/*
 *    Copyright (C) 2008
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mediathek.gui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import mediathek.update.CheckUpdate;
import mediathek.Funktionen;
import mediathek.daten.Daten;
import mediathek.Konstanten;
import mediathek.beobachter.BeobWeb;
import mediathek.gui.dialoge.DialogPgruppen;
import mediathek.gui.menue.DialogEinstellungen;
import mediathek.gui.menue.DialogExportImportDatei;
import mediathek.gui.menue.DialogInfo;
import mediathek.gui.menue.DialogSenderLaden;
import mediathek.io.starter.StartEvent;
import mediathek.io.starter.StartListener;

public final class GuiMediathek extends javax.swing.JFrame {

    private Daten daten;
    public GuiFilme guiFilme;
    private GuiDebug guiDebug;
    public GuiAbo guiAbo;
    public GuiPodder guiPodder;
    // Check that we are on Mac OS X.  This is crucial to loading and using the OSXAdapter class.
    public static boolean MAC_OS_X = (System.getProperty("os.name").toLowerCase().startsWith("mac os x"));
    private boolean debug = false;
    private JTabbedPane jTabbedPane = new JTabbedPane();
    private DialogSenderLaden dialogSenderLaden = null;

    public GuiMediathek(String[] ar) {
        String pfad = "";
        /////////////
//        daten.fehler.systemMeldung(System.getProperty("user.dir"));
//        System.out.println(this.getClass().getName());
        boolean max = false;
        boolean alles = false;
        initComponents();
        if (ar != null) {
            if (ar.length > 0) {
                if (!ar[0].startsWith("-")) {
                    if (!ar[0].endsWith(File.separator)) {
                        ar[0] += File.separator;
                    }
                    pfad = ar[0];
                }
            }
            for (int i = 0; i < ar.length; ++i) {
                if (ar[i].equals("-D")) {
                    debug = true;
                }
                if (ar[i].equals("-M")) {
                    max = true;
                }
                if (ar[i].equals("-alles")) {
                    alles = true;
                }
            }
        }
        jPanelExtra.setLayout(new BorderLayout());
        setStatusPanel(false);
        jProgressBar1.setForeground(new java.awt.Color(102, 153, 255));
        daten = new Daten(pfad, debug, this, false /*noGui*/);
        daten.allesLaden = alles;
        titelSetzen();
        Funktionen.setLook(daten, this);
        initTabs();
        init();
        setSize(max);
        if (this.debug && daten.dialogFehler != null) {
            daten.dialogFehler.setVisible(true);
        }
        // Set up our application to respond to the Mac OS X application menu
        registerForMacOSXEvents();
        new Thread(new CheckUpdate(daten)).start();
    }

    //===================================
    // public
    //===================================
    public void setSize(boolean max) {
        //
        this.pack();
        if (max || Boolean.parseBoolean(daten.system[Konstanten.SYSTEM_START_MAX_NR])) {
            this.setExtendedState(Frame.MAXIMIZED_BOTH);
        } else {
            int x = 0;
            int y = 0;
            try {
                x = Integer.parseInt(daten.system[Konstanten.SYSTEM_GROESSE_X_NR]);
                y = Integer.parseInt(daten.system[Konstanten.SYSTEM_GROESSE_Y_NR]);
            } catch (Exception ex) {
                x = 0;
                y = 0;
            }
            if (x > 0 && y > 0) {
                this.setSize(new Dimension(x, y));
            }
        }
    }

    public void setTabs() {
        jTabbedPane.removeAll();
        jPanelExtra.removeAll();
        if (!daten.system[Konstanten.SYSTEM_ABO_NR].equals(Boolean.toString(true))
                && !daten.system[Konstanten.SYSTEM_PODCAST_NR].equals(Boolean.toString(true))
                && !debug) {
            //nur Tab Filme ist ein, keine TabPane
            jPanelExtra.add(guiFilme, BorderLayout.CENTER);
        } else {
            jPanelExtra.add(jTabbedPane, BorderLayout.CENTER);
            // Filme
            jTabbedPane.addTab("Filme", guiFilme);
            //Abo
            if (daten.system[Konstanten.SYSTEM_ABO_NR].equals(Boolean.toString(true))) {
                jTabbedPane.addTab("Abonnements", guiAbo);
            }
            //Podcast
            if (Boolean.parseBoolean(daten.system[Konstanten.SYSTEM_PODCAST_NR])) {
                jTabbedPane.addTab("Podcasts", guiPodder);
            }
            if (debug) {
                jTabbedPane.addTab("Debug", guiDebug);
            }
        }
        this.pack();
    }

    //===================================
    // private
    //===================================
    private void titelSetzen() {
        if (daten.debug) {
            this.setTitle(
                    Konstanten.Programmname + " " + Konstanten.VERSION + "  ** DEBUG **  " + "     [ " + daten.getBasisVerzeichnis() + " ]     Seiten: " + daten.filmeLaden.getSeitenZaehlerLauf());
        } else {
            this.setTitle(Konstanten.Programmname + " " + Konstanten.VERSION);
        }
    }

    private void init() {
        initMenue();
        daten.starterClass.addListener(new BeobachterStart());
        jButtonStop.addActionListener(new AlleAbbrechen());
        jButtonStopNachFilm.addActionListener(new AlleAbbrechenNachFilm());
        jCheckBoxAboEinschalten.setSelected(Boolean.parseBoolean(daten.system[Konstanten.SYSTEM_ABO_NR]));
        jMenuItemAboEinrichten.setEnabled(Boolean.parseBoolean(daten.system[Konstanten.SYSTEM_ABO_NR]));
        jCheckBoxPodcastEinschalten.setSelected(Boolean.parseBoolean(daten.system[Konstanten.SYSTEM_PODCAST_NR]));
        jMenuItemPodcastEinrichten.setEnabled(Boolean.parseBoolean(daten.system[Konstanten.SYSTEM_PODCAST_NR]));
        addWindowListener(new java.awt.event.WindowAdapter() {

            @Override
            public void windowClosing(java.awt.event.WindowEvent evt) {
                beenden();
            }
        });
    }

    private void initMenue() {
        // Filme
        dialogSenderLaden = new DialogSenderLaden(this, false, daten);
        jMenuItemSender.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                dialogSenderLaden.setVisible(true);
            }
        });
        jMenuItemImportDatei.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                new DialogExportImportDatei(null, true, daten).setVisible(true);
            }
        });
        jMenuItemHistory.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                daten.history.loschen();
                guiFilme.neuLaden();
            }
        });
        jMenuItemLoeschen.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                daten.filmeLaden.alleFilmeLoeschen();
                guiFilme.neuLaden();
            }
        });
        jMenuItemBeenden.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                beenden();
                undThschuess();
            }
        });
        jMenuItemBeendenOhneSpeichern.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                int ret = -1;
                ret = JOptionPane.showConfirmDialog(null, "Beenden ohne zu Speichern?", "Beenden", JOptionPane.YES_NO_OPTION);
                if (ret == JOptionPane.OK_OPTION) {
                    undThschuess();
                }
            }
        });

        //Einstellungen
        jMenuItemEinstellungen.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                new DialogEinstellungen(null, true, daten).setVisible(true);
            }
        });
        jCheckBoxMenuItemPlayer.addActionListener(new BeobPlayer());
        jMenuItemButtonEinrichten.addActionListener(new BeobPgruppen());
        //pod
        jCheckBoxPodcastEinschalten.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                daten.system[Konstanten.SYSTEM_PODCAST_NR] = Boolean.toString(jCheckBoxPodcastEinschalten.isSelected());
                jMenuItemPodcastEinrichten.setEnabled(Boolean.parseBoolean(daten.system[Konstanten.SYSTEM_PODCAST_NR]));
                daten.setGeaendert();
                daten.guiMediathek.setTabs();
            }
        });
        jMenuItemPodcastEinrichten.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                guiPodder.basisziel();
            }
        });
        //Abo
        jCheckBoxAboEinschalten.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                daten.system[Konstanten.SYSTEM_ABO_NR] = Boolean.toString(jCheckBoxAboEinschalten.isSelected());
                jMenuItemAboEinrichten.setEnabled(Boolean.parseBoolean(daten.system[Konstanten.SYSTEM_ABO_NR]));
                daten.setGeaendert();
                daten.guiMediathek.setTabs();
            }
        });
        jMenuItemAboEinrichten.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                guiAbo.einstellungen();
            }
        });

        //Infos
        jMenuItemInfos.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                new DialogInfo(null, false, daten).setVisible(true);
            }
        });
        jMenuItemAnleitung.addActionListener(new BeobWeb());
        jMenuItemFehler.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                if (daten.dialogFehler != null) {
                    daten.dialogFehler.setVisible(true);
                }
            }
        });
    }

    private void initTabs() {
        guiFilme = new GuiFilme(daten);
        guiAbo = new GuiAbo(daten);
        guiPodder = new GuiPodder(daten);
        guiDebug = new GuiDebug(daten);
        setTabs();
    }

    private void setProgressBar(StartEvent ev) {
        titelSetzen();
        if (ev.nixTun()) {
            setStatusPanel(false);
            jLabelDownload.setText("Filme:");
            jProgressBar1.setMaximum(0);
            jProgressBar1.setMinimum(0);
            jProgressBar1.setValue(0);
            jProgressBar1.setStringPainted(false);
        } else {
            setStatusPanel(true);
            jLabelDownload.setText("Filme " + " (" + ev.getMax() + "):");
            jProgressBar1.setMaximum(ev.getMax());
            jProgressBar1.setMinimum(0);
            jProgressBar1.setValue(ev.getProgress());
            jProgressBar1.setStringPainted(true);
        }
        if (ev.getDown() == 0) {
            jTextFieldDownloads.setText(String.valueOf(""));
            jTextFieldDownloads.setBackground(javax.swing.UIManager.getDefaults().getColor("TextField.inactiveBackground"));
        } else {
            jTextFieldDownloads.setText(String.valueOf(" " + ev.getDown() + " "));
            jTextFieldDownloads.setBackground(Konstanten.DOWNLOAD_FARBE_RUN);
        }
        statusPanel.repaint();
    }

    private void setStatusPanel(boolean bool) {
        for (int i = 0; i < statusPanel.getComponentCount(); ++i) {
            statusPanel.getComponent(i).setVisible(bool);
        }

    }

    private void beenden() {
        daten.allesAbbrechen();
        String x = String.valueOf(this.getSize().width);
        String y = String.valueOf(this.getSize().height);
        if (!x.equals(daten.system[Konstanten.SYSTEM_GROESSE_X_NR])
                || !y.equals(daten.system[Konstanten.SYSTEM_GROESSE_Y_NR])) {
            daten.system[Konstanten.SYSTEM_GROESSE_X_NR] = x;
            daten.system[Konstanten.SYSTEM_GROESSE_Y_NR] = y;
            daten.setGeaendertOhnePanel();
        }
        if (daten.isGeaendert()) {
            daten.speichern();
        }

    }

    private void undThschuess() {
        daten.speichern();
        this.dispose();
        System.exit(0);
    }

    private void alleDownloadsAbbrechen() {
        daten.allesAbbrechen();
    }

    private void alleDownloadsAbbrechenNachFilm() {
        daten.allesAbbrechenNachFilm();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        statusPanel = new javax.swing.JPanel();
        jProgressBar1 = new javax.swing.JProgressBar();
        jLabel2 = new javax.swing.JLabel();
        jTextFieldDownloads = new javax.swing.JTextField();
        jLabelDownload = new javax.swing.JLabel();
        jButtonStop = new javax.swing.JButton();
        jButtonStopNachFilm = new javax.swing.JButton();
        jPanelExtra = new javax.swing.JPanel();
        jMenuBar1 = new javax.swing.JMenuBar();
        jMenu1 = new javax.swing.JMenu();
        jMenuItemSender = new javax.swing.JMenuItem();
        jMenuItemImportDatei = new javax.swing.JMenuItem();
        jSeparator1 = new javax.swing.JPopupMenu.Separator();
        jMenuItemLoeschen = new javax.swing.JMenuItem();
        jMenuItemHistory = new javax.swing.JMenuItem();
        jSeparator2 = new javax.swing.JPopupMenu.Separator();
        jMenuItemBeenden = new javax.swing.JMenuItem();
        jMenuItemBeendenOhneSpeichern = new javax.swing.JMenuItem();
        jMenu2 = new javax.swing.JMenu();
        jMenuItemEinstellungen = new javax.swing.JMenuItem();
        jMenu5 = new javax.swing.JMenu();
        jCheckBoxMenuItemPlayer = new javax.swing.JCheckBoxMenuItem();
        jMenuItemButtonEinrichten = new javax.swing.JMenuItem();
        jMenuAboEinrichten = new javax.swing.JMenu();
        jCheckBoxAboEinschalten = new javax.swing.JCheckBoxMenuItem();
        jMenuItemAboEinrichten = new javax.swing.JMenuItem();
        jMenu6 = new javax.swing.JMenu();
        jCheckBoxPodcastEinschalten = new javax.swing.JCheckBoxMenuItem();
        jMenuItemPodcastEinrichten = new javax.swing.JMenuItem();
        jMenu3 = new javax.swing.JMenu();
        jMenuItemInfos = new javax.swing.JMenuItem();
        jMenuItemFehler = new javax.swing.JMenuItem();
        jMenuItemAnleitung = new javax.swing.JMenuItem();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);

        statusPanel.setBorder(new javax.swing.border.SoftBevelBorder(javax.swing.border.BevelBorder.RAISED));

        jLabel2.setText("laufende Filme:");

        jTextFieldDownloads.setEditable(false);
        jTextFieldDownloads.setHorizontalAlignment(javax.swing.JTextField.CENTER);

        jLabelDownload.setText("Filme:");

        jButtonStop.setIcon(new javax.swing.ImageIcon(getClass().getResource("/mediathek/res/process-stop.png"))); // NOI18N
        jButtonStop.setText("alle stoppen");
        jButtonStop.setToolTipText("Downloads sofort abbrechen");

        jButtonStopNachFilm.setIcon(new javax.swing.ImageIcon(getClass().getResource("/mediathek/res/emblem-unreadable.png"))); // NOI18N
        jButtonStopNachFilm.setText("wartende stoppen");
        jButtonStopNachFilm.setToolTipText("Downloads nach dem Film abbrechen");

        javax.swing.GroupLayout statusPanelLayout = new javax.swing.GroupLayout(statusPanel);
        statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(
            statusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, statusPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabelDownload)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jProgressBar1, javax.swing.GroupLayout.DEFAULT_SIZE, 410, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jButtonStop)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jButtonStopNachFilm)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel2)
                .addGap(6, 6, 6)
                .addComponent(jTextFieldDownloads, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
        statusPanelLayout.setVerticalGroup(
            statusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(statusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                .addComponent(jLabelDownload)
                .addComponent(jProgressBar1, javax.swing.GroupLayout.PREFERRED_SIZE, 23, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addComponent(jButtonStop)
                .addComponent(jLabel2)
                .addComponent(jTextFieldDownloads, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addComponent(jButtonStopNachFilm))
        );

        statusPanelLayout.linkSize(javax.swing.SwingConstants.VERTICAL, new java.awt.Component[] {jButtonStop, jButtonStopNachFilm, jProgressBar1, jTextFieldDownloads});

        jPanelExtra.setBorder(javax.swing.BorderFactory.createEtchedBorder());

        javax.swing.GroupLayout jPanelExtraLayout = new javax.swing.GroupLayout(jPanelExtra);
        jPanelExtra.setLayout(jPanelExtraLayout);
        jPanelExtraLayout.setHorizontalGroup(
            jPanelExtraLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 950, Short.MAX_VALUE)
        );
        jPanelExtraLayout.setVerticalGroup(
            jPanelExtraLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 321, Short.MAX_VALUE)
        );

        jMenu1.setText("Filme");

        jMenuItemSender.setText("Filmliste direkt beim Sender laden");
        jMenu1.add(jMenuItemSender);

        jMenuItemImportDatei.setText("Import/Export Filme aus Datei");
        jMenuItemImportDatei.setToolTipText("Die ganze Filmliste aus einer Datei importieren");
        jMenu1.add(jMenuItemImportDatei);
        jMenu1.add(jSeparator1);

        jMenuItemLoeschen.setText("Filmliste löschen");
        jMenu1.add(jMenuItemLoeschen);

        jMenuItemHistory.setText("History löschen");
        jMenu1.add(jMenuItemHistory);
        jMenu1.add(jSeparator2);

        jMenuItemBeenden.setText("Beenden");
        jMenu1.add(jMenuItemBeenden);

        jMenuItemBeendenOhneSpeichern.setText("Beenden ohne Speichern");
        jMenu1.add(jMenuItemBeendenOhneSpeichern);

        jMenuBar1.add(jMenu1);

        jMenu2.setText("Einstellungen");

        jMenuItemEinstellungen.setText("Allgemeine Einstellungen");
        jMenuItemEinstellungen.setToolTipText("allgemeine Programmeinstellungen");
        jMenu2.add(jMenuItemEinstellungen);

        jMenu5.setText("Button");

        jCheckBoxMenuItemPlayer.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_F6, 0));
        jCheckBoxMenuItemPlayer.setSelected(true);
        jCheckBoxMenuItemPlayer.setText("Playerbutton ausblenden");
        jCheckBoxMenuItemPlayer.setToolTipText("Rahmen mit den Playerbutton ein- und ausblenden");
        jMenu5.add(jCheckBoxMenuItemPlayer);

        jMenuItemButtonEinrichten.setText("Einrichten");
        jMenu5.add(jMenuItemButtonEinrichten);

        jMenu2.add(jMenu5);

        jMenuAboEinrichten.setText("Abos");

        jCheckBoxAboEinschalten.setSelected(true);
        jCheckBoxAboEinschalten.setText("Einschalten");
        jMenuAboEinrichten.add(jCheckBoxAboEinschalten);

        jMenuItemAboEinrichten.setText("Einrichten");
        jMenuAboEinrichten.add(jMenuItemAboEinrichten);

        jMenu2.add(jMenuAboEinrichten);

        jMenu6.setText("Podcasts");

        jCheckBoxPodcastEinschalten.setSelected(true);
        jCheckBoxPodcastEinschalten.setText("Einschalten");
        jMenu6.add(jCheckBoxPodcastEinschalten);

        jMenuItemPodcastEinrichten.setText("Einrichten");
        jMenu6.add(jMenuItemPodcastEinrichten);

        jMenu2.add(jMenu6);

        jMenuBar1.add(jMenu2);

        jMenu3.setText("Infos");

        jMenuItemInfos.setText("Infos Anzeigen");
        jMenuItemInfos.setToolTipText("Programminfos, Speicherpfade");
        jMenu3.add(jMenuItemInfos);

        jMenuItemFehler.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_F8, 0));
        jMenuItemFehler.setText("Systemmeldungen anzeigen");
        jMenu3.add(jMenuItemFehler);

        jMenuItemAnleitung.setText("Anleitung im Web öffnen");
        jMenu3.add(jMenuItemAnleitung);

        jMenuBar1.add(jMenu3);

        setJMenuBar(jMenuBar1);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(statusPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            .addGroup(layout.createSequentialGroup()
                .addGap(12, 12, 12)
                .addComponent(jPanelExtra, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanelExtra, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(statusPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents
    /**
     * @param args the command line arguments
     */
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonStop;
    private javax.swing.JButton jButtonStopNachFilm;
    private javax.swing.JCheckBoxMenuItem jCheckBoxAboEinschalten;
    private javax.swing.JCheckBoxMenuItem jCheckBoxMenuItemPlayer;
    private javax.swing.JCheckBoxMenuItem jCheckBoxPodcastEinschalten;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabelDownload;
    private javax.swing.JMenu jMenu1;
    private javax.swing.JMenu jMenu2;
    private javax.swing.JMenu jMenu3;
    private javax.swing.JMenu jMenu5;
    private javax.swing.JMenu jMenu6;
    private javax.swing.JMenu jMenuAboEinrichten;
    private javax.swing.JMenuBar jMenuBar1;
    private javax.swing.JMenuItem jMenuItemAboEinrichten;
    private javax.swing.JMenuItem jMenuItemAnleitung;
    private javax.swing.JMenuItem jMenuItemBeenden;
    private javax.swing.JMenuItem jMenuItemBeendenOhneSpeichern;
    private javax.swing.JMenuItem jMenuItemButtonEinrichten;
    private javax.swing.JMenuItem jMenuItemEinstellungen;
    private javax.swing.JMenuItem jMenuItemFehler;
    private javax.swing.JMenuItem jMenuItemHistory;
    private javax.swing.JMenuItem jMenuItemImportDatei;
    private javax.swing.JMenuItem jMenuItemInfos;
    private javax.swing.JMenuItem jMenuItemLoeschen;
    private javax.swing.JMenuItem jMenuItemPodcastEinrichten;
    private javax.swing.JMenuItem jMenuItemSender;
    private javax.swing.JPanel jPanelExtra;
    private javax.swing.JProgressBar jProgressBar1;
    private javax.swing.JPopupMenu.Separator jSeparator1;
    private javax.swing.JPopupMenu.Separator jSeparator2;
    private javax.swing.JTextField jTextFieldDownloads;
    private javax.swing.JPanel statusPanel;
    // End of variables declaration//GEN-END:variables

    private class AlleAbbrechen implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent arg0) {
            alleDownloadsAbbrechen();
        }
    }

    private class AlleAbbrechenNachFilm implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent arg0) {
            alleDownloadsAbbrechenNachFilm();
        }
    }

    private class BeobPlayer implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent arg0) {
            jCheckBoxMenuItemPlayer.setText(jCheckBoxMenuItemPlayer.isSelected() ? "Playerbutton ausblenden" : "Playerbutton einblenden");
            guiFilme.setExtraVisible(jCheckBoxMenuItemPlayer.isSelected());
        }
    }

    private class BeobPgruppen implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            new DialogPgruppen(null, true, daten, true, guiFilme).setVisible(true);
            guiFilme.setExtraVisible(jCheckBoxMenuItemPlayer.isSelected());
        }
    }

    private class BeobachterStart implements StartListener {

        @Override
        public void starter(StartEvent ev) {
            setProgressBar(ev);
        }
    }

    // Generic registration with the Mac OS X application menu
    // Checks the platform, then attempts to register with the Apple EAWT
    // See OSXAdapter.java to see how this is done without directly referencing any Apple APIs
    public void registerForMacOSXEvents() {
        if (MAC_OS_X) {
            try {
                // Generate and register the OSXAdapter, passing it a hash of all the methods we wish to
                // use as delegates for various com.apple.eawt.ApplicationListener methods
                OSXAdapter.setQuitHandler(this, getClass().getDeclaredMethod("quitForMac", (Class[]) null));
            } catch (Exception e) {
                System.err.println("Error while loading the OSXAdapter:");
                e.printStackTrace();
            }
        }
    }

    public void quitForMac() {
        beenden();
    }
}
