/*
 * DialogSerienbrief.java
 *
 * Created on 17. August 2007, 20:50
 *
 *    Emma, Vereinsverwaltungsprorgamm
 *    Copyright (C) 2007
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

package mediathek.gui.menue;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JScrollPane;
import mediathek.Konstanten;
import mediathek.daten.Daten;

public class DialogMeldungen extends javax.swing.JDialog {

    private Daten daten;
    private StringBuffer textFehler = new StringBuffer();
    private StringBuffer textMeldung = new StringBuffer();
    private StringBuffer textPlayer = new StringBuffer();
    private final int MAX_LAENGE_1 = 30000;
    private final int MAX_LAENGE_2 = 20000;

    public DialogMeldungen(Daten ddaten) {
        super((Frame) null, false);
        daten = ddaten;
        initComponents();
        this.setTitle("Fehlerdialog");
        jButtonOk.addActionListener(new BeobOk());
        jButtonLoeschen.addActionListener(new BeobLoeschen());
        jCheckBox1.addActionListener(new BeobCheck());
        jCheckBox1.setSelected(Boolean.parseBoolean(daten.system[Konstanten.SYSTEM_FEHLER_ANZEIGEN_NR]));
    }

    public void addTextFehler(String titel, String[] texte) {
        cut(textFehler);
        this.setTitle(titel);
        for (int i = 0; i < texte.length; ++i) {
            textFehler.append(texte[i] + "\n");
        }
        textFehler.append("********************************************************************************" + "\n\n");
        jTextAreaFehler.setText(textFehler.toString());
        setTextArea(jScrollPaneFehler);
    }

    public void addTextMeldung(String titel, String[] texte) {
        cut(textMeldung);
        for (int i = 0; i < texte.length; ++i) {
            textMeldung.append(titel + ":  " + texte[i] + "\n");
        }
        jTextAreaMeldung.setText(textMeldung.toString());
        setTextArea(jScrollPaneMeldung);
    }

    public void addTextMeldung(String text) {
        cut(textMeldung);
        textMeldung.append(text + "\n");
        jTextAreaMeldung.setText(textMeldung.toString());
        setTextArea(jScrollPaneMeldung);
    }

    public void addTextPlayer(String titel, String texte) {
        cut(textPlayer);
        textPlayer.append(titel + ":  " + texte + "\n");
        jTextAreaPlayer.setText(textPlayer.toString());
        setTextArea(jScrollPanePlayer);
    }

    private void setTextArea(JScrollPane pane) {
        //pane.setViewportView(area);
        pane.getVerticalScrollBar().setValue(pane.getVerticalScrollBar().getMaximum());
        pane.repaint();
    }

    private void clear() {
        textFehler.setLength(0);
        jTextAreaFehler.setText(textFehler.toString());
        textMeldung.setLength(0);
        jTextAreaMeldung.setText(textMeldung.toString());
        textPlayer.setLength(0);
        jTextAreaPlayer.setText(textPlayer.toString());
    }

    private void cut(StringBuffer buffer) {
        if (buffer.length() > MAX_LAENGE_1) {
            buffer.delete(0, MAX_LAENGE_2);
        }
    }

    private void beenden() {
        this.dispose();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        jButtonOk = new javax.swing.JButton();
        jCheckBox1 = new javax.swing.JCheckBox();
        jButtonLoeschen = new javax.swing.JButton();
        jTabbedPane1 = new javax.swing.JTabbedPane();
        jPanelFehler = new javax.swing.JPanel();
        jScrollPaneFehler = new javax.swing.JScrollPane();
        jTextAreaFehler = new javax.swing.JTextArea();
        jPanelMeldungen = new javax.swing.JPanel();
        jScrollPaneMeldung = new javax.swing.JScrollPane();
        jTextAreaMeldung = new javax.swing.JTextArea();
        jPanelProgramme = new javax.swing.JPanel();
        jScrollPanePlayer = new javax.swing.JScrollPane();
        jTextAreaPlayer = new javax.swing.JTextArea();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);

        jPanel1.setBorder(new javax.swing.border.SoftBevelBorder(javax.swing.border.BevelBorder.RAISED));

        jButtonOk.setText("Ok");

        jCheckBox1.setText("Fehlermeldungen weiter anzeigen");

        jButtonLoeschen.setText("löschen");

        jScrollPaneFehler.setViewportView(jTextAreaFehler);

        javax.swing.GroupLayout jPanelFehlerLayout = new javax.swing.GroupLayout(jPanelFehler);
        jPanelFehler.setLayout(jPanelFehlerLayout);
        jPanelFehlerLayout.setHorizontalGroup(
            jPanelFehlerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jScrollPaneFehler, javax.swing.GroupLayout.DEFAULT_SIZE, 614, Short.MAX_VALUE)
        );
        jPanelFehlerLayout.setVerticalGroup(
            jPanelFehlerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jScrollPaneFehler, javax.swing.GroupLayout.DEFAULT_SIZE, 331, Short.MAX_VALUE)
        );

        jTabbedPane1.addTab("Fehler", jPanelFehler);

        jScrollPaneMeldung.setViewportView(jTextAreaMeldung);

        javax.swing.GroupLayout jPanelMeldungenLayout = new javax.swing.GroupLayout(jPanelMeldungen);
        jPanelMeldungen.setLayout(jPanelMeldungenLayout);
        jPanelMeldungenLayout.setHorizontalGroup(
            jPanelMeldungenLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jScrollPaneMeldung, javax.swing.GroupLayout.DEFAULT_SIZE, 614, Short.MAX_VALUE)
        );
        jPanelMeldungenLayout.setVerticalGroup(
            jPanelMeldungenLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jScrollPaneMeldung, javax.swing.GroupLayout.DEFAULT_SIZE, 331, Short.MAX_VALUE)
        );

        jTabbedPane1.addTab("Meldungen", jPanelMeldungen);

        jScrollPanePlayer.setViewportView(jTextAreaPlayer);

        javax.swing.GroupLayout jPanelProgrammeLayout = new javax.swing.GroupLayout(jPanelProgramme);
        jPanelProgramme.setLayout(jPanelProgrammeLayout);
        jPanelProgrammeLayout.setHorizontalGroup(
            jPanelProgrammeLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jScrollPanePlayer, javax.swing.GroupLayout.DEFAULT_SIZE, 614, Short.MAX_VALUE)
        );
        jPanelProgrammeLayout.setVerticalGroup(
            jPanelProgrammeLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jScrollPanePlayer, javax.swing.GroupLayout.DEFAULT_SIZE, 331, Short.MAX_VALUE)
        );

        jTabbedPane1.addTab("Videoplayer", jPanelProgramme);

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jTabbedPane1, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 619, Short.MAX_VALUE)
                    .addComponent(jCheckBox1, javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(jButtonLoeschen)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonOk, javax.swing.GroupLayout.DEFAULT_SIZE, 524, Short.MAX_VALUE)))
                .addContainerGap())
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jTabbedPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 358, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jCheckBox1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButtonLoeschen)
                    .addComponent(jButtonOk))
                .addGap(12, 12, 12))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonLoeschen;
    private javax.swing.JButton jButtonOk;
    private javax.swing.JCheckBox jCheckBox1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanelFehler;
    private javax.swing.JPanel jPanelMeldungen;
    private javax.swing.JPanel jPanelProgramme;
    private javax.swing.JScrollPane jScrollPaneFehler;
    private javax.swing.JScrollPane jScrollPaneMeldung;
    private javax.swing.JScrollPane jScrollPanePlayer;
    private javax.swing.JTabbedPane jTabbedPane1;
    private javax.swing.JTextArea jTextAreaFehler;
    private javax.swing.JTextArea jTextAreaMeldung;
    private javax.swing.JTextArea jTextAreaPlayer;
    // End of variables declaration//GEN-END:variables

    private class BeobOk implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent arg0) {
            beenden();
        }

    }

    private class BeobLoeschen implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent arg0) {
            clear();
        }

    }

    private class BeobCheck implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent arg0) {
            daten.system[Konstanten.SYSTEM_FEHLER_ANZEIGEN_NR] = Boolean.toString(jCheckBox1.isSelected());
            daten.setGeaendertSofort();
        }

    }

}
