/*
 *    Copyright (C) 2008
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mediathek.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.util.LinkedList;
import mediathek.Funktionen;
import mediathek.daten.Daten;
import mediathek.Konstanten;

public class Log {

    private Daten daten;
    private final String TRENNER = "  |###|  ";

    public Log(Daten d) {
        daten = d;
    }
    private LinkedList<String> logListeZdf = null;
    private LinkedList<String> logListePod = null;

    public synchronized boolean zeileSchreiben(String titel, String url, String logdatei) {
        boolean ret = false;
        daten.log.clearLogList(logdatei);
        File f = new File(daten.getBasisVerzeichnis(true) + logdatei);
        if (f != null) {
            OutputStreamWriter writer = null;
            try {
                writer = new OutputStreamWriter(new FileOutputStream(f, true));
                titel = titel.replace("\n", "");
                titel = titel.replace("|", "");
                titel = titel.replace(TRENNER, "");
                titel = Funktionen.getHeute_dd_MM_yyyy() + TRENNER + titel;
                writer.write(titel + TRENNER + url + "\n");
                writer.close();
                ret = true;
            } catch (Exception ex) {
                daten.fehler.fehlerMeldung(ex, "Log.zeileSchreiben");
            } finally {
                try {
                    writer.close();
                } catch (Exception ex) {
                    daten.fehler.fehlerMeldung(ex, "Log.zeileSchreiben");
                }
            }
        }
        return ret;
    }

    public void clearLogList(String logdatei) {
        if (logdatei.equals(Konstanten.LOG_DATEI_ZDF)) {
            if (logListeZdf != null) {
                logListeZdf.clear();
                logListeZdf = null;
            }
        } else {
            if (logListePod != null) {
                logListePod.clear();
                logListePod = null;
            }
        }
    }

    public boolean zeilePruefen(String zeile, String logdatei) {
        //wenn zeile gefunden, dann true zurück
        boolean ret = false;
        LineNumberReader in = null;
        LinkedList<String> liste;
        String url = "";
        int a1 = 0;
        if (logdatei.equals(Konstanten.LOG_DATEI_ZDF)) {
            liste = logListeZdf;
        } else {
            liste = logListePod;
        }
        if (liste == null) {
            liste = new LinkedList<String>();
            try {
                in = new LineNumberReader(new InputStreamReader(new FileInputStream(new File(daten.getBasisVerzeichnis(false) + logdatei))));
                String z;
                while ((z = in.readLine()) != null) {
                    try {
                        if (z.contains(TRENNER)) {
                            //neues Logfile-Format
                            a1 = z.lastIndexOf(TRENNER);
                            a1 += TRENNER.length();
                            url = z.substring(a1);
                            liste.add(url);
                        } else {
                            liste.add(z);
                        }
                    } catch (Exception ex) {
                        daten.fehler.fehlerMeldung(ex, "Log.zeilePruefen: " + zeile + "  Logdatei:  " + logdatei);
                    }
                }
                in.close();
            } catch (Exception ex) {
            } finally {
                try {
                    in.close();
                } catch (Exception ex) {
                }
            }
            if (logdatei.equals(Konstanten.LOG_DATEI_ZDF)) {
                logListeZdf = liste;
            } else {
                logListePod = liste;
            }
        }
        if (liste.contains(zeile)) {
            ret = true;
        }
        return ret;
    }
}
