/*
 *    Copyright (C) 2008
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mediathek.io.starter;

import mediathek.Funktionen;
import mediathek.TModel;
import mediathek.Konstanten;
import mediathek.HinweisKeineAuswahl;
import mediathek.Hinweis;
import mediathek.daten.Daten;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.concurrent.ExecutionException;
import javax.swing.JOptionPane;
import javax.swing.event.EventListenerList;
import mediathek.daten.DatenAbo;
import mediathek.filme.DatenFilm;
import mediathek.daten.DatenPgruppe;
import mediathek.daten.DatenProg;
import mediathek.gui.dialoge.DialogZiel;

public class StarterClass {

    private Daten daten;
    private boolean allesStop = false;
    private ListeStarts listeStarts;
    private Starten starten = null;
    private EventListenerList listeners = new EventListenerList();

    //===================================
    // Public
    //===================================
    /**
     * Neue Starter-Klasse inizialisieren
     * @param d 
     */
    public StarterClass(Daten d) {
        daten = d;
        listeners = new EventListenerList();
        listeStarts = new ListeStarts(daten);
        starten = new Starten();
        Thread startenThread = new Thread(starten);
        startenThread.setDaemon(true);
        startenThread.start();
    }

    /**
     *
     * @param url
     * @param open
     * @param ersterFilm
     * @param listener
     * @return
     */
    public Starts urlStarten(String url, int open, DatenFilm ersterFilm) {
        // url mit dem Programm mit der Nr. starten (Button oder Doppelklick)
        // Quelle ist immer ein vom User gestarteter Film, also Quelle_Button!!
        Starts ret = null;
        String befehlsString = "";
        String zielDateiname = "";
        String zielPfad = "";
        String zielPfadDatei = "";
        int art = 0;
        if (!url.equals("")) {
            DatenPgruppe gruppe = daten.listePgruppeButton.get(open);
            //mit der Url das passende Programm finden
            DatenProg prog = gruppe.getProgUrl(url);
            if (prog != null) {
                befehlsString = prog.getBegehl();
                if (url.startsWith("-r") || url.startsWith("rtmp") || url.startsWith("--host")) {
                    if (!(befehlsString.contains("flvstreamer") || befehlsString.contains("rtmpdump"))) {
                        new Hinweis(daten).hinweisFlash();
                    }
                }
                zielDateiname = gruppe.getZielDateiname();
                zielPfad = gruppe.getZielPfad();
                art = gruppe.checkDownloadDirekt(daten, url);
                if (!zielDateiname.equals("")) {
                    if (zielDateiname.contains("%p")) {
                        /////////////////////////////////////////////////
                        DialogZiel dialog = new DialogZiel(null, true, daten, gruppe.getZielPfad(),
                                Funktionen.getDateiName(daten, ersterFilm.arr[Konstanten.FILM_URL_NR]));
                        dialog.setVisible(true);
                        if (!dialog.ok) {
                            return null;
                        }
                        zielDateiname = zielDateiname.replace("%p", dialog.zielDateiname);
                        zielPfad = dialog.zielPfad;
                    } else if (zielDateiname.contains("%n")) {
                        String str;
                        str = JOptionPane.showInputDialog("Dateiname eingeben", Funktionen.getDateiName(daten, ersterFilm.arr[Konstanten.FILM_URL_NR]));
                        if (str == null) {
                            return null;
                        }
                        zielDateiname = zielDateiname.replace("%n", Funktionen.replaceLeerDateiname(str, true /*keinPfadTrenner*/));
                    }
                    if (zielPfad.equals("")) {
                        JOptionPane.showMessageDialog(null, "Zielpfad angeben!",
                                "Pfad leer", JOptionPane.INFORMATION_MESSAGE);
                    }
                    zielPfadDatei = ersterFilm.dateiNamenBauen(zielPfad, zielDateiname);
                    befehlsString = Funktionen.getBefhelsString(befehlsString, zielPfadDatei, url, ersterFilm);
                } else {
                    //nur abspielen
                    befehlsString = befehlsString.replace("%f", url);
                }
                Starts s = new Starts(Starts.QUELLE_BUTTON, ersterFilm, art, befehlsString, Boolean.parseBoolean(prog.arr[Konstanten.PROGRAMM_RESTART_NR]));
//                s.autoDelete = true;
                ret = s;
                //Aufruf von den Button PanelFilme, entweder ART_ZDF oder ART_ZDF_DIREKT
                if (s.art == Starts.ART_PROGRAMM) {
                    StartenProgramm zdfStarten = new StartenProgramm(s);
                    new Thread(zdfStarten).start();
                    addListe(s);
                } else {
                    StartenDonwnload podderStart = new StartenDonwnload(s);
                    new Thread(podderStart).start();
                    addListe(s);
                }
            }
        } else {
            new HinweisKeineAuswahl();
        }
        return ret;
    }

    public LinkedList<Starts> getStarts(int quelle) {
        LinkedList<Starts> ret = new LinkedList<Starts>();
        Iterator<Starts> it = listeStarts.getIt();
        while (it.hasNext()) {
            Starts s = it.next();
            if (s.quelle == quelle || quelle == Starts.QUELLE_ALLE) {
                ret.add(s);
            }
        }
        return ret;
    }

    /**
     * Liefert ein TModell mit den aktuelen Starts
     * @return
     */
    public TModel getStarterModell() {
        return listeStarts.getModel();

    }

    /**
     * Listener hinzufügen, informiert über Änderungen am Status der Downloads
     * @param listener 
     */
    public void addListener(StartListener listener) {
        listeners.add(StartListener.class, listener);
    }

//    public void addListener(RuntimeListener listener) {
//        listeners.add(RuntimeListener.class, listener);
//    }
    /**Eine liste mit Downloads wird an die Auftragsliste angehängt
     * @param starts 
     */
    public void addListe(LinkedList<Starts> starts) {
        //add: Liste neues Element an die Liste anhängen
        allesStop = false;
        if (starts != null) {
            ListIterator<Starts> it = starts.listIterator(0);
            while (it.hasNext()) {
                Starts s = it.next();
                addListe(s);
            }
        }
    }

    public synchronized void addListe(Starts starts) {
        //add: Liste neues Element an die Liste anhängen
        allesStop = false;
        if (starts != null) {
            if (!listeStarts.contain(starts)) {
                listeStarts.add(starts);
            }
        }
        notifyStartEvent();
    }

    /**Gibt den Status eines Downloads zurück*
     * ziel: ist die Zieldatei
     * @param url
     * @return Status des Downloads
     */
    public int getState(String url) {
        int ret = 0;
        Iterator<Starts> it = listeStarts.getIt();
        while (it.hasNext()) {
            Starts s = it.next();
            if (s.film.arr[Konstanten.FILM_URL_NR].equals(url)) {
                ret = s.status;
                break;
            }
        }
        return ret;
    }

    public Starts getStart(String url) {
        Starts ret = null;
        Iterator<Starts> it = listeStarts.getIt();
        while (it.hasNext()) {
            Starts s = it.next();
            if (s.film.arr[Konstanten.FILM_URL_NR].equals(url)) {
                ret = s;
                break;
            }
        }
        return ret;
    }

    public void delStart(String url) {
        listeStarts.delStart(url);
    }

    /**Alle erledigten Downloads werden aus der Liste gelöscht,
     * StartEvent wird ausgelöst
     * @param startArt 
     */
    public synchronized void aufraeumen(int quelle) {
        listeStarts.aufraeumen(quelle);
        notifyStartEvent();
    }

    /**Alle Downloads werden abgebrochen*/
    public void abbrechen() {
        allesStop = true;
        listeStarts.delAlle();
        ///////////////////
        notifyStartEvent();
    }

    /**Alle Downloads die nicht laufen, löschen: Es wird nach dem laufenden Download abgebrochen*/
    public void abbrechenNachFilm() {
        listeStarts.delRest();
        notifyStartEvent();
    }

    public void filmLoeschen(String url) {
        listeStarts.delStart(url);
        notifyStartEvent();
    }

    //===================================
    // Private
    //===================================
    private void notifyStartEvent() {
        StartEvent event;
        int down = 0;
        int progr = 0;
        int max = listeStarts.getmax();
        Iterator<Starts> it = listeStarts.getIt();
        while (it.hasNext()) {
            Starts s = it.next();
            if (s.status == Starts.STATUS_RUN) {
                ++down;
            }
            if (s.status >= Starts.STATUS_FERTIG) {
                ++progr;
            }
        }
        event = new StartEvent(this, down, progr, max, allesStop);
        for (StartListener l : listeners.getListeners(StartListener.class)) {
            l.starter(event);
        }
    }

    private Starts getListe() {
        /*get: erstes passendes Element der Liste zurückgeben oder null*/
        /*versuchen dass bei mehreren laufenden Downloads ein anderer Sender gesucht wird*/
        Iterator<Starts> it;
        Starts ret = null;
        if (allesStop) {
            //////////listeStarts.clear();
            //nur die laufenden Starts löschen, damit die Anzeige der Podcasts stimmt
            it = listeStarts.getIt();
            while (it.hasNext()) {
                Starts s = it.next();
                if (s.status < Starts.STATUS_FERTIG) {
                    it.remove();
                }
            }
        } else {
            if (listeStarts.size() >= 0
                    && listeStarts.getDown() < Integer.parseInt(daten.system[Konstanten.SYSTEM_MAX_DOWNLOAD_NR])) {
                Starts s = naechsterStart();
                if (s != null) {
                    if (s.status == Starts.STATUS_INIT) {
                        ret = s;
                    }
                }
            }
        }
        return ret;
    }

    private void buttonStartsPutzen() {
        // Starts durch Button die fertig sind, löschen
        boolean habsGetan = false;
        Iterator<Starts> it = listeStarts.getIt();
        while (it.hasNext()) {
            Starts s = it.next();
            if (s.quelle == Starts.QUELLE_BUTTON) {
                if (s.status != Starts.STATUS_RUN) {
                    // dann ist er fertig oder abgebrochen
                    it.remove();
                    habsGetan = true;
                }
            }
        }
        if (habsGetan) {
            notifyStartEvent(); // und dann bescheid geben
        }
    }

    private Starts naechsterStart() {
        Starts s = null;
        Iterator<Starts> it = listeStarts.getIt();
        //erster Versuch, Start mit einem anderen Sender
        while (it.hasNext()) {
            s = it.next();
            if (s.status == Starts.STATUS_INIT) {
                if (!maxSenderLaufen(s, 1)) {
                    return s;
                }
            }
        }
        if (Konstanten.MAX_SENDER_FILME_LADEN == 1) {
            //dann wars dass
            return null;
        }
        //zweiter Versuch, Start mit einem passenden Sender
        it = listeStarts.getIt();
        while (it.hasNext()) {
            s = it.next();
            if (s.status == Starts.STATUS_INIT) {
                if (!maxSenderLaufen(s, Konstanten.MAX_SENDER_FILME_LADEN)) {
                    return s;
                }
            }
        }
        return null;
    }

    private boolean maxSenderLaufen(Starts s, int max) {
        //true wenn bereits die maxAnzahl pro Sender läuft
        int counter = 0;
        Starts start = null;
        String sender = s.film.arr[Konstanten.FILM_SENDER_NR];
        Iterator<Starts> it = listeStarts.getIt();
        while (it.hasNext()) {
            start = it.next();
            if (start.status == Starts.STATUS_RUN
                    && start.film.arr[Konstanten.FILM_SENDER_NR].equalsIgnoreCase(sender)) {
                counter++;
                if (counter >= max) {
                    return true;
                }
            }
        }
        return false;
    }

    private class Starten implements Runnable {
        /*Ewige Schleife die die Downloads startet*/

        Starts starts;

        @Override
        public synchronized void run() {
            while (true) {
                try {
//                    notifyStartEvent();
                    while ((starts = getListe()) != null) {
//                        notifyStartEvent();
                        switch (starts.art) {
                            case Starts.ART_PROGRAMM:
                                StartenProgramm zdfStarten = new StartenProgramm(starts);
                                new Thread(zdfStarten).start();
                                //alle 10 Sekunden einen Download starten
                                this.wait(10000);
                                break;
                            case Starts.ART_DOWNLOAD:
                                StartenDonwnload podderStart = new StartenDonwnload(starts);
                                new Thread(podderStart).start();
                                //alle 2 Sekunden einen Download starten
                                this.wait(2000);
                                break;
                            default:
                                daten.fehler.fehlerMeldung("Fehler!", "StarterClass.Starten - Switch-default");
                                break;
                        }
                    }
                    buttonStartsPutzen(); // Button Starts aus der Liste löschen
                    this.wait(3000);
                } catch (Exception ex) {
                    daten.fehler.fehlerMeldung(ex, "StarterClass.Starten.run");
                }
            } //while(true)
        }
    }

    private class StartenProgramm implements Runnable {

        Starts starts;
        RuntimeExec runtimeExec;

        public StartenProgramm(Starts s) {
            starts = s;
            starts.status = Starts.STATUS_RUN;
            notifyStartEvent();
            try {
                new File(starts.film.arr[Konstanten.FILM_ZIEL_PFAD_NR]).mkdirs();
            } catch (Exception ex) {
                daten.fehler.fehlerMeldung(ex, "StarterClass.ZdfStarten.run");
            }
        }

        @Override
        public synchronized void run() {
            int k = 0;
            long filesize = -1;
            boolean restart = false;
            boolean startOk = false;
            try {
                if (starten()) {
                    restart = true; //los gehts
                }
                while (restart && !starts.stoppen) {
                    startOk = false;
                    restart = false;
                    while (!allesStop && !starts.stoppen) {
                        //hier läuft der Download bis zum Abbruch oder Ende
                        try {
                            k = starts.process.exitValue();
                            //fertig und tschüss
                            break;
                        } catch (Exception ex) {
                            try {
                                this.wait(2000);
                            } catch (InterruptedException e) {
                            }
                        }
                    }
                    if (allesStop || starts.stoppen) {
                        if (starts.process != null) {
                            starts.process.destroy();
                            //Anzeige ändern - fertig
                            if (starts.quelle == Starts.QUELLE_BUTTON) {
                                //für die direkten Starts mit dem Button
                                starts.status = Starts.STATUS_FERTIG;
                            } else {
                                starts.status = Starts.STATUS_INIT;
                            }
                            new File(starts.film.arr[Konstanten.FILM_ZIEL_PFAD_DATEI_NR]).delete();
                        }
                    } else { //Exitvalue vom Prozess prüfen und ggf. neu Starten
                        if (k != 0) {
                            if (starts.restart) {
                                //Download wieder starten
                                if (filesize == -1) {
                                    //erstes Mal
                                    File file = new File(starts.film.arr[Konstanten.FILM_ZIEL_PFAD_DATEI_NR]);
                                    if (file.exists()) {
                                        filesize = file.length();
                                        startOk = true;
                                    } else if (starts.startcounter < Starts.STARTCOUNTER_MAX) {
                                        //counter prüfen und bei einem Maxwert abbrechen, sonst endlos
                                        startOk = true;
                                    }
                                } else {
                                    //jetzt muss das File wachsen, sonst kein Restart
                                    File file = new File(starts.film.arr[Konstanten.FILM_ZIEL_PFAD_DATEI_NR]);
                                    if (file.exists()) {
                                        if (file.length() > filesize) {
                                            //nur weitermachen wenn die Datei tasächlich wächst
                                            startOk = true;
                                            filesize = file.length();
                                        }
                                    }
                                }
                                if (startOk && starten()) {
                                    restart = true;
                                } else {
                                    //Anzeige ändern - fertig mit Fehler
                                    starts.status = Starts.STATUS_ERR;
                                }
                            } else {
                                //Anzeige ändern - fertig
                                starts.status = Starts.STATUS_ERR;
                            }
                        } else if (starts.quelle == Starts.QUELLE_BUTTON) {
                            //für die direkten Starts mit dem Button
                            starts.status = Starts.STATUS_FERTIG;
                        } else if (pruefen(starts)) {
                            //Anzeige ändern - fertig
                            starts.status = Starts.STATUS_FERTIG;
                        } else {
                            //Anzeige ändern - fehler
                            starts.status = Starts.STATUS_ERR;
                            //bei einem Fehler Film umbenennen
////////                        new File(starts.film.arr[Konstanten.FILM_ZIEL_PFAD_DATEI_NR]).renameTo(new File(
////////                            starts.film.arr[Konstanten.FILM_ZIEL_PFAD_DATEI_NR] + ".mit-Fehler"));
                        }
                    }
                }
            } catch (Exception ex) {
                daten.fehler.fehlerMeldung(ex, "StarterClass.StartenProgramm");
            }
            notifyStartEvent();
        }

        private boolean starten() {
            boolean ret = true;
            runtimeExec = new RuntimeExec(daten, starts);
            starts.process = runtimeExec.exec();
            if (starts.process == null) {
                //Anzeige ändern - fehler - Programm wurde nicht gestartet
                starts.status = Starts.STATUS_ERR;
                ret = false;
            } else {
                starts.startcounter++;
            }
            return ret;
        }
    }

    private class StartenDonwnload implements Runnable {

        Starts starts;

        public StartenDonwnload(Starts s) {
            starts = s;
            starts.status = Starts.STATUS_RUN;
            notifyStartEvent();
        }

        @Override
        public void run() {
            InputStream input = null;
            OutputStream destStream = null;
            try {
                int len;
                new File(starts.film.arr[Konstanten.FILM_ZIEL_PFAD_NR]).mkdirs();
                URL feedUrl = new URL(starts.film.arr[Konstanten.FILM_URL_NR]);
                input = feedUrl.openStream();
                byte[] buffer = new byte[1024];
                destStream = new FileOutputStream(starts.film.arr[Konstanten.FILM_ZIEL_PFAD_DATEI_NR]);
                while ((len = input.read(buffer)) != -1) {
                    destStream.write(buffer, 0, len);
                    if (allesStop || starts.stoppen) {
                        break;
                    }
                }
                input.close();
                destStream.close();
            } catch (Exception e) {
                daten.fehler.fehlerMeldung(e, "StarterClass.StartenDonwnload-1");
            }
            try {
                if (allesStop || starts.stoppen) {
                    new File(starts.film.arr[Konstanten.FILM_ZIEL_PFAD_DATEI_NR]).delete();
                } else {
                    if (starts.quelle == Starts.QUELLE_BUTTON) {
                        // direkter Start mit dem Button
                        starts.status = Starts.STATUS_FERTIG;
                    } else if (pruefen(starts)) {
                        //Anzeige ändern - fertig
                        starts.status = Starts.STATUS_FERTIG;
                    } else {
                        //Anzeige ändern - bei Fehler fehlt der Eintrag
                        starts.status = Starts.STATUS_ERR;
                    }
                }
            } catch (Exception e) {
                daten.fehler.fehlerMeldung(e, "StarterClass.StartenDonwnload-2");
            }
            notifyStartEvent();
        }
    }

    private boolean einmalErledigen(DatenFilm film) {
        // wenn EinmalAbo dann auf erledigt setzten und true zurück
        boolean ret = false;
        String name = "";
        try {
            DatenAbo abo = daten.listeAbo.getEinmalAbo(film.arr[Konstanten.FILM_URL_NR]);
            if (abo != null) {
                ret = true;
                name = abo.arr[Konstanten.ABO_NAME_NR];
                //daten.listeAbo.aboLoeschen(abo); zum restart
                abo.arr[Konstanten.ABO_EINMAL_ERLEDIGT_NR] = Boolean.toString(true);
                daten.fehler.systemMeldung("StarterClass.einmalErledigen Abo: " + name);
            }
        } catch (Exception ex) {
            daten.fehler.fehlerMeldung(ex, "StarterClass.einmalErledigen Abo: " + name);
        }
        return ret;
    }

    private boolean pruefen(Starts starts) {
        boolean ret = false;
        String logfile = "";
        if (starts.quelle == Starts.QUELLE_ABO) {
            logfile = Konstanten.LOG_DATEI_ZDF;
        } else if (starts.quelle == Starts.QUELLE_PODCAST) {
            logfile = Konstanten.LOG_DATEI_POD;
        }
        File file = new File(starts.film.arr[Konstanten.FILM_ZIEL_PFAD_DATEI_NR]);
        if (!file.exists()) {
            daten.fehler.fehlerMeldung("Fehler!", "Download fehlgeschlagen: " + starts.film.arr[Konstanten.FILM_ZIEL_PFAD_DATEI_NR]);
        } else if (file.length() < Konstanten.MIN_DATEI_GROESSE_KB * 1024) {
            daten.fehler.fehlerMeldung("Fehler!", "Download fehlgeschlagen: " + starts.film.arr[Konstanten.FILM_ZIEL_PFAD_DATEI_NR]);
        } else {
            if (!einmalErledigen(starts.film)) {
                daten.log.zeileSchreiben(starts.film.arr[Konstanten.FILM_TITEL_NR], starts.film.arr[Konstanten.FILM_URL_NR], logfile);
            }
            ret = true;
        }
        return ret;
    }
}
