#!/usr/bin/perl
# This script tests latest file version from given svn url
# Use: check_version.pl [ -d /path/to/download/ ] < svn-urls
# Option -d is optional, ask for download of new files.


use Getopt::Std;
%options=();
getopts("d:",\%options);

my @outdated;

while (<>) {
  next if (/^\s*#/);
  /^(.+)\s-\s(\d+)/;
  my ($url,$revision) = ($1,$2);
  my $latest_revision = `LC_ALL=C svn info $url | grep "Last Changed Rev" | sed -e "s#Last Changed Rev: ##"`;
  push @outdated,$url and 
  print "$url:\noutdated: local revison = $revision, newest = $latest_revision\n" and
  download_latest($url,$revision) and
  next unless ($latest_revision <= $revision);
  print "$url:\nup to date at revision $revision\n\n" unless ($latest_revision > $revision);
}


sub download_latest {
my ($url,$old) = @_;
  if ($options{d}) {
    print "Downloading file\n";
    $url =~ /^http:\/\/.*\/(.*)$/;
    my $file = $1;
    system("mkdir -p $options{d}/latest > /dev/null 2>&1");
    system("mkdir -p $options{d}/packaged > /dev/null 2>&1");
    system("mkdir -p $options{d}/diff > /dev/null 2>&1");
    system("cd $options{d}/latest && svn export $url > /dev/null 2>&1");
    system("cd $options{d}/packaged && svn export -r$old $url > /dev/null 2>&1");
    system("find -name $file | while read i; do diff -urN \$i $options{d}/packaged/$file >| $options{d}/diff/$file.debdiff; done 2>/dev/null"); 
  }  
}

