<?php

/**
 * Messages file for the InputBox extension
 *
 * @file
 * @ingroup Extensions
 */

/**
 * Get all extension messages
 *
 * @return array
 */
$messages = array();

$messages['en'] = array(
	'inputbox-desc'           => 'Allow inclusion of predefined HTML forms',
	'inputbox-error-no-type'  => 'You have not specified the type of input box to create.',
	'inputbox-error-bad-type' => 'Input box type "$1" not recognised.
Please specify "create", "comment", "search", "search2" or "fulltext".',
	'tryexact'                => 'Try exact match',
	'searchfulltext'          => 'Search full text',
	'createarticle'           => 'Create page',
	'inputbox-ns-main'        => 'Main',
);

/** Message documentation (Message documentation)
 * @author Lloffiwr
 * @author Meno25
 * @author SPQRobin
 * @author Siebrand
 * @author The Evil IP address
 */
$messages['qqq'] = array(
	'inputbox-desc' => '{{desc}}',
	'inputbox-error-bad-type' => '{{doc-important|"create", "comment", "search", "search2" and "fulltext" should not be translated.}}',
	'tryexact' => 'Part of the "Inputbox" extension. This message is the text of the button to search the page you typed in the inputbox. If the page with the exact name exists, you will go directly to that page.',
	'searchfulltext' => 'Part of the "Inputbox" extension. This message is the text of the button to search the page you typed in the inputbox. This button always goes to the search page, even if the page with the exact name exists.',
	'createarticle' => 'Part of the "Inputbox" extension. This message is the text of the button to create the page you typed in the inputbox.',
	'inputbox-ns-main' => 'Probably refers to the main namespace.',
);

/** Niuean (ko e vagahau Niuē)
 * @author Jose77
 */
$messages['niu'] = array(
	'createarticle' => 'Talaga tohi tala',
);

/** Afrikaans (Afrikaans)
 * @author Naudefj
 */
$messages['af'] = array(
	'inputbox-desc' => 'Laat die insluiting van vooraf gedefinieerde HTML-vorms moontlik',
	'inputbox-error-no-type' => 'U het nie die tipe invoerveld gespesifiseer nie.',
	'inputbox-error-bad-type' => 'Tipe invoerveld is "$1" nie herken nie.
Gebruik "create", "comment", "search", "search2" of "fulltext".',
	'tryexact' => 'Soek presiese ooreenkoms',
	'searchfulltext' => 'Deursoek volledige teks',
	'createarticle' => 'Skep bladsy',
	'inputbox-ns-main' => 'Hoofnaamruimte',
);

/** Amharic (አማርኛ)
 * @author Codex Sinaiticus
 */
$messages['am'] = array(
	'createarticle' => 'አዲስ አርዕስት ለመፍጠር',
);

/** Aragonese (Aragonés)
 * @author Juanpabl
 */
$messages['an'] = array(
	'inputbox-desc' => 'Premite a enclusión de formularios HTML predefinitos',
	'inputbox-error-no-type' => 'No ha endicato o tipo de caixa de dentrada que cal creyar.',
	'inputbox-error-bad-type' => 'No se reconoixe o tipo de caixa de dentrada "$1".
Por favor, especifique "create", "comment", "search" u "fulltext".',
	'tryexact' => 'Mirar títol esauto',
	'searchfulltext' => 'Mirar por testo completo',
	'createarticle' => 'Creyar pachina',
	'inputbox-ns-main' => 'Prencipal',
);

/** Arabic (العربية)
 * @author Meno25
 * @author زكريا
 */
$messages['ar'] = array(
	'inputbox-desc' => 'يسمح بتضمين أشكال HTML معرفة مسبقا.',
	'inputbox-error-no-type' => 'لم تقم بتحديد نوع صندوق الإدخال للإنشاء.',
	'inputbox-error-bad-type' => 'نوع صندوق الإدخال "$1" لم يتم التعرف عليه.
من فضلك حدد "create"، "comment"، "search"، "search2" أو "fulltext".',
	'tryexact' => 'ابحث عن عنوان مطابق',
	'searchfulltext' => 'ابحث في النص الكامل',
	'createarticle' => 'إنشاء صفحة',
	'inputbox-ns-main' => 'رئيسي',
);

/** Aramaic (ܐܪܡܝܐ)
 * @author Basharh
 */
$messages['arc'] = array(
	'createarticle' => 'ܒܪܝ ܦܐܬܐ',
);

/** Egyptian Spoken Arabic (مصرى)
 * @author Ghaly
 * @author Ramsis II
 */
$messages['arz'] = array(
	'inputbox-desc' => 'يسمح بتضمين أشكال اتش تى ام ال معرفه من الاول',
	'inputbox-error-no-type' => 'إنت ما حددتش نوع صندوق الإدخال للإنشاء',
	'inputbox-error-bad-type' => 'ما اتعرفناش على نوع صندوق الإدخال "$1"  .
لو سمحت  تحدد "create"، "comment"، "search" أو "search2".',
	'tryexact' => 'دور على عنوان مطابق',
	'searchfulltext' => 'دور فى النص كله',
	'createarticle' => 'إنشاء صفحة',
);

/** Assamese (অসমীয়া)
 * @author Chaipau
 * @author Rajuonline
 */
$messages['as'] = array(
	'tryexact' => 'কেবল দিয়া শব্দহে বিচাৰিব',
	'searchfulltext' => 'সম্পূৰ্ণ পাঠ্য বিচাৰিব',
	'createarticle' => 'পৃষ্ঠা বনাওক',
);

/** Asturian (Asturianu)
 * @author Esbardu
 * @author Xuacu
 */
$messages['ast'] = array(
	'inputbox-desc' => 'Permite la inclusión de formularios HTML predefiníos',
	'inputbox-error-no-type' => "Nun especificasti la triba de caxellu d'entrada pa crear.",
	'inputbox-error-bad-type' => "Triba de caxa d'entrada \$1 non reconocida.
Por favor conseña la opción ''create'', ''comment'', ''search'', ''search2'' o \"fulltext\".",
	'tryexact' => 'Intentar concueyar exautamente',
	'searchfulltext' => 'Buscar testu completu',
	'createarticle' => 'Crear páxina',
	'inputbox-ns-main' => 'Principal',
);

/** Azerbaijani (Azərbaycanca)
 * @author Cekli829
 * @author Vugar 1981
 */
$messages['az'] = array(
	'searchfulltext' => 'Yaxşı mətni axtar',
	'createarticle' => 'Məqalə yarat',
	'inputbox-ns-main' => 'Əsas',
);

/** Bashkir (Башҡортса)
 * @author Assele
 */
$messages['ba'] = array(
	'inputbox-desc' => 'Алдан билдәләнгән HTML формаларҙы индереү мөмкинлеген бирә',
	'inputbox-error-no-type' => 'Һеҙ булдырыла торған юлдың төрөн күрһәтмәгеҙ.',
	'inputbox-error-bad-type' => '"$1" юл төрө танылмаған.
Зинһар, "create", "comment", "search", "search2" йәки "fulltext" төрөнөң береһен күрһәтегеҙ.',
	'tryexact' => 'Теүәл тура килеү буйынса эҙләү',
	'searchfulltext' => 'Тулы текст буйынса эҙләү',
	'createarticle' => 'Яңы бит яһарға',
);

/** Southern Balochi (بلوچی مکرانی)
 * @author Mostafadaneshvar
 */
$messages['bcc'] = array(
	'inputbox-desc' => 'اجازه داتن په هور بیگ فرم های HTML چه پیش تعریف بوتگین',
	'inputbox-error-no-type' => 'شما نوع جعبه ورودی په شرکتن مشخص نه کتت',
	'inputbox-error-bad-type' => 'نوع جعبه ورودی "$1"  جاه آرگ نه بیت.
لطفا مشخص کنیت  "شرکتن", "نظر", "گردگ" یا "گردگ2".',
	'tryexact' => 'تطبیق کامل آزمایش کن',
	'searchfulltext' => 'متن کامل گرد',
	'createarticle' => 'شرکتن صفحه',
);

/** Belarusian (Беларуская) */
$messages['be'] = array(
	'createarticle' => 'Пачаць артыкул',
);

/** Belarusian (Taraškievica orthography) (‪Беларуская (тарашкевіца)‬)
 * @author EugeneZelenko
 * @author Jim-by
 * @author Red Winged Duck
 * @author Wizardist
 */
$messages['be-tarask'] = array(
	'inputbox-desc' => 'Дазваляе ўключаць раней вызначаныя HTML-формы',
	'inputbox-error-no-type' => 'Вы не пазначылі тып ствараемага поля ўводу.',
	'inputbox-error-bad-type' => 'Невядомы тып поля ўводу «$1».
Калі ласка, выбірайце толькі з дазволеных тыпаў: «create», «comment», «search», «search2» ці «fulltext».',
	'tryexact' => 'Паспрабаваць дакладны пошук',
	'searchfulltext' => 'Шукаць увесь тэкст',
	'createarticle' => 'Стварыць старонку',
	'inputbox-ns-main' => 'Асноўная',
);

/** Bulgarian (Български)
 * @author DCLXVI
 * @author Spiritia
 */
$messages['bg'] = array(
	'inputbox-desc' => 'Позволява вмъкването на HTML формуляри.',
	'inputbox-error-no-type' => 'Не се посочили типа на кутията за вход, която да бъде създадена.',
	'inputbox-error-bad-type' => 'Неразпознат тип „$1“ на кутията за вход.
Необходимо е да се посочи „create“, „comment“, „search“, „search2“ или „fulltext“.',
	'tryexact' => 'Пълно и точно съвпадение',
	'searchfulltext' => 'Претърсване на целия текст',
	'createarticle' => 'Създаване',
);

/** Bislama (Bislama)
 * @author Ushanka
 */
$messages['bi'] = array(
	'createarticle' => 'Mekem atikel',
);

/** Bengali (বাংলা)
 * @author Bellayet
 * @author Zaheen
 */
$messages['bn'] = array(
	'inputbox-desc' => 'পূর্বসংজ্ঞায়িত এইচটিএমএল ফর্মের অন্তর্ভুক্তি অনুমোদন করুন',
	'inputbox-error-no-type' => 'আপনি ইনপুট বক্স তৈরির জন্য ইনপুট বক্সের ধরণ নির্ধারণ করেননি।',
	'inputbox-error-bad-type' => '"$1" ধরনেরর ইনপুট বাক্স সনাক্ত করা যায় নাই।
অনুগ্রহ করে "create", "comment", "search" অথবা "search2" নির্ধারণ করুন।',
	'tryexact' => 'ঠিক এই নামের নিবন্ধে যান',
	'searchfulltext' => 'সব বিষয়বস্তুতে খুঁজুন',
	'createarticle' => 'নিবন্ধ শুরু করো',
	'inputbox-ns-main' => 'প্রধান',
);

/** Bakhtiari (بختياري)
 * @author Behdarvandyani
 */
$messages['bqi'] = array(
	'inputbox-desc' => 'اجازه استفاده زه فرم‌های HTML قبلا تعریف وابیده را اده',
	'inputbox-error-no-type' => 'نوع جعبه ورودی  درست شونده را معلوم نکردین.',
	'inputbox-error-bad-type' => 'نوع "$1" سی جعبه ورودی شناخته نه. لطفاً یکی زه موارد 
"create", "comment", "search" or "search2" را مشخص کنین.',
	'tryexact' => 'تطبیق مورد به مورد را آزمایش کن',
	'searchfulltext' => 'جستجوی همه متن',
	'createarticle' => 'درست کردن صفحه',
);

/** Breton (Brezhoneg)
 * @author Fulup
 */
$messages['br'] = array(
	'inputbox-desc' => 'Aotren a ra degas furmskridoù HTML raktermenet.',
	'inputbox-error-no-type' => "N'eo ket bet spisaet ganeoc'h ar seurt boest enmont da vezañ krouet",
	'inputbox-error-bad-type' => 'N\'eo ket anavaezet ar seurt boest enmont "$1".
Spisait "create", "comment", "search" pe "search2" pe "fulltext".',
	'tryexact' => 'Klask ma klotfe rik',
	'searchfulltext' => 'Klask en destenn a-bezh',
	'createarticle' => 'Krouiñ ar pennad',
	'inputbox-ns-main' => 'Pennañ',
);

/** Bosnian (Bosanski)
 * @author CERminator
 */
$messages['bs'] = array(
	'inputbox-desc' => 'Omogućuje uključivanje prethodno napravljenih HTML obrazaca',
	'inputbox-error-no-type' => 'Niste odredili tip kutije za unos koju pravite.',
	'inputbox-error-bad-type' => 'Tip kutije unosa "$1" nije prepoznat.
Molimo odredite "create", "comment", "search", "search2" ili "fulltext".',
	'tryexact' => 'Isprobaj naći tačan upit',
	'searchfulltext' => 'Pretraži cijeli tekst',
	'createarticle' => 'Napravi stranicu',
);

/** Catalan (Català)
 * @author Aleator
 * @author Gemmaa
 * @author Paucabot
 * @author SMP
 * @author Toniher
 */
$messages['ca'] = array(
	'inputbox-desc' => 'Permet la inclusió de formularis HTML predefinits',
	'inputbox-error-no-type' => "No heu especificat el tipus de quadre d'entrada per crear.",
	'inputbox-error-bad-type' => "El tipus de quadre d'entrada «$1» no està reconegut.

Especifiqueu-hi «create», «comment», «search», «search2» o «fulltext».",
	'tryexact' => 'Prova una coincidència exacta',
	'searchfulltext' => 'Cerca un text sencer',
	'createarticle' => 'Crea una pàgina',
	'inputbox-ns-main' => 'Principal',
);

/** Min Dong Chinese (Mìng-dĕ̤ng-ngṳ̄) */
$messages['cdo'] = array(
	'createarticle' => 'Kŭi hiĕk',
);

/** Chechen (Нохчийн)
 * @author Sasan700
 */
$messages['ce'] = array(
	'tryexact' => 'Леррина лахар',
);

/** Corsican (Corsu) */
$messages['co'] = array(
	'searchfulltext' => 'Ricerca testu cumplettu',
	'createarticle' => "Creà l'articulu",
);

/** Crimean Turkish (Latin script) (‪Qırımtatarca (Latin)‬)
 * @author Don Alessandro
 */
$messages['crh-latn'] = array(
	'createarticle' => 'Saifeni yarat',
);

/** Crimean Turkish (Cyrillic script) (‪Къырымтатарджа (Кирилл)‬)
 * @author Don Alessandro
 */
$messages['crh-cyrl'] = array(
	'createarticle' => 'Саифени ярат',
);

/** Czech (Česky)
 * @author Danny B.
 * @author Li-sung
 * @author Mormegil
 */
$messages['cs'] = array(
	'inputbox-desc' => 'Umožňuje vkládat určité HTML formuláře.',
	'inputbox-error-no-type' => 'Není určen typ formulářového pole k vytvoření.',
	'inputbox-error-bad-type' => 'Nerozpoznaný typ pole „$1“.
Uveďte jednu z možností: „create“, „comment“, „search“, „search2“ nebo „fulltext“.',
	'tryexact' => 'Vyzkoušet přesné hledání',
	'searchfulltext' => 'Plnotextové hledání',
	'createarticle' => 'Vytvořit článek',
	'inputbox-ns-main' => 'Hlavní',
);

/** Church Slavic (Словѣ́ньскъ / ⰔⰎⰑⰂⰡⰐⰠⰔⰍⰟ)
 * @author ОйЛ
 */
$messages['cu'] = array(
	'createarticle' => 'cъꙁижди члѣнъ',
);

/** Chuvash (Чӑвашла) */
$messages['cv'] = array(
	'createarticle' => 'Çĕнĕ статья çыр',
);

/** Welsh (Cymraeg)
 * @author Lloffiwr
 */
$messages['cy'] = array(
	'inputbox-desc' => "Yn caniatau creu blychau mewnbynnu sy'n cynnwys ffurflenni HTML wedi eu gosod yn barod i'w defnyddio",
	'inputbox-error-no-type' => "Nid ydych wedi pennu'r math o flwch mewnbynnu yr ydych am ei greu.",
	'inputbox-error-bad-type' => 'Nid yw\'r gair "$1" ar y math o flwch mewnbynnu yn ddealladwy gan y meddalwedd.
Dewiswch rhwng "create", "comment", "search" a "search2" neu "fulltext".',
	'tryexact' => 'Chwilio am yr union gymal',
	'searchfulltext' => "Chwilio'r testun cyfan",
	'createarticle' => "Creu'r dudalen",
	'inputbox-ns-main' => 'Prif',
);

/** Danish (Dansk)
 * @author Byrial
 * @author Peter Alberti
 */
$messages['da'] = array(
	'inputbox-desc' => 'Muliggør inkludering af forhåndsdefinerede HTML-formularer',
	'inputbox-error-no-type' => 'Du har ikke angivet type i inputboksen som skal laves.',
	'inputbox-error-bad-type' => 'Inputboks-type "$1" kendes ikke.
Vælg venligst "create", "comment", "search", "search2" eller "fulltext".',
	'tryexact' => 'Gå til siden',
	'searchfulltext' => 'Søg efter teksten',
	'createarticle' => 'Opret side',
	'inputbox-ns-main' => 'Hoved',
);

/** German (Deutsch)
 * @author Kghbln
 * @author LWChris
 * @author Metalhead64
 * @author Raimond Spekking
 * @author Umherirrender
 */
$messages['de'] = array(
	'inputbox-desc' => 'Ergänzt das Tag <code>&lt;inputbox&gt;</code> zum Einbinden vordefinierter HTML-Eingabefelder',
	'inputbox-error-no-type' => 'Es wurde kein Eingabefeldtyp angegeben.',
	'inputbox-error-bad-type' => 'Der Eingabefeldtyp „$1“ ist unbekannt.
Bitte „create“, „comment“, „search“, „search2“ oder „fulltext“ angeben.',
	'tryexact' => 'Exakte Suche durchführen',
	'searchfulltext' => 'Volltextsuche',
	'createarticle' => 'Seite erstellen',
	'inputbox-ns-main' => 'Seiten',
);

/** Zazaki (Zazaki)
 * @author Aspar
 * @author Xoser
 */
$messages['diq'] = array(
	'inputbox-desc' => 'desturê daxilbiyayişê formê HTMLyi dano, no HTML gani ver ra şınasi bıbo.',
	'inputbox-error-no-type' => 'Qutiya daxilbiyayişi ya ke vıraziyena gani tipê aye diyari bıbo',
	'inputbox-error-bad-type' => 'Qutiyê tîp ê "$1"î kebul nikerd.
Ma şima rê "create", "comment", "search", "search2" or "fulltext" spesife bike.',
	'tryexact' => 'tam hemcıt biyayiş tesel bıker/bıcereb',
	'searchfulltext' => 'pêroyê metni bıgêr',
	'createarticle' => 'pel vıraz',
);

/** Lower Sorbian (Dolnoserbski)
 * @author Michawiki
 * @author Pe7er
 */
$messages['dsb'] = array(
	'inputbox-desc' => 'Zapśěgnjenje pśeddefiněrowanych HTML-formularow dowóliś',
	'inputbox-error-no-type' => 'Njejsy pódał typ zapódawańskego póla za napóranje.',
	'inputbox-error-bad-type' => 'Zapódawańske pólo typa "$1" njespóznane.
Pšosym pódaj "create", "comment", "search", "search2" abo "fulltext".',
	'tryexact' => 'Eksaktne pytanje',
	'searchfulltext' => 'Ceły tekst pytaś',
	'createarticle' => 'Bok załožyś',
	'inputbox-ns-main' => 'Boki',
);

/** Divehi (ދިވެހިބަސް)
 * @author Spacebirdy
 */
$messages['dv'] = array(
	'createarticle' => 'މަޒުމޫނެއް ފައްޓަވާ',
);

/** Ewe (Eʋegbe)
 * @author Natsubee
 */
$messages['ee'] = array(
	'searchfulltext' => 'Di nuŋɔŋlɔ bliboa me',
	'createarticle' => 'Dze nuŋɔŋlɔ yeye gɔme',
);

/** Greek (Ελληνικά)
 * @author Dead3y3
 * @author ZaDiak
 */
$messages['el'] = array(
	'inputbox-desc' => 'Επιτρέπει την περίληψη προκαθορισμένων φορμών HTML',
	'inputbox-error-no-type' => 'Δεν έχετε καθορίσει τον τύπο του κουτιού εισόδου προς δημιουργία.',
	'inputbox-error-bad-type' => 'Τύπος κουτιού εισόδου "$1" δεν αναγνωρίστηκε.<br />
Παρακαλώ ορίστε "create", "comment", "search", "search2" ή "fulltext".',
	'tryexact' => 'Δοκιμάστε την επακριβή αντιστοιχία.',
	'searchfulltext' => 'Αναζήτηση με το πλήρες κείμενο',
	'createarticle' => 'Δημιουργία σελίδας',
	'inputbox-ns-main' => 'Κύριος',
);

/** Esperanto (Esperanto)
 * @author Michawiki
 * @author Yekrats
 */
$messages['eo'] = array(
	'inputbox-desc' => 'Permesi enhavon de antaŭdifinitaj HTML-kamparoj',
	'inputbox-error-no-type' => 'Vi ne enigis la specon de enigo-kesto por krei.',
	'inputbox-error-bad-type' => 'Enigo-kesto "$1" ne estas konata.
Bonvolu specifi keston "create", "comment", "seatch", "search2", aŭ "fulltext".',
	'tryexact' => 'Provu ekzaktan trafon',
	'searchfulltext' => 'Serĉi plentekste',
	'createarticle' => 'Krei artikolon',
	'inputbox-ns-main' => 'Ĉefa',
);

/** Spanish (Español)
 * @author Crazymadlover
 * @author Icvav
 * @author MetalBrasil
 * @author Muro de Aguas
 * @author Sanbec
 */
$messages['es'] = array(
	'inputbox-desc' => 'Permite la inclusión de formularios en HTML predefinidos.',
	'inputbox-error-no-type' => 'No has especificado el tipo de formulario que vas a crear.',
	'inputbox-error-bad-type' => 'No se reconoce el tipo de caja de entrada «$1».
Por favor, especifica «create», «comment», «search» «search2» o "fulltext".',
	'tryexact' => 'Buscar título exacto',
	'searchfulltext' => 'Buscar por texto completo',
	'createarticle' => 'Crear artículo',
	'inputbox-ns-main' => 'Principal',
);

/** Estonian (Eesti)
 * @author Avjoska
 * @author Jaan513
 * @author Pikne
 */
$messages['et'] = array(
	'inputbox-desc' => 'Lubab kaasata eelmääratletud HTML-vormid.',
	'inputbox-error-no-type' => 'Sisendkasti tüüp on määramata.',
	'inputbox-error-bad-type' => 'Tundmatu sisendkasti tüüp "$1".
Palun vali tüübiks "create", "comment", "search", "search2" või "fulltext".',
	'tryexact' => 'Proovi täpset vastet',
	'searchfulltext' => 'Otsi täisteksti',
	'createarticle' => 'Alusta lehekülge',
);

/** Basque (Euskara) */
$messages['eu'] = array(
	'tryexact' => 'Izenburu zehatza bilatu',
	'searchfulltext' => 'Testu osoa bilatu',
	'createarticle' => 'Artikulua sortu',
);

/** Extremaduran (Estremeñu) */
$messages['ext'] = array(
	'createarticle' => 'Crial página',
);

/** Persian (فارسی)
 * @author Ebraminio
 * @author Huji
 * @author Mjbmr
 */
$messages['fa'] = array(
	'inputbox-desc' => 'اجازهٔ استفاده از فرم‌های HTML از پیش تعریف شده را می‌دهد',
	'inputbox-error-no-type' => 'نوع جعبهٔ ورودی  ایجادشونده را مشخص نکرده‌اید.',
	'inputbox-error-bad-type' => 'نوع «$1» برای جعبهٔ ورودی شناخته شده نیست.
لطفاً یکی از موارد «create»، «comment»، «search»، «search2» یا «fulltext» را مشخص کنید.',
	'tryexact' => 'مطابقت نظیر به نظیر را بیازما',
	'searchfulltext' => 'جستجوی کل متن',
	'createarticle' => 'ایجاد صفحه',
	'inputbox-ns-main' => 'اصلی',
);

/** Finnish (Suomi)
 * @author Crt
 * @author Nike
 * @author Olli
 */
$messages['fi'] = array(
	'inputbox-desc' => 'Mahdollistaa ennalta määriteltyjen lomakkeiden sisällyttämisen sivuille.',
	'inputbox-error-no-type' => 'Et määritellyt syötekentän tyyppiä.',
	'inputbox-error-bad-type' => 'Syötekentän tyyppi ”$1” ei kelpaa.
Sallittuja arvoja ovat create, comment, search, search2 ja fulltext.',
	'tryexact' => 'Yritä tarkkaa osumaa',
	'searchfulltext' => 'Etsi koko tekstiä',
	'createarticle' => 'Luo sivu',
	'inputbox-ns-main' => '(sivut)',
);

/** Faroese (Føroyskt)
 * @author EileenSanda
 */
$messages['fo'] = array(
	'tryexact' => 'Far til síðu',
	'searchfulltext' => 'Leita eftir hesum teksti',
	'createarticle' => 'Upprætta síðu',
	'inputbox-ns-main' => 'Høvuðs',
);

/** French (Français)
 * @author Crochet.david
 * @author IAlex
 * @author Sherbrooke
 * @author Wyz
 */
$messages['fr'] = array(
	'inputbox-desc' => 'Permet l’inclusion de formulaires HTML prédéfinis.',
	'inputbox-error-no-type' => 'Vous n’avez pas précisé le type de la boîte d’entrée à créer.',
	'inputbox-error-bad-type' => 'Type de boîte entrée « $1 » non reconnue.
Indiquez une option parmis « create », « comment », « search », « searche2 » ou « fulltext ».',
	'tryexact' => 'Essayez la correspondance exacte.',
	'searchfulltext' => 'Recherche en texte intégral',
	'createarticle' => 'Créer une page',
	'inputbox-ns-main' => 'Principal',
);

/** Franco-Provençal (Arpetan)
 * @author ChrisPtDe
 */
$messages['frp'] = array(
	'inputbox-desc' => 'Pèrmèt l’encllusion de formulèros HTML prèdèfenis.',
	'inputbox-error-no-type' => 'Vos éd pas spècefiâ lo tipo de la bouèta d’entrâ a fâre.',
	'inputbox-error-bad-type' => 'Tipo de bouèta d’entrâ « $1 » pas recognu.
Volyéd spècefiar un chouèx permié « create », « comment », « search », « searche2 » ou ben « fulltext ».',
	'tryexact' => 'Èprovâd la corrèspondance justa.',
	'searchfulltext' => 'Rechèrche en tèxto complèt',
	'createarticle' => 'Fâre la pâge',
	'inputbox-ns-main' => 'Principâl',
);

/** Friulian (Furlan)
 * @author Klenje
 */
$messages['fur'] = array(
	'tryexact' => 'Cîr une corispondence esate',
	'searchfulltext' => 'Cîr in dut il test',
	'createarticle' => 'Cree vôs',
);

/** Western Frisian (Frysk)
 * @author Snakesteuben
 */
$messages['fy'] = array(
	'createarticle' => 'Side oanmeitsje',
);

/** Irish (Gaeilge)
 * @author Evertype
 */
$messages['ga'] = array(
	'inputbox-desc' => 'Ceadaigh glactha foirmeacha HTML réamhshainithe',
	'inputbox-error-no-type' => 'Níor shocraigh tú an cineál bosca ionchur a bheadh le cruthú.',
	'inputbox-error-bad-type' => 'Bosca iochur den chineál "$1" gan aithint.
Sonraigh "create", "comment", "search", "search2" nó "fulltext".',
	'tryexact' => 'Déan iarracht ar meaitseáil cruinn',
	'searchfulltext' => 'Cuardaigh sa téacs iomlán',
	'createarticle' => 'Cruthaigh alt',
);

/** Galician (Galego)
 * @author Alma
 * @author Toliño
 */
$messages['gl'] = array(
	'inputbox-desc' => 'Permitir a inclusión de formularios predefinidos de HTML',
	'inputbox-error-no-type' => 'Non especificou o tipo de caixa de entrada que quere crear.',
	'inputbox-error-bad-type' => 'O tipo de caixa de entrada "$1" non foi recoñecido.
Por favor, especifique "create", "comment", "search", "search2" ou "fulltext".',
	'tryexact' => 'Buscar coincidencias exactas',
	'searchfulltext' => 'Buscar o texto completo',
	'createarticle' => 'Crear a páxina',
	'inputbox-ns-main' => 'Principal',
);

/** Ancient Greek (Ἀρχαία ἑλληνικὴ)
 * @author Omnipaedista
 */
$messages['grc'] = array(
	'inputbox-desc' => 'Ἐπιτρέπειν τὴν εἰσαγωγὴν προκαθωρισμένων μορφῶν HTML',
	'inputbox-error-no-type' => 'Οὐχ ὥρισας τὸν τύπον τοῦ ποιηθέντος κυτίου εἰσηγμένων δεδομένων.',
	'inputbox-error-bad-type' => 'Ὁ τύπος τοῦ ποιηθέντος κυτίου εἰσηγμένων δεδομένων "$1" ἀνεγνωρισμένος οὐκ ἔστιν.
Καθόρισον "create", "comment", "search", "search2" ἢ "fulltext".',
	'tryexact' => 'Πείρασον τὴν ἀκριβῆ ἀντιστοιχίαν',
	'searchfulltext' => 'Ζητεῖν ἐν τῷ πλήρει κειμένῳ',
	'createarticle' => 'Δέλτον δημιουργήσειν',
);

/** Swiss German (Alemannisch)
 * @author Als-Chlämens
 * @author Als-Holder
 */
$messages['gsw'] = array(
	'inputbox-desc' => 'Erlaubt d Yybindig vu vordefinierte HTML-Formular',
	'inputbox-error-no-type' => 'Du hesch kei Yygabfäld-Typ aagee.',
	'inputbox-error-bad-type' => 'Yygabfäld-Typ „$1“ nit bekannt.
Bitte „create“, „comment“, „search“, „search2“ oder „fulltext“ aagee.',
	'tryexact' => 'Versuech es mitenere exakte Suech',
	'searchfulltext' => 'De gsamti Teggscht durchsueche',
	'createarticle' => 'Syte aalaie',
	'inputbox-ns-main' => 'Hauptsyte',
);

/** Gujarati (ગુજરાતી)
 * @author Dsvyas
 * @author KartikMistry
 * @author Sushant savla
 */
$messages['gu'] = array(
	'inputbox-desc' => 'પૂર્વવ્યાખ્યાયિત HTML પત્રકોનો સમાવેશ માન્ય',
	'inputbox-error-no-type' => 'તમે બનાવવા માટેના ઈનપુટ બોક્સનો પ્રકાર સ્પષ્ટ કર્યો નથી.',
	'tryexact' => 'આબેહૂબ સરખામણી ધારી પ્રયત્ન કરો',
	'searchfulltext' => 'સંપૂર્ણ લખાણ શોધો',
	'createarticle' => 'નવો લેખ શરૂ કરો',
	'inputbox-ns-main' => 'મુખ્ય',
);

/** Manx (Gaelg)
 * @author MacTire02
 */
$messages['gv'] = array(
	'createarticle' => 'Croo duillag',
);

/** Hakka (Hak-kâ-fa)
 * @author Hakka
 */
$messages['hak'] = array(
	'tryexact' => 'Sòng-chhṳ chîn-khok phit-phi',
	'searchfulltext' => 'Chhiòn vùn-kiám chhìm-cháu',
	'createarticle' => 'Kien-li̍p vùn-chông',
);

/** Hebrew (עברית)
 * @author Amire80
 * @author Rotem Liss
 */
$messages['he'] = array(
	'inputbox-desc' => 'אפשרות להכללת טופסי HTML שהוגדרו מראש',
	'inputbox-error-no-type' => 'לא ציינתם את סוג תיבת הקלט ליצירה.',
	'inputbox-error-bad-type' => 'סוג תיבת הקלט "$1" אינו ידוע.
אנא ציינו "create", "comment", "search", "search2" או "fulltext".',
	'tryexact' => 'לדף בשם זה',
	'searchfulltext' => 'חיפוש בתוכן הדפים',
	'createarticle' => 'יצירת הדף',
	'inputbox-ns-main' => 'ראשי',
);

/** Hindi (हिन्दी)
 * @author Ansumang
 * @author Kaustubh
 */
$messages['hi'] = array(
	'inputbox-desc' => 'पहलेसे लिखे गये HTML फार्म इस्तेमाल करने की अनुमति दें',
	'inputbox-error-no-type' => 'इनपुट बक्सा बनाने के लिये आपने इसका प्रकार बताया नहीं हैं।',
	'inputbox-error-bad-type' => 'इनपुट बक्से का "$1" यह प्रकार उचित नहीं हैं।
कृपया "create", "comment", "search" या फिर "search2" में से एक चुनें।',
	'tryexact' => 'दिये हुए शब्दही खोजें',
	'searchfulltext' => 'पूरा पाठ खोजें',
	'createarticle' => 'लेख बनाईयें',
	'inputbox-ns-main' => 'मुख्य',
);

/** Fiji Hindi (Latin script) (Fiji Hindi)
 * @author Thakurji
 */
$messages['hif-latn'] = array(
	'inputbox-desc' => 'Predefined HTML forms ke allow karo',
	'inputbox-error-no-type' => 'Aap ii nai bataya hai ki kon rakam ke input box ke banae ke chaahi',
	'inputbox-error-bad-type' => 'Input box type "$1" ke pehchana nai gais hai.
Meharbani kar kr ii batao ki "create", "comment", "search", "search2" nai to "fulltext" hai.',
	'tryexact' => 'Exact match ke try karo',
	'searchfulltext' => 'Puura text me khojo',
	'createarticle' => 'Panna banao',
);

/** Hiligaynon (Ilonggo)
 * @author Jose77
 */
$messages['hil'] = array(
	'createarticle' => 'Maghimo artikulo',
);

/** Croatian (Hrvatski)
 * @author Brest
 * @author Dnik
 * @author SpeedyGonsales
 */
$messages['hr'] = array(
	'inputbox-desc' => 'Dozvoli uključivanje predefiniranih obrazaca u HTML-u',
	'inputbox-error-no-type' => 'Niste naveli tip ulaznog polja koje želite stvoriti.',
	'inputbox-error-bad-type' => 'Tip ulaznog polja "$1" nije prepoznat. 
Molimo navedite "create", "comment", "search", "search2" ili "fulltext".',
	'tryexact' => 'Pokušaj naći točan pogodak',
	'searchfulltext' => 'Traži po cjelokupnom tekstu',
	'createarticle' => 'Stvori članak',
);

/** Upper Sorbian (Hornjoserbsce)
 * @author Dundak
 * @author Michawiki
 */
$messages['hsb'] = array(
	'inputbox-desc' => 'Zapřijeće předdefinowanych HTML-formularow dowolić.',
	'inputbox-error-no-type' => 'Njesy typ zapodatneho kašćika podał.',
	'inputbox-error-bad-type' => 'Typ zapodatneho kašćika "$1" je njeznaty. Prošu podaj płaćiwy typ: "create", "comment", "search", "search2" abo "fulltext".',
	'tryexact' => 'Dokładne pytanje spytać',
	'searchfulltext' => 'Dospołny tekst pytać',
	'createarticle' => 'Nastawk wutworić',
	'inputbox-ns-main' => 'Strony',
);

/** Haitian (Kreyòl ayisyen)
 * @author Boukman
 * @author Masterches
 */
$messages['ht'] = array(
	'inputbox-desc' => 'Pèmèt ou mete fòmilè HTML yo ki deja defini.',
	'inputbox-error-no-type' => 'Atansyon, ou pa bay detay sou tip, kalite bwat antre pou ou kreye',
	'inputbox-error-bad-type' => 'Kalite bwat $1 ou antre pa bon, sistèm nan pa konnen l.
Tanpri mete youn nan opsyon sa yo: "create", "comment", "search", "search2" oubyen "fulltext".',
	'tryexact' => 'Eseye paj ki koresponn toutbon.',
	'searchfulltext' => 'Fouye nan tout teks nèt',
	'createarticle' => 'Kreye atik sa',
);

/** Hungarian (Magyar)
 * @author Dani
 * @author Dj
 * @author Glanthor Reviol
 * @author KossuthRad
 * @author Tgr
 */
$messages['hu'] = array(
	'inputbox-desc' => 'Lehetővé teszi előre megadott HTML-űrlapok beillesztését',
	'inputbox-error-no-type' => 'Nem adtad meg, hogy milyen típusú beviteli mezőt akarsz készíteni.',
	'inputbox-error-bad-type' => '„$1” típusú beviteli mező nem ismert.
A „create”, „comment”, „search”, „search2” vagy „fulltext” egyikét add meg.',
	'tryexact' => 'Ugrás a szócikkre',
	'searchfulltext' => 'Keresés a teljes szövegben',
	'createarticle' => 'Szócikk létrehozása',
	'inputbox-ns-main' => 'Fő',
);

/** Armenian (Հայերեն)
 * @author Xelgen
 */
$messages['hy'] = array(
	'createarticle' => 'Ստեղծել էջ',
);

/** Interlingua (Interlingua)
 * @author McDutchie
 */
$messages['ia'] = array(
	'inputbox-desc' => 'Permitter le inclusion de formularios HTML predefinite',
	'inputbox-error-no-type' => 'Tu non ha specificate le typo de quadro de entrata a crear.',
	'inputbox-error-bad-type' => 'Le typo de quadro de entrata "$1" non es recognoscite.
Per favor specifica "create", "comment", "search", "search2" o "fulltext".',
	'tryexact' => 'Provar correspondentia exacte',
	'searchfulltext' => 'Cercar in texto integre',
	'createarticle' => 'Crear pagina',
	'inputbox-ns-main' => 'Principal',
);

/** Indonesian (Bahasa Indonesia)
 * @author -iNu-
 * @author Aldnonymous
 * @author IvanLanin
 * @author Rex
 */
$messages['id'] = array(
	'inputbox-desc' => 'Memungkinkan penggunaan form HTML yang telah ditentukan',
	'inputbox-error-no-type' => 'Anda harus menentukan tipe kotak input yang ingin dibuat.',
	'inputbox-error-bad-type' => 'Tipe kotak input "$1" tak dikenal.
Harap gunakan "create", "comment", "search", "search2", atau "fulltext".',
	'tryexact' => 'Coba pencocokan eksak',
	'searchfulltext' => 'Cari di teks lengkap',
	'createarticle' => 'Buat halaman',
	'inputbox-ns-main' => 'Utama',
);

/** Igbo (Igbo)
 * @author Ukabia
 */
$messages['ig'] = array(
	'createarticle' => 'Ké ihü',
);

/** Iloko (Ilokano)
 * @author Lam-ang
 */
$messages['ilo'] = array(
	'inputbox-desc' => 'Pakabaelan na nga agikabil kadagiti napalasin a kinabuklan ti HTML',
	'inputbox-error-no-type' => 'Saan mo pay nga imbaga no ania a kita ti pagikabilan a kahon ti aramiden.',
	'inputbox-error-bad-type' => 'Ti kita ti pigikabilan a kahon "$1" ket saan a ma-ammoan.
Pangaasi ta ibagam nga "agaramid", "komentario", "biruken", "biruken2", "wenno sibubukel a teksto".',
	'tryexact' => 'Padasem to pudno a kapada',
	'searchfulltext' => 'Agbiruk ti sibubukel a teksto',
	'createarticle' => 'Agaramid ti panid',
	'inputbox-ns-main' => 'Dati',
);

/** Ido (Ido)
 * @author Malafaya
 */
$messages['io'] = array(
	'searchfulltext' => 'Serchar tota texto',
	'createarticle' => 'Krear pagino',
);

/** Icelandic (Íslenska)
 * @author S.Örvarr.S
 */
$messages['is'] = array(
	'createarticle' => 'Búa til síðu',
);

/** Italian (Italiano)
 * @author BrokenArrow
 * @author Darth Kule
 * @author Karika
 */
$messages['it'] = array(
	'inputbox-desc' => "Consente l'inserimento di moduli HTML predefiniti",
	'inputbox-error-no-type' => 'Non è stato specificato il tipo di inputbox da creare.',
	'inputbox-error-bad-type' => '"$1" non è un tipo di inputbox riconosciuto. Scegliere il tipo tra "create", "comment", "search", "search2" e "fulltext".',
	'tryexact' => 'Cerca corrispondenza esatta',
	'searchfulltext' => 'Ricerca nel testo',
	'createarticle' => 'Crea voce',
	'inputbox-ns-main' => 'Principale',
);

/** Japanese (日本語)
 * @author Fryed-peach
 * @author JtFuruhata
 * @author Schu
 */
$messages['ja'] = array(
	'inputbox-desc' => 'あらかじめ定義されたHTMLフォーム埋め込み機能を有効にする',
	'inputbox-error-no-type' => '作成すべき入力ボックスのタイプが指定されていません。',
	'inputbox-error-bad-type' => '"$1" というタイプの入力ボックスは定義されていません。"create"・"comment"・"search"・"search2"・"fulltext" が指定可能です。',
	'tryexact' => '一致する項目を検索',
	'searchfulltext' => '全文検索',
	'createarticle' => '項目を作成',
	'inputbox-ns-main' => '(標準)',
);

/** Jutish (Jysk)
 * @author Huslåke
 */
$messages['jut'] = array(
	'inputbox-desc' => 'Tilstån der inklusje der prædæfiiniærn HTML fårmer',
	'inputbox-error-no-type' => 'Du harst ekke spæsifiærn æ type der input boks til skep.',
	'inputbox-error-bad-type' => 'Input boks type "$1" ekke herkonnen. Spæsifiær "skep", "bimærkenge", "søĝ" æller "søĝ2".',
	'tryexact' => 'Førsøĝ eksakt søĝnenge:',
	'searchfulltext' => "Gennemsøĝe'n hæle tekster",
	'createarticle' => 'Åprette side',
);

/** Javanese (Basa Jawa)
 * @author Meursault2004
 * @author Pras
 */
$messages['jv'] = array(
	'inputbox-desc' => 'Ngidinaké nganggo formulir HTML sing wis ditemtokaké',
	'inputbox-error-no-type' => 'Panjenengan durung nemtokaké tipe kothak input sing arep digawé.',
	'inputbox-error-bad-type' => 'Tipe kothak input "$1" ora dikenal.
Supaya migunakaké "create", "comment", "search", "search2", utawa "fulltext".',
	'tryexact' => 'Cobanen pancocogan èksak',
	'searchfulltext' => 'Golèk ing tèks jangkep',
	'createarticle' => 'Damel artikel',
);

/** Georgian (ქართული)
 * @author Alsandro
 * @author David1010
 * @author ITshnik
 */
$messages['ka'] = array(
	'inputbox-desc' => 'საშუალებას იძლევა ჩართოს წინასწარ განსაზღვრული HTML ფორმები',
	'tryexact' => 'სცადე ზუსტი დამთხვევა',
	'searchfulltext' => 'სრული ტექსტის ძიება',
	'createarticle' => 'სტატიის შექმნა',
	'inputbox-ns-main' => 'მთავარი',
);

/** Kara-Kalpak (Qaraqalpaqsha) */
$messages['kaa'] = array(
	'createarticle' => 'Bet jaratıw',
);

/** Kabyle (Taqbaylit)
 * @author Agurzil
 */
$messages['kab'] = array(
	'tryexact' => 'Nadi ɣef uzwel kif-kif',
	'searchfulltext' => 'Nadi aḍris ettmam',
	'createarticle' => 'Xleq amagrad',
);

/** Kazakh (Arabic script) (‫قازاقشا (تٴوتە)‬) */
$messages['kk-arab'] = array(
	'inputbox-error-no-type' => 'جاسالاتىن ەنگٸزۋ جولاعىنىڭ تٷرٸن كەلتٸرمەپسٸز.',
	'inputbox-error-bad-type' => 'ەنگٸزۋ جولاقتىڭ «$1» تٷرٸ تانىلمادى. تەك «create», «comment», «search» نە «search2» دەگەن تٷرلەردٸ كەلتٸرٸڭٸز.',
	'tryexact' => 'دٵل سٵيكەسٸن سىناپ كٶرٸڭٸز',
	'searchfulltext' => 'تولىق مٵتٸنٸمەن ٸزدەۋ',
	'createarticle' => 'بەتتٸ باستاۋ',
);

/** Kazakh (Cyrillic script) (‪Қазақша (кирил)‬) */
$messages['kk-cyrl'] = array(
	'inputbox-error-no-type' => 'Жасалатын енгізу жолағының түрін келтірмепсіз.',
	'inputbox-error-bad-type' => 'Енгізу жолақтың «$1» түрі танылмады. Тек «create», «comment», «search» не «search2» деген түрлерді келтіріңіз.',
	'tryexact' => 'Дәл сәйкесін сынап көріңіз',
	'searchfulltext' => 'Толық мәтінімен іздеу',
	'createarticle' => 'Бетті бастау',
);

/** Kazakh (Latin script) (‪Qazaqşa (latın)‬) */
$messages['kk-latn'] = array(
	'inputbox-error-no-type' => 'Jasalatın engizw jolağınıñ türin keltirmepsiz.',
	'inputbox-error-bad-type' => 'Engizw jolaqtıñ «$1» türi tanılmadı. Tek «create», «comment», «search» ne «search2» degen türlerdi keltiriñiz.',
	'tryexact' => 'Däl säýkesin sınap köriñiz',
	'searchfulltext' => 'Tolıq mätinimen izdew',
	'createarticle' => 'Betti bastaw',
);

/** Khmer (ភាសាខ្មែរ)
 * @author Chhorran
 * @author Lovekhmer
 * @author T-Rithy
 */
$messages['km'] = array(
	'inputbox-error-no-type' => 'អ្នកមិនទាន់បញ្ជាក់ប្រភេទប្រអប់បញ្ចូលដើម្បីបង្កើត។',
	'searchfulltext' => 'ស្វែងរកពាក្យពេញ',
	'createarticle' => 'បង្កើតទំព័រ',
);

/** Korean (한국어)
 * @author Albamhandae
 * @author Klutzy
 * @author Kwj2772
 * @author ToePeu
 */
$messages['ko'] = array(
	'inputbox-desc' => '사전 정의된 HTML 폼을 포함할 수 있게 해 줌',
	'inputbox-error-no-type' => 'type 속성을 정하지 않았습니다.',
	'inputbox-error-bad-type' => '"$1"은(는) 사용할 수 없는 type 속성입니다.
"create", "comment", "search", "search2", "fulltext" 중 하나를 사용하세요.',
	'tryexact' => '정확한 이름으로 찾기',
	'searchfulltext' => '전체 글 검색',
	'createarticle' => '문서 만들기',
	'inputbox-ns-main' => '문서',
);

/** Komi-Permyak (Перем Коми)
 * @author Enye Lav
 */
$messages['koi'] = array(
	'tryexact' => 'Кошшыны утлянно сiйö',
	'searchfulltext' => 'Кошшыны тыр текст',
	'createarticle' => 'Лöсьöтны листбок',
);

/** Colognian (Ripoarisch)
 * @author Purodha
 */
$messages['ksh'] = array(
	'inputbox-desc' => 'Bestemmpte HTML-Formulare könne hee met enjebonge wääde.',
	'inputbox-error-no-type' => 'Wat för en Zoot Kaste wells De dann han?',
	'inputbox-error-bad-type' => 'De Zoot „$1“ för et Feld för jet enzejevve kenne mer nit, De moss schunn „create“, „comment“, „search“, „search2“, udder „fulltext“ doför aanjevve.',
	'tryexact' => 'Versök en akkurate Üvvereinstimmung:',
	'searchfulltext' => 'Sök durch dä janze Tex',
	'createarticle' => 'Sigg aanlääje',
	'inputbox-ns-main' => '{{int:blanknamespace}}',
);

/** Kurdish (Latin script) (‪Kurdî (latînî)‬) */
$messages['ku-latn'] = array(
	'createarticle' => 'Gotarê biafirîne',
);

/** Latin (Latina) */
$messages['la'] = array(
	'createarticle' => 'Paginam creare',
);

/** Luxembourgish (Lëtzebuergesch)
 * @author Robby
 */
$messages['lb'] = array(
	'inputbox-desc' => "Erlaabt d'Afüge vu viirdefinéierten HTML-Formulairen",
	'inputbox-error-no-type' => 'Dir hutt den Typ vu Këscht fir eppes anzeginn net uginn.',
	'inputbox-error-bad-type' => 'Këscht fir anzeginn vum Typ "$1" net erkannt.
Gitt w.e.g. "create", "comment", "search", "search2" oder "fulltext" un.',
	'tryexact' => 'Versicht et matt der preziser Sich:',
	'searchfulltext' => 'Am ganzen Text sichen',
	'createarticle' => 'Säit uleeën',
	'inputbox-ns-main' => 'Haapt',
);

/** Lingua Franca Nova (Lingua Franca Nova)
 * @author Malafaya
 */
$messages['lfn'] = array(
	'createarticle' => 'Crea paje',
);

/** Ganda (Luganda) */
$messages['lg'] = array(
	'createarticle' => 'Wandika omuko',
);

/** Limburgish (Limburgs)
 * @author Aelske
 * @author Matthias
 * @author Ooswesthoesbes
 */
$messages['li'] = array(
	'inputbox-desc' => "Maakt 't toevoege van veurgedefinieerde HTML-formuliere meugelijk",
	'inputbox-error-no-type' => "U heeft 't type inputbox neet aangegeve. Zie [http://www.mediawiki.org/wiki/Extension:Inputbox MediaWiki.org] veur meer informatie.",
	'inputbox-error-bad-type' => 'Inputbox-type "$1" neet herkend. 
Gebroek "create", "comment", "search", "search2" óf "fulltext".',
	'tryexact' => 'Perbeer exacte euvereinkoms',
	'searchfulltext' => 'Zeuk de volledige teks',
	'createarticle' => "Maak 'n pagina aan",
	'inputbox-ns-main' => 'Houfnaamruumdje',
);

/** Lingala (Lingála)
 * @author Moyogo
 */
$messages['ln'] = array(
	'createarticle' => 'Kokela ekakoli',
);

/** Lao (ລາວ)
 * @author Tuinui
 */
$messages['lo'] = array(
	'tryexact' => 'ໄປ',
	'searchfulltext' => 'ຊອກຫາ',
	'createarticle' => 'ສ້າງບົດຄວາມ',
);

/** Lithuanian (Lietuvių) */
$messages['lt'] = array(
	'tryexact' => 'Mėginti tikslų atitikimą',
	'searchfulltext' => 'Ieškoti pilno teksto',
	'createarticle' => 'Kurti straipsnį',
);

/** Latgalian (Latgaļu)
 * @author Dark Eagle
 */
$messages['ltg'] = array(
	'createarticle' => 'Sataiseit rakstīņu',
);

/** Latvian (Latviešu)
 * @author Dark Eagle
 * @author Xil
 * @author Yyy
 */
$messages['lv'] = array(
	'inputbox-desc' => 'Atļaut iekļaut iepriekš noteiktās HTML formas',
	'inputbox-error-no-type' => 'Tu neesi norādījis ievades lauka tipu',
	'inputbox-error-bad-type' => 'Ievades lauka tips "$1" nav atpazīts.
Lūdzu norādi "create", "comment", "search", "search2" vai "fulltext".',
	'tryexact' => 'Meklēt precīzi',
	'searchfulltext' => 'Meklēt visu tekstu',
	'createarticle' => 'Izveidot lapu',
);

/** Literary Chinese (文言) */
$messages['lzh'] = array(
	'inputbox-error-no-type' => '汝未定輸入盒之類也。',
	'inputbox-error-bad-type' => '輸入盒之類"$1"無認耳。指"create"、"comment"、"search"或"search2"之。',
	'tryexact' => '查全合',
	'searchfulltext' => '尋全文',
	'createarticle' => '撰文',
);

/** Macedonian (Македонски)
 * @author Bjankuloski06
 * @author Brest
 * @author Misos
 */
$messages['mk'] = array(
	'inputbox-desc' => 'Овозможува вклучување на предодредени HTML-форми',
	'inputbox-error-no-type' => 'Немате наведено тип на поле за внос кое сакате да го создадете.',
	'inputbox-error-bad-type' => 'Типот на полето за внес "$1" не е познат.
Наведете еден од следниве "create", "comment", "search", "search2" или "fulltext".',
	'tryexact' => 'Обиди се точно',
	'searchfulltext' => 'Барај низ целиот текст',
	'createarticle' => 'Создај страница',
	'inputbox-ns-main' => 'Главна',
);

/** Malayalam (മലയാളം)
 * @author Praveenp
 * @author Shijualex
 */
$messages['ml'] = array(
	'inputbox-desc' => 'നിർവ്വചിക്കപ്പെട്ടു വെച്ചിരിക്കുന്ന HTML ഫോമുകൾ ഉൾപ്പെടുത്താൻ അനുവദിക്കുക',
	'inputbox-error-no-type' => 'സൃഷ്ടിക്കേണ്ട ഇൻപുട്ട് ബോക്സിന്റെ തരം നിഷ്കർഷിച്ചിട്ടില്ല',
	'inputbox-error-bad-type' => 'ഇൻപുട്ട് ബോക്സ് "$1" ഏതു തരം എന്നു തിരിച്ചറിയാൻ കഴിഞ്ഞില്ല.
ദയവു ചെയ്ത് "create", "comment", "search", "search2" ഇവയിലൊന്നു നിഷ്കർഷിക്കുക',
	'tryexact' => 'കൃത്യമായി യോജിക്കുന്ന ഫലങ്ങൾ ഉണ്ടോയെന്നു പരിശോധിക്കുക',
	'searchfulltext' => 'എഴുത്ത് മൊത്തമായി തിരയുക',
	'createarticle' => 'താൾ സൃഷ്ടിക്കുക',
	'inputbox-ns-main' => 'മുഖ്യം',
);

/** Mongolian (Монгол)
 * @author Chinneeb
 */
$messages['mn'] = array(
	'createarticle' => 'Хуудас үүсгэх',
);

/** Marathi (मराठी)
 * @author Kaustubh
 * @author Mahitgar
 * @author Rahuldeshmukh101
 * @author V.narsikar
 */
$messages['mr'] = array(
	'inputbox-desc' => 'पूर्वी लिहिलेले HTML अर्ज वापरण्याची परवानगी द्या',
	'inputbox-error-no-type' => 'तुम्ही कुठल्या प्रकारची पृष्ठपेटी तयार करायची ते स्पष्ट केलेले नाही.',
	'inputbox-error-bad-type' => 'तुम्ही दिलेला पृष्ठपेटीचा "$1" हा प्रकार ओळखीचा नाही. 
कृपया "create", "comment", "search" किंवा "search2"  किंवा "fulltext".यातील एक निवडा.',
	'tryexact' => 'दिलेलेच शब्द शोधा',
	'searchfulltext' => 'पूर्ण मजकूर शोधा',
	'createarticle' => 'लेख बनवा',
	'inputbox-ns-main' => 'मुख्य',
);

/** Malay (Bahasa Melayu)
 * @author Anakmalaysia
 * @author Aviator
 */
$messages['ms'] = array(
	'inputbox-desc' => 'Membenarkan penyertaan borang HTML yang sudah ditetapkan.',
	'inputbox-error-no-type' => 'Anda tidak menyatakan jenis kotak input untuk diciptakan.',
	'inputbox-error-bad-type' => 'Jenis kotak input "$1" tidak dikenali. Sila nyatakan "create", "comment", "search", "search2" atau "fulltext".',
	'tryexact' => 'Cuba padanan tepat',
	'searchfulltext' => 'Cari dalam teks penuh',
	'createarticle' => 'Cipta laman',
	'inputbox-ns-main' => 'Utama',
);

/** Maltese (Malti)
 * @author Chrisportelli
 * @author Giangian15
 */
$messages['mt'] = array(
	'inputbox-desc' => "Tħalli formuli ta' HTML predefiniti",
	'inputbox-error-no-type' => "Inti ma speċifikajtx it-tip ta' ''input box'' li trid toħloq.",
	'inputbox-error-bad-type' => '"$1" mhuwiex tip magħruf ta\' \'\'inputbox\'\'.
Jekk jogħġbok speċifika fost "create", "comment", "search", "search2" jew "fulltext".',
	'tryexact' => 'Fittex korrispondenza eżatta',
	'searchfulltext' => 'Fittex fit-test',
	'createarticle' => 'Oħloq paġna',
);

/** Erzya (Эрзянь)
 * @author Botuzhaleny-sodamo
 */
$messages['myv'] = array(
	'createarticle' => 'Шкамс лопа',
);

/** Mazanderani (مازِرونی)
 * @author Spacebirdy
 * @author محک
 */
$messages['mzn'] = array(
	'createarticle' => 'صفحه بَیتن',
);

/** Nahuatl (Nāhuatl)
 * @author Fluence
 */
$messages['nah'] = array(
	'createarticle' => 'Ticchīhuāz zāzanilli',
);

/** Min Nan Chinese (Bân-lâm-gú) */
$messages['nan'] = array(
	'searchfulltext' => 'Chhiau choan-bûn',
);

/** Neapolitan (Nnapulitano)
 * @author SabineCretella
 */
$messages['nap'] = array(
	'searchfulltext' => "Ascià dint''o testo",
	'createarticle' => 'Cria voce',
);

/** Norwegian (bokmål)‬ (‪Norsk (bokmål)‬)
 * @author EivindJ
 * @author Jon Harald Søby
 */
$messages['nb'] = array(
	'inputbox-desc' => 'Tillater inkludering av forhåndsdefinerte HTML-skjemaer',
	'inputbox-error-no-type' => 'Du har ikke angitt hva slags inputboks du vil lage.',
	'inputbox-error-bad-type' => 'Inputboks av typen «$1» gjenkjennes ikke.
Vennligst velg «create», «comment», «search», «search2» eller «fulltext».',
	'tryexact' => 'Prøv nøyaktig treff',
	'searchfulltext' => 'Søk full tekst',
	'createarticle' => 'Opprett side',
	'inputbox-ns-main' => 'Hoved',
);

/** Low German (Plattdüütsch)
 * @author Slomox
 */
$messages['nds'] = array(
	'inputbox-desc' => 'Verlöövt dat Inbinnen vun vördefineerte HTML-Formularen',
	'inputbox-error-no-type' => 'Du hest keen Typ för dat Ingaav-Feld angeven.',
	'inputbox-error-bad-type' => 'De Typ „$1“ för dat Ingaav-Feld is nich bekannt.
Geev een vun disse Typen an: „create“, „comment“, „search“, „search2“ oder „fulltext“.',
	'tryexact' => 'exakte Söök versöken',
	'searchfulltext' => 'in’n Vulltext söken',
	'createarticle' => 'Siet anleggen',
);

/** Nedersaksisch (Nedersaksisch)
 * @author Servien
 */
$messages['nds-nl'] = array(
	'tryexact' => 'Naor sekuur zeuken',
	'searchfulltext' => 'De hele tekste deurzeuken',
	'createarticle' => 'Nieje pagina anmaken',
);

/** Nepali (नेपाली) */
$messages['ne'] = array(
	'createarticle' => 'लेख थाल्नुहोस्',
);

/** Dutch (Nederlands)
 * @author SPQRobin
 * @author Siebrand
 */
$messages['nl'] = array(
	'inputbox-desc' => 'Maakt het toevoegen van voorgedefinieerde HTML-formulieren mogelijk',
	'inputbox-error-no-type' => 'U hebt het type invoerveld niet aangegeven.
Zie [http://www.mediawiki.org/wiki/Extension:Inputbox MediaWiki.org] voor meer informatie.',
	'inputbox-error-bad-type' => 'Type invoerveld "$1" niet herkend.
Gebruik "create", "comment", "search", "search2" of "fulltext".',
	'tryexact' => 'Zoeken op exacte overeenkomst',
	'searchfulltext' => 'Volledige tekst doorzoeken',
	'createarticle' => 'Pagina aanmaken',
	'inputbox-ns-main' => 'Hoofdnaamruimte',
);

/** Norwegian Nynorsk (‪Norsk (nynorsk)‬)
 * @author Frokor
 * @author Harald Khan
 */
$messages['nn'] = array(
	'inputbox-desc' => 'Tillet inkludering av førehandsdefinerte HTML-skjema',
	'inputbox-error-no-type' => 'Du har ikkje gjeve kva slags inputboks du vil lage.',
	'inputbox-error-bad-type' => 'Inntekstboks av typen «$1» vart ikkje gjenkjent.
Ver venleg og velg «create», «comment», «search», «search2», eller «fulltext».',
	'tryexact' => 'Prøv nøyaktig treff',
	'searchfulltext' => 'Søk i all tekst',
	'createarticle' => 'Lag side',
);

/** Novial (Novial)
 * @author Malafaya
 */
$messages['nov'] = array(
	'searchfulltext' => 'Sercha kompleti texte',
);

/** Northern Sotho (Sesotho sa Leboa)
 * @author Mohau
 */
$messages['nso'] = array(
	'createarticle' => 'Tlhoma letlakala',
);

/** Occitan (Occitan)
 * @author Cedric31
 */
$messages['oc'] = array(
	'inputbox-desc' => 'Permet l’inclusion de formularis HTML predefinits',
	'inputbox-error-no-type' => "Avètz pas precisat lo tipe de la bóstia d'entrada de crear.",
	'inputbox-error-bad-type' => "Tipe de bóstia d'entrada « $1 » pas reconeguda.
Indicatz una opcion demest ''create'', ''comment'', ''search'' o ''searche2'' o « fulltext ».",
	'tryexact' => 'Ensajatz la correspondéncia exacta',
	'searchfulltext' => 'Recèrca en tèxte integral',
	'createarticle' => 'Crear l’article',
);

/** Oriya (ଓଡ଼ିଆ)
 * @author Odisha1
 * @author Psubhashish
 */
$messages['or'] = array(
	'inputbox-desc' => 'ଆଗରୁ ତିଆରି HTML ରୂପରେ ଆହରଣକୁ ଅନୁମୋଦନ ଦେବା',
	'inputbox-error-no-type' => 'ଆପଣ ନିବେଶ ଘରେ ଦେବାକୁ ଥିବା ଲେଖାର ପ୍ରକାର ଏଯାଏଁ ଦେଇନାହାନ୍ତି ।',
	'inputbox-error-bad-type' => 'ନିବେଶ ଘର ପ୍ରକାର "$1" ବାରିପାରିଲୁ ନାହିଁ ।
ଦୟାକରି "create", "comment", "search", "search2" ଅବା "fulltext" ସ୍ଥିର କରନ୍ତୁ ।',
	'tryexact' => 'ପୁରାପୁରି ମେଳ କରିବାକୁ ଚେଷ୍ଟା କରିବେ',
	'searchfulltext' => 'ପୁରା ଲେଖା ଖୋଜିବେ',
	'createarticle' => 'ନୂଆ ପୃଷ୍ଠାଟିଏ ତିଆରିବେ',
	'inputbox-ns-main' => 'ମୁଖ୍ୟ',
);

/** Pangasinan (Pangasinan) */
$messages['pag'] = array(
	'createarticle' => 'Mangawa na artikulo',
);

/** Pampanga (Kapampangan) */
$messages['pam'] = array(
	'createarticle' => 'Gawang artikulu',
);

/** Deitsch (Deitsch)
 * @author Xqt
 */
$messages['pdc'] = array(
	'inputbox-ns-main' => 'Bledder',
);

/** Polish (Polski)
 * @author Derbeth
 * @author Sp5uhe
 */
$messages['pl'] = array(
	'inputbox-desc' => 'Umożliwia włączenie w treść strony wcześniej zdefiniowanych formularzy HTML',
	'inputbox-error-no-type' => 'Typ pola wejściowego nie został określony',
	'inputbox-error-bad-type' => 'Typ „$1” pola wejściowego nie został rozpoznany.
Należy wybrać „create”, „comment”, „search”, „search2” or „fulltext”.',
	'tryexact' => 'Użyj dokładnego wyrażenia',
	'searchfulltext' => 'Szukaj w całych tekstach',
	'createarticle' => 'Utwórz artykuł',
	'inputbox-ns-main' => 'Główna',
);

/** Piedmontese (Piemontèis)
 * @author Bèrto 'd Sèra
 * @author Dragonòt
 */
$messages['pms'] = array(
	'inputbox-desc' => "A përmëtt l'anseriment ëd forme HTML predefinìe",
	'inputbox-error-no-type' => "A l'ha nen dit che sòrt ëd quàder ëd caria dat ch'a debia fesse.",
	'inputbox-error-bad-type' => 'La sòrt ëd quàder "$1" a l\'é nen conossùa. 
Për piasì, ch\'a sërna antra "create", "comment", "search", "search2" o "fulltext".',
	'tryexact' => 'Sërca che a sia pròpe parej',
	'searchfulltext' => 'Sërca an tut ël test',
	'createarticle' => "Crea n'artìcol",
	'inputbox-ns-main' => 'Prinsipal',
);

/** Western Punjabi (پنجابی)
 * @author Khalid Mahmood
 */
$messages['pnb'] = array(
	'inputbox-desc' => 'ایچ ٹی ایم ایل پریڈیفائینڈ فورمز نوں رلان دی اجازت دیو۔',
	'inputbox-error-no-type' => 'تساں انپٹ ڈبے بنان دی ٹائپ نئیں دسی۔',
	'inputbox-error-bad-type' => 'انپٹ ڈبہ ٹائپ "$1" نئیں پچھانیا گیا۔
مہربانی کرکے "create", "comment", "search", "search2"  "fulltext" بارے دسو۔',
	'tryexact' => 'ٹھیک جوڑ رلاؤ',
	'searchfulltext' => 'پوری لکھت لبو',
	'createarticle' => 'صفہ بناؤ',
	'inputbox-ns-main' => 'مین',
);

/** Pontic (Ποντιακά)
 * @author Sinopeus
 */
$messages['pnt'] = array(
	'createarticle' => 'Ποίσον σελίδαν',
);

/** Pashto (پښتو)
 * @author Ahmed-Najib-Biabani-Ibrahimkhel
 */
$messages['ps'] = array(
	'inputbox-desc' => 'د پخوا نه د HTML څرګند شويو فورمو کارولو اجازه ورکوي',
	'tryexact' => 'کټ مټ انډول يې وآزمويه',
	'searchfulltext' => 'بشپړ متن پلټل',
	'createarticle' => 'نوې ليکنه پيلول',
	'inputbox-ns-main' => 'آرنی',
);

/** Portuguese (Português)
 * @author Hamilton Abreu
 * @author Malafaya
 */
$messages['pt'] = array(
	'inputbox-desc' => 'Permite a inclusão de formulários HTML pré-definidos.',
	'inputbox-error-no-type' => 'Não especificou o tipo de caixa de edição a ser criado.',
	'inputbox-error-bad-type' => 'O tipo de caixa de introdução de dados "$1" não foi reconhecido.
Por favor, especifique "create", "comment", "search", "search2" ou "fulltext".',
	'tryexact' => 'Tentar a exata expressão',
	'searchfulltext' => 'Pesquisar no texto completo',
	'createarticle' => 'Criar página',
	'inputbox-ns-main' => 'Principal',
);

/** Brazilian Portuguese (Português do Brasil)
 * @author Brunoy Anastasiya Seryozhenko
 * @author Eduardo.mps
 * @author MetalBrasil
 */
$messages['pt-br'] = array(
	'inputbox-desc' => 'Permite a inclusão de formulários definidos de HTML',
	'inputbox-error-no-type' => 'Você não especificou o tipo de inputbox a ser criada.',
	'inputbox-error-bad-type' => 'O tipo de caixa de introdução de dados "$1" não foi reconhecido.
Por favor, especifique "create", "comment", "search", "search2" ou "fulltext".',
	'tryexact' => 'Tentar a expressão exata',
	'searchfulltext' => 'Pesquisar em todo o texto.',
	'createarticle' => 'Criar página.',
	'inputbox-ns-main' => 'Principal',
);

/** Quechua (Runa Simi)
 * @author AlimanRuna
 */
$messages['qu'] = array(
	'tryexact' => 'Hinalla taripanayaspa maskay',
	'searchfulltext' => "Hunt'a qillqata maskay",
	'createarticle' => 'Qillqata kamariy',
);

/** Romanian (Română)
 * @author AdiJapan
 * @author Emily
 * @author Firilacroco
 * @author KlaudiuMihaila
 * @author Mihai
 * @author Minisarm
 */
$messages['ro'] = array(
	'inputbox-desc' => 'Permite includerea formelor HTML predefinite',
	'inputbox-error-no-type' => 'Nu ați specificat ce tip de cutie intrare să fie creată.',
	'inputbox-error-bad-type' => 'Tipul de cutie intrare „$1” nu este recunoscut.
Vă rugăm să specificați parametrii „create”, „comment”, „search”, „search2” sau „fulltext”.',
	'tryexact' => 'Încearcă varianta exactă',
	'searchfulltext' => 'Caută textul întreg',
	'createarticle' => 'Creează pagină',
	'inputbox-ns-main' => 'Principal',
);

/** Tarandíne (Tarandíne)
 * @author Joetaras
 */
$messages['roa-tara'] = array(
	'inputbox-desc' => "Permette l'inglusione de module predefinite de HTML",
	'inputbox-error-no-type' => "Tu non g'è specificate 'u tipe de scatele de input da ccrejà.",
	'inputbox-error-bad-type' => '\'U tipe d\'a scatele de input "$1" non g\'è corrette.
Pe piacere mitte "create", "comment", "search", "search2" o "fulltext".',
	'tryexact' => "Pruève cu 'u combronde satte-satte",
	'searchfulltext' => "Cirche jndr'à tutte 'u teste",
	'createarticle' => "Ccreje 'a vôsce",
	'inputbox-ns-main' => 'Prengepàle',
);

/** Russian (Русский)
 * @author Александр Сигачёв
 */
$messages['ru'] = array(
	'inputbox-desc' => 'Позволяет включать заранее определённые HTML-формы',
	'inputbox-error-no-type' => 'Вы не указали тип создаваемого поля ввода.',
	'inputbox-error-bad-type' => 'Неизвестный тип поля ввода «$1».
Пожалуйста, укажите один из допустимых типов: «create», «comment», «search», «search2» или «fulltext».',
	'tryexact' => 'Строгий поиск',
	'searchfulltext' => 'Полнотекстовый поиск',
	'createarticle' => 'Создать статью',
	'inputbox-ns-main' => 'Главная',
);

/** Rusyn (Русиньскый)
 * @author Gazeb
 */
$messages['rue'] = array(
	'inputbox-desc' => 'Доволює вкладати вызначены HTML формуларї.',
	'inputbox-error-no-type' => 'Не задали сьте тіп формуларёвого поля про створїня.',
	'inputbox-error-bad-type' => 'Нерозпознаный тіп поля „$1“.
Зазначте єдну з можностей: „create“, „comment“, „search“, „search2“ або „fulltext“.',
	'tryexact' => 'Спробуйте точне гляданя',
	'searchfulltext' => 'Повнотекстове гляданя',
	'createarticle' => 'Створити статю',
	'inputbox-ns-main' => 'Головна',
);

/** Aromanian (Armãneashce) */
$messages['rup'] = array(
	'createarticle' => 'Adrats articlu',
);

/** Sanskrit (संस्कृतम्)
 * @author Ansumang
 */
$messages['sa'] = array(
	'inputbox-ns-main' => 'मुख्य',
);

/** Sakha (Саха тыла)
 * @author HalanTul
 */
$messages['sah'] = array(
	'inputbox-desc' => 'Эрдэттэн талыллыбыт HTML-формалары холбуур',
	'inputbox-error-no-type' => 'Вы не указали тип создаваемого поля ввода.',
	'inputbox-error-bad-type' => '«$1» көрүҥэ кыайан өйдөммөтө. Бука диэн көҥүллэнэри тал: «create», «comment», «search», «search2» эбэтэр «fulltext».',
	'tryexact' => 'Чопчу булуу',
	'searchfulltext' => 'Тиэкиһин барытын көрдөөһүн',
	'createarticle' => 'Ыстатыйаны айарга',
	'inputbox-ns-main' => 'Сүрүн',
);

/** Sardinian (Sardu)
 * @author Marzedu
 */
$messages['sc'] = array(
	'createarticle' => 'Crea artìculu',
);

/** Sicilian (Sicilianu)
 * @author Aushulz
 * @author Santu
 */
$messages['scn'] = array(
	'inputbox-desc' => 'Pirmetti nzirimenti di mòduli HTML predifiniti',
	'inputbox-error-no-type' => 'Non vinni spicificatu lu tipu di inputbox di criari.',
	'inputbox-error-bad-type' => '"$1" nun è nu tipu di inputbox canusciutu. S\'hà scègghiri lu tipu ntra "create", "comment", "search" e "search2".',
	'tryexact' => 'Cerca currispunnenza giusta',
	'searchfulltext' => 'Circata ntô testu',
	'createarticle' => 'Cria vuci',
	'inputbox-ns-main' => 'Principali',
);

/** Sindhi (سنڌي) */
$messages['sd'] = array(
	'createarticle' => 'نئون مضمون لکو',
);

/** Sango (Sängö) */
$messages['sg'] = array(
	'createarticle' => 'Sü soura',
);

/** Samogitian (Žemaitėška)
 * @author Hugo.arg
 */
$messages['sgs'] = array(
	'searchfulltext' => 'Ėiškuotė pėlna teksta',
);

/** Sinhala (සිංහල)
 * @author Asiri wiki
 * @author Budhajeewa
 * @author නන්දිමිතුරු
 * @author බිඟුවා
 */
$messages['si'] = array(
	'inputbox-desc' => 'පූර්වාර්ථදැක්වූණු HTML ආකාරයන් අඩංගුකිරීමට ඉඩදෙන්න',
	'inputbox-error-no-type' => 'තැනිය යුතු ප්‍රදාන කොටුවේ මාදිලිය ඔබ විසින් නිර්දේශ කොට දක්වා නොමැත.',
	'inputbox-error-bad-type' => '"$1" ඇතුලත් කෙරුම් කොටු වර්ගය හඳුනාගත නොහැක.
"create", "comment", "search", "search2" හෝ "fulltext" බව සඳහන් කරන්න.',
	'tryexact' => 'තථ්‍ය ගැලපීම  වෑයම් කරන්න',
	'searchfulltext' => 'සම්පූර්ණ පෙළ ගවේෂණය කරන්න',
	'createarticle' => 'පිටුවක් සාදන්න',
	'inputbox-ns-main' => 'ප්‍රධාන',
);

/** Slovak (Slovenčina)
 * @author Helix84
 */
$messages['sk'] = array(
	'inputbox-desc' => 'Umožňuje vloženie preddefinovaných HTML formulárov',
	'inputbox-error-no-type' => 'Neuviedli ste typ vstupného poľa, ktoré sa má vytvoriť.',
	'inputbox-error-bad-type' => 'Vstupné pole typu „$1“ nie je podporované.
Prosím, použite „create“, „comment“, „search“ alebo „search2“.',
	'tryexact' => 'Skúste presné vyhľadávanie',
	'searchfulltext' => 'Fulltextové vyhľadávanie',
	'createarticle' => 'Vytvoriť stránku',
);

/** Slovenian (Slovenščina)
 * @author Dbc334
 */
$messages['sl'] = array(
	'inputbox-desc' => 'Omogoča vključitev vnaprej določenih obrazcev HTML',
	'inputbox-error-no-type' => 'Niste določili vrste vnosnega polja za ustvarjanje.',
	'inputbox-error-bad-type' => 'Vrsta vnosnega polja »$1« ni prepoznana.
Prosimo, določite »create«, »comment«, »search«, »search2« ali »fulltext«.',
	'tryexact' => 'Poskusite z natančnim ujemanjem',
	'searchfulltext' => 'Preišči vse besedilo',
	'createarticle' => 'Ustvarite stran',
	'inputbox-ns-main' => 'Osnovno',
);

/** Albanian (Shqip)
 * @author Dori
 * @author Olsi
 */
$messages['sq'] = array(
	'inputbox-desc' => 'Lejoni futjen e formave të paracaktuara HTML',
	'inputbox-error-no-type' => 'Ju nuk keni specifikuar llojin e kutisë për ta krijuar.',
	'inputbox-error-bad-type' => 'Lloji i kutisë "$1" nuk njihet.
Ju lutemi specifikoni "create", "comment", "search", "search2" ose "fulltext".',
	'tryexact' => 'Kërko përputhje të plotë',
	'searchfulltext' => 'Kërko tekstin e plotë',
	'createarticle' => 'Krijo artikull',
	'inputbox-ns-main' => 'Kryesor',
);

/** Serbian (Cyrillic script) (‪Српски (ћирилица)‬)
 * @author Millosh
 * @author Rancher
 * @author Михајло Анђелковић
 */
$messages['sr-ec'] = array(
	'inputbox-desc' => 'Омогући укључивање претходно дефинисаних HTML форми.',
	'inputbox-error-no-type' => 'Ниси одредио тип уносне кутије да би је направио.',
	'inputbox-error-bad-type' => 'Тип "$1" кутијице за унос података је непознат.
Молимо вас да га промените на "create", "comment", "search", "search2" или "fulltext".',
	'tryexact' => 'Покушај тачно',
	'searchfulltext' => 'Претражи цео текст',
	'createarticle' => 'Направи чланак',
	'inputbox-ns-main' => 'Главни',
);

/** Serbian (Latin script) (‪Srpski (latinica)‬)
 * @author Michaello
 */
$messages['sr-el'] = array(
	'inputbox-desc' => 'Omogući uključivanje prethodno definisanih HTML formi.',
	'inputbox-error-no-type' => 'Nisi odredio tip unosne kutije da bi je napravio.',
	'inputbox-error-bad-type' => 'Tip "$1" kutijice za unos podataka je nepoznat.
Molimo vas da ga promenite na "create", "comment", "search", "search2" ili "fulltext".',
	'tryexact' => 'Pokušaj tačno',
	'searchfulltext' => 'Pretraži ceo tekst',
	'createarticle' => 'Napravi članak',
	'inputbox-ns-main' => 'Glavni',
);

/** Swati (SiSwati)
 * @author Jatrobat
 */
$messages['ss'] = array(
	'createarticle' => 'Kúdála intfo',
);

/** Seeltersk (Seeltersk)
 * @author Maartenvdbent
 * @author Pyt
 */
$messages['stq'] = array(
	'inputbox-desc' => 'Ferlööwet dät Apniemen fon foardefinierde HTML-Formulare',
	'inputbox-error-no-type' => 'Du hääst naan Inputbox-Typ ounroat.',
	'inputbox-error-bad-type' => 'Iengoawefäild-Typ "$1" uunbekoand.
Reek n gultigen Typ an: „create“, „comment“, „search“, „search2“ of "fulltext".',
	'tryexact' => 'Fersäik exakte Säike:',
	'searchfulltext' => 'Dän ganse Text truchsäike',
	'createarticle' => 'Siede anlääse',
);

/** Sundanese (Basa Sunda)
 * @author Irwangatot
 */
$messages['su'] = array(
	'tryexact' => 'Coba jeung anu cocog',
	'searchfulltext' => 'Sungsi dina téks lengkap',
	'createarticle' => 'Jieun artikel',
);

/** Swedish (Svenska)
 * @author Boivie
 * @author Lejonel
 * @author Najami
 */
$messages['sv'] = array(
	'inputbox-desc' => 'Ger möjlighet att använda fördefinerade HTML-formulär.',
	'inputbox-error-no-type' => 'Du har inte angivit vilken typ av inputbox som ska skapas..',
	'inputbox-error-bad-type' => '"$1" är inte en känd typ av inputbox.
Var god specifiera "create", "comment", "search", "search2" eller "fulltext".',
	'tryexact' => 'Försök hitta exakt matchning',
	'searchfulltext' => 'Fulltextsökning',
	'createarticle' => 'Skapa sida',
	'inputbox-ns-main' => 'Huvud',
);

/** Swahili (Kiswahili)
 * @author Lloffiwr
 */
$messages['sw'] = array(
	'createarticle' => 'Anzisha ukurasa',
	'inputbox-ns-main' => 'Kuu',
);

/** Silesian (Ślůnski)
 * @author Ozi64
 */
$messages['szl'] = array(
	'createarticle' => 'Naškryflej artikel',
);

/** Tamil (தமிழ்)
 * @author Kanags
 * @author Shanmugamp7
 * @author TRYPPN
 */
$messages['ta'] = array(
	'createarticle' => 'பக்கத்தை உருவாக்கவும்',
	'inputbox-ns-main' => 'முதன்மை',
);

/** Telugu (తెలుగు)
 * @author Chaduvari
 * @author Kiranmayee
 * @author Veeven
 */
$messages['te'] = array(
	'inputbox-desc' => 'ముందే నిర్వచించబడిన HTML ఫారములను చేర్చనివ్వు',
	'inputbox-error-no-type' => 'ఏ రకమైన ఇన్&zwnj;పుట్ పెట్టెని తయారుచేయాలో మీరు చెప్పలేదు.',
	'inputbox-error-bad-type' => 'ప్రవేశికము పెట్టె యొక్క బాపతు "$1"ను గుర్తించలేదు .
దయచేసి "create", "comment", "search", "search2" లేదా "fulltext" లను పేర్కొనండి.',
	'tryexact' => 'ఖచ్చితమైన పోలిక కొరకు ప్రయత్నించు',
	'searchfulltext' => 'పూర్తి పాఠ్యంలో వెతుకు',
	'createarticle' => 'వ్యాసాన్ని సృష్టించు',
	'inputbox-ns-main' => 'ప్రధాన',
);

/** Tajik (Cyrillic script) (Тоҷикӣ)
 * @author Ibrahim
 */
$messages['tg-cyrl'] = array(
	'inputbox-desc' => 'Иҷозаи истифода аз формҳои HTML аз пеш таърифшударо медиҳад',
	'inputbox-error-no-type' => 'Навъи ҷаъбаи вурудии эҷодшавандаро мушаххас накардаед.',
	'inputbox-error-bad-type' => 'Навъи ҷаъбаи вурудии "$1" ношинохта аст. Лутфан як аз маворидро аз инҳо "create", "comment", "search" ё "search2" мушаххас кунед.',
	'tryexact' => 'Мутобиқати аниқро бисанҷед',
	'searchfulltext' => 'Ҷустуҷӯи матни пурра',
	'createarticle' => 'Эҷоди мақола',
);

/** Tajik (Latin script) (tojikī)
 * @author Liangent
 */
$messages['tg-latn'] = array(
	'inputbox-desc' => "Içozai istifoda az formhoi HTML az peş ta'rifşudaro medihad",
	'inputbox-error-no-type' => "Nav'i ça'bai vurudiji eçodşavandaro muşaxxas nakardaed.",
	'tryexact' => 'Mutobiqati aniqro bisançed',
	'searchfulltext' => 'Çustuçūi matni purra',
	'createarticle' => 'Eçodi maqola',
);

/** Thai (ไทย) */
$messages['th'] = array(
	'tryexact' => 'ค้นหาตรงทุกตัวอักษร',
	'searchfulltext' => 'ค้นหาข้อมูล',
	'createarticle' => 'สร้างเนื้อหา',
);

/** Turkmen (Türkmençe)
 * @author Hanberke
 */
$messages['tk'] = array(
	'inputbox-desc' => 'Deslapky kesgitlenen HTML formlarynyň goşulmagyna rugsat berýär',
	'inputbox-error-no-type' => 'Dörediljek giriş gutusynyň tipini görkezmediňiz.',
	'inputbox-error-bad-type' => 'Giriş gutusynyň tipi "$1" ykrar edilmedi.
"create", "comment", "search", "search2" ýa-da "fulltext" diýip görkeziň.',
	'tryexact' => 'Takyk gabat gelýänini syna',
	'searchfulltext' => 'Tutuş teksti gözle',
	'createarticle' => 'Sahypa döret',
);

/** Tagalog (Tagalog)
 * @author AnakngAraw
 */
$messages['tl'] = array(
	'inputbox-desc' => 'Pahintulutan ang pagsasama ng mga pormularyong HTML na may paunang kahulugan',
	'inputbox-error-no-type' => 'Hindi mo tinukoy ang uri ng pasukang kahong lilikhain.',
	'inputbox-error-bad-type' => 'Hindi nakikilala ang uri ng pasukang kahong "$1".
Pakitukoy ang "create", "comment", "search", "search2" o "fulltext".',
	'tryexact' => 'Subukin ang hustung-hustong katugmaan',
	'searchfulltext' => 'Maghanap sa buong teksto',
	'createarticle' => 'Likhain ang pahina',
);

/** Tswana (Setswana) */
$messages['tn'] = array(
	'createarticle' => 'Kwala mokwalo',
);

/** Tongan (lea faka-Tonga) */
$messages['to'] = array(
	'createarticle' => 'Fakatupu ʻa e kupu',
);

/** Turkish (Türkçe)
 * @author Emperyan
 * @author Erkan Yilmaz
 * @author Joseph
 * @author Srhat
 */
$messages['tr'] = array(
	'inputbox-desc' => 'Öntanımlı HTML formlarının dahil edilmesine olanak verir',
	'inputbox-error-no-type' => 'Oluşturulacak girdi kutusunun tipini belirtmediniz.',
	'inputbox-error-bad-type' => 'Girdi kutusu tipi "$1" tanınmadı.
Lütfen "create", "comment", "search", "search2" ya da  "fulltext" olarak belirtin.',
	'tryexact' => 'Tam eşleşme dene',
	'searchfulltext' => 'Tüm metni ara',
	'createarticle' => 'Sayfayı oluştur',
	'inputbox-ns-main' => 'Ana',
);

/** Tsonga (Xitsonga)
 * @author Thuvack
 */
$messages['ts'] = array(
	'createarticle' => 'Tumbuluxa tluka',
);

/** Ukrainian (Українська)
 * @author AS
 * @author Ahonc
 * @author Dim Grits
 */
$messages['uk'] = array(
	'inputbox-desc' => 'Дозволяє включати заздалегідь визначені HTML-форми',
	'inputbox-error-no-type' => 'Ви не зазначили тип поля вводу, яке створюється.',
	'inputbox-error-bad-type' => 'Невідомий тип поля вводу «$1».
Будь ласка, зазначте один з допустимих типів: «create», «comment», «search», «search2» або «fulltext».',
	'tryexact' => 'Строгий пошук',
	'searchfulltext' => 'Повнотекстовий пошук',
	'createarticle' => 'Створити статтю',
	'inputbox-ns-main' => 'Головна',
);

/** Urdu (اردو) */
$messages['ur'] = array(
	'searchfulltext' => 'تلاش ِکل متن',
	'createarticle' => 'نیا مضمون',
);

/** Uzbek (O'zbek) */
$messages['uz'] = array(
	'createarticle' => 'Maqola kiritish',
);

/** Vèneto (Vèneto)
 * @author Candalua
 */
$messages['vec'] = array(
	'inputbox-desc' => "Consente l'inserimento de moduli HTML predefinìi",
	'inputbox-error-no-type' => 'No te ghè specificà el tipo de inputbox da crear.',
	'inputbox-error-bad-type' => '"$1" no\'l xe mìa un tipo de inputbox riconossiùo.
Siegli el tipo tra "create", "comment", "search", "search2" o "fulltext".',
	'tryexact' => 'Çerca corispondenza precisa',
	'searchfulltext' => 'Çerca nel testo',
	'createarticle' => 'Crea pagina',
);

/** Veps (Vepsän kel')
 * @author Игорь Бродский
 */
$messages['vep'] = array(
	'tryexact' => "Lat'kat tehta tarkoiged ecind",
	'searchfulltext' => 'Ectä täudes tekstas',
	'createarticle' => "Säta lehtpol'",
	'inputbox-ns-main' => 'Pänimiavaruz',
);

/** Vietnamese (Tiếng Việt)
 * @author Minh Nguyen
 */
$messages['vi'] = array(
	'inputbox-desc' => 'Thêm những biểu mẫu HTML đơn giản',
	'inputbox-error-no-type' => 'Bạn chưa định rõ loại biểu mẫu để tạo ra.',
	'inputbox-error-bad-type' => 'Loại biểu mẫu “$1” không hợp lệ. Xin hãy chọn “create”, “comment”, “search”, “search2”, hay “fulltext”.',
	'tryexact' => 'Thử tìm đoạn văn khớp chính xác với từ khóa',
	'searchfulltext' => 'Tìm toàn văn',
	'createarticle' => 'Viết bài mới',
	'inputbox-ns-main' => 'Chính',
);

/** Volapük (Volapük)
 * @author Malafaya
 * @author Smeira
 */
$messages['vo'] = array(
	'inputbox-desc' => 'Dälön keninükami fomas-HTLM büo pemiedetölas',
	'searchfulltext' => 'Sukön zi da vödem lölik',
	'createarticle' => 'Jafön padi',
);

/** Võro (Võro)
 * @author Võrok
 */
$messages['vro'] = array(
	'inputbox-desc' => 'Lupa pruukiq ette ärqmäärätüid HTML-vormõ.',
	'inputbox-error-no-type' => 'Sa olõ-õi määränüq sisseandmisvälä tüüpi.',
	'inputbox-error-bad-type' => 'Sisseandmisvälä tüüp ”$1” ei kõlbaq.
Tüüp piät olõma create, comment, search, search2 vai fulltext.',
	'tryexact' => 'Täpsä otsminõ',
	'searchfulltext' => 'Otsiq terveq tekst',
	'createarticle' => 'Luuq leht',
);

/** Walloon (Walon) */
$messages['wa'] = array(
	'createarticle' => 'Ahiver årtike',
);

/** Wolof (Wolof)
 * @author Ibou
 */
$messages['wo'] = array(
	'inputbox-error-no-type' => 'Leeraloo ban xeetu boyotu duggit nga bëgga sos.',
	'inputbox-error-bad-type' => '↓"$1" du xeetu boyotu duggiit bees xam. Tànnal benn ci yii "create", "comment", "seach" walla "search2"',
	'tryexact' => 'Seet wi mu yamal',
	'searchfulltext' => 'Ceet ci mbind mi',
	'createarticle' => 'Sos jukki bi',
);

/** Wu (吴语) */
$messages['wuu'] = array(
	'searchfulltext' => '全文搜寻',
	'createarticle' => '建立新文章',
);

/** Kalmyk (Хальмг)
 * @author Huuchin
 */
$messages['xal'] = array(
	'inputbox-error-no-type' => 'Та бүтәлдг оруллһна теегин янз заав уга.',
	'inputbox-error-bad-type' => '«$1» буру оруллһна теегин янз болҗана.
Буйн болтха, нег йоста янз автн: «create», «comment», «search», «search2» аль «fulltext».',
	'tryexact' => 'Дарата хәәлһн',
	'searchfulltext' => 'Күцц бичг хәәлһн',
	'createarticle' => 'Халхиг бүтәх',
);

/** Xhosa (isiXhosa) */
$messages['xh'] = array(
	'createarticle' => 'Bhala Ibali',
);

/** Yiddish (ייִדיש)
 * @author Yidel
 * @author פוילישער
 */
$messages['yi'] = array(
	'searchfulltext' => 'זוך אין אלע בלעטער',
	'createarticle' => 'באשאפט ארטיקל',
	'inputbox-ns-main' => 'הויפט',
);

/** Yoruba (Yorùbá)
 * @author Demmy
 */
$messages['yo'] = array(
	'createarticle' => 'Dá ojúewé',
);

/** Cantonese (粵語) */
$messages['yue'] = array(
	'inputbox-desc' => '容許包含預先設定嘅HTML表格',
	'inputbox-error-no-type' => '你重未指定開輸入盒嘅指定類型。',
	'inputbox-error-bad-type' => '輸入盒類型"$1"認唔到。請指定"create"、"comment"、"search"或"search2"。',
	'tryexact' => '試吓精確嘅比較',
	'searchfulltext' => '搵全文',
	'createarticle' => '建立文章',
);

/** Simplified Chinese (‪中文(简体)‬)
 * @author Liangent
 * @author PhiLiP
 * @author Wmr89502270
 * @author Xiaomingyan
 */
$messages['zh-hans'] = array(
	'inputbox-desc' => '允许包含预先设置的HTML表格',
	'inputbox-error-no-type' => '您没有指定所创建输入框的类型。',
	'inputbox-error-bad-type' => '输入框类型“$1”无法识别。
请指定“create”、“comment”、“search”、“search2”或“fulltext”。',
	'tryexact' => '尝试精确匹配',
	'searchfulltext' => '搜索全文',
	'createarticle' => '创建页面',
	'inputbox-ns-main' => '主',
);

/** Traditional Chinese (‪中文(繁體)‬)
 * @author Anakmalaysia
 * @author Gaoxuewei
 * @author Liangent
 * @author Mark85296341
 */
$messages['zh-hant'] = array(
	'inputbox-desc' => '容許包含預先設定的 HTML 表格',
	'inputbox-error-no-type' => '您尚未指定建立輸入框的指定類型。',
	'inputbox-error-bad-type' => '輸入框類型「$1」無法識別。
請指定「create」、「comment」、「search」、「search2」或「fulltext」。',
	'tryexact' => '嘗試精確匹配',
	'searchfulltext' => '全文檢索',
	'createarticle' => '建立文章',
	'inputbox-ns-main' => '主',
);

/** Chinese (Taiwan) (‪中文(台灣)‬)
 * @author Ffaarr
 */
$messages['zh-tw'] = array(
	'createarticle' => '創建頁面',
);

/** Zulu (isiZulu) */
$messages['zu'] = array(
	'searchfulltext' => 'Sesha ukubhala konke',
);

