/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jorbis;

import com.jcraft.jogg.Buffer;
import com.jcraft.jogg.Packet;

public class Comment {
    private static byte[] _vorbis = "vorbis".getBytes();
    private static final int OV_EFAULT = -129;
    private static final int OV_EIMPL = -130;
    public byte[][] user_comments;
    public int[] comment_lengths;
    public int comments;
    public byte[] vendor;

    public void init() {
        this.user_comments = null;
        this.comments = 0;
        this.vendor = null;
    }

    public void add(String string) {
        this.add(string.getBytes());
    }

    private void add(byte[] byArray) {
        byte[][] byArray2 = new byte[this.comments + 2][];
        if (this.user_comments != null) {
            System.arraycopy(this.user_comments, 0, byArray2, 0, this.comments);
        }
        this.user_comments = byArray2;
        int[] nArray = new int[this.comments + 2];
        if (this.comment_lengths != null) {
            System.arraycopy(this.comment_lengths, 0, nArray, 0, this.comments);
        }
        this.comment_lengths = nArray;
        byte[] byArray3 = new byte[byArray.length + 1];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        this.user_comments[this.comments] = byArray3;
        this.comment_lengths[this.comments] = byArray.length;
        ++this.comments;
        this.user_comments[this.comments] = null;
    }

    public void add_tag(String string, String string2) {
        if (string2 == null) {
            string2 = "";
        }
        this.add(String.valueOf(string) + "=" + string2);
    }

    static boolean tagcompare(byte[] byArray, byte[] byArray2, int n) {
        int n2 = 0;
        while (n2 < n) {
            byte by = byArray[n2];
            byte by2 = byArray2[n2];
            if (by >= 65) {
                by = (byte)(by - 65 + 97);
            }
            if (by2 >= 65) {
                by2 = (byte)(by2 - 65 + 97);
            }
            if (by != by2) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public String query(String string) {
        return this.query(string, 0);
    }

    public String query(String string, int n) {
        int n2 = this.query(string.getBytes(), n);
        if (n2 == -1) {
            return null;
        }
        byte[] byArray = this.user_comments[n2];
        int n3 = 0;
        while (n3 < this.comment_lengths[n2]) {
            if (byArray[n3] == 61) {
                return new String(byArray, n3 + 1, this.comment_lengths[n2] - (n3 + 1));
            }
            ++n3;
        }
        return null;
    }

    private int query(byte[] byArray, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = byArray.length;
        byte[] byArray2 = new byte[n4 + 2];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byArray2[byArray.length] = 61;
        n2 = 0;
        while (n2 < this.comments) {
            if (Comment.tagcompare(this.user_comments[n2], byArray2, n4)) {
                if (n == n3) {
                    return n2;
                }
                ++n3;
            }
            ++n2;
        }
        return -1;
    }

    int unpack(Buffer buffer) {
        int n = buffer.read(32);
        if (n < 0) {
            this.clear();
            return -1;
        }
        this.vendor = new byte[n + 1];
        buffer.read(this.vendor, n);
        this.comments = buffer.read(32);
        if (this.comments < 0) {
            this.clear();
            return -1;
        }
        this.user_comments = new byte[this.comments + 1][];
        this.comment_lengths = new int[this.comments + 1];
        int n2 = 0;
        while (n2 < this.comments) {
            int n3 = buffer.read(32);
            if (n3 < 0) {
                this.clear();
                return -1;
            }
            this.comment_lengths[n2] = n3;
            this.user_comments[n2] = new byte[n3 + 1];
            buffer.read(this.user_comments[n2], n3);
            ++n2;
        }
        if (buffer.read(1) != 1) {
            this.clear();
            return -1;
        }
        return 0;
    }

    int pack(Buffer buffer) {
        byte[] byArray = "Xiphophorus libVorbis I 20000508".getBytes();
        buffer.write(3, 8);
        buffer.write(_vorbis);
        buffer.write(byArray.length, 32);
        buffer.write(byArray);
        buffer.write(this.comments, 32);
        if (this.comments != 0) {
            int n = 0;
            while (n < this.comments) {
                if (this.user_comments[n] != null) {
                    buffer.write(this.comment_lengths[n], 32);
                    buffer.write(this.user_comments[n]);
                } else {
                    buffer.write(0, 32);
                }
                ++n;
            }
        }
        buffer.write(1, 1);
        return 0;
    }

    public int header_out(Packet packet) {
        Buffer buffer = new Buffer();
        buffer.writeinit();
        if (this.pack(buffer) != 0) {
            return -130;
        }
        packet.packet_base = new byte[buffer.bytes()];
        packet.packet = 0;
        packet.bytes = buffer.bytes();
        System.arraycopy(buffer.buffer(), 0, packet.packet_base, 0, packet.bytes);
        packet.b_o_s = 0;
        packet.e_o_s = 0;
        packet.granulepos = 0L;
        return 0;
    }

    void clear() {
        int n = 0;
        while (n < this.comments) {
            this.user_comments[n] = null;
            ++n;
        }
        this.user_comments = null;
        this.vendor = null;
    }

    public String getVendor() {
        return new String(this.vendor, 0, this.vendor.length - 1);
    }

    public String getComment(int n) {
        if (this.comments <= n) {
            return null;
        }
        return new String(this.user_comments[n], 0, this.user_comments[n].length - 1);
    }

    public String toString() {
        String string = "Vendor: " + new String(this.vendor, 0, this.vendor.length - 1);
        int n = 0;
        while (n < this.comments) {
            string = String.valueOf(string) + "\nComment: " + new String(this.user_comments[n], 0, this.user_comments[n].length - 1);
            ++n;
        }
        string = String.valueOf(string) + "\n";
        return string;
    }
}

