<?php
/**
 * Simple 1:1 upper/lowercase switching arrays for utf-8 text
 * Won't get context-sensitive things yet
 *
 * Hack for bugs in ucfirst() and company
 *
 * These are pulled from memcached if possible, as this is faster than filling
 * up a big array manually.
 * @package MediaWiki
 * @subpackage Language
 */

/*
 * Translation array to get upper case character
 */
$wikiUpperChars = array(
	"a" => "A",
	"b" => "B",
	"c" => "C",
	"d" => "D",
	"e" => "E",
	"f" => "F",
	"g" => "G",
	"h" => "H",
	"i" => "I",
	"j" => "J",
	"k" => "K",
	"l" => "L",
	"m" => "M",
	"n" => "N",
	"o" => "O",
	"p" => "P",
	"q" => "Q",
	"r" => "R",
	"s" => "S",
	"t" => "T",
	"u" => "U",
	"v" => "V",
	"w" => "W",
	"x" => "X",
	"y" => "Y",
	"z" => "Z",
	"\xc2\xb5" => "\xce\x9c",
	"\xc3\xa0" => "\xc3\x80",
	"\xc3\xa1" => "\xc3\x81",
	"\xc3\xa2" => "\xc3\x82",
	"\xc3\xa3" => "\xc3\x83",
	"\xc3\xa4" => "\xc3\x84",
	"\xc3\xa5" => "\xc3\x85",
	"\xc3\xa6" => "\xc3\x86",
	"\xc3\xa7" => "\xc3\x87",
	"\xc3\xa8" => "\xc3\x88",
	"\xc3\xa9" => "\xc3\x89",
	"\xc3\xaa" => "\xc3\x8a",
	"\xc3\xab" => "\xc3\x8b",
	"\xc3\xac" => "\xc3\x8c",
	"\xc3\xad" => "\xc3\x8d",
	"\xc3\xae" => "\xc3\x8e",
	"\xc3\xaf" => "\xc3\x8f",
	"\xc3\xb0" => "\xc3\x90",
	"\xc3\xb1" => "\xc3\x91",
	"\xc3\xb2" => "\xc3\x92",
	"\xc3\xb3" => "\xc3\x93",
	"\xc3\xb4" => "\xc3\x94",
	"\xc3\xb5" => "\xc3\x95",
	"\xc3\xb6" => "\xc3\x96",
	"\xc3\xb8" => "\xc3\x98",
	"\xc3\xb9" => "\xc3\x99",
	"\xc3\xba" => "\xc3\x9a",
	"\xc3\xbb" => "\xc3\x9b",
	"\xc3\xbc" => "\xc3\x9c",
	"\xc3\xbd" => "\xc3\x9d",
	"\xc3\xbe" => "\xc3\x9e",
	"\xc3\xbf" => "\xc5\xb8",
	"\xc4\x81" => "\xc4\x80",
	"\xc4\x83" => "\xc4\x82",
	"\xc4\x85" => "\xc4\x84",
	"\xc4\x87" => "\xc4\x86",
	"\xc4\x89" => "\xc4\x88",
	"\xc4\x8b" => "\xc4\x8a",
	"\xc4\x8d" => "\xc4\x8c",
	"\xc4\x8f" => "\xc4\x8e",
	"\xc4\x91" => "\xc4\x90",
	"\xc4\x93" => "\xc4\x92",
	"\xc4\x95" => "\xc4\x94",
	"\xc4\x97" => "\xc4\x96",
	"\xc4\x99" => "\xc4\x98",
	"\xc4\x9b" => "\xc4\x9a",
	"\xc4\x9d" => "\xc4\x9c",
	"\xc4\x9f" => "\xc4\x9e",
	"\xc4\xa1" => "\xc4\xa0",
	"\xc4\xa3" => "\xc4\xa2",
	"\xc4\xa5" => "\xc4\xa4",
	"\xc4\xa7" => "\xc4\xa6",
	"\xc4\xa9" => "\xc4\xa8",
	"\xc4\xab" => "\xc4\xaa",
	"\xc4\xad" => "\xc4\xac",
	"\xc4\xaf" => "\xc4\xae",
	"\xc4\xb1" => "I",
	"\xc4\xb3" => "\xc4\xb2",
	"\xc4\xb5" => "\xc4\xb4",
	"\xc4\xb7" => "\xc4\xb6",
	"\xc4\xba" => "\xc4\xb9",
	"\xc4\xbc" => "\xc4\xbb",
	"\xc4\xbe" => "\xc4\xbd",
	"\xc5\x80" => "\xc4\xbf",
	"\xc5\x82" => "\xc5\x81",
	"\xc5\x84" => "\xc5\x83",
	"\xc5\x86" => "\xc5\x85",
	"\xc5\x88" => "\xc5\x87",
	"\xc5\x8b" => "\xc5\x8a",
	"\xc5\x8d" => "\xc5\x8c",
	"\xc5\x8f" => "\xc5\x8e",
	"\xc5\x91" => "\xc5\x90",
	"\xc5\x93" => "\xc5\x92",
	"\xc5\x95" => "\xc5\x94",
	"\xc5\x97" => "\xc5\x96",
	"\xc5\x99" => "\xc5\x98",
	"\xc5\x9b" => "\xc5\x9a",
	"\xc5\x9d" => "\xc5\x9c",
	"\xc5\x9f" => "\xc5\x9e",
	"\xc5\xa1" => "\xc5\xa0",
	"\xc5\xa3" => "\xc5\xa2",
	"\xc5\xa5" => "\xc5\xa4",
	"\xc5\xa7" => "\xc5\xa6",
	"\xc5\xa9" => "\xc5\xa8",
	"\xc5\xab" => "\xc5\xaa",
	"\xc5\xad" => "\xc5\xac",
	"\xc5\xaf" => "\xc5\xae",
	"\xc5\xb1" => "\xc5\xb0",
	"\xc5\xb3" => "\xc5\xb2",
	"\xc5\xb5" => "\xc5\xb4",
	"\xc5\xb7" => "\xc5\xb6",
	"\xc5\xba" => "\xc5\xb9",
	"\xc5\xbc" => "\xc5\xbb",
	"\xc5\xbe" => "\xc5\xbd",
	"\xc5\xbf" => "S",
	"\xc6\x83" => "\xc6\x82",
	"\xc6\x85" => "\xc6\x84",
	"\xc6\x88" => "\xc6\x87",
	"\xc6\x8c" => "\xc6\x8b",
	"\xc6\x92" => "\xc6\x91",
	"\xc6\x95" => "\xc7\xb6",
	"\xc6\x99" => "\xc6\x98",
	"\xc6\xa1" => "\xc6\xa0",
	"\xc6\xa3" => "\xc6\xa2",
	"\xc6\xa5" => "\xc6\xa4",
	"\xc6\xa8" => "\xc6\xa7",
	"\xc6\xad" => "\xc6\xac",
	"\xc6\xb0" => "\xc6\xaf",
	"\xc6\xb4" => "\xc6\xb3",
	"\xc6\xb6" => "\xc6\xb5",
	"\xc6\xb9" => "\xc6\xb8",
	"\xc6\xbd" => "\xc6\xbc",
	"\xc6\xbf" => "\xc7\xb7",
	"\xc7\x85" => "\xc7\x84",
	"\xc7\x86" => "\xc7\x84",
	"\xc7\x88" => "\xc7\x87",
	"\xc7\x89" => "\xc7\x87",
	"\xc7\x8b" => "\xc7\x8a",
	"\xc7\x8c" => "\xc7\x8a",
	"\xc7\x8e" => "\xc7\x8d",
	"\xc7\x90" => "\xc7\x8f",
	"\xc7\x92" => "\xc7\x91",
	"\xc7\x94" => "\xc7\x93",
	"\xc7\x96" => "\xc7\x95",
	"\xc7\x98" => "\xc7\x97",
	"\xc7\x9a" => "\xc7\x99",
	"\xc7\x9c" => "\xc7\x9b",
	"\xc7\x9d" => "\xc6\x8e",
	"\xc7\x9f" => "\xc7\x9e",
	"\xc7\xa1" => "\xc7\xa0",
	"\xc7\xa3" => "\xc7\xa2",
	"\xc7\xa5" => "\xc7\xa4",
	"\xc7\xa7" => "\xc7\xa6",
	"\xc7\xa9" => "\xc7\xa8",
	"\xc7\xab" => "\xc7\xaa",
	"\xc7\xad" => "\xc7\xac",
	"\xc7\xaf" => "\xc7\xae",
	"\xc7\xb2" => "\xc7\xb1",
	"\xc7\xb3" => "\xc7\xb1",
	"\xc7\xb5" => "\xc7\xb4",
	"\xc7\xb9" => "\xc7\xb8",
	"\xc7\xbb" => "\xc7\xba",
	"\xc7\xbd" => "\xc7\xbc",
	"\xc7\xbf" => "\xc7\xbe",
	"\xc8\x81" => "\xc8\x80",
	"\xc8\x83" => "\xc8\x82",
	"\xc8\x85" => "\xc8\x84",
	"\xc8\x87" => "\xc8\x86",
	"\xc8\x89" => "\xc8\x88",
	"\xc8\x8b" => "\xc8\x8a",
	"\xc8\x8d" => "\xc8\x8c",
	"\xc8\x8f" => "\xc8\x8e",
	"\xc8\x91" => "\xc8\x90",
	"\xc8\x93" => "\xc8\x92",
	"\xc8\x95" => "\xc8\x94",
	"\xc8\x97" => "\xc8\x96",
	"\xc8\x99" => "\xc8\x98",
	"\xc8\x9b" => "\xc8\x9a",
	"\xc8\x9d" => "\xc8\x9c",
	"\xc8\x9f" => "\xc8\x9e",
	"\xc8\xa3" => "\xc8\xa2",
	"\xc8\xa5" => "\xc8\xa4",
	"\xc8\xa7" => "\xc8\xa6",
	"\xc8\xa9" => "\xc8\xa8",
	"\xc8\xab" => "\xc8\xaa",
	"\xc8\xad" => "\xc8\xac",
	"\xc8\xaf" => "\xc8\xae",
	"\xc8\xb1" => "\xc8\xb0",
	"\xc8\xb3" => "\xc8\xb2",
	"\xc9\x93" => "\xc6\x81",
	"\xc9\x94" => "\xc6\x86",
	"\xc9\x96" => "\xc6\x89",
	"\xc9\x97" => "\xc6\x8a",
	"\xc9\x99" => "\xc6\x8f",
	"\xc9\x9b" => "\xc6\x90",
	"\xc9\xa0" => "\xc6\x93",
	"\xc9\xa3" => "\xc6\x94",
	"\xc9\xa8" => "\xc6\x97",
	"\xc9\xa9" => "\xc6\x96",
	"\xc9\xaf" => "\xc6\x9c",
	"\xc9\xb2" => "\xc6\x9d",
	"\xc9\xb5" => "\xc6\x9f",
	"\xca\x80" => "\xc6\xa6",
	"\xca\x83" => "\xc6\xa9",
	"\xca\x88" => "\xc6\xae",
	"\xca\x8a" => "\xc6\xb1",
	"\xca\x8b" => "\xc6\xb2",
	"\xca\x92" => "\xc6\xb7",
	"\xcd\x85" => "\xce\x99",
	"\xce\xac" => "\xce\x86",
	"\xce\xad" => "\xce\x88",
	"\xce\xae" => "\xce\x89",
	"\xce\xaf" => "\xce\x8a",
	"\xce\xb1" => "\xce\x91",
	"\xce\xb2" => "\xce\x92",
	"\xce\xb3" => "\xce\x93",
	"\xce\xb4" => "\xce\x94",
	"\xce\xb5" => "\xce\x95",
	"\xce\xb6" => "\xce\x96",
	"\xce\xb7" => "\xce\x97",
	"\xce\xb8" => "\xce\x98",
	"\xce\xb9" => "\xce\x99",
	"\xce\xba" => "\xce\x9a",
	"\xce\xbb" => "\xce\x9b",
	"\xce\xbc" => "\xce\x9c",
	"\xce\xbd" => "\xce\x9d",
	"\xce\xbe" => "\xce\x9e",
	"\xce\xbf" => "\xce\x9f",
	"\xcf\x80" => "\xce\xa0",
	"\xcf\x81" => "\xce\xa1",
	"\xcf\x82" => "\xce\xa3",
	"\xcf\x83" => "\xce\xa3",
	"\xcf\x84" => "\xce\xa4",
	"\xcf\x85" => "\xce\xa5",
	"\xcf\x86" => "\xce\xa6",
	"\xcf\x87" => "\xce\xa7",
	"\xcf\x88" => "\xce\xa8",
	"\xcf\x89" => "\xce\xa9",
	"\xcf\x8a" => "\xce\xaa",
	"\xcf\x8b" => "\xce\xab",
	"\xcf\x8c" => "\xce\x8c",
	"\xcf\x8d" => "\xce\x8e",
	"\xcf\x8e" => "\xce\x8f",
	"\xcf\x90" => "\xce\x92",
	"\xcf\x91" => "\xce\x98",
	"\xcf\x95" => "\xce\xa6",
	"\xcf\x96" => "\xce\xa0",
	"\xcf\x9b" => "\xcf\x9a",
	"\xcf\x9d" => "\xcf\x9c",
	"\xcf\x9f" => "\xcf\x9e",
	"\xcf\xa1" => "\xcf\xa0",
	"\xcf\xa3" => "\xcf\xa2",
	"\xcf\xa5" => "\xcf\xa4",
	"\xcf\xa7" => "\xcf\xa6",
	"\xcf\xa9" => "\xcf\xa8",
	"\xcf\xab" => "\xcf\xaa",
	"\xcf\xad" => "\xcf\xac",
	"\xcf\xaf" => "\xcf\xae",
	"\xcf\xb0" => "\xce\x9a",
	"\xcf\xb1" => "\xce\xa1",
	"\xcf\xb2" => "\xce\xa3",
	"\xcf\xb5" => "\xce\x95",
	"\xd0\xb0" => "\xd0\x90",
	"\xd0\xb1" => "\xd0\x91",
	"\xd0\xb2" => "\xd0\x92",
	"\xd0\xb3" => "\xd0\x93",
	"\xd0\xb4" => "\xd0\x94",
	"\xd0\xb5" => "\xd0\x95",
	"\xd0\xb6" => "\xd0\x96",
	"\xd0\xb7" => "\xd0\x97",
	"\xd0\xb8" => "\xd0\x98",
	"\xd0\xb9" => "\xd0\x99",
	"\xd0\xba" => "\xd0\x9a",
	"\xd0\xbb" => "\xd0\x9b",
	"\xd0\xbc" => "\xd0\x9c",
	"\xd0\xbd" => "\xd0\x9d",
	"\xd0\xbe" => "\xd0\x9e",
	"\xd0\xbf" => "\xd0\x9f",
	"\xd1\x80" => "\xd0\xa0",
	"\xd1\x81" => "\xd0\xa1",
	"\xd1\x82" => "\xd0\xa2",
	"\xd1\x83" => "\xd0\xa3",
	"\xd1\x84" => "\xd0\xa4",
	"\xd1\x85" => "\xd0\xa5",
	"\xd1\x86" => "\xd0\xa6",
	"\xd1\x87" => "\xd0\xa7",
	"\xd1\x88" => "\xd0\xa8",
	"\xd1\x89" => "\xd0\xa9",
	"\xd1\x8a" => "\xd0\xaa",
	"\xd1\x8b" => "\xd0\xab",
	"\xd1\x8c" => "\xd0\xac",
	"\xd1\x8d" => "\xd0\xad",
	"\xd1\x8e" => "\xd0\xae",
	"\xd1\x8f" => "\xd0\xaf",
	"\xd1\x90" => "\xd0\x80",
	"\xd1\x91" => "\xd0\x81",
	"\xd1\x92" => "\xd0\x82",
	"\xd1\x93" => "\xd0\x83",
	"\xd1\x94" => "\xd0\x84",
	"\xd1\x95" => "\xd0\x85",
	"\xd1\x96" => "\xd0\x86",
	"\xd1\x97" => "\xd0\x87",
	"\xd1\x98" => "\xd0\x88",
	"\xd1\x99" => "\xd0\x89",
	"\xd1\x9a" => "\xd0\x8a",
	"\xd1\x9b" => "\xd0\x8b",
	"\xd1\x9c" => "\xd0\x8c",
	"\xd1\x9d" => "\xd0\x8d",
	"\xd1\x9e" => "\xd0\x8e",
	"\xd1\x9f" => "\xd0\x8f",
	"\xd1\xa1" => "\xd1\xa0",
	"\xd1\xa3" => "\xd1\xa2",
	"\xd1\xa5" => "\xd1\xa4",
	"\xd1\xa7" => "\xd1\xa6",
	"\xd1\xa9" => "\xd1\xa8",
	"\xd1\xab" => "\xd1\xaa",
	"\xd1\xad" => "\xd1\xac",
	"\xd1\xaf" => "\xd1\xae",
	"\xd1\xb1" => "\xd1\xb0",
	"\xd1\xb3" => "\xd1\xb2",
	"\xd1\xb5" => "\xd1\xb4",
	"\xd1\xb7" => "\xd1\xb6",
	"\xd1\xb9" => "\xd1\xb8",
	"\xd1\xbb" => "\xd1\xba",
	"\xd1\xbd" => "\xd1\xbc",
	"\xd1\xbf" => "\xd1\xbe",
	"\xd2\x81" => "\xd2\x80",
	"\xd2\x8d" => "\xd2\x8c",
	"\xd2\x8f" => "\xd2\x8e",
	"\xd2\x91" => "\xd2\x90",
	"\xd2\x93" => "\xd2\x92",
	"\xd2\x95" => "\xd2\x94",
	"\xd2\x97" => "\xd2\x96",
	"\xd2\x99" => "\xd2\x98",
	"\xd2\x9b" => "\xd2\x9a",
	"\xd2\x9d" => "\xd2\x9c",
	"\xd2\x9f" => "\xd2\x9e",
	"\xd2\xa1" => "\xd2\xa0",
	"\xd2\xa3" => "\xd2\xa2",
	"\xd2\xa5" => "\xd2\xa4",
	"\xd2\xa7" => "\xd2\xa6",
	"\xd2\xa9" => "\xd2\xa8",
	"\xd2\xab" => "\xd2\xaa",
	"\xd2\xad" => "\xd2\xac",
	"\xd2\xaf" => "\xd2\xae",
	"\xd2\xb1" => "\xd2\xb0",
	"\xd2\xb3" => "\xd2\xb2",
	"\xd2\xb5" => "\xd2\xb4",
	"\xd2\xb7" => "\xd2\xb6",
	"\xd2\xb9" => "\xd2\xb8",
	"\xd2\xbb" => "\xd2\xba",
	"\xd2\xbd" => "\xd2\xbc",
	"\xd2\xbf" => "\xd2\xbe",
	"\xd3\x82" => "\xd3\x81",
	"\xd3\x84" => "\xd3\x83",
	"\xd3\x88" => "\xd3\x87",
	"\xd3\x8c" => "\xd3\x8b",
	"\xd3\x91" => "\xd3\x90",
	"\xd3\x93" => "\xd3\x92",
	"\xd3\x95" => "\xd3\x94",
	"\xd3\x97" => "\xd3\x96",
	"\xd3\x99" => "\xd3\x98",
	"\xd3\x9b" => "\xd3\x9a",
	"\xd3\x9d" => "\xd3\x9c",
	"\xd3\x9f" => "\xd3\x9e",
	"\xd3\xa1" => "\xd3\xa0",
	"\xd3\xa3" => "\xd3\xa2",
	"\xd3\xa5" => "\xd3\xa4",
	"\xd3\xa7" => "\xd3\xa6",
	"\xd3\xa9" => "\xd3\xa8",
	"\xd3\xab" => "\xd3\xaa",
	"\xd3\xad" => "\xd3\xac",
	"\xd3\xaf" => "\xd3\xae",
	"\xd3\xb1" => "\xd3\xb0",
	"\xd3\xb3" => "\xd3\xb2",
	"\xd3\xb5" => "\xd3\xb4",
	"\xd3\xb9" => "\xd3\xb8",
	"\xd5\xa1" => "\xd4\xb1",
	"\xd5\xa2" => "\xd4\xb2",
	"\xd5\xa3" => "\xd4\xb3",
	"\xd5\xa4" => "\xd4\xb4",
	"\xd5\xa5" => "\xd4\xb5",
	"\xd5\xa6" => "\xd4\xb6",
	"\xd5\xa7" => "\xd4\xb7",
	"\xd5\xa8" => "\xd4\xb8",
	"\xd5\xa9" => "\xd4\xb9",
	"\xd5\xaa" => "\xd4\xba",
	"\xd5\xab" => "\xd4\xbb",
	"\xd5\xac" => "\xd4\xbc",
	"\xd5\xad" => "\xd4\xbd",
	"\xd5\xae" => "\xd4\xbe",
	"\xd5\xaf" => "\xd4\xbf",
	"\xd5\xb0" => "\xd5\x80",
	"\xd5\xb1" => "\xd5\x81",
	"\xd5\xb2" => "\xd5\x82",
	"\xd5\xb3" => "\xd5\x83",
	"\xd5\xb4" => "\xd5\x84",
	"\xd5\xb5" => "\xd5\x85",
	"\xd5\xb6" => "\xd5\x86",
	"\xd5\xb7" => "\xd5\x87",
	"\xd5\xb8" => "\xd5\x88",
	"\xd5\xb9" => "\xd5\x89",
	"\xd5\xba" => "\xd5\x8a",
	"\xd5\xbb" => "\xd5\x8b",
	"\xd5\xbc" => "\xd5\x8c",
	"\xd5\xbd" => "\xd5\x8d",
	"\xd5\xbe" => "\xd5\x8e",
	"\xd5\xbf" => "\xd5\x8f",
	"\xd6\x80" => "\xd5\x90",
	"\xd6\x81" => "\xd5\x91",
	"\xd6\x82" => "\xd5\x92",
	"\xd6\x83" => "\xd5\x93",
	"\xd6\x84" => "\xd5\x94",
	"\xd6\x85" => "\xd5\x95",
	"\xd6\x86" => "\xd5\x96",
	"\xe1\xb8\x81" => "\xe1\xb8\x80",
	"\xe1\xb8\x83" => "\xe1\xb8\x82",
	"\xe1\xb8\x85" => "\xe1\xb8\x84",
	"\xe1\xb8\x87" => "\xe1\xb8\x86",
	"\xe1\xb8\x89" => "\xe1\xb8\x88",
	"\xe1\xb8\x8b" => "\xe1\xb8\x8a",
	"\xe1\xb8\x8d" => "\xe1\xb8\x8c",
	"\xe1\xb8\x8f" => "\xe1\xb8\x8e",
	"\xe1\xb8\x91" => "\xe1\xb8\x90",
	"\xe1\xb8\x93" => "\xe1\xb8\x92",
	"\xe1\xb8\x95" => "\xe1\xb8\x94",
	"\xe1\xb8\x97" => "\xe1\xb8\x96",
	"\xe1\xb8\x99" => "\xe1\xb8\x98",
	"\xe1\xb8\x9b" => "\xe1\xb8\x9a",
	"\xe1\xb8\x9d" => "\xe1\xb8\x9c",
	"\xe1\xb8\x9f" => "\xe1\xb8\x9e",
	"\xe1\xb8\xa1" => "\xe1\xb8\xa0",
	"\xe1\xb8\xa3" => "\xe1\xb8\xa2",
	"\xe1\xb8\xa5" => "\xe1\xb8\xa4",
	"\xe1\xb8\xa7" => "\xe1\xb8\xa6",
	"\xe1\xb8\xa9" => "\xe1\xb8\xa8",
	"\xe1\xb8\xab" => "\xe1\xb8\xaa",
	"\xe1\xb8\xad" => "\xe1\xb8\xac",
	"\xe1\xb8\xaf" => "\xe1\xb8\xae",
	"\xe1\xb8\xb1" => "\xe1\xb8\xb0",
	"\xe1\xb8\xb3" => "\xe1\xb8\xb2",
	"\xe1\xb8\xb5" => "\xe1\xb8\xb4",
	"\xe1\xb8\xb7" => "\xe1\xb8\xb6",
	"\xe1\xb8\xb9" => "\xe1\xb8\xb8",
	"\xe1\xb8\xbb" => "\xe1\xb8\xba",
	"\xe1\xb8\xbd" => "\xe1\xb8\xbc",
	"\xe1\xb8\xbf" => "\xe1\xb8\xbe",
	"\xe1\xb9\x81" => "\xe1\xb9\x80",
	"\xe1\xb9\x83" => "\xe1\xb9\x82",
	"\xe1\xb9\x85" => "\xe1\xb9\x84",
	"\xe1\xb9\x87" => "\xe1\xb9\x86",
	"\xe1\xb9\x89" => "\xe1\xb9\x88",
	"\xe1\xb9\x8b" => "\xe1\xb9\x8a",
	"\xe1\xb9\x8d" => "\xe1\xb9\x8c",
	"\xe1\xb9\x8f" => "\xe1\xb9\x8e",
	"\xe1\xb9\x91" => "\xe1\xb9\x90",
	"\xe1\xb9\x93" => "\xe1\xb9\x92",
	"\xe1\xb9\x95" => "\xe1\xb9\x94",
	"\xe1\xb9\x97" => "\xe1\xb9\x96",
	"\xe1\xb9\x99" => "\xe1\xb9\x98",
	"\xe1\xb9\x9b" => "\xe1\xb9\x9a",
	"\xe1\xb9\x9d" => "\xe1\xb9\x9c",
	"\xe1\xb9\x9f" => "\xe1\xb9\x9e",
	"\xe1\xb9\xa1" => "\xe1\xb9\xa0",
	"\xe1\xb9\xa3" => "\xe1\xb9\xa2",
	"\xe1\xb9\xa5" => "\xe1\xb9\xa4",
	"\xe1\xb9\xa7" => "\xe1\xb9\xa6",
	"\xe1\xb9\xa9" => "\xe1\xb9\xa8",
	"\xe1\xb9\xab" => "\xe1\xb9\xaa",
	"\xe1\xb9\xad" => "\xe1\xb9\xac",
	"\xe1\xb9\xaf" => "\xe1\xb9\xae",
	"\xe1\xb9\xb1" => "\xe1\xb9\xb0",
	"\xe1\xb9\xb3" => "\xe1\xb9\xb2",
	"\xe1\xb9\xb5" => "\xe1\xb9\xb4",
	"\xe1\xb9\xb7" => "\xe1\xb9\xb6",
	"\xe1\xb9\xb9" => "\xe1\xb9\xb8",
	"\xe1\xb9\xbb" => "\xe1\xb9\xba",
	"\xe1\xb9\xbd" => "\xe1\xb9\xbc",
	"\xe1\xb9\xbf" => "\xe1\xb9\xbe",
	"\xe1\xba\x81" => "\xe1\xba\x80",
	"\xe1\xba\x83" => "\xe1\xba\x82",
	"\xe1\xba\x85" => "\xe1\xba\x84",
	"\xe1\xba\x87" => "\xe1\xba\x86",
	"\xe1\xba\x89" => "\xe1\xba\x88",
	"\xe1\xba\x8b" => "\xe1\xba\x8a",
	"\xe1\xba\x8d" => "\xe1\xba\x8c",
	"\xe1\xba\x8f" => "\xe1\xba\x8e",
	"\xe1\xba\x91" => "\xe1\xba\x90",
	"\xe1\xba\x93" => "\xe1\xba\x92",
	"\xe1\xba\x95" => "\xe1\xba\x94",
	"\xe1\xba\x9b" => "\xe1\xb9\xa0",
	"\xe1\xba\xa1" => "\xe1\xba\xa0",
	"\xe1\xba\xa3" => "\xe1\xba\xa2",
	"\xe1\xba\xa5" => "\xe1\xba\xa4",
	"\xe1\xba\xa7" => "\xe1\xba\xa6",
	"\xe1\xba\xa9" => "\xe1\xba\xa8",
	"\xe1\xba\xab" => "\xe1\xba\xaa",
	"\xe1\xba\xad" => "\xe1\xba\xac",
	"\xe1\xba\xaf" => "\xe1\xba\xae",
	"\xe1\xba\xb1" => "\xe1\xba\xb0",
	"\xe1\xba\xb3" => "\xe1\xba\xb2",
	"\xe1\xba\xb5" => "\xe1\xba\xb4",
	"\xe1\xba\xb7" => "\xe1\xba\xb6",
	"\xe1\xba\xb9" => "\xe1\xba\xb8",
	"\xe1\xba\xbb" => "\xe1\xba\xba",
	"\xe1\xba\xbd" => "\xe1\xba\xbc",
	"\xe1\xba\xbf" => "\xe1\xba\xbe",
	"\xe1\xbb\x81" => "\xe1\xbb\x80",
	"\xe1\xbb\x83" => "\xe1\xbb\x82",
	"\xe1\xbb\x85" => "\xe1\xbb\x84",
	"\xe1\xbb\x87" => "\xe1\xbb\x86",
	"\xe1\xbb\x89" => "\xe1\xbb\x88",
	"\xe1\xbb\x8b" => "\xe1\xbb\x8a",
	"\xe1\xbb\x8d" => "\xe1\xbb\x8c",
	"\xe1\xbb\x8f" => "\xe1\xbb\x8e",
	"\xe1\xbb\x91" => "\xe1\xbb\x90",
	"\xe1\xbb\x93" => "\xe1\xbb\x92",
	"\xe1\xbb\x95" => "\xe1\xbb\x94",
	"\xe1\xbb\x97" => "\xe1\xbb\x96",
	"\xe1\xbb\x99" => "\xe1\xbb\x98",
	"\xe1\xbb\x9b" => "\xe1\xbb\x9a",
	"\xe1\xbb\x9d" => "\xe1\xbb\x9c",
	"\xe1\xbb\x9f" => "\xe1\xbb\x9e",
	"\xe1\xbb\xa1" => "\xe1\xbb\xa0",
	"\xe1\xbb\xa3" => "\xe1\xbb\xa2",
	"\xe1\xbb\xa5" => "\xe1\xbb\xa4",
	"\xe1\xbb\xa7" => "\xe1\xbb\xa6",
	"\xe1\xbb\xa9" => "\xe1\xbb\xa8",
	"\xe1\xbb\xab" => "\xe1\xbb\xaa",
	"\xe1\xbb\xad" => "\xe1\xbb\xac",
	"\xe1\xbb\xaf" => "\xe1\xbb\xae",
	"\xe1\xbb\xb1" => "\xe1\xbb\xb0",
	"\xe1\xbb\xb3" => "\xe1\xbb\xb2",
	"\xe1\xbb\xb5" => "\xe1\xbb\xb4",
	"\xe1\xbb\xb7" => "\xe1\xbb\xb6",
	"\xe1\xbb\xb9" => "\xe1\xbb\xb8",
	"\xe1\xbc\x80" => "\xe1\xbc\x88",
	"\xe1\xbc\x81" => "\xe1\xbc\x89",
	"\xe1\xbc\x82" => "\xe1\xbc\x8a",
	"\xe1\xbc\x83" => "\xe1\xbc\x8b",
	"\xe1\xbc\x84" => "\xe1\xbc\x8c",
	"\xe1\xbc\x85" => "\xe1\xbc\x8d",
	"\xe1\xbc\x86" => "\xe1\xbc\x8e",
	"\xe1\xbc\x87" => "\xe1\xbc\x8f",
	"\xe1\xbc\x90" => "\xe1\xbc\x98",
	"\xe1\xbc\x91" => "\xe1\xbc\x99",
	"\xe1\xbc\x92" => "\xe1\xbc\x9a",
	"\xe1\xbc\x93" => "\xe1\xbc\x9b",
	"\xe1\xbc\x94" => "\xe1\xbc\x9c",
	"\xe1\xbc\x95" => "\xe1\xbc\x9d",
	"\xe1\xbc\xa0" => "\xe1\xbc\xa8",
	"\xe1\xbc\xa1" => "\xe1\xbc\xa9",
	"\xe1\xbc\xa2" => "\xe1\xbc\xaa",
	"\xe1\xbc\xa3" => "\xe1\xbc\xab",
	"\xe1\xbc\xa4" => "\xe1\xbc\xac",
	"\xe1\xbc\xa5" => "\xe1\xbc\xad",
	"\xe1\xbc\xa6" => "\xe1\xbc\xae",
	"\xe1\xbc\xa7" => "\xe1\xbc\xaf",
	"\xe1\xbc\xb0" => "\xe1\xbc\xb8",
	"\xe1\xbc\xb1" => "\xe1\xbc\xb9",
	"\xe1\xbc\xb2" => "\xe1\xbc\xba",
	"\xe1\xbc\xb3" => "\xe1\xbc\xbb",
	"\xe1\xbc\xb4" => "\xe1\xbc\xbc",
	"\xe1\xbc\xb5" => "\xe1\xbc\xbd",
	"\xe1\xbc\xb6" => "\xe1\xbc\xbe",
	"\xe1\xbc\xb7" => "\xe1\xbc\xbf",
	"\xe1\xbd\x80" => "\xe1\xbd\x88",
	"\xe1\xbd\x81" => "\xe1\xbd\x89",
	"\xe1\xbd\x82" => "\xe1\xbd\x8a",
	"\xe1\xbd\x83" => "\xe1\xbd\x8b",
	"\xe1\xbd\x84" => "\xe1\xbd\x8c",
	"\xe1\xbd\x85" => "\xe1\xbd\x8d",
	"\xe1\xbd\x91" => "\xe1\xbd\x99",
	"\xe1\xbd\x93" => "\xe1\xbd\x9b",
	"\xe1\xbd\x95" => "\xe1\xbd\x9d",
	"\xe1\xbd\x97" => "\xe1\xbd\x9f",
	"\xe1\xbd\xa0" => "\xe1\xbd\xa8",
	"\xe1\xbd\xa1" => "\xe1\xbd\xa9",
	"\xe1\xbd\xa2" => "\xe1\xbd\xaa",
	"\xe1\xbd\xa3" => "\xe1\xbd\xab",
	"\xe1\xbd\xa4" => "\xe1\xbd\xac",
	"\xe1\xbd\xa5" => "\xe1\xbd\xad",
	"\xe1\xbd\xa6" => "\xe1\xbd\xae",
	"\xe1\xbd\xa7" => "\xe1\xbd\xaf",
	"\xe1\xbd\xb0" => "\xe1\xbe\xba",
	"\xe1\xbd\xb1" => "\xe1\xbe\xbb",
	"\xe1\xbd\xb2" => "\xe1\xbf\x88",
	"\xe1\xbd\xb3" => "\xe1\xbf\x89",
	"\xe1\xbd\xb4" => "\xe1\xbf\x8a",
	"\xe1\xbd\xb5" => "\xe1\xbf\x8b",
	"\xe1\xbd\xb6" => "\xe1\xbf\x9a",
	"\xe1\xbd\xb7" => "\xe1\xbf\x9b",
	"\xe1\xbd\xb8" => "\xe1\xbf\xb8",
	"\xe1\xbd\xb9" => "\xe1\xbf\xb9",
	"\xe1\xbd\xba" => "\xe1\xbf\xaa",
	"\xe1\xbd\xbb" => "\xe1\xbf\xab",
	"\xe1\xbd\xbc" => "\xe1\xbf\xba",
	"\xe1\xbd\xbd" => "\xe1\xbf\xbb",
	"\xe1\xbe\x80" => "\xe1\xbe\x88",
	"\xe1\xbe\x81" => "\xe1\xbe\x89",
	"\xe1\xbe\x82" => "\xe1\xbe\x8a",
	"\xe1\xbe\x83" => "\xe1\xbe\x8b",
	"\xe1\xbe\x84" => "\xe1\xbe\x8c",
	"\xe1\xbe\x85" => "\xe1\xbe\x8d",
	"\xe1\xbe\x86" => "\xe1\xbe\x8e",
	"\xe1\xbe\x87" => "\xe1\xbe\x8f",
	"\xe1\xbe\x90" => "\xe1\xbe\x98",
	"\xe1\xbe\x91" => "\xe1\xbe\x99",
	"\xe1\xbe\x92" => "\xe1\xbe\x9a",
	"\xe1\xbe\x93" => "\xe1\xbe\x9b",
	"\xe1\xbe\x94" => "\xe1\xbe\x9c",
	"\xe1\xbe\x95" => "\xe1\xbe\x9d",
	"\xe1\xbe\x96" => "\xe1\xbe\x9e",
	"\xe1\xbe\x97" => "\xe1\xbe\x9f",
	"\xe1\xbe\xa0" => "\xe1\xbe\xa8",
	"\xe1\xbe\xa1" => "\xe1\xbe\xa9",
	"\xe1\xbe\xa2" => "\xe1\xbe\xaa",
	"\xe1\xbe\xa3" => "\xe1\xbe\xab",
	"\xe1\xbe\xa4" => "\xe1\xbe\xac",
	"\xe1\xbe\xa5" => "\xe1\xbe\xad",
	"\xe1\xbe\xa6" => "\xe1\xbe\xae",
	"\xe1\xbe\xa7" => "\xe1\xbe\xaf",
	"\xe1\xbe\xb0" => "\xe1\xbe\xb8",
	"\xe1\xbe\xb1" => "\xe1\xbe\xb9",
	"\xe1\xbe\xb3" => "\xe1\xbe\xbc",
	"\xe1\xbe\xbe" => "\xce\x99",
	"\xe1\xbf\x83" => "\xe1\xbf\x8c",
	"\xe1\xbf\x90" => "\xe1\xbf\x98",
	"\xe1\xbf\x91" => "\xe1\xbf\x99",
	"\xe1\xbf\xa0" => "\xe1\xbf\xa8",
	"\xe1\xbf\xa1" => "\xe1\xbf\xa9",
	"\xe1\xbf\xa5" => "\xe1\xbf\xac",
	"\xe1\xbf\xb3" => "\xe1\xbf\xbc",
	"\xe2\x85\xb0" => "\xe2\x85\xa0",
	"\xe2\x85\xb1" => "\xe2\x85\xa1",
	"\xe2\x85\xb2" => "\xe2\x85\xa2",
	"\xe2\x85\xb3" => "\xe2\x85\xa3",
	"\xe2\x85\xb4" => "\xe2\x85\xa4",
	"\xe2\x85\xb5" => "\xe2\x85\xa5",
	"\xe2\x85\xb6" => "\xe2\x85\xa6",
	"\xe2\x85\xb7" => "\xe2\x85\xa7",
	"\xe2\x85\xb8" => "\xe2\x85\xa8",
	"\xe2\x85\xb9" => "\xe2\x85\xa9",
	"\xe2\x85\xba" => "\xe2\x85\xaa",
	"\xe2\x85\xbb" => "\xe2\x85\xab",
	"\xe2\x85\xbc" => "\xe2\x85\xac",
	"\xe2\x85\xbd" => "\xe2\x85\xad",
	"\xe2\x85\xbe" => "\xe2\x85\xae",
	"\xe2\x85\xbf" => "\xe2\x85\xaf",
	"\xe2\x93\x90" => "\xe2\x92\xb6",
	"\xe2\x93\x91" => "\xe2\x92\xb7",
	"\xe2\x93\x92" => "\xe2\x92\xb8",
	"\xe2\x93\x93" => "\xe2\x92\xb9",
	"\xe2\x93\x94" => "\xe2\x92\xba",
	"\xe2\x93\x95" => "\xe2\x92\xbb",
	"\xe2\x93\x96" => "\xe2\x92\xbc",
	"\xe2\x93\x97" => "\xe2\x92\xbd",
	"\xe2\x93\x98" => "\xe2\x92\xbe",
	"\xe2\x93\x99" => "\xe2\x92\xbf",
	"\xe2\x93\x9a" => "\xe2\x93\x80",
	"\xe2\x93\x9b" => "\xe2\x93\x81",
	"\xe2\x93\x9c" => "\xe2\x93\x82",
	"\xe2\x93\x9d" => "\xe2\x93\x83",
	"\xe2\x93\x9e" => "\xe2\x93\x84",
	"\xe2\x93\x9f" => "\xe2\x93\x85",
	"\xe2\x93\xa0" => "\xe2\x93\x86",
	"\xe2\x93\xa1" => "\xe2\x93\x87",
	"\xe2\x93\xa2" => "\xe2\x93\x88",
	"\xe2\x93\xa3" => "\xe2\x93\x89",
	"\xe2\x93\xa4" => "\xe2\x93\x8a",
	"\xe2\x93\xa5" => "\xe2\x93\x8b",
	"\xe2\x93\xa6" => "\xe2\x93\x8c",
	"\xe2\x93\xa7" => "\xe2\x93\x8d",
	"\xe2\x93\xa8" => "\xe2\x93\x8e",
	"\xe2\x93\xa9" => "\xe2\x93\x8f",
	"\xef\xbd\x81" => "\xef\xbc\xa1",
	"\xef\xbd\x82" => "\xef\xbc\xa2",
	"\xef\xbd\x83" => "\xef\xbc\xa3",
	"\xef\xbd\x84" => "\xef\xbc\xa4",
	"\xef\xbd\x85" => "\xef\xbc\xa5",
	"\xef\xbd\x86" => "\xef\xbc\xa6",
	"\xef\xbd\x87" => "\xef\xbc\xa7",
	"\xef\xbd\x88" => "\xef\xbc\xa8",
	"\xef\xbd\x89" => "\xef\xbc\xa9",
	"\xef\xbd\x8a" => "\xef\xbc\xaa",
	"\xef\xbd\x8b" => "\xef\xbc\xab",
	"\xef\xbd\x8c" => "\xef\xbc\xac",
	"\xef\xbd\x8d" => "\xef\xbc\xad",
	"\xef\xbd\x8e" => "\xef\xbc\xae",
	"\xef\xbd\x8f" => "\xef\xbc\xaf",
	"\xef\xbd\x90" => "\xef\xbc\xb0",
	"\xef\xbd\x91" => "\xef\xbc\xb1",
	"\xef\xbd\x92" => "\xef\xbc\xb2",
	"\xef\xbd\x93" => "\xef\xbc\xb3",
	"\xef\xbd\x94" => "\xef\xbc\xb4",
	"\xef\xbd\x95" => "\xef\xbc\xb5",
	"\xef\xbd\x96" => "\xef\xbc\xb6",
	"\xef\xbd\x97" => "\xef\xbc\xb7",
	"\xef\xbd\x98" => "\xef\xbc\xb8",
	"\xef\xbd\x99" => "\xef\xbc\xb9",
	"\xef\xbd\x9a" => "\xef\xbc\xba",
	"\xf0\x90\x90\xa8" => "\xf0\x90\x90\x80",
	"\xf0\x90\x90\xa9" => "\xf0\x90\x90\x81",
	"\xf0\x90\x90\xaa" => "\xf0\x90\x90\x82",
	"\xf0\x90\x90\xab" => "\xf0\x90\x90\x83",
	"\xf0\x90\x90\xac" => "\xf0\x90\x90\x84",
	"\xf0\x90\x90\xad" => "\xf0\x90\x90\x85",
	"\xf0\x90\x90\xae" => "\xf0\x90\x90\x86",
	"\xf0\x90\x90\xaf" => "\xf0\x90\x90\x87",
	"\xf0\x90\x90\xb0" => "\xf0\x90\x90\x88",
	"\xf0\x90\x90\xb1" => "\xf0\x90\x90\x89",
	"\xf0\x90\x90\xb2" => "\xf0\x90\x90\x8a",
	"\xf0\x90\x90\xb3" => "\xf0\x90\x90\x8b",
	"\xf0\x90\x90\xb4" => "\xf0\x90\x90\x8c",
	"\xf0\x90\x90\xb5" => "\xf0\x90\x90\x8d",
	"\xf0\x90\x90\xb6" => "\xf0\x90\x90\x8e",
	"\xf0\x90\x90\xb7" => "\xf0\x90\x90\x8f",
	"\xf0\x90\x90\xb8" => "\xf0\x90\x90\x90",
	"\xf0\x90\x90\xb9" => "\xf0\x90\x90\x91",
	"\xf0\x90\x90\xba" => "\xf0\x90\x90\x92",
	"\xf0\x90\x90\xbb" => "\xf0\x90\x90\x93",
	"\xf0\x90\x90\xbc" => "\xf0\x90\x90\x94",
	"\xf0\x90\x90\xbd" => "\xf0\x90\x90\x95",
	"\xf0\x90\x90\xbe" => "\xf0\x90\x90\x96",
	"\xf0\x90\x90\xbf" => "\xf0\x90\x90\x97",
	"\xf0\x90\x91\x80" => "\xf0\x90\x90\x98",
	"\xf0\x90\x91\x81" => "\xf0\x90\x90\x99",
	"\xf0\x90\x91\x82" => "\xf0\x90\x90\x9a",
	"\xf0\x90\x91\x83" => "\xf0\x90\x90\x9b",
	"\xf0\x90\x91\x84" => "\xf0\x90\x90\x9c",
	"\xf0\x90\x91\x85" => "\xf0\x90\x90\x9d",
	"\xf0\x90\x91\x86" => "\xf0\x90\x90\x9e",
	"\xf0\x90\x91\x87" => "\xf0\x90\x90\x9f",
	"\xf0\x90\x91\x88" => "\xf0\x90\x90\xa0",
	"\xf0\x90\x91\x89" => "\xf0\x90\x90\xa1",
	"\xf0\x90\x91\x8a" => "\xf0\x90\x90\xa2",
	"\xf0\x90\x91\x8b" => "\xf0\x90\x90\xa3",
	"\xf0\x90\x91\x8c" => "\xf0\x90\x90\xa4",
	"\xf0\x90\x91\x8d" => "\xf0\x90\x90\xa5"
);

/*
 * Translation array to get lower case character
 */
$wikiLowerChars = array (
	"A" => "a",
	"B" => "b",
	"C" => "c",
	"D" => "d",
	"E" => "e",
	"F" => "f",
	"G" => "g",
	"H" => "h",
	"I" => "i",
	"J" => "j",
	"K" => "k",
	"L" => "l",
	"M" => "m",
	"N" => "n",
	"O" => "o",
	"P" => "p",
	"Q" => "q",
	"R" => "r",
	"S" => "s",
	"T" => "t",
	"U" => "u",
	"V" => "v",
	"W" => "w",
	"X" => "x",
	"Y" => "y",
	"Z" => "z",
	"\xc3\x80" => "\xc3\xa0",
	"\xc3\x81" => "\xc3\xa1",
	"\xc3\x82" => "\xc3\xa2",
	"\xc3\x83" => "\xc3\xa3",
	"\xc3\x84" => "\xc3\xa4",
	"\xc3\x85" => "\xc3\xa5",
	"\xc3\x86" => "\xc3\xa6",
	"\xc3\x87" => "\xc3\xa7",
	"\xc3\x88" => "\xc3\xa8",
	"\xc3\x89" => "\xc3\xa9",
	"\xc3\x8a" => "\xc3\xaa",
	"\xc3\x8b" => "\xc3\xab",
	"\xc3\x8c" => "\xc3\xac",
	"\xc3\x8d" => "\xc3\xad",
	"\xc3\x8e" => "\xc3\xae",
	"\xc3\x8f" => "\xc3\xaf",
	"\xc3\x90" => "\xc3\xb0",
	"\xc3\x91" => "\xc3\xb1",
	"\xc3\x92" => "\xc3\xb2",
	"\xc3\x93" => "\xc3\xb3",
	"\xc3\x94" => "\xc3\xb4",
	"\xc3\x95" => "\xc3\xb5",
	"\xc3\x96" => "\xc3\xb6",
	"\xc3\x98" => "\xc3\xb8",
	"\xc3\x99" => "\xc3\xb9",
	"\xc3\x9a" => "\xc3\xba",
	"\xc3\x9b" => "\xc3\xbb",
	"\xc3\x9c" => "\xc3\xbc",
	"\xc3\x9d" => "\xc3\xbd",
	"\xc3\x9e" => "\xc3\xbe",
	"\xc4\x80" => "\xc4\x81",
	"\xc4\x82" => "\xc4\x83",
	"\xc4\x84" => "\xc4\x85",
	"\xc4\x86" => "\xc4\x87",
	"\xc4\x88" => "\xc4\x89",
	"\xc4\x8a" => "\xc4\x8b",
	"\xc4\x8c" => "\xc4\x8d",
	"\xc4\x8e" => "\xc4\x8f",
	"\xc4\x90" => "\xc4\x91",
	"\xc4\x92" => "\xc4\x93",
	"\xc4\x94" => "\xc4\x95",
	"\xc4\x96" => "\xc4\x97",
	"\xc4\x98" => "\xc4\x99",
	"\xc4\x9a" => "\xc4\x9b",
	"\xc4\x9c" => "\xc4\x9d",
	"\xc4\x9e" => "\xc4\x9f",
	"\xc4\xa0" => "\xc4\xa1",
	"\xc4\xa2" => "\xc4\xa3",
	"\xc4\xa4" => "\xc4\xa5",
	"\xc4\xa6" => "\xc4\xa7",
	"\xc4\xa8" => "\xc4\xa9",
	"\xc4\xaa" => "\xc4\xab",
	"\xc4\xac" => "\xc4\xad",
	"\xc4\xae" => "\xc4\xaf",
	"\xc4\xb0" => "i",
	"\xc4\xb2" => "\xc4\xb3",
	"\xc4\xb4" => "\xc4\xb5",
	"\xc4\xb6" => "\xc4\xb7",
	"\xc4\xb9" => "\xc4\xba",
	"\xc4\xbb" => "\xc4\xbc",
	"\xc4\xbd" => "\xc4\xbe",
	"\xc4\xbf" => "\xc5\x80",
	"\xc5\x81" => "\xc5\x82",
	"\xc5\x83" => "\xc5\x84",
	"\xc5\x85" => "\xc5\x86",
	"\xc5\x87" => "\xc5\x88",
	"\xc5\x8a" => "\xc5\x8b",
	"\xc5\x8c" => "\xc5\x8d",
	"\xc5\x8e" => "\xc5\x8f",
	"\xc5\x90" => "\xc5\x91",
	"\xc5\x92" => "\xc5\x93",
	"\xc5\x94" => "\xc5\x95",
	"\xc5\x96" => "\xc5\x97",
	"\xc5\x98" => "\xc5\x99",
	"\xc5\x9a" => "\xc5\x9b",
	"\xc5\x9c" => "\xc5\x9d",
	"\xc5\x9e" => "\xc5\x9f",
	"\xc5\xa0" => "\xc5\xa1",
	"\xc5\xa2" => "\xc5\xa3",
	"\xc5\xa4" => "\xc5\xa5",
	"\xc5\xa6" => "\xc5\xa7",
	"\xc5\xa8" => "\xc5\xa9",
	"\xc5\xaa" => "\xc5\xab",
	"\xc5\xac" => "\xc5\xad",
	"\xc5\xae" => "\xc5\xaf",
	"\xc5\xb0" => "\xc5\xb1",
	"\xc5\xb2" => "\xc5\xb3",
	"\xc5\xb4" => "\xc5\xb5",
	"\xc5\xb6" => "\xc5\xb7",
	"\xc5\xb8" => "\xc3\xbf",
	"\xc5\xb9" => "\xc5\xba",
	"\xc5\xbb" => "\xc5\xbc",
	"\xc5\xbd" => "\xc5\xbe",
	"\xc6\x81" => "\xc9\x93",
	"\xc6\x82" => "\xc6\x83",
	"\xc6\x84" => "\xc6\x85",
	"\xc6\x86" => "\xc9\x94",
	"\xc6\x87" => "\xc6\x88",
	"\xc6\x89" => "\xc9\x96",
	"\xc6\x8a" => "\xc9\x97",
	"\xc6\x8b" => "\xc6\x8c",
	"\xc6\x8e" => "\xc7\x9d",
	"\xc6\x8f" => "\xc9\x99",
	"\xc6\x90" => "\xc9\x9b",
	"\xc6\x91" => "\xc6\x92",
	"\xc6\x93" => "\xc9\xa0",
	"\xc6\x94" => "\xc9\xa3",
	"\xc6\x96" => "\xc9\xa9",
	"\xc6\x97" => "\xc9\xa8",
	"\xc6\x98" => "\xc6\x99",
	"\xc6\x9c" => "\xc9\xaf",
	"\xc6\x9d" => "\xc9\xb2",
	"\xc6\x9f" => "\xc9\xb5",
	"\xc6\xa0" => "\xc6\xa1",
	"\xc6\xa2" => "\xc6\xa3",
	"\xc6\xa4" => "\xc6\xa5",
	"\xc6\xa6" => "\xca\x80",
	"\xc6\xa7" => "\xc6\xa8",
	"\xc6\xa9" => "\xca\x83",
	"\xc6\xac" => "\xc6\xad",
	"\xc6\xae" => "\xca\x88",
	"\xc6\xaf" => "\xc6\xb0",
	"\xc6\xb1" => "\xca\x8a",
	"\xc6\xb2" => "\xca\x8b",
	"\xc6\xb3" => "\xc6\xb4",
	"\xc6\xb5" => "\xc6\xb6",
	"\xc6\xb7" => "\xca\x92",
	"\xc6\xb8" => "\xc6\xb9",
	"\xc6\xbc" => "\xc6\xbd",
	"\xc7\x84" => "\xc7\x86",
	"\xc7\x85" => "\xc7\x86",
	"\xc7\x87" => "\xc7\x89",
	"\xc7\x88" => "\xc7\x89",
	"\xc7\x8a" => "\xc7\x8c",
	"\xc7\x8b" => "\xc7\x8c",
	"\xc7\x8d" => "\xc7\x8e",
	"\xc7\x8f" => "\xc7\x90",
	"\xc7\x91" => "\xc7\x92",
	"\xc7\x93" => "\xc7\x94",
	"\xc7\x95" => "\xc7\x96",
	"\xc7\x97" => "\xc7\x98",
	"\xc7\x99" => "\xc7\x9a",
	"\xc7\x9b" => "\xc7\x9c",
	"\xc7\x9e" => "\xc7\x9f",
	"\xc7\xa0" => "\xc7\xa1",
	"\xc7\xa2" => "\xc7\xa3",
	"\xc7\xa4" => "\xc7\xa5",
	"\xc7\xa6" => "\xc7\xa7",
	"\xc7\xa8" => "\xc7\xa9",
	"\xc7\xaa" => "\xc7\xab",
	"\xc7\xac" => "\xc7\xad",
	"\xc7\xae" => "\xc7\xaf",
	"\xc7\xb1" => "\xc7\xb3",
	"\xc7\xb2" => "\xc7\xb3",
	"\xc7\xb4" => "\xc7\xb5",
	"\xc7\xb6" => "\xc6\x95",
	"\xc7\xb7" => "\xc6\xbf",
	"\xc7\xb8" => "\xc7\xb9",
	"\xc7\xba" => "\xc7\xbb",
	"\xc7\xbc" => "\xc7\xbd",
	"\xc7\xbe" => "\xc7\xbf",
	"\xc8\x80" => "\xc8\x81",
	"\xc8\x82" => "\xc8\x83",
	"\xc8\x84" => "\xc8\x85",
	"\xc8\x86" => "\xc8\x87",
	"\xc8\x88" => "\xc8\x89",
	"\xc8\x8a" => "\xc8\x8b",
	"\xc8\x8c" => "\xc8\x8d",
	"\xc8\x8e" => "\xc8\x8f",
	"\xc8\x90" => "\xc8\x91",
	"\xc8\x92" => "\xc8\x93",
	"\xc8\x94" => "\xc8\x95",
	"\xc8\x96" => "\xc8\x97",
	"\xc8\x98" => "\xc8\x99",
	"\xc8\x9a" => "\xc8\x9b",
	"\xc8\x9c" => "\xc8\x9d",
	"\xc8\x9e" => "\xc8\x9f",
	"\xc8\xa2" => "\xc8\xa3",
	"\xc8\xa4" => "\xc8\xa5",
	"\xc8\xa6" => "\xc8\xa7",
	"\xc8\xa8" => "\xc8\xa9",
	"\xc8\xaa" => "\xc8\xab",
	"\xc8\xac" => "\xc8\xad",
	"\xc8\xae" => "\xc8\xaf",
	"\xc8\xb0" => "\xc8\xb1",
	"\xc8\xb2" => "\xc8\xb3",
	"\xce\x86" => "\xce\xac",
	"\xce\x88" => "\xce\xad",
	"\xce\x89" => "\xce\xae",
	"\xce\x8a" => "\xce\xaf",
	"\xce\x8c" => "\xcf\x8c",
	"\xce\x8e" => "\xcf\x8d",
	"\xce\x8f" => "\xcf\x8e",
	"\xce\x91" => "\xce\xb1",
	"\xce\x92" => "\xce\xb2",
	"\xce\x93" => "\xce\xb3",
	"\xce\x94" => "\xce\xb4",
	"\xce\x95" => "\xce\xb5",
	"\xce\x96" => "\xce\xb6",
	"\xce\x97" => "\xce\xb7",
	"\xce\x98" => "\xce\xb8",
	"\xce\x99" => "\xce\xb9",
	"\xce\x9a" => "\xce\xba",
	"\xce\x9b" => "\xce\xbb",
	"\xce\x9c" => "\xce\xbc",
	"\xce\x9d" => "\xce\xbd",
	"\xce\x9e" => "\xce\xbe",
	"\xce\x9f" => "\xce\xbf",
	"\xce\xa0" => "\xcf\x80",
	"\xce\xa1" => "\xcf\x81",
	"\xce\xa3" => "\xcf\x83",
	"\xce\xa4" => "\xcf\x84",
	"\xce\xa5" => "\xcf\x85",
	"\xce\xa6" => "\xcf\x86",
	"\xce\xa7" => "\xcf\x87",
	"\xce\xa8" => "\xcf\x88",
	"\xce\xa9" => "\xcf\x89",
	"\xce\xaa" => "\xcf\x8a",
	"\xce\xab" => "\xcf\x8b",
	"\xcf\x9a" => "\xcf\x9b",
	"\xcf\x9c" => "\xcf\x9d",
	"\xcf\x9e" => "\xcf\x9f",
	"\xcf\xa0" => "\xcf\xa1",
	"\xcf\xa2" => "\xcf\xa3",
	"\xcf\xa4" => "\xcf\xa5",
	"\xcf\xa6" => "\xcf\xa7",
	"\xcf\xa8" => "\xcf\xa9",
	"\xcf\xaa" => "\xcf\xab",
	"\xcf\xac" => "\xcf\xad",
	"\xcf\xae" => "\xcf\xaf",
	"\xcf\xb4" => "\xce\xb8",
	"\xd0\x80" => "\xd1\x90",
	"\xd0\x81" => "\xd1\x91",
	"\xd0\x82" => "\xd1\x92",
	"\xd0\x83" => "\xd1\x93",
	"\xd0\x84" => "\xd1\x94",
	"\xd0\x85" => "\xd1\x95",
	"\xd0\x86" => "\xd1\x96",
	"\xd0\x87" => "\xd1\x97",
	"\xd0\x88" => "\xd1\x98",
	"\xd0\x89" => "\xd1\x99",
	"\xd0\x8a" => "\xd1\x9a",
	"\xd0\x8b" => "\xd1\x9b",
	"\xd0\x8c" => "\xd1\x9c",
	"\xd0\x8d" => "\xd1\x9d",
	"\xd0\x8e" => "\xd1\x9e",
	"\xd0\x8f" => "\xd1\x9f",
	"\xd0\x90" => "\xd0\xb0",
	"\xd0\x91" => "\xd0\xb1",
	"\xd0\x92" => "\xd0\xb2",
	"\xd0\x93" => "\xd0\xb3",
	"\xd0\x94" => "\xd0\xb4",
	"\xd0\x95" => "\xd0\xb5",
	"\xd0\x96" => "\xd0\xb6",
	"\xd0\x97" => "\xd0\xb7",
	"\xd0\x98" => "\xd0\xb8",
	"\xd0\x99" => "\xd0\xb9",
	"\xd0\x9a" => "\xd0\xba",
	"\xd0\x9b" => "\xd0\xbb",
	"\xd0\x9c" => "\xd0\xbc",
	"\xd0\x9d" => "\xd0\xbd",
	"\xd0\x9e" => "\xd0\xbe",
	"\xd0\x9f" => "\xd0\xbf",
	"\xd0\xa0" => "\xd1\x80",
	"\xd0\xa1" => "\xd1\x81",
	"\xd0\xa2" => "\xd1\x82",
	"\xd0\xa3" => "\xd1\x83",
	"\xd0\xa4" => "\xd1\x84",
	"\xd0\xa5" => "\xd1\x85",
	"\xd0\xa6" => "\xd1\x86",
	"\xd0\xa7" => "\xd1\x87",
	"\xd0\xa8" => "\xd1\x88",
	"\xd0\xa9" => "\xd1\x89",
	"\xd0\xaa" => "\xd1\x8a",
	"\xd0\xab" => "\xd1\x8b",
	"\xd0\xac" => "\xd1\x8c",
	"\xd0\xad" => "\xd1\x8d",
	"\xd0\xae" => "\xd1\x8e",
	"\xd0\xaf" => "\xd1\x8f",
	"\xd1\xa0" => "\xd1\xa1",
	"\xd1\xa2" => "\xd1\xa3",
	"\xd1\xa4" => "\xd1\xa5",
	"\xd1\xa6" => "\xd1\xa7",
	"\xd1\xa8" => "\xd1\xa9",
	"\xd1\xaa" => "\xd1\xab",
	"\xd1\xac" => "\xd1\xad",
	"\xd1\xae" => "\xd1\xaf",
	"\xd1\xb0" => "\xd1\xb1",
	"\xd1\xb2" => "\xd1\xb3",
	"\xd1\xb4" => "\xd1\xb5",
	"\xd1\xb6" => "\xd1\xb7",
	"\xd1\xb8" => "\xd1\xb9",
	"\xd1\xba" => "\xd1\xbb",
	"\xd1\xbc" => "\xd1\xbd",
	"\xd1\xbe" => "\xd1\xbf",
	"\xd2\x80" => "\xd2\x81",
	"\xd2\x8c" => "\xd2\x8d",
	"\xd2\x8e" => "\xd2\x8f",
	"\xd2\x90" => "\xd2\x91",
	"\xd2\x92" => "\xd2\x93",
	"\xd2\x94" => "\xd2\x95",
	"\xd2\x96" => "\xd2\x97",
	"\xd2\x98" => "\xd2\x99",
	"\xd2\x9a" => "\xd2\x9b",
	"\xd2\x9c" => "\xd2\x9d",
	"\xd2\x9e" => "\xd2\x9f",
	"\xd2\xa0" => "\xd2\xa1",
	"\xd2\xa2" => "\xd2\xa3",
	"\xd2\xa4" => "\xd2\xa5",
	"\xd2\xa6" => "\xd2\xa7",
	"\xd2\xa8" => "\xd2\xa9",
	"\xd2\xaa" => "\xd2\xab",
	"\xd2\xac" => "\xd2\xad",
	"\xd2\xae" => "\xd2\xaf",
	"\xd2\xb0" => "\xd2\xb1",
	"\xd2\xb2" => "\xd2\xb3",
	"\xd2\xb4" => "\xd2\xb5",
	"\xd2\xb6" => "\xd2\xb7",
	"\xd2\xb8" => "\xd2\xb9",
	"\xd2\xba" => "\xd2\xbb",
	"\xd2\xbc" => "\xd2\xbd",
	"\xd2\xbe" => "\xd2\xbf",
	"\xd3\x81" => "\xd3\x82",
	"\xd3\x83" => "\xd3\x84",
	"\xd3\x87" => "\xd3\x88",
	"\xd3\x8b" => "\xd3\x8c",
	"\xd3\x90" => "\xd3\x91",
	"\xd3\x92" => "\xd3\x93",
	"\xd3\x94" => "\xd3\x95",
	"\xd3\x96" => "\xd3\x97",
	"\xd3\x98" => "\xd3\x99",
	"\xd3\x9a" => "\xd3\x9b",
	"\xd3\x9c" => "\xd3\x9d",
	"\xd3\x9e" => "\xd3\x9f",
	"\xd3\xa0" => "\xd3\xa1",
	"\xd3\xa2" => "\xd3\xa3",
	"\xd3\xa4" => "\xd3\xa5",
	"\xd3\xa6" => "\xd3\xa7",
	"\xd3\xa8" => "\xd3\xa9",
	"\xd3\xaa" => "\xd3\xab",
	"\xd3\xac" => "\xd3\xad",
	"\xd3\xae" => "\xd3\xaf",
	"\xd3\xb0" => "\xd3\xb1",
	"\xd3\xb2" => "\xd3\xb3",
	"\xd3\xb4" => "\xd3\xb5",
	"\xd3\xb8" => "\xd3\xb9",
	"\xd4\xb1" => "\xd5\xa1",
	"\xd4\xb2" => "\xd5\xa2",
	"\xd4\xb3" => "\xd5\xa3",
	"\xd4\xb4" => "\xd5\xa4",
	"\xd4\xb5" => "\xd5\xa5",
	"\xd4\xb6" => "\xd5\xa6",
	"\xd4\xb7" => "\xd5\xa7",
	"\xd4\xb8" => "\xd5\xa8",
	"\xd4\xb9" => "\xd5\xa9",
	"\xd4\xba" => "\xd5\xaa",
	"\xd4\xbb" => "\xd5\xab",
	"\xd4\xbc" => "\xd5\xac",
	"\xd4\xbd" => "\xd5\xad",
	"\xd4\xbe" => "\xd5\xae",
	"\xd4\xbf" => "\xd5\xaf",
	"\xd5\x80" => "\xd5\xb0",
	"\xd5\x81" => "\xd5\xb1",
	"\xd5\x82" => "\xd5\xb2",
	"\xd5\x83" => "\xd5\xb3",
	"\xd5\x84" => "\xd5\xb4",
	"\xd5\x85" => "\xd5\xb5",
	"\xd5\x86" => "\xd5\xb6",
	"\xd5\x87" => "\xd5\xb7",
	"\xd5\x88" => "\xd5\xb8",
	"\xd5\x89" => "\xd5\xb9",
	"\xd5\x8a" => "\xd5\xba",
	"\xd5\x8b" => "\xd5\xbb",
	"\xd5\x8c" => "\xd5\xbc",
	"\xd5\x8d" => "\xd5\xbd",
	"\xd5\x8e" => "\xd5\xbe",
	"\xd5\x8f" => "\xd5\xbf",
	"\xd5\x90" => "\xd6\x80",
	"\xd5\x91" => "\xd6\x81",
	"\xd5\x92" => "\xd6\x82",
	"\xd5\x93" => "\xd6\x83",
	"\xd5\x94" => "\xd6\x84",
	"\xd5\x95" => "\xd6\x85",
	"\xd5\x96" => "\xd6\x86",
	"\xe1\xb8\x80" => "\xe1\xb8\x81",
	"\xe1\xb8\x82" => "\xe1\xb8\x83",
	"\xe1\xb8\x84" => "\xe1\xb8\x85",
	"\xe1\xb8\x86" => "\xe1\xb8\x87",
	"\xe1\xb8\x88" => "\xe1\xb8\x89",
	"\xe1\xb8\x8a" => "\xe1\xb8\x8b",
	"\xe1\xb8\x8c" => "\xe1\xb8\x8d",
	"\xe1\xb8\x8e" => "\xe1\xb8\x8f",
	"\xe1\xb8\x90" => "\xe1\xb8\x91",
	"\xe1\xb8\x92" => "\xe1\xb8\x93",
	"\xe1\xb8\x94" => "\xe1\xb8\x95",
	"\xe1\xb8\x96" => "\xe1\xb8\x97",
	"\xe1\xb8\x98" => "\xe1\xb8\x99",
	"\xe1\xb8\x9a" => "\xe1\xb8\x9b",
	"\xe1\xb8\x9c" => "\xe1\xb8\x9d",
	"\xe1\xb8\x9e" => "\xe1\xb8\x9f",
	"\xe1\xb8\xa0" => "\xe1\xb8\xa1",
	"\xe1\xb8\xa2" => "\xe1\xb8\xa3",
	"\xe1\xb8\xa4" => "\xe1\xb8\xa5",
	"\xe1\xb8\xa6" => "\xe1\xb8\xa7",
	"\xe1\xb8\xa8" => "\xe1\xb8\xa9",
	"\xe1\xb8\xaa" => "\xe1\xb8\xab",
	"\xe1\xb8\xac" => "\xe1\xb8\xad",
	"\xe1\xb8\xae" => "\xe1\xb8\xaf",
	"\xe1\xb8\xb0" => "\xe1\xb8\xb1",
	"\xe1\xb8\xb2" => "\xe1\xb8\xb3",
	"\xe1\xb8\xb4" => "\xe1\xb8\xb5",
	"\xe1\xb8\xb6" => "\xe1\xb8\xb7",
	"\xe1\xb8\xb8" => "\xe1\xb8\xb9",
	"\xe1\xb8\xba" => "\xe1\xb8\xbb",
	"\xe1\xb8\xbc" => "\xe1\xb8\xbd",
	"\xe1\xb8\xbe" => "\xe1\xb8\xbf",
	"\xe1\xb9\x80" => "\xe1\xb9\x81",
	"\xe1\xb9\x82" => "\xe1\xb9\x83",
	"\xe1\xb9\x84" => "\xe1\xb9\x85",
	"\xe1\xb9\x86" => "\xe1\xb9\x87",
	"\xe1\xb9\x88" => "\xe1\xb9\x89",
	"\xe1\xb9\x8a" => "\xe1\xb9\x8b",
	"\xe1\xb9\x8c" => "\xe1\xb9\x8d",
	"\xe1\xb9\x8e" => "\xe1\xb9\x8f",
	"\xe1\xb9\x90" => "\xe1\xb9\x91",
	"\xe1\xb9\x92" => "\xe1\xb9\x93",
	"\xe1\xb9\x94" => "\xe1\xb9\x95",
	"\xe1\xb9\x96" => "\xe1\xb9\x97",
	"\xe1\xb9\x98" => "\xe1\xb9\x99",
	"\xe1\xb9\x9a" => "\xe1\xb9\x9b",
	"\xe1\xb9\x9c" => "\xe1\xb9\x9d",
	"\xe1\xb9\x9e" => "\xe1\xb9\x9f",
	"\xe1\xb9\xa0" => "\xe1\xb9\xa1",
	"\xe1\xb9\xa2" => "\xe1\xb9\xa3",
	"\xe1\xb9\xa4" => "\xe1\xb9\xa5",
	"\xe1\xb9\xa6" => "\xe1\xb9\xa7",
	"\xe1\xb9\xa8" => "\xe1\xb9\xa9",
	"\xe1\xb9\xaa" => "\xe1\xb9\xab",
	"\xe1\xb9\xac" => "\xe1\xb9\xad",
	"\xe1\xb9\xae" => "\xe1\xb9\xaf",
	"\xe1\xb9\xb0" => "\xe1\xb9\xb1",
	"\xe1\xb9\xb2" => "\xe1\xb9\xb3",
	"\xe1\xb9\xb4" => "\xe1\xb9\xb5",
	"\xe1\xb9\xb6" => "\xe1\xb9\xb7",
	"\xe1\xb9\xb8" => "\xe1\xb9\xb9",
	"\xe1\xb9\xba" => "\xe1\xb9\xbb",
	"\xe1\xb9\xbc" => "\xe1\xb9\xbd",
	"\xe1\xb9\xbe" => "\xe1\xb9\xbf",
	"\xe1\xba\x80" => "\xe1\xba\x81",
	"\xe1\xba\x82" => "\xe1\xba\x83",
	"\xe1\xba\x84" => "\xe1\xba\x85",
	"\xe1\xba\x86" => "\xe1\xba\x87",
	"\xe1\xba\x88" => "\xe1\xba\x89",
	"\xe1\xba\x8a" => "\xe1\xba\x8b",
	"\xe1\xba\x8c" => "\xe1\xba\x8d",
	"\xe1\xba\x8e" => "\xe1\xba\x8f",
	"\xe1\xba\x90" => "\xe1\xba\x91",
	"\xe1\xba\x92" => "\xe1\xba\x93",
	"\xe1\xba\x94" => "\xe1\xba\x95",
	"\xe1\xba\xa0" => "\xe1\xba\xa1",
	"\xe1\xba\xa2" => "\xe1\xba\xa3",
	"\xe1\xba\xa4" => "\xe1\xba\xa5",
	"\xe1\xba\xa6" => "\xe1\xba\xa7",
	"\xe1\xba\xa8" => "\xe1\xba\xa9",
	"\xe1\xba\xaa" => "\xe1\xba\xab",
	"\xe1\xba\xac" => "\xe1\xba\xad",
	"\xe1\xba\xae" => "\xe1\xba\xaf",
	"\xe1\xba\xb0" => "\xe1\xba\xb1",
	"\xe1\xba\xb2" => "\xe1\xba\xb3",
	"\xe1\xba\xb4" => "\xe1\xba\xb5",
	"\xe1\xba\xb6" => "\xe1\xba\xb7",
	"\xe1\xba\xb8" => "\xe1\xba\xb9",
	"\xe1\xba\xba" => "\xe1\xba\xbb",
	"\xe1\xba\xbc" => "\xe1\xba\xbd",
	"\xe1\xba\xbe" => "\xe1\xba\xbf",
	"\xe1\xbb\x80" => "\xe1\xbb\x81",
	"\xe1\xbb\x82" => "\xe1\xbb\x83",
	"\xe1\xbb\x84" => "\xe1\xbb\x85",
	"\xe1\xbb\x86" => "\xe1\xbb\x87",
	"\xe1\xbb\x88" => "\xe1\xbb\x89",
	"\xe1\xbb\x8a" => "\xe1\xbb\x8b",
	"\xe1\xbb\x8c" => "\xe1\xbb\x8d",
	"\xe1\xbb\x8e" => "\xe1\xbb\x8f",
	"\xe1\xbb\x90" => "\xe1\xbb\x91",
	"\xe1\xbb\x92" => "\xe1\xbb\x93",
	"\xe1\xbb\x94" => "\xe1\xbb\x95",
	"\xe1\xbb\x96" => "\xe1\xbb\x97",
	"\xe1\xbb\x98" => "\xe1\xbb\x99",
	"\xe1\xbb\x9a" => "\xe1\xbb\x9b",
	"\xe1\xbb\x9c" => "\xe1\xbb\x9d",
	"\xe1\xbb\x9e" => "\xe1\xbb\x9f",
	"\xe1\xbb\xa0" => "\xe1\xbb\xa1",
	"\xe1\xbb\xa2" => "\xe1\xbb\xa3",
	"\xe1\xbb\xa4" => "\xe1\xbb\xa5",
	"\xe1\xbb\xa6" => "\xe1\xbb\xa7",
	"\xe1\xbb\xa8" => "\xe1\xbb\xa9",
	"\xe1\xbb\xaa" => "\xe1\xbb\xab",
	"\xe1\xbb\xac" => "\xe1\xbb\xad",
	"\xe1\xbb\xae" => "\xe1\xbb\xaf",
	"\xe1\xbb\xb0" => "\xe1\xbb\xb1",
	"\xe1\xbb\xb2" => "\xe1\xbb\xb3",
	"\xe1\xbb\xb4" => "\xe1\xbb\xb5",
	"\xe1\xbb\xb6" => "\xe1\xbb\xb7",
	"\xe1\xbb\xb8" => "\xe1\xbb\xb9",
	"\xe1\xbc\x88" => "\xe1\xbc\x80",
	"\xe1\xbc\x89" => "\xe1\xbc\x81",
	"\xe1\xbc\x8a" => "\xe1\xbc\x82",
	"\xe1\xbc\x8b" => "\xe1\xbc\x83",
	"\xe1\xbc\x8c" => "\xe1\xbc\x84",
	"\xe1\xbc\x8d" => "\xe1\xbc\x85",
	"\xe1\xbc\x8e" => "\xe1\xbc\x86",
	"\xe1\xbc\x8f" => "\xe1\xbc\x87",
	"\xe1\xbc\x98" => "\xe1\xbc\x90",
	"\xe1\xbc\x99" => "\xe1\xbc\x91",
	"\xe1\xbc\x9a" => "\xe1\xbc\x92",
	"\xe1\xbc\x9b" => "\xe1\xbc\x93",
	"\xe1\xbc\x9c" => "\xe1\xbc\x94",
	"\xe1\xbc\x9d" => "\xe1\xbc\x95",
	"\xe1\xbc\xa8" => "\xe1\xbc\xa0",
	"\xe1\xbc\xa9" => "\xe1\xbc\xa1",
	"\xe1\xbc\xaa" => "\xe1\xbc\xa2",
	"\xe1\xbc\xab" => "\xe1\xbc\xa3",
	"\xe1\xbc\xac" => "\xe1\xbc\xa4",
	"\xe1\xbc\xad" => "\xe1\xbc\xa5",
	"\xe1\xbc\xae" => "\xe1\xbc\xa6",
	"\xe1\xbc\xaf" => "\xe1\xbc\xa7",
	"\xe1\xbc\xb8" => "\xe1\xbc\xb0",
	"\xe1\xbc\xb9" => "\xe1\xbc\xb1",
	"\xe1\xbc\xba" => "\xe1\xbc\xb2",
	"\xe1\xbc\xbb" => "\xe1\xbc\xb3",
	"\xe1\xbc\xbc" => "\xe1\xbc\xb4",
	"\xe1\xbc\xbd" => "\xe1\xbc\xb5",
	"\xe1\xbc\xbe" => "\xe1\xbc\xb6",
	"\xe1\xbc\xbf" => "\xe1\xbc\xb7",
	"\xe1\xbd\x88" => "\xe1\xbd\x80",
	"\xe1\xbd\x89" => "\xe1\xbd\x81",
	"\xe1\xbd\x8a" => "\xe1\xbd\x82",
	"\xe1\xbd\x8b" => "\xe1\xbd\x83",
	"\xe1\xbd\x8c" => "\xe1\xbd\x84",
	"\xe1\xbd\x8d" => "\xe1\xbd\x85",
	"\xe1\xbd\x99" => "\xe1\xbd\x91",
	"\xe1\xbd\x9b" => "\xe1\xbd\x93",
	"\xe1\xbd\x9d" => "\xe1\xbd\x95",
	"\xe1\xbd\x9f" => "\xe1\xbd\x97",
	"\xe1\xbd\xa8" => "\xe1\xbd\xa0",
	"\xe1\xbd\xa9" => "\xe1\xbd\xa1",
	"\xe1\xbd\xaa" => "\xe1\xbd\xa2",
	"\xe1\xbd\xab" => "\xe1\xbd\xa3",
	"\xe1\xbd\xac" => "\xe1\xbd\xa4",
	"\xe1\xbd\xad" => "\xe1\xbd\xa5",
	"\xe1\xbd\xae" => "\xe1\xbd\xa6",
	"\xe1\xbd\xaf" => "\xe1\xbd\xa7",
	"\xe1\xbe\x88" => "\xe1\xbe\x80",
	"\xe1\xbe\x89" => "\xe1\xbe\x81",
	"\xe1\xbe\x8a" => "\xe1\xbe\x82",
	"\xe1\xbe\x8b" => "\xe1\xbe\x83",
	"\xe1\xbe\x8c" => "\xe1\xbe\x84",
	"\xe1\xbe\x8d" => "\xe1\xbe\x85",
	"\xe1\xbe\x8e" => "\xe1\xbe\x86",
	"\xe1\xbe\x8f" => "\xe1\xbe\x87",
	"\xe1\xbe\x98" => "\xe1\xbe\x90",
	"\xe1\xbe\x99" => "\xe1\xbe\x91",
	"\xe1\xbe\x9a" => "\xe1\xbe\x92",
	"\xe1\xbe\x9b" => "\xe1\xbe\x93",
	"\xe1\xbe\x9c" => "\xe1\xbe\x94",
	"\xe1\xbe\x9d" => "\xe1\xbe\x95",
	"\xe1\xbe\x9e" => "\xe1\xbe\x96",
	"\xe1\xbe\x9f" => "\xe1\xbe\x97",
	"\xe1\xbe\xa8" => "\xe1\xbe\xa0",
	"\xe1\xbe\xa9" => "\xe1\xbe\xa1",
	"\xe1\xbe\xaa" => "\xe1\xbe\xa2",
	"\xe1\xbe\xab" => "\xe1\xbe\xa3",
	"\xe1\xbe\xac" => "\xe1\xbe\xa4",
	"\xe1\xbe\xad" => "\xe1\xbe\xa5",
	"\xe1\xbe\xae" => "\xe1\xbe\xa6",
	"\xe1\xbe\xaf" => "\xe1\xbe\xa7",
	"\xe1\xbe\xb8" => "\xe1\xbe\xb0",
	"\xe1\xbe\xb9" => "\xe1\xbe\xb1",
	"\xe1\xbe\xba" => "\xe1\xbd\xb0",
	"\xe1\xbe\xbb" => "\xe1\xbd\xb1",
	"\xe1\xbe\xbc" => "\xe1\xbe\xb3",
	"\xe1\xbf\x88" => "\xe1\xbd\xb2",
	"\xe1\xbf\x89" => "\xe1\xbd\xb3",
	"\xe1\xbf\x8a" => "\xe1\xbd\xb4",
	"\xe1\xbf\x8b" => "\xe1\xbd\xb5",
	"\xe1\xbf\x8c" => "\xe1\xbf\x83",
	"\xe1\xbf\x98" => "\xe1\xbf\x90",
	"\xe1\xbf\x99" => "\xe1\xbf\x91",
	"\xe1\xbf\x9a" => "\xe1\xbd\xb6",
	"\xe1\xbf\x9b" => "\xe1\xbd\xb7",
	"\xe1\xbf\xa8" => "\xe1\xbf\xa0",
	"\xe1\xbf\xa9" => "\xe1\xbf\xa1",
	"\xe1\xbf\xaa" => "\xe1\xbd\xba",
	"\xe1\xbf\xab" => "\xe1\xbd\xbb",
	"\xe1\xbf\xac" => "\xe1\xbf\xa5",
	"\xe1\xbf\xb8" => "\xe1\xbd\xb8",
	"\xe1\xbf\xb9" => "\xe1\xbd\xb9",
	"\xe1\xbf\xba" => "\xe1\xbd\xbc",
	"\xe1\xbf\xbb" => "\xe1\xbd\xbd",
	"\xe1\xbf\xbc" => "\xe1\xbf\xb3",
	"\xe2\x84\xa6" => "\xcf\x89",
	"\xe2\x84\xaa" => "k",
	"\xe2\x84\xab" => "\xc3\xa5",
	"\xe2\x85\xa0" => "\xe2\x85\xb0",
	"\xe2\x85\xa1" => "\xe2\x85\xb1",
	"\xe2\x85\xa2" => "\xe2\x85\xb2",
	"\xe2\x85\xa3" => "\xe2\x85\xb3",
	"\xe2\x85\xa4" => "\xe2\x85\xb4",
	"\xe2\x85\xa5" => "\xe2\x85\xb5",
	"\xe2\x85\xa6" => "\xe2\x85\xb6",
	"\xe2\x85\xa7" => "\xe2\x85\xb7",
	"\xe2\x85\xa8" => "\xe2\x85\xb8",
	"\xe2\x85\xa9" => "\xe2\x85\xb9",
	"\xe2\x85\xaa" => "\xe2\x85\xba",
	"\xe2\x85\xab" => "\xe2\x85\xbb",
	"\xe2\x85\xac" => "\xe2\x85\xbc",
	"\xe2\x85\xad" => "\xe2\x85\xbd",
	"\xe2\x85\xae" => "\xe2\x85\xbe",
	"\xe2\x85\xaf" => "\xe2\x85\xbf",
	"\xe2\x92\xb6" => "\xe2\x93\x90",
	"\xe2\x92\xb7" => "\xe2\x93\x91",
	"\xe2\x92\xb8" => "\xe2\x93\x92",
	"\xe2\x92\xb9" => "\xe2\x93\x93",
	"\xe2\x92\xba" => "\xe2\x93\x94",
	"\xe2\x92\xbb" => "\xe2\x93\x95",
	"\xe2\x92\xbc" => "\xe2\x93\x96",
	"\xe2\x92\xbd" => "\xe2\x93\x97",
	"\xe2\x92\xbe" => "\xe2\x93\x98",
	"\xe2\x92\xbf" => "\xe2\x93\x99",
	"\xe2\x93\x80" => "\xe2\x93\x9a",
	"\xe2\x93\x81" => "\xe2\x93\x9b",
	"\xe2\x93\x82" => "\xe2\x93\x9c",
	"\xe2\x93\x83" => "\xe2\x93\x9d",
	"\xe2\x93\x84" => "\xe2\x93\x9e",
	"\xe2\x93\x85" => "\xe2\x93\x9f",
	"\xe2\x93\x86" => "\xe2\x93\xa0",
	"\xe2\x93\x87" => "\xe2\x93\xa1",
	"\xe2\x93\x88" => "\xe2\x93\xa2",
	"\xe2\x93\x89" => "\xe2\x93\xa3",
	"\xe2\x93\x8a" => "\xe2\x93\xa4",
	"\xe2\x93\x8b" => "\xe2\x93\xa5",
	"\xe2\x93\x8c" => "\xe2\x93\xa6",
	"\xe2\x93\x8d" => "\xe2\x93\xa7",
	"\xe2\x93\x8e" => "\xe2\x93\xa8",
	"\xe2\x93\x8f" => "\xe2\x93\xa9",
	"\xef\xbc\xa1" => "\xef\xbd\x81",
	"\xef\xbc\xa2" => "\xef\xbd\x82",
	"\xef\xbc\xa3" => "\xef\xbd\x83",
	"\xef\xbc\xa4" => "\xef\xbd\x84",
	"\xef\xbc\xa5" => "\xef\xbd\x85",
	"\xef\xbc\xa6" => "\xef\xbd\x86",
	"\xef\xbc\xa7" => "\xef\xbd\x87",
	"\xef\xbc\xa8" => "\xef\xbd\x88",
	"\xef\xbc\xa9" => "\xef\xbd\x89",
	"\xef\xbc\xaa" => "\xef\xbd\x8a",
	"\xef\xbc\xab" => "\xef\xbd\x8b",
	"\xef\xbc\xac" => "\xef\xbd\x8c",
	"\xef\xbc\xad" => "\xef\xbd\x8d",
	"\xef\xbc\xae" => "\xef\xbd\x8e",
	"\xef\xbc\xaf" => "\xef\xbd\x8f",
	"\xef\xbc\xb0" => "\xef\xbd\x90",
	"\xef\xbc\xb1" => "\xef\xbd\x91",
	"\xef\xbc\xb2" => "\xef\xbd\x92",
	"\xef\xbc\xb3" => "\xef\xbd\x93",
	"\xef\xbc\xb4" => "\xef\xbd\x94",
	"\xef\xbc\xb5" => "\xef\xbd\x95",
	"\xef\xbc\xb6" => "\xef\xbd\x96",
	"\xef\xbc\xb7" => "\xef\xbd\x97",
	"\xef\xbc\xb8" => "\xef\xbd\x98",
	"\xef\xbc\xb9" => "\xef\xbd\x99",
	"\xef\xbc\xba" => "\xef\xbd\x9a",
	"\xf0\x90\x90\x80" => "\xf0\x90\x90\xa8",
	"\xf0\x90\x90\x81" => "\xf0\x90\x90\xa9",
	"\xf0\x90\x90\x82" => "\xf0\x90\x90\xaa",
	"\xf0\x90\x90\x83" => "\xf0\x90\x90\xab",
	"\xf0\x90\x90\x84" => "\xf0\x90\x90\xac",
	"\xf0\x90\x90\x85" => "\xf0\x90\x90\xad",
	"\xf0\x90\x90\x86" => "\xf0\x90\x90\xae",
	"\xf0\x90\x90\x87" => "\xf0\x90\x90\xaf",
	"\xf0\x90\x90\x88" => "\xf0\x90\x90\xb0",
	"\xf0\x90\x90\x89" => "\xf0\x90\x90\xb1",
	"\xf0\x90\x90\x8a" => "\xf0\x90\x90\xb2",
	"\xf0\x90\x90\x8b" => "\xf0\x90\x90\xb3",
	"\xf0\x90\x90\x8c" => "\xf0\x90\x90\xb4",
	"\xf0\x90\x90\x8d" => "\xf0\x90\x90\xb5",
	"\xf0\x90\x90\x8e" => "\xf0\x90\x90\xb6",
	"\xf0\x90\x90\x8f" => "\xf0\x90\x90\xb7",
	"\xf0\x90\x90\x90" => "\xf0\x90\x90\xb8",
	"\xf0\x90\x90\x91" => "\xf0\x90\x90\xb9",
	"\xf0\x90\x90\x92" => "\xf0\x90\x90\xba",
	"\xf0\x90\x90\x93" => "\xf0\x90\x90\xbb",
	"\xf0\x90\x90\x94" => "\xf0\x90\x90\xbc",
	"\xf0\x90\x90\x95" => "\xf0\x90\x90\xbd",
	"\xf0\x90\x90\x96" => "\xf0\x90\x90\xbe",
	"\xf0\x90\x90\x97" => "\xf0\x90\x90\xbf",
	"\xf0\x90\x90\x98" => "\xf0\x90\x91\x80",
	"\xf0\x90\x90\x99" => "\xf0\x90\x91\x81",
	"\xf0\x90\x90\x9a" => "\xf0\x90\x91\x82",
	"\xf0\x90\x90\x9b" => "\xf0\x90\x91\x83",
	"\xf0\x90\x90\x9c" => "\xf0\x90\x91\x84",
	"\xf0\x90\x90\x9d" => "\xf0\x90\x91\x85",
	"\xf0\x90\x90\x9e" => "\xf0\x90\x91\x86",
	"\xf0\x90\x90\x9f" => "\xf0\x90\x91\x87",
	"\xf0\x90\x90\xa0" => "\xf0\x90\x91\x88",
	"\xf0\x90\x90\xa1" => "\xf0\x90\x91\x89",
	"\xf0\x90\x90\xa2" => "\xf0\x90\x91\x8a",
	"\xf0\x90\x90\xa3" => "\xf0\x90\x91\x8b",
	"\xf0\x90\x90\xa4" => "\xf0\x90\x91\x8c",
	"\xf0\x90\x90\xa5" => "\xf0\x90\x91\x8d"
);

?>
