#ifndef _PCE_H

#include "../types.h"
#include "../mednafen.h"
#include "../state.h"
#include "../general.h"
#include "../memory.h"

#define DECLFR(x) uint8 x (uint32 A)
#define DECLFW(x) void x (uint32 A, uint8 V)

#include "huc6280.h"


extern bool PCE_InDebug;
void PCE_Power(void);

extern readfunc PCERead[0x100];
extern writefunc PCEWrite[0x100];
extern uint8 PCEIODataBuffer;
extern int pce_overclocked;

#ifdef WANT_DEBUGGER
void PCE_ResetASpaceInfo(void);
void PCE_AddASpace(void (*gasb)(const char *name, uint32 Address, uint32 Length, uint8 *Buffer), void (*pasb)(const char *name, uint32 Address, uint32 Length, uint32 Granularity, bool hl, const uint8 *Buffer), const char *name, const char *long_name, uint32 TotalBits, bool IsSegmented = 0, uint32 SegmentBits = 0, uint32 OffsetBits = 0, uint32 BitsOverlapped = 0);
void PCE_ResetRegGroupsInfo(void);
void PCE_AddRegGroup(RegGroupType *groupie);

#endif

#define _PCE_H
#endif
