#ifndef __WSWAN_H
#define __WSWAN_H

#include "../types.h"
#include "../mednafen.h"
#include "../state.h"
#include "../general.h"
#include "../memory.h"

#define  mBCD(value) (((value)/10)<<4)|((value)%10)

extern          uint32 rom_size;
extern          int wsc;

#include "interrupt.h"

#ifdef WANT_DEBUGGER
void WSwan_ResetASpaceInfo(void);
void WSwan_AddASpace(void (*gasb)(const char *name, uint32 Address, uint32 Length, uint8 *Buffer), void (*pasb)(const char *name, uint32 Address, uint32 Length, uint32 Granularity, bool hl, const uint8 *Buffer), const char *name, const char *long_name, uint32 TotalBits, bool IsSegmented = 0, uint32 SegmentBits = 0, uint32 OffsetBits = 0, uint32 BitsOverlapped = 0);
void WSwan_ResetRegGroupsInfo(void);
void WSwan_AddRegGroup(RegGroupType *groupie);
#endif

#endif
