/*
 * medussa - a distributed cracking system
 * Copyright (C) 1999 Kostas Evangelinos <kos@bastard.net>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

/*
 * $Id: generator.c,v 1.2 2003/02/05 04:38:37 kos Exp $
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef HAVE_STRINGS_H
#include <strings.h>
#endif
#include <gmp.h>

#include "common.h"
#include "keyspace.h"
#include "bruteforce.h"
#include "dictionary.h"
#include "binary.h"
#include "random.h"
#include "obfuscate.h"
#include "xmalloc.h"
#include "generator.h"

extern generator_impl_t bruteforce_impl;
extern generator_impl_t dictionary_impl;
extern generator_impl_t binary_impl;
extern generator_impl_t random_impl;
extern generator_impl_t obfuscate_impl;

generator_impl_t *generator_impl[] = {
  &bruteforce_impl,
  &dictionary_impl,
  &binary_impl,
  &random_impl,
  &obfuscate_impl,
  (generator_impl_t *)NULL
};

generator_t *
generator_init(char *name, char *opts) {
  generator_t *g;
  int i;
  
  g = (generator_t *)xcalloc(1, sizeof(generator_t));
  for(i=0; generator_impl[i]; i++) {
    if(!strcmp(generator_impl[i]->name, name)) {
      g->impl = generator_impl[i];

      if(!(g->context = g->impl->init(opts))) {
	xfree(g);
	return (generator_t *)NULL;
      }
      strncpy(g->name, name, KSP_LINELEN);
      if(opts)
	strncpy(g->opts, opts, KSP_LINELEN);
      else
	strcpy(g->opts, "");
      return g;
    }
  }

  xfree(g);
  return (generator_t *)NULL;
}

int
generator_query(int index, char *buf, int len) {
  int i;
  
  i = 0;
  while(generator_impl[i] && i < index)
    i++;
  
  if(!generator_impl[i])
    return 1;
  
  strncpy(buf, generator_impl[i]->name, len);
  return 0;
}
