/* colors.c -- color setting
 *
 * Copyright(C) 2001-2002 Elisa Manara <e@entropika.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */ 

#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include "melon.h"

GtkWidget *colorseldlg = NULL;
GdkColor gdk_color;
	char msg[256];

void set_color (GtkWidget *widget, GtkColorSelection *colorsel);
gint update_color (GtkWidget *widget, gpointer data);

gint color_selector (GtkWidget *widget, gpointer color_data)
{
	GtkWidget *colorsel;
	char title[256];
	gdouble old_col[3];
	GdkColor old_color;

	/* gtk default colors */
	if (strcmp(color_data, "gdef") == 0) {
		strncpy(cfg_data.color_style, "gtk_default", 16);
		strncpy(msg, " Colors updated to Gtk Default ", 256);
		set_style();
		config_update();
		dialog_message(msg);
		return 1;
	/* melon default colors */
	} else if (strcmp(color_data, "mdef") == 0) {
		strncpy(cfg_data.color_style, "melon_default", 16);
		strncpy(msg, " Colors updated to Melon Default ", 256);
		set_melon_def_colors();
		set_style();
		config_update();
		dialog_message(msg);
		return 1;

	} else if (strcmp(color_data, "bg") == 0) {
		strncpy(title, "Select background color", 256);
		strncpy(msg, " Background color updated ", 256);
		old_color = cfg_data.bgcolor;
	} else if (strcmp(color_data, "fg") == 0) {
		strncpy(title, "Select foreground color", 256);
		strncpy(msg, " Foreground color updated ", 256);
		old_color = cfg_data.fgcolor;
	} else if (strcmp(color_data, "abg") == 0) {
		strncpy(title, "Select active background color", 256);
		strncpy(msg, " Active background color updated ", 256);
		old_color = cfg_data.abgcolor;
	} else if (strcmp(color_data, "afg") == 0) {
		strncpy(title, "Select active foreground color", 256);
		strncpy(msg, " Active foreground color updated ", 256);
		old_color = cfg_data.afgcolor;
	}

	old_col[0] = old_color.red / 65535.0;
	old_col[1] = old_color.green / 65535.0;
	old_col[2] = old_color.blue / 65535.0;

	colorseldlg = gtk_color_selection_dialog_new(title);
	gtk_widget_hide ( GTK_COLOR_SELECTION_DIALOG(colorseldlg)->help_button );

	colorsel = GTK_COLOR_SELECTION_DIALOG(colorseldlg)->colorsel;
	gtk_color_selection_set_update_policy(GTK_COLOR_SELECTION( colorsel ), 
		GTK_UPDATE_DISCONTINUOUS);
	gtk_color_selection_set_color(GTK_COLOR_SELECTION( colorsel ), old_col);

	gtk_signal_connect(GTK_OBJECT(colorsel), "color_changed",
		(GtkSignalFunc)set_color, (gpointer)colorsel);

	gtk_signal_connect 
		(GTK_OBJECT (GTK_COLOR_SELECTION_DIALOG(colorseldlg)->ok_button), "clicked",
		GTK_SIGNAL_FUNC(update_color), color_data);

	gtk_signal_connect_object 
		(GTK_OBJECT (GTK_COLOR_SELECTION_DIALOG(colorseldlg)->ok_button), "clicked",
		GTK_SIGNAL_FUNC(gtk_widget_destroy),
		GTK_OBJECT (colorseldlg));

	gtk_signal_connect_object 
		(GTK_OBJECT (GTK_COLOR_SELECTION_DIALOG(colorseldlg)->cancel_button), "clicked",
		GTK_SIGNAL_FUNC(gtk_widget_destroy),
		GTK_OBJECT (colorseldlg));

	gtk_widget_show(colorseldlg);

	return 1;
}

void set_color ( GtkWidget *widget, GtkColorSelection *colorsel )
{
	gdouble color[3];

	/* get selected color */
	gtk_color_selection_get_color (colorsel, color);

	gdk_color.red = (guint16)(color[0]*65535.0);
	gdk_color.green = (guint16)(color[1]*65535.0);
	gdk_color.blue = (guint16)(color[2]*65535.0);
}

gint update_color (GtkWidget *widget, gpointer data)
{
	if (strcmp(data, "bg") == 0) {
		cfg_data.bgcolor = gdk_color;
	} else if (strcmp(data, "fg") == 0) {
		cfg_data.fgcolor = gdk_color;
	} else if (strcmp(data, "abg") == 0) {
		cfg_data.abgcolor = gdk_color;
	} else if (strcmp(data, "afg") == 0) {
		cfg_data.afgcolor = gdk_color;
	}

	strncpy(cfg_data.color_style, "custom", 16);
	set_style();
	config_update();
	dialog_message(msg);

	return 1;
}

void set_melon_def_colors (void)
{
	GdkColor def_colors[] =
	{
		{0, 0x30b9, 0x6c9a, 0x2375},
		{0, 0xffff, 0xf89d, 0x678a},
		{0, 0x22a6, 0x85d0, 0x21b5},
		{0, 0xcba2, 0x2fe9, 0x2fe9},
	};

	cfg_data.bgcolor = def_colors[0];
	cfg_data.fgcolor = def_colors[1];
	cfg_data.abgcolor = def_colors[2];
	cfg_data.afgcolor = def_colors[3];
	return;
}

