package Memories::SystemTag;
use strict;
use base qw(Memories::DBI Maypole::Model::CDBI::Plain);
__PACKAGE__->columns(Essential => qw/id name/);
__PACKAGE__->table("system_tag");

Memories::Photo->set_sql(sorted_by_system_tag => q/
SELECT photo.id as id, title, uploader, uploaded, x, y
FROM photo, system_tag, system_tagging
WHERE system_tagging.photo = photo.id
    AND system_tagging.tag = system_tag.id
    AND system_tag.id = ?
ORDER BY photo.uploaded DESC
/
);
sub view :Exported {
    my ($self, $r) = @_;
    my $tag;
    my $page = $r->params->{page} || 1;
    my $pager = Class::DBI::Pager::_pager("Memories::Photo",
        Memories->config->{photos_per_page}, $page);
    $r->{template_args}{pager} = $pager;

    if (!$r->objects) {
        $tag = $self->search(name => $r->{args}->[0])->first;
    } else {
        $tag = $r->objects->[0]; # Should hardly happen
    }
    $r->{template_args}{tag} = $tag;
    $r->{template_args}{tags} = [$tag]; # For selector
    $r->{template_args}{photos} =
        [$pager->search_sorted_by_system_tag($tag->id)];
}

package Memories::SystemTagging;
use base qw(Memories::DBI);
use Class::DBI::Pager;
__PACKAGE__->table("system_tagging");
__PACKAGE__->columns(TEMP => qw/count/);
__PACKAGE__->columns(Essential => qw/id tag photo/);
__PACKAGE__->set_sql(summary => qq/
SELECT  id, system_tag, count(*) AS count
FROM system_tagging
GROUP BY system_tag
ORDER BY count DESC
LIMIT 50
    /);
__PACKAGE__->set_sql(all => qq/
SELECT  id, tag, count(*) AS count
FROM system_tagging
GROUP BY system_tag
ORDER BY count DESC
    /);
Memories::SystemTagging->has_a("photo" => "Memories::Photo");
Memories::SystemTagging->has_a("tag" => "Memories::SystemTag");

Memories::Photo->has_many(system_tags => ["Memories::SystemTagging" => "system_tag"]);
Memories::Photo->has_many(system_taggings => "Memories::SystemTagging");
Memories::SystemTag->has_many(photos => ["Memories::SystemTagging" => "photo"] );
Memories::SystemTag->has_many(system_taggings => "Memories::SystemTagging");

1;
