/*
** Copyright (C) 2002 The University of Melbourne.
** This file may only be copied under the terms of the GNU Library General
** Public License - see the file COPYING.LIB in the Mercury distribution.
*/

/*
** The contents of this file were generated by the make_port_code script
** in the tools directory. Do not edit.
**
** The function of the code in this module is described in the paper on deep
** profiling by Thomas Conway and Zoltan Somogyi.
*/

#include "mercury_imp.h"

#ifndef MR_HIGHLEVEL_CODE
#include "mercury_deep_profiling_hand.h"
#include "mercury_profiling_builtin.h"

MR_define_extern_entry(mercury__profiling_builtin__det_call_port_code_ac_3_0);
MR_define_extern_entry(mercury__profiling_builtin__det_exit_port_code_ac_2_0);
MR_define_extern_entry(mercury__profiling_builtin__semi_call_port_code_ac_3_0);
MR_define_extern_entry(mercury__profiling_builtin__semi_exit_port_code_ac_2_0);
MR_define_extern_entry(mercury__profiling_builtin__semi_fail_port_code_ac_2_0);
MR_define_extern_entry(mercury__profiling_builtin__non_call_port_code_ac_4_0);
MR_define_extern_entry(mercury__profiling_builtin__non_exit_port_code_ac_2_0);
MR_define_extern_entry(mercury__profiling_builtin__non_redo_port_code_ac_2_0);
MR_define_extern_entry(mercury__profiling_builtin__non_fail_port_code_ac_2_0);
MR_define_extern_entry(mercury__profiling_builtin__det_call_port_code_sr_4_0);
MR_define_extern_entry(mercury__profiling_builtin__det_exit_port_code_sr_3_0);
MR_define_extern_entry(mercury__profiling_builtin__semi_call_port_code_sr_4_0);
MR_define_extern_entry(mercury__profiling_builtin__semi_exit_port_code_sr_3_0);
MR_define_extern_entry(mercury__profiling_builtin__semi_fail_port_code_sr_3_0);
MR_define_extern_entry(mercury__profiling_builtin__non_call_port_code_sr_5_0);
MR_define_extern_entry(mercury__profiling_builtin__non_exit_port_code_sr_3_0);
MR_define_extern_entry(mercury__profiling_builtin__non_redo_port_code_sr_2_0);
MR_define_extern_entry(mercury__profiling_builtin__non_fail_port_code_sr_3_0);
MR_BEGIN_MODULE(runtime_profiling_builtin_module)
MR_init_entry_an(mercury__profiling_builtin__det_call_port_code_ac_3_0);
MR_init_entry_an(mercury__profiling_builtin__det_exit_port_code_ac_2_0);
MR_init_entry_an(mercury__profiling_builtin__semi_call_port_code_ac_3_0);
MR_init_entry_an(mercury__profiling_builtin__semi_exit_port_code_ac_2_0);
MR_init_entry_an(mercury__profiling_builtin__semi_fail_port_code_ac_2_0);
MR_init_entry_an(mercury__profiling_builtin__non_call_port_code_ac_4_0);
MR_init_entry_an(mercury__profiling_builtin__non_exit_port_code_ac_2_0);
MR_init_entry_an(mercury__profiling_builtin__non_redo_port_code_ac_2_0);
MR_init_entry_an(mercury__profiling_builtin__non_fail_port_code_ac_2_0);
MR_init_entry_an(mercury__profiling_builtin__det_call_port_code_sr_4_0);
MR_init_entry_an(mercury__profiling_builtin__det_exit_port_code_sr_3_0);
MR_init_entry_an(mercury__profiling_builtin__semi_call_port_code_sr_4_0);
MR_init_entry_an(mercury__profiling_builtin__semi_exit_port_code_sr_3_0);
MR_init_entry_an(mercury__profiling_builtin__semi_fail_port_code_sr_3_0);
MR_init_entry_an(mercury__profiling_builtin__non_call_port_code_sr_5_0);
MR_init_entry_an(mercury__profiling_builtin__non_exit_port_code_sr_3_0);
MR_init_entry_an(mercury__profiling_builtin__non_redo_port_code_sr_2_0);
MR_init_entry_an(mercury__profiling_builtin__non_fail_port_code_sr_3_0);
MR_BEGIN_CODE

MR_define_entry(mercury__profiling_builtin__det_call_port_code_ac_3_0);
{
MR_Word ProcStatic;
MR_Word TopCSD;
MR_Word MiddleCSD;

ProcStatic = MR_r1;

#define MR_PROCNAME "det_call_port_code_ac"
#define MR_VERSION_AC
#define MR_CALL_PORT
#undef  MR_NEED_NEW_OUTERMOST
/*
** Copyright (C) 2001-2002 The University of Melbourne.
** This file may only be copied under the terms of the GNU Library General
** Public License - see the file COPYING.LIB in the Mercury distribution.
*/

/*
** The implementation of {det,semi,non}_call_port_code_{ac,sr}.
**
** The code including this file should define the following macros:
** 
** MR_PROCNAME:			The name of the procedure whose body this is.
** MR_VERSION_AC or MR_VERSION_SR:
** 				Says whether the procedure whose body this is
**				is intended for use with or without
**				MR_USE_ACTIVATION_COUNTS.
** MR_NEED_NEW_OUTERMOST:	Says whether we need to know the new value of
**				the outermost activation pointer. Should be
**				true only for non_call_port_code_*.
**
** The code including this file should have the following variables in scope:
**
** ProcStatic:			The proc_static of the procedure whose call
**				port we are at.
** MiddleCSD:			The id of the current csd.
** TopCSD:			The id of the parent's csd.
** OldOutermostActivationPtr:	The id of the outermost activation of the
**				current user procedure before the call.
**				Needed only with MR_VERSION_SR.
** NewOutermostActivationPtr:	The id of the outermost activation of the
**				current user procedure after the call.
**				Needed only with MR_NEED_NEW_OUTERMOST.
*/

#ifdef MR_DEEP_PROFILING
{
	MR_CallSiteDynamic	*csd;
	MR_ProcStatic		*ps;

	MR_enter_instrumentation();

  #ifdef MR_DEEP_PROFILING_LOWLEVEL_DEBUG
	if (MR_calldebug && MR_lld_print_enabled) {
		MR_print_deep_prof_vars(stdout, MR_PROCNAME);
	}
  #endif

	TopCSD = (MR_Word) MR_current_call_site_dynamic;
	MiddleCSD = (MR_Word) MR_next_call_site_dynamic;
	csd = MR_next_call_site_dynamic;
	MR_current_call_site_dynamic = csd;
  #ifdef MR_DEEP_PROFILING_PORT_COUNTS
    #ifdef MR_DEEP_PROFILING_EXPLICIT_CALL_COUNTS
	csd->MR_csd_own.MR_own_calls++;
    #else
	/* calls are computed from the other counts */
    #endif
  #endif

  #ifdef MR_DEEP_PROFILING_LOWLEVEL_DEBUG
	/* After we copy it, MR_next_call_site_dynamic is not meaningful; */
	/* zeroing it makes debugging output less cluttered. */
	MR_next_call_site_dynamic = NULL;
  #endif

	ps = (MR_ProcStatic *) ProcStatic;
  #ifdef MR_VERSION_SR
	OldOutermostActivationPtr =
		(MR_Word) ps->MR_ps_outermost_activation_ptr;
  #endif

  #if defined(MR_VERSION_AC)
    #ifdef MR_USE_ACTIVATION_COUNTS
	MR_deep_assert(csd, ps, ps->MR_ps_activation_count == 0
		|| ps->MR_ps_outermost_activation_ptr != NULL);

      #ifdef MR_DEEP_PROFILING_STATISTICS
	if (csd->MR_csd_callee_ptr != NULL) {
		MR_deep_prof_call_old++;
	} else if (ps->MR_ps_activation_count > 0) {
		MR_deep_prof_call_rec++;
	} else {
		MR_deep_prof_call_new++;
	}
      #endif

	if (csd->MR_csd_callee_ptr != NULL) {
		if (ps->MR_ps_activation_count == 0) {
			ps->MR_ps_outermost_activation_ptr =
				csd->MR_csd_callee_ptr;
		}
	} else if (ps->MR_ps_activation_count > 0) {
		csd->MR_csd_callee_ptr = ps->MR_ps_outermost_activation_ptr;
	} else {
		MR_ProcDynamic	*pd;

		MR_new_proc_dynamic(pd, ps);
		csd->MR_csd_callee_ptr = pd;
		ps->MR_ps_outermost_activation_ptr = pd;
	}

	ps->MR_ps_activation_count++;
    #else
	MR_fatal_error(MR_PROCNAME ": MR_USE_ACTIVATION_COUNTS not enabled");
    #endif
  #elif defined(MR_VERSION_SR)
    #ifndef MR_USE_ACTIVATION_COUNTS
      #ifdef MR_DEEP_PROFILING_STATISTICS
	if (csd->MR_csd_callee_ptr != NULL) {
		MR_deep_prof_call_old++;
	} else if (ps->MR_ps_outermost_activation_ptr != NULL) {
		MR_deep_prof_call_rec++;
	} else {
		MR_deep_prof_call_new++;
	}
      #endif

	if (csd->MR_csd_callee_ptr != NULL) {
		ps->MR_ps_outermost_activation_ptr = csd->MR_csd_callee_ptr;
	} else if (ps->MR_ps_outermost_activation_ptr != NULL) {
		csd->MR_csd_callee_ptr = ps->MR_ps_outermost_activation_ptr;
	} else {
		MR_ProcDynamic	*pd;

		MR_new_proc_dynamic(pd, ps);
		csd->MR_csd_callee_ptr = pd;
		ps->MR_ps_outermost_activation_ptr = csd->MR_csd_callee_ptr;
	}
    #else
	MR_fatal_error(MR_PROCNAME ": MR_USE_ACTIVATION_COUNTS enabled");
    #endif
  #else
    #error "mercury_deep_call_port_body.h: neither MR_VERSION_AC nor MR_VERSION_SR"
  #endif

  #ifdef MR_NEED_NEW_OUTERMOST
	NewOutermostActivationPtr =
		(MR_Word) ps->MR_ps_outermost_activation_ptr;
  #endif

	MR_leave_instrumentation();
}
#else
	MR_fatal_error(MR_PROCNAME ": deep profiling not enabled");
#endif
#undef  MR_PROCNAME
#undef  MR_VERSION_AC
#undef  MR_CALL_PORT
#undef  MR_NEED_NEW_OUTERMOST

MR_r1 = TopCSD;
MR_r2 = MiddleCSD;
}
MR_proceed();

MR_define_entry(mercury__profiling_builtin__det_exit_port_code_ac_2_0);
{
MR_Word TopCSD;
MR_Word MiddleCSD;

TopCSD = MR_r1;
MiddleCSD = MR_r2;

#define MR_PROCNAME "det_exit_port_code_ac"
#define MR_VERSION_AC
#define MR_EXIT_PORT
#undef  MR_NEED_NEW_OUTERMOST
/*
** Copyright (C) 2001-2002 The University of Melbourne.
** This file may only be copied under the terms of the GNU Library General
** Public License - see the file COPYING.LIB in the Mercury distribution.
*/

/*
** The implementation of {det,semi,non}_{exit,fail}_port_code_{ac,sr}.
**
** The code including this file should define the following macros:
** 
** MR_PROCNAME:			The name of the procedure whose body this is.
** MR_FAIL_PORT or MR_EXIT_PORT:
** 				Says which field to increment and whether the
**				procedure has detism det or failure.
** MR_VERSION_AC or MR_VERSION_SR:
** 				Says whether the procedure whose body this is
**				is intended for use with or without
**				MR_USE_ACTIVATION_COUNTS.
**
** The code including this file should have the following variables in scope:
**
** MiddleCSD:			The id of the current csd.
** TopCSD:			The id of the parent's csd.
** OldOutermostActivationPtr:	The id of the outermost activation of the
**				current user procedure before the current call
**				to it. Needed only with MR_VERSION_SR.
*/

#ifdef MR_DEEP_PROFILING
{
	MR_CallSiteDynamic	*csd;
	MR_ProcStatic		*ps;

	MR_enter_instrumentation();

	csd = (MR_CallSiteDynamic *) MiddleCSD;
	MR_deep_assert(csd, NULL, csd == MR_current_call_site_dynamic);

  #ifdef MR_DEEP_PROFILING_PORT_COUNTS
	/* increment exit/fail count */
    #if defined(MR_FAIL_PORT)
	csd->MR_csd_own.MR_own_fails++;
    #elif defined(MR_EXIT_PORT)
	csd->MR_csd_own.MR_own_exits++;
    #else
      #error "mercury_deep_leave_port_body.h: neither MR_FAIL_PORT nor MR_EXIT_PORT"
    #endif
  #endif

	MR_deep_assert(csd, NULL, csd->MR_csd_callee_ptr != NULL);
	ps = csd->MR_csd_callee_ptr->MR_pd_proc_static;
	MR_deep_assert(csd, ps, ps != NULL);

  #if defined(MR_VERSION_AC)
    #ifdef MR_USE_ACTIVATION_COUNTS
	/* decrement activation count */
	ps->MR_ps_activation_count--;
	MR_deep_assert(csd, ps, ps->MR_ps_activation_count >= 0);
    #else
	MR_fatal_error(MR_PROCNAME ": MR_USE_ACTIVATION_COUNTS not enabled");
    #endif
  #elif defined(MR_VERSION_SR)
    #ifndef MR_USE_ACTIVATION_COUNTS
	/* set outermost activation pointer */
	ps->MR_ps_outermost_activation_ptr =
		(MR_ProcDynamic *) OldOutermostActivationPtr;
    #else
	MR_fatal_error(MR_PROCNAME ": MR_USE_ACTIVATION_COUNTS enabled");
    #endif
  #else
    #error "mercury_deep_leave_port_body.h: neither MR_VERSION_AC nor MR_VERSION_SR"
  #endif

	/* set current csd */
	MR_current_call_site_dynamic = (MR_CallSiteDynamic *) TopCSD;

	MR_leave_instrumentation();

  	/*
	** For MR_FAIL_PORT code, the failure we should execute here
	** is handled by code inserted by the compiler.
	*/
}
#else
	MR_fatal_error(MR_PROCNAME ": deep profiling not enabled");
#endif
#undef  MR_PROCNAME
#undef  MR_VERSION_AC
#undef  MR_EXIT_PORT
#undef  MR_NEED_NEW_OUTERMOST

}
MR_proceed();

MR_define_entry(mercury__profiling_builtin__semi_call_port_code_ac_3_0);
{
MR_Word ProcStatic;
MR_Word TopCSD;
MR_Word MiddleCSD;

ProcStatic = MR_r1;

#define MR_PROCNAME "semi_call_port_code_ac"
#define MR_VERSION_AC
#define MR_CALL_PORT
#undef  MR_NEED_NEW_OUTERMOST
/*
** Copyright (C) 2001-2002 The University of Melbourne.
** This file may only be copied under the terms of the GNU Library General
** Public License - see the file COPYING.LIB in the Mercury distribution.
*/

/*
** The implementation of {det,semi,non}_call_port_code_{ac,sr}.
**
** The code including this file should define the following macros:
** 
** MR_PROCNAME:			The name of the procedure whose body this is.
** MR_VERSION_AC or MR_VERSION_SR:
** 				Says whether the procedure whose body this is
**				is intended for use with or without
**				MR_USE_ACTIVATION_COUNTS.
** MR_NEED_NEW_OUTERMOST:	Says whether we need to know the new value of
**				the outermost activation pointer. Should be
**				true only for non_call_port_code_*.
**
** The code including this file should have the following variables in scope:
**
** ProcStatic:			The proc_static of the procedure whose call
**				port we are at.
** MiddleCSD:			The id of the current csd.
** TopCSD:			The id of the parent's csd.
** OldOutermostActivationPtr:	The id of the outermost activation of the
**				current user procedure before the call.
**				Needed only with MR_VERSION_SR.
** NewOutermostActivationPtr:	The id of the outermost activation of the
**				current user procedure after the call.
**				Needed only with MR_NEED_NEW_OUTERMOST.
*/

#ifdef MR_DEEP_PROFILING
{
	MR_CallSiteDynamic	*csd;
	MR_ProcStatic		*ps;

	MR_enter_instrumentation();

  #ifdef MR_DEEP_PROFILING_LOWLEVEL_DEBUG
	if (MR_calldebug && MR_lld_print_enabled) {
		MR_print_deep_prof_vars(stdout, MR_PROCNAME);
	}
  #endif

	TopCSD = (MR_Word) MR_current_call_site_dynamic;
	MiddleCSD = (MR_Word) MR_next_call_site_dynamic;
	csd = MR_next_call_site_dynamic;
	MR_current_call_site_dynamic = csd;
  #ifdef MR_DEEP_PROFILING_PORT_COUNTS
    #ifdef MR_DEEP_PROFILING_EXPLICIT_CALL_COUNTS
	csd->MR_csd_own.MR_own_calls++;
    #else
	/* calls are computed from the other counts */
    #endif
  #endif

  #ifdef MR_DEEP_PROFILING_LOWLEVEL_DEBUG
	/* After we copy it, MR_next_call_site_dynamic is not meaningful; */
	/* zeroing it makes debugging output less cluttered. */
	MR_next_call_site_dynamic = NULL;
  #endif

	ps = (MR_ProcStatic *) ProcStatic;
  #ifdef MR_VERSION_SR
	OldOutermostActivationPtr =
		(MR_Word) ps->MR_ps_outermost_activation_ptr;
  #endif

  #if defined(MR_VERSION_AC)
    #ifdef MR_USE_ACTIVATION_COUNTS
	MR_deep_assert(csd, ps, ps->MR_ps_activation_count == 0
		|| ps->MR_ps_outermost_activation_ptr != NULL);

      #ifdef MR_DEEP_PROFILING_STATISTICS
	if (csd->MR_csd_callee_ptr != NULL) {
		MR_deep_prof_call_old++;
	} else if (ps->MR_ps_activation_count > 0) {
		MR_deep_prof_call_rec++;
	} else {
		MR_deep_prof_call_new++;
	}
      #endif

	if (csd->MR_csd_callee_ptr != NULL) {
		if (ps->MR_ps_activation_count == 0) {
			ps->MR_ps_outermost_activation_ptr =
				csd->MR_csd_callee_ptr;
		}
	} else if (ps->MR_ps_activation_count > 0) {
		csd->MR_csd_callee_ptr = ps->MR_ps_outermost_activation_ptr;
	} else {
		MR_ProcDynamic	*pd;

		MR_new_proc_dynamic(pd, ps);
		csd->MR_csd_callee_ptr = pd;
		ps->MR_ps_outermost_activation_ptr = pd;
	}

	ps->MR_ps_activation_count++;
    #else
	MR_fatal_error(MR_PROCNAME ": MR_USE_ACTIVATION_COUNTS not enabled");
    #endif
  #elif defined(MR_VERSION_SR)
    #ifndef MR_USE_ACTIVATION_COUNTS
      #ifdef MR_DEEP_PROFILING_STATISTICS
	if (csd->MR_csd_callee_ptr != NULL) {
		MR_deep_prof_call_old++;
	} else if (ps->MR_ps_outermost_activation_ptr != NULL) {
		MR_deep_prof_call_rec++;
	} else {
		MR_deep_prof_call_new++;
	}
      #endif

	if (csd->MR_csd_callee_ptr != NULL) {
		ps->MR_ps_outermost_activation_ptr = csd->MR_csd_callee_ptr;
	} else if (ps->MR_ps_outermost_activation_ptr != NULL) {
		csd->MR_csd_callee_ptr = ps->MR_ps_outermost_activation_ptr;
	} else {
		MR_ProcDynamic	*pd;

		MR_new_proc_dynamic(pd, ps);
		csd->MR_csd_callee_ptr = pd;
		ps->MR_ps_outermost_activation_ptr = csd->MR_csd_callee_ptr;
	}
    #else
	MR_fatal_error(MR_PROCNAME ": MR_USE_ACTIVATION_COUNTS enabled");
    #endif
  #else
    #error "mercury_deep_call_port_body.h: neither MR_VERSION_AC nor MR_VERSION_SR"
  #endif

  #ifdef MR_NEED_NEW_OUTERMOST
	NewOutermostActivationPtr =
		(MR_Word) ps->MR_ps_outermost_activation_ptr;
  #endif

	MR_leave_instrumentation();
}
#else
	MR_fatal_error(MR_PROCNAME ": deep profiling not enabled");
#endif
#undef  MR_PROCNAME
#undef  MR_VERSION_AC
#undef  MR_CALL_PORT
#undef  MR_NEED_NEW_OUTERMOST

MR_r1 = TopCSD;
MR_r2 = MiddleCSD;
}
MR_proceed();

MR_define_entry(mercury__profiling_builtin__semi_exit_port_code_ac_2_0);
{
MR_Word TopCSD;
MR_Word MiddleCSD;

TopCSD = MR_r1;
MiddleCSD = MR_r2;

#define MR_PROCNAME "semi_exit_port_code_ac"
#define MR_VERSION_AC
#define MR_EXIT_PORT
#undef  MR_NEED_NEW_OUTERMOST
/*
** Copyright (C) 2001-2002 The University of Melbourne.
** This file may only be copied under the terms of the GNU Library General
** Public License - see the file COPYING.LIB in the Mercury distribution.
*/

/*
** The implementation of {det,semi,non}_{exit,fail}_port_code_{ac,sr}.
**
** The code including this file should define the following macros:
** 
** MR_PROCNAME:			The name of the procedure whose body this is.
** MR_FAIL_PORT or MR_EXIT_PORT:
** 				Says which field to increment and whether the
**				procedure has detism det or failure.
** MR_VERSION_AC or MR_VERSION_SR:
** 				Says whether the procedure whose body this is
**				is intended for use with or without
**				MR_USE_ACTIVATION_COUNTS.
**
** The code including this file should have the following variables in scope:
**
** MiddleCSD:			The id of the current csd.
** TopCSD:			The id of the parent's csd.
** OldOutermostActivationPtr:	The id of the outermost activation of the
**				current user procedure before the current call
**				to it. Needed only with MR_VERSION_SR.
*/

#ifdef MR_DEEP_PROFILING
{
	MR_CallSiteDynamic	*csd;
	MR_ProcStatic		*ps;

	MR_enter_instrumentation();

	csd = (MR_CallSiteDynamic *) MiddleCSD;
	MR_deep_assert(csd, NULL, csd == MR_current_call_site_dynamic);

  #ifdef MR_DEEP_PROFILING_PORT_COUNTS
	/* increment exit/fail count */
    #if defined(MR_FAIL_PORT)
	csd->MR_csd_own.MR_own_fails++;
    #elif defined(MR_EXIT_PORT)
	csd->MR_csd_own.MR_own_exits++;
    #else
      #error "mercury_deep_leave_port_body.h: neither MR_FAIL_PORT nor MR_EXIT_PORT"
    #endif
  #endif

	MR_deep_assert(csd, NULL, csd->MR_csd_callee_ptr != NULL);
	ps = csd->MR_csd_callee_ptr->MR_pd_proc_static;
	MR_deep_assert(csd, ps, ps != NULL);

  #if defined(MR_VERSION_AC)
    #ifdef MR_USE_ACTIVATION_COUNTS
	/* decrement activation count */
	ps->MR_ps_activation_count--;
	MR_deep_assert(csd, ps, ps->MR_ps_activation_count >= 0);
    #else
	MR_fatal_error(MR_PROCNAME ": MR_USE_ACTIVATION_COUNTS not enabled");
    #endif
  #elif defined(MR_VERSION_SR)
    #ifndef MR_USE_ACTIVATION_COUNTS
	/* set outermost activation pointer */
	ps->MR_ps_outermost_activation_ptr =
		(MR_ProcDynamic *) OldOutermostActivationPtr;
    #else
	MR_fatal_error(MR_PROCNAME ": MR_USE_ACTIVATION_COUNTS enabled");
    #endif
  #else
    #error "mercury_deep_leave_port_body.h: neither MR_VERSION_AC nor MR_VERSION_SR"
  #endif

	/* set current csd */
	MR_current_call_site_dynamic = (MR_CallSiteDynamic *) TopCSD;

	MR_leave_instrumentation();

  	/*
	** For MR_FAIL_PORT code, the failure we should execute here
	** is handled by code inserted by the compiler.
	*/
}
#else
	MR_fatal_error(MR_PROCNAME ": deep profiling not enabled");
#endif
#undef  MR_PROCNAME
#undef  MR_VERSION_AC
#undef  MR_EXIT_PORT
#undef  MR_NEED_NEW_OUTERMOST

}
MR_proceed();

MR_define_entry(mercury__profiling_builtin__semi_fail_port_code_ac_2_0);
{
MR_Word TopCSD;
MR_Word MiddleCSD;

TopCSD = MR_r1;
MiddleCSD = MR_r2;

#define MR_PROCNAME "semi_fail_port_code_ac"
#define MR_VERSION_AC
#define MR_FAIL_PORT
#undef  MR_NEED_NEW_OUTERMOST
/*
** Copyright (C) 2001-2002 The University of Melbourne.
** This file may only be copied under the terms of the GNU Library General
** Public License - see the file COPYING.LIB in the Mercury distribution.
*/

/*
** The implementation of {det,semi,non}_{exit,fail}_port_code_{ac,sr}.
**
** The code including this file should define the following macros:
** 
** MR_PROCNAME:			The name of the procedure whose body this is.
** MR_FAIL_PORT or MR_EXIT_PORT:
** 				Says which field to increment and whether the
**				procedure has detism det or failure.
** MR_VERSION_AC or MR_VERSION_SR:
** 				Says whether the procedure whose body this is
**				is intended for use with or without
**				MR_USE_ACTIVATION_COUNTS.
**
** The code including this file should have the following variables in scope:
**
** MiddleCSD:			The id of the current csd.
** TopCSD:			The id of the parent's csd.
** OldOutermostActivationPtr:	The id of the outermost activation of the
**				current user procedure before the current call
**				to it. Needed only with MR_VERSION_SR.
*/

#ifdef MR_DEEP_PROFILING
{
	MR_CallSiteDynamic	*csd;
	MR_ProcStatic		*ps;

	MR_enter_instrumentation();

	csd = (MR_CallSiteDynamic *) MiddleCSD;
	MR_deep_assert(csd, NULL, csd == MR_current_call_site_dynamic);

  #ifdef MR_DEEP_PROFILING_PORT_COUNTS
	/* increment exit/fail count */
    #if defined(MR_FAIL_PORT)
	csd->MR_csd_own.MR_own_fails++;
    #elif defined(MR_EXIT_PORT)
	csd->MR_csd_own.MR_own_exits++;
    #else
      #error "mercury_deep_leave_port_body.h: neither MR_FAIL_PORT nor MR_EXIT_PORT"
    #endif
  #endif

	MR_deep_assert(csd, NULL, csd->MR_csd_callee_ptr != NULL);
	ps = csd->MR_csd_callee_ptr->MR_pd_proc_static;
	MR_deep_assert(csd, ps, ps != NULL);

  #if defined(MR_VERSION_AC)
    #ifdef MR_USE_ACTIVATION_COUNTS
	/* decrement activation count */
	ps->MR_ps_activation_count--;
	MR_deep_assert(csd, ps, ps->MR_ps_activation_count >= 0);
    #else
	MR_fatal_error(MR_PROCNAME ": MR_USE_ACTIVATION_COUNTS not enabled");
    #endif
  #elif defined(MR_VERSION_SR)
    #ifndef MR_USE_ACTIVATION_COUNTS
	/* set outermost activation pointer */
	ps->MR_ps_outermost_activation_ptr =
		(MR_ProcDynamic *) OldOutermostActivationPtr;
    #else
	MR_fatal_error(MR_PROCNAME ": MR_USE_ACTIVATION_COUNTS enabled");
    #endif
  #else
    #error "mercury_deep_leave_port_body.h: neither MR_VERSION_AC nor MR_VERSION_SR"
  #endif

	/* set current csd */
	MR_current_call_site_dynamic = (MR_CallSiteDynamic *) TopCSD;

	MR_leave_instrumentation();

  	/*
	** For MR_FAIL_PORT code, the failure we should execute here
	** is handled by code inserted by the compiler.
	*/
}
#else
	MR_fatal_error(MR_PROCNAME ": deep profiling not enabled");
#endif
#undef  MR_PROCNAME
#undef  MR_VERSION_AC
#undef  MR_FAIL_PORT
#undef  MR_NEED_NEW_OUTERMOST

}
MR_r1 = MR_FALSE; MR_proceed();

MR_define_entry(mercury__profiling_builtin__non_call_port_code_ac_4_0);
{
MR_Word ProcStatic;
MR_Word TopCSD;
MR_Word MiddleCSD;
MR_Word NewOutermostActivationPtr;

ProcStatic = MR_r1;

#define MR_PROCNAME "non_call_port_code_ac"
#define MR_VERSION_AC
#define MR_CALL_PORT
#define MR_NEED_NEW_OUTERMOST
/*
** Copyright (C) 2001-2002 The University of Melbourne.
** This file may only be copied under the terms of the GNU Library General
** Public License - see the file COPYING.LIB in the Mercury distribution.
*/

/*
** The implementation of {det,semi,non}_call_port_code_{ac,sr}.
**
** The code including this file should define the following macros:
** 
** MR_PROCNAME:			The name of the procedure whose body this is.
** MR_VERSION_AC or MR_VERSION_SR:
** 				Says whether the procedure whose body this is
**				is intended for use with or without
**				MR_USE_ACTIVATION_COUNTS.
** MR_NEED_NEW_OUTERMOST:	Says whether we need to know the new value of
**				the outermost activation pointer. Should be
**				true only for non_call_port_code_*.
**
** The code including this file should have the following variables in scope:
**
** ProcStatic:			The proc_static of the procedure whose call
**				port we are at.
** MiddleCSD:			The id of the current csd.
** TopCSD:			The id of the parent's csd.
** OldOutermostActivationPtr:	The id of the outermost activation of the
**				current user procedure before the call.
**				Needed only with MR_VERSION_SR.
** NewOutermostActivationPtr:	The id of the outermost activation of the
**				current user procedure after the call.
**				Needed only with MR_NEED_NEW_OUTERMOST.
*/

#ifdef MR_DEEP_PROFILING
{
	MR_CallSiteDynamic	*csd;
	MR_ProcStatic		*ps;

	MR_enter_instrumentation();

  #ifdef MR_DEEP_PROFILING_LOWLEVEL_DEBUG
	if (MR_calldebug && MR_lld_print_enabled) {
		MR_print_deep_prof_vars(stdout, MR_PROCNAME);
	}
  #endif

	TopCSD = (MR_Word) MR_current_call_site_dynamic;
	MiddleCSD = (MR_Word) MR_next_call_site_dynamic;
	csd = MR_next_call_site_dynamic;
	MR_current_call_site_dynamic = csd;
  #ifdef MR_DEEP_PROFILING_PORT_COUNTS
    #ifdef MR_DEEP_PROFILING_EXPLICIT_CALL_COUNTS
	csd->MR_csd_own.MR_own_calls++;
    #else
	/* calls are computed from the other counts */
    #endif
  #endif

  #ifdef MR_DEEP_PROFILING_LOWLEVEL_DEBUG
	/* After we copy it, MR_next_call_site_dynamic is not meaningful; */
	/* zeroing it makes debugging output less cluttered. */
	MR_next_call_site_dynamic = NULL;
  #endif

	ps = (MR_ProcStatic *) ProcStatic;
  #ifdef MR_VERSION_SR
	OldOutermostActivationPtr =
		(MR_Word) ps->MR_ps_outermost_activation_ptr;
  #endif

  #if defined(MR_VERSION_AC)
    #ifdef MR_USE_ACTIVATION_COUNTS
	MR_deep_assert(csd, ps, ps->MR_ps_activation_count == 0
		|| ps->MR_ps_outermost_activation_ptr != NULL);

      #ifdef MR_DEEP_PROFILING_STATISTICS
	if (csd->MR_csd_callee_ptr != NULL) {
		MR_deep_prof_call_old++;
	} else if (ps->MR_ps_activation_count > 0) {
		MR_deep_prof_call_rec++;
	} else {
		MR_deep_prof_call_new++;
	}
      #endif

	if (csd->MR_csd_callee_ptr != NULL) {
		if (ps->MR_ps_activation_count == 0) {
			ps->MR_ps_outermost_activation_ptr =
				csd->MR_csd_callee_ptr;
		}
	} else if (ps->MR_ps_activation_count > 0) {
		csd->MR_csd_callee_ptr = ps->MR_ps_outermost_activation_ptr;
	} else {
		MR_ProcDynamic	*pd;

		MR_new_proc_dynamic(pd, ps);
		csd->MR_csd_callee_ptr = pd;
		ps->MR_ps_outermost_activation_ptr = pd;
	}

	ps->MR_ps_activation_count++;
    #else
	MR_fatal_error(MR_PROCNAME ": MR_USE_ACTIVATION_COUNTS not enabled");
    #endif
  #elif defined(MR_VERSION_SR)
    #ifndef MR_USE_ACTIVATION_COUNTS
      #ifdef MR_DEEP_PROFILING_STATISTICS
	if (csd->MR_csd_callee_ptr != NULL) {
		MR_deep_prof_call_old++;
	} else if (ps->MR_ps_outermost_activation_ptr != NULL) {
		MR_deep_prof_call_rec++;
	} else {
		MR_deep_prof_call_new++;
	}
      #endif

	if (csd->MR_csd_callee_ptr != NULL) {
		ps->MR_ps_outermost_activation_ptr = csd->MR_csd_callee_ptr;
	} else if (ps->MR_ps_outermost_activation_ptr != NULL) {
		csd->MR_csd_callee_ptr = ps->MR_ps_outermost_activation_ptr;
	} else {
		MR_ProcDynamic	*pd;

		MR_new_proc_dynamic(pd, ps);
		csd->MR_csd_callee_ptr = pd;
		ps->MR_ps_outermost_activation_ptr = csd->MR_csd_callee_ptr;
	}
    #else
	MR_fatal_error(MR_PROCNAME ": MR_USE_ACTIVATION_COUNTS enabled");
    #endif
  #else
    #error "mercury_deep_call_port_body.h: neither MR_VERSION_AC nor MR_VERSION_SR"
  #endif

  #ifdef MR_NEED_NEW_OUTERMOST
	NewOutermostActivationPtr =
		(MR_Word) ps->MR_ps_outermost_activation_ptr;
  #endif

	MR_leave_instrumentation();
}
#else
	MR_fatal_error(MR_PROCNAME ": deep profiling not enabled");
#endif
#undef  MR_PROCNAME
#undef  MR_VERSION_AC
#undef  MR_CALL_PORT
#undef  MR_NEED_NEW_OUTERMOST

MR_r1 = TopCSD;
MR_r2 = MiddleCSD;
MR_r3 = NewOutermostActivationPtr;
}
MR_proceed();

MR_define_entry(mercury__profiling_builtin__non_exit_port_code_ac_2_0);
{
MR_Word TopCSD;
MR_Word MiddleCSD;

TopCSD = MR_r1;
MiddleCSD = MR_r2;

#define MR_PROCNAME "non_exit_port_code_ac"
#define MR_VERSION_AC
#define MR_EXIT_PORT
#undef  MR_NEED_NEW_OUTERMOST
/*
** Copyright (C) 2001-2002 The University of Melbourne.
** This file may only be copied under the terms of the GNU Library General
** Public License - see the file COPYING.LIB in the Mercury distribution.
*/

/*
** The implementation of {det,semi,non}_{exit,fail}_port_code_{ac,sr}.
**
** The code including this file should define the following macros:
** 
** MR_PROCNAME:			The name of the procedure whose body this is.
** MR_FAIL_PORT or MR_EXIT_PORT:
** 				Says which field to increment and whether the
**				procedure has detism det or failure.
** MR_VERSION_AC or MR_VERSION_SR:
** 				Says whether the procedure whose body this is
**				is intended for use with or without
**				MR_USE_ACTIVATION_COUNTS.
**
** The code including this file should have the following variables in scope:
**
** MiddleCSD:			The id of the current csd.
** TopCSD:			The id of the parent's csd.
** OldOutermostActivationPtr:	The id of the outermost activation of the
**				current user procedure before the current call
**				to it. Needed only with MR_VERSION_SR.
*/

#ifdef MR_DEEP_PROFILING
{
	MR_CallSiteDynamic	*csd;
	MR_ProcStatic		*ps;

	MR_enter_instrumentation();

	csd = (MR_CallSiteDynamic *) MiddleCSD;
	MR_deep_assert(csd, NULL, csd == MR_current_call_site_dynamic);

  #ifdef MR_DEEP_PROFILING_PORT_COUNTS
	/* increment exit/fail count */
    #if defined(MR_FAIL_PORT)
	csd->MR_csd_own.MR_own_fails++;
    #elif defined(MR_EXIT_PORT)
	csd->MR_csd_own.MR_own_exits++;
    #else
      #error "mercury_deep_leave_port_body.h: neither MR_FAIL_PORT nor MR_EXIT_PORT"
    #endif
  #endif

	MR_deep_assert(csd, NULL, csd->MR_csd_callee_ptr != NULL);
	ps = csd->MR_csd_callee_ptr->MR_pd_proc_static;
	MR_deep_assert(csd, ps, ps != NULL);

  #if defined(MR_VERSION_AC)
    #ifdef MR_USE_ACTIVATION_COUNTS
	/* decrement activation count */
	ps->MR_ps_activation_count--;
	MR_deep_assert(csd, ps, ps->MR_ps_activation_count >= 0);
    #else
	MR_fatal_error(MR_PROCNAME ": MR_USE_ACTIVATION_COUNTS not enabled");
    #endif
  #elif defined(MR_VERSION_SR)
    #ifndef MR_USE_ACTIVATION_COUNTS
	/* set outermost activation pointer */
	ps->MR_ps_outermost_activation_ptr =
		(MR_ProcDynamic *) OldOutermostActivationPtr;
    #else
	MR_fatal_error(MR_PROCNAME ": MR_USE_ACTIVATION_COUNTS enabled");
    #endif
  #else
    #error "mercury_deep_leave_port_body.h: neither MR_VERSION_AC nor MR_VERSION_SR"
  #endif

	/* set current csd */
	MR_current_call_site_dynamic = (MR_CallSiteDynamic *) TopCSD;

	MR_leave_instrumentation();

  	/*
	** For MR_FAIL_PORT code, the failure we should execute here
	** is handled by code inserted by the compiler.
	*/
}
#else
	MR_fatal_error(MR_PROCNAME ": deep profiling not enabled");
#endif
#undef  MR_PROCNAME
#undef  MR_VERSION_AC
#undef  MR_EXIT_PORT
#undef  MR_NEED_NEW_OUTERMOST

}
MR_proceed();

MR_define_entry(mercury__profiling_builtin__non_redo_port_code_ac_2_0);
{
MR_Word MiddleCSD;
MR_Word NewOutermostActivationPtr;

MiddleCSD = MR_r1;
NewOutermostActivationPtr = MR_r2;

#define MR_PROCNAME "non_redo_port_code_ac"
#define MR_VERSION_AC
#define MR_REDO_PORT
#undef  MR_NEED_NEW_OUTERMOST
/*
** Copyright (C) 2001-2002 The University of Melbourne.
** This file may only be copied under the terms of the GNU Library General
** Public License - see the file COPYING.LIB in the Mercury distribution.
*/

/*
** The implementation of non_redo_port_code_{ac,sr}.
**
** The code including this file should define the following macros:
** 
** MR_PROCNAME:			The name of the procedure whose body this is.
** MR_VERSION_AC or MR_VERSION_SR:
** 				Says whether the procedure whose body this is
**				is intended for use with or without
**				MR_USE_ACTIVATION_COUNTS.
**
** The code including this file should have the following variables in scope:
**
** MiddleCSD:			The id of the current csd.
** NewOutermostActivationPtr:	The id of the outermost activation of the
**				procedure being backtracked into after the
**				current call to it.
*/

#ifdef MR_DEEP_PROFILING
{
	MR_CallSiteDynamic	*csd;
	MR_ProcDynamic		*pd;
	MR_ProcStatic		*ps;

	MR_enter_instrumentation();
	csd = (MR_CallSiteDynamic *) MiddleCSD;
	MR_current_call_site_dynamic = csd;

  #ifdef MR_DEEP_PROFILING_PORT_COUNTS
	csd->MR_csd_own.MR_own_redos++;
  #endif

	pd = csd->MR_csd_callee_ptr;
	MR_deep_assert(csd, NULL, pd != NULL);
	ps = pd->MR_pd_proc_static;
	MR_deep_assert(csd, ps, ps != NULL);

  #if defined(MR_VERSION_AC)
    #ifdef MR_USE_ACTIVATION_COUNTS
	/* increment activation count */
	ps->MR_ps_activation_count++;
	ps->MR_ps_outermost_activation_ptr =
		(MR_ProcDynamic *) NewOutermostActivationPtr;
    #else
	MR_fatal_error(MR_PROCNAME ": MR_USE_ACTIVATION_COUNTS not enabled");
    #endif
  #elif defined(MR_VERSION_SR)
    #ifndef MR_USE_ACTIVATION_COUNTS
	/* set outermost activation pointer */
	ps->MR_ps_outermost_activation_ptr =
		(MR_ProcDynamic *) NewOutermostActivationPtr;
    #else
	MR_fatal_error(MR_PROCNAME ": MR_USE_ACTIVATION_COUNTS enabled");
    #endif
  #else
    #error "mercury_deep_redo_port_body.h: neither MR_VERSION_AC nor MR_VERSION_SR"
  #endif

	MR_leave_instrumentation();
}
#else
	MR_fatal_error(MR_PROCNAME ": deep profiling not enabled");
#endif
#undef  MR_PROCNAME
#undef  MR_VERSION_AC
#undef  MR_REDO_PORT
#undef  MR_NEED_NEW_OUTERMOST

}
MR_r1 = MR_FALSE; MR_proceed();

MR_define_entry(mercury__profiling_builtin__non_fail_port_code_ac_2_0);
{
MR_Word TopCSD;
MR_Word MiddleCSD;

TopCSD = MR_r1;
MiddleCSD = MR_r2;

#define MR_PROCNAME "non_fail_port_code_ac"
#define MR_VERSION_AC
#define MR_FAIL_PORT
#undef  MR_NEED_NEW_OUTERMOST
/*
** Copyright (C) 2001-2002 The University of Melbourne.
** This file may only be copied under the terms of the GNU Library General
** Public License - see the file COPYING.LIB in the Mercury distribution.
*/

/*
** The implementation of {det,semi,non}_{exit,fail}_port_code_{ac,sr}.
**
** The code including this file should define the following macros:
** 
** MR_PROCNAME:			The name of the procedure whose body this is.
** MR_FAIL_PORT or MR_EXIT_PORT:
** 				Says which field to increment and whether the
**				procedure has detism det or failure.
** MR_VERSION_AC or MR_VERSION_SR:
** 				Says whether the procedure whose body this is
**				is intended for use with or without
**				MR_USE_ACTIVATION_COUNTS.
**
** The code including this file should have the following variables in scope:
**
** MiddleCSD:			The id of the current csd.
** TopCSD:			The id of the parent's csd.
** OldOutermostActivationPtr:	The id of the outermost activation of the
**				current user procedure before the current call
**				to it. Needed only with MR_VERSION_SR.
*/

#ifdef MR_DEEP_PROFILING
{
	MR_CallSiteDynamic	*csd;
	MR_ProcStatic		*ps;

	MR_enter_instrumentation();

	csd = (MR_CallSiteDynamic *) MiddleCSD;
	MR_deep_assert(csd, NULL, csd == MR_current_call_site_dynamic);

  #ifdef MR_DEEP_PROFILING_PORT_COUNTS
	/* increment exit/fail count */
    #if defined(MR_FAIL_PORT)
	csd->MR_csd_own.MR_own_fails++;
    #elif defined(MR_EXIT_PORT)
	csd->MR_csd_own.MR_own_exits++;
    #else
      #error "mercury_deep_leave_port_body.h: neither MR_FAIL_PORT nor MR_EXIT_PORT"
    #endif
  #endif

	MR_deep_assert(csd, NULL, csd->MR_csd_callee_ptr != NULL);
	ps = csd->MR_csd_callee_ptr->MR_pd_proc_static;
	MR_deep_assert(csd, ps, ps != NULL);

  #if defined(MR_VERSION_AC)
    #ifdef MR_USE_ACTIVATION_COUNTS
	/* decrement activation count */
	ps->MR_ps_activation_count--;
	MR_deep_assert(csd, ps, ps->MR_ps_activation_count >= 0);
    #else
	MR_fatal_error(MR_PROCNAME ": MR_USE_ACTIVATION_COUNTS not enabled");
    #endif
  #elif defined(MR_VERSION_SR)
    #ifndef MR_USE_ACTIVATION_COUNTS
	/* set outermost activation pointer */
	ps->MR_ps_outermost_activation_ptr =
		(MR_ProcDynamic *) OldOutermostActivationPtr;
    #else
	MR_fatal_error(MR_PROCNAME ": MR_USE_ACTIVATION_COUNTS enabled");
    #endif
  #else
    #error "mercury_deep_leave_port_body.h: neither MR_VERSION_AC nor MR_VERSION_SR"
  #endif

	/* set current csd */
	MR_current_call_site_dynamic = (MR_CallSiteDynamic *) TopCSD;

	MR_leave_instrumentation();

  	/*
	** For MR_FAIL_PORT code, the failure we should execute here
	** is handled by code inserted by the compiler.
	*/
}
#else
	MR_fatal_error(MR_PROCNAME ": deep profiling not enabled");
#endif
#undef  MR_PROCNAME
#undef  MR_VERSION_AC
#undef  MR_FAIL_PORT
#undef  MR_NEED_NEW_OUTERMOST

}
MR_r1 = MR_FALSE; MR_proceed();

MR_define_entry(mercury__profiling_builtin__det_call_port_code_sr_4_0);
{
MR_Word ProcStatic;
MR_Word TopCSD;
MR_Word MiddleCSD;
MR_Word OldOutermostActivationPtr;

ProcStatic = MR_r1;

#define MR_PROCNAME "det_call_port_code_sr"
#define MR_VERSION_SR
#define MR_CALL_PORT
#undef  MR_NEED_NEW_OUTERMOST
/*
** Copyright (C) 2001-2002 The University of Melbourne.
** This file may only be copied under the terms of the GNU Library General
** Public License - see the file COPYING.LIB in the Mercury distribution.
*/

/*
** The implementation of {det,semi,non}_call_port_code_{ac,sr}.
**
** The code including this file should define the following macros:
** 
** MR_PROCNAME:			The name of the procedure whose body this is.
** MR_VERSION_AC or MR_VERSION_SR:
** 				Says whether the procedure whose body this is
**				is intended for use with or without
**				MR_USE_ACTIVATION_COUNTS.
** MR_NEED_NEW_OUTERMOST:	Says whether we need to know the new value of
**				the outermost activation pointer. Should be
**				true only for non_call_port_code_*.
**
** The code including this file should have the following variables in scope:
**
** ProcStatic:			The proc_static of the procedure whose call
**				port we are at.
** MiddleCSD:			The id of the current csd.
** TopCSD:			The id of the parent's csd.
** OldOutermostActivationPtr:	The id of the outermost activation of the
**				current user procedure before the call.
**				Needed only with MR_VERSION_SR.
** NewOutermostActivationPtr:	The id of the outermost activation of the
**				current user procedure after the call.
**				Needed only with MR_NEED_NEW_OUTERMOST.
*/

#ifdef MR_DEEP_PROFILING
{
	MR_CallSiteDynamic	*csd;
	MR_ProcStatic		*ps;

	MR_enter_instrumentation();

  #ifdef MR_DEEP_PROFILING_LOWLEVEL_DEBUG
	if (MR_calldebug && MR_lld_print_enabled) {
		MR_print_deep_prof_vars(stdout, MR_PROCNAME);
	}
  #endif

	TopCSD = (MR_Word) MR_current_call_site_dynamic;
	MiddleCSD = (MR_Word) MR_next_call_site_dynamic;
	csd = MR_next_call_site_dynamic;
	MR_current_call_site_dynamic = csd;
  #ifdef MR_DEEP_PROFILING_PORT_COUNTS
    #ifdef MR_DEEP_PROFILING_EXPLICIT_CALL_COUNTS
	csd->MR_csd_own.MR_own_calls++;
    #else
	/* calls are computed from the other counts */
    #endif
  #endif

  #ifdef MR_DEEP_PROFILING_LOWLEVEL_DEBUG
	/* After we copy it, MR_next_call_site_dynamic is not meaningful; */
	/* zeroing it makes debugging output less cluttered. */
	MR_next_call_site_dynamic = NULL;
  #endif

	ps = (MR_ProcStatic *) ProcStatic;
  #ifdef MR_VERSION_SR
	OldOutermostActivationPtr =
		(MR_Word) ps->MR_ps_outermost_activation_ptr;
  #endif

  #if defined(MR_VERSION_AC)
    #ifdef MR_USE_ACTIVATION_COUNTS
	MR_deep_assert(csd, ps, ps->MR_ps_activation_count == 0
		|| ps->MR_ps_outermost_activation_ptr != NULL);

      #ifdef MR_DEEP_PROFILING_STATISTICS
	if (csd->MR_csd_callee_ptr != NULL) {
		MR_deep_prof_call_old++;
	} else if (ps->MR_ps_activation_count > 0) {
		MR_deep_prof_call_rec++;
	} else {
		MR_deep_prof_call_new++;
	}
      #endif

	if (csd->MR_csd_callee_ptr != NULL) {
		if (ps->MR_ps_activation_count == 0) {
			ps->MR_ps_outermost_activation_ptr =
				csd->MR_csd_callee_ptr;
		}
	} else if (ps->MR_ps_activation_count > 0) {
		csd->MR_csd_callee_ptr = ps->MR_ps_outermost_activation_ptr;
	} else {
		MR_ProcDynamic	*pd;

		MR_new_proc_dynamic(pd, ps);
		csd->MR_csd_callee_ptr = pd;
		ps->MR_ps_outermost_activation_ptr = pd;
	}

	ps->MR_ps_activation_count++;
    #else
	MR_fatal_error(MR_PROCNAME ": MR_USE_ACTIVATION_COUNTS not enabled");
    #endif
  #elif defined(MR_VERSION_SR)
    #ifndef MR_USE_ACTIVATION_COUNTS
      #ifdef MR_DEEP_PROFILING_STATISTICS
	if (csd->MR_csd_callee_ptr != NULL) {
		MR_deep_prof_call_old++;
	} else if (ps->MR_ps_outermost_activation_ptr != NULL) {
		MR_deep_prof_call_rec++;
	} else {
		MR_deep_prof_call_new++;
	}
      #endif

	if (csd->MR_csd_callee_ptr != NULL) {
		ps->MR_ps_outermost_activation_ptr = csd->MR_csd_callee_ptr;
	} else if (ps->MR_ps_outermost_activation_ptr != NULL) {
		csd->MR_csd_callee_ptr = ps->MR_ps_outermost_activation_ptr;
	} else {
		MR_ProcDynamic	*pd;

		MR_new_proc_dynamic(pd, ps);
		csd->MR_csd_callee_ptr = pd;
		ps->MR_ps_outermost_activation_ptr = csd->MR_csd_callee_ptr;
	}
    #else
	MR_fatal_error(MR_PROCNAME ": MR_USE_ACTIVATION_COUNTS enabled");
    #endif
  #else
    #error "mercury_deep_call_port_body.h: neither MR_VERSION_AC nor MR_VERSION_SR"
  #endif

  #ifdef MR_NEED_NEW_OUTERMOST
	NewOutermostActivationPtr =
		(MR_Word) ps->MR_ps_outermost_activation_ptr;
  #endif

	MR_leave_instrumentation();
}
#else
	MR_fatal_error(MR_PROCNAME ": deep profiling not enabled");
#endif
#undef  MR_PROCNAME
#undef  MR_VERSION_SR
#undef  MR_CALL_PORT
#undef  MR_NEED_NEW_OUTERMOST

MR_r1 = TopCSD;
MR_r2 = MiddleCSD;
MR_r3 = OldOutermostActivationPtr;
}
MR_proceed();

MR_define_entry(mercury__profiling_builtin__det_exit_port_code_sr_3_0);
{
MR_Word TopCSD;
MR_Word MiddleCSD;
MR_Word OldOutermostActivationPtr;

TopCSD = MR_r1;
MiddleCSD = MR_r2;
OldOutermostActivationPtr = MR_r3;

#define MR_PROCNAME "det_exit_port_code_sr"
#define MR_VERSION_SR
#define MR_EXIT_PORT
#undef  MR_NEED_NEW_OUTERMOST
/*
** Copyright (C) 2001-2002 The University of Melbourne.
** This file may only be copied under the terms of the GNU Library General
** Public License - see the file COPYING.LIB in the Mercury distribution.
*/

/*
** The implementation of {det,semi,non}_{exit,fail}_port_code_{ac,sr}.
**
** The code including this file should define the following macros:
** 
** MR_PROCNAME:			The name of the procedure whose body this is.
** MR_FAIL_PORT or MR_EXIT_PORT:
** 				Says which field to increment and whether the
**				procedure has detism det or failure.
** MR_VERSION_AC or MR_VERSION_SR:
** 				Says whether the procedure whose body this is
**				is intended for use with or without
**				MR_USE_ACTIVATION_COUNTS.
**
** The code including this file should have the following variables in scope:
**
** MiddleCSD:			The id of the current csd.
** TopCSD:			The id of the parent's csd.
** OldOutermostActivationPtr:	The id of the outermost activation of the
**				current user procedure before the current call
**				to it. Needed only with MR_VERSION_SR.
*/

#ifdef MR_DEEP_PROFILING
{
	MR_CallSiteDynamic	*csd;
	MR_ProcStatic		*ps;

	MR_enter_instrumentation();

	csd = (MR_CallSiteDynamic *) MiddleCSD;
	MR_deep_assert(csd, NULL, csd == MR_current_call_site_dynamic);

  #ifdef MR_DEEP_PROFILING_PORT_COUNTS
	/* increment exit/fail count */
    #if defined(MR_FAIL_PORT)
	csd->MR_csd_own.MR_own_fails++;
    #elif defined(MR_EXIT_PORT)
	csd->MR_csd_own.MR_own_exits++;
    #else
      #error "mercury_deep_leave_port_body.h: neither MR_FAIL_PORT nor MR_EXIT_PORT"
    #endif
  #endif

	MR_deep_assert(csd, NULL, csd->MR_csd_callee_ptr != NULL);
	ps = csd->MR_csd_callee_ptr->MR_pd_proc_static;
	MR_deep_assert(csd, ps, ps != NULL);

  #if defined(MR_VERSION_AC)
    #ifdef MR_USE_ACTIVATION_COUNTS
	/* decrement activation count */
	ps->MR_ps_activation_count--;
	MR_deep_assert(csd, ps, ps->MR_ps_activation_count >= 0);
    #else
	MR_fatal_error(MR_PROCNAME ": MR_USE_ACTIVATION_COUNTS not enabled");
    #endif
  #elif defined(MR_VERSION_SR)
    #ifndef MR_USE_ACTIVATION_COUNTS
	/* set outermost activation pointer */
	ps->MR_ps_outermost_activation_ptr =
		(MR_ProcDynamic *) OldOutermostActivationPtr;
    #else
	MR_fatal_error(MR_PROCNAME ": MR_USE_ACTIVATION_COUNTS enabled");
    #endif
  #else
    #error "mercury_deep_leave_port_body.h: neither MR_VERSION_AC nor MR_VERSION_SR"
  #endif

	/* set current csd */
	MR_current_call_site_dynamic = (MR_CallSiteDynamic *) TopCSD;

	MR_leave_instrumentation();

  	/*
	** For MR_FAIL_PORT code, the failure we should execute here
	** is handled by code inserted by the compiler.
	*/
}
#else
	MR_fatal_error(MR_PROCNAME ": deep profiling not enabled");
#endif
#undef  MR_PROCNAME
#undef  MR_VERSION_SR
#undef  MR_EXIT_PORT
#undef  MR_NEED_NEW_OUTERMOST

}
MR_proceed();

MR_define_entry(mercury__profiling_builtin__semi_call_port_code_sr_4_0);
{
MR_Word ProcStatic;
MR_Word TopCSD;
MR_Word MiddleCSD;
MR_Word OldOutermostActivationPtr;

ProcStatic = MR_r1;

#define MR_PROCNAME "semi_call_port_code_sr"
#define MR_VERSION_SR
#define MR_CALL_PORT
#undef  MR_NEED_NEW_OUTERMOST
/*
** Copyright (C) 2001-2002 The University of Melbourne.
** This file may only be copied under the terms of the GNU Library General
** Public License - see the file COPYING.LIB in the Mercury distribution.
*/

/*
** The implementation of {det,semi,non}_call_port_code_{ac,sr}.
**
** The code including this file should define the following macros:
** 
** MR_PROCNAME:			The name of the procedure whose body this is.
** MR_VERSION_AC or MR_VERSION_SR:
** 				Says whether the procedure whose body this is
**				is intended for use with or without
**				MR_USE_ACTIVATION_COUNTS.
** MR_NEED_NEW_OUTERMOST:	Says whether we need to know the new value of
**				the outermost activation pointer. Should be
**				true only for non_call_port_code_*.
**
** The code including this file should have the following variables in scope:
**
** ProcStatic:			The proc_static of the procedure whose call
**				port we are at.
** MiddleCSD:			The id of the current csd.
** TopCSD:			The id of the parent's csd.
** OldOutermostActivationPtr:	The id of the outermost activation of the
**				current user procedure before the call.
**				Needed only with MR_VERSION_SR.
** NewOutermostActivationPtr:	The id of the outermost activation of the
**				current user procedure after the call.
**				Needed only with MR_NEED_NEW_OUTERMOST.
*/

#ifdef MR_DEEP_PROFILING
{
	MR_CallSiteDynamic	*csd;
	MR_ProcStatic		*ps;

	MR_enter_instrumentation();

  #ifdef MR_DEEP_PROFILING_LOWLEVEL_DEBUG
	if (MR_calldebug && MR_lld_print_enabled) {
		MR_print_deep_prof_vars(stdout, MR_PROCNAME);
	}
  #endif

	TopCSD = (MR_Word) MR_current_call_site_dynamic;
	MiddleCSD = (MR_Word) MR_next_call_site_dynamic;
	csd = MR_next_call_site_dynamic;
	MR_current_call_site_dynamic = csd;
  #ifdef MR_DEEP_PROFILING_PORT_COUNTS
    #ifdef MR_DEEP_PROFILING_EXPLICIT_CALL_COUNTS
	csd->MR_csd_own.MR_own_calls++;
    #else
	/* calls are computed from the other counts */
    #endif
  #endif

  #ifdef MR_DEEP_PROFILING_LOWLEVEL_DEBUG
	/* After we copy it, MR_next_call_site_dynamic is not meaningful; */
	/* zeroing it makes debugging output less cluttered. */
	MR_next_call_site_dynamic = NULL;
  #endif

	ps = (MR_ProcStatic *) ProcStatic;
  #ifdef MR_VERSION_SR
	OldOutermostActivationPtr =
		(MR_Word) ps->MR_ps_outermost_activation_ptr;
  #endif

  #if defined(MR_VERSION_AC)
    #ifdef MR_USE_ACTIVATION_COUNTS
	MR_deep_assert(csd, ps, ps->MR_ps_activation_count == 0
		|| ps->MR_ps_outermost_activation_ptr != NULL);

      #ifdef MR_DEEP_PROFILING_STATISTICS
	if (csd->MR_csd_callee_ptr != NULL) {
		MR_deep_prof_call_old++;
	} else if (ps->MR_ps_activation_count > 0) {
		MR_deep_prof_call_rec++;
	} else {
		MR_deep_prof_call_new++;
	}
      #endif

	if (csd->MR_csd_callee_ptr != NULL) {
		if (ps->MR_ps_activation_count == 0) {
			ps->MR_ps_outermost_activation_ptr =
				csd->MR_csd_callee_ptr;
		}
	} else if (ps->MR_ps_activation_count > 0) {
		csd->MR_csd_callee_ptr = ps->MR_ps_outermost_activation_ptr;
	} else {
		MR_ProcDynamic	*pd;

		MR_new_proc_dynamic(pd, ps);
		csd->MR_csd_callee_ptr = pd;
		ps->MR_ps_outermost_activation_ptr = pd;
	}

	ps->MR_ps_activation_count++;
    #else
	MR_fatal_error(MR_PROCNAME ": MR_USE_ACTIVATION_COUNTS not enabled");
    #endif
  #elif defined(MR_VERSION_SR)
    #ifndef MR_USE_ACTIVATION_COUNTS
      #ifdef MR_DEEP_PROFILING_STATISTICS
	if (csd->MR_csd_callee_ptr != NULL) {
		MR_deep_prof_call_old++;
	} else if (ps->MR_ps_outermost_activation_ptr != NULL) {
		MR_deep_prof_call_rec++;
	} else {
		MR_deep_prof_call_new++;
	}
      #endif

	if (csd->MR_csd_callee_ptr != NULL) {
		ps->MR_ps_outermost_activation_ptr = csd->MR_csd_callee_ptr;
	} else if (ps->MR_ps_outermost_activation_ptr != NULL) {
		csd->MR_csd_callee_ptr = ps->MR_ps_outermost_activation_ptr;
	} else {
		MR_ProcDynamic	*pd;

		MR_new_proc_dynamic(pd, ps);
		csd->MR_csd_callee_ptr = pd;
		ps->MR_ps_outermost_activation_ptr = csd->MR_csd_callee_ptr;
	}
    #else
	MR_fatal_error(MR_PROCNAME ": MR_USE_ACTIVATION_COUNTS enabled");
    #endif
  #else
    #error "mercury_deep_call_port_body.h: neither MR_VERSION_AC nor MR_VERSION_SR"
  #endif

  #ifdef MR_NEED_NEW_OUTERMOST
	NewOutermostActivationPtr =
		(MR_Word) ps->MR_ps_outermost_activation_ptr;
  #endif

	MR_leave_instrumentation();
}
#else
	MR_fatal_error(MR_PROCNAME ": deep profiling not enabled");
#endif
#undef  MR_PROCNAME
#undef  MR_VERSION_SR
#undef  MR_CALL_PORT
#undef  MR_NEED_NEW_OUTERMOST

MR_r1 = TopCSD;
MR_r2 = MiddleCSD;
MR_r3 = OldOutermostActivationPtr;
}
MR_proceed();

MR_define_entry(mercury__profiling_builtin__semi_exit_port_code_sr_3_0);
{
MR_Word TopCSD;
MR_Word MiddleCSD;
MR_Word OldOutermostActivationPtr;

TopCSD = MR_r1;
MiddleCSD = MR_r2;
OldOutermostActivationPtr = MR_r3;

#define MR_PROCNAME "semi_exit_port_code_sr"
#define MR_VERSION_SR
#define MR_EXIT_PORT
#undef  MR_NEED_NEW_OUTERMOST
/*
** Copyright (C) 2001-2002 The University of Melbourne.
** This file may only be copied under the terms of the GNU Library General
** Public License - see the file COPYING.LIB in the Mercury distribution.
*/

/*
** The implementation of {det,semi,non}_{exit,fail}_port_code_{ac,sr}.
**
** The code including this file should define the following macros:
** 
** MR_PROCNAME:			The name of the procedure whose body this is.
** MR_FAIL_PORT or MR_EXIT_PORT:
** 				Says which field to increment and whether the
**				procedure has detism det or failure.
** MR_VERSION_AC or MR_VERSION_SR:
** 				Says whether the procedure whose body this is
**				is intended for use with or without
**				MR_USE_ACTIVATION_COUNTS.
**
** The code including this file should have the following variables in scope:
**
** MiddleCSD:			The id of the current csd.
** TopCSD:			The id of the parent's csd.
** OldOutermostActivationPtr:	The id of the outermost activation of the
**				current user procedure before the current call
**				to it. Needed only with MR_VERSION_SR.
*/

#ifdef MR_DEEP_PROFILING
{
	MR_CallSiteDynamic	*csd;
	MR_ProcStatic		*ps;

	MR_enter_instrumentation();

	csd = (MR_CallSiteDynamic *) MiddleCSD;
	MR_deep_assert(csd, NULL, csd == MR_current_call_site_dynamic);

  #ifdef MR_DEEP_PROFILING_PORT_COUNTS
	/* increment exit/fail count */
    #if defined(MR_FAIL_PORT)
	csd->MR_csd_own.MR_own_fails++;
    #elif defined(MR_EXIT_PORT)
	csd->MR_csd_own.MR_own_exits++;
    #else
      #error "mercury_deep_leave_port_body.h: neither MR_FAIL_PORT nor MR_EXIT_PORT"
    #endif
  #endif

	MR_deep_assert(csd, NULL, csd->MR_csd_callee_ptr != NULL);
	ps = csd->MR_csd_callee_ptr->MR_pd_proc_static;
	MR_deep_assert(csd, ps, ps != NULL);

  #if defined(MR_VERSION_AC)
    #ifdef MR_USE_ACTIVATION_COUNTS
	/* decrement activation count */
	ps->MR_ps_activation_count--;
	MR_deep_assert(csd, ps, ps->MR_ps_activation_count >= 0);
    #else
	MR_fatal_error(MR_PROCNAME ": MR_USE_ACTIVATION_COUNTS not enabled");
    #endif
  #elif defined(MR_VERSION_SR)
    #ifndef MR_USE_ACTIVATION_COUNTS
	/* set outermost activation pointer */
	ps->MR_ps_outermost_activation_ptr =
		(MR_ProcDynamic *) OldOutermostActivationPtr;
    #else
	MR_fatal_error(MR_PROCNAME ": MR_USE_ACTIVATION_COUNTS enabled");
    #endif
  #else
    #error "mercury_deep_leave_port_body.h: neither MR_VERSION_AC nor MR_VERSION_SR"
  #endif

	/* set current csd */
	MR_current_call_site_dynamic = (MR_CallSiteDynamic *) TopCSD;

	MR_leave_instrumentation();

  	/*
	** For MR_FAIL_PORT code, the failure we should execute here
	** is handled by code inserted by the compiler.
	*/
}
#else
	MR_fatal_error(MR_PROCNAME ": deep profiling not enabled");
#endif
#undef  MR_PROCNAME
#undef  MR_VERSION_SR
#undef  MR_EXIT_PORT
#undef  MR_NEED_NEW_OUTERMOST

}
MR_proceed();

MR_define_entry(mercury__profiling_builtin__semi_fail_port_code_sr_3_0);
{
MR_Word TopCSD;
MR_Word MiddleCSD;
MR_Word OldOutermostActivationPtr;

TopCSD = MR_r1;
MiddleCSD = MR_r2;
OldOutermostActivationPtr = MR_r3;

#define MR_PROCNAME "semi_fail_port_code_sr"
#define MR_VERSION_SR
#define MR_FAIL_PORT
#undef  MR_NEED_NEW_OUTERMOST
/*
** Copyright (C) 2001-2002 The University of Melbourne.
** This file may only be copied under the terms of the GNU Library General
** Public License - see the file COPYING.LIB in the Mercury distribution.
*/

/*
** The implementation of {det,semi,non}_{exit,fail}_port_code_{ac,sr}.
**
** The code including this file should define the following macros:
** 
** MR_PROCNAME:			The name of the procedure whose body this is.
** MR_FAIL_PORT or MR_EXIT_PORT:
** 				Says which field to increment and whether the
**				procedure has detism det or failure.
** MR_VERSION_AC or MR_VERSION_SR:
** 				Says whether the procedure whose body this is
**				is intended for use with or without
**				MR_USE_ACTIVATION_COUNTS.
**
** The code including this file should have the following variables in scope:
**
** MiddleCSD:			The id of the current csd.
** TopCSD:			The id of the parent's csd.
** OldOutermostActivationPtr:	The id of the outermost activation of the
**				current user procedure before the current call
**				to it. Needed only with MR_VERSION_SR.
*/

#ifdef MR_DEEP_PROFILING
{
	MR_CallSiteDynamic	*csd;
	MR_ProcStatic		*ps;

	MR_enter_instrumentation();

	csd = (MR_CallSiteDynamic *) MiddleCSD;
	MR_deep_assert(csd, NULL, csd == MR_current_call_site_dynamic);

  #ifdef MR_DEEP_PROFILING_PORT_COUNTS
	/* increment exit/fail count */
    #if defined(MR_FAIL_PORT)
	csd->MR_csd_own.MR_own_fails++;
    #elif defined(MR_EXIT_PORT)
	csd->MR_csd_own.MR_own_exits++;
    #else
      #error "mercury_deep_leave_port_body.h: neither MR_FAIL_PORT nor MR_EXIT_PORT"
    #endif
  #endif

	MR_deep_assert(csd, NULL, csd->MR_csd_callee_ptr != NULL);
	ps = csd->MR_csd_callee_ptr->MR_pd_proc_static;
	MR_deep_assert(csd, ps, ps != NULL);

  #if defined(MR_VERSION_AC)
    #ifdef MR_USE_ACTIVATION_COUNTS
	/* decrement activation count */
	ps->MR_ps_activation_count--;
	MR_deep_assert(csd, ps, ps->MR_ps_activation_count >= 0);
    #else
	MR_fatal_error(MR_PROCNAME ": MR_USE_ACTIVATION_COUNTS not enabled");
    #endif
  #elif defined(MR_VERSION_SR)
    #ifndef MR_USE_ACTIVATION_COUNTS
	/* set outermost activation pointer */
	ps->MR_ps_outermost_activation_ptr =
		(MR_ProcDynamic *) OldOutermostActivationPtr;
    #else
	MR_fatal_error(MR_PROCNAME ": MR_USE_ACTIVATION_COUNTS enabled");
    #endif
  #else
    #error "mercury_deep_leave_port_body.h: neither MR_VERSION_AC nor MR_VERSION_SR"
  #endif

	/* set current csd */
	MR_current_call_site_dynamic = (MR_CallSiteDynamic *) TopCSD;

	MR_leave_instrumentation();

  	/*
	** For MR_FAIL_PORT code, the failure we should execute here
	** is handled by code inserted by the compiler.
	*/
}
#else
	MR_fatal_error(MR_PROCNAME ": deep profiling not enabled");
#endif
#undef  MR_PROCNAME
#undef  MR_VERSION_SR
#undef  MR_FAIL_PORT
#undef  MR_NEED_NEW_OUTERMOST

}
MR_r1 = MR_FALSE; MR_proceed();

MR_define_entry(mercury__profiling_builtin__non_call_port_code_sr_5_0);
{
MR_Word ProcStatic;
MR_Word TopCSD;
MR_Word MiddleCSD;
MR_Word OldOutermostActivationPtr;
MR_Word NewOutermostActivationPtr;

ProcStatic = MR_r1;

#define MR_PROCNAME "non_call_port_code_sr"
#define MR_VERSION_SR
#define MR_CALL_PORT
#define MR_NEED_NEW_OUTERMOST
/*
** Copyright (C) 2001-2002 The University of Melbourne.
** This file may only be copied under the terms of the GNU Library General
** Public License - see the file COPYING.LIB in the Mercury distribution.
*/

/*
** The implementation of {det,semi,non}_call_port_code_{ac,sr}.
**
** The code including this file should define the following macros:
** 
** MR_PROCNAME:			The name of the procedure whose body this is.
** MR_VERSION_AC or MR_VERSION_SR:
** 				Says whether the procedure whose body this is
**				is intended for use with or without
**				MR_USE_ACTIVATION_COUNTS.
** MR_NEED_NEW_OUTERMOST:	Says whether we need to know the new value of
**				the outermost activation pointer. Should be
**				true only for non_call_port_code_*.
**
** The code including this file should have the following variables in scope:
**
** ProcStatic:			The proc_static of the procedure whose call
**				port we are at.
** MiddleCSD:			The id of the current csd.
** TopCSD:			The id of the parent's csd.
** OldOutermostActivationPtr:	The id of the outermost activation of the
**				current user procedure before the call.
**				Needed only with MR_VERSION_SR.
** NewOutermostActivationPtr:	The id of the outermost activation of the
**				current user procedure after the call.
**				Needed only with MR_NEED_NEW_OUTERMOST.
*/

#ifdef MR_DEEP_PROFILING
{
	MR_CallSiteDynamic	*csd;
	MR_ProcStatic		*ps;

	MR_enter_instrumentation();

  #ifdef MR_DEEP_PROFILING_LOWLEVEL_DEBUG
	if (MR_calldebug && MR_lld_print_enabled) {
		MR_print_deep_prof_vars(stdout, MR_PROCNAME);
	}
  #endif

	TopCSD = (MR_Word) MR_current_call_site_dynamic;
	MiddleCSD = (MR_Word) MR_next_call_site_dynamic;
	csd = MR_next_call_site_dynamic;
	MR_current_call_site_dynamic = csd;
  #ifdef MR_DEEP_PROFILING_PORT_COUNTS
    #ifdef MR_DEEP_PROFILING_EXPLICIT_CALL_COUNTS
	csd->MR_csd_own.MR_own_calls++;
    #else
	/* calls are computed from the other counts */
    #endif
  #endif

  #ifdef MR_DEEP_PROFILING_LOWLEVEL_DEBUG
	/* After we copy it, MR_next_call_site_dynamic is not meaningful; */
	/* zeroing it makes debugging output less cluttered. */
	MR_next_call_site_dynamic = NULL;
  #endif

	ps = (MR_ProcStatic *) ProcStatic;
  #ifdef MR_VERSION_SR
	OldOutermostActivationPtr =
		(MR_Word) ps->MR_ps_outermost_activation_ptr;
  #endif

  #if defined(MR_VERSION_AC)
    #ifdef MR_USE_ACTIVATION_COUNTS
	MR_deep_assert(csd, ps, ps->MR_ps_activation_count == 0
		|| ps->MR_ps_outermost_activation_ptr != NULL);

      #ifdef MR_DEEP_PROFILING_STATISTICS
	if (csd->MR_csd_callee_ptr != NULL) {
		MR_deep_prof_call_old++;
	} else if (ps->MR_ps_activation_count > 0) {
		MR_deep_prof_call_rec++;
	} else {
		MR_deep_prof_call_new++;
	}
      #endif

	if (csd->MR_csd_callee_ptr != NULL) {
		if (ps->MR_ps_activation_count == 0) {
			ps->MR_ps_outermost_activation_ptr =
				csd->MR_csd_callee_ptr;
		}
	} else if (ps->MR_ps_activation_count > 0) {
		csd->MR_csd_callee_ptr = ps->MR_ps_outermost_activation_ptr;
	} else {
		MR_ProcDynamic	*pd;

		MR_new_proc_dynamic(pd, ps);
		csd->MR_csd_callee_ptr = pd;
		ps->MR_ps_outermost_activation_ptr = pd;
	}

	ps->MR_ps_activation_count++;
    #else
	MR_fatal_error(MR_PROCNAME ": MR_USE_ACTIVATION_COUNTS not enabled");
    #endif
  #elif defined(MR_VERSION_SR)
    #ifndef MR_USE_ACTIVATION_COUNTS
      #ifdef MR_DEEP_PROFILING_STATISTICS
	if (csd->MR_csd_callee_ptr != NULL) {
		MR_deep_prof_call_old++;
	} else if (ps->MR_ps_outermost_activation_ptr != NULL) {
		MR_deep_prof_call_rec++;
	} else {
		MR_deep_prof_call_new++;
	}
      #endif

	if (csd->MR_csd_callee_ptr != NULL) {
		ps->MR_ps_outermost_activation_ptr = csd->MR_csd_callee_ptr;
	} else if (ps->MR_ps_outermost_activation_ptr != NULL) {
		csd->MR_csd_callee_ptr = ps->MR_ps_outermost_activation_ptr;
	} else {
		MR_ProcDynamic	*pd;

		MR_new_proc_dynamic(pd, ps);
		csd->MR_csd_callee_ptr = pd;
		ps->MR_ps_outermost_activation_ptr = csd->MR_csd_callee_ptr;
	}
    #else
	MR_fatal_error(MR_PROCNAME ": MR_USE_ACTIVATION_COUNTS enabled");
    #endif
  #else
    #error "mercury_deep_call_port_body.h: neither MR_VERSION_AC nor MR_VERSION_SR"
  #endif

  #ifdef MR_NEED_NEW_OUTERMOST
	NewOutermostActivationPtr =
		(MR_Word) ps->MR_ps_outermost_activation_ptr;
  #endif

	MR_leave_instrumentation();
}
#else
	MR_fatal_error(MR_PROCNAME ": deep profiling not enabled");
#endif
#undef  MR_PROCNAME
#undef  MR_VERSION_SR
#undef  MR_CALL_PORT
#undef  MR_NEED_NEW_OUTERMOST

MR_r1 = TopCSD;
MR_r2 = MiddleCSD;
MR_r3 = OldOutermostActivationPtr;
MR_r4 = NewOutermostActivationPtr;
}
MR_proceed();

MR_define_entry(mercury__profiling_builtin__non_exit_port_code_sr_3_0);
{
MR_Word TopCSD;
MR_Word MiddleCSD;
MR_Word OldOutermostActivationPtr;

TopCSD = MR_r1;
MiddleCSD = MR_r2;
OldOutermostActivationPtr = MR_r3;

#define MR_PROCNAME "non_exit_port_code_sr"
#define MR_VERSION_SR
#define MR_EXIT_PORT
#undef  MR_NEED_NEW_OUTERMOST
/*
** Copyright (C) 2001-2002 The University of Melbourne.
** This file may only be copied under the terms of the GNU Library General
** Public License - see the file COPYING.LIB in the Mercury distribution.
*/

/*
** The implementation of {det,semi,non}_{exit,fail}_port_code_{ac,sr}.
**
** The code including this file should define the following macros:
** 
** MR_PROCNAME:			The name of the procedure whose body this is.
** MR_FAIL_PORT or MR_EXIT_PORT:
** 				Says which field to increment and whether the
**				procedure has detism det or failure.
** MR_VERSION_AC or MR_VERSION_SR:
** 				Says whether the procedure whose body this is
**				is intended for use with or without
**				MR_USE_ACTIVATION_COUNTS.
**
** The code including this file should have the following variables in scope:
**
** MiddleCSD:			The id of the current csd.
** TopCSD:			The id of the parent's csd.
** OldOutermostActivationPtr:	The id of the outermost activation of the
**				current user procedure before the current call
**				to it. Needed only with MR_VERSION_SR.
*/

#ifdef MR_DEEP_PROFILING
{
	MR_CallSiteDynamic	*csd;
	MR_ProcStatic		*ps;

	MR_enter_instrumentation();

	csd = (MR_CallSiteDynamic *) MiddleCSD;
	MR_deep_assert(csd, NULL, csd == MR_current_call_site_dynamic);

  #ifdef MR_DEEP_PROFILING_PORT_COUNTS
	/* increment exit/fail count */
    #if defined(MR_FAIL_PORT)
	csd->MR_csd_own.MR_own_fails++;
    #elif defined(MR_EXIT_PORT)
	csd->MR_csd_own.MR_own_exits++;
    #else
      #error "mercury_deep_leave_port_body.h: neither MR_FAIL_PORT nor MR_EXIT_PORT"
    #endif
  #endif

	MR_deep_assert(csd, NULL, csd->MR_csd_callee_ptr != NULL);
	ps = csd->MR_csd_callee_ptr->MR_pd_proc_static;
	MR_deep_assert(csd, ps, ps != NULL);

  #if defined(MR_VERSION_AC)
    #ifdef MR_USE_ACTIVATION_COUNTS
	/* decrement activation count */
	ps->MR_ps_activation_count--;
	MR_deep_assert(csd, ps, ps->MR_ps_activation_count >= 0);
    #else
	MR_fatal_error(MR_PROCNAME ": MR_USE_ACTIVATION_COUNTS not enabled");
    #endif
  #elif defined(MR_VERSION_SR)
    #ifndef MR_USE_ACTIVATION_COUNTS
	/* set outermost activation pointer */
	ps->MR_ps_outermost_activation_ptr =
		(MR_ProcDynamic *) OldOutermostActivationPtr;
    #else
	MR_fatal_error(MR_PROCNAME ": MR_USE_ACTIVATION_COUNTS enabled");
    #endif
  #else
    #error "mercury_deep_leave_port_body.h: neither MR_VERSION_AC nor MR_VERSION_SR"
  #endif

	/* set current csd */
	MR_current_call_site_dynamic = (MR_CallSiteDynamic *) TopCSD;

	MR_leave_instrumentation();

  	/*
	** For MR_FAIL_PORT code, the failure we should execute here
	** is handled by code inserted by the compiler.
	*/
}
#else
	MR_fatal_error(MR_PROCNAME ": deep profiling not enabled");
#endif
#undef  MR_PROCNAME
#undef  MR_VERSION_SR
#undef  MR_EXIT_PORT
#undef  MR_NEED_NEW_OUTERMOST

}
MR_proceed();

MR_define_entry(mercury__profiling_builtin__non_redo_port_code_sr_2_0);
{
MR_Word MiddleCSD;
MR_Word NewOutermostActivationPtr;

MiddleCSD = MR_r1;
NewOutermostActivationPtr = MR_r2;

#define MR_PROCNAME "non_redo_port_code_sr"
#define MR_VERSION_SR
#define MR_REDO_PORT
#undef  MR_NEED_NEW_OUTERMOST
/*
** Copyright (C) 2001-2002 The University of Melbourne.
** This file may only be copied under the terms of the GNU Library General
** Public License - see the file COPYING.LIB in the Mercury distribution.
*/

/*
** The implementation of non_redo_port_code_{ac,sr}.
**
** The code including this file should define the following macros:
** 
** MR_PROCNAME:			The name of the procedure whose body this is.
** MR_VERSION_AC or MR_VERSION_SR:
** 				Says whether the procedure whose body this is
**				is intended for use with or without
**				MR_USE_ACTIVATION_COUNTS.
**
** The code including this file should have the following variables in scope:
**
** MiddleCSD:			The id of the current csd.
** NewOutermostActivationPtr:	The id of the outermost activation of the
**				procedure being backtracked into after the
**				current call to it.
*/

#ifdef MR_DEEP_PROFILING
{
	MR_CallSiteDynamic	*csd;
	MR_ProcDynamic		*pd;
	MR_ProcStatic		*ps;

	MR_enter_instrumentation();
	csd = (MR_CallSiteDynamic *) MiddleCSD;
	MR_current_call_site_dynamic = csd;

  #ifdef MR_DEEP_PROFILING_PORT_COUNTS
	csd->MR_csd_own.MR_own_redos++;
  #endif

	pd = csd->MR_csd_callee_ptr;
	MR_deep_assert(csd, NULL, pd != NULL);
	ps = pd->MR_pd_proc_static;
	MR_deep_assert(csd, ps, ps != NULL);

  #if defined(MR_VERSION_AC)
    #ifdef MR_USE_ACTIVATION_COUNTS
	/* increment activation count */
	ps->MR_ps_activation_count++;
	ps->MR_ps_outermost_activation_ptr =
		(MR_ProcDynamic *) NewOutermostActivationPtr;
    #else
	MR_fatal_error(MR_PROCNAME ": MR_USE_ACTIVATION_COUNTS not enabled");
    #endif
  #elif defined(MR_VERSION_SR)
    #ifndef MR_USE_ACTIVATION_COUNTS
	/* set outermost activation pointer */
	ps->MR_ps_outermost_activation_ptr =
		(MR_ProcDynamic *) NewOutermostActivationPtr;
    #else
	MR_fatal_error(MR_PROCNAME ": MR_USE_ACTIVATION_COUNTS enabled");
    #endif
  #else
    #error "mercury_deep_redo_port_body.h: neither MR_VERSION_AC nor MR_VERSION_SR"
  #endif

	MR_leave_instrumentation();
}
#else
	MR_fatal_error(MR_PROCNAME ": deep profiling not enabled");
#endif
#undef  MR_PROCNAME
#undef  MR_VERSION_SR
#undef  MR_REDO_PORT
#undef  MR_NEED_NEW_OUTERMOST

}
MR_r1 = MR_FALSE; MR_proceed();

MR_define_entry(mercury__profiling_builtin__non_fail_port_code_sr_3_0);
{
MR_Word TopCSD;
MR_Word MiddleCSD;
MR_Word OldOutermostActivationPtr;

TopCSD = MR_r1;
MiddleCSD = MR_r2;
OldOutermostActivationPtr = MR_r3;

#define MR_PROCNAME "non_fail_port_code_sr"
#define MR_VERSION_SR
#define MR_FAIL_PORT
#undef  MR_NEED_NEW_OUTERMOST
/*
** Copyright (C) 2001-2002 The University of Melbourne.
** This file may only be copied under the terms of the GNU Library General
** Public License - see the file COPYING.LIB in the Mercury distribution.
*/

/*
** The implementation of {det,semi,non}_{exit,fail}_port_code_{ac,sr}.
**
** The code including this file should define the following macros:
** 
** MR_PROCNAME:			The name of the procedure whose body this is.
** MR_FAIL_PORT or MR_EXIT_PORT:
** 				Says which field to increment and whether the
**				procedure has detism det or failure.
** MR_VERSION_AC or MR_VERSION_SR:
** 				Says whether the procedure whose body this is
**				is intended for use with or without
**				MR_USE_ACTIVATION_COUNTS.
**
** The code including this file should have the following variables in scope:
**
** MiddleCSD:			The id of the current csd.
** TopCSD:			The id of the parent's csd.
** OldOutermostActivationPtr:	The id of the outermost activation of the
**				current user procedure before the current call
**				to it. Needed only with MR_VERSION_SR.
*/

#ifdef MR_DEEP_PROFILING
{
	MR_CallSiteDynamic	*csd;
	MR_ProcStatic		*ps;

	MR_enter_instrumentation();

	csd = (MR_CallSiteDynamic *) MiddleCSD;
	MR_deep_assert(csd, NULL, csd == MR_current_call_site_dynamic);

  #ifdef MR_DEEP_PROFILING_PORT_COUNTS
	/* increment exit/fail count */
    #if defined(MR_FAIL_PORT)
	csd->MR_csd_own.MR_own_fails++;
    #elif defined(MR_EXIT_PORT)
	csd->MR_csd_own.MR_own_exits++;
    #else
      #error "mercury_deep_leave_port_body.h: neither MR_FAIL_PORT nor MR_EXIT_PORT"
    #endif
  #endif

	MR_deep_assert(csd, NULL, csd->MR_csd_callee_ptr != NULL);
	ps = csd->MR_csd_callee_ptr->MR_pd_proc_static;
	MR_deep_assert(csd, ps, ps != NULL);

  #if defined(MR_VERSION_AC)
    #ifdef MR_USE_ACTIVATION_COUNTS
	/* decrement activation count */
	ps->MR_ps_activation_count--;
	MR_deep_assert(csd, ps, ps->MR_ps_activation_count >= 0);
    #else
	MR_fatal_error(MR_PROCNAME ": MR_USE_ACTIVATION_COUNTS not enabled");
    #endif
  #elif defined(MR_VERSION_SR)
    #ifndef MR_USE_ACTIVATION_COUNTS
	/* set outermost activation pointer */
	ps->MR_ps_outermost_activation_ptr =
		(MR_ProcDynamic *) OldOutermostActivationPtr;
    #else
	MR_fatal_error(MR_PROCNAME ": MR_USE_ACTIVATION_COUNTS enabled");
    #endif
  #else
    #error "mercury_deep_leave_port_body.h: neither MR_VERSION_AC nor MR_VERSION_SR"
  #endif

	/* set current csd */
	MR_current_call_site_dynamic = (MR_CallSiteDynamic *) TopCSD;

	MR_leave_instrumentation();

  	/*
	** For MR_FAIL_PORT code, the failure we should execute here
	** is handled by code inserted by the compiler.
	*/
}
#else
	MR_fatal_error(MR_PROCNAME ": deep profiling not enabled");
#endif
#undef  MR_PROCNAME
#undef  MR_VERSION_SR
#undef  MR_FAIL_PORT
#undef  MR_NEED_NEW_OUTERMOST

}
MR_r1 = MR_FALSE; MR_proceed();
MR_END_MODULE

#else   /* MR_HIGHLEVEL_CODE */

extern void MR_CALL
mercury__profiling_builtin__det_call_port_code_ac_3_p_0(
    void *arg1, void *arg2, void *arg3);
void MR_CALL
mercury__profiling_builtin__det_call_port_code_ac_3_p_0(
    void *arg1, void *arg2, void *arg3)
{ MR_fatal_error("call to mercury__profiling_builtin__det_call_port_code_ac_3_p_0"); }

extern void MR_CALL
mercury__profiling_builtin__det_exit_port_code_ac_2_p_0(
    void *arg1, void *arg2);
void MR_CALL
mercury__profiling_builtin__det_exit_port_code_ac_2_p_0(
    void *arg1, void *arg2)
{ MR_fatal_error("call to mercury__profiling_builtin__det_exit_port_code_ac_2_p_0"); }

extern void MR_CALL
mercury__profiling_builtin__semi_call_port_code_ac_3_p_0(
    void *arg1, void *arg2, void *arg3);
void MR_CALL
mercury__profiling_builtin__semi_call_port_code_ac_3_p_0(
    void *arg1, void *arg2, void *arg3)
{ MR_fatal_error("call to mercury__profiling_builtin__semi_call_port_code_ac_3_p_0"); }

extern void MR_CALL
mercury__profiling_builtin__semi_exit_port_code_ac_2_p_0(
    void *arg1, void *arg2);
void MR_CALL
mercury__profiling_builtin__semi_exit_port_code_ac_2_p_0(
    void *arg1, void *arg2)
{ MR_fatal_error("call to mercury__profiling_builtin__semi_exit_port_code_ac_2_p_0"); }

extern void MR_CALL
mercury__profiling_builtin__semi_fail_port_code_ac_2_p_0(
    void *arg1, void *arg2);
void MR_CALL
mercury__profiling_builtin__semi_fail_port_code_ac_2_p_0(
    void *arg1, void *arg2)
{ MR_fatal_error("call to mercury__profiling_builtin__semi_fail_port_code_ac_2_p_0"); }

extern void MR_CALL
mercury__profiling_builtin__non_call_port_code_ac_4_p_0(
    void *arg1, void *arg2, void *arg3, void *arg4);
void MR_CALL
mercury__profiling_builtin__non_call_port_code_ac_4_p_0(
    void *arg1, void *arg2, void *arg3, void *arg4)
{ MR_fatal_error("call to mercury__profiling_builtin__non_call_port_code_ac_4_p_0"); }

extern void MR_CALL
mercury__profiling_builtin__non_exit_port_code_ac_2_p_0(
    void *arg1, void *arg2);
void MR_CALL
mercury__profiling_builtin__non_exit_port_code_ac_2_p_0(
    void *arg1, void *arg2)
{ MR_fatal_error("call to mercury__profiling_builtin__non_exit_port_code_ac_2_p_0"); }

extern void MR_CALL
mercury__profiling_builtin__non_redo_port_code_ac_2_p_0(
    void *arg1, void *arg2);
void MR_CALL
mercury__profiling_builtin__non_redo_port_code_ac_2_p_0(
    void *arg1, void *arg2)
{ MR_fatal_error("call to mercury__profiling_builtin__non_redo_port_code_ac_2_p_0"); }

extern void MR_CALL
mercury__profiling_builtin__non_fail_port_code_ac_2_p_0(
    void *arg1, void *arg2);
void MR_CALL
mercury__profiling_builtin__non_fail_port_code_ac_2_p_0(
    void *arg1, void *arg2)
{ MR_fatal_error("call to mercury__profiling_builtin__non_fail_port_code_ac_2_p_0"); }

extern void MR_CALL
mercury__profiling_builtin__det_call_port_code_sr_4_p_0(
    void *arg1, void *arg2, void *arg3, void *arg4);
void MR_CALL
mercury__profiling_builtin__det_call_port_code_sr_4_p_0(
    void *arg1, void *arg2, void *arg3, void *arg4)
{ MR_fatal_error("call to mercury__profiling_builtin__det_call_port_code_sr_4_p_0"); }

extern void MR_CALL
mercury__profiling_builtin__det_exit_port_code_sr_3_p_0(
    void *arg1, void *arg2, void *arg3);
void MR_CALL
mercury__profiling_builtin__det_exit_port_code_sr_3_p_0(
    void *arg1, void *arg2, void *arg3)
{ MR_fatal_error("call to mercury__profiling_builtin__det_exit_port_code_sr_3_p_0"); }

extern void MR_CALL
mercury__profiling_builtin__semi_call_port_code_sr_4_p_0(
    void *arg1, void *arg2, void *arg3, void *arg4);
void MR_CALL
mercury__profiling_builtin__semi_call_port_code_sr_4_p_0(
    void *arg1, void *arg2, void *arg3, void *arg4)
{ MR_fatal_error("call to mercury__profiling_builtin__semi_call_port_code_sr_4_p_0"); }

extern void MR_CALL
mercury__profiling_builtin__semi_exit_port_code_sr_3_p_0(
    void *arg1, void *arg2, void *arg3);
void MR_CALL
mercury__profiling_builtin__semi_exit_port_code_sr_3_p_0(
    void *arg1, void *arg2, void *arg3)
{ MR_fatal_error("call to mercury__profiling_builtin__semi_exit_port_code_sr_3_p_0"); }

extern void MR_CALL
mercury__profiling_builtin__semi_fail_port_code_sr_3_p_0(
    void *arg1, void *arg2, void *arg3);
void MR_CALL
mercury__profiling_builtin__semi_fail_port_code_sr_3_p_0(
    void *arg1, void *arg2, void *arg3)
{ MR_fatal_error("call to mercury__profiling_builtin__semi_fail_port_code_sr_3_p_0"); }

extern void MR_CALL
mercury__profiling_builtin__non_call_port_code_sr_5_p_0(
    void *arg1, void *arg2, void *arg3, void *arg4, void *arg5);
void MR_CALL
mercury__profiling_builtin__non_call_port_code_sr_5_p_0(
    void *arg1, void *arg2, void *arg3, void *arg4, void *arg5)
{ MR_fatal_error("call to mercury__profiling_builtin__non_call_port_code_sr_5_p_0"); }

extern void MR_CALL
mercury__profiling_builtin__non_exit_port_code_sr_3_p_0(
    void *arg1, void *arg2, void *arg3);
void MR_CALL
mercury__profiling_builtin__non_exit_port_code_sr_3_p_0(
    void *arg1, void *arg2, void *arg3)
{ MR_fatal_error("call to mercury__profiling_builtin__non_exit_port_code_sr_3_p_0"); }

extern void MR_CALL
mercury__profiling_builtin__non_redo_port_code_sr_2_p_0(
    void *arg1, void *arg2);
void MR_CALL
mercury__profiling_builtin__non_redo_port_code_sr_2_p_0(
    void *arg1, void *arg2)
{ MR_fatal_error("call to mercury__profiling_builtin__non_redo_port_code_sr_2_p_0"); }

extern void MR_CALL
mercury__profiling_builtin__non_fail_port_code_sr_3_p_0(
    void *arg1, void *arg2, void *arg3);
void MR_CALL
mercury__profiling_builtin__non_fail_port_code_sr_3_p_0(
    void *arg1, void *arg2, void *arg3)
{ MR_fatal_error("call to mercury__profiling_builtin__non_fail_port_code_sr_3_p_0"); }

#endif  /* ! MR_HIGHLEVEL_CODE */
 
/* Ensure that the initialization code for the above module gets to run. */
/*
INIT mercury_sys_init_runtime_profiling_builtin_module
*/

/* forward declarations to suppress gcc -Wmissing-decl warnings */
void mercury_sys_init_runtime_profiling_builtin_module_init(void);
void mercury_sys_init_runtime_profiling_builtin_module_init_type_tables(void);
#ifdef  MR_DEEP_PROFILING
void mercury_sys_init_runtime_profiling_builtin_module_write_out_proc_statics(FILE *fp);
#endif

void mercury_sys_init_runtime_profiling_builtin_module_init(void)
{
#ifndef  MR_HIGHLEVEL_CODE
        runtime_profiling_builtin_module();
#endif
}

void mercury_sys_init_runtime_profiling_builtin_module_init_type_tables(void)
{
        /* no types to register */
}

#ifdef  MR_DEEP_PROFILING
void mercury_sys_init_runtime_profiling_builtin_module_write_out_proc_statics(FILE *fp)
{
        /* no proc_statics to write out */
}
#endif
