/*******************************************************************************
 * Copyright (C) 2004-2007 Intel Corp. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *   - Redistributions of source code must retain the above copyright notice,
 *     this list of conditions and the following disclaimer.
 * 
 *   - Redistributions in binary form must reproduce the above copyright notice,
 *     this list of conditions and the following disclaimer in the documentation
 *     and/or other materials provided with the distribution.
 * 
 *   - Neither the name of Intel Corp. nor the names of its
 *     contributors may be used to endorse or promote products derived from this
 *     software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL Intel Corp. OR THE CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *******************************************************************************/

#ifndef _IME_GUI_COMMANDS_H
#define _IME_GUI_COMMANDS_H

#include <string>

class IMEGuiNotifications;

//*****************************************************************************
//
// Class:	    IMEGuiCommands
//
// Description:	    This is an interface class that represents all the commands 
//                  that the gui of the MEStatus application can perform on its 
//                  logic.
//
//*****************************************************************************
class IMEGuiCommands
{
public:
        virtual bool Init(IMEGuiNotifications* pMEGuiNotifications) = 0;
	virtual void SetEnablement(IPCAMTStatus::Enablement enablement) = 0;
	virtual void SetPopupForCurrentUser(bool bPopupForCurrentUser) = 0;
	virtual bool GetPopupForCurrentUser() const = 0;
	virtual std::string GetOEMUrl() const = 0;
	virtual std::string GetDefaultOEMUrl() const = 0;
	virtual unsigned long GetCheckAMTStatusTimeout() const = 0;
	virtual ~IMEGuiCommands() {}
};

#endif //_IME_GUI_COMMANDS_H
