/*
------------------------------------------------------------------------------
MetaCam - Extract EXIF information from digital camera files, with
support for Vendor specific blocks.
Copyright (C) 2000 Daniel Stephens (daniel@cheeseplant.org)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
------------------------------------------------------------------------------
*/

#include "dpyfuncs.h"

static const char *rcsid="$Id: exiftags.cc,v 1.2 2000/05/29 22:11:28 daniel Exp $";

// Many of these from the TIFF V6.0 Standard
// Extra EXIF references from:
//       http://www.butaman.ne.jp/~tsuruzoh/Computer/Digicams/exif-e.html

knowntag main_known[] = {
    {306,     2, 0, "         Image Creation Date", dpyString},
    {271,     2, 0, "                        Make", dpyString},
    {272,     2, 0, "                       Model", dpyString},
    {305,     2, 0, "            Software Version", dpyString},
    {296,     3, 0, "             Resolution Unit", dpyResolutionType},
    {282,     5, 0, "                X Resolution", dpyResolution},
    {283,     5, 0, "                Y Resolution", dpyResolution},
    {277,     3, 0, "           Samples Per Pixel", dpyUnsigned},
    {258,     3, 0, "             Bits Per Sample", dpyBitsPerSample},
    {270,     2, 0, "           Image Description", dpyString},
    {513,     4, 0, "            Jpeg File Format", dpyYes},
    {262,     3, 0, "  Photometric Interpretation", dpyPhotometric},
    {259,     3, 0, "                 Compression", dpyCompression},
    {0x0213,  3, 0, "           YCbCr Positioning", dpyYCbCrPositioning},
    {0x0112,  3, 1, "               [Orientation]", 0},
    {0x013E,  5, 1, "               [White Point]", 0},
    {0x013F,  5, 1, "      [Primary Chromacities]", 0},
    {0x0211,  5, 1, "        [YCbCr Coefficients]", 0},
    {0x0214,  5, 1, "     [Reference Black/White]", 0},

    {257,     3, 1, "                Image Length", dpyNULL},
    {257,     4, 1, "                Image Length", dpyNULL},
    {256,     3, 1, "                 Image Width", dpyNULL},
    {256,     4, 1, "                 Image Width", dpyNULL},
    {278,     3, 2, "              Rows Per Strip", dpyNULL},
    {278,     4, 2, "              Rows Per Strip", dpyNULL},
    {273,     3, 2, "               Strip Offsets", dpyNULL},
    {273,     4, 2, "               Strip Offsets", dpyNULL},
    {279,     3, 2, "           Strip Byte Counts", dpyNULL},
    {279,     4, 2, "           Strip Byte Counts", dpyNULL},
    {284,     3, 2, "        Planar Configuration", dpyNULL},
    {514,     4, 2, " JPEG Interchange Fmt Length", dpyNULL},
    {515,     3, 2, "       JPEG Restart Interval", dpyNULL},

    {0,0,0,0}
};

knowntag exif_known[] = {
    {0x9290,  2, 0, "    Sub-Second Creation Time", dpyString},
    {0x9003,  2, 0, "          Image Capture Date", dpyString},
    {0x9291,  2, 0, "     Sub-Second Capture Time", dpyString},
    {0x9004,  2, 0, "        Image Digitized Date", dpyString},
    {0x9292,  2, 0, "   Sub-Second Digitized Time", dpyString},
    {0x9204, 10, 0, "               Exposure Bias", dpyExpAdjust},
    {0x920a,  5, 0, "                Focal Length", dpyZoom},
    {0x829a,  5, 0, "               Exposure Time", dpyShutter},

    {0x829d,  5, 0, "                    Aperture", dpyAperture},
    {0xa002,  3, 0, "            Exif Image Width", dpyPixels},
    {0xa002,  4, 0, "            Exif Image Width", dpyPixels},
    {0xa003,  3, 0, "           Exif Image Height", dpyPixels},
    {0xa003,  4, 0, "           Exif Image Height", dpyPixels},

    {0x8822,  3, 0, "            Exposure Program", dpyExposureProgram},
    {0x8827,  3, 0, "            ISO Speed Rating", dpyISO},
    {0x9207,  3, 0, "               Metering Mode", dpyMeteringMode},
    {0x9000,  7, 0, "                EXIF Version", dpyExifVersion},
    {0xa000,  7, 0, "            FlashPix Version", dpyExifVersion},
    {0x9208,  3, 0, "  Light Source/White Balance", dpyLightSource},
    {0x9209,  3, 0, "                       Flash", dpyYesNo},
    {0xa217,  3, 0, "              Sensing Method", dpySensingMethod},
    {0x9102,  5, 0, "   Compressed Bits Per Pixel", dpyRationalAsDouble},
    {0x9202,  5, 0, "              Aperture Value", dpyExifAperture},
    {0x9203,  10,0, "            Brightness Value", dpyExpAdjust},
    {0x9205,  5, 0, "          Max Aperture Value", dpyExifAperture},
    {0xa210,  3, 0, " Focal Plane Resolution Unit", dpyResolutionType},
    {0xa20e,  5, 0, "    Focal Plane X Resolution", dpyResolution},
    {0xa20f,  5, 0, "    Focal Plane Y Resolution", dpyResolution},
    {0x8298,  2, 0, "                   Copyright", dpyString},
    {0x9201,  10,0, "         Shutter Speed Value", dpyExifShutter},

    {0x9101,  7, 1, "   [Component Configuration]", 0},
    {0x9206,  10,1, "          [Subject Distance]", 0},
    {0x9286,  7, 1, "              [User Comment]", 0},

    {0xa001,  3, 1, "                [ColorSpace]", 0},
    {0xa004,  2, 1, "        [Related Sound File]", 0},
    {0xa005,  4, 2, "[ExifInteroperabilityOffset]", 0},
    {0xa300,  7, 1, "               [File Source]", 0},
    {0xa301,  7, 1, "                [Scene Type]", 0},
    {0xa302,  7, 1, "               [CFA Pattern]", 0},
    

    {0,0,0,0}
};

knowntag empty_known[] = {
    {0,0,0,0}
};

