/***************************** LICENSE START ***********************************

 Copyright 2014 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQFolderItemProperty_H
#define MvQFolderItemProperty_H

#include <QFont>
#include <QMap>
#include <QFontMetrics> 

#include "Desktop.h"

class MvQAbstractIconItemProperty
{
public:   	
  	MvQAbstractIconItemProperty();
	
	int iconSize() const {return iconSize_;}
	QFont font() const {return font_;}
	float scaling() const {return scaling_;}
	int textHeight() const {return fm_.height();}
	int textOffset() const {return textOffset_;}	
        bool setIconSize(int);

	virtual QPoint position(QString,QPoint)=0;
	virtual QPoint positionFromHotSpot(QString name, QPoint pos,QPointF hotSpotAtPos)=0;
	virtual QPoint referencePosition(QString,QPoint)=0;
	virtual QPoint adjsutReferencePosition(QString,QString,QPoint)=0;	
	virtual QSize size(QString)=0;
  
protected:
    	virtual void update()=0;
  	
	int iconSize_;
	const int refIconSize_;
	float scaling_;
	
	QFont font_;  
	QFont refFont_;
	QFontMetrics fm_;
	QFontMetrics refFm_; 
	int height_;
	int refHeight_;
	int textOffset_;
};	

class MvQClassicIconItemProperty : public MvQAbstractIconItemProperty
{
public:    	
  	MvQClassicIconItemProperty();

	QPoint position(QString,QPoint);
	QPoint positionFromHotSpot(QString name, QPoint pos,QPointF hotSpotAtPos);
	QPoint referencePosition(QString,QPoint);
	QPoint adjsutReferencePosition(QString,QString,QPoint);	
	QSize size(QString);
protected:	
	void update();
};	

class MvQSimpleIconItemProperty : public MvQAbstractIconItemProperty
{
public:    	
  	MvQSimpleIconItemProperty();

	QPoint position(QString,QPoint);
	QPoint positionFromHotSpot(QString name, QPoint pos,QPointF hotSpotAtPos);
	QPoint referencePosition(QString,QPoint);
	QPoint adjsutReferencePosition(QString,QString,QPoint);	
	QSize size(QString);
protected:	
	void update();
};	

class MvQDetailedIconItemProperty : public MvQAbstractIconItemProperty
{
public:    	
  	MvQDetailedIconItemProperty();

	QPoint position(QString,QPoint);
	QPoint positionFromHotSpot(QString name, QPoint pos,QPointF hotSpotAtPos);
	QPoint referencePosition(QString,QPoint);
	QPoint adjsutReferencePosition(QString,QString,QPoint);	
	QSize size(QString);
protected:	
	void update();
};	


class MvQFolderItemProperty
{
public:
    	//enum TextPosMode {TextBelow,TextBeside};
  
  	MvQFolderItemProperty();
	~MvQFolderItemProperty();
	int iconSize();
	float scaling();	
	QFont font(); 
        QSize size(QString);
        int textHeight();
	int textOffset();
	
        bool setIconSize(int);
	QPoint position(QString,QPoint);
	QPoint positionFromHotSpot(QString name, QPoint pos,QPointF hotSpotAtPos);
	QPoint referencePosition(QString,QPoint);
	QPoint adjsutReferencePosition(QString,QString,QPoint);
	void setViewMode(Desktop::FolderViewMode);
	Desktop::FolderViewMode viewMode() const {return viewMode_;}
	
protected:	
	int iconSize_;
  	Desktop::FolderViewMode viewMode_;
	QMap<Desktop::FolderViewMode,MvQAbstractIconItemProperty*> prop_;
	MvQAbstractIconItemProperty* current_;
	
	
};

#endif