/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include <QtGui>

#include "FunctionListDialog.h"


FunctionListDialog::FunctionListDialog(QString &functionListFilePath, QWidget *parent) : QDialog(parent)
{
    setupUi(this); // this sets up GUI// setupFileMenu();


    // load the fucntion list

    QFile file(functionListFilePath);

    if (file.open(QFile::ReadOnly | QFile::Text))  // try to open in read-only mode
    {
        QTextStream in(&file);

        while (!file.atEnd())   // each line in the file is a function name to add to the list
        {
            QTreeWidgetItem *item;
            QString s = file.readLine();
            s = s.trimmed();  // note: the Qt docs say that trimmed() should not be necessary, but it is!

            item = new QTreeWidgetItem(treeWidget);  // create a new item for the tree
            item->setText (0, s);                    // set its label
        }

        treeWidget->sortItems(0, Qt::AscendingOrder);  // items should start alphabetically sorted (a->z)
    }
    
    else
    {
        // could not load the function list file

        QMessageBox::warning(this, tr("Function List"),
                             tr("Cannot read file %1:\n%2.")
                             .arg(functionListFilePath)
                             .arg(file.errorString()));
    }


    // set up the signal/slot connections

    connect (insertButton, SIGNAL(clicked()), this, SLOT(onInsertButtonClicked()));
    connect (treeWidget,   SIGNAL(itemDoubleClicked(QTreeWidgetItem*, int)), this, SLOT(onItemDoubleClicked(QTreeWidgetItem*, int)));
}


FunctionListDialog::~FunctionListDialog()
{

}



// ---------------------------------------------------------------------------
// FunctionListDialog::setupUIBeforeShow
// sets up UI elements before the dialog is displayed.
// ---------------------------------------------------------------------------

void FunctionListDialog::setupUIBeforeShow ()
{
}


// ---------------------------------------------------------------------------
// FunctionListDialog::setFont
// sets the font used in the selection box
// ---------------------------------------------------------------------------

void FunctionListDialog::setFont(const QFont &font)
{
    treeWidget->setFont(font);
    insertButton->setFont(font);
    buttonBox->setFont(font);
}



// ---------------------------------------------------------------------------
// FunctionListDialog::onItemDoubleClicked
// triggered when the user double-clicks on an item
// ---------------------------------------------------------------------------

void FunctionListDialog::onItemDoubleClicked(QTreeWidgetItem *item, int)
{
    emit insertFunctionName (item->text(0)); // emit a signal with the function name
    close();
}



// ---------------------------------------------------------------------------
// FunctionListDialog::onInsertButtonClicked
// triggered when the user clicks the Insert button
// ---------------------------------------------------------------------------

void FunctionListDialog::onInsertButtonClicked()
{
    // which row is selected?

    QList<QTreeWidgetItem  *> selectedItems = treeWidget->selectedItems();

    if (selectedItems.size() > 0)
    {
        QTreeWidgetItem *item = selectedItems[0];
        emit insertFunctionName (item->text(0)); // emit a signal with the function name
        close();
    }
}


