/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef ColorLine_H
#include "ColorLine.h"
#endif

#ifndef Request_H
#include "Request.h"
#endif

#ifndef RequestPanel_H
#include "RequestPanel.h"
#endif

#ifndef Tokenizer_H
#include "Tokenizer.h"
#endif

#ifndef LineFactory_H
#include "LineFactory.h"
#endif

#ifndef ConfigLoader_H
#include "ConfigLoader.h"
#endif

#ifndef XPalette_H
#include "XPalette.h"
#endif

#include "Colors.h"

ColorLine::ColorLine(RequestPanel& owner,const Parameter& param):
	XRequestPanelLine<UIColorLine_c>(owner,param)
{
}

ColorLine::~ColorLine()
{
}

void ColorLine::refresh(const vector<string>& values)
{
	vector<Pixel> pixels;
	pixels.reserve(values.size());

	for(vector<string>::const_iterator j = values.begin(); j != values.end(); ++j)
		pixels.push_back(XPalette::magics(*j));

	if ( pixels.size() != 0 )
	{
		//ColorsSetPixels(colors_,pixels.size(),pixels.begin());
		Pixel* p = &(*(pixels.begin()));
		ColorsSetPixels( colors_, pixels.size(), p );
	}
}

static LineMaker<ColorLine> maker("colour");
