/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef PAPER_H
#define PAPER_H

#include <Xm/Xm.h>
#include <X11/Intrinsic.h>

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

typedef struct PaperRectangle {
    struct    PaperRectangle *next;
    struct    PaperRectangle *kids;
    double    top;
    double    left;
    double    bottom;
    double    right;
    XtPointer data;
    Boolean   selected;
    Boolean   resizing;
	int       number;
} PaperRectangle;

typedef struct {  	

	XmFontList   font;
	Drawable     drawable;
	XRectangle*  rect;
	GC           gc;
	PaperRectangle *r;

} PaperGraphics;

typedef struct {

	int         reason;         /* what call back */
	XEvent      *event;         /* event that initiated the drag/drop */

	PaperRectangle* r1;
	PaperRectangle* r2;
	PaperRectangle* r3;

	PaperGraphics*	 graphics;

} PaperCallbackStruct;

#define XmNjoinCallback     "joinCallback"
#define XmNsplitCallback    "splitCallback"
#define XmNgroupCallback    "groupCallback"
#define XmNungroupCallback  "ungroupCallback"
#define XmNdeleteCallback   "deleteCallback"
#define XmNdrawCallback     "drawCallback"
#define XmNchangeCallback   "changeCallback"
#ifndef  XmNdblClickCallback
#define XmNdblClickCallback     "dblClickCallback"
#endif



extern WidgetClass  paperWidgetClass;

typedef struct _PaperClassRec *PaperWidgetClass;
typedef struct _PaperRec      *PaperWidget;

extern Widget  CreatePaperWidget(Widget,const char*,Arg*,int);
extern void PaperSetPages(Widget,PaperRectangle*);
extern PaperRectangle*  PaperNewPage(Widget,double,double,double,double);

extern void PaperDeleteSelection(Widget);
extern PaperRectangle* PaperAddPage(Widget,double,double,double,double);

extern void PaperSplitSelection(Widget,int,int,double,double);
extern void PaperJoinSelection(Widget);
extern void PaperGroupSelection(Widget);
extern void PaperUngroupSelection(Widget);

extern Boolean PaperCanSplitSelection(Widget);
extern Boolean PaperCanJoinSelection(Widget);
extern Boolean PaperCanGroupSelection(Widget);
extern Boolean PaperCanUngroupSelection(Widget);

extern Boolean PaperFreeMoves(Widget);
extern void    PaperSetFreeMoves(Widget,Boolean);

extern void    PaperSetGrid(Widget,double,double);
extern void    PaperGetGrid(Widget,double*,double*);
extern void    PaperShowGrid(Widget,Boolean);
extern void    PaperSnapGrid(Widget,Boolean);
extern Boolean  PaperShowGridState(Widget);
extern Boolean  PaperSnapGridState(Widget);

extern void PaperInsetSelection(Widget,double,double,double,double);

extern void PaperSetSize(Widget,double,double);
extern void PaperGetSize(Widget,double*,double*);

extern PaperRectangle*  PaperFind(Widget,XEvent*);
extern void PaperUpdate(Widget);

extern PaperRectangle* PaperGetPages(Widget);

extern void PaperAlignTop(Widget);
extern void PaperAlignHorizontally(Widget);
extern void PaperAlignLeft(Widget);
extern void PaperAlignRight(Widget);
extern void PaperAlignVertically(Widget);
extern void PaperAlignBottom(Widget);

extern void PaperDistributeHorizontally(Widget);
extern void PaperDistributeVertically(Widget);

extern void PaperSelectFirst(Widget);
/*extern void PaperSelectPage (Widget,int);*/
extern void PaperUnselect(Widget);
extern void PaperSelectAll(Widget,Boolean);


extern void PaperLocation(Widget,int,int,double*,double*);

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif


#endif 
