/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQX11Application_H
#define MvQX11Application_H

#include <QtGui/QApplication>
#include <QWidget>

#include <MvRequest.h>
#include <MvProtocol.h>
#include <MvApplication.h>
#include <qsocketnotifier.h>

#include "MvQDragDrop.h"

using namespace std;


// ---------------------------------------------------------------------------
// class MvQX11Application
// This class is essentially just a QApplication class with the addition of
// the ability to handle drag & drop events from the motif-based MetviewUI.
// ---------------------------------------------------------------------------


class MvQX11Application : public QApplication
{
   Q_OBJECT

public:
	// Constructor
	MvQX11Application(int& ac, char** av, const char* name=NULL);

	// Destructor
	virtual ~MvQX11Application();

	// Handle events
	bool x11EventFilter (XEvent *);

signals:
	void sendDropInfo(MvQIconDropItem*);

private:
	// No copy allowed
	MvQX11Application(const MvQX11Application&);
	MvQX11Application& operator=(const MvQX11Application&){return *this;}

	MvQIconDropItem drop_;
};

#endif
