/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQPlaceMarkDialog_H
#define MvQPlaceMarkDialog_H

#include <QDialog>
#include <QMap>
#include <QModelIndex>

class QFileSystemModel ;
class QListView;

class MvQPlaceMarkNode;


class MvQIconSelector : public QDialog
{
Q_OBJECT

public:
	MvQIconSelector(QString,QWidget *parent=0);
	virtual ~MvQIconSelector();

public slots:
	void slotCategoryChanged(const QString&);
	void slotSelectIcon(const QModelIndex&);
	void accept();
	void reject();

signals:
	void iconChanged(QString);

protected:
	void writeSettings();
	void readSettings();

	QString path_;
	QFileSystemModel *fsModel_;
	QListView*	listView_;
	QString 	selection_; 
};


class MvQPlaceMarkDialog : public QDialog
{
Q_OBJECT

public:
	MvQPlaceMarkDialog(MvQPlaceMarkNode*,QString,QWidget *parent=0);
	virtual ~MvQPlaceMarkDialog();

public slots:
	void slotLoadIconSelector(bool);
	void slotIconChanged(QString);
	void accept();
	void reject();

protected:
	void writeSettings();
	void readSettings();

	MvQPlaceMarkNode* pm_;
	QMap<QString,QWidget*> elem_;
	QString systemIconPath_;
	QPixmap pix_;

};

#endif
