/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQZoomStackWidget_H
#define MvQZoomStackWidget_H

#include <QImage>
#include <QMap>
#include <QMenu>
#include <QPlastiqueStyle>
#include <QProxyStyle>

class QAction;

class MgQLayoutItem;
class MgQPlotScene;
class MgQSceneItem;
 
class MvQZoomStackMenuStyle : public QProxyStyle
{
    public:
        MvQZoomStackMenuStyle(QStyle* style=0) : QProxyStyle(style) {};   
        int pixelMetric(PixelMetric, const QStyleOption *option=0, const QWidget *w=0) const;
};
    
class MvQZoomStackMenuPlastiqueStyle : public QPlastiqueStyle
{
    public:
        MvQZoomStackMenuPlastiqueStyle() : QPlastiqueStyle() {};   
        int pixelMetric(PixelMetric, const QStyleOption *option=0, const QWidget *w=0) const;
};

class MvQZoomStackLevel
{
public:
	MvQZoomStackLevel();
	~MvQZoomStackLevel();
	void setImage(QImage&);	
	const QPixmap& pixmap() const {return pixmap_;}
	
protected:
	QPixmap  pixmap_;
};


class MvQZoomStackData : public QObject
{
	Q_OBJECT
public:
	MvQZoomStackData(QString);
	~MvQZoomStackData();
	int update(int,int,MgQLayoutItem*);
	void clear();

	int levelNum() {return levelNum_;}
	int actLevel() {return actLevel_;}
	int selectedLevel() {return selectedLevel_;}
	QString grLayoutId() {return grLayoutId_;}
	void stepUp();
	void stepDown();
	bool setActLevel(int);
	const QList<MvQZoomStackLevel*>& levels() const {return levels_;}

public slots:
	void slotStepTo(int);

signals:
	void actLevelChanged(QString,int);

protected:
	void generatePreview(MvQZoomStackLevel*,MgQLayoutItem*);

	QString grLayoutId_;
	int levelPreviewWidth_;	
	int levelNum_;
	int actLevel_;
	int selectedLevel_;
	QList<MvQZoomStackLevel*> levels_;
};


class MvQZoomStackWidget : public QMenu
{
	Q_OBJECT

public:
	MvQZoomStackWidget(MgQPlotScene*,QWidget *parent=0);
	~MvQZoomStackWidget();
	void updateData();	
	void reset(MgQSceneItem*,bool);
	MvQZoomStackData *pageData(MgQSceneItem*); 
	
	int levelNum();
	int currentLevel();

public slots:
	void slotStepUp();
	void slotStepDown();
	void slotStepTo(QAction*);
	void slotStepTo(int);

signals:
	void actLevelChanged(QString,int);

protected:	
	QMap<QString,MvQZoomStackData*> page_;
	MvQZoomStackData* currentPage_;

	bool skipUpdate_;
	MgQPlotScene* plotScene_;
	MgQSceneItem* activeScene_;
};

#endif
