/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/


#include <Metview.h>

#include "inc_stl.h"


#ifndef InternalTask_H
#include "InternalTask.h"
#endif

#ifndef IconObject_H
#include "IconObject.h"
#endif

#ifndef Log_H
#include "Log.h"
#endif


#ifndef Request_H
#include "Request.h"
#endif

#ifndef Dependancy_H
#include "Dependancy.h"
#endif

#ifndef IconFactory_H
#include "IconFactory.h"
#endif


//=================================================================

InternalTask::InternalTask(const Action& action,IconObject* o):
	action_(action),
	object_(o),
	waiting_(0),
	error_(false)
{
}

InternalTask::~InternalTask()
{
	cout << "InternalTask::~InternalTask " << *object_ << endl;
}

void InternalTask::start()
{
	const set<DependancyH>& dep = object_->dependancies();

	Action action("prepare","*");

	for(set<DependancyH>::const_iterator j = dep.begin(); j != dep.end(); ++j)
	{
		Task* t = (*j)->action(action);
		if(t) {
			tasks_[t] = *j;
			waiting_++;
			t->add(this);
		}
	}
	check();
}

void InternalTask::check()
{
	cout << *this << endl;

	if(waiting_) 
		return;

	if(error_)
	{
		Task::failure();
		return;
	}

	MvRequest r   = object_->fullRequest();
	const char* null = 0;

	if(null == r("_NAME"))    r("_NAME")    = object_->fullName().c_str();
	if(null == r("_CLASS"))   r("_CLASS")   = object_->className().c_str();
	if(null == r("_ACTION"))  r("_ACTION")  = action_.name().c_str();
	Task::success(r);
}

void InternalTask::success(Task* t,const Request& r)
{
	cout << "InternalTask::success " << *t << endl;
	tasks_[t]->success(r);
	waiting_--;
	check();
}

void InternalTask::failure(Task* t)
{
	cout << "InternalTask::failure " << *t << endl;
	error_ = true;
	tasks_[t]->failure();
	waiting_--;
	check();
}

void InternalTask::print(ostream& s) const
{
	s << "InternalTask[" 
	  << "," 
      << action_.name() 
	  << ","  
	  << action_.mode() 
	  << ","
      << *object_ 
	  << "]";
}
