/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File LogWindow.h
// Baudouin Raoult - ECMWF Jul 99

#ifndef LogWindow_H
#define LogWindow_H

#include <Xm/Xm.h>
#include "UILogWindow.h"

class IconObject;

#ifndef IconObject_H
#include "IconObject.h"
#endif

#ifndef Input_H
#include "Input.h"
#endif

#ifndef Timeout_H
#include "Timeout.h"
#endif

class LogWindow : public UILogWindow_c, public Input, public Timeout {
public:

// -- Exceptions
	// None

// -- Destructor

	virtual ~LogWindow(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators
	// None

// -- Methods

	void close();

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods

	static void open(IconObject*);

protected:

// -- Contructors

	LogWindow();

// -- Members
	// None

	FILE*           file_;
	IconObjectH     current_;

// -- Methods
	
	// void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

	LogWindow(const LogWindow&);
	LogWindow& operator=(const LogWindow&);

// -- Members

// -- Methods

	void show(IconObject*);
	void raise();
	void load();
	void more();

// -- Overridden methods

	// -- From XDesigned
	virtual void closeCB(Widget,XtPointer);
	virtual void clearCB(Widget,XtPointer);
	virtual void freezeCB(Widget,XtPointer);

	// -- From Input

	virtual void ready(const char*);
	virtual void done(FILE*);

	// -- From Timeout
	virtual void run();

// -- Class members


// -- Class methods
	// None

// -- Friends

	//friend ostream& operator<<(ostream& s,const LogWindow& p)
	//	{ p.print(s); return s; }

};


inline void destroy(LogWindow**) {}


#endif
