/***************************** LICENSE START ***********************************

 Copyright 2014 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef ReplyObserver_H
#define ReplyObserver_H

#include "Counted.h"

class Request;

class ReplyObserver : public virtual Counted  
{
public:
	ReplyObserver();
	virtual ~ReplyObserver();

	virtual void reply(const Request&,int) = 0;
	virtual void progress(const Request&) = 0;
	virtual void message(const string&) = 0;

protected:
	void callService(const string&,const Request&);

private:
	// No copy allowed
	ReplyObserver(const ReplyObserver&);
	ReplyObserver& operator=(const ReplyObserver&);
};


class ReplyObserverH : public Handle<ReplyObserver> 
{
public:
	ReplyObserverH(ReplyObserver* o) : Handle<ReplyObserver>(o) {}
};

#endif
