/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File VariableEditor.h
// Baudouin Raoult - ECMWF Jul 99

#ifndef VariableEditor_H
#define VariableEditor_H

#ifndef InternalEditor_H
#include "InternalEditor.h"
#endif

#ifndef RequestPanel_H
#include "RequestPanel.h"
#endif

#ifndef Language_H
#include "Language.h"
#endif

#include "UIVariableEditor.h"

#ifndef Task_H
#include "Task.h"
#endif


class RequestPanelLine;
class SimpleEditorObserver;

class VariableEditor : public XEditor<UIVariableEditor_c> {
public:

// -- Exceptions
	// None

// -- Contructors

	VariableEditor(const IconClass&,const string&);

// -- Destructor

	virtual ~VariableEditor(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators
	// None

// -- Methods

	void fail();
	void reply(IconClass&);

	Request currentRequest();

// -- Overridden methods
	// None

	//From InternalEditor.

	virtual void replace(IconObject*);
	virtual void merge(IconObject*);


// -- Class members
	// None

// -- Class methods
	// None

	// Uncomment for persistent, remove otherwise
	// static os_typespec* get_os_typespec();

protected:

// -- Members
	// None

// -- Methods
	
	// void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

	VariableEditor(const VariableEditor&);
	VariableEditor& operator=(const VariableEditor&);

// -- Members

	RequestPanel  fixPanel_;
	RequestPanel* variablePanel_;

	TaskH       task_;
	IconObjectH temp_;

// -- Methods


// -- Class members
	// None

// -- Class methods
	// None
	//From InternalEditor.
	virtual void apply();
	virtual void reset();
	virtual void close();

	virtual IconObject* copy(const string&);

// -- Friends

	//friend ostream& operator<<(ostream& s,const VariableEditor& p)
	//	{ p.print(s); return s; }

};

inline void destroy(VariableEditor**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(VariableEditor);
//#endif

#endif
