
#ifdef USE_IMLIB

#include "image.h"

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/extensions/shape.h>
#include <Imlib.h>

int imIdent(char *fullname, char *name)
{
	return 1;
}

Image *imLoad(char *fullname, char *name, unsigned int verbose)
{
	static Display *disp = NULL;
	Image *image;
	ImlibData *id;
	ImlibImage *im;
	ImlibColor shape;
	unsigned int w,h, size;

	if (disp == NULL) {
		disp=XOpenDisplay(NULL);
	}
	id=Imlib_init(disp);
	im=Imlib_load_image(id, fullname);
	if (im == NULL) {
		return NULL;
	}
	w = im->rgb_width;
	h = im->rgb_height;
	size = w * h * 3;

	image = newTrueImage(w, h);
	memcpy(image->data, im->rgb_data, size);
	
	Imlib_get_image_shape(id, im, &shape);

	/*
	 * bug fix for transparent gif handling
	 * suggested by Jose Geraldo Alves Brito Neto <jgabrito@iq.usp.br>
	 */
	if ((shape.r >=0) && (shape.g >= 0) && (shape.b >= 0))
	  image->trans = \
	    ((shape.r & 0xff) << 16) |
	    ((shape.g & 0xff) <<  8) |
	    ((shape.b & 0xff) <<  0);

	image->title = dupString(name);
	
	return image;
}

#endif
