#!/usr/bin/env perl

package NAST_to_Eco_coords;

use strict;
use warnings;
use Carp;

require Exporter;
our @ISA = qw(Exporter);
our @EXPORT = qw(NAST_to_Eco_coord);


our @NAST_TO_ECO_COORD;
our @ECO_TO_NAST_COORD;
our $ECO_NAST_SEQ;
our $ECO_SEQ;


####
sub NAST_to_Eco_coord {
	my @coords = @_;
	
	my @ret_coords;
	
	foreach my $coord (@coords) {
		
		if ($coord >= length($ECO_NAST_SEQ)) {
			confess "Error, nast coord $coord >= nast alignment length: " . length($ECO_NAST_SEQ);
		}
		
		push (@ret_coords, $NAST_TO_ECO_COORD[$coord]);
	}
	
	return(@ret_coords);
}

####
sub Eco_to_NAST_coord {
	my @coords = @_;
	
	my @ret_coords;
	
	foreach my $coord (@coords) {
		if ($coord >= length($ECO_SEQ)) {
			confess "Error, coordinate $coord of E. coli refseq is >= length of sequence:" . length($ECO_SEQ);
		}
		push (@ret_coords, $ECO_TO_NAST_COORD[$coord]);
	}
	return(@ret_coords);
}

sub get_Eco_NAST_alignment {
	return($ECO_NAST_SEQ);
}


sub Eco_to_Vregion_string {
	my ($coord) = @_;

	my %ranges = ("1-49" => "-V1",
				  "50-100" => "V1",
				  "101-180" => "V1-V2",
				  "181-220" => "V2",
				  "221-399" => "V2-V3",
				  "400-500" => "V3",
				  "501-599" => "V3-V4",
				  "600-650" => "V4",
				  "651-819" => "V4-V5",
				  "820-860" => "V5",
				  "861-999" => "V5-V6",
				  "1000-1050" => "V6",
				  "1051-1119" => "V6-V7",
				  "1120-1150" => "V7",
				  "1151-1239" => "V7-V8",
				  "1240-1290" => "V8",
				  "1291-1409" => "V8-V9",
				  "1410-1480" => "V9",
				  "1481-1600" => "V9+", # should change this to proper length coordinate
		);
	
	foreach my $range (keys %ranges) {
		my $region = $ranges{$range};
		my ($lend, $rend) = split(/-/, $range);
		if ($coord >= $lend && $coord <= $rend) {
			return($region);
		}
	}

	confess "Coordinate $coord out of range of E. coli sequence";
}

BEGIN {
	
	
#>7000004128537908	Escherichia coli	Bacteria; Proteobacteria; Gammaproteobacteria; Enterobacteriales; Enterobacteriaceae; Escherichia

	my $eco_NAST = 
		"............................................................
................................................AGAGTTT-GA--
T-CA-T-G-GCTC-AG-AT-TGAA-C-GC--TGG-C--G-GC-A-GG--C----C-T--A
ACACA-T-GC-A-AGT-CGA-A-CG----------G-TAA-CA-G---------------
-------------AAAG-A-AG--------------------------------------
--------------CTT-G-----------------------------------------
-----------------------------------------CTT-CTTT-----------
-----G-CT--G--AC--G--AG-T-GG-C-GG-A--C-------------GGG-TGAGT
-A--AT-GT-C-T-G-GG---A-A--A-CT-G--C-C-TGA--TG-G-------------
-----------------------------------------------------A-GG---
-GGG-AT-AA-CTA-------------------------C-T-G----------------
-------GAA-A---CGG-TAG-CTAA-TA---CC-G--C-AT-A----------A----
----------------C-------------------------------------GT-C--
------------------------------------------------------------
---------------------------------------------------------G-C
A-A---------------------------------------------------------
------------------------------------------------------------
-----------------G-A-C--------------------------------------
------------------------------------------------------------
------------------------------------------------------------
------------------------------------------------------------
------------------------------------------------------------
-------CAAA--G-A-G-GG-----G--GA-C--C------------------------
------------------------------------------------------------
--------------------------------TTC-G-----------------------
------------------------------------------------------------
-----------------------------------G-G--CC-TC--T---T-G------
--------C----C-A---T-CG-G---AT---G-T-----G-CCC-AGA--T-GGG--A
------TT--A--G-CT-T----G---TTGG-T-G-GG-G-T----AAC-GG-C-T-C-A
CCA--A-GG-C-G--A-CG-A------------TCC-C-T------AG-CT-G-G-TCT-
G-AG----A--GG-AT--G-AC-C-AG-CCAC-A-CTGGA--A-C-TG-A-GA-C-AC-G
-G-TCCAGA-CTCC-TAC-G--G-G-A-G-GC-A-GC-A-G-TG---GG-G-A-ATA-TT
GCA-C-AA-T-GG--GC-GC-A----A-G-CC-T-GA-TG-CA-GCCA-TGCC-G-CG-T
---G-T-A--T--GA-A-G--A--A-G-G-CC-----TT-CG---------G-G-T-T-G
-T--A---AA-G-TAC--------TT-TC-A-G--C-GGG----GA-G--G---AA-GGG
A---GTAA-AG----T--T--AA-T---A----C-----CT-T-TGC-TCA-TT-GA-CG
-TT-A-C-CC-G-CA-G---------AA-----------GAAGC-ACC-GG-C-TAA---
C--T-CCGT--GCCA--G-C---A--GCCG---C-GG--TA-AT--AC---GG-AG-GGT
-GCA-A-G-CG-TTAA-T-CGG-AA-TT-A--C-T--GGGC-GTA----AA-GCGC-AC-
-G-CA-G-G-C-G------------G--T-TT-G-T-T-AA----G-T-C-A---G-ATG
-TG-A-AA-TC--CC-CGG-G---------------------------------------
-----------------------------CTTC-AA------------------------
-------------------------------------------------CC-T-G-GG-A
A-C----T-G-C-A-T-C--------T--GA-T-A-C-T-G-GCA--A-G-C--------
------------------------------------------------------------
------------------------------------------------------------
------------------------------------------------------------
------------------------------------------------------------
------------------------------------------------------------
------------------------------------------------------------
------------------------------------------------------------
------------------------------------------------------------
------------------------------------------------------------
------------------------------------------------------------
------------------------------------------------------------
------------------------------------------------------------
------------------------------------------------------------
------------------------------------------------------------
------------------------------------------------------------
------------------------------------------------------------
------------------------------------------------------------
------------------------------------------------------------
-T-T-G-A-G-T-C-----T-CG--TA-G-A------------G-GG-G-GG-T----AG
--AATT-CCA-G-GT--GT-A-GCG-GTGAAA-TG-CGT-AGAG-A-TC-T-GGA--GG-
A-AT-A-CC-GG--T--G--GC-GAA-G--G-C---G----G--C-C-CCCTG------G
-AC-GA------------------------------------------------------
--------AG-A-C-T--GA--CG-----CT-CA-GG--T-G-CGA--AA-G-C------
--------G-TGGG-GAG-C-A-AACA--GG-ATTA-G-ATA-C-----CC-T-G-GTA-
G-T----C-CA--C-G-CCG-T-AAA--C-GATG-TC--GA-CT---------T-GG--A
--G-G-TT-G-TG-C--C------------------------------------------
--------------------------------------------CTT-GA----------
------------------------------------------------------------
------------------------------------------------------------
----------------G-G-C-GT--G-G-C-T-TC-C------GG--A----GC-TAA-
-CG-C-G-T--T--AA-GT--C----G-ACC-GCC-T-G-GG-GAG-TA---CGG-----
C-C--G-C-A-A-GGT-T--AAA-ACTC-AAA---------TGAA-TTG-ACGGG-G-G-
CCCG----C-A--C-A-A-GCG-GT-G--G--AG-CA-T--GT-GGT-TT-AATT-C-G-
ATG-CAAC-G-CG-A-AG-A-A-CC-TT-A-CC-TGGTC-TT-G-AC-A-T-C-------
-------CAC-G-G-------------A-AG-T-T-T--TC--A-GA-G-A-T--G-A-G
--A-A-T-G--T-G-----CC-------------------------------------T-
-TC-G------------------------------------------GG----A----A-
--CC-GTG---A--GA--------------------------------------------
-------C-A-G-G-T-GCTG-CA-TGG-CT--GTC-GTC-A-GC-TC---G-TG-TT-G
--TGA-AA-TGT-T-GG-G-TT-AA-GT-CCCGC-AA--------C-GAG-CGC-A-ACC
-C-T-TA--TC--C-TTTG--T-T-G-C-C---AG-C-G--G--T---------------
------------------------------------------------------------
------------------------------------------------------------
----------------------------------------------CCG-----------
------------------------------------------------------------
------------------------------------------------------------
------------------------------------------------------------
------------------------------------------------------------
------------------------------------------------------------
-------------------------------------------------G----C----C
-G------------G----G---A-A--CT---------------C-A-A-A-G-GA-G-
-AC-T-G-CCA--G-T------------------------------------G-A---TA
A----------------------------------A-C-T-G--G-A-GG-A--AGG-T-
-GGGG-A-TGAC-GTC--AAGT-C---ATC-A-T-G-G-C-C-CTT----AC-G--AC-C
-A-GG-GC-TA-CAC-ACGTG-C--TA--CAATG---G-CGCA-T-A--C-AAA-GA-GA
------------------------------------------------------------
--------------------------------------A-G-C-G-A--C-CTCG-C--G
---------------------------------------A-GA-G-C-----------A-
-A-G-CG---G----------A--CCT-C------A-T-AAAGT-GC-G-T-C-G-TAG-
TCC--------GGA-T-TGGAG-TC--T-GCAA-CT-C----------------------
------------------------------------------------------------
---------------G-ACTCC-A-T-G-AA-G-TC-GGAAT-CG-C-TA--G-TA-AT-
C-G-T----GGA-TC-A-G--A------AT--GCC-AC-G-GT-G-AAT-ACGT-T-CCC
GGGCCT-TGTA----CACACCG-CCC-GTC-----A---CA--CCA-TG-GG-A--G---
TGG-G-TT-GC-AAA--A-GAA------G--T-AGG-TA-G-C-T-T-AA-C-C------
-------------------------------------------------------T-TC-
G-----------------------------------------------------------
-------------------------------------------GG-A--GG-G--C---G
C-TTA--CC--ACT-T----T-GTG-AT-TCA------------------------TG--
ACT-GGGG-TG-AAG-TCGTAACAA-GGTAA-CC..........................
............................................................
............................................................
............................................................
............................................................
............................................................
............................................................
............................................................
............................................................
............................................................
............................................................
............................................................
............................................................
............................................................
............................................................
..";

    $eco_NAST =~ s/\s+//g;

    $ECO_NAST_SEQ = $eco_NAST;

	my @chars = split (//, $eco_NAST);

	## convert to an Ecoli sequence reference coord system:
    my $counter = -1;
	for (my $i = 0; $i <= $#chars; $i++) {
     	  my $char = $chars[$i];
	
		  if ($char =~ /\w/) {
			 $counter++;
		     $ECO_TO_NAST_COORD[$counter] = $i;
          }
		  $NAST_TO_ECO_COORD[$i] = $counter;
	}

    # create unaligned sequence
    $ECO_SEQ = $ECO_NAST_SEQ;
    $ECO_SEQ =~ s/[\.\-]//g;

}



1; #EOM
