///start file generated from microprofile.html
#ifdef MICROPROFILE_EMBED_HTML
const char g_MicroProfileHtml_begin_0[] =
"<!DOCTYPE HTML>\n"
"<html>\n"
"<head>\n"
"<title>MicroProfile Capture</title>\n"
"<style>\n"
"/* about css: http://bit.ly/1eMQ42U */\n"
"body {margin: 0px;padding: 0px; font: 12px Courier New;background-color:#343434; color:white;overflow:hidden;}\n"
"ul {list-style-type: none;margin: 0;padding: 0;}\n"
"li{display: inline; float:left;border:5px; position:relative;text-align:center;}\n"
"a {\n"
"    float:left;\n"
"    text-decoration:none;\n"
"    display: inline;\n"
"    text-align: center;\n"
"	padding:5px;\n"
"	padding-bottom:0px;\n"
"	padding-top:0px;\n"
"    color: #FFFFFF;\n"
"    background-color: #343434;\n"
"}\n"
"a:hover, a:active{\n"
"	background-color: #000000;\n"
"}\n"
"\n"
"ul ul {\n"
"    position:absolute;\n"
"    left:0;\n"
"    top:100%;\n"
"    margin-left:-999em;\n"
"}\n"
"li:hover ul {\n"
"    margin-left:0;\n"
"    margin-right:0;\n"
"}\n"
"ul li ul{ display:block;float:none;}\n"
"ul li ul li{ display:block;float:none;}\n"
"li li a{ display:block;float:none;text-align:left;word-break: keep-all;white-space: nowrap;}\n"
"#nav li:hover div {margin-left:0;}\n"
".help {position:absolute;z-index:5;text-align:left;padding:2px;background-color: #313131;width:300px;}\n"
".helpstart {position:absolute;z-index:5;text-align:left;padding:2px;background-color: #313131;width:300px;display:none}\n"
".root {z-index:1;position:absolute;top:0px;left:0px;}\n"
".filterinput0{position:fixed;bottom:10px;left:25px;background-color: #313131}\n"
".filterinput1{position:fixed;bottom:10px;left:175px;background-color: #313131}\n"
".filterinputsearchdiv{position:fixed; background-color: #313131;display:none;}\n"
".filterinputsearchdivmenu{position:absolute; background-color: #313131;display:none;}\n"
".filterinputsearch{width:100px;}\n"
"</style>\n"
"</head>\n"
"<body style=\"\">\n"
"<input type=\"file\" id=\"file-input\" style=\"display:none\"/>\n"
"<div id=\'filterinput\'>\n"
"<div class=\"filterinput0\">Group<br><input type=\"text\" id=\"filtergroup\"></div>\n"
"<div class=\"filterinput1\">Timer/Thread<br><input type=\"text\" id=\"filtertimer\"></div>\n"
"</div>\n"
"<div class=\"filterinputsearchdiv\" id=\"FilterInputDiv\">Filter<br><input type=\"text\" id=\"FilterInput\" class=\"filterinputsearch\"></div>\n"
"<div class=\"filterinputsearchdivmenu\" id=\"FilterInputMenuDiv\">Filter<br><input type=\"text\" id=\"FilterInputMenu\" class=\"filterinputsearch\"></div>\n"
"<canvas id=\"History\" height=\"70\" style=\"background-color:#343434;margin:0px;padding:0px;\"></canvas>\n"
"<canvas id=\"DetailedView\" height=\"200\" style=\"background-color:#343434;margin:0px;padding:0px;\"></canvas>\n"
"<canvas id=\"CanvasMenu\" style=\"pointer-events:none;position:absolute;top:0;left:0;margin:0px;padding:0px;zIndex:1\" height=\"500\" width=\"500\"></canvas>\n"
"<div class=\"help\" id=\"divFrameInfo\" style=\"display:none;left:20px;top:300px;width:auto;\"></div>\n"
"<div class=\"helpstart\" id=\"helpwindow\" style=\"left:20px;top:20px\">\n"
"History View:<br>\n"
"Click + Drag: Pan View<br>\n"
"Right Click + Drag : Zoom on region<br>\n"
"Click Frame : Center on frame<br>\n"
"<hr>\n"
"Main View:<br>\n"
"Ctrl + Mouse up/down: Zoom<br>\n"
"Mousewheel : Zoom<br>\n"
"Right Click + Drag: Select region<br>\n"
"Ctrl + Shift + Drag: Select region<br>\n"
"Space: Zoom to Selection<br>\n"
"Ctrl + Drag: Pan<br>\n"
"Click + Drag: Pan<br>\n"
"hold alt: Show tooltip from timer view in detailed, detailed in timer<br>\n"
"x : Toggle View<br>\n"
"<hr>\n"
"Detailed View:<br>\n"
"Tab: Go To Worst Instance<br>\n"
"Left/Right Arror: Next/Prev Instance<br>\n"
"Enter: Search for timer in view<br>\n"
"<hr>\n"
"Timer Views:<br>\n"
"Tab: go to filtering<br>\n"
"Esc: Exit &amp; Clear filter\n"
"<hr>\n"
"<table style=\"width:100%\">\n"
"<tr>\n"
"<td width=\"50%\" align=\"left\"><a href=\'javascript:void(0)\' onclick=\"ShowHelp(0, 0);\">Close</a></td>\n"
"<td width=\"50%\" align=\"right\"><a href=\'javascript:void(0)\' onclick=\"ShowHelp(0, 1);\">Close, Never Show</a></td>\n"
"</tr>\n"
"</table>\n"
"</div>\n"
"<script>\n"
"function ConvertRgbToHsl(hexTripletColor) //from https://gist.github.com/mjackson/5311256\n"
"{\n"
"	var color = hexTripletColor;\n"
"	color = color.substring(1);\n"
"	color = parseInt(color, 16);\n"
"	var r = ((color >> 16) % 256)/255.0;\n"
"	var g = ((color >> 8) % 256)/255.0;\n"
"	var b = ((color >> 0) % 256)/255.0;\n"
"	var max = Math.max(r, g, b), min = Math.min(r, g, b);\n"
"	var h, s, l = (max + min) / 2;\n"
"	if (max == min) {\n"
"		h = s = 0; // achromatic\n"
"	}\n"
"	else \n"
"	{\n"
"		var d = max - min;\n"
"		s = l > 0.5 ? d / (2 - max - min) : d / (max + min);\n"
"\n"
"		switch (max) \n"
"		{\n"
"			case r: h = (g - b) / d + (g < b ? 6 : 0); break;\n"
"			case g: h = (b - r) / d + 2; break;\n"
"			case b: h = (r - g) / d + 4; break;\n"
"		}\n"
"		h /= 6;\n"
"	}\n"
"	return [ h, s, l ];\n"
"}\n"
"\n"
"function ConvertHslToColor(h, s, l) //from https://gist.github.com/mjackson/5311256\n"
"{\n"
"	var r, g, b;\n"
"	if (s == 0)\n"
"	{\n"
"		r = g = b = l; // achromatic\n"
"	}\n"
"	else\n"
"	{\n"
"		function hue2rgb(p, q, t)\n"
"		{\n"
"			if (t < 0) t += 1;\n"
"			if (t > 1) t -= 1;\n"
"			if (t < 1/6) return p + (q - p) * 6 * t;\n"
"			if (t < 1/2) return q;\n"
"			if (t < 2/3) return p + (q - p) * (2/3 - t) * 6;\n"
"			return p;\n"
"		}\n"
"		var q = l < 0.5 ? l * (1 + s) : l + s - l * s;\n"
"		var p = 2 * l - q;\n"
"		r = hue2rgb(p, q, h + 1/3);\n"
"		g = hue2rgb(p, q, h);\n"
"		b = hue2rgb(p, q, h - 1/3);\n"
"	}\n"
"	var color = ((r*255)<<16) | ((g*255)<<8) | (b*255);\n"
"	return \'#\' + (\"000000\" + color.toString(16)).slice(-6);\n"
"}\n"
"\n"
"\n"
"function ConvertColorDark(hexTripletColor)\n"
"{\n"
"	var color = hexTripletColor;\n"
"	color = color.substring(1); // remove #\n"
"	color = parseInt(color, 16); // convert to integer\n"
"	// console.log(color.toString(16));\n"
"	color = (color >> 1);\n"
"	// console.log(color.toString(16));\n"
"	color = color & 0x7f7f7f;\n"
"	// console.log(color.toString(16));\n"
"	return \'#\' + (\"000000\" + color.toString(16)).slice(-6);\n"
"}\n"
"function InvertColor(hexTripletColor) \n"
"{\n"
"	var color = hexTripletColor;\n"
"	color = color.substring(1); // remove #\n"
"	color = parseInt(color, 16); // convert to integer\n"
"	var R = ((color >> 16) % 256)/255.0;\n"
"	var G = ((color >> 8) % 256)/255.0;\n"
"	var B = ((color >> 0) % 256)/255.0;\n"
"	var lum = (0.2126*R + 0.7152*G + 0.0722*B);\n"
"	if(lum < 0.7)\n"
"	{\n"
"		return \'#ffffff\';\n"
"	}\n"
"	else\n"
"	{\n"
"		return \'#333333\';\n"
"	}\n"
"}\n"
"function InvertColorIndex(hexTripletColor) {\n"
"	var color = hexTripletColor;\n"
"	color = color.substring(1); // remove #\n"
"	color = parseInt(color, 16); // convert to integer\n"
"	var R = ((color >> 16) % 256)/255.0;\n"
"	var G = ((color >> 8) % 256)/255.0;\n"
"	var B = ((color >> 0) % 256)/255.0;\n"
"	var lum = (0.2126*R + 0.7152*G + 0.0722*B);\n"
"	if(lum < 0.7)\n"
"	{\n"
"		return 0;\n"
"	}\n"
"	else\n"
"	{\n"
"		return 1;\n"
"	}\n"
"}\n"
"\n"
"function MakeGroup(id, name, category, numtimers, isgpu, total, average, max, color)\n"
"{\n"
"	if(color == \"\")\n"
"	{\n"
"		color = ColorFromString(name, 40, 50);\n"
"	}\n"
"	var cid = GetColorIndex(color);\n"
"	var group = {\"id\":id, \"name\":name, \"category\":category, \"numtimers\":numtimers, \"isgpu\":isgpu, \"total\": total, \"average\" : average, \"max\" : max, \"cid\":cid};\n"
"	return group;\n"
"}\n"
"\n"
"function MakeGroupCid(id, name, category, numtimers, isgpu, total, average, max, color, cid)\n"
"{\n"
"	var group = {\"id\":id, \"name\":name, \"category\":category, \"numtimers\":numtimers, \"isgpu\":isgpu, \"total\": total, \"average\" : average, \"max\" : max, \"cid\":cid};\n"
"	return group;\n"
"}\n"
"\n"
"function MakeTimer(id, name, group, color, colordark, average, max, min, exclaverage, exclmax, callaverage, callcount, total, meta, metaavg, metamax)\n"
"{\n"
"	if(color == \"#000000\")\n"
"	{\n"
"		color = ColorFromString(name + \"x\" + group, 40, 50);\n"
"		colordark = ColorFromString(name + \"x\" + group, 25, 50);\n"
"	}\n"
"	var spike = max <= 0 || average <= 0 ? 0 : (100 * max / average);\n"
"	var cid = GetColorIndex(color);\n"
"	var timer = {\"id\":id, \"name\":name, \"len\":name.length, \"cid\":cid, \"timercid\":cid, \"group\":group, \"average\":average, \"max\":max, \"min\":min, \"exclaverage\":exclaverage, \"exclmax\":exclmax, \"callaverage\":callaverage, \"callcount\":callcount, \"spike\":spike,\"total\":total, \"meta\":meta, \"metaavg\":metaavg, \"metamax\":metamax, \"worst\":0, \"worststart\":0, \"worstend\":0};\n"
"	return timer;\n"
"}\n"
"\n"
"function MakeTimerCid(id, name, group, cid, average, max, min, exclaverage, exclmax, callaverage, callcount, total, meta, metaavg, metamax)\n"
"{\n"
"	var spike = max <= 0 || average <= 0 ? 0 : (100 * max / average);\n"
"	var timer = {\"id\":id, \"name\":name, \"len\":name.length, \"cid\":cid, \"timercid\":cid, \"group\":group, \"average\":average, \"max\":max, \"min\":min, \"exclaverage\":exclaverage, \"exclmax\":exclmax, \"callaverage\":callaverage, \"callcount\":callcount, \"spike\":spike,\"total\":total, \"meta\":meta, \"metaavg\":metaavg, \"metamax\":metamax, \"worst\":0, \"worststart\":0, \"worstend\":0};\n"
"	return timer;\n"
"}\n"
"\n"
"function CloneTimer(T)\n"
"{\n"
"	return MakeTimerCid(T.id, T.name, T.group, T.cid, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);\n"
"}\n"
"function CloneGroup(G)\n"
"{\n"
"	return MakeGroupCid(G.id, G.name, G.category, G.numtimers, G.isgpu, G.total, G.average, G.max, G.cid);\n"
"}\n"
"\n"
"function MakeFrame(id, framestart, frameend, framestartgpu, frameendgpu, ts, tt, ti)\n"
"{\n"
"	var frame = {\"id\":id, \"framestart\":framestart, \"frameend\":frameend, \"framestartgpu\":framestartgpu, \"frameendgpu\":frameendgpu, \"ts\":ts, \"tt\":tt, \"ti\":ti};\n"
"	return frame;\n"
"}\n"
"function MakeCounterHistory(id, history, prc)\n"
"{\n"
"	var counterhistory = {\"id\":id, \"history\":history, \"prc\":prc};\n"
"	return counterhistory;\n"
"}\n"
"function MakeCounter(id, parent, sibling, firstchild, level, name, value, minvalue, maxvalue, formatted, limit, formattedlimit, counterprc, boxprc, format, counterhistory)\n"
"{\n"
"	var counter = { \"id\":id, \"parent\":parent, \"sibling\":sibling, \"firstchild\":firstchild, \"level\": level, \"name\":name, \"value\":value, \"formatted\":formatted, \"limit\":limit, \"formattedlimit\":formattedlimit, \"counterprc\":counterprc, \"boxprc\":boxprc, \"counterhistory\":counterhistory, \"format\":format, \"minvalue\":minvalue, \"maxvalue\":maxvalue};\n"
"	return counter;\n"
"}\n"
"function Clamp(v, low, high)\n"
"{\n"
"	return v < low ? low : (v > high ? high : v);\n"
"}\n"
"function FormatTime(Time)\n"
"{\n"
"	return Time.toFixed(2);\n"
"}\n"
"\n"
"\n"
"\n"
"var g_ColorMap = {};\n"
"var g_Colors = new Array();\n"
"var g_ColorsDark = new Array();\n"
"var g_ColorsTextIndex = new Array();\n"
"var g_ColorH = new Array();\n"
"var g_ColorS = new Array();\n"
"var g_ColorL = new Array();\n"
"\n"
"function GetColorIndex(color)\n"
"{\n"
"	if(g_ColorMap[color])\n"
"	{\n"
"		return g_ColorMap[color];\n"
"	}\n"
"	else\n"
"	{\n"
"		var idx = g_Colors.length;\n"
"		g_ColorMap[color] = idx;\n"
"		g_Colors.push(color);\n"
"		g_ColorsDark.push(ConvertColorDark(color));\n"
"		g_ColorsTextIndex.push(InvertColorIndex(color));\n"
"		var hsl = ConvertRgbToHsl(color);\n"
"		g_ColorH.push(hsl[0]);\n"
"		g_ColorS.push(hsl[1]);\n"
"		g_ColorL.push(hsl[2]);\n"
"		return idx;\n"
"	}\n"
"}\n"
"//color index 0 reserved for blinking\n"
"var cidhovercolor = 0;\n"
"g_Colors.push(\'#000000\');\n"
"g_ColorsDark.push(\'#000000\');\n"
"g_ColorsTextIndex.push(0);\n"
"g_ColorH.push(0);\n"
"g_ColorS.push(0);\n"
"g_ColorL.push(0);\n"
"\n"
"var S = {};\n"
"var S2 = {};\n"
"var Timeline = {};\n"
"S.TimelineArray = [];\n"
"S.TimelineIdArray = [];\n"
"S.TimelineNames = [];\n"
"S.TimelineColorArray = [];\n"
"\n"
"\n"
"\n"
"//EBEGIN\n"
"";

const size_t g_MicroProfileHtml_begin_0_size = sizeof(g_MicroProfileHtml_begin_0);
const char* g_MicroProfileHtml_begin[] = {
&g_MicroProfileHtml_begin_0[0],
};
size_t g_MicroProfileHtml_begin_sizes[] = {
sizeof(g_MicroProfileHtml_begin_0),
};
size_t g_MicroProfileHtml_begin_count = 1;
const char g_MicroProfileHtml_end_0[] =
"\n"
"//EEND\n"
"\n"
"var G_DEBUG = 0;\n"
"\n"
"var CanvasDetailedView = document.getElementById(\'DetailedView\');\n"
"var CanvasHistory = document.getElementById(\'History\');\n"
"var CanvasMenu = document.getElementById(\'CanvasMenu\');\n"
"var CanvasDetailedOffscreen = document.createElement(\'canvas\');\n"
"var FilterInputGroup = document.getElementById(\'filtergroup\');\n"
"var FilterInputTimer = document.getElementById(\'filtertimer\');\n"
"\n"
"var FilterInput = document.getElementById(\'FilterInput\');\n"
"var FilterInputDiv = document.getElementById(\'FilterInputDiv\');\n"
"var FilterInputDivPos = {\"x\":-1,\"y\":-1,\"w\":-1,\"h\":-1};\n"
"var FilterInputMenu = document.getElementById(\'FilterInputMenu\');\n"
"var FilterInputMenuDiv = document.getElementById(\'FilterInputMenuDiv\');\n"
"var FilterInputMenuDivPos = {\"x\":-1,\"y\":-1,\"w\":-1,\"h\":-1};\n"
"var FilterInputMenuValueLast = \'\';\n"
"\n"
"\n"
"var FilterInputGroupString = null;\n"
"var FilterInputTimerString = null;\n"
"var FilterInputArray = [FilterInputGroup, FilterInputTimer];\n"
"var FilterGroup = null;\n"
"var FilterTimer = null;\n"
"var g_Msg = \'0\';\n"
"\n"
"var RedrawRequested = 0;\n"
"var InsideDraw = 0;\n"
"\n"
"\n"
"\n"
"var Initialized = 0;\n"
"var fDetailedOffset = S.Frames[0].framestart;\n"
"var fDetailedOffsetSecond = 0;\n"
"var fDetailedRange = S.Frames[S.Frames.length-1].frameend - fDetailedOffset;\n"
"var nWidth = CanvasDetailedView.width;\n"
"var nHeight = CanvasDetailedView.height;\n"
"var ReferenceTimeString = \'auto\';\n"
"var ReferenceTimeAutoString = \'auto\';\n"
"var ReferenceTime = 33;\n"
"var TargetTime = 16;\n"
"var TargetTimeString = \'16ms\';\n"
"var nHistoryHeight = 70;\n"
"var nOffsetY = 0;\n"
"var nOffsetBarsX = 0;\n"
"var nOffsetBarsY = 0;\n"
"var nOffsetCountersY = 0;\n"
"var nOffsetFilterSearch = 0;\n"
"var nOffsetMenuThreads = 0;\n"
"var nOffsetMenuGroups = 0;\n"
"var FilterInputSearchLast = \'\';\n"
"var nBarsWidth = 80;\n"
"var MouseButtonState = [0,0,0,0,0,0,0,0];\n"
"var KeyShiftDown = 0;\n"
"var KeyAltDown = 0;\n"
"var KeyCtrlDown = 0;\n"
"var MouseDragButton = 0;\n"
"var ToolTipFlip = 0; \n"
"var ToolTipCorner = 1;\n"
"var DetailedViewMouseX = 0;\n"
"var DetailedViewMouseY = 0;\n"
"var DetailedMouseOverButton = 0;\n"
"var DetailedMouseEvent = null;\n"
"var HistoryViewMouseX = -1;\n"
"var HistoryViewMouseY = -1;\n"
"var GlobalMouseX = -1;\n"
"var GlobalMouseY = -1;\n"
"var MouseReleased = false;\n"
"var MouseHistory = 0;\n"
"var MouseDetailed = 0;\n"
"var FontHeight = 10;\n"
"var FontWidth = 1;\n"
"var FontAscent = 3; //Set manually\n"
"var Font = \'Bold \' + FontHeight + \'px Courier New\';\n"
"var FontFlash = \'Bold \' + 35 + \'px Courier New\';\n"
"var BoxHeight = FontHeight + 2;\n"
"var ThreadsActive = {};\n"
"var GroupsDisabled = new Object();\n"
"var nMinWidth = 0.01;//subpixel width\n"
"var nMinWidthPan = 1.0;//subpixel width when panning\n"
"var nContextSwitchEnabled = 1;\n"
"var DisableLod = 0;\n"
"var DisableMerge = 0;\n"
"var GroupColors = 0;\n"
"var DrawDetailedFlameMode = 0;\n"
"var DrawDetailedCompareReverse = 1;\n"
"var nModDown = 0;\n"
"var g_MSG = \'no\';\n"
"var nDrawCount = 0;\n"
"var nBackColors = [\'#292929\', \'#343434\' ];\n"
"var nBackColorsDark = [\'#292929\', \'#272727\' ];\n"
"var nBackColorOffset = \'#404040\';\n"
"var CSwitchColors =[\"#9DD8AF\",\"#D7B6DA\",\"#EAAC76\",\"#DBDA61\",\"#8AD5E1\",\"#8CE48B\",\"#C4D688\",\"#57E5C4\"];//generated by http://tools.medialab.sciences-po.fr/iwanthue/index.php\n"
"var CSwitchHeight = 5;\n"
"var FRAME_HISTORY_COLOR_CPU = \'#ff7f27\';\n"
"var FRAME_HISTORY_COLOR_GPU = \'#ffffff\';\n"
"var ZOOM_TIME = 0.5;\n"
"var AnimationActive = false;\n"
"var nHoverCSCpu = -1;\n"
"var nHoverCSCpuNext = -1;\n"
"var nHoverCSToolTip = null;\n"
"var nHoverToken = -1;\n"
"var HoverTokenOwner = null;\n"
"var nHoverFrame = -1;\n"
"var nHoverTokenIndex = -1;\n"
"var nHoverTokenLogIndex = -1;\n"
"var nHoverCounter = 0;\n"
"var nHoverCounterDelta = 8;\n"
"var nHoverTokenNext = -1;\n"
"var nHoverTokenLogIndexNext = -1;\n"
"var nHoverTokenIndexNext = -1;\n"
"var HoverTokenNextOwner = null;\n"
"var nHoverCounter = -1;\n"
"var nHoverTokenDrawn = -1;\n"
"var nHideHelp = 0;\n"
"var fFrameScale = 33.33;\n"
"var SortColumn = 0;\n"
"var SortColumnOrderFlip = 0;\n"
"var SortColumnMouseOver = null;\n"
"var SortColumnMouseOverNext = null;\n"
"var ColumnsWidth = [];\n"
"var ColumnsEnabled = [];\n"
"let ColumnNames =[\"Average\", \"Max\", \"Total\", \"Min\", \"Spike\", \"Call Average\", \"Call Count\", \"Excl Average\", \"Excl Max\"];\n"
"let NumColumns = ColumnNames.length;\n"
"while(ColumnsEnabled.length < NumColumns)\n"
"{\n"
"	ColumnsEnabled.push(1);\n"
"	ColumnsWidth.push(20);\n"
"}\n"
"var FilterSearchActive = 0;\n"
"var FilterSearchSelection = -1;\n"
"var FilterSearchSelectionMax = 0;\n"
"var FilterSearchPassIndex = -1;\n"
"FilterSearchReset();\n"
"var FilterSearchStartTime = new Date();\n"
"var IgnoreInput = 0;\n"
"function RangeInit()\n"
"{\n"
"	return {\"Begin\":-1, \"End\":-1, \"YBegin\":-1, \"YEnd\":-1, \"Thread\": -1 , \"Index\": -1, \"Off\": 0, \"Second\":0};\n"
"}\n"
"function RangeValid(Range)\n"
"{\n"
"	return Range.Begin < Range.End;\n"
"}\n"
"function RangeCopy(Dst, Src)\n"
"{\n"
"	Dst.Begin = Src.Begin;\n"
"	Dst.End = Src.End;\n"
"	Dst.YBegin = Src.YBegin;\n"
"	Dst.YEnd = Src.YEnd;\n"
"	Dst.Thread = Src.Thread;\n"
"	Dst.Off = Src.Off;\n"
"	Dst.Second = Src.Second;\n"
"}\n"
"var RangeCpu = RangeInit();\n"
"var RangeGpu = RangeInit();\n"
"var RangeSelect = RangeInit();\n"
"\n"
"var RangeCpuNext = RangeInit();\n"
"var RangeGpuNext = RangeInit();\n"
"\n"
"var RangeCpuHistory = RangeInit();\n"
"var RangeGpuHistory = RangeInit();\n"
"\n"
"var fRangeBegin = 0;\n"
"var fRangeEnd = -1;\n"
"var fRangeThreadId = -1;\n"
"var fRangeThreadIdNext = -1;\n"
"var fRangeBeginNext = 0;\n"
"var fRangeEndNext = 0;\n"
"var fRangeBeginGpuNext = 0;\n"
"var fRangeEndGpuNext = 0;\n"
"var fRangeBeginHistory = -1;\n"
"var fRangeEndHistory = -1;\n"
"var fRangeBeginHistoryGpu = -1;\n"
"var fRangeEndHistoryGpu = -1;\n"
"var fRangeBeginSelect = 0;\n"
"var fRangeEndSelect = -1;\n"
"var ThreadYBegin;\n"
"var ThreadYEnd;\n"
"\n"
"var ModeDetailed = 0;\n"
"var ModeTimers = 1;\n"
"var ModeTimers_Threads = 2;\n"
"var ModeTimers_Groups = 3;\n"
"var ModeCounters = 4;\n"
"var ModeCount = 5;\n"
"var Mode = ModeDetailed;\n"
"\n"
"var DebugDrawQuadCount = 0;\n"
"var DebugDrawTextCount = 0;\n"
"var ProfileMode = 0;\n"
"var ProfileRedraw0 = 0;\n"
"var ProfileRedraw1 = 0;\n"
"var ProfileRedraw2 = 0;\n"
"var ProfileFps = 0;\n"
"var ProfileFpsAggr = 0;\n"
"var ProfileFpsCount = 0;\n"
"var ProfileLastTimeStamp = new Date();\n"
"\n"
"var ProfileData = {};\n"
"var ProfileStackTime = {};\n"
"var ProfileStackName = {};\n"
"var Debug = 1;\n"
"\n"
"var NumLodSplits = 10;\n"
"var SplitMin = 100;\n"
"var SPLIT_LIMIT = 1e20;\n"
"var DPR = 1;\n"
"var DetailedRedrawState = {};\n"
"var OffscreenData;\n"
"var DetailedFrameCounter = 0;\n"
"var Invalidate = 0;\n"
"var GroupOrder = Array();\n"
"var ThreadOrder = Array();\n"
"var ThreadOrderNames = Array();\n"
"var ThreadOrderT = Array();\n"
"var MetaLengths = Array();\n"
"var MetaLengthsAvg = Array();\n"
"var MetaLengthsMax = Array();\n"
"\n"
"var ZoomActive = 0;\n"
"\n"
"var StrGroup = \"Group\";\n"
"var StrThread = \"Thread\";\n"
"var StrTimer = \"Timer\";\n"
"var StrAverage = \"Average\";\n"
"var StrMax = \"Max\";\n"
"var StrTotal = \"Total\";\n"
"var StrMin = \"Min\";\n"
"var StrSpike = \"Spike%\";\n"
"var StrCallAverage = \"Call Average\";\n"
"var StrCount = \"Count\";\n"
"var StrExclAverage = \"Excl Average\";\n"
"var StrExclMax = \"Excl Max\";\n"
"\n"
"var GroupRemapReverse = [];\n"
"var TimerRemapReverse = [];\n"
"var ThreadRemapReverse = [];\n"
"\n"
"let SubMenuHelp = 0;\n"
"let SubMenuMode = 1;\n"
"let SubMenuReference = 2;\n"
"let SubMenuTarget = 3;\n"
"let SubMenuThreads = 4;\n"
"let SubMenuGroups = 5;\n"
"let SubMenuColumns = 6;\n"
"let SubMenuOptions = 7;\n"
"let SubMenuCompare = 8;\n"
"\n"
"let MenuRedraw = 0;\n"
"let SubMenuActive = -1;\n"
"let SubMenuTimeoutBase = 0.7;\n"
"let SubMenuMouseX = 0;\n"
"let SubMenuMouseY = 0;\n"
"let SubMenuTimeout = new Date();\n"
"let MenuItems = [];\n"
"let FilterInputMenuThreadsValue = \'\';\n"
"let FilterInputMenuGroupsValue = \'\';\n"
"let MouseMoveTime = new Date();\n"
"let ReferenceTimes = [-1, 5, 10, 15, 16, 20, 30, 33, 50, 100, 250, 500, 1000];\n"
"let TargetTimes = [5, 10, 15, 16, 20, 30, 33, 50, 100, 250, 500, 1000];\n"
"let ModeItems = [\"Detailed\", \"Timers\", \"Threads\", \"Groups\", \"Counters\"];\n"
"let HideModeCollapsed = 0;\n"
"let HideModeHidden = 1;\n"
"let HideMode = HideModeCollapsed;\n"
"\n"
"\n"
"function ProfileModeClear()\n"
"{\n"
"	if(ProfileMode)\n"
"	{\n"
"		ProfileData = new Object();\n"
"		ProfileStackTime = new Array();\n"
"		ProfileStackName = new Array();\n"
"	}\n"
"}\n"
"function ProfileEnter(Name)\n"
"{\n"
"	if(ProfileMode)\n"
"	{\n"
"		ProfileStackTime.push(new Date());\n"
"		ProfileStackName.push(Name);\n"
"	}\n"
"}\n"
"function ProfileLeave()\n"
"{\n"
"	if(ProfileMode)\n"
"	{\n"
"		var Time = new Date();\n"
"		var Delta = Time - ProfileStackTime.pop();\n"
"		var Name = ProfileStackName.pop();\n"
"		var Obj = ProfileData[Name];\n"
"		if(!Obj)\n"
"		{\n"
"			Obj = new Object();\n"
"			Obj.Count = 0;\n"
"			Obj.Name = Name;\n"
"			Obj.Time = 0;\n"
"			ProfileData[Name] = Obj;\n"
"		}\n"
"		Obj.Time += Delta;\n"
"		Obj.Count += 1;\n"
"	}\n"
"}\n"
"\n"
"function ProfilePlot(s)\n"
"{\n"
"	if(ProfileMode)\n"
"	{\n"
"		var A = ProfileData.Plot;\n"
"		if(!A)\n"
"		{\n"
"			ProfileData.Plot = Array();\n"
"			A = ProfileData.Plot;\n"
"		}\n"
"		if(A.length<10)\n"
"		{\n"
"			A.push(s);\n"
"		}\n"
"	}\n"
"}\n"
"function ProfileModeDump()\n"
"{\n"
"	for(var idx in ProfileData)\n"
"	{\n"
"		var Timer = ProfileData[idx];\n"
"		console.log(Timer.Name + \" \" + Timer.Time + \"ms \" + Timer.Count);\n"
"	}\n"
"\n"
"}\n"
"function ProfileModeDraw(Canvas)\n"
"{\n"
"	if(ProfileMode)\n"
"	{\n"
"		var StringArray = [];\n"
"		for(var idx in ProfileData)\n"
"		{\n"
"			if(idx == \"Plot\")\n"
"				continue;\n"
"			var Timer = ProfileData[idx];\n"
"			StringArray.push(Timer.Name);\n"
"			StringArray.push(Timer.Time + \"ms\");\n"
"			StringArray.push(\"#\");\n"
"			StringArray.push(\"\" + Timer.Count);\n"
"		}\n"
"		StringArray.push(\"debug\");\n"
"		StringArray.push(Debug);\n"
"		var Time = new Date();\n"
"		var Delta = Time - ProfileLastTimeStamp;\n"
"		ProfileLastTimeStamp = Time;\n"
"		StringArray.push(\"Frame Delta\");\n"
"		StringArray.push(Delta + \"ms\");\n"
"		if(ProfileMode == 2)\n"
"		{\n"
"			ProfileFpsAggr += Delta;\n"
"			ProfileFpsCount ++ ;\n"
"			var AggrFrames = 10;\n"
"			if(ProfileFpsCount == AggrFrames)\n"
"			{\n"
"				ProfileFps = 1000 / (ProfileFpsAggr / AggrFrames);\n"
"				ProfileFpsAggr = 0;\n"
"				ProfileFpsCount = 0;\n"
"			}\n"
"			StringArray.push(\"FPS\");\n"
"			StringArray.push(\"\" + ProfileFps.toFixed(2));\n"
"		}\n"
"		StringArray.push(\"ProfileRedraw0\");\n"
"		StringArray.push(\"\" + ProfileRedraw0);\n"
"		StringArray.push(\"ProfileRedraw1\");\n"
"		StringArray.push(\"\" + ProfileRedraw1);\n"
"		StringArray.push(\"ProfileRedraw2\");\n"
"		StringArray.push(\"\" + ProfileRedraw2);\n"
"		ProfileRedraw0 = 0;\n"
"		ProfileRedraw1 = 0;\n"
"		ProfileRedraw2 = 0;\n"
"\n"
"\n"
"		for(var i = 0; i < ProfileData.Plot; ++i)\n"
"		{\n"
"			StringArray.push(\"\");\n"
"			StringArray.push(ProfileData.Plot[i]);\n"
"		}\n"
"		ProfileData.Plot = Array();\n"
"		DrawToolTip(StringArray, Canvas, 0, 200);\n"
"	}\n"
"}\n"
"\n"
"function ToggleDebugMode()\n"
"{\n"
"	ProfileMode = (ProfileMode+1)%4;\n"
"	console.log(\'Toggle Debug Mode \' + ProfileMode);\n"
"}\n"
"\n"
"function DetailedTotal(S)\n"
"{\n"
"	var Total = 0;\n"
"	for(var i = 0; i < S.Frames.length; i++)\n"
"	{\n"
"		var frfr = S.Frames[i];\n"
"		Total += frfr.frameend - frfr.framestart;\n"
"	}\n"
"	return Total;\n"
"}\n"
"\n"
"\n"
"function InitFrameInfo()\n"
"{\n"
"\n"
"	var div = document.getElementById(\'divFrameInfo\');\n"
"	var txt = \'\';\n"
"	txt = txt + \'Timers View\' + \'<br>\';\n"
"	txt = txt + \'Frames:\' + S.AggregateInfo.Frames +\'<br>\';\n"
"	txt = txt + \'Time:\' + S.AggregateInfo.Time.toFixed(2) +\'ms<br>\';\n"
"	txt = txt + \'<hr>\';\n"
"	txt = txt + \'Detailed View\' + \'<br>\';\n"
"	txt = txt + \'Frames:\' + S.Frames.length +\'<br>\';\n"
"	txt = txt + \'Time:\' + DetailedTotal(S).toFixed(2) +\'ms<br>\';\n"
"	div.innerHTML = txt;\n"
"}\n"
"function InitGroups()\n"
"{\n"
"	for(groupid in S.GroupInfo)\n"
"	{\n"
"		var TimerArray = Array();\n"
"		for(timerid in S.TimerInfo)\n"
"		{\n"
"			if(S.TimerInfo[timerid].group == groupid)\n"
"			{\n"
"				TimerArray.push(timerid);\n"
"			}\n"
"		}\n"
"		S.GroupInfo[groupid].TimerArray = TimerArray;\n"
"	}\n"
"}\n"
"\n"
"\n"
"function ThreadOrderMove(Name, Dir, Top)\n"
"{	\n"
"	let idx = ThreadOrderNames.indexOf(Name);\n"
"	let base = idx;\n"
"	idx += Dir;\n"
"	let found = -1;\n"
"	while(idx >= 0 && idx <= ThreadOrderNames.length)\n"
"	{\n"
"		let n = S.ThreadNames.indexOf(ThreadOrderNames[idx]);\n"
"		if(n != -1)\n"
"		{\n"
"			found = idx;\n"
"			if(!Top)\n"
"				break;\n"
"		}\n"
"		idx += Dir;\n"
"	}\n"
"	Dir = -Dir; \n"
"	while(found >= 0 && found <= ThreadOrderNames.length && (Dir > 0 ? (found <= base) : (found >= base)))\n"
"	{\n"
"		let Tmp = ThreadOrderNames[found];\n"
"		ThreadOrderNames[found] = Name;\n"
"		Name = Tmp;\n"
"		found += Dir;\n"
"	}\n"
"	ThreadOrderSort();\n"
"}\n"
"function ThreadOrderMoveUp(Name, Top)\n"
"{\n"
"	ThreadOrderMove(Name, -1, Top);\n"
"	WriteCookie();\n"
"}\n"
"function ThreadOrderMoveDown(Name, Top)\n"
"{\n"
"	ThreadOrderMove(Name, 1, Top);\n"
"	WriteCookie();\n"
"}\n"
"function ThreadOrderSort()\n"
"{\n"
"	for(let i = 0; i < S.ThreadNames.length; ++i)\n"
"	{\n"
"		var name = S.ThreadNames[i];\n"
"		var idx = ThreadOrderNames.indexOf(name);\n"
"		if(idx == -1)\n"
"		{\n"
"			ThreadOrderNames.push(name);\n"
"		}\n"
"	}\n"
"\n"
"	//clear all that are not present??\n"
"	let ThreadOrderX = Array(S.ThreadNames.length);\n"
"	for(let i = 0; i < S.ThreadNames.length; ++i)\n"
"	{\n"
"		var n = ThreadOrderNames.indexOf(S.ThreadNames[i]);\n"
"		if(n == -1)\n"
"		{\n"
"			debugger;\n"
"		}\n"
"		ThreadOrderX[i] = {\"i\":i, \"n\": n};\n"
"	}\n"
"	ThreadOrderX.sort(function(l,r){return l.n-r.n;});\n"
"	ThreadOrderT = Array(S.ThreadNames.length);\n"
"	for(let i = 0; i < S.ThreadNames.length; ++i)\n"
"	{\n"
"		ThreadOrderT[i] = ThreadOrderX[i].i;\n"
"	}\n"
"}\n"
"\n"
"function ToggleThread(ThreadName, All, FilterArray, State)\n"
"{\n"
"	if(ThreadName)\n"
"	{\n"
"		if(ThreadsActive[ThreadName])\n"
"		{\n"
"			ThreadsActive[ThreadName] = false;\n"
"		}\n"
"		else\n"
"		{\n"
"			ThreadsActive[ThreadName] = true;\n"
"		}\n"
"	}\n"
"	else\n"
"	{\n"
"		let Names = All ? S.ThreadNames : FilterArray;\n"
"\n"
"		for(let i in Names)\n"
"		{\n"
"			switch(State)\n"
"			{\n"
"				case 2: if(!ThreadsActive[Names[i]]){ ThreadsActive[Names[i]] = 1;} break;\n"
"				case 1: ThreadsActive[Names[i]] = ThreadsActive[Names[i]] ? 0 : 1; break;\n"
"				case 0: if(ThreadsActive[Names[i]]){ ThreadsActive[Names[i]] = 0;} break;\n"
"			}\n"
"		}\n"
"	}\n"
"	RequestRedraw();\n"
"	Invalidate = 0;\n"
"	FilterSearchReset();\n"
"	WriteCookie();\n"
"}\n"
"\n"
"\n"
"function CreateOrderArray(Source, NameFunc)\n"
"{\n"
"	var Temp = Array(Source.length);\n"
"	for(var i = 0; i < Source.length; ++i)\n"
"	{\n"
"		Temp[i] = {};\n"
"		Temp[i].index = i;\n"
"		Temp[i].namezz = NameFunc(Source[i]).toLowerCase();\n"
"	}\n"
"	Temp.sort(function(l, r)\n"
"	{ \n"
"		if(r.namezz<l.namezz)\n"
"			{return 1;}\n"
"		if(l.namezz<r.namezz)\n"
"			{return -1;} \n"
"		return 0;\n"
"	} );\n"
"	var OrderArray = Array(Source.length);\n"
"	for(var i = 0; i < Source.length; ++i)\n"
"	{\n"
"		OrderArray[i] = Temp[i].index;\n"
"	}\n"
"	return OrderArray;\n"
"}\n"
"\n"
"function InitOrderArrays()\n"
"{\n"
"	ThreadOrder = [];\n"
"	ThreadOrder = CreateOrderArray(S.ThreadNames, function(a){return a;});\n"
"\n"
"\n"
"	let MaxLen = 7;\n"
"	let MenuArray = Array();\n"
"	for(let i = 0; i < S.GroupInfo.length; ++i)\n"
"	{\n"
"		let x = {};\n"
"		x.IsCategory = 0;\n"
"		x.category = S.GroupInfo[i].category;\n"
"		x.name = S.GroupInfo[i].name;\n"
"		x.index = i;\n"
"		MenuArray.push(x);\n"
"	}\n"
"	for(let i = 0; i < S.CategoryInfo.length; ++i)\n"
"	{\n"
"		let x = {};\n"
"		x.IsCategory = 1;\n"
"		x.category = i;\n"
"		x.name = S.CategoryInfo[i];\n"
"		x.index = i;\n"
"		MenuArray.push(x);\n"
"	}\n"
"	let OrderFunction = function(a){ return a.category + \"__\" + a.name; };\n"
"	let OrderFunctionMenu = function(a){ return a.IsCategory ? (a.category + \'\') : (a.category + \"__\" + a.name); };\n"
"	GroupOrder = CreateOrderArray(S.GroupInfo, OrderFunction);\n"
"}\n"
"\n"
"function CategoryIndex(CategoryName)\n"
"{\n"
"	for(var i = 0; i < S.CategoryInfo.length; ++i)\n"
"	{\n"
"		if(S.CategoryInfo[i] == CategoryName)\n"
"		{\n"
"			return i;\n"
"		}\n"
"	}\n"
"	return -1;\n"
"}\n"
"function IsCategoryActive(CategoryIdx)\n"
"{\n"
"	for(var i = 0; i < S.GroupInfo.length; ++i)\n"
"	{\n"
"		if(S.GroupInfo[i].category == CategoryIdx)\n"
"		{\n"
"			var Name = S.GroupInfo[i].name;\n"
"			if(!GroupsActive[Name])\n"
"			{\n"
"				return false;\n"
"			}\n"
"		}\n"
"	}\n"
"	return true;\n"
"\n"
"}\n"
"function ToggleCategory(CategoryName, WantRedraw)\n"
"{\n"
"	var CategoryIdx = CategoryIndex(CategoryName);\n"
"	if(CategoryIdx < 0)\n"
"		return;\n"
"	var CategoryActive = IsCategoryActive(CategoryIdx);\n"
"	for(var i = 0; i < S.GroupInfo.length; ++i)\n"
"	{\n"
"		if(S.GroupInfo[i].category == CategoryIdx)\n"
"		{\n"
"			var Name = S.GroupInfo[i].name;\n"
"			if(CategoryActive)\n"
"			{\n"
"				delete GroupsDisabled[Name];\n"
"			}\n"
"			else\n"
"			{\n"
"				GroupsDisabled[Name] = 1;\n"
"			}\n"
"		}\n"
"	}\n"
"	WriteCookie();\n"
"	if(WantRedraw)\n"
"	{\n"
"		RequestRedraw();\n"
"	}\n"
"}\n"
"\n"
"function ToggleGroup(GroupName, All, FilterArray, State)\n"
"{\n"
"	if(GroupName)\n"
"	{\n"
"		if(GroupsDisabled[GroupName])\n"
"		{\n"
"			delete GroupsDisabled[GroupName];\n"
"		}\n"
"		else\n"
"		{\n"
"			GroupsDisabled[GroupName] = 1;\n"
"		}\n"
"	}\n"
"	else\n"
"	{\n"
"		let Names = FilterArray;\n"
"		if(All)\n"
"		{\n"
"			Names = [];\n"
"			for(let i in S.GroupInfo)\n"
"			{\n"
"				Names.push(S.GroupInfo[i].name);\n"
"			}\n"
"		}\n"
"\n"
"		for(let i in Names)\n"
"		{\n"
"			let N = Names[i];\n"
"			switch(State)\n"
"			{\n"
"				case 2: if(GroupsDisabled[N]){ delete GroupsDisabled[N];} break;\n"
"				case 1: \n"
"					if(GroupsDisabled[N])\n"
"					{\n"
"						delete GroupsDisabled[N];\n"
"					}\n"
"					else\n"
"					{\n"
"						GroupsDisabled[N] = 1;\n"
"					}\n"
"\n"
"					break;\n"
"				case 0: if(!GroupsDisabled[N]){ GroupsDisabled[N] = 1;} break;\n"
"			}\n"
"		}\n"
"	}\n"
"	WriteCookie();\n"
"}\n"
"\n"
"function UpdateGroupColors()\n"
"{\n"
"	for(var i = 0; i < S.TimerInfo.length; ++i)\n"
"	{\n"
"		if(GroupColors == 1)\n"
"		{\n"
"			S.TimerInfo[i].cid = S.GroupInfo[S.TimerInfo[i].group].cid;\n"
"		}\n"
"		else\n"
"		{\n"
"			S.TimerInfo[i].cid = S.TimerInfo[i].timercid;\n"
"		}\n"
"	}\n"
"}\n"
"function ToggleDetailedFlameMode(WantRedraw)\n"
"{\n"
"	DrawDetailedFlameMode = (DrawDetailedFlameMode+1)%3;\n"
"	if(WantRedraw)\n"
"	{\n"
"		RequestRedraw();\n"
"	}\n"
"}	\n"
"\n"
"function ToggleDetailedSecondReverse(WantRedraw)\n"
"{\n"
"	DrawDetailedCompareReverse = 1-DrawDetailedCompareReverse;\n"
"	if(WantRedraw)\n"
"	{\n"
"		RequestRedraw();\n"
"	}\n"
"}	\n"
"\n"
"function ToggleGroupColors(WantRedraw)\n"
"{\n"
"	GroupColors = (GroupColors+1)%3;\n"
"	UpdateGroupColors();\n"
"	WriteCookie();\n"
"	if(WantRedraw)\n"
"	{\n"
"		RequestRedraw();\n"
"	}\n"
"}\n"
"\n"
"function ShowHelp(Show, Forever)\n"
"{\n"
"	var HelpWindow = document.getElementById(\'helpwindow\');\n"
"	if(Show)\n"
"	{\n"
"		HelpWindow.style[\'display\'] = \'block\';\n"
"	}\n"
"	else\n"
"	{\n"
"		HelpWindow.style[\'display\'] = \'none\';\n"
"	}\n"
"	if(Forever)\n"
"	{\n"
"		nHideHelp = Show ? 0 : 1;\n"
"		WriteCookie();\n"
"	}\n"
"}\n"
"function ToggleMode()\n"
"{\n"
"	Mode = (Mode + 1) % ModeCount;\n"
"	SetMode(Mode);\n"
"}\n"
"\n"
"function SetMode(NewMode, WantRedraw)\n"
"{\n"
"	ResetColumnWidth();\n"
"	Mode = NewMode;\n"
"	if(Mode == ModeTimers || Mode == ModeTimers_Groups || Mode == ModeTimers_Threads)\n"
"	{\n"
"		SetFilterInput(FilterInputGroupString, FilterInputTimerString);\n"
"	}\n"
"	else\n"
"	{\n"
"		ShowFilterInput(0);\n"
"	}\n"
"\n"
"	WriteCookie();\n"
"	if(WantRedraw)\n"
"	{\n"
"		RequestRedraw();\n"
"	}\n"
"}\n"
"\n"
"\n"
"function UpdateReferenceTime()\n"
"{\n"
"	if(\'auto\' == ReferenceTimeString.substring(0,4))\n"
"	{\n"
"		let Max = 0.1;\n"
"		for(var i = 0; i < S.Frames.length; ++i)\n"
"		{\n"
"			let T = S.Frames[i].frameend - S.Frames[i].framestart;\n"
"			Max = Math.max(T, Max);\n"
"		}\n"
"		ReferenceTime = Max*1.20;\n"
"		if(TargetTime>0)\n"
"		{\n"
"			ReferenceTime = Math.max(ReferenceTime, TargetTime * 1.33);\n"
"		}\n"
"		ReferenceTimeAutoString = \'auto [\' + Max.toFixed(2) + \'ms]\';\n"
"	}\n"
"	else\n"
"	{\n"
"		ReferenceTime = parseInt(ReferenceTimeString);\n"
"	}\n"
"}\n"
"\n"
"function SetReferenceTime(TimeString, WantRedraw)\n"
"{\n"
"	ReferenceTimeString = TimeString;\n"
"	UpdateReferenceTime();\n"
"	WriteCookie();\n"
"	if(WantRedraw)\n"
"	{\n"
"		RequestRedraw();\n"
"	}\n"
"}\n"
"\n"
"function SetTargetTime(TimeString, WantRedraw)\n"
"{\n"
"	TargetTimeString = TimeString;\n"
"	TargetTime = parseInt(TargetTimeString);\n"
"	WriteCookie();\n"
"	if(WantRedraw)\n"
"	{\n"
"		RequestRedraw();\n"
"	}\n"
"}\n"
"\n"
"function ToggleContextSwitch()\n"
"{\n"
"	SetContextSwitch(nContextSwitchEnabled ? 0 : 1);\n"
"}\n"
"\n"
"function SetContextSwitch(Enabled, WantRedraw)\n"
"{\n"
"	nContextSwitchEnabled = Enabled ? 1 : 0;\n"
"	WriteCookie();\n"
"	if(WantRedraw)\n"
"	{\n"
"		RequestRedraw();\n"
"	}\n"
"}\n"
"\n"
"function ToggleDebug()\n"
"{\n"
"	Debug = (Debug + 1) % 2;\n"
"}\n"
"\n"
"function ToggleDisableMerge()\n"
"{\n"
"	DisableMerge = DisableMerge ? 0 : 1;\n"
"}\n"
"function ToggleDisableLod()\n"
"{\n"
"	DisableLod = DisableLod ? 0 : 1;\n"
"}\n"
"\n"
"function GatherHoverMetaCounters(TimerIndex, StartIndex, nLog, nFrameLast)\n"
"{\n"
"	var HoverInfo = new Object();\n"
"	return HoverInfo;\n"
"	var StackPos = 1;\n"
"	//search backwards, count meta counters \n"
"	for(var i = nFrameLast; i >= 0; i--)\n"
"	{\n"
"		var fr = S.Frames[i];\n"
"		var ts = fr.ts[nLog];\n"
"		var ti = fr.ti[nLog];\n"
"		var tt = fr.tt[nLog];\n"
"		var start = i == nFrameLast ? StartIndex-1-fr.LogStart[nLog] : ts.length-1;\n"
"\n"
"		for(var j = start; j >= 0; j--)\n"
"		{\n"
"			var type = tt[j];\n"
"			var index = ti[j];\n"
"			var time = ts[j];\n"
"			if(type == 1)\n"
"			{\n"
"				StackPos--;\n"
"				if(StackPos == 0 && index == TimerIndex)\n"
"				{\n"
"					return HoverInfo;\n"
"				}\n"
"			}\n"
"			else if(type == 0)\n"
"			{\n"
"				StackPos++;\n"
"			}\n"
"			else if(type > 1)\n"
"			{\n"
"				// var nMetaCount = type - 3;\n"
"				// var nMetaIndex = MetaNames[index];\n"
"				// if(nMetaIndex in HoverInfo)\n"
"				// {\n"
"				// 	HoverInfo[nMetaIndex] += nMetaCount;\n"
"				// }\n"
"				// else\n"
"				// {\n"
"				// 	HoverInfo[nMetaIndex] = nMetaCount;\n"
"				// }\n"
"			}\n"
"		}\n"
"	}\n"
"}\n"
"function CalculateAllTimers(fBegin, fEnd)\n"
"{\n"
"	var Sum = [];\n"
"	var Count = [];\n"
"	var Sorted = [];\n"
"	for(var i = 0; i < S.TimerInfo.length; ++i)\n"
"	{\n"
"		Sum.push(0.0);\n"
"		Count.push(0);\n"
"		Sorted.push(i);\n"
"	}\n"
"	var nFrameFirst = 0;\n"
"	var nFrameLast = S.Frames.length;\n"
"\n"
"	var nNumLogs = S.Frames[0].ts.length;\n"
"	var StackPosArray = Array(nNumLogs);\n"
"	var StackArray = Array(nNumLogs);\n"
"	for(var i = 0; i < nNumLogs; ++i)\n"
"	{\n"
"		StackPosArray[i] = 0;\n"
"		StackArray[i] = Array(20);\n"
"	}\n"
"\n"
"	for(var i = nFrameFirst; i < nFrameLast; i++)\n"
"	{\n"
"		var fr = S.Frames[i];\n"
"		for(nLog = 0; nLog < nNumLogs; nLog++)\n"
"		{\n"
"			var StackPos = StackPosArray[nLog];\n"
"			var Stack = StackArray[nLog];\n"
"			var ts = fr.ts[nLog];\n"
"			var ti = fr.ti[nLog];\n"
"			var tt = fr.tt[nLog];\n"
"			var count = ts.length;\n"
"			for(j = 0; j < count; j++)\n"
"			{\n"
"				var type = tt[j];\n"
"				var index = ti[j];\n"
"				var time = ts[j];\n"
"				if(type == 1 && time < fEnd) //enter\n"
"				{\n"
"					Stack[StackPos] = time < fBegin ? fBegin : time;\n"
"					if(StackArray[nLog][StackPos] != time)\n"
"					{\n"
"						console.log(\'fail fail fail\');\n"
"					}\n"
"					StackPos++;\n"
"				}\n"
"				else if(type == 0) // leave\n"
"				{\n"
"					if(StackPos>0)\n"
"					{\n"
"						var timeend = time;\n"
"						StackPos--;\n"
"						timestart = Stack[StackPos];\n"
"						var TimeDelta = timeend - timestart;\n"
"						Sum[index] += TimeDelta;\n"
"						Count[index]++;\n"
"					}\n"
"				}\n"
"			}\n"
"			StackPosArray[nLog] = StackPos;\n"
"		}\n"
"	}\n"
"	Sorted.sort(function(a,b){ return Sum[b] - Sum[a]; } );\n"
"	var Result = {\"Sorted\" : Sorted, \"Sum\" : Sum, \"Count\" : Count};\n"
"	return Result;\n"
"}\n"
"\n"
"function CalculateTimers2(Result, TimerIndex, Time, SContext)\n"
"{\n"
"	let nFrame = -1;\n"
"	for(var i = 0; i < SContext.Frames.length; ++i)\n"
"	{\n"
"		let F = SContext.Frames[i];\n"
"		if(Time > F.framestart && Time <= F.frameend)\n"
"		{\n"
"			nFrame = i;\n"
"			break;\n"
"		}\n"
"	}\n"
"	CalculateTimers(Result, TimerIndex, nFrame, nFrame+1, SContext);\n"
"	return nFrame;\n"
"}\n"
"\n"
"function CalculateTimers(Result, TimerIndex, nFrameFirst, nFrameLast, SContext)\n"
"{\n"
"	if(!SContext)\n"
"		SContext = S;\n"
"	if(!nFrameFirst || nFrameFirst < 0)\n"
"		nFrameFirst = 0;\n"
"	if(!nFrameLast || nFrameLast > SContext.Frames.length)\n"
"		nFrameLast = SContext.Frames.length;\n"
"	var FrameCount = nFrameLast - nFrameFirst;\n"
"	if(0 == FrameCount)\n"
"		return;\n"
"	var CallCount = 0;\n"
"	var Sum = 0;\n"
"	var Max = 0;\n"
"	var FrameMax = 0;\n"
"\n"
"	var nNumLogs = SContext.Frames[0].ts.length;\n"
"	var StackPosArray = Array(nNumLogs);\n"
"	var StackArray = Array(nNumLogs);\n"
"	let StackIndexArray = Array(nNumLogs);\n"
"	for(var i = 0; i < nNumLogs; ++i)\n"
"	{\n"
"		StackPosArray[i] = 0;\n"
"		StackArray[i] = Array(32);\n"
"		StackIndexArray[i] = Array(32);\n"
"	}\n"
"\n"
"	for(var i = nFrameFirst; i < nFrameLast; i++)\n"
"	{\n"
"		let FrameSum = 0;\n"
"		let fr = SContext.Frames[i];\n"
"		for(nLog = 0; nLog < nNumLogs; nLog++)\n"
"		{\n"
"			let StackPos = StackPosArray[nLog];\n"
"			let Stack = StackArray[nLog];\n"
"			let StackIndex = StackIndexArray[nLog];\n"
"			var ts = fr.ts[nLog];\n"
"			var ti = fr.ti[nLog];\n"
"			var tt = fr.tt[nLog];\n"
"			var count = ts.length;\n"
"			for(var j = 0; j < count; j++)\n"
"			{\n"
"				var type = tt[j];\n"
"				var index = ti[j];\n"
"				var time = ts[j];\n"
"				if(type == 1) //enter\n"
"				{\n"
"					//push\n"
"					Stack[StackPos] = time;\n"
"					StackIndex[StackPos] = index;\n"
"					if(StackArray[nLog][StackPos] != time)\n"
"					{\n"
"						console.log(\'fail fail fail\');\n"
"					}\n"
"					StackPos++;\n"
"				}\n"
"				else if(type == 0) // leave\n"
"				{\n"
"					var timestart;\n"
"					var timeend = time;\n"
"					if(StackPos>0)\n"
"					{\n"
"						StackPos--;\n"
"						timestart = Stack[StackPos];\n"
"					}\n"
"					else\n"
"					{\n"
"						timestart = SContext.Frames[nFrameFirst].framestart;\n"
"					}\n"
"					if(index == TimerIndex)\n"
"					{\n"
"						let TimeDelta = timeend - timestart;\n"
"						CallCount++;\n"
"						FrameSum += TimeDelta;\n"
"						Sum += TimeDelta;\n"
"						if(TimeDelta > Max)\n"
"							Max = TimeDelta;\n"
"					}\n"
"				}\n"
"				else\n"
"				{\n"
"					//meta\n"
"				}\n"
"			}\n"
"			if(i == nFrameLast - 1)\n"
"			{\n"
"				for(var j = 0; j < StackPos; ++j)\n"
"				{\n"
"					if(StackIndex[j] == TimerIndex)\n"
"					{\n"
"						let LastFrameEnd = SContext.Frames[nFrameLast-1].frameend;\n"
"						let TimeDelta = LastFrameEnd - Stack[j];\n"
"						CallCount++;\n"
"						FrameSum += TimeDelta;\n"
"						Sum += TimeDelta;\n"
"						if(TimeDelta > Max)\n"
"							Max = TimeDelta;\n"
"						break;\n"
"					}\n"
"				}\n"
"\n"
"			}\n"
"			if(FrameSum > FrameMax)\n"
"			{\n"
"				FrameMax = FrameSum;\n"
"			}\n"
"			StackPosArray[nLog] = StackPos;\n"
"		}\n"
"	}\n"
"\n"
"	Result.CallCount = CallCount;\n"
"	Result.Sum = Sum.toFixed(3);\n"
"	Result.Max = Max.toFixed(3);\n"
"	Result.Average = (Sum / CallCount).toFixed(3);\n"
"	Result.FrameAverage = (Sum / FrameCount).toFixed(3);\n"
"	Result.FrameCallAverage = (CallCount / FrameCount).toFixed(3);\n"
"	Result.FrameMax = FrameMax.toFixed(3);\n"
"	return Result;\n"
"}\n"
"\n"
"function PreprocessCalculateAllTimers()\n"
"{\n"
"	ProfileEnter(\"CalculateAllTimers\");\n"
"	var nFrameFirst = 0;\n"
"	var nFrameLast = S.Frames.length;\n"
"	var FrameCount = nFrameLast - nFrameFirst;\n"
"	if(0 == FrameCount)\n"
"		return;\n"
"	for(var j = 0; j < S.TimerInfo.length; j++)\n"
"	{\n"
"		S.TimerInfo[j].CallCount = 0;\n"
"		S.TimerInfo[j].Sum = 0;\n"
"		S.TimerInfo[j].Max = 0;\n"
"		S.TimerInfo[j].FrameMax = 0;\n"
"	}\n"
"\n"
"\n"
"	var nNumLogs = S.Frames[0].ts.length;\n"
"	var StackPosArray = Array(nNumLogs);\n"
"	var StackArray = Array(nNumLogs);\n"
"	for(var i = 0; i < nNumLogs; ++i)\n"
"	{\n"
"		StackPosArray[i] = 0;\n"
"		StackArray[i] = Array(20);\n"
"	}\n"
"\n"
"	for(var i = nFrameFirst; i < nFrameLast; i++)\n"
"	{\n"
"		for(var j = 0; j < S.TimerInfo.length; j++)\n"
"		{\n"
"			S.TimerInfo[j].FrameSum = 0;\n"
"		}\n"
"\n"
"		var fr = S.Frames[i];\n"
"		for(nLog = 0; nLog < nNumLogs; nLog++)\n"
"		{\n"
"			var StackPos = StackPosArray[nLog];\n"
"			var Stack = StackArray[nLog];\n"
"			var ts = fr.ts[nLog];\n"
"			var ti = fr.ti[nLog];\n"
"			var tt = fr.tt[nLog];\n"
"			var count = ts.length;\n"
"			for(j = 0; j < count; j++)\n"
"			{\n"
"				var type = tt[j];\n"
"				var index = ti[j];\n"
"				var time = ts[j];\n"
"				if(type == 1) //enter\n"
"				{\n"
"					//push\n"
"					Stack[StackPos] = time;\n"
"					if(StackArray[nLog][StackPos] != time)\n"
"					{\n"
"						console.log(\'fail fail fail\');\n"
"					}\n"
"					StackPos++;\n"
"				}\n"
"				else if(type == 0) // leave\n"
"				{\n"
"					var timestart;\n"
"					var timeend = time;\n"
"					if(StackPos>0)\n"
"					{\n"
"						StackPos--;\n"
"						timestart = Stack[StackPos];\n"
"					}\n"
"					else\n"
"					{\n"
"						timestart = S.Frames[nFrameFirst].framestart;\n"
"					}\n"
"					// if(index == TimerIndex)\n"
"					{\n"
"						var TimeDelta = timeend - timestart;\n"
"						S.TimerInfo[index].CallCount++;\n"
"						S.TimerInfo[index].FrameSum += TimeDelta;\n"
"						S.TimerInfo[index].Sum += TimeDelta;\n"
"						if(TimeDelta > S.TimerInfo[index].Max)\n"
"						{\n"
"							S.TimerInfo[index].Max = TimeDelta;\n"
"							S.TimerInfo[index].worst = TimeDelta;\n"
"							S.TimerInfo[index].worststart = timestart;\n"
"							S.TimerInfo[index].worstend = timeend;\n"
"							S.TimerInfo[index].worstthread = nLog;\n"
"						}\n"
"					}\n"
"				}\n"
"				else\n"
"				{\n"
"					//meta\n"
"				}\n"
"			}\n"
"			for(var j = 0; j < S.TimerInfo.length; j++)\n"
"			{\n"
"				if(S.TimerInfo[j].FrameSum > S.TimerInfo[j].FrameMax)\n"
"				{\n"
"					S.TimerInfo[j].FrameMax = S.TimerInfo[j].FrameSum;\n"
"				}\n"
"			}\n"
"			StackPosArray[nLog] = StackPos;\n"
"		}\n"
"\n"
"\n"
"	}\n"
"\n"
"	for(var j = 0; j < S.TimerInfo.length; j++)\n"
"	{\n"
"		var CallCount = S.TimerInfo[j].CallCount;\n"
"		var Sum = S.TimerInfo[j].Sum.toFixed(3);\n"
"		var Max = S.TimerInfo[j].Max.toFixed(3);\n"
"		var Average = (S.TimerInfo[j].Sum / S.TimerInfo[j].CallCount).toFixed(3);\n"
"		var FrameAverage = (S.TimerInfo[j].Sum / FrameCount).toFixed(3);\n"
"		var FrameCallAverage = (S.TimerInfo[j].CallCount / FrameCount).toFixed(3);\n"
"		var FrameMax = S.TimerInfo[j].FrameMax.toFixed(3);\n"
"		S.TimerInfo[j].CallCount = CallCount;\n"
"		S.TimerInfo[j].Sum = Sum;\n"
"		S.TimerInfo[j].Max  = Max ;\n"
"		S.TimerInfo[j].Average = Average;\n"
"		S.TimerInfo[j].FrameAverage = FrameAverage;\n"
"		S.TimerInfo[j].FrameCallAverage = FrameCallAverage;\n"
"		S.TimerInfo[j].FrameMax = FrameMax;\n"
"	}\n"
"	ProfileLeave();\n"
"}\n"
"\n"
"var FlashFrames = 10;\n"
"var FlashFrameCounter = 0;\n"
"var FlashMessage = \'\';\n"
"function TimeString(Diff)\n"
"{\n"
"	var DiffString = \"0 sec\";\n"
"	var DiffTable = [1,60,60*60,60*60*24];\n"
"	var DiffNameTable = [\"sec\", \"min\", \"hr\", \"day\"];\n"
"	for(var i = 0; i < DiffTable.length; ++i)\n"
"	{\n"
"		if(Diff >= DiffTable[i])\n"
"		{\n"
"			DiffString = Math.floor(Diff / DiffTable[i]) + \" \" + DiffNameTable[i];\n"
"		}\n"
"	}\n"
"	return DiffString;\n"
"\n"
"}\n"
"function ShowFlashMessage(Message, FrameCount)\n"
"{\n"
"	FlashMessage = Message;\n"
"	FlashFrameCounter = FrameCount;\n"
"}\n"
"function OnPageReady()\n"
"{\n"
"	var DumpDate = S.DumpUtcCaptureTime;\n"
"	var CurrentDate = Date.now() / 1000;\n"
"	var Diff = CurrentDate - DumpDate;\n"
"	var Limit = 10*60;//flash old message when loading captures older than 10 minutes \n"
"	if(Diff > Limit)\n"
"	{\n"
"		ShowFlashMessage(\"Captured \" + TimeString(Diff) + \" ago\", 100);\n"
"	}\n"
"}\n"
"\n"
"function DrawFlashMessage(context)\n"
"{\n"
"	if(FlashFrameCounter > 0)\n"
"	{\n"
"		if(FlashFrameCounter>1)\n"
"		{\n"
"			var FlashPrc = Math.sin(FlashFrameCounter / FlashFrames);\n"
"			context.font = FontFlash;\n"
"			context.globalAlpha = FlashPrc * 0.35 + 0.5;\n"
"			context.textAlign = \'center\';\n"
"			context.fillStyle = \'red\';\n"
"			context.fillText(FlashMessage, nWidth * 0.5, 50);\n"
"			context.globalAlpha = 1;\n"
"			context.textAlign = \'left\';\n"
"			context.font = Font;\n"
"		}\n"
"		FlashFrameCounter -= 1;\n"
"\n"
"	}\n"
"}\n"
"\n"
"function DrawCaptureInfo(context)\n"
"{\n"
"	context.fillStyle = \'white\';\n"
"	context.textAlign = \'right\';\n"
"	context.font = Font;\n"
"	var DumpDate = S.DumpUtcCaptureTime;\n"
"	var CurrentDate = Date.now() / 1000;\n"
"	var Diff = CurrentDate - DumpDate;\n"
"	var DiffString = TimeString(Diff) + \" ago\";\n"
"	context.fillText(new Date(DumpDate*1000).toLocaleString(), nWidth, FontHeight);\n"
"	if(Mode == ModeTimers || Mode == ModeTimers_Threads || Mode == ModeTimers_Groups)\n"
"	{\n"
"		context.fillText(\"Timer Frames: \" + S.AggregateInfo.Frames, nWidth, FontHeight*2);\n"
"	}\n"
"	else\n"
"	{\n"
"		context.fillText(\"Detailed Frames \"+ S.Frames.length, nWidth, FontHeight*2);\n"
"	}\n"
"	context.fillText(S.DumpHost, nWidth, FontHeight*3);\n"
"	context.fillText(DiffString, nWidth, FontHeight*4);\n"
"	context.textAlign = \'left\';\n"
"	DrawFlashMessage(context);\n"
"}\n"
"\n"
"function DrawDetailedFrameHistory()\n"
"{\n"
"	ProfileEnter(\"DrawDetailedFrameHistory\");\n"
"	var x = HistoryViewMouseX;\n"
"\n"
"	var context = CanvasHistory.getContext(\'2d\');\n"
"	context.clearRect(0, 0, CanvasHistory.width, CanvasHistory.height);\n"
"\n"
"	let HistoryHeight = CanvasHistory.height;\n"
"\n"
"	var GreenTime = (TargetTime * 0.9);\n"
"	var RedBegin = (TargetTime * 1.1);\n"
"	var LerpDist = 1.0 / (RedBegin - GreenTime);\n"
"\n"
"\n"
"	var fHeight = nHistoryHeight;\n"
"	var fWidth = nWidth / S.Frames.length;\n"
"	var fHeightScale = fHeight / ReferenceTime;\n"
"	var fX = 0;\n"
"	var FrameIndex = -1;\n"
"	var MouseDragging = MouseDragState != MouseDragOff;\n"
"	RangeCpuHistory = RangeInit();\n"
"	RangeGpuHistory = RangeInit()\n"
"\n"
"	var FrameFirst = -1;\n"
"	var FrameLast = nWidth;\n"
"	var fDetailedOffsetEnd = fDetailedOffset + fDetailedRange;\n"
"	for(i = 0; i < S.Frames.length; i++)\n"
"	{\n"
"		var fMs = S.Frames[i].frameend - S.Frames[i].framestart;\n"
"\n"
"		var fPrc = (fMs - GreenTime) * LerpDist;\n"
"		fPrc = Clamp(fPrc, 0, 1);\n"
"		var color = LerpColor(fPrc);\n"
"\n"
"\n"
"\n"
"		if(fDetailedOffset <= S.Frames[i].frameend && fDetailedOffset >= S.Frames[i].framestart)\n"
"		{\n"
"			var lerp = (fDetailedOffset - S.Frames[i].framestart) / (S.Frames[i].frameend - S.Frames[i].framestart);\n"
"			FrameFirst = fX + fWidth * lerp;\n"
"		}\n"
"		if(fDetailedOffsetEnd <= S.Frames[i].frameend && fDetailedOffsetEnd >= S.Frames[i].framestart)\n"
"		{\n"
"			var lerp = (fDetailedOffsetEnd - S.Frames[i].framestart) / (S.Frames[i].frameend - S.Frames[i].framestart);\n"
"			FrameLast = fX + fWidth * lerp;\n"
"		}\n"
"		var fH = fHeightScale * fMs;\n"
"		var bMouse = x > fX && x < fX + fWidth;\n"
"		if(bMouse && !MouseDragging)\n"
"		{\n"
"			context.fillStyle = FRAME_HISTORY_COLOR_GPU;\n"
"			RangeCpuHistory.Begin = S.Frames[i].framestart;\n"
"			RangeCpuHistory.End = S.Frames[i].frameend;\n"
"			if(S.Frames[i].framestartgpu)\n"
"			{\n"
"				RangeGpuHistory.Begin = S.Frames[i].framestartgpu;\n"
"				RangeGpuHistory.End = S.Frames[i].frameendgpu;\n"
"			}\n"
"			FrameIndex = i;\n"
"		}\n"
"		else\n"
"		{\n"
"			context.fillStyle = color;\n"
"		}\n"
"		context.fillRect(fX, fHeight - fH, fWidth-1, fH);\n"
"		fX += fWidth;\n"
"	}\n"
"\n"
"	var fRangeHistoryBegin = FrameFirst;\n"
"	var fRangeHistoryEnd = FrameLast;\n"
"	var X = fRangeHistoryBegin;\n"
"	var Y = 0;\n"
"	var W = fRangeHistoryEnd - fRangeHistoryBegin;\n"
"	context.globalAlpha = 0.35;\n"
"	context.fillStyle = \'#009900\';\n"
"	context.fillRect(X, Y, W, fHeight);\n"
"	context.globalAlpha = 1;\n"
"	context.strokeStyle = \'#00ff00\';\n"
"	context.beginPath();\n"
"	context.moveTo(X, Y);\n"
"	context.lineTo(X, Y+fHeight);\n"
"	context.moveTo(X+W, Y);\n"
"	context.lineTo(X+W, Y+fHeight);\n"
"	context.stroke();\n"
"\n"
"	{\n"
"		var fH = fHeight - fHeightScale * TargetTime;\n"
"		context.fillStyle = \'wheat\';\n"
"		context.strokeStyle = \'wheat\';\n"
"		context.beginPath();\n"
"		context.moveTo(0, fH);\n"
"		context.lineTo(nWidth, fH);\n"
"		// context.closePath();\n"
"		context.stroke();\n"
"		var YText;\n"
"		if(fH > HistoryHeight * 0.25)\n"
"		{\n"
"			YText = fH - FontAscent;\n"
"		}\n"
"		else\n"
"		{\n"
"			YText = fH + FontHeight;\n"
"		}\n"
"		context.fillText(TargetTime + \'ms\', 3, YText);\n"
"		context.textAlign=\'right\';\n"
"		context.fillText(FormatTime(ReferenceTime) + \'ms\', nWidth, FontHeight);\n"
"		context.textAlign=\'left\';\n"
"	}\n"
"\n"
"\n"
"	DrawCaptureInfo(context);\n"
"\n"
"	if(FrameIndex>=0 && !MouseDragging)\n"
"	{\n"
"		var StringArray = [];\n"
"		StringArray.push(\"Frame\");\n"
"		StringArray.push(\"\" + FrameIndex);\n"
"		StringArray.push(\"Time\");\n"
"		StringArray.push(\"\" + (S.Frames[FrameIndex].frameend - S.Frames[FrameIndex].framestart).toFixed(3));\n"
"\n"
"		DrawToolTip(StringArray, CanvasHistory, HistoryViewMouseX, HistoryViewMouseY+20);\n"
"\n"
"	}\n"
"	ProfileLeave();\n"
"}\n"
"function TimeToMsString(Time)\n"
"{\n"
"	return Time.toFixed(3) + \"ms\";\n"
"}\n"
"function TimeToString(Time)\n"
"{\n"
"	if(Time > 1000)\n"
"	{\n"
"		return (Time/1000.0).toFixed(0) +\"s\";\n"
"	}\n"
"	else if(Time > 0.9)\n"
"	{\n"
"		return Time.toFixed(0) + \"ms\";\n"
"	}\n"
"	else if(Time > 0.0009)\n"
"	{\n"
"		return (Tim";

const size_t g_MicroProfileHtml_end_0_size = sizeof(g_MicroProfileHtml_end_0);
const char g_MicroProfileHtml_end_1[] =
"e*1000).toFixed(0) + \"us\";\n"
"	}\n"
"	else\n"
"	{\n"
"		return (Time*1000000).toFixed(0) + \"ns\";\n"
"	}\n"
"}\n"
"\n"
"function DrawDetailedBackground(context)\n"
"{\n"
"	var fMs = fDetailedRange;\n"
"	var fMsEnd = fMs + fDetailedOffset;\n"
"	var fMsToScreen = nWidth / fMs;\n"
"	var fRate = Math.floor(2*((Math.log(fMs)/Math.log(10))-1))/2;\n"
"	var fStep = Math.pow(10, fRate);\n"
"	var fRcpStep = 1.0 / fStep;\n"
"	var nColorIndex = Math.floor(fDetailedOffset * fRcpStep) % 2;\n"
"	if(nColorIndex < 0)\n"
"		nColorIndex = -nColorIndex;\n"
"	var fStart = Math.floor(fDetailedOffset * fRcpStep) * fStep;\n"
"	var fHeight = CanvasDetailedView.height;\n"
"	var fScaleX = nWidth / fDetailedRange; \n"
"	var HeaderString = TimeToString(fStep);\n"
"	context.textAlign = \'center\';\n"
"	for(f = fStart; f < fMsEnd; )\n"
"	{\n"
"		var fNext = f + fStep;\n"
"		var X = (f - fDetailedOffset) * fScaleX;\n"
"		var W = (fNext-f)*fScaleX;\n"
"		context.fillStyle = nBackColors[nColorIndex];\n"
"		context.fillRect(X, 0, W+2, fHeight);\n"
"		nColorIndex = 1 - nColorIndex;\n"
"		context.fillStyle = \'#777777\'\n"
"		context.fillText(HeaderString, X + W * 0.5, 10);\n"
"		context.fillText(HeaderString, X + W * 0.5, nHeight - 10);\n"
"		f = fNext;\n"
"	}\n"
"	context.textAlign = \'left\';\n"
"	var fScaleX = nWidth / fDetailedRange; \n"
"	context.globalAlpha = 0.5;\n"
"	context.strokeStyle = \'#bbbbbb\';\n"
"	context.beginPath();\n"
"	for(var i = 0; i < S.Frames.length; i++)\n"
"	{\n"
"		var frfr = S.Frames[i];\n"
"		if(frfr.frameend < fDetailedOffset || frfr.framestart > fDetailedOffset + fDetailedRange)\n"
"		{\n"
"			continue;\n"
"		}\n"
"		var X = (frfr.framestart - fDetailedOffset) * fScaleX;\n"
"		if(X >= 0 && X < nWidth)\n"
"		{\n"
"			context.moveTo(X, 0);\n"
"			context.lineTo(X, nHeight);\n"
"		}\n"
"	}\n"
"	context.stroke();\n"
"	context.globalAlpha = 1;\n"
"\n"
"}\n"
"\n"
"function DrawToolTip(StringArray, Canvas, x, y, bSecondary)\n"
"{\n"
"	var context = Canvas.getContext(\'2d\');\n"
"	context.font = Font;\n"
"	var WidthArray = Array(StringArray.length);\n"
"	var nMaxWidth = 0;\n"
"	var nHeight = 0;\n"
"	for(i = 0; i < StringArray.length; i += 2)\n"
"	{\n"
"		var nWidth0 = context.measureText(StringArray[i]).width;\n"
"		var nWidth1 = context.measureText(StringArray[i+1]).width;\n"
"		var nSum = nWidth0 + nWidth1;\n"
"		WidthArray[i] = nWidth0;\n"
"		WidthArray[i+1] = nWidth1;\n"
"		if(nSum > nMaxWidth)\n"
"		{\n"
"			nMaxWidth = nSum;\n"
"		}\n"
"		nHeight += BoxHeight;\n"
"	}\n"
"	nMaxWidth += 15;\n"
"	//bounds check.\n"
"	if(!bSecondary)\n"
"	{\n"
"		var CanvasRect = Canvas.getBoundingClientRect();\n"
"		if(y + nHeight > CanvasRect.height)\n"
"		{\n"
"			y = CanvasRect.height - nHeight;\n"
"			x += 20;\n"
"		}\n"
"		if(x + nMaxWidth > CanvasRect.width)\n"
"		{\n"
"			x = CanvasRect.width - nMaxWidth;\n"
"		}\n"
"	}\n"
"	else\n"
"	{\n"
"		x -= nMaxWidth;\n"
"	}\n"
"	context.fillStyle = \'black\';\n"
"	context.fillRect(x-1, y, nMaxWidth+2, nHeight);\n"
"	context.fillStyle = \'white\';\n"
"\n"
"	var XPos = x;\n"
"	var XPosRight = x + nMaxWidth;\n"
"	var YPos = y + BoxHeight-2;\n"
"	for(i = 0; i < StringArray.length; i += 2)\n"
"	{\n"
"		context.fillText(StringArray[i], XPos, YPos);\n"
"		context.fillText(StringArray[i+1], XPosRight - WidthArray[i+1], YPos);\n"
"		YPos += BoxHeight;\n"
"	}\n"
"	return {\"x\":x, \"y\":y};\n"
"}\n"
"\n"
"function BuildToolTipDetailed(S, nHoverToken, nHoverFrame, HoverTokenOwner, bSecond)\n"
"{\n"
"	var StringArray = [];\n"
"	var groupid = S.TimerInfo[nHoverToken].group;\n"
"	if(nHoverToken > -1)\n"
"	{\n"
"		StringArray.push(\"Timer\");\n"
"		StringArray.push(S.TimerInfo[nHoverToken].name);\n"
"		StringArray.push(\"Group\");\n"
"		StringArray.push(S.GroupInfo[groupid].name);\n"
"	}\n"
"	else\n"
"	{\n"
"		StringArray.push(\"\");\n"
"		StringArray.push(\"\");\n"
"		StringArray.push(\"\");\n"
"		StringArray.push(\"\");	\n"
"	}\n"
"	StringArray.push(\"\");\n"
"	StringArray.push(\"\");\n"
"\n"
"	if(S == HoverTokenOwner)\n"
"	{\n"
"		StringArray.push(\"Time\");\n"
"		StringArray.push((RangeCpu.End-RangeCpu.Begin).toFixed(3));\n"
"	}\n"
"	else\n"
"	{\n"
"		StringArray.push(\"\");\n"
"		StringArray.push(\"\");\n"
"	}\n"
"\n"
"	StringArray.push(\"\");\n"
"	StringArray.push(\"\");\n"
"	StringArray.push(\"Total\");\n"
"	StringArray.push(\"\" + S.TimerInfo[nHoverToken].Sum);\n"
"	StringArray.push(\"Max\");\n"
"	StringArray.push(\"\" + S.TimerInfo[nHoverToken].Max);\n"
"	StringArray.push(\"Average\");\n"
"	StringArray.push(\"\" + S.TimerInfo[nHoverToken].Average);\n"
"	StringArray.push(\"Count\");\n"
"	StringArray.push(\"\" + S.TimerInfo[nHoverToken].CallCount);\n"
"\n"
"	StringArray.push(\"\");\n"
"	StringArray.push(\"\");\n"
"\n"
"	StringArray.push(\"Max/Frame\");\n"
"	StringArray.push(\"\" + S.TimerInfo[nHoverToken].FrameMax);\n"
"\n"
"	StringArray.push(\"Average Time/Frame\");\n"
"	StringArray.push(\"\" + S.TimerInfo[nHoverToken].FrameAverage);\n"
"\n"
"	StringArray.push(\"Average Count/Frame\");\n"
"	StringArray.push(\"\" + S.TimerInfo[nHoverToken].FrameCallAverage);\n"
"\n"
"\n"
"	let Time = fDetailedOffset + fDetailedRange * (DetailedViewMouseX / nWidth);\n"
"	if(bSecond)\n"
"		Time += fDetailedOffsetSecond;\n"
"	let FrameTime = new Object();\n"
"	let Frame = CalculateTimers2(FrameTime, nHoverToken, Time, S);\n"
"	StringArray.push(\"\");\n"
"	StringArray.push(\"\");\n"
"	if(Frame>-1)\n"
"	{\n"
"		StringArray.push(\"Frame \" + Frame);\n"
"		StringArray.push(\"\");\n"
"		StringArray.push(\"Total\");\n"
"		StringArray.push(\"\" + FrameTime.Sum);\n"
"		StringArray.push(\"Count\");\n"
"		StringArray.push(\"\" + FrameTime.CallCount);\n"
"		StringArray.push(\"Average\");\n"
"		StringArray.push(\"\" + FrameTime.Average);\n"
"		StringArray.push(\"Max\");\n"
"		StringArray.push(\"\" + FrameTime.Max);\n"
"	}\n"
"	else\n"
"	{\n"
"		for(var i = 0; i < 10; ++i)\n"
"			StringArray.push(\"\");\n"
"	}\n"
"\n"
"	StringArray.push(\"\");\n"
"	StringArray.push(\"\");\n"
"\n"
"	StringArray.push(\"Detailed Capture\");\n"
"	StringArray.push(\"\");\n"
"	StringArray.push(\"Frames\");\n"
"	StringArray.push(S.Frames.length);\n"
"	StringArray.push(\"Time\");\n"
"	StringArray.push(DetailedTotal(S).toFixed(2) + \"ms\");	\n"
"	return StringArray;\n"
"\n"
"\n"
"\n"
"} \n"
"\n"
"\n"
"function DrawHoverToolTip()\n"
"{\n"
"	ProfileEnter(\"DrawHoverToolTip\");\n"
"	var StringArray = [];\n"
"	let StringArray2;\n"
"	if(nHoverToken != -1)\n"
"	{\n"
"\n"
"		var bShowTimers = Mode == ModeTimers || Mode == ModeTimers_Threads || Mode == ModeTimers_Groups;\n"
"		// this confused alot of people.\n"
"		// if(ToolTipFlip == 1)\n"
"		// {\n"
"		// 	bShowTimers = !bShowTimers;\n"
"		// }\n"
"		if(bShowTimers)\n"
"		{\n"
"			// var StringArray = [];\n"
"			var groupid = S.TimerInfo[nHoverToken].group;\n"
"			StringArray.push(\"Timer\");\n"
"			StringArray.push(S.TimerInfo[nHoverToken].name);\n"
"			StringArray.push(\"Group\");\n"
"			StringArray.push(S.GroupInfo[groupid].name);\n"
"\n"
"			StringArray.push(\"\");\n"
"			StringArray.push(\"\");\n"
"			var Timer = S.TimerInfo[nHoverToken];\n"
"			StringArray.push(\"Average\");\n"
"			StringArray.push(Timer.average);\n"
"			StringArray.push(\"Max\");\n"
"			StringArray.push(Timer.max);\n"
"			StringArray.push(\"Excl Max\");\n"
"			StringArray.push(Timer.exclmax);\n"
"			StringArray.push(\"Excl Average\");\n"
"			StringArray.push(Timer.exclaverage);\n"
"			StringArray.push(\"Call Average\");\n"
"			StringArray.push(Timer.callaverage);\n"
"			StringArray.push(\"Call Count\");\n"
"			StringArray.push(Timer.callcount);\n"
"\n"
"			StringArray.push(\"\");\n"
"			StringArray.push(\"\");\n"
"\n"
"\n"
"			StringArray.push(\"Group\");\n"
"			StringArray.push(S.GroupInfo[groupid].name);\n"
"			StringArray.push(\"Average\");\n"
"			StringArray.push(S.GroupInfo[groupid].average);\n"
"			StringArray.push(\"Max\");\n"
"			StringArray.push(S.GroupInfo[groupid].max);\n"
"\n"
"			StringArray.push(\"\");\n"
"			StringArray.push(\"\");\n"
"\n"
"			StringArray.push(\"Timer Capture\");\n"
"			StringArray.push(\"\");\n"
"			StringArray.push(\"Frames\");\n"
"			StringArray.push(S.AggregateInfo.Frames);\n"
"			StringArray.push(\"Time\");\n"
"			StringArray.push(S.AggregateInfo.Time.toFixed(2) + \"ms\");\n"
"\n"
"\n"
"\n"
"\n"
"		}\n"
"		else\n"
"		{\n"
"			StringArray = BuildToolTipDetailed(S, nHoverToken, nHoverFrame, HoverTokenOwner, 0);\n"
"			let nCompareHoverToken = TimerRemapReverse[nHoverToken];\n"
"			if(nCompareHoverToken > -1)\n"
"			{\n"
"				StringArray2 = BuildToolTipDetailed(S2, nCompareHoverToken, null, HoverTokenOwner, 1);\n"
"			}\n"
"		}\n"
"		if(ToolTipCorner)\n"
"		{\n"
"			let R = DrawToolTip(StringArray, CanvasDetailedView, nWidth, nHeight);\n"
"			if(StringArray2)\n"
"				DrawToolTip(StringArray2, CanvasDetailedView, R.x-15, R.y, 1);\n"
"		}\n"
"		else\n"
"		{\n"
"			let R = DrawToolTip(StringArray, CanvasDetailedView, DetailedViewMouseX, DetailedViewMouseY+20);\n"
"			if(StringArray2)\n"
"				DrawToolTip(StringArray2, CanvasDetailedView, R.x-15, R.y, 1);\n"
"		}\n"
"	}\n"
"	else if(nHoverCSCpu >= 0)\n"
"	{\n"
"		var StringArray = [];\n"
"		StringArray.push(\"Context Switch\");\n"
"		StringArray.push(\"\");\n"
"		StringArray.push(\"\");\n"
"		StringArray.push(\"\");\n"
"		StringArray.push(\"Cpu\");\n"
"		StringArray.push(\"\" + nHoverCSCpu);\n"
"		StringArray.push(\"Begin\");\n"
"		StringArray.push(\"\" + RangeCpu.Begin);\n"
"		StringArray.push(\"End\");\n"
"		StringArray.push(\"\" + RangeCpu.End);\n"
"		if(ToolTipCorner)\n"
"		{\n"
"			DrawToolTip(StringArray, CanvasDetailedView, nWidth, nHeight);\n"
"		}\n"
"		else\n"
"			DrawToolTip(StringArray, CanvasDetailedView, DetailedViewMouseX, DetailedViewMouseY+20);\n"
"	}\n"
"	ProfileLeave();\n"
"}\n"
"\n"
"function FormatMeta(Value, Dec)\n"
"{\n"
"	if(!Value)\n"
"	{\n"
"		Value = \"0\";\n"
"	}\n"
"	else\n"
"	{\n"
"		Value = \'\' + Value.toFixed(Dec);\n"
"	}\n"
"	return Value;\n"
"}\n"
"\n"
"function FilterMatch(FilterArray, value)\n"
"{\n"
"	if(!FilterArray)\n"
"		return true;\n"
"	for(var i = 0; i < FilterArray.length; ++i)\n"
"	{\n"
"		var res = value.search(FilterArray[i]);\n"
"		if(res<0)\n"
"			return false;\n"
"	}\n"
"	return true;\n"
"}\n"
"\n"
"\n"
"function DrawBarView()\n"
"{\n"
"	ProfileEnter(\"DrawBarView\");\n"
"	Invalidate++;\n"
"	nHoverToken = -1;\n"
"	nHoverFrame = -1;\n"
"	var context = CanvasDetailedView.getContext(\'2d\');\n"
"	context.clearRect(0, 0, nWidth, nHeight);\n"
"\n"
"	var Height = BoxHeight;\n"
"	var Width = nWidth;\n"
"	var NameWidth = Math.max(S.TimerNameWidth, S.GroupNameWidth) + 20;\n"
"\n"
"	//clamp offset to prevent scrolling into the void\n"
"	var nTotalRows = 0;\n"
"	for(var groupid in S.GroupInfo)\n"
"	{\n"
"		if(!GroupsDisabled[S.GroupInfo[groupid].name])\n"
"		{\n"
"			nTotalRows += S.GroupInfo[groupid].TimerArray.length + 1;\n"
"		}\n"
"	}\n"
"	var nTotalRowPixels = nTotalRows * Height;\n"
"	var nFrameRows = nHeight - BoxHeight;\n"
"\n"
"	if(nOffsetBarsY + nFrameRows > nTotalRowPixels && nTotalRowPixels > nFrameRows)\n"
"	{\n"
"		nOffsetBarsY = nTotalRowPixels - nFrameRows;\n"
"	}\n"
"	var ColumnsWidthBefore = new Array(ColumnsWidth.length);\n"
"	for(var i = 0; i < ColumnsWidth.length; ++i)\n"
"	{\n"
"		ColumnsWidthBefore[i] = ColumnsWidth[i];\n"
"	}\n"
"\n"
"	var Y = -nOffsetBarsY + BoxHeight;\n"
"	let TimersGroups = Mode == ModeTimers_Threads || Mode == ModeTimers_Groups;\n"
"	if(TimersGroups)\n"
"	{\n"
"		nOffsetBarsX = 0;\n"
"	}\n"
"	var XBase = -nOffsetBarsX;\n"
"	var nColorIndex = 0;\n"
"\n"
"	context.fillStyle = \'white\';\n"
"	context.font = Font;\n"
"	var bMouseIn = 0;\n"
"	var RcpReferenceTime = 1.0 / ReferenceTime;\n"
"	var CountWidth = 12 * FontWidth;\n"
"	var nMetaLen = S.TimerInfo[0].meta.length;\n"
"	var nMetaCharacters = 10;\n"
"	var InnerBoxHeight = BoxHeight-2;\n"
"	var TimerLen = 8; //todo: fix max digits.\n"
"	var TimerWidth = TimerLen * FontWidth;\n"
"	var nWidthBars = nBarsWidth+2;\n"
"	var nWidthMs = TimerWidth+2+10;\n"
"	var R = 0;\n"
"	var AllColumns = TimersGroups != 0;\n"
"\n"
"\n"
"\n"
"	for(var i = 0; i < nMetaLen; ++i)\n"
"	{\n"
"		if(nMetaCharacters < MetaNames[i].length)\n"
"			nMetaCharacters = MetaNames[i].length;\n"
"	}\n"
"	var nWidthMeta = nMetaCharacters * FontWidth + 6;\n"
"	function HeaderMouseHandle(XBegin, X, Header)\n"
"	{\n"
"		var bMouseIn = DetailedViewMouseY >= 0 && DetailedViewMouseY < BoxHeight && DetailedViewMouseX < X && DetailedViewMouseX > XBegin;\n"
"		if(bMouseIn)\n"
"		{\n"
"			SortColumnMouseOverNext = Header;\n"
"		}\n"
"	}\n"
"	function HeaderString(Header)\n"
"	{\n"
"		if(Header == SortColumnMouseOver)\n"
"		{\n"
"			return Header + (SortColumnOrderFlip ? \'<\' : \'>\');\n"
"		}\n"
"		else\n"
"		{\n"
"			return Header;\n"
"		}\n"
"\n"
"	}\n"
"	function DrawHeaderSplit(Header)\n"
"	{\n"
"		if(ColumnsEnabled[R]||AllColumns)\n"
"		{\n"
"			context.fillStyle = \'white\';\n"
"			context.fillText(HeaderString(Header), X, Height-FontAscent);\n"
"			var XBegin = X;\n"
"			X += nWidthBars;\n"
"			context.fillStyle = nBackColorOffset;\n"
"			X += ColumnsWidth[R];\n"
"			if(X >= NameWidth)\n"
"			{\n"
"				context.fillRect(X-3, 0, 1, nHeight);\n"
"			}\n"
"			HeaderMouseHandle(XBegin, X, Header);\n"
"		}\n"
"		R++;\n"
"	}\n"
"	function DrawHeaderSplitSingle(Header, Col)\n"
"	{\n"
"		if(ColumnsEnabled[Col]||AllColumns)\n"
"		{\n"
"			context.fillStyle = \'white\';\n"
"			context.fillText(HeaderString(Header), X, Height-FontAscent);\n"
"			var XBegin = X;\n"
"			X += ColumnsWidth[R];\n"
"			context.fillStyle = nBackColorOffset;\n"
"			if(X >= NameWidth)\n"
"			{\n"
"				context.fillRect(X-3, 0, 1, nHeight);\n"
"			}\n"
"			HeaderMouseHandle(XBegin, X, Header);\n"
"		}\n"
"		R++;\n"
"	}\n"
"	function DrawHeaderSplitLeftRight(HeaderLeft, HeaderRight, Width)\n"
"	{\n"
"		context.textAlign = \'left\';\n"
"		context.fillStyle = \'white\';\n"
"		context.fillText(HeaderLeft, X, Height-FontAscent);\n"
"		var XBegin = X;\n"
"		X += Width;\n"
"		context.textAlign = \'right\';\n"
"		context.fillText(HeaderRight, X-5, Height-FontAscent);\n"
"		context.textAlign = \'left\';\n"
"		context.fillStyle = nBackColorOffset;\n"
"		if(X >= NameWidth)\n"
"		{\n"
"			context.fillRect(X-3, 0, 1, nHeight);\n"
"		}\n"
"		HeaderMouseHandle(XBegin, X, HeaderLeft);\n"
"	}\n"
"	function DrawTimer(Value, Color)\n"
"	{\n"
"		if(ColumnsEnabled[R]||AllColumns)\n"
"		{\n"
"			var Prc = Value * RcpReferenceTime;\n"
"			var YText = Y+Height-FontAscent;\n"
"			if(Prc > 1)\n"
"			{\n"
"				Prc = 1;\n"
"			}\n"
"			context.textAlign = \'left\';\n"
"			context.fillStyle = Color;\n"
"			context.fillRect(X+1, Y+1, Prc * nBarsWidth, InnerBoxHeight);\n"
"			var TimerText = Value.toFixed(2);\n"
"			var W = context.measureText(TimerText).width + FontWidth;\n"
"			ColumnsWidth[R] = Math.max(W, ColumnsWidth[R]);\n"
"			X += nWidthBars;\n"
"			X += ColumnsWidth[R];\n"
"			context.fillStyle = \'white\';\n"
"			context.textAlign = \'right\';\n"
"			context.fillText(TimerText, X - FontWidth, YText);\n"
"			context.textAlign = \'left\';\n"
"		}\n"
"		R++;\n"
"	}\n"
"	function DrawCount(Str)\n"
"	{\n"
"		if(ColumnsEnabled[R]||AllColumns)\n"
"		{\n"
"			X += ColumnsWidth[R];\n"
"			context.fillStyle = \'white\';\n"
"			context.textAlign = \'right\';\n"
"			var YText = Y+Height-FontAscent;\n"
"			context.fillText(Str, X-6, YText);\n"
"			var W = Math.max(80, context.measureText(Str).width + FontWidth * 2);\n"
"			ColumnsWidth[R] = Math.max(W, ColumnsWidth[R]);\n"
"		}\n"
"		R++;\n"
"	\n"
"	}\n"
"\n"
"\n"
"	function DrawMeta(Value, Width, Dec, YText, Col)\n"
"	{\n"
"		if(ColumnsEnabled[Col]||AllColumns)\n"
"		{\n"
"			Value = FormatMeta(Value, Dec);\n"
"			X += (FontWidth*Width);\n"
"			ColumnsWidth[R] = FontWidth*Width;\n"
"			context.textAlign = \'right\';\n"
"			context.fillText(Value, X-FontWidth, YText);\n"
"			context.textAlign = \'left\';\n"
"		}\n"
"		R++;\n"
"	}\n"
"\n"
"\n"
"\n"
"	function DrawTimerRow(timerid, showgroup)\n"
"	{\n"
"		R = 0;\n"
"		var Timer = S.TimerInfo[timerid];\n"
"		var Average = Timer.average;\n"
"		var Max = Timer.max;\n"
"		var Min = Timer.min;\n"
"		var Spike = Timer.spike;\n"
"		var ExclusiveMax = Timer.exclmax;\n"
"		var ExclusiveAverage = Timer.exclaverage;\n"
"		var CallAverage = Timer.callaverage;\n"
"		var CallCount = Timer.callcount;\n"
"		var YText = Y+Height-FontAscent;\n"
"		var Color = g_Colors[Timer.cid];\n"
"		X = NameWidth + XBase;\n"
"\n"
"		nColorIndex = 1-nColorIndex;\n"
"		bMouseIn = DetailedViewMouseY >= Y && DetailedViewMouseY < Y + BoxHeight;\n"
"		if(bMouseIn)\n"
"		{\n"
"			nHoverToken = timerid;\n"
"		}\n"
"		context.fillStyle = bMouseIn ? nBackColorOffset : nBackColors[nColorIndex];\n"
"		context.fillRect(0, Y, Width, FontHeight+2);\n"
"\n"
"		DrawTimer(Average,  Color);\n"
"		DrawTimer(Max, Color);\n"
"		DrawTimer(Timer.total, Color);\n"
"		DrawTimer(Min, Color);\n"
"		DrawCount(Spike.toFixed(2) + \'%\');\n"
"		DrawTimer(CallAverage, Color);\n"
"		DrawCount(CallCount);\n"
"		DrawTimer(ExclusiveAverage, Color);\n"
"		DrawTimer(ExclusiveMax, Color);\n"
"\n"
"		context.fillStyle = \'white\';\n"
"		var Col = R;\n"
"		for(var j = 0; j < nMetaLen; ++j)\n"
"		{\n"
"		    DrawMeta(Timer.meta[j], MetaLengths[j], 0, YText, Col + j);\n"
"		    DrawMeta(Timer.metaavg[j], MetaLengthsAvg[j], 2, YText, Col + j);\n"
"		    DrawMeta(Timer.metamax[j], MetaLengthsMax[j], 0, YText, Col + j);\n"
"		}\n"
"		context.fillStyle = bMouseIn ? nBackColorOffset : nBackColors[nColorIndex];\n"
"		context.fillRect(0, Y, NameWidth, Height);\n"
"		context.textAlign = \'right\';\n"
"		context.fillStyle = Color;\n"
"		context.fillText(Timer.name, NameWidth - 5, YText);\n"
"		context.textAlign = \'left\';\n"
"		if(showgroup)\n"
"		{\n"
"			context.fillStyle = \'white\';\n"
"			context.fillText(S.GroupInfo[Timer.group].name, 1, YText);\n"
"		}\n"
"	}\n"
"	if(SortColumn && Mode == ModeTimers)\n"
"	{\n"
"		var OrderArray = new Array(S.TimerInfo.length);\n"
"		var KeyArray = new Array(S.TimerInfo.length);\n"
"		for(var idx in GroupOrder)\n"
"		{\n"
"			var Group = S.GroupInfo[idx];\n"
"			if((!GroupsDisabled[Group.name]) && FilterMatch(FilterGroup, Group.name))\n"
"			{\n"
"				var TimerArray = Group.TimerArray;\n"
"				for(var timerindex in TimerArray)\n"
"				{\n"
"					var timerid = TimerArray[timerindex];\n"
"					if(FilterMatch(FilterTimer, S.TimerInfo[timerid].name))\n"
"					{\n"
"						OrderArray.push(timerid);\n"
"						NameWidth = Math.max(S.TimerInfo[timerid].wtotal, NameWidth);\n"
"					}\n"
"				}\n"
"			}\n"
"		}\n"
"		var KeyFunc = null;\n"
"		switch(SortColumn)\n"
"		{\n"
"			case 1: KeyFunc = function (a) { return S.TimerInfo[a].average; }; break;\n"
"			case 2: KeyFunc = function (a) { return S.TimerInfo[a].max; }; break;\n"
"			case 3: KeyFunc = function (a) { return S.TimerInfo[a].total; }; break;\n"
"			case 4: KeyFunc = function (a) { return S.TimerInfo[a].min; }; break;\n"
"			case 5: KeyFunc = function (a) { return S.TimerInfo[a].spike; }; break;\n"
"			case 6: KeyFunc = function (a) { return S.TimerInfo[a].callaverage; }; break;\n"
"			case 7: KeyFunc = function (a) { return S.TimerInfo[a].callcount; }; break;\n"
"			case 8: KeyFunc = function (a) { return S.TimerInfo[a].exclaverage; }; break;\n"
"			case 9: KeyFunc = function (a) { return S.TimerInfo[a].exclmax; }; break;\n"
"		}\n"
"\n"
"		var Flip = SortColumnOrderFlip == 1 ? -1 : 1;\n"
"		OrderArray.sort(function(a,b) { return Flip * (KeyFunc(b) - KeyFunc(a)); } );\n"
"\n"
"		for(var i in OrderArray)\n"
"		{\n"
"			DrawTimerRow(OrderArray[i], 1);\n"
"			Y += Height;\n"
"		}			\n"
"\n"
"	}\n"
"	else if(Mode == ModeTimers_Threads)\n"
"	{\n"
"		for(var i = 0; i < S.ThreadNames.length; ++i)\n"
"		{\n"
"			if((ThreadsActive[S.ThreadNames[i]]) && FilterMatch(FilterTimer, S.ThreadNames[i]))\n"
"			{\n"
"				var X = 0;\n"
"				var YText = Y+Height-FontAscent;\n"
"				bMouseIn = DetailedViewMouseY >= Y && DetailedViewMouseY < Y + BoxHeight;\n"
"				nColorIndex = 1-nColorIndex;\n"
"				context.fillStyle = bMouseIn ? nBackColorOffset : nBackColors[nColorIndex];\n"
"				context.fillRect(0, Y, Width, FontHeight+2);\n"
"				var ThreadColor = CSwitchColors[i % CSwitchColors.length];\n"
"				context.fillStyle = ThreadColor;\n"
"				context.fillText(S.ThreadNames[i], 1, YText);\n"
"				context.textAlign = \'left\';\n"
"				Y += Height;\n"
"				for(var idx in GroupOrder)\n"
"				{\n"
"					R = 0;\n"
"					var groupid = GroupOrder[idx];\n"
"					var Group = S.GroupInfo[groupid];\n"
"					var PerThreadTimer = S.ThreadGroupTimeArray[i][groupid];\n"
"					var PerThreadTimerTotal = S.ThreadGroupTimeTotalArray[i][groupid];\n"
"					if((PerThreadTimer > 0.0001|| PerThreadTimerTotal>0.1) && (!GroupsDisabled[Group.name]) && FilterMatch(FilterGroup, Group.name))\n"
"					{\n"
"						var GColor = GroupColors ? g_Colors[S.GroupInfo[groupid].cid] : \'white\';\n"
"						var X = 0;\n"
"						nColorIndex = 1-nColorIndex;\n"
"						bMouseIn = DetailedViewMouseY >= Y && DetailedViewMouseY < Y + BoxHeight;\n"
"						context.fillStyle = bMouseIn ? nBackColorOffset : nBackColors[nColorIndex];\n"
"						context.fillRect(0, Y, Width, nHeight);\n"
"						context.fillStyle = GColor;\n"
"						context.textAlign = \'right\';\n"
"						context.fillText(Group.name, NameWidth - 5, Y+Height-FontAscent);\n"
"						context.textAlign = \'left\';\n"
"						X += NameWidth;\n"
"						DrawTimer(PerThreadTimer, GColor);\n"
"						DrawTimer(PerThreadTimerTotal, GColor);\n"
"						Y += Height;\n"
"					}\n"
"				}\n"
"			}\n"
"		}\n"
"	}\n"
"	else\n"
"	{\n"
"		for(var idx in GroupOrder)\n"
"		{\n"
"			var groupid = GroupOrder[idx];\n"
"			var Group = S.GroupInfo[groupid];\n"
"			var GColor = GroupColors ? g_Colors[S.GroupInfo[groupid].cid] : \'white\';\n"
"			if((!GroupsDisabled[Group.name]) && FilterMatch(FilterGroup, Group.name))\n"
"			{\n"
"				R = 0;\n"
"				var TimerArray = Group.TimerArray;\n"
"				var X = XBase;\n"
"				nColorIndex = 1-nColorIndex;\n"
"				bMouseIn = DetailedViewMouseY >= Y && DetailedViewMouseY < Y + BoxHeight;\n"
"				context.fillStyle = bMouseIn ? nBackColorOffset : nBackColors[nColorIndex];\n"
"				context.fillRect(0, Y, Width, FontHeight+2);\n"
"				context.fillStyle = GColor;\n"
"				context.fillText(Group.name, 1, Y+Height-FontAscent);\n"
"				X += NameWidth;\n"
"				DrawTimer(Group.average, GColor);\n"
"				DrawTimer(Group.max, GColor);\n"
"				DrawTimer(Group.total, GColor);\n"
"\n"
"				context.fillStyle = bMouseIn ? nBackColorOffset : nBackColors[nColorIndex];\n"
"				context.fillRect(0, Y, NameWidth, FontHeight+2);\n"
"				context.fillStyle = GColor;\n"
"				context.fillText(Group.name, 1, Y+Height-FontAscent);\n"
"\n"
"				Y += Height;\n"
"				let TimersGroups = Mode == ModeTimers_Threads || Mode == ModeTimers_Groups;\n"
"				if(TimersGroups)\n"
"				{\n"
"					for(var i = 0; i < S.ThreadNames.length; ++i)\n"
"					{\n"
"						R = 0;\n"
"						var PerThreadTimer = S.ThreadGroupTimeArray[i][groupid];\n"
"						var PerThreadTimerTotal = S.ThreadGroupTimeTotalArray[i][groupid];\n"
"						if((PerThreadTimer > 0.0001|| PerThreadTimerTotal>0.1) && (ThreadsActive[S.ThreadNames[i]]) && FilterMatch(FilterTimer, S.ThreadNames[i]))\n"
"						{\n"
"							var YText = Y+Height-FontAscent;\n"
"							bMouseIn = DetailedViewMouseY >= Y && DetailedViewMouseY < Y + BoxHeight;\n"
"							nColorIndex = 1-nColorIndex;\n"
"							context.fillStyle = bMouseIn ? nBackColorOffset : nBackColors[nColorIndex];\n"
"							context.fillRect(0, Y, Width, FontHeight+2);\n"
"							var ThreadColor = CSwitchColors[i % CSwitchColors.length];\n"
"							context.fillStyle = ThreadColor;\n"
"							context.textAlign = \'right\';\n"
"							context.fillText(S.ThreadNames[i], NameWidth - 5, YText);\n"
"							context.textAlign = \'left\';\n"
"							X = NameWidth;\n"
"							DrawTimer(PerThreadTimer, ThreadColor);\n"
"							X += nWidthBars + ColumnsWidth[R++];	\n"
"							DrawTimer(PerThreadTimerTotal, ThreadColor);\n"
"							Y += Height;\n"
"						}\n"
"					}\n"
"				}\n"
"				else\n"
"				{\n"
"					for(var timerindex in TimerArray)\n"
"					{\n"
"						var timerid = TimerArray[timerindex];\n"
"						if(FilterMatch(FilterTimer, S.TimerInfo[timerid].name))\n"
"						{\n"
"							DrawTimerRow(timerid, 0);\n"
"							Y += Height;\n"
"						}\n"
"					}			\n"
"				}\n"
"			}\n"
"		}\n"
"	}\n"
"	X = 0;\n"
"	R = 0;\n"
"	context.fillStyle = nBackColorOffset;\n"
"	context.fillRect(0, 0, Width, Height);\n"
"	context.fillStyle = \'white\';\n"
"	SortColumnMouseOverNext = null;\n"
"\n"
"	if(Mode == ModeTimers_Threads || Mode == ModeTimers_Groups)\n"
"	{\n"
"		if(Mode == ModeTimers_Threads)\n"
"		{\n"
"			DrawHeaderSplitLeftRight(StrThread, StrGroup, NameWidth);\n"
"			DrawHeaderSplit(StrAverage);\n"
"			DrawHeaderSplit(StrTotal);\n"
"		}\n"
"		else\n"
"		{\n"
"			DrawHeaderSplitLeftRight(StrGroup, StrThread, NameWidth);\n"
"			DrawHeaderSplit(StrAverage);\n"
"			DrawHeaderSplit(StrMax);\n"
"			DrawHeaderSplit(StrTotal);\n"
"		}\n"
"	}\n"
"	else\n"
"	{\n"
"		X = NameWidth + XBase;\n"
"		DrawHeaderSplit(StrAverage);\n"
"		DrawHeaderSplit(StrMax);\n"
"		DrawHeaderSplit(StrTotal);\n"
"		DrawHeaderSplit(StrMin);\n"
"		DrawHeaderSplitSingle(StrSpike, R);\n"
"		DrawHeaderSplit(StrCallAverage);\n"
"		DrawHeaderSplitSingle(StrCount, R);\n"
"		DrawHeaderSplit(StrExclAverage);\n"
"		DrawHeaderSplit(StrExclMax);\n"
"		var Col = R;\n"
"		for(var i = 0; i < nMetaLen; ++i)\n"
"		{\n"
"			DrawHeaderSplitSingle(MetaNames[i], Col + i);\n"
"			DrawHeaderSplitSingle(MetaNames[i] + \" Avg\", Col + i);\n"
"			DrawHeaderSplitSingle(MetaNames[i] + \" Max\", Col + i);\n"
"		}\n"
"		X = 0;\n"
"		context.fillStyle = nBackColorOffset;\n"
"		context.fillRect(0, 0, NameWidth, Height);\n"
"		context.fillStyle = \'white\';\n"
"	\n"
"		DrawHeaderSplitLeftRight(StrGroup, StrTimer, NameWidth);\n"
"	\n"
"	}\n"
"\n"
"	var ColumnsChanged = false;\n"
"	for(var i = 0; i < ColumnsWidth.length; ++i)\n"
"	{\n"
"		if(ColumnsWidthBefore[i] != ColumnsWidth[i])\n"
"		{\n"
"			ColumnsChanged = true;\n"
"		}\n"
"	}\n"
"	if(ColumnsChanged)\n"
"	{\n"
"		Invalidate = 0;\n"
"	}\n"
"\n"
"\n"
"\n"
"\n"
"	ProfileLeave();\n"
"}\n"
"\n"
"var CounterNameWidth = 100;\n"
"var CounterValueWidth = 100;\n"
"var CounterLimitWidth = 100;\n"
"\n"
"var FormatCounterDefault = 0;\n"
"var FormatCounterBytes = 1;\n"
"var FormatCounterBytesExt = [ \"b\",\"kb\",\"mb\",\"gb\",\"tb\",\"pb\", \"eb\",\"zb\", \"yb\" ];\n"
"\n"
"function ShiftRight10(v)\n"
"{\n"
"	if(v > 1024)\n"
"	{\n"
"		return v / 1024.0;\n"
"	}\n"
"	else\n"
"	{\n"
"		return v >> 10;\n"
"	}\n"
"}\n"
"\n"
"\n"
"function FormatCounter(Format, Counter)\n"
"{\n"
"	if(!Counter)\n"
"	{\n"
"		return \'0\';\n"
"	}\n"
"	var Negative = 0;\n"
"	if(Counter < 0)\n"
"	{\n"
"		Counter = -Counter;\n"
"		Negative = 1;\n"
"		if(Counter < 0) // handle INT_MIN\n"
"		{\n"
"			Counter = -(Counter+1);\n"
"			if(Counter < 0)\n"
"			{\n"
"				return \'?\';\n"
"			}\n"
"		}\n"
"	}\n"
"	var str = Negative ? \'-\' :\'\' ;\n"
"	if(Format == FormatCounterDefault)\n"
"	{\n"
"		var Seperate = 0;\n"
"		var result = \'\';\n"
"		while (Counter)\n"
"		{\n"
"			if (Seperate)\n"
"			{\n"
"				result += \'.\';\n"
"			}\n"
"			Seperate = 1;\n"
"			for (var i = 0; Counter && i < 3; ++i)\n"
"			{\n"
"				var Digit = Math.floor(Counter % 10);\n"
"				Counter = Math.floor(Counter / 10);\n"
"				result += \'\' + Digit;\n"
"			}\n"
"		}\n"
"\n"
"		for(var i = 0; i < result.length; ++i)\n"
"		{\n"
"			str += result[result.length-1-i];\n"
"		}\n"
"		return str;\n"
"	}\n"
"	else if(Format == FormatCounterBytes)\n"
"	{\n"
"		var Shift = 0;\n"
"		var Divisor = 1;\n"
"		var CountShifted = ShiftRight10(Counter);\n"
"		while(CountShifted)\n"
"		{\n"
"			Divisor <<= 10;\n"
"			CountShifted = ShiftRight10(CountShifted);\n"
"			Shift++;\n"
"		}\n"
"		if(Shift)\n"
"		{\n"
"			return str + (Counter / Divisor).toFixed(2) + \'\' + FormatCounterBytesExt[Shift];\n"
"		}\n"
"		else\n"
"		{\n"
"			return str + Counter.toFixed(2) + \'\' + FormatCounterBytesExt[0];\n"
"		}\n"
"	}\n"
"	return \'?\'\n"
"}\n"
"function DrawCounterView()\n"
"{\n"
"	ProfileEnter(\"DrawCounterView\");\n"
"	Invalidate++;\n"
"	nHoverToken = -1;\n"
"	nHoverFrame = -1;\n"
"	var context = CanvasDetailedView.getContext(\'2d\');\n"
"	context.clearRect(0, 0, nWidth, nHeight);\n"
"\n"
"	var Height = BoxHeight;\n"
"	var Width = nWidth;\n"
"	//clamp offset to prevent scrolling into the void\n"
"	var nTotalRows = S.CounterInfo.length;\n"
"	var nTotalRowPixels = nTotalRows * Height;\n"
"	var nFrameRows = nHeight - BoxHeight;\n"
"	if(nOffsetCountersY + nFrameRows > nTotalRowPixels && nTotalRowPixels > nFrameRows)\n"
"	{\n"
"		nOffsetCountersY = nTotalRowPixels - nFrameRows;\n"
"	}\n"
"\n"
"	var CounterNameWidthTemp = 10;\n"
"	var CounterValueWidthTemp = 10;\n"
"	var CounterLimitWidthTemp = 10;\n"
"\n"
"	var CounterWidth = 150;\n"
"	var Y = -nOffsetCountersY + BoxHeight;\n"
"	var X = 0;\n"
"	var nColorIndex = 0;\n"
"	context.fillStyle = \'white\';\n"
"	context.font = Font;\n"
"	var bMouseIn = 0;\n"
"	function DrawHeaderSplitSingle(Header, Width)\n"
"	{\n"
"		context.fillStyle = \'white\';\n"
"		context.fillText(Header, X, Height-FontAscent);\n"
"		X += Width;\n"
"		context.fillStyle = nBackColorOffset;\n"
"		context.fillRect(X-3, 0, 1, nHeight);\n"
"	}\n"
"	function DrawHeaderSplitSingleRight(Header, Width)\n"
"	{\n"
"		X += Width;\n"
"		context.fillStyle = \'white\';\n"
"		context.textAlign  = \'right\';\n"
"		context.fillText(Header, X - FontWidth, Height-FontAscent);\n"
"		context.fillStyle = nBackColorOffset;\n"
"		context.fillRect(X, 0, 1, nHeight);\n"
"		context.textAlign  = \'left\';\n"
"	}\n"
"	var TimerLen = 6;\n"
"	var TimerWidth = TimerLen * FontWidth;\n"
"	nHoverCounter = -1;\n"
"	function CounterIndent(Level)\n"
"	{\n"
"		return Level * 4 * FontWidth;\n"
"	}\n"
"	function Max(a, b)\n"
"	{\n"
"		return a > b ? a : b;\n"
"	}\n"
"\n"
"	function DrawCounterRecursive(Index)\n"
"	{\n"
"		var Counter = S.CounterInfo[Index];\n"
"		var Indent = CounterIndent(Counter.level);\n"
"		CounterNameWidthTemp = Max(CounterNameWidthTemp, Counter.name.length+1 + Indent / (FontWidth+1));\n"
"		CounterValueWidthTemp = Max(CounterValueWidthTemp, Counter.formatted.length);\n"
"		CounterLimitWidthTemp = Max(CounterLimitWidthTemp, Counter.formattedlimit.length);\n"
"\n"
"		var X = 0;\n"
"		nColorIndex = 1-nColorIndex;\n"
"		var HeightExpanded = Counter.Expanded ? Height * 5 : Height\n"
"\n"
"		bMouseIn = DetailedViewMouseY >= Y && DetailedViewMouseY < Y + HeightExpanded;\n"
"		if(bMouseIn)\n"
"		{\n"
"			nHoverCounter = Index;\n"
"		}\n"
"		var bgcolor = bMouseIn ? nBackColorOffset : nBackColors[nColorIndex];\n"
"		context.fillStyle = bgcolor;\n"
"		context.fillRect(0, Y, Width, HeightExpanded);\n"
"		context.fillStyle = \'white\';\n"
"		var c = Counter.closed ? \'*\' : \' \';\n"
"		context.fillText(c + Counter.name, Indent, Y+Height-FontAscent);\n"
"		X += CounterNameWidth;\n"
"		X += CounterValueWidth - FontWidth;\n"
"		context.textAlign = \'right\';\n"
"		context.fillText(Counter.formatted, X, Y+Height-FontAscent);\n"
"		context.textAlign = \'left\';\n"
"		X += FontWidth * 4;\n"
"		var Y0 = Y + 1;\n"
"		if(Counter.limit != 0)\n"
"		{\n"
"			context.fillText(Counter.formattedlimit, X, Y+Height-FontAscent);\n"
"			X += CounterLimitWidth;\n"
"			var X0 = X + 1;\n"
"			context.fillStyle = \'white\';\n"
"			context.fillRect(X0, Y0, Counter.boxprc * (CounterWidth-2), Height-2);\n"
"			context.fillStyle = bgcolor;\n"
"			context.fillRect(X0+1, Y0+1, Counter.boxprc * (CounterWidth-4), Height-4);\n"
"			context.fillStyle = \'cyan\';\n"
"			context.fillRect(X0+1, Y0+1, Counter.counterprc * (CounterWidth-4), Height-4);\n"
"			X += CounterWidth + 10;\n"
"		}\n"
"		else\n"
"		{\n"
"			X += CounterLimitWidth;\n"
"			X += CounterWidth + 10;\n"
"		}\n"
"		var CounterHistory = Counter.counterhistory;\n"
"		if(CounterHistory)\n"
"		{\n"
"			var Prc = CounterHistory.prc;\n"
"\n"
"			context.fillStyle = \'cyan\';\n"
"			context.strokeStyle = \'cyan\';\n"
"			context.globalAlpha = 0.5;\n"
"			context.beginPath();\n"
"			var x = X;\n"
"			var YBase = Y0 + HeightExpanded-1;\n"
"			var YOffset = -(HeightExpanded-2);\n"
"\n"
"			context.moveTo(X, Y0);\n"
"			for(var i = 0; i < Prc.length; ++i)\n"
"			{\n"
"				context.moveTo(x, YBase);\n"
"				context.lineTo(x, YBase + Prc[i] * YOffset);\n"
"				\n"
"				x += 1;\n"
"			}\n"
"			context.stroke();\n"
"\n"
"			x = X;\n"
"			context.globalAlpha = 1.0;\n"
"			context.beginPath();\n"
"			context.moveTo(X, YBase);\n"
"\n"
"			for(var i = 0; i < Prc.length; ++i)\n"
"			{\n"
"				context.lineTo(x, YBase + Prc[i] * YOffset);\n"
"				x += 1;\n"
"			}\n"
"			context.stroke();\n"
"			if(bMouseIn)\n"
"			{\n"
"				var MouseGraphX = Math.floor(DetailedViewMouseX - X);\n"
"				if(MouseGraphX >= 0 && MouseGraphX < CounterHistory.history.length)\n"
"				{\n"
"					context.fillStyle = \'white\';\n"
"					var Formatted = FormatCounter(Counter.format, CounterHistory.history[MouseGraphX]);\n"
"					context.fillText(Formatted, X, Y+Height-FontAscent);\n"
"				}\n"
"				context.strokeStyle = \'orange\';\n"
"				context.beginPath();\n"
"				var CrossX = X + MouseGraphX;\n"
"				var CrossY = YBase + Prc[MouseGraphX] * YOffset;\n"
"				context.moveTo(CrossX-2, CrossY-2);\n"
"				context.lineTo(CrossX+2, CrossY+2);\n"
"				context.moveTo(CrossX+2, CrossY-2);\n"
"				context.lineTo(CrossX-2, CrossY+2);\n"
"				context.stroke();\n"
"\n"
"			}\n"
"			X += Prc.length + 5;\n"
"			context.fillStyle = \'white\';\n"
"			context.fillText( FormatCounter(Counter.format, Counter.minvalue), X, Y + Height - FontAscent);\n"
"			X += CounterWidth + 5;\n"
"			context.fillText( FormatCounter(Counter.format, Counter.maxvalue), X, Y + Height - FontAscent);\n"
"			X += CounterWidth + 5;\n"
"		}\n"
"\n"
"		Y += HeightExpanded;\n"
"\n"
"		if(!Counter.closed)\n"
"		{\n"
"			var ChildIndex = Counter.firstchild;\n"
"			while(ChildIndex != -1)\n"
"			{\n"
"				DrawCounterRecursive(ChildIndex);\n"
"				ChildIndex = S.CounterInfo[ChildIndex].sibling;\n"
"			}\n"
"		}\n"
"	}\n"
"\n"
"	for(var i = 0; i < S.CounterInfo.length; ++i)\n"
"	{\n"
"		if(S.CounterInfo[i].parent == -1)\n"
"		{\n"
"			DrawCounterRecursive(i);\n"
"		}\n"
"	}\n"
"\n"
"	X = 0;\n"
"	context.fillStyle = nBackColorOffset;\n"
"	context.fillRect(0, 0, Width, Height);\n"
"	context.fillStyle = \'white\';\n"
"	DrawHeaderSplitSingle(\'Name\', CounterNameWidth);\n"
"	DrawHeaderSplitSingleRight(\'Value\', CounterValueWidth + (FontWidth+1));\n"
"	DrawHeaderSplitSingle(\'Limit\', CounterLimitWidth + CounterWidth + 3 * (FontWidth+1));\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"	var CounterNameWidthNew = CounterNameWidthTemp * (FontWidth+1);\n"
"	var CounterValueWidthNew = CounterValueWidthTemp * (FontWidth+1);\n"
"	var CounterLimitWidthNew = CounterLimitWidthTemp * (FontWidth+1);\n"
"	if(CounterNameWidthNew != CounterNameWidth || CounterValueWidthNew != CounterValueWidth || CounterLimitWidthNew != CounterLimitWidth)\n"
"	{\n"
"		// console.log(\'requesting redraw 0\' + CounterNameWidthNew + \'= \' + CounterNameWidth );\n"
"		// console.log(\'requesting redraw 1\' + CounterValueWidthNew + \'= \' + CounterValueWidth );\n"
"		// console.log(\'requesting redraw 2\' + CounterLimitWidthNew + \'= \' + CounterLimitWidth );\n"
"		CounterNameWidth = CounterNameWidthNew;\n"
"		CounterValueWidth = CounterValueWidthNew;\n"
"		CounterLimitWidth = CounterLimitWidthNew;\n"
"		Invalidate = 0;\n"
"	}\n"
"\n"
"	ProfileLeave();\n"
"}\n"
"\n"
"\n"
"//preprocess context switch data to contain array per thread\n"
"function PreprocessContextSwitchCacheItem(ThreadId)\n"
"{\n"
"	var CSObject = S.CSwitchCache[ThreadId];\n"
"	if(ThreadId > 0 && !CSObject)\n"
"	{\n"
"		CSArrayIn = new Array();\n"
"		CSArrayOut = new Array();\n"
"		CSArrayCpu = new Array();\n"
"		var nCount = S.CSwitchTime.length;\n"
"		var j = 0;\n"
"		var TimeIn = -1.0;\n"
"		for(var i = 0; i < nCount; ++i)\n"
"		{	\n"
"			var ThreadIn = S.CSwitchThreadInOutCpu[j];\n"
"			var ThreadOut = S.CSwitchThreadInOutCpu[j+1];\n"
"			var Cpu = S.CSwitchThreadInOutCpu[j+2];\n"
"			if(TimeIn < 0)\n"
"			{\n"
"				if(ThreadIn == ThreadId)\n"
"				{\n"
"					TimeIn = S.CSwitchTime[i];\n"
"				}\n"
"			}\n"
"			else\n"
"			{\n"
"				if(ThreadOut == ThreadId)\n"
"				{\n"
"					var TimeOut = S.CSwitchTime[i];\n"
"					CSArrayIn.push(TimeIn);\n"
"					CSArrayOut.push(TimeOut);\n"
"					CSArrayCpu.push(Cpu);\n"
"					TimeIn = -1;\n"
"				}\n"
"			}\n"
"			j += 3;\n"
"		}\n"
"		CSObject = new Object();\n"
"		CSObject.Size = CSArrayIn.length;\n"
"		CSObject.In = CSArrayIn;\n"
"		CSObject.Out = CSArrayOut;\n"
"		CSObject.Cpu = CSArrayCpu;\n"
"		S.CSwitchCache[ThreadId] = CSObject;\n"
"	}\n"
"\n"
"}\n"
"function PreprocessContextSwitchCache()\n"
"{\n"
"	ProfileEnter(\"PreprocessContextSwitchCache\");\n"
"	var AllThreads = {};\n"
"	var nCount = S.CSwitchTime.length;\n"
"	for(var i = 0; i < nCount; ++i)\n"
"	{	\n"
"		var nThreadIn = S.CSwitchThreadInOutCpu[i];\n"
"		if(!AllThreads[nThreadIn])\n"
"		{\n"
"		    AllThreads[nThreadIn] = \'\' + nThreadIn;\n"
"		    var FoundThread = false;\n"
"		    for(var i = 0; i < S.ThreadIds.length; ++i)\n"
"		    {\n"
"		        if(S.ThreadIds[i] == nThreadIn)\n"
"		        {\n"
"		            FoundThread = true;\n"
"		        }\n"
"		    }\n"
"		    if(!FoundThread)\n"
"		    {\n"
"		        S.CSwitchOnlyThreads.push(nThreadIn);\n"
"		    }\n"
"		}\n"
"	}\n"
"	for(var i = 0; i < S.CSwitchOnlyThreads.length; ++i)\n"
"	{\n"
"		PreprocessContextSwitchCacheItem(S.CSwitchOnlyThreads[i]);\n"
"	}\n"
"	for(var i = 0; i < S.ThreadIds.length; ++i)\n"
"	{\n"
"		PreprocessContextSwitchCacheItem(S.ThreadIds[i]);	\n"
"	}\n"
"	function HandleMissingThread(a)\n"
"	{\n"
"		if(!S.CSwitchThreads[a])\n"
"		{\n"
"			S.CSwitchThreads[a] = {\'tid\':a, \'pid\':-1, \'t\':\'?\', \'p\':\'?\'}\n"
"		}\n"
"	}\n"
"	function CompareThreadInfo(a, b)\n"
"	{\n"
"		if(a.pid != b.pid)\n"
"			return a.pid - b.pid;\n"
"		else\n"
"			return a.tid - b.tid;\n"
"	}\n"
"	S.CSwitchOnlyThreads.sort( function(a, b){ \n"
"		HandleMissingThread(a);\n"
"		HandleMissingThread(b);\n"
"		return CompareThreadInfo(S.CSwitchThreads[a], S.CSwitchThreads[b]); \n"
"";

const size_t g_MicroProfileHtml_end_1_size = sizeof(g_MicroProfileHtml_end_1);
const char g_MicroProfileHtml_end_2[] =
"	} );\n"
"\n"
"	ProfileLeave();\n"
"}\n"
"\n"
"function DrawContextSwitchBars(context, ThreadId, fScaleX, fOffsetY, fDetailedOffset, nHoverColor, MinWidth, bDrawEnabled, bSecond)\n"
"{\n"
"	ProfileEnter(\"DrawContextSwitchBars\");\n"
"	var CSObject = S.CSwitchCache[ThreadId];\n"
"	if(CSObject && CSObject.Size > 0)\n"
"	{\n"
"		var Size = CSObject.Size;		\n"
"		var In = CSObject.In;\n"
"		var Out = CSObject.Out;\n"
"		var Cpu = CSObject.Cpu;\n"
"		var nNumColors = CSwitchColors.length;\n"
"		for(var i = 0; i < Size; ++i)\n"
"		{\n"
"			var TimeIn = In[i];\n"
"			var TimeOut = Out[i];\n"
"			var ActiveCpu = Cpu[i];\n"
"\n"
"			var X = (TimeIn - fDetailedOffset) * fScaleX;\n"
"			if(X > nWidth)\n"
"			{\n"
"				break;\n"
"			}\n"
"			var W = (TimeOut - TimeIn) * fScaleX;\n"
"			if(W > MinWidth && X+W > 0)\n"
"			{\n"
"				if(nHoverCSCpu == ActiveCpu || bDrawEnabled)\n"
"				{\n"
"					if(nHoverCSCpu == ActiveCpu)\n"
"					{\n"
"						context.fillStyle = nHoverColor;\n"
"					}\n"
"					else\n"
"					{\n"
"						context.fillStyle = CSwitchColors[ActiveCpu % nNumColors];\n"
"					}\n"
"					context.fillRect(X, fOffsetY, W, CSwitchHeight);\n"
"				}\n"
"				if(DetailedViewMouseX >= X && DetailedViewMouseX <= X+W && DetailedViewMouseY < fOffsetY+CSwitchHeight && DetailedViewMouseY >= fOffsetY)\n"
"				{\n"
"					nHoverCSCpuNext = ActiveCpu;\n"
"					RangeCpuNext.Off = bSecond ? fDetailedOffsetSecond : 0;\n"
"					RangeCpuNext.Begin = TimeIn;\n"
"					RangeCpuNext.End = TimeOut;\n"
"					RangeCpuNext.Thread = ThreadId;\n"
"					RangeGpuNext.Begin = RangeGpuNext.End = -1;\n"
"				}\n"
"			}\n"
"		}\n"
"	}\n"
"	else \n"
"	{\n"
"		//debug: draw context switch without cswitch\n"
"		// for(var i = 0; i < 8; ++i)\n"
"		// {\n"
"		// 	context.fillStyle = CSwitchColors[i];\n"
"		// 	context.fillRect((nWidth * i / 8) + 10, fOffsetY, nWidth / 8 - 20, CSwitchHeight);\n"
"		// }\n"
"	}\n"
"	ProfileLeave();\n"
"}\n"
"\n"
"function DrawDetailedButtons(context, X, Y, Names, Callbacks, Align)\n"
"{\n"
"	if(!Align)\n"
"	{\n"
"		Align = \"left\";\n"
"	}\n"
"	var Dir = 1;\n"
"	var Offset = 0;\n"
"	var OffsetText = 0;\n"
"	if(Align == \"right\")\n"
"	{\n"
"		Dir = -1;\n"
"	}\n"
"	else if(Align == \"center\")\n"
"	{\n"
"		Offset = -0.5;\n"
"		Align = \"left\";\n"
"	}\n"
"	let W = Array(Names.length);\n"
"	var w = 0;\n"
"	for(let i = 0; i < Names.length; ++i)\n"
"	{\n"
"		W[i] = context.measureText(Names[i]).width;\n"
"		w += W[i];\n"
"	}\n"
"	X += w * Offset;\n"
"\n"
"	// context.textBaseline = \'top\';\n"
"	context.textAlign = Align;\n"
"	context.fillStyle = \'white\';\n"
"	var mx = DetailedViewMouseX;\n"
"	var my = DetailedViewMouseY;\n"
"	for(let i = 0; i < Names.length; ++i)\n"
"	{\n"
"		let w = W[i];\n"
"		let x0_ = X + w * Dir;\n"
"		let x0 = Math.min(X, x0_);\n"
"		let x1 = Math.max(X, x0_);\n"
"		let y0 = Y;\n"
"		let y1 = Y + FontHeight;\n"
"		context.fillStyle = nBackColors[0];\n"
"		context.fillRect(x0, y0, x1 - x0, y1 - y0);\n"
"\n"
"		if(mx >= x0 && mx <= x1 && my >= y0 && my <= y1)\n"
"		{\n"
"			DetailedMouseOverButton = 1;\n"
"			context.fillStyle = \'cyan\';\n"
"			DetailedAddMouseEvent(99, function(){ Callbacks[i](); } );\n"
"		}\n"
"		else\n"
"		{\n"
"			context.fillStyle = \'white\';\n"
"		}\n"
"\n"
"		context.fillText(Names[i], X, Y + FontHeight - 2);\n"
"		X += Dir * (w+FontWidth);\n"
"	}\n"
"\n"
"	context.fillStyle = \'white\';\n"
"	context.textAlign = \'left\';\n"
"}\n"
"\n"
"function DrawDetailedView(S, S0, context, MinWidth, bDrawEnabled)\n"
"{\n"
"	if(!S || !S.Frames)\n"
"	{\n"
"		return;\n"
"	}\n"
"	let bSecond = S != S0;\n"
"	if(bDrawEnabled && !bSecond)\n"
"	{\n"
"		DrawDetailedBackground(context);\n"
"	}\n"
"\n"
"	let colors = [ \'#ff0000\', \'#ff00ff\', \'#ffff00\'];\n"
"	let fScaleX = nWidth / fDetailedRange; \n"
"	let fOffsetY = -nOffsetY + BoxHeight;\n"
"\n"
"\n"
"	let nHoverTokenStack = -1;\n"
"	if(S == S0)\n"
"	{\n"
"		nHoverCounter += nHoverCounterDelta;\n"
"		if(nHoverCounter >= 255) \n"
"		{\n"
"			nHoverCounter = 255;\n"
"			nHoverCounterDelta = -nHoverCounterDelta;\n"
"		}\n"
"		if(nHoverCounter < 128) \n"
"		{\n"
"			nHoverCounter = 128;\n"
"			nHoverCounterDelta = -nHoverCounterDelta;\n"
"		}\n"
"	}\n"
"	let nHoverHigh = nHoverCounter.toString(16);\n"
"	let nHoverLow = (127+255-nHoverCounter).toString(16);\n"
"	let nHoverColor = \'#\' + nHoverHigh + nHoverHigh + nHoverHigh;\n"
"	let nHoverColorIndex;\n"
"\n"
"	context.fillStyle = \'black\';\n"
"	context.font = Font;\n"
"	// context.textBaseline = \'alphabetic\';\n"
"\n"
"	let nNumLogs = S.Frames[0].ts.length;\n"
"	if(S0)\n"
"	{\n"
"		let l0 = S0.Frames[0].ts.length;\n"
"		let l1 = S.Frames[0].ts.length\n"
"		if(l1 != l0)\n"
"			debugger;\n"
"	}\n"
"	let Off = fDetailedOffset;\n"
"	let XOffset = 0;\n"
"	if(bSecond)\n"
"	{\n"
"		XOffset = fDetailedOffsetSecond;\n"
"		Off += XOffset;\n"
"	}\n"
"	let fTimeEnd = Off + fDetailedRange;\n"
"\n"
"	let FirstFrame = 0;\n"
"	for(let i = 0; i < S.Frames.length ; i++)\n"
"	{\n"
"		if(S.Frames[i].frameend < Off)\n"
"		{\n"
"			FirstFrame = i;\n"
"		}\n"
"	}\n"
"\n"
"	let BoxHeightScaled = BoxHeight;\n"
"	let Scale = 1;\n"
"	let fExtra = 0;\n"
"	let Padding = 15;\n"
"	let SecondReverseOffset = 0;\n"
"	if(DrawDetailedFlameMode == 1)\n"
"	{\n"
"		BoxHeightScaled = Math.ceil(BoxHeight*0.5);\n"
"		fExtra = 0.5;\n"
"	}\n"
"	else if(DrawDetailedFlameMode == 2)\n"
"	{\n"
"		BoxHeightScaled = 0;\n"
"		fExtra = 1;\n"
"	}\n"
"	if(DrawDetailedCompareReverse && bSecond)\n"
"	{\n"
"		Scale = -1;\n"
"		BoxHeightScaled = -BoxHeightScaled;\n"
"		SecondReverseOffset = 5-BoxHeight;\n"
"	}\n"
"	let BoxHeightScaledPos = Math.abs(BoxHeightScaled);\n"
"	let Levels = [];\n"
"	let BatchesTxtColor = [\'#ffffff\', \'#333333\'];\n"
"\n"
"	let AddBatch = function(StackPos, index, X, Y, W, Name, NameLen, Duration)\n"
"	{\n"
"		let L = Levels[StackPos];\n"
"		if(!L)\n"
"		{\n"
"			for(let j = 0; j < StackPos+1; ++j)\n"
"			{\n"
"				if(!Levels[j])\n"
"				{\n"
"					Levels[j] = {};\n"
"					L = Levels[j];\n"
"					L.Batches = new Array(g_Colors.length+1);\n"
"					L.BatchesTxt = new Array();\n"
"					L.BatchesTxtPos = new Array();\n"
"					for(let i = 0; i < 2; ++i)\n"
"					{\n"
"						L.BatchesTxt[i] = Array();\n"
"						L.BatchesTxtPos[i] = Array();\n"
"					}\n"
"					for(let i = 0; i < L.Batches.length; ++i)\n"
"					{\n"
"						L.Batches[i] = Array();\n"
"					}\n"
"				}\n"
"			}\n"
"		}\n"
"		let B = L.Batches[index];\n"
"		let txtidx = g_ColorsTextIndex[index];\n"
"		if(txtidx < 0 || txtidx > 1)\n"
"			debugger;\n"
"		let BTxt = L.BatchesTxt[txtidx];\n"
"		let BTxtPos = L.BatchesTxtPos[txtidx];\n"
"		B.push(X);\n"
"		B.push(Y);\n"
"		B.push(W);\n"
"		DebugDrawQuadCount++;\n"
"\n"
"		let XText = X < 0 ? 0 : X;\n"
"		let WText = W - (XText-X);\n"
"		if(XText + WText > nWidth)\n"
"		{\n"
"			WText = nWidth - XText;\n"
"		}\n"
"		let BarTextLen = Math.floor((WText-2)/FontWidth);\n"
"		let TimeText = TimeToMsString(Duration);\n"
"		let TimeTextLen = TimeText.length;\n"
"\n"
"		if(BarTextLen >= 2)\n"
"		{\n"
"			if(BarTextLen < NameLen)\n"
"				Name = Name.substr(0, BarTextLen);\n"
"			let YPos = Y+BoxHeight-FontAscent;\n"
"			BTxt.push(Name);\n"
"			BTxtPos.push(XText+2);\n"
"\n"
"			BTxtPos.push(YPos);\n"
"			DebugDrawTextCount++;\n"
"			if(BarTextLen - NameLen > TimeTextLen)\n"
"			{\n"
"				BTxt.push(TimeText);\n"
"				BTxtPos.push(XText+WText-2 - TimeTextLen * FontWidth);\n"
"				BTxtPos.push(YPos);\n"
"				DebugDrawTextCount++;\n"
"			}\n"
"		}\n"
"	};\n"
"	{\n"
"		context.fillStyle = \'white\';\n"
"		fOffsetY += BoxHeight;\n"
"		context.fillText(\"Timeline\", 0, fOffsetY);\n"
"		fOffsetY += BoxHeight;\n"
"\n"
"\n"
"		let Times = Timeline.Times;\n"
"		let Colors = Timeline.Colors;\n"
"		let Ends = Timeline.Ends;\n"
"		let Positions = Timeline.Positions;\n"
"		let Names = Timeline.Names;\n"
"		let off = 0.7;\n"
"		let off2 = 2*off;\n"
"		let MaxPosition = 1;\n"
"\n"
"		for(let i = 0; i < Timeline.Positions.length; ++i)\n"
"		{\n"
"			let TimeStart = Times[i];\n"
"			let TimeEnd = Ends[i];\n"
"			let Position = Positions[i];\n"
"			if(Position >= 0)\n"
"			{\n"
"				MaxPosition = Math.max(Position, MaxPosition);\n"
"				let Color = Colors[i];\n"
"				let Name = Names[i];\n"
"				let P = Positions[i];\n"
"				let X = (TimeStart - Off) * fScaleX;\n"
"				let Y = fOffsetY + P * (BoxHeight+2);\n"
"				let W = (TimeEnd-TimeStart)*fScaleX;\n"
"				if(!bSecond)\n"
"				{\n"
"					if(DetailedViewMouseX >= X && DetailedViewMouseX <= X+W && DetailedViewMouseY < Y+BoxHeight && DetailedViewMouseY >= Y)\n"
"					{\n"
"						RangeCpuNext.Off = 0;\n"
"						RangeCpuNext.Begin = TimeStart;\n"
"						RangeCpuNext.End = TimeEnd;\n"
"						RangeCpuNext.Thread = -1;\n"
"						nHoverColorIndex = Color;\n"
"						Color = cidhovercolor;\n"
"					}\n"
"					AddBatch(0, Color, X, Y, W, Name, Name.length, TimeEnd-TimeStart);\n"
"				}\n"
"			}\n"
"		}\n"
"		fOffsetY += (1+MaxPosition) * (BoxHeight+3);\n"
"	}\n"
"	let nMinTimeMs = MinWidth / fScaleX;\n"
"	let DrawGuides = 1;\n"
"	{\n"
"		if(!ThreadYBegin)\n"
"		{\n"
"			ThreadYBegin = Array(S0.ThreadNames.length);\n"
"			ThreadYEnd = Array(S0.ThreadNames.length);\n"
"		}\n"
"\n"
"		for(let i = 0; i < nNumLogs; i++)\n"
"		{\n"
"			let nLog = ThreadOrderT[i];\n"
"			let ThreadName = S0.ThreadNames[nLog];\n"
"			let Active = ThreadsActive[ThreadName];\n"
"			let ThreadColors = S0.ThreadColors[nLog];\n"
"			ThreadYBegin[nLog] = fOffsetY;\n"
"			if(HideMode == HideModeCollapsed && !Active)\n"
"			{\n"
"				continue;\n"
"			}\n"
"\n"
"\n"
"			let SMul = 2;\n"
"			let LogHeight = (S0.MaxStack[nLog]) * BoxHeightScaledPos + BoxHeight;\n"
"			let LogHeight2 = (S0.MaxStack2[nLog]) * BoxHeightScaledPos + BoxHeight;\n"
"			if(nContextSwitchEnabled)\n"
"			{\n"
"				LogHeight += (CSwitchHeight+4);\n"
"				LogHeight2 += (CSwitchHeight+4);\n"
"			}\n"
"			if(!S0.SecondActive)\n"
"			{\n"
"				LogHeight2 = 0;\n"
"			}\n"
"			let OY = fOffsetY;\n"
"			if(!bSecond)\n"
"			{\n"
"				OY += LogHeight2+1;\n"
"			}\n"
"			else\n"
"			{\n"
"				if(DrawDetailedCompareReverse)\n"
"				{\n"
"					OY += LogHeight2 - 5;\n"
"				}\n"
"			}\n"
"			\n"
"			let fOffsetYDelta = Active ? (LogHeight + LogHeight2 + Padding) : BoxHeight;\n"
"\n"
"			ThreadYBegin[nLog] = fOffsetY;\n"
"			ThreadYEnd[nLog] = fOffsetY + fOffsetYDelta;\n"
"\n"
"			let ThreadHover = false;\n"
"			if(bDrawEnabled)\n"
"			{\n"
"				if(Active || !bSecond)\n"
"				{\n"
"					let Color = bSecond ? ThreadColors.coloroff : ThreadColors.color;\n"
"					let ColorLine = !bSecond ? ThreadColors.colordark : ThreadColors.color;\n"
"					let Gradient = bSecond ? ThreadColors.gradientoff : ThreadColors.gradient;\n"
"					let BaseY = (bSecond||!Active) ? (fOffsetY+1) : (fOffsetY+1+LogHeight2);\n"
"					let HeightY = !Active ? BoxHeight : (bSecond ? LogHeight2 : (LogHeight + Padding));\n"
"					let TransparentLine = S2.Frames != null && !bSecond;\n"
"					if(TransparentLine)\n"
"					{\n"
"						context.globalAlpha = 0.4;\n"
"					}\n"
"					context.strokeStyle = ColorLine;\n"
"					context.beginPath();\n"
"					context.moveTo(0, BaseY);\n"
"					context.lineTo(nWidth, BaseY);\n"
"					context.stroke();\n"
"					if(TransparentLine)\n"
"					{\n"
"						context.globalAlpha = 1.0;\n"
"					}\n"
"\n"
"					if(!Gradient)\n"
"					{\n"
"						Gradient = context.createLinearGradient(0,0,200,0);\n"
"						Gradient.addColorStop(0, Color);\n"
"						Gradient.addColorStop(1,\'transparent\');\n"
"						if(bSecond)\n"
"							ThreadColors.gradientoff = Gradient;\n"
"						else\n"
"							ThreadColors.gradient = Gradient;\n"
"					}\n"
"					context.fillStyle = Gradient;\n"
"					context.fillRect(0,BaseY,200,HeightY);\n"
"				}\n"
"			}\n"
"			let D = fOffsetY + BoxHeight - DetailedViewMouseY;\n"
"			\n"
"			if(bDrawEnabled && G_DEBUG && 0)\n"
"			{\n"
"				debugger;\n"
"			}\n"
"			if(!bSecond)\n"
"			{\n"
"				if(D > 0 && D < BoxHeight)\n"
"				{\n"
"					if(!bDrawEnabled)\n"
"					{\n"
"						context.globalAlpha = 0.3;\n"
"						context.fillStyle = \'grey\';\n"
"						context.fillRect(0, fOffsetY+2, nWidth, Active ? LogHeight2 + LogHeight + Padding : BoxHeight);\n"
"						context.globalAlpha = 1.0;\n"
"					}\n"
"					ThreadHover = 1;\n"
"				}\n"
"			}\n"
"\n"
"			if(Active)\n"
"			{\n"
"				let LodIndex = 0;\n"
"				let MinDelta = 0;\n"
"				let NextLod = 1;\n"
"				while(NextLod < S.LodData.length && S.LodData[NextLod].MinDelta[nLog] < nMinTimeMs)\n"
"				{\n"
"					LodIndex = NextLod;\n"
"					NextLod = NextLod + 1;\n"
"					MinDelta = S.LodData[LodIndex].MinDelta[nLog];\n"
"				}\n"
"				if(LodIndex == S.LodData.length)\n"
"				{\n"
"					LodIndex = S.LodData.length-1;\n"
"				}\n"
"				if(DisableLod || FilterSearchPassIndex != -1)\n"
"				{\n"
"					LodIndex = 0;\n"
"				}\n"
"\n"
"				OY += 4;\n"
"\n"
"				if(nContextSwitchEnabled)\n"
"				{\n"
"					DrawContextSwitchBars(context, S.ThreadIds[nLog], fScaleX, OY, Off, nHoverColor, MinWidth, bDrawEnabled, bSecond);\n"
"					OY += Scale * (CSwitchHeight+2);\n"
"				}\n"
"				OY += SecondReverseOffset;\n"
"				let MaxDepth = 1;\n"
"				let StackPos = 0;\n"
"				let Stack = Array(20);\n"
"				let Lod = S.LodData[LodIndex];\n"
"\n"
"				let TypeArray = Lod.TypeArray[nLog];\n"
"				let IndexArray = Lod.IndexArray[nLog];\n"
"				let TimeArray = Lod.TimeArray[nLog];\n"
"\n"
"				let LocalFirstFrame = S.Frames[FirstFrame].FirstFrameIndex[nLog];\n"
"				let IndexStart = S.ISGPU[nLog] ? 0 : Lod.LogStart[LocalFirstFrame][nLog];\n"
"				let IndexEnd = TimeArray.length;\n"
"				IndexEnd = TimeArray.length;\n"
"				let HasSetHover = 0;\n"
"\n"
"\n"
"\n"
"				for(let j = IndexStart; j < IndexEnd; ++j)\n"
"				{\n"
"					let type = TypeArray[j];\n"
"					let index = IndexArray[j];\n"
"					let time = TimeArray[j];\n"
"					if(type == 1)\n"
"					{\n"
"						//push\n"
"						Stack[StackPos] = j;\n"
"						StackPos++;\n"
"						if(StackPos > MaxDepth)\n"
"						{\n"
"							MaxDepth = StackPos;\n"
"						}\n"
"					}\n"
"					else if(type == 0)\n"
"					{\n"
"						if(StackPos>0)\n"
"						{\n"
"							StackPos--;\n"
"\n"
"							let StartIndex = Stack[StackPos];\n"
"							let timestart = TimeArray[StartIndex];\n"
"							let timeend = time;\n"
"							let X = (timestart - Off) * fScaleX;\n"
"							let Y = OY + StackPos * BoxHeightScaled;\n"
"\n"
"							let W = (timeend-timestart)*fScaleX;\n"
"\n"
"							if(X < nWidth && X+W > 0)\n"
"							{\n"
"								if(index == FilterSearchPassIndex)\n"
"								{\n"
"									let Range = RangeInit();\n"
"									Range.Begin = timestart;\n"
"									Range.End = timeend;\n"
"									Range.Thread = nLog;\n"
"									Range.YBegin = Y - ThreadYBegin[nLog];\n"
"									Range.Second = bSecond;\n"
"\n"
"									if(FilterSearchArray.length < 500)\n"
"									{\n"
"										FilterSearchArray.push(Range);\n"
"										if(FilterSearchArray.length == 500)\n"
"										{\n"
"											ShowFlashMessage(\'Capping Search Result to 500\', 30);\n"
"										}\n"
"									}\n"
"								}\n"
"								if(W > MinWidth)\n"
"								{\n"
"									if(bDrawEnabled || index == nHoverToken)\n"
"									{\n"
"										let cid = GroupColors == 2 ? ThreadColors.colordark_cid : S0.TimerInfo[index].cid;\n"
"										if(index == nHoverToken)\n"
"										{\n"
"											nHoverColorIndex = cid;\n"
"											cid = cidhovercolor;\n"
"										}\n"
"										AddBatch(StackPos, cid, X, Y, W, S0.TimerInfo[index].name, S0.TimerInfo[index].len, timeend-timestart);\n"
"									}\n"
"\n"
"\n"
"									if(DetailedViewMouseX >= X && DetailedViewMouseX <= X+W && DetailedViewMouseY < Y+BoxHeight && DetailedViewMouseY >= Y && StackPos > nHoverTokenStack)\n"
"									{\n"
"										RangeCpuNext.Off = bSecond ? fDetailedOffsetSecond : 0;\n"
"										RangeCpuNext.Begin = timestart;\n"
"										RangeCpuNext.End = timeend;\n"
"										RangeCpuNext.Thread = nLog;\n"
"										RangeCpuNext.Off = XOffset;\n"
"										if(TypeArray[StartIndex+1] == 3 && TypeArray[j+1] == 3)\n"
"										{\n"
"											RangeGpuNext.Begin = RangeCpuNext.Begin;\n"
"											RangeGpuNext.End = RangeCpuNext.End;\n"
"											RangeGpuNext.Thread = nLog;\n"
"											RangeGpuNext.Off = XOffset;\n"
"											//cpu tick is stored following\n"
"											RangeCpuNext.Begin = TimeArray[StartIndex+1];\n"
"											RangeCpuNext.End = TimeArray[j+1];\n"
"											RangeCpuNext.Thread = IndexArray[StartIndex+1];\n"
"											RangeCpuNext.Off = XOffset;\n"
"										}\n"
"										else\n"
"										{\n"
"											RangeGpuNext.Begin = -1;\n"
"											RangeGpuNext.End = -1\n"
"										}\n"
"\n"
"										nHoverTokenNext = index;\n"
"										nHoverTokenStack = StackPos;\n"
"										nHoverTokenIndexNext = j;\n"
"										nHoverTokenLogIndexNext = nLog;\n"
"										HoverTokenNextOwner = S;\n"
"										HasSetHover = 1;\n"
"									}\n"
"								}\n"
"							}\n"
"							if(StackPos == 0 && time > fTimeEnd)\n"
"								break;											\n"
"						}\n"
"					}\n"
"				}\n"
"				if(HasSetHover)\n"
"				{\n"
"					for(let i = 0; i < S.Frames.length-1; ++i)\n"
"					{\n"
"						let IndexStart = Lod.LogStart[i][nLog];\n"
"						if(nHoverTokenIndexNext >= IndexStart)\n"
"						{\n"
"							nHoverFrame = i;\n"
"						}\n"
"					}\n"
"				}\n"
"			}\n"
"			let w = context.measureText(ThreadName).width;\n"
"			context.fillStyle = nBackColors[0];\n"
"			context.fillStyle = \'white\';\n"
"			context.fillText(ThreadName, 0, fOffsetY+FontHeight-1);\n"
"			if(ThreadHover)\n"
"			{\n"
"				DrawDetailedButtons(context, nWidth, fOffsetY+1, [\"\\u2191\\u2191\\u2191\", \"\\u2193\\u2193\\u2193\", \"\\u2191\", \"\\u2193\"], \n"
"					[function(){ThreadOrderMoveUp(ThreadName,1);}, function(){ThreadOrderMoveDown(ThreadName,1);},\n"
"					function(){ThreadOrderMoveUp(ThreadName);}, function(){ThreadOrderMoveDown(ThreadName);}],\n"
"					 \"right\");\n"
"							// DetailedAddMouseEvent(1, function(){ Callbacks[i](); } );\n"
"				DetailedAddMouseEvent(1, function()\n"
"				{\n"
"					ToggleThread(ThreadName);\n"
"				});\n"
"			}\n"
"			// context.textBaseline = \'alphabetic\';\n"
"			fOffsetY += fOffsetYDelta;\n"
"			// ThreadY[nLog+1] = fOffsetY;\n"
"		}\n"
"\n"
"		if(nContextSwitchEnabled && !bSecond) //non instrumented threads.\n"
"		{\n"
"			let CurrentPid = -112;\n"
"			let ContextSwitchThreads = S.CSwitchOnlyThreads;\n"
"			function DrawHeader(str, X, Y)\n"
"			{\n"
"				let width = str.length * FontWidth;\n"
"				context.globalAlpha = 0.5;\n"
"				context.fillStyle = \'grey\';\n"
"				context.fillRect(X, Y-FontHeight + 2, width, FontHeight);\n"
"				context.globalAlpha = 1.0;\n"
"				context.fillStyle = \'white\';\n"
"				context.fillText(str, X, Y);\n"
"\n"
"\n"
"			}\n"
"			for(let i = 0; i < ContextSwitchThreads.length; ++i)\n"
"			{\n"
"				let ThreadId = ContextSwitchThreads[i];\n"
"				let ThreadName = \'\' + ThreadId;\n"
"				let TI = S.CSwitchThreads[ThreadId];\n"
"\n"
"				if(TI)\n"
"				{\n"
"					if(CurrentPid != TI.pid)\n"
"					{\n"
"						fOffsetY += BoxHeight + 1;\n"
"						CurrentPid = TI.pid;\n"
"						let str = TI.pid.toString(16) +\':\' +TI.p;\n"
"						DrawHeader(str, 0, fOffsetY+5);\n"
"						fOffsetY += BoxHeight + 1;\n"
"					}\n"
"				}\n"
"\n"
"				DrawContextSwitchBars(context, ThreadId, fScaleX, fOffsetY, Off, nHoverColor, MinWidth, bDrawEnabled);\n"
"\n"
"				if(TI)\n"
"				{\n"
"					DrawHeader(TI.tid.toString(16) +\':\' +TI.t, 10, fOffsetY+5);\n"
" 				}\n"
"				fOffsetY += BoxHeight + 1;\n"
"			}\n"
"		}\n"
"		{\n"
"			let h = nHeight;\n"
"\n"
"		}\n"
"		let TOP_LIMIT = 100;\n"
"		if(fOffsetY < TOP_LIMIT)\n"
"		{\n"
"			let Diff = fOffsetY - TOP_LIMIT;\n"
"			nOffsetY += Math.floor(Diff);\n"
"			nOffsetY = Math.max(0, nOffsetY);\n"
"		}\n"
"		let FillRects = function(a, color, colordark)\n"
"		{\n"
"			context.fillStyle = color;\n"
"			for(let j = 0; j < a.length; j += 3)\n"
"			{						\n"
"				let X = a[j];\n"
"				let Y = a[j+1];\n"
"				let W = a[j+2];\n"
"				if(W >= 1)\n"
"				{\n"
"					context.fillRect(X, Y, W, BoxHeight-1);\n"
"				}\n"
"			}\n"
"			// context.fillStyle = color;\n"
"			// for(var j = 0; j < a.length; j += 3)\n"
"			// {						\n"
"			// 	var X = a[j];\n"
"			// 	var Y = a[j+1];\n"
"			// 	var W = a[j+2];\n"
"			// 	if(W > 0)\n"
"			// 	{\n"
"			// 		context.fillRect(X+off, Y+off, W-off2, BoxHeight-1-off2);\n"
"			// 	}\n"
"			// }\n"
"		}\n"
"\n"
"		for(let l = 0; l < Levels.length; ++l)\n"
"		{\n"
"			let Batches = Levels[l].Batches;\n"
"			for(let i = 0; i < Batches.length; ++i)\n"
"			{\n"
"				let a = Batches[i];\n"
"				if(a.length)\n"
"				{\n"
"					if(!DisableMerge)\n"
"					{\n"
"						for(let j = 0; j < a.length; j += 3)\n"
"						{						\n"
"							let X = a[j];\n"
"							let Y = a[j+1];\n"
"							let BaseWidth = j + 2;\n"
"							let W = a[BaseWidth];\n"
"							while(j+1 < a.length && W < 1)\n"
"							{\n"
"								let jnext = j+3;\n"
"								let XNext = a[jnext];\n"
"								let YNext = a[jnext+1];\n"
"								let WNext = a[jnext+2];\n"
"								let Delta = XNext - (X+W);\n"
"								let YDelta = Math.abs(Y - YNext);							\n"
"								if(Delta < 0.3 && YDelta < 0.5 && WNext < 1)\n"
"								{\n"
"									W = (XNext+WNext) - X;\n"
"									a[BaseWidth] = W;\n"
"									a[jnext+2] = 0;\n"
"									j += 3;\n"
"								}\n"
"								else\n"
"								{\n"
"									break;\n"
"								}\n"
"\n"
"							}\n"
"						}\n"
"					}\n"
"					let Color = i == 0 ? nHoverColor : g_Colors[i];\n"
"					let ColorDark = i == 0 ? nHoverColor : g_ColorsDark[i];\n"
"					if(i == 0)\n"
"					{\n"
"						if(nHoverColorIndex)\n"
"						{\n"
"							let mult = nHoverCounter / 255.0;\n"
"							let m2 =mult -0.5;\n"
"							let m4 = m2 * 0.5;\n"
"							let f = function()\n"
"							{\n"
"								let H = g_ColorH[nHoverColorIndex];\n"
"								let S = g_ColorS[nHoverColorIndex];\n"
"								let L = g_ColorL[nHoverColorIndex];\n"
"								let offset = 0;\n"
"								if(S> 0.5)\n"
"									offset = 0.5 - S;\n"
"								let offsetL = 0;\n"
"								if(L > 0.75)\n"
"									offsetL = 0.75 - L;\n"
"								L = L + m4 + offsetL;\n"
"								L = L > 1 ? 1 : (L < 0 ? 0 : L);\n"
"								S = S + m2 + offset;\n"
"								S = S > 1 ? 1 : (S < 0 ? 0 : S);\n"
"								return ConvertHslToColor(H, S, L);\n"
"							};\n"
"							let ColorCV = f();\n"
"							ColorDark = Color = ColorCV; ;\n"
"						}\n"
"					}\n"
"					FillRects(a, Color, ColorDark);\n"
"\n"
"				}\n"
"			}\n"
"			let BatchesTxt = Levels[l].BatchesTxt;\n"
"			let BatchesTxtPos = Levels[l].BatchesTxtPos;	\n"
"			for(let i = 0; i < BatchesTxt.length; ++i)\n"
"			{\n"
"				context.fillStyle = BatchesTxtColor[i];\n"
"				let TxtArray = BatchesTxt[i];\n"
"				let PosArray = BatchesTxtPos[i];\n"
"				for(let j = 0; j < TxtArray.length; ++j)\n"
"				{\n"
"					let k = j * 2;\n"
"					context.fillText(TxtArray[j], PosArray[k],PosArray[k+1]);\n"
"				}\n"
"			}\n"
"\n"
"		}\n"
"	}\n"
"}\n"
"function DrawTextBox(context, text, x, y, align)\n"
"{\n"
"	let textsize = context.measureText(text).width;\n"
"	let offsetx = 0;\n"
"	let offsety = -FontHeight;\n"
"	if(align == \'center\')\n"
"	{\n"
"		offsetx = -textsize / 2.0;\n"
"	}\n"
"	else if(align == \'right\')\n"
"	{\n"
"		offsetx = -textsize;\n"
"	}\n"
"	context.fillStyle = nBackColors[0];\n"
"	context.fillRect(x + offsetx, y + offsety, textsize+2, FontHeight + 2);\n"
"	context.fillStyle = \'white\';\n"
"	context.fillText(text, x, y);\n"
"\n"
"}\n"
"\n"
"function DrawFilterSearchRanges(context, Ranges, ColorBack, ColorFront, ThreadY)\n"
"{\n"
"	if(0 == Ranges.length)\n"
"		return;\n"
"	//todo: arrow key support \n"
"	var MarginTop = 1.0 * FontHeight;\n"
"	var MarginBottom = nHeight - 1.0 * FontHeight;\n"
"\n"
"\n"
"	var Time = new Date();\n"
"	var Delta = Time - FilterSearchStartTime;\n"
"	var BlinkTime = 2.5 * 1000;\n"
"	var Blinks = 5;\n"
"	var HoverFloat = 0.2;\n"
"	var Blinking = 0;\n"
"	if(Delta < BlinkTime)\n"
"	{\n"
"		Blinking = 1;\n"
"		var b0 = Blinks* Math.PI * Delta;\n"
"		var b1 = b0 / BlinkTime;\n"
"		var Mag = Math.abs(Math.sin(b1));\n"
"		HoverFloat = Mag * 0.5 + 0.2;\n"
"	}\n"
"	var Lines = new Array();\n"
"	var Rects = new Array();\n"
"\n"
"\n"
"	for(var i = 0; i < Ranges.length; ++i)\n"
"	{\n"
"		var Range = Ranges[i];\n"
"		let Off = Range.Second ? fDetailedOffsetSecond : 0\n"
"		var fBegin = Range.Begin - Off;\n"
"		var fEnd = Range.End - Off;\n"
"		var OffsetTop = Range.YBegin + ThreadY[Range.Thread];\n"
"		var OffsetBottom = OffsetTop + BoxHeight;\n"
"\n"
"		if(fBegin < fEnd)\n"
"		{\n"
"			{\n"
"				OffsetTop = Math.max(OffsetTop, 0);\n"
"				OffsetBottom = Math.max(OffsetBottom, MarginTop);\n"
"				OffsetTop = Math.min(OffsetTop, MarginBottom);\n"
"				OffsetBottom = Math.min(OffsetBottom, nHeight);\n"
"				var fScaleX = nWidth / fDetailedRange; \n"
"				var X = (fBegin - fDetailedOffset) * fScaleX;\n"
"				var Y = OffsetTop;\n"
"				var W = (fEnd - fBegin) * fScaleX;\n"
"				if(W > 1)\n"
"				{\n"
"					Rects.push(X-3);\n"
"					Rects.push(OffsetTop-3);\n"
"					Rects.push(W+5);\n"
"					Rects.push(5 + OffsetBottom - OffsetTop);\n"
"				}\n"
"				else\n"
"				{\n"
"					X += W * 0.5;\n"
"					Lines.push(X);\n"
"					context.beginPath();\n"
"					context.moveTo(X, 0);\n"
"					context.lineTo(X, nHeight);\n"
"					context.stroke();\n"
"				}\n"
"			}\n"
"		}\n"
"	}\n"
"\n"
"	context.fillStyle = ColorBack;\n"
"	context.strokeStyle = ColorBack;\n"
"\n"
"	context.globalAlpha = HoverFloat;\n"
"\n"
"	for(var i = 0; i < Rects.length;)\n"
"	{\n"
"		var X = Rects[i++];\n"
"		var Y = Rects[i++];\n"
"		var W = Rects[i++];\n"
"		var H = Rects[i++];\n"
"		context.fillRect(X, Y, W, H);\n"
"	}\n"
"	context.globalAlpha = 1;\n"
"	for(var i = 0; i < Rects.length;)\n"
"	{\n"
"		var X = Rects[i++];\n"
"		var Y = Rects[i++];\n"
"		var W = Rects[i++];\n"
"		var H = Rects[i++];\n"
"		context.strokeRect(X, Y, W, H);\n"
"	}\n"
"\n"
"	for(var i = 0; i < Lines.length; ++i)\n"
"	{\n"
"		context.beginPath();\n"
"		context.moveTo(Lines[i], 0);\n"
"		context.lineTo(Lines[i], nHeight);\n"
"		context.stroke();\n"
"	}\n"
"	if(Blinking>0)\n"
"	{\n"
"		Invalidate = 1;\n"
"	}\n"
"\n"
"}\n"
"\n"
"\n"
"function DrawRange(context, Range, ColorBack, ColorFront, Name, Offset)\n"
"{\n"
"	if(!Offset)\n"
"		Offset = 0;\n"
"	var fBegin = Range.Begin;\n"
"	var fEnd = Range.End;\n"
"	var OffsetTop = Range.YBegin;\n"
"	var OffsetBottom = Range.YEnd;\n"
"	var Off = Range.Off + fDetailedOffset;\n"
"	if(fBegin < fEnd)\n"
"	{\n"
"		var MarginTop = (1.0+Offset) * (FontHeight+1);\n"
"		var MarginBottom = nHeight - (Offset+1.5) * (FontHeight+1);\n"
"		if(OffsetTop < MarginTop)\n"
"		{\n"
"			Offset += 1;\n"
"			OffsetTop = MarginTop;\n"
"		}\n"
"		if(OffsetBottom > MarginBottom)\n"
"		{\n"
"			OffsetBottom = MarginBottom;\n"
"		}\n"
"		var fRulerOffset = FontHeight * 0.5;\n"
"		var fScaleX = nWidth / fDetailedRange; \n"
"		var X = (fBegin - Off) * fScaleX;\n"
"		var YSpace = (FontHeight+2);\n"
"		var Y = OffsetTop;\n"
"		var YBottom = OffsetBottom;\n"
"		var W = (fEnd - fBegin) * fScaleX;\n"
"		context.globalAlpha = 0.1;\n"
"		context.fillStyle = ColorBack;\n"
"		context.fillRect(X, OffsetTop + fRulerOffset, W, OffsetBottom - OffsetTop);\n"
"		context.globalAlpha = 1;\n"
"		context.strokeStyle = ColorFront;\n"
"		context.beginPath();\n"
"		context.moveTo(X, 0);\n"
"		context.lineTo(X, nHeight);\n"
"		context.moveTo(X+W, 0);\n"
"		context.lineTo(X+W, nHeight);\n"
"		context.stroke();\n"
"		var Duration = (fEnd - fBegin).toFixed(2) + \"ms\";\n"
"		var Center = ((fBegin + fEnd) / 2.0) - Off;\n"
"		var DurationWidth = context.measureText(Duration+ \"   \").width;\n"
"\n"
"		context.fillStyle = \'white\';\n"
"		context.textAlign = \'right\';\n"
"		var TextPosY = Y + YSpace;\n"
"		DrawTextBox(context, (fBegin-Range.Off).toFixed(2), X-3, TextPosY, \'right\');\n"
"		var YS = [Y, YBottom];\n"
"		for(var i = 0; i < YS.length; ++i)\n"
"		{\n"
"			var Y = YS[i];\n"
"			var Y0 = Y + fRulerOffset;\n"
"			var W0 = W - DurationWidth + FontWidth*1.5;\n"
"			if(W0 > 6)\n"
"			{\n"
"				context.textAlign = \'center\';\n"
"				DrawTextBox(context, Duration,Center * fScaleX, Y + YSpace, \'center\');\n"
"				W0 = W0 / 2.0;\n"
"				var X0 = X + W0;\n"
"				var X1 = X + W - W0;\n"
"				context.strokeStyle = ColorFront;\n"
"				context.beginPath();\n"
"				context.moveTo(X, Y0);\n"
"				context.lineTo(X0, Y0);\n"
"				context.moveTo(X0, Y0-2);\n"
"				context.lineTo(X0, Y0+2);\n"
"				context.moveTo(X1, Y0-2);\n"
"				context.lineTo(X1, Y0+2);\n"
"				context.moveTo(X1, Y0);\n"
"				context.lineTo(X + W, Y0);\n"
"				context.stroke();\n"
"			}\n"
"			else\n"
"			{\n"
"				if(i == 1)\n"
"				{\n"
"					context.textAlign = \'right\';\n"
"					DrawTextBox(context, Duration, X - 3, Y0, \'right\');\n"
"					context.textAlign = \'left\';\n"
"					DrawTextBox(context, Duration, X + W + 2, Y0, \'left\');\n"
"				}\n"
"				context.strokeStyle = ColorFront;\n"
"				context.beginPath();\n"
"				context.moveTo(X, Y0);\n"
"				context.lineTo(X+W, Y0);\n"
"				context.stroke();\n"
"			}\n"
"		}\n"
"		context.textAlign = \'left\';\n"
"		DrawTextBox(context, (fEnd-Range.Off).toFixed(2), X + W + 2, TextPosY, \'left\');\n"
"		DrawTextBox(context, Name, X + W + 2, OffsetTop + YSpace + FontHeight, \'left\');\n"
"	}\n"
"	return Offset;\n"
"}\n"
"function DetailedAddMouseEvent(P, E)\n"
"{\n"
"	if(!DetailedMouseEvent)\n"
"	{\n"
"		DetailedMouseEvent = {\"P\":P, \"E\":E};\n"
"	}\n"
"	else if(DetailedMouseEvent.P < P)\n"
"	{\n"
"		DetailedMouseEvent.P = P;\n"
"		DetailedMouseEvent.E = E;\n"
"	}\n"
"\n"
"}\n"
"\n"
"function DrawDetailed(Animation)\n"
"{\n"
"	DetailedMouseEvent = null;\n"
"\n"
"	if(!Initialized)\n"
"	{\n"
"		return;\n"
"	}\n"
"	ProfileEnter(\"DrawDetailed\");\n"
"	DetailedMouseOverButton = false;\n"
"\n"
"	DebugDrawQuadCount = 0;\n"
"	DebugDrawTextCount = 0;\n"
"	nHoverCSCpuNext = -1;\n"
"\n"
"	RangeCpuNext = RangeInit();\n"
"	RangeGpuNext = RangeInit();\n"
"\n"
"	var start = new Date();\n"
"	nDrawCount++;\n"
"\n"
"	var context = CanvasDetailedView.getContext(\'2d\');\n"
"	var offscreen = CanvasDetailedOffscreen.getContext(\'2d\');\n"
"	var fScaleX = nWidth / fDetailedRange; \n"
"	var fOffsetY = -nOffsetY + BoxHeight;\n"
"	if(DetailedRedrawState.fOffsetY == fOffsetY && DetailedRedrawState.fDetailedOffset == fDetailedOffset && DetailedRedrawState.fDetailedRange == fDetailedRange && !KeyCtrlDown && !KeyShiftDown && !KeyAltDown && !MouseDragButton && !RedrawRequested)\n"
"	{\n"
"		Invalidate++;\n"
"	}\n"
"	else\n"
"	{\n"
"		Invalidate = 0;\n"
"		DetailedRedrawState.fOffsetY = fOffsetY;\n"
"		DetailedRedrawState.fDetailedOffset = fDetailedOffset;\n"
"		DetailedRedrawState.fDetailedRange = fDetailedRange;\n"
"	}\n"
"	if(nHoverTokenDrawn != nHoverToken)\n"
"	{\n"
"		Invalidate = 1;\n"
"	}\n"
"	nHoverTokenDrawn = nHoverToken;\n"
"	nHoverTokenNext = -1;\n"
"	HoverTokenNextOwner = null;\n"
"	nHoverTokenLogIndexNext = -1;\n"
"	nHoverTokenIndexNext = -1;\n"
"\n"
"\n"
"\n"
"	if(Invalidate == 0) //when panning, only draw bars that are a certain width to keep decent framerate\n"
"	{\n"
"		context.clearRect(0, 0, CanvasDetailedView.width, CanvasDetailedView.height);\n"
"		DrawDetailedView(S, S, context, nMinWidthPan, true);\n"
"		DrawDetailedView(S2, S, context, nMinWidthPan, true, 1);\n"
"		ProfileRedraw0++;\n"
"	}\n"
"	else if(Invalidate == 1) //draw full and store\n"
"	{\n"
"		offscreen.clearRect(0, 0, CanvasDetailedView.width, CanvasDetailedView.height);\n"
"		DrawDetailedView(S, S, offscreen, nMinWidth, true);\n"
"		DrawDetailedView(S2, S, offscreen, nMinWidth, true, 1);\n"
"		OffscreenData = offscreen.getImageData(0, 0, CanvasDetailedOffscreen.width, CanvasDetailedOffscreen.height);\n"
"		ProfileRedraw1++;\n"
"	}\n"
"	else//reuse stored result untill next time viewport is changed.\n"
"	{\n"
"		context.clearRect(0, 0, CanvasDetailedView.width, CanvasDetailedView.height);\n"
"		context.putImageData(OffscreenData, 0, 0);\n"
"		DrawDetailedView(S, S, context, nMinWidth, false);\n"
"		DrawDetailedView(S2, S, context, nMinWidth, false, 1);\n"
"		ProfileRedraw2++;\n"
"	}\n"
"\n"
"	if(KeyShiftDown || KeyCtrlDown || MouseDragSelectRange() || ZoomActive || FilterSearchActive)\n"
"	{\n"
"		nHoverToken = -1;\n"
"		nHoverTokenIndex = -1;\n"
"		nHoverTokenLogIndex = -1;\n"
"		HoverTokenOwner = null;\n"
"		RangeCpu = RangeInit();\n"
"		RangeGpu = RangeInit();\n"
"	}\n"
"	else\n"
"	{\n"
"		nHoverToken = nHoverTokenNext;\n"
"		HoverTokenOwner = HoverTokenNextOwner;\n"
"		nHoverTokenIndex = nHoverTokenIndexNext;\n"
"		nHoverTokenLogIndex = nHoverTokenLogIndexNext;\n"
"		if(RangeValid(RangeCpuHistory))\n"
"		{\n"
"			RangeCopy(RangeCpu, RangeCpuHistory);\n"
"			RangeCopy(RangeGpu, RangeGpuHistory);\n"
"		}\n"
"		else\n"
"		{\n"
"			RangeCopy(RangeCpu, RangeCpuNext);\n"
"			RangeCopy(RangeGpu, RangeGpuNext);\n"
"		}\n"
"	}\n"
"\n"
"	DrawTextBox(context, TimeToMsString(fDetailedOffset), 0, FontHeight, \'left\');\n"
"	context.textAlign = \'right\';\n"
"	DrawTextBox(context, TimeToMsString(fDetailedOffset + fDetailedRange), nWidth, FontHeight, \'right\');\n"
"	context.textAlign = \'left\';\n"
"\n"
"	if(!FilterSearchActive && !IgnoreInput && SubMenuActive == -1)\n"
"	{\n"
"		let Colors = GroupColors == 2 ? \"Color[thread]\" : (GroupColors ? \"Color[group]\" : \"Color[timer]\");\n"
"		DrawDetailedButtons(context, nWidth * 0.5, 0, [Colors, \"Search\"],[function(){ToggleGroupColors(1);}, FilterInputShow], \"center\");\n"
"	}\n"
"\n"
"\n"
"	var YBegin = ThreadYBegin[fRangeThreadIdNext];\n"
"	var YEnd = ThreadYEnd[fRangeThreadIdNext];\n"
"	var YBeginGpu = YBegin;\n"
"	var YEndGpu = YEnd;\n"
"	function RangeSet(R)\n"
"	{\n"
"		if(R.Thread >= 0)\n"
"		{\n"
"			R.YBegin = ThreadYBegin[R.Thread];\n"
"			R.YEnd = ThreadYEnd[R.Thread];\n"
"		}\n"
"		else\n"
"		{\n"
"			R.YBegin = 0;\n"
"			R.YEnd = nHeight;\n"
"		}\n"
"	}\n"
"	RangeSet(RangeSelect);\n"
"	RangeSet(RangeCpu);\n"
"	RangeSet(RangeGpu);\n"
"	var Offset = 0;\n"
"	Offset = DrawRange(context, RangeSelect, \'#59d0ff\', \'#00ddff\', \"Selection\", Offset);\n"
"	Offset = DrawRange(context, RangeCpu, \'#009900\', \'#00ff00\', \"Cpu\", Offset);\n"
"	Offset = DrawRange(context, RangeGpu, \'#996600\', \'#775500\', \"Gpu\", Offset);\n"
"\n"
"	DrawFilterSearchRanges(context, FilterSearchArray, \'#ff9900\', \'#ff9900\', ThreadYBegin);\n"
"\n"
"	nHoverCSCpu = nHoverCSCpuNext;\n"
"\n"
"	DrawFilterSearch();\n"
"\n"
"\n"
"	ProfileLeave();\n"
"}\n"
"function ZoomToHighlight(NoGpu)\n"
"{\n"
"	if(RangeValid(RangeGpu) && !NoGpu)\n"
"	{\n"
"		ZoomToRange(RangeGpu);\n"
"	}\n"
"	else if(RangeValid(RangeCpu))\n"
"	{\n"
"		ZoomToRange(RangeCpu);\n"
"	}\n"
"	RangeCpu = RangeInit();\n"
"	RangeGpu = RangeInit();\n"
"}\n"
"\n"
"function MoveToNext(Direction) //1 forward, -1 backwards\n"
"{\n"
"	var fTimeBegin, fTimeEnd, nLog;\n"
"	var Index = nHoverToken;\n"
"\n"
"	if(nHoverToken != -1 && nHoverTokenLogIndex != -1)\n"
"	{\n"
"		fTimeBegin = RangeCpu.Begin;\n"
"		fTimeEnd = RangeCpu.End;\n"
"		nLog = nHoverTokenLogIndex;\n"
"	}\n"
"	else if(RangeValid(RangeSelect))\n"
"	{\n"
"		fTimeBegin = RangeSelect.Begin;\n"
"		fTimeEnd = RangeSelect.End;\n"
"		nLog = RangeSelect.Thread;\n"
"		Index = RangeSelect.Index;\n"
"	}\n"
"	else\n"
"	{\n"
"		return;\n"
"	}\n"
"	if(nLog<0)\n"
"	{\n"
"		return;\n"
"	}\n"
"	var Forward = Direction && Direction < 0 ? 0 : 1;\n"
"	var bFound = false;\n"
"	var nStackPos = 0;\n"
"	var fResultTimeBegin, fResultTimeEnd;\n"
"	var TypeBegin = Forward ? 1 : 0;\n"
"	var TypeEnd = Forward ? 0 : 1;\n"
"	var SearchTimeBegin = Forward ? fTimeBegin : fTimeEnd;\n"
"\n"
"	var istart = Forward ? 0 : S.Frames.length-1;\n"
"	var iend = Forward ? S.Frames.length : -1;\n"
"	var idelta = Forward ? 1 : -1;\n"
"	for(var i = istart; i != iend; i += idelta)\n"
"	{\n"
"		var fr = S.Frames[i];\n"
"		var ts = fr.ts[nLog];\n"
"		var ti = fr.ti[nLog];\n"
"		var tt = fr.tt[nLog];\n"
"		var jstart = Forward ? 0 : ts.length-1;\n"
"		var jend = Forward ? ts.length : -1;\n"
"		var jdelta = Forward ? 1 : -1;\n"
"		for(var j = jstart; j != jend; j += jdelta)\n"
"		{\n"
"			if(!bFound)\n"
"			{\n"
"				if(tt[j] == TypeBegin && Index == ti[j])\n"
"				{\n"
"					if(SearchTimeBegin == ts[j])\n"
"					{\n"
"						bFound = true;\n"
"					}\n"
"				}\n"
"			}\n"
"			else\n"
"			{\n"
"				if(Index == ti[j])\n"
"				{\n"
"					var type = tt[j];\n"
"					if(type == TypeBegin)\n"
"					{\n"
"						if(0 == nStackPos)\n"
"						{\n"
"							fResultTimeBegin = ts[j];\n"
"						}\n"
"						nStackPos++;\n"
"					}\n"
"					else if(type == TypeEnd && nStackPos)\n"
"					{\n"
"						nStackPos--;\n"
"						if(0 == nStackPos)\n"
"						{\n"
"							fResultTimeEnd = ts[j];\n"
"							if(0 == Forward)\n"
"							{\n"
"								var Tmp = fResultTimeBegin;\n"
"								fResultTimeBegin = fResultTimeEnd;\n"
"								fResultTimeEnd = Tmp;\n"
"							}\n"
"							RangeSelect.Begin = fResultTimeBegin;\n"
"							RangeSelect.End = fResultTimeEnd;\n"
"							RangeSelect.Thread = nLog;\n"
"							RangeSelect.Index = Index;\n"
"							MoveTo(fResultTimeBegin,fResultTimeEnd);\n"
"							return;\n"
"						}\n"
"					}\n"
"				}\n"
"			}\n"
"		}\n"
"	}\n"
"}\n"
"\n"
"function MoveTo(fMoveBegin, fMoveEnd, YTop, YBottom)\n"
"{\n"
"	var nOffsetYBottom = YBottom - nHeight;\n"
"	var nOffsetYDest = nOffsetY;\n"
"	if(nOffsetYDest < nOffsetYBottom)\n"
"	{\n"
"		nOffsetYDest = nOffsetYBottom;\n"
"	}\n"
"	if(nOffsetYDest > YTop)\n"
"	{	\n"
"		nOffsetYDest = YTop;\n"
"	}\n"
"	var fRange = fDetailedRange;\n"
"	var fMinRange = (fMoveEnd-fMoveBegin) * 2.0;\n"
"	if(fRange < fMinRange)\n"
"	{\n"
"		fRange = fMinRange;\n"
"	}\n"
"	var fMoveCenter = (fMoveBegin + fMoveEnd) * 0.5;\n"
"	fMoveBegin = fMoveCenter - 0.5 * fRange;\n"
"	fMoveEnd = fMoveCenter + 0.5 * fRange;\n"
"	var nOffset;\n"
"	if(nOffsetYDest != nOffsetY)\n"
"		nOffset = nOffsetYDest;\n"
"	ZoomTo(fMoveBegin, fMoveEnd, nOffsetYDest, -1);\n"
"}\n"
"\n"
"function ZoomToRange(R)\n"
"{\n"
"	ZoomTo(R.Begin, R.End, 0, 0, R.Off);\n"
"}\n"
"\n"
"let ZoomCallback = null;\n"
"\n"
"function ZoomTo(fZoomBegin, fZoomEnd, OffsetYDest, ZoomTime, fOffset)\n"
"{\n"
"	if(fZoomBegin < fZoomEnd)\n"
"	{\n"
"		if(fOffset)\n"
"		{\n"
"			fZoomBegin -= fOffset;\n"
"			fZoomEnd -= fOffset;\n"
"		}\n"
"		AnimationActive = true;\n"
"		var fDetailedOffsetOriginal = fDetailedOffset;\n"
"		var fDetailedRangeOriginal = fDeta";

const size_t g_MicroProfileHtml_end_2_size = sizeof(g_MicroProfileHtml_end_2);
const char g_MicroProfileHtml_end_3[] =
"iledRange;\n"
"		var fDetailedOffsetTarget = fZoomBegin;\n"
"		var fDetailedRangeTarget = fZoomEnd - fZoomBegin;\n"
"		var OffsetYOriginal = nOffsetY;\n"
"		var OffsetYTarget = OffsetYDest;\n"
"		var TimestampStart = new Date();\n"
"		var count = 0;\n"
"		if(!ZoomTime)\n"
"		{			\n"
"			ZoomTime = ZOOM_TIME;\n"
"		}\n"
"\n"
"		function ZoomFunc()\n"
"		{\n"
"			ZoomActive = 1;\n"
"			var fPrc = (new Date() - TimestampStart) / (ZoomTime * 1000.0);\n"
"			if(fPrc > 1.0 || ZoomTime < 0.01)\n"
"			{\n"
"				fPrc = 1.0;\n"
"			}\n"
"			fPrc = Math.pow(fPrc, 0.3);\n"
"			fDetailedOffset = fDetailedOffsetOriginal + (fDetailedOffsetTarget - fDetailedOffsetOriginal) * fPrc;\n"
"			fDetailedRange = fDetailedRangeOriginal + (fDetailedRangeTarget - fDetailedRangeOriginal) * fPrc;\n"
"			if(OffsetYDest)\n"
"			{\n"
"				nOffsetY = OffsetYOriginal + (OffsetYTarget - OffsetYOriginal) * fPrc;\n"
"			}\n"
"			if(fPrc >= 1.0)\n"
"			{\n"
"				AnimationActive = false;\n"
"				fDetailedOffset = fDetailedOffsetTarget;\n"
"				fDetailedRange = fDetailedRangeTarget;\n"
"				if(OffsetYDest)\n"
"				{\n"
"					nOffsetY = OffsetYTarget;\n"
"				}\n"
"				ZoomCallback = null;\n"
"			}\n"
"			else\n"
"			{\n"
"				RequestRedraw();\n"
"			}\n"
"			return 1;\n"
"		}\n"
"		ZoomCallback = ZoomFunc;\n"
"		RequestRedraw();\n"
"	}\n"
"}\n"
"\n"
"function RequestAnimationFrame(cb)\n"
"{\n"
"	if(!RedrawRequested)\n"
"	{\n"
"		let RedrawCallback = function(foo)\n"
"		{\n"
"			RedrawRequested = 0;\n"
"			cb(foo);\n"
"		};\n"
"		RedrawRequested = 1;\n"
"		requestAnimationFrame(RedrawCallback);\n"
"	}\n"
"}\n"
"\n"
"function RequestRedraw(FullRedraw)\n"
"{\n"
"	if(!RedrawRequested)\n"
"	{\n"
"		RequestAnimationFrame(Draw);\n"
"	}\n"
"}\n"
"\n"
"function Draw()\n"
"{\n"
"	let RedrawMode = 1;\n"
"	let RedrawAgain = 0;\n"
"	RedrawMode = 1;\n"
"	if(Mode == ModeDetailed)\n"
"	{\n"
"		if(ProfileMode == 2 || ((nHoverCSCpu >= 0 || nHoverToken != -1) && !KeyCtrlDown && !KeyShiftDown && !MouseDragButton)||(Invalidate<2 && !KeyCtrlDown && !KeyShiftDown && !MouseDragButton))\n"
"		{\n"
"			RedrawMode = 1;\n"
"			RedrawAgain = 1;\n"
"		}\n"
"	}\n"
"	else\n"
"	{\n"
"		if(Invalidate < 1)\n"
"		{\n"
"			RedrawMode = 1;\n"
"		}\n"
"	}\n"
"\n"
"	if(!Initialized)\n"
"	{\n"
"		return;\n"
"	}\n"
"	if(InsideDraw)\n"
"	{\n"
"		debugger;\n"
"		return;\n"
"	}\n"
"	let ZoomActive = 0;\n"
"	if(ZoomCallback)\n"
"	{\n"
"		ZoomActive = ZoomCallback();\n"
"	}\n"
"	InsideDraw = 1;\n"
"	if(ProfileMode)\n"
"	{\n"
"		ProfileModeClear();\n"
"		ProfileEnter(\"Total\");\n"
"	}\n"
"\n"
"	if(ZoomActive)\n"
"	{\n"
"		DrawDetailed(true);\n"
"	}\n"
"	else if(RedrawMode == 1)\n"
"	{\n"
"		if(Mode == ModeTimers || Mode == ModeTimers_Threads || Mode == ModeTimers_Groups)\n"
"		{\n"
"			DrawBarView();\n"
"			DrawHoverToolTip();\n"
"		}\n"
"		else if(Mode == ModeDetailed)\n"
"		{\n"
"			console.log(\"DRAWDetailed\");\n"
"			DrawDetailed(false);\n"
"			DrawHoverToolTip();\n"
"		}\n"
"		else if(Mode == ModeCounters)\n"
"		{\n"
"			DrawCounterView();\n"
"			DrawHoverToolTip();\n"
"		}\n"
"	}\n"
"	DrawDetailedFrameHistory();\n"
"	DrawMenu();\n"
"\n"
"\n"
"	if(ProfileMode)\n"
"	{\n"
"		ProfileLeave();\n"
"		ProfileModeDraw(CanvasDetailedView);\n"
"	}\n"
"\n"
"	InsideDraw = 0;\n"
"	if(RedrawAgain)\n"
"	{\n"
"		RequestRedraw();\n"
"	}\n"
"	MouseReleased = false;\n"
"}\n"
"\n"
"function MoveFilterInputMenuDiv(x, y, w)\n"
"{\n"
"	if(FilterInputMenuDivPos.x != x || FilterInputMenuDivPos.y != y || FilterInputMenuDivPos.w != w)\n"
"	{\n"
"		FilterInputMenuDivPos.x = x;\n"
"		FilterInputMenuDivPos.y = y;\n"
"		FilterInputMenuDivPos.w = w;\n"
"		FilterInputMenuDiv.style[\'left\'] = x + \'px\';\n"
"		FilterInputMenuDiv.style[\'top\'] = y + \'px\';\n"
"		FilterInputMenu.style[\'width\'] = w + \'px\';\n"
"	}\n"
"}\n"
"function MoveFilterInputDiv(x, y, w)\n"
"{\n"
"	if(FilterInputDivPos.x != x || FilterInputDivPos.y != y || FilterInputDivPos.w != w)\n"
"	{\n"
"		FilterInputDivPos.x = x;\n"
"		FilterInputDivPos.y = y;\n"
"		FilterInputDivPos.w = w;\n"
"		FilterInputDiv.style[\'left\'] = x + \'px\';\n"
"		FilterInputDiv.style[\'top\'] = (y + (CanvasHistory.height / DPR)) + \'px\';\n"
"		FilterInput.style[\'width\'] = w + \'px\';\n"
"	}\n"
"}\n"
"\n"
"\n"
"function MakeMenuItem(name, f, visible)\n"
"{\n"
"	var Item = {};\n"
"	Item.name = name;\n"
"	Item.f = f;\n"
"	Item.w = name.length;\n"
"	Item.x = 0;\n"
"	Item.y = 0;\n"
"	Item.visible = visible;\n"
"	return Item;\n"
"}\n"
"function EnableMenu(m)\n"
"{\n"
"	if(m != SubMenuActive)\n"
"	{\n"
"		if(SubMenuActive == SubMenuThreads)\n"
"		{\n"
"			FilterInputMenuThreadsValue = FilterInputMenu.value;\n"
"		}\n"
"		else if(SubMenuActive == SubMenuGroups)\n"
"		{\n"
"			FilterInputMenuGroupsValue = FilterInputMenu.value;\n"
"		}\n"
"\n"
"		SubMenuActive = m;\n"
"		SubMenuTimeout = new Date();\n"
"\n"
"		if(SubMenuActive == SubMenuThreads)\n"
"		{\n"
"			FilterInputMenu.value = FilterInputMenuThreadsValue;\n"
"			FilterInputMenu.focus();\n"
"		}\n"
"		else if(SubMenuActive == SubMenuGroups)\n"
"		{\n"
"			FilterInputMenu.value = FilterInputMenuGroupsValue;\n"
"			FilterInputMenu.focus();\n"
"		}\n"
"		FilterInputMenuValueLast = FilterInput.value;\n"
"		// if(m == SubMenuHelp)\n"
"		{\n"
"			let info = document.getElementById(\"divFrameInfo\");\n"
"			info.display = \'inline\';\n"
"		}\n"
"	}\n"
"	if(m == -1)\n"
"	{\n"
"		SubMenuTimeout = 0;\n"
"	}\n"
"	if(SubMenuActive == SubMenuGroups || SubMenuActive == SubMenuThreads)\n"
"	{\n"
"		FilterInputMenuDiv.style[\'display\'] = \'inline\';\n"
"		FilterInputMenu.focus();\n"
"	}\n"
"	else\n"
"	{\n"
"		FilterInputMenuDiv.style[\'display\'] = \'none\';\n"
"	}\n"
"}\n"
"function InitMenu()\n"
"{\n"
"	MenuItems = [];\n"
"	MenuItems.push(MakeMenuItem(\"?\", function(){EnableMenu(SubMenuHelp); } ));\n"
"	MenuItems.push(MakeMenuItem(\"Mode\", function(){EnableMenu(SubMenuMode); } ));\n"
"	MenuItems.push(MakeMenuItem(\"Reference\", function(){EnableMenu(SubMenuReference); } ));\n"
"	MenuItems.push(MakeMenuItem(\"Target\", function(){EnableMenu(SubMenuTarget); } ));\n"
"	MenuItems.push(MakeMenuItem(\"Threads\", function(){ EnableMenu(SubMenuThreads); }, function(){ return Mode != ModeCounters && Mode != ModeTimers_Groups; }));\n"
"	MenuItems.push(MakeMenuItem(\"Groups\", function(){ EnableMenu(SubMenuGroups); }, function() { return Mode != ModeDetailed && Mode != ModeCounters && Mode != ModeTimers_Threads; } ));\n"
"	MenuItems.push(MakeMenuItem(\"Columns\", function(){ EnableMenu(SubMenuColumns); }, function(){return Mode == ModeTimers; }  ));\n"
"	MenuItems.push(MakeMenuItem(\"Options\", function(){ EnableMenu(SubMenuOptions); } ));\n"
"	MenuItems.push(MakeMenuItem(\"Compare\", function(){ EnableMenu(SubMenuCompare); } ));\n"
"}\n"
"function DrawTopMenu(context)\n"
"{\n"
"	MenuItems[SubMenuMode].name = \"Mode[\" + ModeItems[Mode] + \"]\";\n"
"	let X = 2;\n"
"	let Y = 0;\n"
"	let MouseInY = GlobalMouseY < BoxHeight;\n"
"	for(let i = 0; i < MenuItems.length; ++i)\n"
"	{\n"
"		let Item = MenuItems[i];\n"
"		if(Item.visible == null || Item.visible())\n"
"		{\n"
"			let w = context.measureText(Item.name).width + 4;\n"
"			let MouseIn = MouseInY && GlobalMouseX >= X && GlobalMouseX < X + w;\n"
"			let color = MouseIn ? nBackColors[1] : \"black\";\n"
"			Item.x = X;\n"
"			Item.y = Y + BoxHeight;\n"
"			if(MouseIn)\n"
"			{\n"
"				context.fillStyle = \'white\';\n"
"				context.fillRect(X-2, Y, w+4, BoxHeight);\n"
"				// Enable\n"
"				EnableMenu(i);\n"
"			}\n"
"			context.fillStyle = color;\n"
"			context.fillRect(X, Y, w, BoxHeight);\n"
"			context.fillStyle = \"white\";\n"
"			context.fillText(Item.name, X+2, Y+BoxHeight-FontAscent);\n"
"			if(MouseIn && MouseReleased)\n"
"			{\n"
"				Item.f();\n"
"			}\n"
"			X += w + 6;\n"
"		}\n"
"	}\n"
"\n"
"	return WindowRect(0, 0, X, BoxHeight);\n"
"}\n"
"function MenuSize(w)\n"
"{\n"
"	return WindowRect(nWidth / 2 - w / 2, HistoryHeight + 50,w, nHeight);\n"
"}\n"
"function MouseInRect(Rect)\n"
"{\n"
"	return MouseInside(Rect.x, Rect.y, Rect.w, Rect.h);\n"
"}\n"
"function MouseInside(X, Y, W, H)\n"
"{\n"
"	return GlobalMouseX >= X && GlobalMouseX <= X + W && GlobalMouseY >= Y && GlobalMouseY <= Y + H;\n"
"}\n"
"\n"
"function DrawMenuGeneric(Elements, Active, OnClick, x, y, Elements2)\n"
"{\n"
"	let context = CanvasMenu.getContext(\'2d\');\n"
"	let nColorIndex = 0;\n"
"	if(Elements2 && Elements2.length != Elements.length)\n"
"	{\n"
"		Elements2 = null;\n"
"	}\n"
"	let h = FontHeight * Elements.length;\n"
"	let w = 20;\n"
"	let w2 = 0;\n"
"	for(let i = 0; i < Elements.length; ++i)\n"
"	{\n"
"		let m = context.measureText(Elements[i]).width;\n"
"		w = w > m ? w : m;\n"
"		if(Elements2)\n"
"		{\n"
"			m = context.measureText(Elements2[i]).width;\n"
"			w2 = w2 > m ? w2 : m;\n"
"		}\n"
"	}\n"
"	w += 10 + w2;\n"
"	let SizeInfo = MenuSize(w);\n"
"	SizeInfo.x = x;\n"
"	SizeInfo.y = y;\n"
"	let X = x;\n"
"	let Y = y;\n"
"\n"
"\n"
"	for(let i = 0; i < Elements.length; ++i)\n"
"	{\n"
"		let Selected = Active(i);\n"
"		let Name = Elements[i];\n"
"		let bMouseIn = GlobalMouseY >= Y && GlobalMouseY < Y + BoxHeight;\n"
"		let bgcolor = bMouseIn ? nBackColorOffset : nBackColors[nColorIndex];\n"
"		let TextY = Y+BoxHeight-FontAscent;\n"
"		context.fillStyle = Selected?\'white\':bgcolor;\n"
"		context.fillRect(X-2, Y, w+4, BoxHeight);\n"
"		context.fillStyle = bgcolor;\n"
"		context.fillRect(X, Y, w, BoxHeight);\n"
"		context.fillStyle = \'white\';\n"
"		context.fillText(Name, X + 2, TextY);\n"
"		if(Elements2)\n"
"		{\n"
"			context.textAlign = \"right\";\n"
"			context.fillText(Elements2[i], X + w , TextY);\n"
"			context.textAlign = \"left\";\n"
"		}\n"
"		context.fillText(Name, X + 2, TextY);\n"
"		if(bMouseIn && MouseReleased)\n"
"		{\n"
"			OnClick(i, Name);\n"
"		}\n"
"		Y += BoxHeight;\n"
"		nColorIndex = 1-nColorIndex;\n"
"	}\n"
"	SizeInfo.h = Y - SizeInfo.y;\n"
"	return SizeInfo;\n"
"}\n"
"\n"
"function DrawMenuReference()\n"
"{\n"
"	let Names = [];\n"
"	let ActiveIdx = 0;\n"
"	for(let i in ReferenceTimes)\n"
"	{\n"
"		let v = ReferenceTimes[i];\n"
"		if(v < 0)\n"
"		{\n"
"			Names.push(ReferenceTimeAutoString);\n"
"		}\n"
"		else\n"
"		{\n"
"			if(ReferenceTime == ReferenceTimes[i])\n"
"			{\n"
"				ActiveIdx = i;\n"
"			}\n"
"			Names.push(v + \"ms\");\n"
"		}\n"
"	}\n"
"	let Click = function(idx, name)\n"
"	{\n"
"		SetReferenceTime(Names[idx]);\n"
"		RequestRedraw();\n"
"		Invalidate = 0;\n"
"\n"
"	};\n"
"	let x = MenuItems[SubMenuReference].x;\n"
"	let y = MenuItems[SubMenuReference].y;\n"
"	let Active = function(Idx) { return ActiveIdx == Idx; };\n"
"	return DrawMenuGeneric(Names, Active, Click, x, y, null);\n"
"}\n"
"function DrawMenuTarget()\n"
"{\n"
"	let Names = [];\n"
"	for(let i in TargetTimes)\n"
"	{\n"
"		Names.push(TargetTimes[i] + \"ms\");\n"
"	}\n"
"	let Click = function(idx, name)\n"
"	{\n"
"		SetTargetTime(Names[idx]);\n"
"		RequestRedraw();\n"
"		Invalidate = 0;\n"
"\n"
"	};\n"
"	let x = MenuItems[SubMenuTarget].x;\n"
"	let y = MenuItems[SubMenuTarget].y;\n"
"	let Active = function(Idx) { return TargetTimes[Idx] == TargetTime; };\n"
"	return DrawMenuGeneric(Names, Active, Click, x, y, null);\n"
"}\n"
"\n"
"function DrawMenuMode()\n"
"{\n"
"	let Click = function(idx, name)\n"
"	{\n"
"		SetMode(idx,false);\n"
"		MenuItems[SubMenuMode].name = \"Mode[\" + ModeItems[idx] + \"]\";\n"
"		RequestRedraw();\n"
"		Invalidate = 0;\n"
"\n"
"	};\n"
"	let x = MenuItems[SubMenuMode].x;\n"
"	let y = MenuItems[SubMenuMode].y;\n"
"	let Active = function(Idx) { return Idx == Mode; };\n"
"	return DrawMenuGeneric(ModeItems, Active, Click, x, y, null);\n"
"}\n"
"function DrawMenuOptions()\n"
"{\n"
"	let OptionNames =[\"Context Switch\", \"MergeDisable\", \"LodDisable\", \"Flame Mode\", \"Compare Reverse\", \"Help\"];\n"
"	let Click = function(idx, name)\n"
"	{\n"
"		switch(idx)\n"
"		{\n"
"			case 0: ToggleContextSwitch(); break;\n"
"			case 1: ToggleDisableMerge(); break;\n"
"			case 2: ToggleDisableLod(); break;\n"
"			case 3: ToggleDetailedFlameMode(); break;\n"
"			case 4: ToggleDetailedSecondReverse(); break;\n"
"			case 5: ShowHelp(1,1); break;\n"
"		}\n"
"		RequestRedraw();\n"
"		Invalidate = 0;\n"
"\n"
"	};\n"
"	let x = MenuItems[SubMenuOptions].x;\n"
"	let y = MenuItems[SubMenuOptions].y;\n"
"	let Active = function(Idx) { return false; };\n"
"	return DrawMenuGeneric(OptionNames, Active, Click, x, y, null);\n"
"}\n"
"\n"
"function DrawMenuColumns()\n"
"{\n"
"	let Click = function(idx, name)\n"
"	{\n"
"		ToggleColumn(idx);\n"
"\n"
"	};\n"
"	let x = MenuItems[SubMenuColumns].x;\n"
"	let y = MenuItems[SubMenuColumns].y;\n"
"	let Active = function(Idx) { return ColumnsEnabled[Idx]; };\n"
"	return DrawMenuGeneric(ColumnNames, Active, Click, x, y, null);\n"
"\n"
"}\n"
"\n"
"function GroupMenuSize()\n"
"{\n"
"	return MenuSize(300);\n"
"}\n"
"\n"
"function ThreadMenuSize()\n"
"{\n"
"	return MenuSize(S.ThreadNameWidth + S.ThreadCategoryWidth + 10);\n"
"}\n"
"\n"
"function DrawMultiMenu(context, X, Y, W, Elements, Callbacks)\n"
"{\n"
"	let A = Array();\n"
"	let wtemp = W;\n"
"	let bMouseIn = GlobalMouseY >= Y && GlobalMouseY < Y + BoxHeight;\n"
"\n"
"	for(let i = 0; i < Elements.length; ++i)\n"
"	{\n"
"		let wElement = context.measureText(Elements[i]).width;\n"
"		if(i > 0)\n"
"		{\n"
"			wElement += 15;\n"
"			wtemp -= wElement;\n"
"		}\n"
"		A.push(wElement);\n"
"	}\n"
"	A[0] = Math.max(wtemp, 0);\n"
"\n"
"	context.fillStyle = nBackColors[0];\n"
"	context.fillRect(X-2, Y, W, BoxHeight);\n"
"	let XOff = 0;\n"
"	let TextY = Y+BoxHeight-FontAscent;\n"
"	for(let i = 0; i < Elements.length; ++i)\n"
"	{\n"
"		let width = A[i];\n"
"		let Inside = i != 0 && bMouseIn && GlobalMouseX > XOff + X && GlobalMouseX <= XOff + X + width;\n"
"		context.fillStyle = Inside ? nBackColorOffset : nBackColors[0];\n"
"		context.fillRect(X+XOff, Y, width, BoxHeight);\n"
"		context.fillStyle = \'white\';\n"
"		context.textAlign = \'center\';\n"
"		context.fillText(Elements[i], X+XOff + width * 0.5, TextY);\n"
"		XOff += width;\n"
"		if(Inside && MouseReleased && Callbacks[i])\n"
"		{\n"
"			Callbacks[i]();\n"
"		}\n"
"	}\n"
"	context.textAlign = \'left\';\n"
"}\n"
"\n"
"function DrawMenuThreads()\n"
"{\n"
"	if(FilterInputMenuValueLast != FilterInputMenu.value)\n"
"	{\n"
"		nOffsetMenuThreads = 0;\n"
"	}\n"
"	FilterInputMenuValueLast = FilterInputMenu.value;\n"
"	let FilterArray = CreateFilter(FilterInputMenu.value);\n"
"	let context = CanvasMenu.getContext(\'2d\');\n"
"	let nColorIndex = 0;\n"
"	let SizeInfo = ThreadMenuSize();\n"
"	SizeInfo.x = MenuItems[SubMenuThreads].x;\n"
"	SizeInfo.y = MenuItems[SubMenuThreads].y;\n"
"	let Y = SizeInfo.y;\n"
"	let Width = SizeInfo.w;\n"
"	let Selection = null;\n"
"	let X = SizeInfo.x;\n"
"	MoveFilterInputMenuDiv(SizeInfo.x, SizeInfo.y, SizeInfo.w);\n"
"	Y += 35;\n"
"\n"
"	let bMouseIn = GlobalMouseY >= Y && GlobalMouseY < Y + BoxHeight;\n"
"	let bgcolor = bMouseIn ? nBackColorOffset : nBackColors[nColorIndex];\n"
"	let TextY = Y+BoxHeight-FontAscent;\n"
"	let YClear = Y;\n"
"	let TextYClear = TextY;\n"
"	let YStart = Y;\n"
"	let MatchCount = 0;\n"
"	let MouseTaken = bMouseIn;\n"
"\n"
"	Y += BoxHeight * 3;\n"
"	nColorIndex = 1-nColorIndex;\n"
"\n"
"	Y -= nOffsetMenuThreads;\n"
"\n"
"	for(let i = 0; i < S.ThreadNames.length; ++i)\n"
"	{\n"
"		let Name = S.ThreadNames[i];\n"
"		let ParentName = \"ThreadCategory\";\n"
"		if(FilterMatch(FilterArray, ParentName + \" \" + Name))\n"
"		{\n"
"			if(Y > YStart)\n"
"			{\n"
"				var ParentColor = \'white\';\n"
"				let E =	ThreadsActive[Name];\n"
"				bMouseIn = GlobalMouseY >= Y && GlobalMouseY < Y + BoxHeight && !MouseTaken;\n"
"				bgcolor = bMouseIn ? nBackColorOffset : nBackColors[nColorIndex];\n"
"				TextY = Y+BoxHeight-FontAscent;\n"
"				context.fillStyle = E ? \'white\' :bgcolor;\n"
"				context.fillRect(X-2, Y, Width+4, BoxHeight);\n"
"				context.fillStyle = bgcolor;\n"
"				context.fillRect(X, Y, Width, BoxHeight);\n"
"				context.fillStyle = ParentColor;\n"
"				context.fillText(ParentName, X + 2, TextY);\n"
"				context.fillStyle = S.ThreadColors[i].color;//thread color her....\n"
"				context.textAlign = \'right\';\n"
"				context.fillText(Name, X + Width - 2, TextY);\n"
"				context.textAlign = \'left\';\n"
"				if(bMouseIn && MouseReleased)\n"
"				{\n"
"					ToggleThread(Name);\n"
"					RequestRedraw();\n"
"				}\n"
"			}\n"
"			Y += BoxHeight;\n"
"			nColorIndex = 1-nColorIndex;\n"
"			MatchCount++;\n"
"		}\n"
"	}\n"
"	let TextAll = \"All [\" + S.ThreadNames.length + \"]\";\n"
"	let TextFiltered = \"Filtered [\" + MatchCount +\"]\";\n"
"\n"
"\n"
"\n"
"	let ElementsAll = [TextAll, \"Off\", \"Flip\", \"On\"];\n"
"	let CallbacksAll = [null, \n"
"		function(){ ToggleThread(0, 1, 0, 0); },\n"
"		function(){ ToggleThread(0, 1, 0, 1); },\n"
"		function(){ ToggleThread(0, 1, 0, 2); },\n"
"	];\n"
"	let ElementsFiltered = [TextFiltered, \"Off\", \"Flip\", \"On\"];\n"
"	let CreateFilteredArray = function()\n"
"	{\n"
"		if(!FilterArray) return S.ThreadNames;\n"
"		let A = [];\n"
"		for(let i = 0; i < S.ThreadNames.length; ++i)\n"
"		{\n"
"			let Name = S.ThreadNames[i];\n"
"			let ParentName = \"ThreadCategory\";\n"
"			if(FilterMatch(FilterArray, ParentName + \" \" + Name))\n"
"			{\n"
"				A.push(Name);\n"
"			}\n"
"		}\n"
"		return A;\n"
"	};\n"
"	let CallbacksFiltered = [null, \n"
"		function(){let F = CreateFilteredArray(); ToggleThread(0, 0, F, 0); },\n"
"		function(){let F = CreateFilteredArray(); ToggleThread(0, 0, F, 1); },\n"
"		function(){let F = CreateFilteredArray(); ToggleThread(0, 0, F, 2); },\n"
"	];\n"
"	let ElementsOptions = [\"Hide mode\", HideMode ? \"Collapsed\" : \"Invisible\"];\n"
"	let CallbacksOptions = [ null, function(){ HideMode = !HideMode; }];\n"
"\n"
"	DrawMultiMenu(context, X, YClear, Width, ElementsOptions, CallbacksOptions);\n"
"	YClear += BoxHeight;\n"
"	DrawMultiMenu(context, X, YClear, Width, ElementsAll, CallbacksAll);\n"
"	YClear += BoxHeight;\n"
"	DrawMultiMenu(context, X, YClear, Width, ElementsFiltered, CallbacksFiltered);\n"
"\n"
"	SizeInfo.h = Y-SizeInfo.y;\n"
"	return SizeInfo;\n"
"}\n"
"\n"
"function DrawMenuGroups()\n"
"{\n"
"	if(FilterInputMenuValueLast != FilterInputMenu.value)\n"
"	{\n"
"		nOffsetMenuThreads = 0;\n"
"	}\n"
"	FilterInputMenuValueLast = FilterInputMenu.value;\n"
"	let FilterArray = CreateFilter(FilterInputMenu.value);\n"
"	let context = CanvasMenu.getContext(\'2d\');\n"
"	let nColorIndex = 0;\n"
"	let SizeInfo = ThreadMenuSize();\n"
"	SizeInfo.x = MenuItems[SubMenuGroups].x;\n"
"	SizeInfo.y = MenuItems[SubMenuGroups].y;\n"
"	let Y = SizeInfo.y;\n"
"	let Width = SizeInfo.w;\n"
"	let Selection = null;\n"
"	let X = SizeInfo.x;\n"
"	MoveFilterInputMenuDiv(SizeInfo.x, SizeInfo.y, SizeInfo.w);\n"
"	Y += 35;\n"
"\n"
"	let bMouseIn = GlobalMouseY >= Y && GlobalMouseY < Y + BoxHeight;\n"
"	let bgcolor = bMouseIn ? nBackColorOffset : nBackColors[nColorIndex];\n"
"	let TextY = Y+BoxHeight-FontAscent;\n"
"	let YClear = Y;\n"
"	let TextYClear = TextY;\n"
"	let YStart = Y;\n"
"	let MatchCount = 0;\n"
"	let MouseTaken = bMouseIn;\n"
"\n"
"	Y += BoxHeight * 2;\n"
"	nColorIndex = 1-nColorIndex;\n"
"\n"
"	Y -= nOffsetMenuThreads;\n"
"\n"
"\n"
"\n"
"	for(var i = 0; i < S.GroupInfo.length; ++i)\n"
"	{\n"
"		let Name = S.GroupInfo[i].name;\n"
"		let ParentName = S.CategoryInfo[S.GroupInfo[i].category];\n"
"		let Color = g_Colors[ S.GroupInfo[i].cid ];\n"
"		if(FilterMatch(FilterArray, ParentName + \" \" + Name))\n"
"		{\n"
"			if(Y > YStart)\n"
"			{\n"
"				var ParentColor = \'white\';\n"
"				let E =	!GroupsDisabled[Name];\n"
"				bMouseIn = GlobalMouseY >= Y && GlobalMouseY < Y + BoxHeight && !MouseTaken;\n"
"				bgcolor = bMouseIn ? nBackColorOffset : nBackColors[nColorIndex];\n"
"				TextY = Y+BoxHeight-FontAscent;\n"
"				context.fillStyle = E ? \'white\' :bgcolor;\n"
"				context.fillRect(X-2, Y, Width+4, BoxHeight);\n"
"				context.fillStyle = bgcolor;\n"
"				context.fillRect(X, Y, Width, BoxHeight);\n"
"				context.fillStyle = ParentColor;\n"
"				context.fillText(ParentName, X + 2, TextY);\n"
"				context.fillStyle = Color;\n"
"				context.textAlign = \'right\';\n"
"				context.fillText(Name, X + Width - 2, TextY);\n"
"				context.textAlign = \'left\';\n"
"				if(bMouseIn && MouseReleased)\n"
"				{\n"
"					ToggleGroup(Name);\n"
"					RequestRedraw();\n"
"				}\n"
"			}\n"
"			Y += BoxHeight;\n"
"			nColorIndex = 1-nColorIndex;\n"
"			MatchCount++;\n"
"		}\n"
"	}\n"
"	let TextAll = \"All [\" + S.GroupInfo.length + \"]\";\n"
"	let TextFiltered = \"Filtered [\" + MatchCount +\"]\";\n"
"\n"
"\n"
"\n"
"	let ElementsAll = [TextAll, \"Off\", \"Flip\", \"On\"];\n"
"	let CallbacksAll = [null, \n"
"		function(){ ToggleGroup(0, 1, 0, 0); },\n"
"		function(){ ToggleGroup(0, 1, 0, 1); },\n"
"		function(){ ToggleGroup(0, 1, 0, 2); },\n"
"	];\n"
"	let ElementsFiltered = [TextFiltered, \"Off\", \"Flip\", \"On\"];\n"
"	let CreateFilteredArray = function()\n"
"	{\n"
"		let A = [];\n"
"		for(let i = 0; i < S.GroupInfo.length; ++i)\n"
"		{\n"
"			let Name = S.GroupInfo[i].name;\n"
"			let ParentName = S.CategoryInfo[S.GroupInfo[i].category];\n"
"			if(FilterMatch(FilterArray, ParentName + \" \" + Name))\n"
"			{\n"
"				A.push(Name);\n"
"			}\n"
"		}\n"
"		return A;\n"
"	};\n"
"	let CallbacksFiltered = [null, \n"
"		function(){let F = CreateFilteredArray(); ToggleGroup(0, 0, F, 0); },\n"
"		function(){let F = CreateFilteredArray(); ToggleGroup(0, 0, F, 1); },\n"
"		function(){let F = CreateFilteredArray(); ToggleGroup(0, 0, F, 2); },\n"
"	];\n"
"\n"
"\n"
"	DrawMultiMenu(context, X, YClear, Width, ElementsAll, CallbacksAll);\n"
"	DrawMultiMenu(context, X, YClear+BoxHeight, Width, ElementsFiltered, CallbacksFiltered);\n"
"\n"
"	SizeInfo.h = Y-SizeInfo.y;\n"
"	return SizeInfo;\n"
"\n"
"\n"
"}\n"
"\n"
"function DrawMenu()\n"
"{\n"
"	MenuRedraw = 0;\n"
"\n"
"	var context = CanvasMenu.getContext(\'2d\');\n"
"	context.clearRect(0, 0, CanvasMenu.width, CanvasMenu.height);\n"
"\n"
"	var nColorIndex = 0;\n"
"	var Y = 50;\n"
"	var Width = 300;\n"
"	var Selection = null;\n"
"\n"
"	ProfileEnter(\"DrawMenu\");\n"
"	let MenuRect = DrawTopMenu(context);\n"
"	if(SubMenuActive != -1)\n"
"	{\n"
"		MouseMoveTime = new Date();\n"
"	}\n"
"	if(SubMenuActive == SubMenuHelp)\n"
"	{\n"
"		if(MouseReleased)\n"
"		{\n"
"			ToggleDebugMode();\n"
"		}\n"
"	}\n"
"	if(SubMenuActive == SubMenuMode)\n"
"	{\n"
"		MenuRect = DrawMenuMode();\n"
"	}\n"
"	else if(SubMenuActive == SubMenuReference)\n"
"	{\n"
"		MenuRect = DrawMenuReference();\n"
"	}\n"
"	else if(SubMenuActive == SubMenuTarget)\n"
"	{\n"
"		MenuRect = DrawMenuTarget();\n"
"	}\n"
"	else if(SubMenuActive == SubMenuThreads)\n"
"	{\n"
"		MenuRect = DrawMenuThreads();\n"
"	}\n"
"	else if(SubMenuActive == SubMenuGroups)\n"
"	{\n"
"		MenuRect = DrawMenuGroups();\n"
"	}\n"
"	else if(SubMenuActive == SubMenuOptions)\n"
"	{\n"
"		MenuRect = DrawMenuOptions();\n"
"	}\n"
"	else if(SubMenuActive == SubMenuCompare)\n"
"	{\n"
"		if(MouseReleased)\n"
"		{\n"
"			ComparePrompt();\n"
"		}\n"
"	}\n"
"	else if(SubMenuActive == SubMenuColumns)\n"
"	{\n"
"		MenuRect = DrawMenuColumns();\n"
"	}\n"
"	var Grow = 10;\n"
"	MenuRect.x -= Grow;\n"
"	MenuRect.y -= Grow;\n"
"	MenuRect.h += 2*Grow;\n"
"	MenuRect.w += 2*Grow;\n"
"	var MouseMoved = GlobalMouseX != SubMenuMouseX || GlobalMouseY != SubMenuMouseY;\n"
"\n"
"	if(MouseInRect(MenuRect) || !MouseMoved)\n"
"	{\n"
"		SubMenuTimeout = new Date();\n"
"		SubMenuMouseX = GlobalMouseX;\n"
"		SubMenuMouseY = GlobalMouseY;\n"
"	}\n"
"	else\n"
"	{\n"
"		var Time = new Date() - SubMenuTimeout;\n"
"		var Dest = SubMenuTimeoutBase * 1000;\n"
"		if(Time > Dest)\n"
"		{\n"
"			EnableMenu(-1);\n"
"		}\n"
"	}\n"
"	if(0)//debugging of menu extents. dont delete\n"
"	{\n"
"		context.strokeStyle = \'red\';\n"
"		context.beginPath();\n"
"		context.moveTo(MenuRect.x,MenuRect.y);\n"
"		context.lineTo(MenuRect.x + MenuRect.w,MenuRect.y);\n"
"		context.lineTo(MenuRect.x + MenuRect.w,MenuRect.y+MenuRect.h);\n"
"		context.lineTo(MenuRect.x,MenuRect.y+MenuRect.h);\n"
"		context.lineTo(MenuRect.x,MenuRect.y);\n"
"		context.stroke();\n"
"	}	// SpinnerDraw(SpinnerShow(), context, SpinnerCorner, 0, nHeight-20,  20, 20);\n"
"	ProfileLeave();\n"
"}\n"
"\n"
"\n"
"function ZoomGraph(nZoom)\n"
"{\n"
"	var fOldRange = fDetailedRange;\n"
"	if(nZoom>0)\n"
"	{\n"
"		fDetailedRange *= Math.pow(nModDown ? 1.40 : 1.03, nZoom);\n"
"	}\n"
"	else\n"
"	{\n"
"		var fNewDetailedRange = fDetailedRange / Math.pow((nModDown ? 1.40 : 1.03), -nZoom);\n"
"		if(fNewDetailedRange < 0.0001) //100ns\n"
"			fNewDetailedRange = 0.0001;\n"
"		fDetailedRange = fNewDetailedRange;\n"
"	}\n"
"\n"
"	var fDiff = fOldRange - fDetailedRange;\n"
"	var fMousePrc = DetailedViewMouseX / nWidth;\n"
"	if(fMousePrc < 0)\n"
"	{\n"
"		fMousePrc = 0;\n"
"	}\n"
"	fDetailedOffset += fDiff * fMousePrc;\n"
"\n"
"}\n"
"\n"
"function MeasureFont()\n"
"{\n"
"	var context = CanvasDetailedView.getContext(\'2d\');\n"
"	context.font = Font;\n"
"	FontWidth = context.measureText(\'W\').width;\n"
"\n"
"}\n"
"function ResizeCanvas() \n"
"{\n"
"	nWidth = window.innerWidth;\n"
"	nHeight = window.innerHeight - CanvasHistory.height-2;\n"
"	DPR = window.devicePixelRatio;\n"
"\n"
"	if(DPR)\n"
"	{\n"
"		CanvasDetailedView.style.width = nWidth + \'px\'; \n"
"		CanvasDetailedView.style.height = nHeight + \'px\';\n"
"		CanvasDetailedView.width = nWidth * DPR;\n"
"		CanvasDetailedView.height = nHeight * DPR;\n"
"		CanvasHistory.style.width = window.innerWidth + \'px\';\n"
"		CanvasHistory.style.height = 70 + \'px\';\n"
"		CanvasHistory.width = window.innerWidth * DPR;\n"
"		CanvasHistory.height = 70 * DPR;\n"
"		CanvasMenu.style.width = window.innerWidth + \'px\';\n"
"		CanvasMenu.style.height = window.innerHeight + \'px\';\n"
"		CanvasMenu.width = window.innerWidth * DPR;\n"
"		CanvasMenu.height = window.innerHeight * DPR;\n"
"		CanvasHistory.getContext(\'2d\').scale(DPR,DPR);\n"
"		CanvasDetailedView.getContext(\'2d\').scale(DPR,DPR);\n"
"		CanvasMenu.getContext(\'2d\').scale(DPR,DPR);\n"
"\n"
"		CanvasDetailedOffscreen.style.width = nWidth + \'px\';\n"
"		CanvasDetailedOffscreen.style.height = nHeight + \'px\';\n"
"		CanvasDetailedOffscreen.width = nWidth * DPR;\n"
"		CanvasDetailedOffscreen.height = nHeight * DPR;\n"
"		CanvasDetailedOffscreen.getContext(\'2d\').scale(DPR,DPR);\n"
"\n"
"	}\n"
"	else\n"
"	{\n"
"		DPR = 1;\n"
"		CanvasDetailedView.width = nWidth;\n"
"		CanvasDetailedView.height = nHeight;\n"
"		CanvasDetailedOffscreen.width = nWidth;\n"
"		CanvasDetailedOffscreen.height = nHeight;\n"
"\n"
"		CanvasMenu.width = window.innerWidth;\n"
"		CanvasMenu.height = window.innerHeight;\n"
"		CanvasHistory.width = window.innerWidth;\n"
"	}\n"
"	RequestRedraw();\n"
"}\n"
"\n"
"\n"
"var MouseDragOff = 0;\n"
"var MouseDragDown = 1;\n"
"var MouseDragUp = 2;\n"
"var MouseDragMove = 3;\n"
"var MouseDragState = MouseDragOff;\n"
"var MouseDragTarget = 0;\n"
"var MouseDragButton = 0;\n"
"var MouseDragButtonNext = 0;\n"
"var MouseDragKeyShift = 0;\n"
"var MouseDragKeyCtrl = 0;\n"
"var MouseDragKeyAlt = 0;\n"
"var MouseDragX = 0;\n"
"var MouseDragY = 0;\n"
"var MouseDragXLast = 0;\n"
"var MouseDragYLast = 0;\n"
"var MouseDragXStart = 0;\n"
"var MouseDragYStart = 0;\n"
"\n"
"function clamp(number, min, max)\n"
"{\n"
"  return Math.max(min, Math.min(number, max));\n"
"}\n"
"\n"
"function MouseDragPan()\n"
"{\n"
"	return MouseDragButton == 1 || MouseDragKeyShift || MouseDragKeyAlt;\n"
"}\n"
"function MouseDragSelectRange()\n"
"{\n"
"	return MouseDragState == MouseDragMove && (MouseDragButton == 3 || (MouseDragKeyShift && MouseDragKeyCtrl));\n"
"}\n"
"function MouseHandleDrag()\n"
"{\n"
"	if(MouseDragTarget == CanvasDetailedView)\n"
"	{\n"
"		if(Mode == ModeDetailed)\n"
"		{\n"
"\n"
"			if(FilterSearchActive)\n"
"			{\n"
"				if(MouseDragKeyShift || MouseDragButton == 1)\n"
"				{\n"
"					var Y = MouseDragY - MouseDragYLast;\n"
"					nOffsetFilterSearch -= Y;\n"
"					if(nOffsetFilterSearch < 0)\n"
"					{\n"
"						nOffsetFilterSearch = 0;\n"
"					}\n"
"				}\n"
"			}\n"
"			else\n"
"			{\n"
"				if(MouseDragSelectRange())\n"
"				{\n"
"					var xStart = MouseDragXStart;\n"
"					var xEnd = MouseDragX;\n"
"					if(xStart > xEnd)\n"
"					{\n"
"						var Temp = xStart;\n"
"						xStart = xEnd;\n"
"						xEnd = Temp;\n"
"					}\n"
"					if(xEnd - xStart > 1)\n"
"					{\n"
"						RangeCpu.Begin = fDetailedOffset + fDetailedRange * (xStart / nWidth);\n"
"						RangeCpu.End = fDetailedOffset + fDetailedRange * (xEnd / nWidth);\n"
"						RangeSelect.Begin = fDetailedOffset + fDetailedRange * (xStart / nWidth);\n"
"						RangeSelect.End = fDetailedOffset + fDetailedRange * (xEnd / nWidth);\n"
"						RangeSelect.Thread = -1;\n"
"						RangeSelect.Index = -1;\n"
"					}\n"
"				}\n"
"				else if(MouseDragPan())\n"
"				{\n"
"					var X = MouseDragX - MouseDragXLast;\n"
"					var Y = MouseDragY - MouseDragYLast;\n"
"					if(X)\n"
"					{\n"
"						if(MouseDragKeyAlt)\n"
"						{\n"
"							fDetailedOffsetSecond += -X * fDetailedRange / nWidth;\n"
"						}\n"
"						else\n"
"						{\n"
"							fDetailedOffset += -X * fDetailedRange / nWidth;\n"
"						}\n"
"					}\n"
"					if(!MouseDragKeyAlt)\n"
"					{						\n"
"						nOffsetY -= Y;\n"
"					}\n"
"					if(nOffsetY < 0)\n"
"					{\n"
"						nOffsetY = 0;\n"
"					}\n"
"				}\n"
"				else if(MouseDragKeyCtrl)\n"
"				{\n"
"					if(MouseDragY != MouseDragYLast)\n"
"					{\n"
"						ZoomGraph(MouseDragY - MouseDragYLast);\n"
"					}\n"
"				}\n"
"			}	\n"
"		}\n"
"		else if(Mode == ModeTimers || Mode == ModeTimers_Threads || Mode == ModeTimers_Groups)\n"
"		{\n"
"			if(MouseDragKeyShift || MouseDragButton == 1)\n"
"			{\n"
"				var X = MouseDragX - MouseDragXLast;\n"
"				var Y = MouseDragY - MouseDragYLast;\n"
"				nOffsetBarsY -= Y;\n"
"				nOffsetBarsX -= X;\n"
"				if(nOffsetBarsY < 0)\n"
"				{\n"
"					nOffsetBarsY = 0;\n"
"				}\n"
"				if(nOffsetBarsX < 0)\n"
"				{\n"
"					nOffsetBarsX = 0;\n"
"				}\n"
"			}\n"
"		}\n"
"		else if(Mode == ModeCounters)\n"
"		{\n"
"			if(MouseDragKeyShift || MouseDragButton == 1)\n"
"			{\n"
"				var Y = MouseDragY - MouseDragYLast;\n"
"				nOffsetCountersY -= Y;\n"
"				if(nOffsetCountersY < 0)\n"
"				{\n"
"					nOffsetCountersY = 0;\n"
"				}\n"
"			}\n"
"		}\n"
"\n"
"	}\n"
"	else if(MouseDragTarget == CanvasHistory)\n"
"	{\n"
"		function HistoryFrameTime(x)\n"
"		{\n"
"			var NumFrames = S.Frames.length;\n"
"			var fBarWidth = nWidth / NumFrames;\n"
"			var Index = clamp(Math.floor(NumFrames * x / nWidth), 0, NumFrames-1);\n"
"			var Lerp = clamp((x/fBarWidth - Index) , 0, 1);\n"
"			var time = S.Frames[Index].framestart + (S.Frames[Index].frameend - S.Frames[Index].framestart) * Lerp;\n"
"			return time;\n"
"		}\n"
"		if(MouseDragSelectRange())\n"
"		{\n"
"			RangeCpu = RangeInit();\n"
"			RangeGpu = RangeInit();\n"
"\n"
"			var xStart = MouseDragXStart;\n"
"			var xEnd = MouseDragX;\n"
"			if(xStart > xEnd)\n"
"			{\n"
"				var Temp = xStart;\n"
"				xStart = xEnd;\n"
"				xEnd = Temp;\n"
"			}\n"
"			if(xEnd - xStart > 2)\n"
"			{\n"
"				var timestart = HistoryFrameTime(xStart);\n"
"				var timeend = HistoryFrameTime(xEnd);\n"
"				fDetailedOffset = timestart;\n"
"				fDetailedRange = timeend-timestart;\n"
"			}\n"
"		}\n"
"		else if(MouseDragPan())\n"
"		{\n"
"			var Time = HistoryFrameTime(MouseDragX);\n"
"			fDetailedOffset = Time - fDetailedRange / 2.0;\n"
"		}\n"
"	}\n"
"}\n"
"function MouseHandleDragEnd()\n"
"{\n"
"	if(MouseDragTarget == CanvasDetailedView)\n"
"	{\n"
"\n"
"	}\n"
"	else if(MouseDragTarget == CanvasHistory)\n"
"	{\n"
"		if(!MouseDragSelectRange() && !MouseDragPan())\n"
"		{\n"
"			ZoomToHighlight(1);\n"
"		}\n"
"	}\n"
"}\n"
"\n"
"function MouseHandleDragClick()\n"
"{\n"
"	if(MouseDragTarget == CanvasDetailedView)\n"
"	{\n"
"		if(Mode == ModeCounters)\n"
"		{\n"
"			if(nHoverCounter != -1)\n"
"			{\n"
"				if(S.CounterInfo[nHoverCounter].firstchild != -1)\n"
"				{\n"
"					S.CounterInfo[nHoverCounter].closed = !S.CounterInfo[nHoverCounter].closed;\n"
"				}\n"
"				else\n"
"				{\n"
"					S.CounterInfo[nHoverCounter].Expanded = !S.CounterInfo[nHoverCounter].Expanded;\n"
"				}\n"
"				Draw(1);\n"
"			}\n"
"		}\n"
"		else if(Mode == ModeDetailed && FilterSearchSelection >= 0)\n"
"		{\n"
"			FilterInputCommit();\n"
"		}\n"
"		else\n"
"		{\n"
"			if(DetailedMouseEvent)\n"
"			{\n"
"				DetailedMouseEvent.E();\n"
"			}\n"
"			else if(!DetailedMouseOverButton)\n"
"			{\n"
"				ZoomToHighlight();\n"
"			}\n"
"		}\n"
"	}\n"
"	else if(MouseDragTarget == CanvasHistory)\n"
"	{\n"
"		if(Mode == ModeDetailed)\n"
"		{\n"
"			ZoomToHighlight(1);\n"
"		}\n"
"	}\n"
"}\n"
"\n"
"function MapMouseButton(event)\n"
"{\n"
"	if(event.button == 1 || event.which == 1)\n"
"	{\n"
"		return 1;\n"
"	}\n"
"	else if(event.button == 3 || event.which == 3)\n"
"	{\n"
"		return 3;\n"
"	}\n"
"	else\n"
"	{\n"
"		return 0;\n"
"	}\n"
"}\n"
"\n"
"function MouseDragIsActive()\n"
"{\n"
"	return MouseDragState != MouseDragOff && MouseDragState != MouseDragDown;\n"
"}\n"
"function MouseDragReset()\n"
"{\n"
"	MouseDragState = MouseDragOff;\n"
"	MouseDragTarget = 0;\n"
"	MouseDragKeyShift = 0;\n"
"	MouseDragKeyCtrl = 0;\n"
"	MouseDragKeyAlt = 0;\n"
"	MouseDragButton = 0;\n"
"}\n"
"function MouseDragKeyUp()\n"
"{\n"
"	if((MouseDragKeyShift && !KeyShiftDown) || (MouseDragKeyCtrl && !KeyCtrlDown) || (MouseDragKeyAlt && !KeyAltDown) || SubMenuActive != -1)\n"
"	{\n"
"		MouseHandleDragEnd();\n"
"		MouseDragReset();\n"
"	}\n"
"}\n"
"function MouseDrag(Source, Event)\n"
"{\n"
"	if(Source == MouseDragOff || (MouseDragTarget && MouseDragTarget != Event.target) || SubMenuActive != -1)\n"
"	{\n"
"		MouseDragReset();\n"
"		return;\n"
"	}\n"
"	if(G_DEBUG)\n"
"	{\n"
"		debugger;\n"
"	}\n"
"	var LocalRect = Event.target.getBoundingClientRect();\n"
"	MouseDragX = Event.clientX - LocalRect.left;\n"
"	MouseDragY = Event.clientY - LocalRect.top;\n"
"	if(MouseDragState == MouseDragMove)\n"
"	{\n"
"		var dx = Math.abs(MouseDragX - MouseDragXStart);\n"
"		var dy = Math.abs(MouseDragY - MouseDragYStart);\n"
"		if((Source == MouseDragUp && MapMouseButton(Event) == MouseDragButton) ||\n"
"			(MouseDragKeyCtrl && !KeyCtrlDown) ||\n"
"			(MouseDragKeyShift && !KeyShiftDown) ||\n"
"			(MouseDragKeyAlt && !KeyAltDown))\n"
"		{\n"
"			MouseHandleDragEnd();\n"
"			MouseDragReset();\n"
"			return;\n"
"		}\n"
"		else\n"
"		{\n"
"			MouseHandleDrag();\n"
"		}\n"
"	}\n"
"	else if(MouseDragState == MouseDragOff)\n"
"	{\n"
"		if(Source == MouseDragDown || KeyShiftDown || KeyCtrlDown|| KeyAltDown)\n"
"		{\n"
"			MouseDragTarget = Event.target;\n"
"			MouseDragButton = MapMouseButton(Event);\n"
"			MouseDragState = MouseDragDown;\n"
"			MouseDragXStart = MouseDragX;\n"
"			MouseDragYStart = MouseDragY;\n"
"			MouseDragKeyCtrl = 0;\n"
"			MouseDragKeyShift = 0;\n"
"			MouseDragKeyAlt = 0;\n"
"\n"
"			if(KeyShiftDown || KeyCtrlDown || KeyAltDown)\n"
"			{\n"
"				MouseDragKeyAlt = KeyAltDown;\n"
"				MouseDragKeyShift = KeyShiftDown;\n"
"				MouseDragKeyCtrl = KeyCtrlDown;\n"
"				MouseDragState = MouseDragMove;\n"
"			}\n"
"		}\n"
"	}\n"
"	else if(MouseDragState == MouseDragDown)\n"
"	{\n"
"		if(Source == MouseDragUp)\n"
"		{\n"
"			MouseHandleDragClick();\n"
"			MouseDragReset();\n"
"		}\n"
"		else if(Source == MouseDragMove)\n"
"		{\n"
"			var dx = Math.abs(MouseDragX - MouseDragXStart);\n"
"			var dy = Math.abs(MouseDragY - MouseDragYStart);\n"
"			if(dx+dy>1)\n"
"			{\n"
"				MouseDragState = MouseDragMove;\n"
"			}\n"
"		}\n"
"	}\n"
"	MouseDragXLast = MouseDragX;\n"
"	MouseDragYLast = MouseDragY;\n"
"}\n"
"\n"
"function MouseMove(evt)\n"
"{\n"
"	evt.preventDefault();\n"
"	ZoomActive = 0;\n"
"	MouseDrag(MouseDragMove, evt);\n"
" 	MouseHistory = 0;\n"
"	MouseDetailed = 0;\n"
"	HistoryViewMouseX = HistoryViewMouseY = -1;\n"
"	var rect = evt.target.getBoundingClientRect();\n"
"	var x = evt.clientX - rect.left;\n"
"	var y = evt.clientY - rect.top;\n"
"	GlobalMouseX = evt.pageX;\n"
"	GlobalMouseY = evt.pageY;\n"
"	if(evt.target == CanvasDetailedView)\n"
"	{\n"
"		if(!MouseDragSelectRange())\n"
"		{\n"
"			RangeCpu = RangeInit();\n"
"		}\n"
"		DetailedViewMouseX = x;\n"
"		DetailedViewMouseY = y;\n"
"	}\n"
"	else if(evt.target = CanvasHistory)\n"
"	{\n"
"		var Rect = CanvasHistory.getBoundingClientRect();\n"
"		HistoryViewMouseX = x;\n"
"		HistoryViewMouseY = y;\n"
"\n"
"		DetailedViewMouseX = -1;\n"
"		DetailedViewMouseY = -1;\n"
"\n"
"	}\n"
"	RequestRedraw();\n"
"}\n"
"\n"
"function MouseSortClick()\n"
"{\n"
"	if(SortColumnMouseOverNext)\n"
"	{\n"
"		if(SortColumnMouseOverNext == SortColumnMouseOver)\n"
"		{\n"
"			SortColumnOrderFlip =  1 - SortColumnOrderFlip;\n"
"		}\n"
"		else\n"
"		{\n"
"			SortColumnOrderFlip = 0;\n"
"		}\n"
"\n"
"		SortColumnMouseOver = SortColumnMouseOverNext;\n"
"		SortColumnMouseOverNext = null;\n"
"		if(SortColumnMouseOver == StrAverage)\n"
"		{\n"
"			SortColumn = 1;\n"
"		}\n"
"		else if(SortColumnMouseOver == StrMax)\n"
"		{\n"
"			SortColumn = 2;\n"
"		}\n"
"		else if(SortColumnMouseOver == StrTotal)\n"
"		{\n"
"			SortColumn = 3;\n"
"		}			\n"
"		else if(SortColumnMouseOver == StrMin)\n"
"		{\n"
"			SortColumn = 4;\n"
"		}\n"
"		else if(SortColumnMouseOver == StrSpike)\n"
"		{\n"
"			SortColumn = 5;\n"
"		}\n"
"		else if(SortColumnMouseOver == StrCallAverage)\n"
"		{\n"
"			SortColumn = 6;\n"
"		}\n"
"		else if(SortColumnMouseOver == StrCount)\n"
"		{\n"
"			SortColumn = 7;\n"
"		}\n"
"		else if(SortColumnMouseOver == StrExclAverage)\n"
"		{\n"
"			SortColumn = 8;\n"
"		}\n"
"		else if(SortColumnMouseOver == StrExclMax)\n"
"		{\n"
"			SortColumn = 9;\n"
"		}\n"
"		else if(SortColumnMouseOver == StrGroup)\n"
"		{\n"
"			SortColumn = 0;\n"
"		}\n"
"		RequestRedraw();\n"
"	}\n"
"}\n"
"\n"
"function MouseButton(bPressed, evt)\n"
"{\n"
"	evt.preventDefault();\n"
"	MouseReleased = !bPressed;\n"
"	MouseDrag(bPressed ? MouseDragDown : MouseDragUp, evt);\n"
"	if(!bPressed && SubMenuActive == -1)\n"
"		MouseSortClick();\n"
"	RequestRedraw();\n"
"}\n"
"\n"
"function MouseOut(evt)\n"
"{\n"
"	MouseDrag(MouseDragOff, evt);\n"
"	KeyCtrlDown = 0;\n"
"	KeyShiftDown = 0;\n"
"	KeyAltDown = 0;\n"
"	MouseDragButton = 0;\n"
"	nHoverToken = -1;\n"
"	RangeCpu = RangeInit();\n"
"}\n"
"\n"
"function MouseWheel(e)\n"
"{\n"
"    var e = window.event || e;\n"
"    var delta = (e.wheelDelta || e.detail * (-120));\n"
"    ZoomGraph((-4 * delta / 120.0) | 0);\n"
"    Draw(1);\n"
"}\n"
"function ShowFilterInput(bShow)\n"
"{\n"
"	if(bShow)\n"
"	{\n"
"		document.getElementById(\'filterinput\').style[\'display\'] = \'block\';\n"
"	}\n"
"	else\n"
"	{\n"
"		document.getElementById(\'filterinput\').style[\'display\'] = \'none\';\n"
"	}\n"
"}\n"
"\n"
"function SetFilterInput(group, timer)\n"
"{";

const size_t g_MicroProfileHtml_end_3_size = sizeof(g_MicroProfileHtml_end_3);
const char g_MicroProfileHtml_end_4[] =
"\n"
"	FilterInputGroupString = group;\n"
"	FilterInputTimerString = timer;\n"
"	FilterInputGroup.value = group?group:\'\';\n"
"	FilterInputTimer.value = timer?timer:\'\';\n"
"	FilterUpdate();\n"
"	if(group || timer)\n"
"	{\n"
"		ShowFilterInput(1);\n"
"	}\n"
"	else\n"
"	{\n"
"		ShowFilterInput(0);\n"
"	}\n"
"\n"
"}\n"
"\n"
"function ToggleFilterInput(escape)\n"
"{\n"
"	var ActiveElement = -1;\n"
"	for(var i = 0; i < FilterInputArray.length; ++i)\n"
"	{\n"
"		if(FilterInputArray[i] == document.activeElement)\n"
"		{\n"
"			ActiveElement = i;\n"
"		}\n"
"	}\n"
"	var OldActiveElement = ActiveElement;\n"
"	if(ActiveElement >= 0)\n"
"	{\n"
"		FilterInputArray[ActiveElement].blur();\n"
"	}\n"
"	ActiveElement++;\n"
"	if(!escape)\n"
"	{\n"
"		if(ActiveElement < FilterInputArray.length)\n"
"		{\n"
"			ShowFilterInput(1);\n"
"			FilterInputArray[ActiveElement].focus();\n"
"		}\n"
"	}\n"
"	else\n"
"	{\n"
"		if(-1 == OldActiveElement)\n"
"		{\n"
"			SetFilterInput();\n"
"		}\n"
"	}\n"
"}\n"
"\n"
"function KeyUp(evt)\n"
"{\n"
"	// console.log(\"keyup \", evt.keyCode);\n"
"\n"
"	if(evt.keyCode== 84)\n"
"	{\n"
"		G_DEBUG = 1;\n"
"	}\n"
"	if(evt.keyCode == 18)\n"
"	{\n"
"		ToolTipFlip = 0;\n"
"	}\n"
"	// ShowFlashMessage(evt.keyCode + \' <<\', 100);\n"
"	if(!FilterSearchActive && !IgnoreInput && SubMenuActive == -1)\n"
"	{\n"
"		if(evt.keyCode == 112)\n"
"		{\n"
"			ShowHelp(1, 0);\n"
"		}\n"
"		if(evt.keyCode == 39)\n"
"		{\n"
"			MoveToNext(1);\n"
"		}\n"
"		if(evt.keyCode == 37)\n"
"		{\n"
"			MoveToNext(-1);\n"
"		}\n"
"		if(evt.keyCode == 90)\n"
"		{\n"
"			ToolTipCorner = 1-ToolTipCorner;\n"
"		}\n"
"		if(evt.keyCode == 187)\n"
"		{\n"
"			DrawDetailedFlameMode = (DrawDetailedFlameMode+1) % 3;\n"
"			FilterSearchReset();\n"
"		}\n"
"		if(evt.keyCode == 189)\n"
"		{\n"
"			DrawDetailedCompareReverse = 1-DrawDetailedCompareReverse;\n"
"			FilterSearchReset();\n"
"		}\n"
"		if(evt.keyCode == 32)\n"
"		{\n"
"			if(RangeSelect.Begin < RangeSelect.End)\n"
"			{\n"
"				ZoomToRange(RangeSelect);\n"
"				RangeSelect = RangeInit();\n"
"				MouseHandleDragEnd();\n"
"			}\n"
"		}\n"
"		if(evt.keyCode == 9)\n"
"		{\n"
"			evt.preventDefault();\n"
"			if(Mode == ModeDetailed)\n"
"			{\n"
"				var Token = nHoverToken;\n"
"				if(Token == -1 && RangeValid(RangeSelect) && RangeSelect.Index >= 0)\n"
"				{\n"
"					Token = RangeSelect.Index;\n"
"				}\n"
"				if(Token != -1 && Token < S.TimerInfo.length)\n"
"				{\n"
"					var start = S.TimerInfo[Token].worststart;\n"
"					var end = S.TimerInfo[Token].worstend;\n"
"					RangeSelect.Begin = start;\n"
"					RangeSelect.End = end;\n"
"					RangeSelect.Thread = S.TimerInfo[Token].worstthread;\n"
"					RangeSelect.Index = Token;\n"
"					ShowFlashMessage(\'Worst: \' + (end-start).toFixed(2) + \'ms\', 100);\n"
"					MoveTo(RangeSelect.Begin, RangeSelect.End, ThreadYBegin[RangeSelect.Thread] + nOffsetY, ThreadYEnd[RangeSelect.Thread+1] + nOffsetY);\n"
"					MouseHandleDragEnd();\n"
"				}\n"
"			}\n"
"			else if(Mode == ModeTimers || Mode == ModeTimers_Threads || Mode == ModeTimers_Groups)\n"
"			{\n"
"				ToggleFilterInput(0);\n"
"				evt.preventDefault();\n"
"			}\n"
"\n"
"		}\n"
"		if(evt.keyCode == 88)\n"
"		{\n"
"			ToggleMode();\n"
"		}\n"
"\n"
"	}\n"
"	if(evt.keyCode == 18)\n"
"	{\n"
"		KeyAltDown = 0;\n"
"		MouseDragKeyUp();\n"
"	}		\n"
"	else if(evt.keyCode == 17)\n"
"	{ \n"
"		KeyCtrlDown = 0;\n"
"		MouseDragKeyUp();\n"
"	}\n"
"	else if(evt.keyCode == 16)\n"
"	{\n"
"		KeyShiftDown = 0;\n"
"		MouseDragKeyUp();\n"
"	}\n"
"\n"
"\n"
"	if(evt.keyCode == 27)\n"
"	{\n"
"		RangeSelect = RangeInit();\n"
"		SortColumn = 0;\n"
"		SortColumnMouseOver = \"\";\n"
"		if(Mode == ModeTimers || Mode == ModeTimers_Threads || Mode == ModeTimers_Groups)\n"
"		{\n"
"			ToggleFilterInput(1);\n"
"			evt.preventDefault();\n"
"		}\n"
"		if(SubMenuActive != -1)\n"
"		{\n"
"			if(FilterInputMenu.value.trim() != \"\")\n"
"			{\n"
"				FilterInputMenu.value = \"\";\n"
"			}\n"
"			else\n"
"			{\n"
"				EnableMenu(-1);\n"
"			}			\n"
"		}\n"
"\n"
"		if(FilterSearchActive)\n"
"		{\n"
"			if(FilterInput.value != \'\')\n"
"			{\n"
"				FilterInput.value = \'\';\n"
"			}\n"
"			else\n"
"			{\n"
"				FilterInputHide();\n"
"			}\n"
"		}\n"
"		else\n"
"		{\n"
"			FilterSearchReset();\n"
"		}\n"
"	}\n"
"\n"
"\n"
"	if(evt.keyCode == 13 && !IgnoreInput)\n"
"	{\n"
"		if(FilterSearchActive)\n"
"		{\n"
"			FilterInputCommit();\n"
"		}\n"
"		else\n"
"		{\n"
"			FilterInputShow();\n"
"		}\n"
"	}\n"
"	RequestRedraw();\n"
"	Invalidate = 0;\n"
"}\n"
"function FilterInputUpdate()\n"
"{\n"
"	Invalidate = 0;	\n"
"	if(FilterSearchActive == 1)\n"
"	{\n"
"		FilterInputDiv.style[\'display\'] = \'inline\';\n"
"		FilterInput.focus();\n"
"	}\n"
"	else\n"
"	{\n"
"		FilterSearchSelection = -1;\n"
"		FilterInputDiv.style[\'display\'] = \'none\';\n"
"	}	\n"
"}\n"
"function FilterInputShow()\n"
"{\n"
"	FilterSearchActive = 1;\n"
"	FilterInputUpdate();\n"
"	RequestRedraw();\n"
"}\n"
"function FilterInputHide()\n"
"{\n"
"	FilterSearchActive = 0;\n"
"	FilterInputUpdate();\n"
"}\n"
"\n"
"function FilterInputCommit()\n"
"{\n"
"	if(FilterSearchSelection >= 0)\n"
"	{\n"
"		FilterSearchReset();\n"
"		FilterSearchPassIndex = FilterSearchSelection;\n"
"		FilterSearchStartTime = new Date();\n"
"	}\n"
"	FilterInputHide();\n"
"}\n"
"function FilterSearchReset()\n"
"{\n"
"	FilterSearchArray = new Array();	\n"
"}\n"
"function CreateFilter(Filter)\n"
"{\n"
"	if(!Filter || Filter.length == 0)\n"
"	{\n"
"		return null;\n"
"	}\n"
"	Filter = Filter.split(\' \');\n"
"	\n"
"	var regexp = \"\";\n"
"	for(var i = 0; i < Filter.length; ++i)\n"
"	{\n"
"		regexp = regexp + \".*\" + Filter[i];\n"
"	}\n"
"	Filter = new Array();\n"
"	regexp = regexp + \".*\";\n"
"	Filter.push(new RegExp(regexp, \"i\"));\n"
"	return Filter;\n"
"}\n"
"function FilterKeyUp()\n"
"{\n"
"	FilterInputTimerString = FilterInputTimer.value;\n"
"	FilterInputGroupString = FilterInputGroup.value;\n"
"	FilterUpdate();\n"
"}\n"
"\n"
"function FilterUpdate()\n"
"{\n"
"	FilterTimer = CreateFilter(FilterInputTimerString);\n"
"	FilterGroup = CreateFilter(FilterInputGroupString);\n"
"}\n"
"\n"
"function KeyDown(evt)\n"
"{\n"
"	// console.log(\"keydow \", evt.keyCode);\n"
"\n"
"	if(evt.keyCode == 18)\n"
"	{\n"
"		KeyAltDown = 1;\n"
"	}\n"
"	else if(evt.keyCode == 17)\n"
"	{\n"
"		KeyCtrlDown = 1;\n"
"	}\n"
"	else if(evt.keyCode == 16)\n"
"	{\n"
"		KeyShiftDown = 1;\n"
"	}\n"
"	else if(evt.keyCode == 9)\n"
"	{\n"
"		evt.preventDefault();\n"
"	}\n"
"	else if(evt.keyCode == 13)\n"
"	{\n"
"		evt.preventDefault();\n"
"	}\n"
"	if(evt.keyCode == 91) // z/tab to toggle tooltip\n"
"	{\n"
"		ToolTipFlip = 1;\n"
"	}\n"
"\n"
"\n"
"	Invalidate = 0;\n"
"}\n"
"function ParseCookie(str)\n"
"{\n"
"	if(!str) return null;\n"
"	var result = str.match(/fisk=([^;]+)/);\n"
"	console.log(\"cookie is \" + str);\n"
"	if(result && result.length > 0)\n"
"	{\n"
"		var Obj = JSON.parse(result[1]);\n"
"		if(!Obj.offline)\n"
"		{\n"
"			var C = {};\n"
"			C.offline = Obj;\n"
"			Obj = C;\n"
"		}		\n"
"		return Obj;\n"
"	}\n"
"	return null;\n"
"}\n"
"\n"
"function GetCookie()\n"
"{\n"
"	var Obj = ParseCookie(localStorage.getItem(\"microprofile_fisk\"));\n"
"	if(!Obj)\n"
"	{\n"
"		Obj = ParseCookie(document.cookie);\n"
"	}\n"
"	if(!Obj)\n"
"	{\n"
"		return {offline:{},live:{}};\n"
"	}\n"
"	return Obj;\n"
"}\n"
"\n"
"function ReadCookie()\n"
"{\n"
"	var C = GetCookie();\n"
"	var NewMode = ModeDetailed;\n"
"	if(C.offline)\n"
"	{\n"
"		var Obj = C.offline;\n"
"		if(Obj.Mode)\n"
"		{\n"
"			NewMode = Obj.ModeX;\n"
"		}\n"
"		if(Obj.ReferenceTimeString)\n"
"		{\n"
"			ReferenceTimeString = Obj.ReferenceTimeString;\n"
"		}\n"
"		if(Obj.TargetTimeString)\n"
"		{\n"
"			TargetTimeString = Obj.TargetTimeString;\n"
"		}\n"
"		if(Obj.ThreadsActive)\n"
"		{\n"
"			ThreadsActive = Obj.ThreadsActive;\n"
"		}\n"
"		if(Obj.GroupsAllActive || Obj.GroupsAllActive == 0 || Obj.GroupsAllActive)\n"
"		{\n"
"			GroupsAllActive = Obj.GroupsAllActive;\n"
"		}\n"
"		else\n"
"		{\n"
"			GroupsAllActive = 1;\n"
"		}\n"
"		if(Obj.GroupsDisabled)\n"
"		{\n"
"			GroupsDisabled = Obj.GroupsDisabled;\n"
"		}\n"
"		if(Obj.nContextSwitchEnabled)\n"
"		{\n"
"			nContextSwitchEnabled = Obj.nContextSwitchEnabled; \n"
"		}\n"
"		else\n"
"		{\n"
"			nContextSwitchEnabled = 1;\n"
"		}\n"
"		if(Obj.GroupColors)\n"
"		{\n"
"			GroupColors = Obj.GroupColors;\n"
"		}\n"
"		else\n"
"		{\n"
"			GroupColors = 0;\n"
"		}\n"
"		if(Obj.nHideHelp)\n"
"		{\n"
"			nHideHelp = 1;\n"
"		}\n"
"		if(Obj.ColumnsEnabled)\n"
"		{\n"
"			ColumnsEnabled = Obj.ColumnsEnabled;\n"
"		}\n"
"		if(Obj.ToolTipCorner)\n"
"		{\n"
"			ToolTipCorner = Obj.ToolTipCorner;\n"
"		}\n"
"		if(Obj.DrawDetailedFlameMode)\n"
"		{\n"
"			DrawDetailedFlameMode = Obj.DrawDetailedFlameMode;\n"
"		}\n"
"		if(Obj.DrawDetailedCompareReverse)\n"
"		{\n"
"			DrawDetailedCompareReverse = Obj.DrawDetailedCompareReverse;\n"
"		}\n"
"		if(Obj.ThreadOrderNames)\n"
"		{\n"
"			ThreadOrderNames = Obj.ThreadOrderNames;\n"
"		}\n"
"	}\n"
"	SetContextSwitch(nContextSwitchEnabled);\n"
"	SetMode(NewMode);\n"
"	SetReferenceTime(ReferenceTimeString);\n"
"	SetTargetTime(TargetTimeString);\n"
"	UpdateGroupColors();\n"
"}\n"
"function WriteCookie()\n"
"{\n"
"	var C = GetCookie();\n"
"	var Obj = new Object();\n"
"	Obj.ModeX = Mode;\n"
"	Obj.ReferenceTimeString = ReferenceTimeString;\n"
"	Obj.TargetTimeString = TargetTimeString;\n"
"	Obj.ThreadsActive = ThreadsActive;\n"
"	Obj.GroupsDisabled = GroupsDisabled;\n"
"	Obj.GroupsAllActive = GroupsAllActive;\n"
"	Obj.nContextSwitchEnabled = nContextSwitchEnabled;\n"
"	Obj.GroupColors = GroupColors;\n"
"	Obj.ColumnsEnabled = ColumnsEnabled;\n"
"	Obj.ToolTipCorner = ToolTipCorner;\n"
"	Obj.DrawDetailedFlameMode = DrawDetailedFlameMode;\n"
"	Obj.DrawDetailedCompareReverse = DrawDetailedCompareReverse;\n"
"	Obj.ThreadOrderNames = ThreadOrderNames;\n"
"	if(nHideHelp)\n"
"	{\n"
"		Obj.nHideHelp = 1;\n"
"	}\n"
"	C.offline = Obj;\n"
"	var date = new Date();\n"
"	date.setFullYear(2099);\n"
"	var cookie = \'fisk=\' + JSON.stringify(C) + \';expires=\' + date;\n"
"	document.cookie = cookie;\n"
"	localStorage.setItem(\"microprofile_fisk\", cookie);\n"
"}\n"
"\n"
"function WindowRect(x,y,w,h)\n"
"{\n"
"	var s = {};\n"
"	s.x = x;\n"
"	s.y = y;\n"
"	s.w = w;\n"
"	s.h = h;\n"
"	return s;\n"
"}\n"
"\n"
"function MenuSize(w)\n"
"{\n"
"	return WindowRect(nWidth / 2 - w / 2, 5, w, nHeight);\n"
"}\n"
"\n"
"function TimerMenuSize()\n"
"{\n"
"	return MenuSize(200 + 5 + FontWidth); //fix menu size\n"
"}\n"
"\n"
"function DrawFilterSearch()\n"
"{\n"
"	FilterSearchSelection = -1;\n"
"	FilterSearchPassIndex = -1;\n"
"	FilterSearchSelectionMax = 0;\n"
"	if(!FilterSearchActive)\n"
"		return;\n"
"	nHoverToken = -1;\n"
"\n"
"	if(FilterInputSearchLast != FilterInput.value)\n"
"	{\n"
"		nOffsetFilterSearch = 0;\n"
"	}\n"
"	FilterInputSearchLast = FilterInput.value;\n"
"\n"
"	var FilterArray = CreateFilter(FilterInput.value);\n"
"	var context = CanvasDetailedView.getContext(\'2d\');\n"
"	var nColorIndex = 0;\n"
"	var SizeInfo = TimerMenuSize();\n"
"	var Y = SizeInfo.y;\n"
"	var Width = S.TimerNameWidth + S.GroupNameWidth;\n"
"	SizeInfo.w = Width;\n"
"	var X = SizeInfo.x;\n"
"\n"
"	MoveFilterInputDiv(SizeInfo.x, SizeInfo.y, SizeInfo.w);\n"
"	var YStart = Y;\n"
"	Y += 35; //todo: measure somehow?\n"
"	var MouseX = DetailedViewMouseX;\n"
"	var MouseY = DetailedViewMouseY;\n"
"\n"
"	Y -= nOffsetFilterSearch;\n"
"	var Count = 0;\n"
"	for(var i = 0; i < S.TimerInfo.length; ++i)\n"
"	{\n"
"		var v = S.TimerInfo[i];\n"
"		{\n"
"			var Name = v.name;\n"
"			var ParentName = S.GroupInfo[v.group].name;\n"
"			if(FilterMatch(FilterArray, ParentName + \" \" + Name))\n"
"			{\n"
"				if(Y >= YStart)\n"
"				{\n"
"					Count++;\n"
"					var ParentName = S.GroupInfo[v.group].name;\n"
"					var ParentColor = \'white\';\n"
"					var bMouseIn = MouseY >= Y && MouseY < Y + BoxHeight;\n"
"					var bgcolor = bMouseIn ? nBackColorOffset : nBackColors[nColorIndex];\n"
"					var TextY = Y+BoxHeight-FontAscent;\n"
"					context.fillStyle = bgcolor;\n"
"					context.fillRect(X, Y, Width, BoxHeight);\n"
"					context.fillStyle = ParentColor;\n"
"					context.fillText(ParentName, X + 2, TextY);\n"
"					context.fillStyle = g_Colors[v.cid];\n"
"					context.textAlign = \'right\';\n"
"					context.fillText(Name, X + Width - 2, TextY);\n"
"					context.textAlign = \'left\';\n"
"					if(bMouseIn)\n"
"					{\n"
"						FilterSearchSelection = i;\n"
"					}\n"
"				}\n"
"				Y += BoxHeight;\n"
"				if(Y > nHeight)\n"
"					break;\n"
"				nColorIndex = 1-nColorIndex;\n"
"			}\n"
"		}\n"
"	}\n"
"	FilterSearchSelectionMax = Count;\n"
"	SizeInfo.h = Y-SizeInfo.y;\n"
"	RequestRedraw();\n"
"	return SizeInfo;\n"
"}\n"
"\n"
"function CalcAverage()\n"
"{\n"
"	var Sum = 0;\n"
"	var Count = 0;\n"
"	for(nLog = 0; nLog < nNumLogs; nLog++)\n"
"	{\n"
"		StackPos = 0;\n"
"		for(var i = 0; i < S.Frames.length; i++)\n"
"		{\n"
"			var Frame_ = S.Frames[i];			\n"
"			var tt = Frame_.tt[nLog];\n"
"			var ts = Frame_.ts[nLog];\n"
"\n"
"			var count = tt.length;\n"
"			for(var j = 0; j < count; j++)\n"
"			{\n"
"				var type = tt[j];\n"
"				var time = ts[j];\n"
"				if(type == 1)\n"
"				{\n"
"					Stack[StackPos] = time;//store the frame which it comes from\n"
"					StackPos++;\n"
"				}\n"
"				else if(type == 0)\n"
"				{\n"
"					if(StackPos>0)\n"
"					{\n"
"\n"
"						StackPos--;\n"
"						var localtime = time - Stack[StackPos];\n"
"						Count++;\n"
"						Sum += localtime;\n"
"					}\n"
"				}\n"
"			}\n"
"		}\n"
"	}\n"
"	return Sum / Count;\n"
"\n"
"}\n"
"\n"
"function MakeLod(index, MinDelta, TimeArray, TypeArray, IndexArray, LogStart)\n"
"{\n"
"	if(S.LodData[index])\n"
"	{\n"
"		console.log(\"error!!\");\n"
"	}\n"
"	var o = new Object();\n"
"	o.MinDelta = MinDelta;\n"
"	o.TimeArray = TimeArray;\n"
"	o.TypeArray = TypeArray;\n"
"	o.IndexArray = IndexArray;\n"
"	o.LogStart = LogStart;\n"
"	S.LodData[index] = o;\n"
"}\n"
"\n"
"function PreprocessBuildSplitArray()\n"
"{\n"
"	var nNumLogs = S.Frames[0].ts.length;\n"
"\n"
"	ProfileEnter(\"PreprocessBuildSplitArray\");\n"
"	var SplitArrays = new Array(nNumLogs);\n"
"\n"
"	for(nLog = 0; nLog < nNumLogs; ++nLog)\n"
"	{\n"
"		console.log(\"source log \" + nLog + \" size \" + S.LodData[0].TypeArray[nLog].length);\n"
"	}\n"
"\n"
"\n"
"	for(nLog = 0; nLog < nNumLogs; nLog++)\n"
"	{\n"
"		var MaxDepth = 1;\n"
"		var StackPos = 0;\n"
"		var Stack = Array(20);\n"
"		var TypeArray = S.LodData[0].TypeArray[nLog];\n"
"		var TimeArray = S.LodData[0].TimeArray[nLog];\n"
"		var DeltaTimes = new Array(TypeArray.length);\n"
"\n"
"		for(var j = 0; j < TypeArray.length; ++j)\n"
"		{\n"
"			var type = TypeArray[j];\n"
"			var time = TimeArray[j];\n"
"			if(type == 1)\n"
"			{\n"
"				//push\n"
"				Stack[StackPos] = time;\n"
"				StackPos++;\n"
"			}\n"
"			else if(type == 0)\n"
"			{\n"
"				if(StackPos>0)\n"
"				{\n"
"					StackPos--;\n"
"					DeltaTimes[j] = time - Stack[StackPos];\n"
"				}\n"
"				else\n"
"				{\n"
"					DeltaTimes[j] = 0;\n"
"				}\n"
"			}\n"
"		}\n"
"		DeltaTimes.sort(function(a,b){return b-a;});\n"
"		var SplitArray = Array(NumLodSplits);\n"
"		var SplitIndex = DeltaTimes.length;\n"
"\n"
"		var j = 0;\n"
"		for(j = 0; j < NumLodSplits; ++j)\n"
"		{\n"
"			SplitIndex = Math.floor(SplitIndex / 2);\n"
"			while(SplitIndex > 0 && !DeltaTimes[SplitIndex])\n"
"			{\n"
"				SplitIndex--;\n"
"			}\n"
"			if(SplitIndex < SplitMin)\n"
"			{\n"
"				break;\n"
"			}\n"
"			//search.. if 0\n"
"			var SplitTime = DeltaTimes[SplitIndex];\n"
"			if(SplitTime>=0)\n"
"			{\n"
"				SplitArray[j] = SplitTime;\n"
"			}\n"
"			else\n"
"			{\n"
"				SplitArray[j] = SPLIT_LIMIT;\n"
"			}\n"
"			if(j>0)\n"
"			{\n"
"				console.assert(SplitArray[j-1] <= SplitArray[j], \"must be less\");\n"
"			}\n"
"\n"
"		}\n"
"		for(; j < NumLodSplits; ++j)\n"
"		{\n"
"			SplitArray[j] = SPLIT_LIMIT;\n"
"		}\n"
"\n"
"\n"
"		SplitArrays[nLog] = SplitArray;\n"
"	}\n"
"	ProfileLeave();\n"
"	return SplitArrays;\n"
"}\n"
"\n"
"function PreprocessBuildDurationArray()\n"
"{\n"
"	var nNumLogs = S.Frames[0].ts.length;\n"
"	ProfileEnter(\"PreprocessBuildDurationArray\");\n"
"	var DurationArrays = new Array(nNumLogs);\n"
"	for(nLog = 0; nLog < nNumLogs; ++nLog)\n"
"	{\n"
"		var MaxDepth = 1;\n"
"		var StackPos = 0;\n"
"		var Stack = Array(20);\n"
"		var StackIndex = Array(20);\n"
"		var TypeArray = S.LodData[0].TypeArray[nLog];\n"
"		var TimeArray = S.LodData[0].TimeArray[nLog];\n"
"		var DurationArray = Array(S.LodData[0].TypeArray[nLog].length);\n"
"		for(var j = 0; j < TypeArray.length; ++j)\n"
"		{\n"
"			var type = TypeArray[j];\n"
"			var time = TimeArray[j];\n"
"			if(type == 1)\n"
"			{\n"
"				//push\n"
"				Stack[StackPos] = time;\n"
"				StackIndex[StackPos] = j;\n"
"				StackPos++;\n"
"			}\n"
"			else if(type == 0)\n"
"			{\n"
"				if(StackPos>0)\n"
"				{\n"
"					StackPos--;\n"
"					var Duration = time - Stack[StackPos];\n"
"					DurationArray[StackIndex[StackPos]] = Duration;\n"
"					DurationArray[j] = Duration;\n"
"				}\n"
"				else\n"
"				{\n"
"					DurationArray[j] = 0;\n"
"				}\n"
"			}\n"
"		}\n"
"		for(var j = 0; j < StackPos; ++j)\n"
"		{\n"
"			DurationArray[j] = 0;\n"
"		}\n"
"		DurationArrays[nLog] = DurationArray;\n"
"	}\n"
"	ProfileLeave();\n"
"	return DurationArrays;\n"
"\n"
"}\n"
"function PreprocessLods()\n"
"{\n"
"	ProfileEnter(\"PreprocessLods\");\n"
"	var nNumLogs = S.Frames[0].ts.length;\n"
"	var SplitArrays = PreprocessBuildSplitArray();\n"
"	var DurationArrays = PreprocessBuildDurationArray();\n"
"	var Source = S.LodData[0];\n"
"	var SourceLogStart = Source.LogStart;\n"
"	var NumFrames = SourceLogStart.length;\n"
"\n"
"	for(var i = 0; i < NumLodSplits-1; ++i)\n"
"	{\n"
"		var DestLogStart = Array(SourceLogStart.length);\n"
"		for(var j = 0; j < DestLogStart.length; ++j)\n"
"		{\n"
"			DestLogStart[j] = Array(nNumLogs);\n"
"		}\n"
"		var MinDelta = Array(nNumLogs);\n"
"		var TimeArray = Array(nNumLogs);\n"
"		var IndexArray = Array(nNumLogs);\n"
"		var TypeArray = Array(nNumLogs);\n"
"\n"
"\n"
"\n"
"		for(nLog = 0; nLog < nNumLogs; ++nLog)\n"
"		{\n"
"			var SourceTypeArray = Source.TypeArray[nLog];\n"
"			var SourceTimeArray = Source.TimeArray[nLog];\n"
"			var SourceIndexArray = Source.IndexArray[nLog];\n"
"			var Duration = DurationArrays[nLog];\n"
"			console.assert(Duration.length == SourceTypeArray.length, \"must be equal!\");\n"
"			var SplitTime = SplitArrays[nLog][i];\n"
"\n"
"			MinDelta[nLog] = SplitTime;\n"
"			if(SplitTime < SPLIT_LIMIT)\n"
"			{\n"
"				var SourceCount = SourceTypeArray.length;\n"
"				var DestTypeArray = Array();\n"
"				var DestTimeArray = Array();\n"
"				var DestIndexArray = Array();\n"
"				var RemapArray = Array(SourceCount);\n"
"				var DiscardLast = 0;\n"
"\n"
"				for(var j = 0; j < SourceCount; ++j)\n"
"				{\n"
"					RemapArray[j] = DestTypeArray.length;\n"
"					if(Duration[j] >= SplitTime || (SourceTypeArray[j] == 3 && 0 == DiscardLast))\n"
"					{\n"
"						DiscardLast = 0;\n"
"						DestTypeArray.push(SourceTypeArray[j]);\n"
"						DestTimeArray.push(SourceTimeArray[j]);\n"
"						DestIndexArray.push(SourceIndexArray[j]);\n"
"					}\n"
"					else\n"
"					{\n"
"						DiscardLast = 1;\n"
"					}\n"
"				}\n"
"				TimeArray[nLog] = DestTimeArray;\n"
"				IndexArray[nLog] = DestIndexArray;\n"
"				TypeArray[nLog] = DestTypeArray;\n"
"				for(var j = 0; j < NumFrames; ++j)\n"
"				{\n"
"					var OldStart = SourceLogStart[j][nLog];\n"
"					var NewStart = RemapArray[OldStart];\n"
"					var FrameArray = DestLogStart[j];\n"
"					FrameArray[nLog] = NewStart;\n"
"				}\n"
"			}\n"
"			else\n"
"			{\n"
"\n"
"				for(var j = 0; j < NumFrames; ++j)\n"
"				{\n"
"					var FrameArray = DestLogStart[j];\n"
"	\n"
"					FrameArray[nLog] = 0;\n"
"				}\n"
"\n"
"			}\n"
"\n"
"		}\n"
"		MakeLod(i+1, MinDelta, TimeArray, TypeArray, IndexArray, DestLogStart);\n"
"	}\n"
"	ProfileLeave();\n"
"}\n"
"function PreprocessGlobalArray()\n"
"{\n"
"	ProfileEnter(\"PreprocessGlobalArray\");\n"
"	var nNumLogs = S.Frames[0].ts.length;\n"
"	var CaptureStart = S.Frames[0].framestart;\n"
"	var CaptureEnd = S.Frames[S.Frames.length-1].frameend;\n"
"	S.TypeArray = new Array(nNumLogs);\n"
"	S.TimeArray = new Array(nNumLogs);\n"
"	S.IndexArray = new Array(nNumLogs);\n"
"	var StackPos = 0;\n"
"	var Stack = Array(20);\n"
"	var LogStartArray = new Array(S.Frames.length);\n"
"	for(var i = 0; i < S.Frames.length; i++)\n"
"	{\n"
"		S.Frames[i].LogStart = new Array(nNumLogs);	\n"
"		LogStartArray[i] = S.Frames[i].LogStart;\n"
"\n"
"		S.Frames[i].LogEnd = new Array(nNumLogs);\n"
"	}\n"
"	var MinDelta = Array(nNumLogs);\n"
"	for(nLog = 0; nLog < nNumLogs; nLog++)\n"
"	{\n"
"		MinDelta[nLog] = 0;\n"
"		var Discard = 0;\n"
"		var TypeArray = new Array();\n"
"		var TimeArray = new Array();\n"
"		var IndexArray = new Array();\n"
"		for(var i = 0; i < S.Frames.length; i++)\n"
"		{\n"
"			var Frame_ = S.Frames[i];	\n"
"			Frame_.LogStart[nLog] = TimeArray.length;\n"
"			var CanDiscard = !S.ISGPU[nLog] || Frame_.frameendgpu > 0; //in case of no reference, we cannot discard gpu markers. This happens when there is no gpu/cpu tick reference\n"
"\n"
"			var FrameDiscard = (S.ISGPU[nLog] ? Frame_.frameendgpu : Frame_.frameend) + 33;//if timestamps are more than 33ms after current frame, we assume buffer has wrapped.\n"
"			var tt = Frame_.tt[nLog];\n"
"			var ts = Frame_.ts[nLog];\n"
"			var ti = Frame_.ti[nLog];\n"
"			var len = tt.length;\n"
"			var DiscardLast = 0;\n"
"			for(var xx = 0; xx < len; ++xx)\n"
"			{\n"
"				var Skip = (tt[i] == 3) ? DiscardLast : (CanDiscard && ts[xx] > FrameDiscard);\n"
"				if(Skip)\n"
"				{\n"
"					Discard++;\n"
"					DiscardLast = 1;\n"
"				}\n"
"				else\n"
"				{\n"
"					DiscardLast = 0;\n"
"					TypeArray.push(tt[xx]);\n"
"					TimeArray.push(ts[xx]);\n"
"					IndexArray.push(ti[xx]);\n"
"				}\n"
"			}\n"
"			Frame_.LogEnd[nLog] = TimeArray.length;\n"
"		}\n"
"		S.TypeArray[nLog] = TypeArray;\n"
"		S.TimeArray[nLog] = TimeArray;\n"
"		S.IndexArray[nLog] = IndexArray;\n"
"		if(Discard)\n"
"		{\n"
"			console.log(\'discarded \' + Discard + \' markers from \' + S.ThreadNames[nLog]);\n"
"		}\n"
"	}\n"
"	MakeLod(0, MinDelta, S.TimeArray, S.TypeArray, S.IndexArray, LogStartArray);\n"
"	ProfileLeave();\n"
"}\n"
"\n"
"function PreprocessFindFirstFrames()\n"
"{\n"
"	ProfileEnter(\"PreprocesFindFirstFrames\");\n"
"	//create arrays that show how far back we need to start search in order to get all markers.\n"
"	var nNumLogs = S.Frames[0].ts.length;\n"
"	for(var i = 0; i < S.Frames.length; i++)\n"
"	{\n"
"		S.Frames[i].FirstFrameIndex = new Array(nNumLogs);\n"
"		for(var j = 0; j < S.Frames[i].FirstFrameIndex.length; ++j)\n"
"		{\n"
"			S.Frames[i].FirstFrameIndex[j] = 0;\n"
"		}\n"
"	}\n"
"\n"
"	var StackPos = 0;\n"
"	var Stack = Array(20);\n"
"	S.MaxStack = Array(nNumLogs);\n"
"	\n"
"	for(nLog = 0; nLog < nNumLogs; nLog++)\n"
"	{\n"
"		var MaxStack = 0;\n"
"		StackPos = 0;\n"
"		for(var i = 0; i < S.Frames.length; i++)\n"
"		{\n"
"			var Frame_ = S.Frames[i];			\n"
"			var tt = Frame_.tt[nLog];\n"
"			var count = tt.length;\n"
"\n"
"			var FirstFrame = i;\n"
"			if(StackPos>0)\n"
"			{\n"
"				FirstFrame = Stack[0];\n"
"			}\n"
"			S.Frames[i].FirstFrameIndex[nLog] = FirstFrame;\n"
"\n"
"			for(var j = 0; j < count; j++)\n"
"			{\n"
"				var type = tt[j];\n"
"				if(type == 1)\n"
"				{\n"
"					Stack[StackPos] = i;//store the frame which it comes from\n"
"					StackPos++;\n"
"					if(StackPos > MaxStack)\n"
"					{\n"
"						MaxStack = StackPos;\n"
"					}\n"
"				}\n"
"				else if(type == 0)\n"
"				{\n"
"					if(StackPos>0)\n"
"					{\n"
"						StackPos--;\n"
"					}\n"
"				}\n"
"			}\n"
"		}\n"
"		S.MaxStack[nLog] = MaxStack;\n"
"	}\n"
"	S.MaxStack2 = Array(S.MaxStack.length);\n"
"	for(var i = 0; i < S.MaxStack2.length; ++i)\n"
"		S.MaxStack2[i] = 0;\n"
"	S.SecondActive = 0;\n"
"	ProfileLeave();\n"
"}\n"
"function PreprocessMeta()\n"
"{\n"
"	return;\n"
"	MetaLengths = Array(MetaNames.length);\n"
"	MetaLengthsAvg = Array(MetaNames.length);\n"
"	MetaLengthsMax = Array(MetaNames.length);\n"
"	for(var i = 0; i < MetaNames.length; ++i)\n"
"	{\n"
"		MetaLengths[i] = MetaNames[i].length+1;\n"
"		MetaLengthsAvg[i] = MetaNames[i].length+5;\n"
"		MetaLengthsMax[i] = MetaNames[i].length+5;\n"
"		if(MetaLengths[i]<12)\n"
"			MetaLengths[i] = 12;\n"
"		if(MetaLengthsAvg[i]<12)\n"
"			MetaLengthsAvg[i] = 12;\n"
"		if(MetaLengthsMax[i]<12)\n"
"			MetaLengthsMax[i] = 12;\n"
"	}\n"
"	for(var i = 0; i < S.TimerInfo.length; ++i)\n"
"	{\n"
"		var Timer = S.TimerInfo[i];\n"
"		for(var j = 0; j < MetaNames.length; ++j)\n"
"		{\n"
"			var Len = FormatMeta(Timer.meta[j],0).length + 2;\n"
"			var LenAvg = FormatMeta(Timer.meta[j],2).length + 2;\n"
"			var LenMax = FormatMeta(Timer.meta[j],0).length + 2;\n"
"			if(Len > MetaLengths[j])\n"
"			{\n"
"				MetaLengths[j] = Len;\n"
"			}\n"
"			if(LenAvg > MetaLengthsAvg[j])\n"
"			{\n"
"				MetaLengthsAvg[j] = LenAvg;\n"
"			}\n"
"			if(LenMax > MetaLengthsMax[j])\n"
"			{\n"
"				MetaLengthsMax[j] = LenMax;\n"
"			}\n"
"		}\n"
"	}\n"
"}\n"
"\n"
"function StringHash(s) //note: matching code in microprofile.cpp: uint32_t MicroProfileStringHash(const char* pString)\n"
"{ \n"
"	var h = 0xfeedba3e;\n"
"	for(var i = 0; i < s.length; ++i)\n"
"	{\n"
"		h = s.charCodeAt(i) + (h << 5) - h;\n"
"		h = h & h;\n"
"	}\n"
"	return Math.abs(h);\n"
"}\n"
"\n"
"function StringColorIndex(Name)\n"
"{\n"
"	var h = StringHash(Name);\n"
"	var cidx = Math.floor(360*(h  / (1<<32-1)) );\n"
"	return cidx;\n"
"}\n"
"\n"
"function ColorFromString(Name, S, L)\n"
"{\n"
"	var H = StringColorIndex(Name);\n"
"	return \"hsl(\" + H + \",\" + S + \"%, \" + L+ \"%)\";\n"
"}\n"
"function LerpColor(v)\n"
"{\n"
"	var R_0 = 0;\n"
"	var G_0 = 1;\n"
"	var B_0 = 0;\n"
"\n"
"	var R_1 = 1;\n"
"	var G_1 = 0.5;\n"
"	var B_1 = 0;\n"
"\n"
"	var R_2 = 1;\n"
"	var G_2 = 0;\n"
"	var B_3 = 0;\n"
"	var R;\n"
"	var G;\n"
"	if(v < 0.5)\n"
"	{\n"
"		v *= 2;\n"
"		var v0 = (1-v);\n"
"		R = R_0 * v0 + R_1 * v;\n"
"		G = G_0 * v0 + G_1 * v;\n"
"\n"
"	}\n"
"	else\n"
"	{\n"
"		v = (v-0.5) * 2;\n"
"		var v0 = (1-v);\n"
"		R = R_1 * v0 + R_2 * v;\n"
"		G = G_1 * v0 + G_2 * v;\n"
"	}\n"
"	R *= 255;\n"
"	G *= 255;\n"
"	return \"rgb(\" + R.toFixed(0) + \",\" + G.toFixed(0) + \",0)\";\n"
"\n"
"}\n"
"\n"
"function PreprocessThreadColors(S)\n"
"{\n"
"	S.ThreadColors = Array(S.ThreadNames.length);\n"
"	for(let i = 0; i < S.ThreadNames.length; ++i)\n"
"	{\n"
"		var cidx = StringColorIndex(S.ThreadNames[i]);\n"
"		var color = \"hsl(\" + cidx + \",50%, 60%)\";\n"
"		var coloroff = \"hsl(\" + cidx + \",85%, 50%)\";\n"
"		var colordark = \"hsl(\" + cidx + \",80%, 30%)\";\n"
"		var colordark_cid = GetColorIndex(colordark);\n"
"		S.ThreadColors[i] = {\"color\":color, \"colordark\":colordark, \"cidx\":cidx, \"gradient\":null,\"gradientoff\":null, \"coloroff\":coloroff, \"colordark_cid\":colordark_cid};\n"
"	}\n"
"}\n"
"\n"
"function PreprocessWidths()\n"
"{\n"
"	let context = CanvasHistory.getContext(\'2d\');\n"
"	context.font = Font;\n"
"	S.TimerNameWidth = 0;\n"
"	S.GroupNameWidth = 0;\n"
"\n"
"	for(let i in S.TimerInfo)\n"
"	{\n"
"		let str = S.GroupInfo[S.TimerInfo[i].group].name + \"XXX\" + S.TimerInfo[i].name;		\n"
"		let width = context.measureText(str).width;\n"
"		let widthname = context.measureText(S.TimerInfo[i].name).width;\n"
"		S.TimerInfo[i].wtotal = width;\n"
"		S.TimerInfo[i].w = widthname;\n"
"		S.TimerNameWidth = Math.max(S.TimerNameWidth, widthname);\n"
"	}\n"
"	for(let i in S.GroupInfo)\n"
"	{\n"
"		let widthname = context.measureText(S.TimerInfo[i].name).width;\n"
"		S.GroupNameWidth = Math.max(S.GroupNameWidth, widthname);\n"
"	}\n"
"	for(let i in S.ThreadNames)\n"
"	{\n"
"		let w = context.measureText(S.ThreadNames[i]).width;\n"
"		S.ThreadNameWidth = Math.max(S.ThreadNameWidth, w);\n"
"	}\n"
"	for(let i in S.CategoryInfo)\n"
"	{\n"
"		let w = context.measureText(S.CategoryInfo[i]).width;\n"
"		S.ThreadCategoryWidth = Math.max(S.ThreadCategoryWidth, w);\n"
"	}\n"
"}\n"
"\n"
"function PreprocessTimeline()\n"
"{\n"
"	Timeline.Times = S.TimelineArray;\n"
"	Timeline.Ids = S.TimelineIdArray;\n"
"	Timeline.Colors = new Array(S.TimelineArray.length);\n"
"	Timeline.Names = S.TimelineNames;\n"
"	Timeline.Ends = new Array(S.TimelineArray.length);\n"
"	Timeline.Pairs = new Array(S.TimelineArray.length);\n"
"	Timeline.Tracks = new Array();\n"
"	Timeline.Positions = new Array();\n"
"	for(var i = 0; i < Timeline.Times.length; ++i)\n"
"	{\n"
"		Timeline.Positions[i] = -1;\n"
"		Timeline.Ends[i] = -1;\n"
"		Timeline.Pairs[i] = -1;\n"
"		var Color = S.TimelineColorArray[i]\n"
"		if(!Color || Color == \'\')\n"
"		{\n"
"			Color = \'#777777\'\n"
"		}\n"
"		Timeline.Colors[i] = GetColorIndex(Color);\n"
"		if(null == Timeline.Colors[i])\n"
"			debugger;\n"
"		Timeline.Colors[i] = GetColorIndex(Color);\n"
"	}\n"
"\n"
"\n"
"	var LinearizeTrack = function(Track)\n"
"	{\n"
"		var b = new Array();\n"
"		var e = new Array();\n"
"		// var n = new Array();\n"
"		var k = new Array();\n"
"		var h = Track.h;\n"
"		while(h != -1)\n"
"		{\n"
"			b.push(Track.b[h]);\n"
"			e.push(Track.e[h]);\n"
"			k.push(Track.k[h]);\n"
"\n"
"			h = Track.n[h];\n"
"		}\n"
"	}\n"
"\n"
"	var CreateTrack = function()\n"
"	{\n"
"		var Track = {};\n"
"		Track.b = new Array();\n"
"		Track.e = new Array();\n"
"		Track.n = new Array();\n"
"		Track.k = new Array();\n"
"		Track.h = -1;\n"
"		return Track;\n"
"	}\n"
"\n"
"\n"
"	var TryAddToTrack = function(Track, b, e, k)\n"
"	{\n"
"		var Invalid = 0;\n"
"		var prev = -1;\n"
"		var next = Track.h;\n"
"		while(next != -1)\n"
"		{\n"
"			var B = Track.b[next];\n"
"			var E = Track.e[next];\n"
"			if(Math.max(B, b) < Math.min(E, e))\n"
"			{\n"
"				Invalid = 1;\n"
"				break;\n"
"			}\n"
"			if(E < b)\n"
"			{\n"
"				//should be after next, continue\n"
"			}else if(e < B)\n"
"			{\n"
"				//insert at this spot\n"
"				break;\n"
"			}\n"
"			prev = next;\n"
"			next = Track.n[next];\n"
"		}\n"
"		if(!Invalid)\n"
"		{\n"
"			var idx = Track.b.length;\n"
"			Track.b.push(b);\n"
"			Track.e.push(e);\n"
"			Track.k.push(k);\n"
"			Track.n.push(next);\n"
"			if(prev == -1)\n"
"			{\n"
"				Track.h = idx;\n"
"			}\n"
"			else\n"
"			{\n"
"				var h = Track.n[prev];\n"
"				if(h != next)\n"
"				{\n"
"					debugger;\n"
"				}\n"
"				Track.n[prev] = idx;\n"
"			}\n"
"			return true;\n"
"		}\n"
"		else\n"
"		{\n"
"			return false;\n"
"		}\n"
"	};\n"
"\n"
"\n"
"	var AddToTrack = function(b, e, k)\n"
"	{\n"
"		var Tracks = Timeline.Tracks;\n"
"\n"
"		for(var i = 0; i < Tracks.length; ++i)\n"
"		{\n"
"			var Track = Tracks[i];\n"
"			if(TryAddToTrack(Track, b, e, k))\n"
"			{\n"
"				return i;\n"
"			}\n"
"		}\n"
"		var NewTrack = CreateTrack();\n"
"		var i = Timeline.Tracks.length;\n"
"		Timeline.Tracks.push(NewTrack);\n"
"		if(!TryAddToTrack(NewTrack, b, e, k))\n"
"		{\n"
"			debugger;\n"
"		}\n"
"		return i;\n"
"\n"
"	};\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"	var Matching = {};\n"
"	var Pairs = Timeline.Pairs;\n"
"	var Ids = Timeline.Ids;\n"
"	var Ends = Timeline.Ends;\n"
"	var Times = Timeline.Times;\n"
"	if(Ids)\n"
"	{\n"
"		for(var i = 0; i < Ids.length; ++i)\n"
"		{\n"
"			Pairs[i] = -1;\n"
"			var ID = Ids[i];\n"
"			var match = Matching[ID];\n"
"			if(match)\n"
"			{\n"
"				if(match > Ids.length || match < 0)\n"
"					debugger;\n"
"				Pairs[match] = i;\n"
"				Pairs[i] = match;\n"
"				if(match > i)\n"
"					debugger;\n"
"				Ends[match] = Times[i];\n"
"				var Track = AddToTrack(Times[match], Ends[match], match);\n"
"				Timeline.Positions[match] = Track;\n"
"			}\n"
"			else\n"
"			{\n"
"				Matching[ID] = i;\n"
"			}\n"
"		}\n"
"	}\n"
"}\n"
"\n"
"function Preprocess_S()\n"
"{\n"
"	console.log(\'preprocessing\\n\');	\n"
"	S.LodData = new Array();\n"
"	S.CSwitchCache = {};\n"
"	S.CSwitchOnlyThreads = [];\n"
"	S.GroupNameWidth = 200;\n"
"	S.TimerNameWidth = 200;\n"
"	S.ThreadNameWidth = 150;\n"
"	S.ThreadCategoryWidth = 150;\n"
"\n"
"	PreprocessCalculateAllTimers();\n"
"	PreprocessFindFirstFrames();\n"
"\n"
"	PreprocessGlobalArray();\n"
"	PreprocessLods();\n"
"	PreprocessMeta();\n"
"	PreprocessThreadColors(S);\n"
"\n"
"	PreprocessContextSwitchCache();\n"
"	PreprocessWidths();\n"
"	console.log(\'preprocessing done\\n\');\n"
"	console.log(\"SS \" + S.LodData.length);\n"
"}\n"
"function Preprocess()\n"
"{\n"
"	var ProfileModeOld = ProfileMode;\n"
"	ProfileMode = 1;\n"
"	ProfileModeClear();\n"
"	ProfileEnter(\"Preprocess\");\n"
"	Preprocess_S();\n"
"	UpdateReferenceTime();\n"
"	ProfileLeave();\n"
"	ProfileModeDump();\n"
"	ProfileMode = ProfileModeOld;\n"
"	PreprocessTimeline();\n"
"	Initialized = 1;\n"
"}\n"
"\n"
"function ToggleColumn(idx, isMeta)\n"
"{\n"
"	ColumnsEnabled[idx] = !ColumnsEnabled[idx];\n"
"	UpdateColumnsMenu();\n"
"	WriteCookie();\n"
"	Invalidate = 0;\n"
"}\n"
"function UpdateColumnsMenu()\n"
"{\n"
"	var ulColumnMenu = document.getElementById(\'ColumnsSubMenu\');\n"
"	var Lis = ulColumnMenu.getElementsByTagName(\'li\');\n"
"	for(var i = 0; i < Lis.length; ++i)\n"
"	{\n"
"		if(ColumnsEnabled[i])\n"
"		{\n"
"			Lis[i].style[\'text-decoration\'] = \'underline\';\n"
"		}\n"
"		else\n"
"		{\n"
"			Lis[i].style[\'text-decoration\'] = \'none\';\n"
"		}\n"
"	}\n"
"}\n"
"\n"
"function ResetColumnWidth()\n"
"{\n"
"	if(ColumnsWidth)\n"
"	{\n"
"		for(var i = 0; i < ColumnsWidth.length; ++i)\n"
"		{\n"
"			ColumnsWidth[i] = 0;\n"
"		}\n"
"	}\n"
"}\n"
"var Comp0 = new Date();\n"
"var Comp1 = new Date();\n"
"var Comp2 = new Date();\n"
"var Comp3 = new Date();\n"
"\n"
"function SetGlobal(Name, Value)\n"
"{\n"
"	this[Name] = Value;\n"
"}\n"
"\n"
"\n"
"//compare todo:\n"
"//	**Match threads\n"
"//	**match tokens.\n"
"//	**Calculate shared screen positions.\n"
"//	**Invert second pass\n"
"//	**fix hovertoken\n"
"//	**fix range display\n"
"// 	todo: isgpu\n"
"//  todo: group numtimers.\n"
"//	implement timer view\n"
"\n"
"function CompareFixup(S0, S1) // S0 is the reference\n"
"{\n"
"	var GroupRemap = Array(S1.GroupInfo.length);\n"
"	var ThreadRemap = Array(S1.ThreadNames.length);\n"
"	var TimerRemap = Array(S1.TimerInfo.length);\n"
"	GroupRemapReverse = Array(S0.GroupInfo.length + S1.GroupInfo.length);\n"
"	TimerRemapReverse = Array(S0.TimerInfo.length + S1.TimerInfo.length);\n"
"	ThreadRemapReverse = Array(S0.ThreadNames.length + S1.ThreadNames.length);\n"
"\n"
"	for(var i = 0; i < GroupRemapReverse.length; ++i)\n"
"		GroupRemapReverse[i] = -1;\n"
"	for(var i = 0; i < TimerRemapReverse.length; ++i)\n"
"		TimerRemapReverse[i] = -1;\n"
"	for(var i = 0; i < ThreadRemapReverse.length; ++i)\n"
"		ThreadRemapReverse[i] = -1;\n"
"\n"
"\n"
"\n"
"	// var dump = function(SS, str)\n"
"	// {\n"
"	// 	console.log(str);\n"
"	// 	for(var i = 0; i < SS.GroupInfo.length; ++i)\n"
"	// 	{\n"
"	// 		console.log(\"G\" + i + \":\" + SS.GroupInfo[i].name);\n"
"	// 	}\n"
"	// 	for(var i = 0; i < SS.TimerInfo.length; ++i)\n"
"	// 	{\n"
"	// 		console.log(\"T\" + i + \":\" + SS.TimerInfo[i].name);\n"
"	// 	}\n"
"	\n"
"	// };\n"
"	// dump(S0, \"S0be4\");\n"
"	// dump(S1, \"S1be4\");\n"
"\n"
"	for(var i = 0; i < S1.GroupInfo.length; ++i)\n"
"	{\n"
"		var n = S1.GroupInfo[i].name;\n"
"		var idx = S0.GroupInfo.findIndex(function(G){ return G.name == n; });\n"
"		if(idx != -1)\n"
"		{\n"
"			GroupRemap[i] = idx;\n"
"		}\n"
"		else\n"
"		{\n"
"			GroupRemap[i] = S0.GroupInfo.length;\n"
"			S0.GroupInfo.push(S1.GroupInfo[i]);\n"
"		}\n"
"		GroupRemapReverse[GroupRemap[i]] = i;\n"
"	}\n"
"	// for(var i = 0; i < S0.TimerInfo.length; ++i)\n"
"	// {\n"
"	// 	var n = S0.TimerInfo[i].name;	\n"
"	// 	console.log(\'OG \', n, \' idx \', i);\n"
"	// }\n"
"\n"
"	for(var i = 0; i < S1.TimerInfo.length; ++i)\n"
"	{\n"
"		var TI = S1.TimerInfo[i];\n"
"		var n = TI.name;\n"
"		var g = GroupRemap[TI.group];\n"
"		var idx = S0.TimerInfo.findIndex(function(T){ return T.name == n && T.group == g; });\n"
"		TI.group = GroupRemap[TI.group];\n"
"		if(idx != -1)\n"
"		{\n"
"			TimerRemap[i] = idx;\n"
"		}\n"
"		else\n"
"		{\n"
"			console.log(\'added timer \' + TI.name + \' idx \' + S0.TimerInfo.length);\n"
"			TimerRemap[i] = S0.TimerInfo.length;\n"
"			TI.id = S0.TimerInfo.length;\n"
"			S0.TimerInfo.push(TI);\n"
"		}\n"
"		TimerRemapReverse[TimerRemap[i]] = i;\n"
"	}\n"
"\n"
"	var NumThreads = S0.ThreadNames.length;\n"
"\n"
"\n"
"	for(var i = 0; i < S1.ThreadNames.length; ++i)\n"
"	{\n"
"		var n = S1.ThreadNames[i];\n"
"		var idx = S0.ThreadNames.indexOf(n);\n"
"		if(idx != -1)\n"
"		{\n"
"			ThreadRemap[i] = idx;\n"
"		}\n"
"		else\n"
"		{\n"
"			ThreadRemap[i] = S0.ThreadNames.length;\n"
"			S0.ThreadNames.push(n);\n"
"			NumThreads++;\n"
"		}\n"
"		ThreadRemapReverse[ThreadRemap[i]] = i;\n"
"	}\n"
"\n"
"\n"
"	PreprocessThreadColors(S0);\n"
"	PreprocessThreadColors(S1);\n"
"\n"
"	var Fix = function(a, r)\n"
"	{\n"
"		for(var i in a)\n"
"		{\n"
"			a[i] = r[a[i]];\n"
"		}\n"
"	};\n"
"	var FixArray = function(a, s)\n"
"	{\n"
"		if(!s)\n"
"			return;\n"
"		for(var i = 0; i < a.length; ++i)\n"
"		{\n"
"			if(!a[i])\n"
"				a[i] = [];\n"
"		}\n"
"		while(a.length != s)\n"
"			a.push([]);\n"
"	};\n"
"\n"
"	for(var i in S0.Frames)\n"
"	{\n"
"		var F = S0.Frames[i];\n"
"		FixArray(F.ti, NumThreads);\n"
"		FixArray(F.ts, NumThreads);\n"
"		FixArray(F.tt, NumThreads);\n"
"	}\n"
"\n"
"	for(var i in S1.Frames)\n"
"	{\n"
"		var F = S1.Frames[i];\n"
"		var ti = F.ti;\n"
"		var ts = F.ts;\n"
"		var tt = F.tt;\n"
"\n"
"		F.ti = new Array(NumThreads);\n"
"		F.ts = new Array(NumThreads);\n"
"		F.tt = new Array(NumThreads);\n"
"		\n"
"		for(var j in ti)\n"
"		{\n"
"\n"
"			Fix(ti[j], TimerRemap);\n"
"			F.ti[ThreadRemap[j]] = ti[j];\n"
"		}\n"
"		FixArray(F.ti, NumThreads);\n"
"		for(var i = 0; i < NumThreads; ++i)\n"
"		{\n"
"			if(!F.ti[i])\n"
"				debugger;\n"
"		}\n"
"		for(var j in ts)\n"
"		{\n"
"			F.ts[ThreadRemap[j]] = ts[j];\n"
"		}\n"
"		FixArray(F.ts, NumThreads);\n"
"		for(var i = 0; i < NumThreads; ++i)\n"
"		{\n"
"			if(!F.ts[i])\n"
"				debugger;\n"
"		}\n"
"		for(var j in tt)\n"
"		{\n"
"			F.tt[ThreadRemap[j]] = tt[j];\n"
"		}\n"
"		FixArray(F.tt, NumThreads);\n"
"\n"
"		for(var i = 0; i < NumThreads; ++i)\n"
"		{\n"
"			if(!F.tt[i])\n"
"				debugger;\n"
"		}\n"
"		//assert length is the same\n"
"		if(F.tt.length != S0.Frames[0].tt.length)\n"
"		{\n"
"			debugger;\n"
"		}\n"
"		if(F.ti.length != S0.Frames[0].ti.length)\n"
"		{\n"
"			debugger;\n"
"		}\n"
"		if(F.ts.length != S0.Frames[0].ts.length)\n"
"		{\n"
"			debugger;\n"
"		}\n"
"		// console.log(\'log \' + i +  \':\', F.ts.length, \':\', F.ti.length, \':\', F.tt.length);\n"
"	}\n"
"\n"
"	var NewTimerInfo = Array(S0.TimerInfo.length);\n"
"	for(var i = 0; i < S1.TimerInfo.length; ++i)\n"
"	{\n"
"		let xx = TimerRemap[i];\n"
"		NewTimerInfo[xx] = S1.TimerInfo[i];\n"
"		NewTimerInfo[xx].id = xx;\n"
"		NewTimerInfo[xx].group = S0.TimerInfo[xx].group;\n"
"		\n"
"		if(NewTimerInfo[xx].id != S0.TimerInfo[xx].id)\n"
"		{\n"
"			debugger;\n"
"		}\n"
"		if(NewTimerInfo[xx].group != S0.TimerInfo[xx].group)\n"
"		{\n"
"			debugger;\n"
"		}\n"
"\n"
"	}\n"
"	for(var i = 0; i < NewTimerInfo.length; ++i)\n"
"	{\n"
"		if(!NewTimerInfo[i])\n"
"		{\n"
"			NewTimerInfo[i] = CloneTimer(S0.TimerInfo[i]);\n"
"			NewTimerInfo[i].id = i;\n"
"			if(NewTimerInfo[i].id != S0.TimerInfo[i].id)\n"
"			{\n"
"				debugger;\n"
"			}\n"
"			if(NewTimerInfo[i].group != S0.TimerInfo[i].group)\n"
"			{\n"
"				debugger;\n"
"			}\n"
"	\n"
"		}\n"
"	}\n"
"	S1.TimerInfo = NewTimerInfo;\n"
"	";

const size_t g_MicroProfileHtml_end_4_size = sizeof(g_MicroProfileHtml_end_4);
const char g_MicroProfileHtml_end_5[] =
"var NewGroupInfo = Array(S0.GroupInfo.length);\n"
"\n"
"	for(let i = 0; i < S1.GroupInfo.length; ++i)\n"
"	{\n"
"		let xx = GroupRemap[i];\n"
"		NewGroupInfo[xx] = S1.GroupInfo[i];\n"
"		NewGroupInfo[xx].id = xx;\n"
"	}\n"
"	for(let i = 0; i < NewGroupInfo.length; ++i)\n"
"	{\n"
"		if(!NewGroupInfo[i])\n"
"		{\n"
"			NewGroupInfo[i] = CloneGroup(S0.GroupInfo[i]);\n"
"			NewGroupInfo[i].id = i;\n"
"		}\n"
"	}\n"
"	S1.GroupInfo = NewGroupInfo;\n"
"	for(let i = 0; i < S1.GroupInfo.length; ++i)\n"
"	{\n"
"		if(S1.GroupInfo[i].id != i)\n"
"			debugger;\n"
"		if(S0.GroupInfo[i].id != i)\n"
"			debugger;\n"
"	}\n"
"\n"
"	//debugging:\n"
"	if(S0.TimerInfo.length != S1.TimerInfo.length)\n"
"		debugger;\n"
"	for(let i = 0; i < S0.TimerInfo.length; ++i)\n"
"	{\n"
"		let t0 = S0.TimerInfo[i];\n"
"		let t1 = S1.TimerInfo[i];\n"
"		if(t0.id != t1.id)\n"
"			debugger;\n"
"		if(t0.name != t1.name)\n"
"			debugger;\n"
"		if(t0.group != t1.group)\n"
"			debugger;\n"
"	}\n"
"\n"
"	if(S0.GroupInfo.length != S1.GroupInfo.length)\n"
"		debugger;\n"
"	for(let i = 0; i < S0.GroupInfo.length; ++i)\n"
"	{\n"
"		let t0 = S0.GroupInfo[i];\n"
"		let t1 = S1.GroupInfo[i];\n"
"		if(t0.id != t1.id)\n"
"			debugger;\n"
"		if(t0.name != t1.name)\n"
"			debugger;\n"
"	}\n"
"\n"
"\n"
"\n"
"\n"
"}\n"
"function ReadHtmlFile(e)\n"
"{\n"
"	var File = e.target.files[0];\n"
"	if (!File)\n"
"	{\n"
"		return;\n"
"	}\n"
"	var Reader = new FileReader();\n"
"	Reader.onload = function(e) {\n"
"		if(!ParseCompareData(e.target.result))\n"
"		{\n"
"			ShowFlashMessage(\"Failed to parse file\", 50);\n"
"		}\n"
"	};\n"
"	Reader.onprogress = function(e)\n"
"	{\n"
"		var m = e.loaded + \":\" + e.total + \" :: \" + e.lengthComputable;\n"
"		console.log(m);\n"
"	};\n"
"	C0 = new Date();\n"
"	Reader.readAsText(File);\n"
"}\n"
"\n"
"function ParseCompareData(Data)\n"
"{\n"
"	S.AA = \"Original\";\n"
"	Comp1 = new Date();\n"
"	\n"
"	var idxbegin = Data.indexOf(\"//EBEGIN\");\n"
"	if(idxbegin == -1)\n"
"		return false;\n"
"	idxbegin += \"//EBEGIN\".length + 1;\n"
"	var idxend = Data.indexOf(\"//EEND\", idxbegin);\n"
"	if(idxend == -1)\n"
"		return false;\n"
"\n"
"	Comp2 = new Date();\n"
"	var SOriginal = S;\n"
"	S = {};\n"
"\n"
"	var idx = idxbegin;\n"
"	while(idx < idxend)\n"
"	{\n"
"		var idx0 = Data.indexOf(\'\\n\', idx);\n"
"		var s = Data.substring(idx, idx0);\n"
"		// console.log(s);\n"
"		eval(s);\n"
"		idx = idx0+1;\n"
"	}\n"
"\n"
"	S.AA = \"Parsed\";\n"
"	var SParsed = S;   //note: the calls to eval, will make a new \"S\" in local scope.\n"
"	SetGlobal(\"S\", S); //Set global S to point to new object, while its preprocessed\n"
"	Comp3 = new Date();\n"
"\n"
"\n"
"	CompareFixup(SOriginal, SParsed);\n"
"	Preprocess_S();\n"
"\n"
"	var MaxStack2 = SParsed.MaxStack;\n"
"\n"
"	var Comp4 = new Date();\n"
"	SetGlobal(\"S2\", SParsed);\n"
"	SetGlobal(\"S\", SOriginal);\n"
"\n"
"	Preprocess_S(); //since indices are rebased, a repreprocessing is needed.\n"
"\n"
"	SOriginal.MaxStack2 = SParsed.MaxStack;\n"
"	SParsed.MaxStack2 = SOriginal.MaxStack;\n"
"	SOriginal.SecondActive = 1;\n"
"\n"
"\n"
"	ThreadOrderSort();\n"
"\n"
"	console.log(\'file loaded \' + idxbegin + \' \' + idxend );\n"
"	console.log(\'time \' + (Comp1 - Comp0));\n"
"	console.log(\'time \' + (Comp2 - Comp1));\n"
"	console.log(\'time \' + (Comp3 - Comp2).toFixed(2));\n"
"	console.log(\'time \' + (Comp4 - Comp3).toFixed(2));\n"
"	document.getElementById(\'file-input\').removeEventListener(\'change\', ReadHtmlFile, false);\n"
"	let fname = document.getElementById(\'file-input\').value;\n"
"	let index = 1+Math.max(fname.lastIndexOf(\'/\'), fname.lastIndexOf(\'\\\\\'));\n"
"	if(index < fname.length)\n"
"		fname = fname.substring(index);\n"
"	let CompStr = \'Compare [\' + fname + \']\';\n"
"	RequestRedraw();\n"
"	return true;\n"
"}\n"
"\n"
"function ComparePrompt()\n"
"{\n"
"	document.getElementById(\'file-input\').addEventListener(\'change\', ReadHtmlFile, false);\n"
"	document.getElementById(\'file-input\').click();\n"
"}\n"
"\n"
"\n"
"var mousewheelevt = (/Firefox/i.test(navigator.userAgent)) ? \"DOMMouseScroll\" : \"mousewheel\" //FF doesn\'t recognize mousewheel as of FF3.x\n"
"\n"
"CanvasDetailedView.addEventListener(\'mousemove\', MouseMove, false);\n"
"CanvasDetailedView.addEventListener(\'mousedown\', function(evt) { MouseButton(true, evt); });\n"
"CanvasDetailedView.addEventListener(\'mouseup\', function(evt) { MouseButton(false, evt); } );\n"
"CanvasDetailedView.addEventListener(\'mouseout\', MouseOut);\n"
"CanvasDetailedView.addEventListener(\"contextmenu\", function (e) { e.preventDefault(); }, false);\n"
"CanvasDetailedView.addEventListener(mousewheelevt, MouseWheel, false);\n"
"CanvasHistory.addEventListener(\'mousemove\', MouseMove);\n"
"CanvasHistory.addEventListener(\'mousedown\', function(evt) { MouseButton(true, evt); });\n"
"CanvasHistory.addEventListener(\'mouseup\', function(evt) { MouseButton(false, evt); } );\n"
"CanvasHistory.addEventListener(\'mouseout\', MouseOut);\n"
"CanvasHistory.addEventListener(\"contextmenu\", function (e) { e.preventDefault(); }, false);\n"
"CanvasHistory.addEventListener(mousewheelevt, MouseWheel, false);\n"
"CanvasMenu.addEventListener(\'mousemove\', MouseMove);\n"
"CanvasMenu.addEventListener(\'mousedown\', function(evt) { MouseButton(true, evt); });\n"
"CanvasMenu.addEventListener(\'mouseup\', function(evt) { MouseButton(false, evt); } );\n"
"CanvasMenu.addEventListener(\'mouseout\', MouseOut);\n"
"CanvasMenu.addEventListener(\"contextmenu\", function (e) { e.preventDefault(); }, false);\n"
"CanvasMenu.addEventListener(mousewheelevt, MouseWheel, false);\n"
"FilterInputTimer.addEventListener(\'keyup\', FilterKeyUp);\n"
"FilterInputGroup.addEventListener(\'keyup\', FilterKeyUp);\n"
"window.addEventListener(\'keydown\', KeyDown);\n"
"window.addEventListener(\'keyup\', KeyUp);\n"
"window.addEventListener(\'resize\', ResizeCanvas, false);\n"
"\n"
"InitGroups();\n"
"ReadCookie();\n"
"MeasureFont();\n"
"ThreadOrderSort();\n"
"InitOrderArrays();\n"
"InitMenu();\n"
"InitFrameInfo();\n"
"ResizeCanvas();\n"
"Preprocess();\n"
"OnPageReady();\n"
"Draw(1);\n"
"\n"
"\n"
"</script>\n"
"</body>\n"
"</html>      ";

const size_t g_MicroProfileHtml_end_5_size = sizeof(g_MicroProfileHtml_end_5);
const char* g_MicroProfileHtml_end[] = {
&g_MicroProfileHtml_end_0[0],
&g_MicroProfileHtml_end_1[0],
&g_MicroProfileHtml_end_2[0],
&g_MicroProfileHtml_end_3[0],
&g_MicroProfileHtml_end_4[0],
&g_MicroProfileHtml_end_5[0],
};
size_t g_MicroProfileHtml_end_sizes[] = {
sizeof(g_MicroProfileHtml_end_0),
sizeof(g_MicroProfileHtml_end_1),
sizeof(g_MicroProfileHtml_end_2),
sizeof(g_MicroProfileHtml_end_3),
sizeof(g_MicroProfileHtml_end_4),
sizeof(g_MicroProfileHtml_end_5),
};
size_t g_MicroProfileHtml_end_count = 6;
#endif //MICROPROFILE_EMBED_HTML

///end file generated from  microprofile.html
///start file generated from microprofilelive.html
#ifdef MICROPROFILE_EMBED_HTML
const char g_MicroProfileHtmlLive_begin_0[] =
"<!DOCTYPE HTML>\n"
"<html>\n"
"<head>\n"
"<title>MicroProfile Live</title>\n"
"<style>\n"
"/* about css: http://bit.ly/1eMQ42U */\n"
"body {margin: 0px;padding: 0px; font: 12px Courier New;background-color:#343434; color:white;overflow:hidden;}\n"
"ul {list-style-type: none;margin: 0;padding: 0;}\n"
"li{display: inline; float:left;border:5px; position:relative;text-align:center;}\n"
"a {\n"
"    float:left;\n"
"    text-decoration:none;\n"
"    display: inline;\n"
"    text-align: center;\n"
"	padding:5px;\n"
"	padding-bottom:0px;\n"
"	padding-top:0px;\n"
"    color: #FFFFFF;\n"
"    background-color: #343434;\n"
"}\n"
"a:hover, a:active{\n"
"	background-color: #000000;\n"
"}\n"
"\n"
"ul ul {\n"
"    position:absolute;\n"
"    left:0;\n"
"    top:100%;\n"
"    margin-left:-999em;\n"
"}\n"
"li:hover ul {\n"
"    margin-left:0;\n"
"    margin-right:0;\n"
"}\n"
"ul li ul{ display:block;float:none;width:100%;}\n"
"ul li ul li{ display:block;float:none;width:100%;}\n"
"li li a{ display:block;float:none;width:100%;text-align:left;}\n"
"#nav li:hover div {margin-left:0;}\n"
".help {position:absolute;z-index:5;text-align:left;padding:2px;margin-left:-999em;background-color: #313131;width:300px;}\n"
".helpstart {position:absolute;z-index:5;text-align:left;padding:2px;background-color: #313131;width:300px;display:none}\n"
".root {z-index:1;position:absolute;top:0px;left:0px;}\n"
".filterinputsearchdiv{position:fixed; background-color: #313131;display:none;}\n"
".filterinputsearch{width:100px;}\n"
"</style>\n"
"</head>\n"
"<body style=\"\">\n"
"<div class=\"filterinputsearchdiv\" id=\"FilterInputDiv\">Filter<br><input type=\"text\" id=\"FilterInput\" class=\"filterinputsearch\"></div>\n"
"<div class=\"helpstart\" id=\"helpwindow\" style=\"left:20px;top:20px\">\n"
"History View:<br>\n"
"Right Click + Drag : Select Region<br>\n"
"Click + Drag: Move Selection<br>\n"
"Click Frame : Center on frame<br>\n"
"<hr>\n"
"Main View:<br>\n"
"space: Freeze capturing<br>\n"
"x : Toggle View<br>\n"
"/ : Rotate connection port % 3<br>\n"
"Ctrl + Drag: Pan<br>\n"
"Click + Drag: Pan<br>\n"
"Enter: Capture selection/Next N Frames\n"
"<hr>\n"
"<table style=\"width:100%\">\n"
"<tr>\n"
"<td width=\"50%\" align=\"left\"><a href=\'javascript:void(0)\' onclick=\"ShowHelp(0);\">Close</a></td>\n"
"</tr>\n"
"</table>\n"
"</div>\n"
"<canvas id=\"DetailedView\" height=\"100%\" style=\"background-color:#343434;margin:0px;padding:0px;\"></canvas>\n"
"<script>\n"
"\"use strict\"\n"
"\n"
"var FRAME_HISTORY_COLOR_CPU = \'#ff7f27\';\n"
"var FRAME_HISTORY_COLOR_GPU = \'#ffffff\';\n"
"\n"
"var Settings = {};\n"
"var Cookie = {};\n"
"\n"
"var HistoryHeight = 100;\n"
"var CanvasDetailedView = document.getElementById(\'DetailedView\');\n"
"var CanvasDetailedOffscreen = document.createElement(\'canvas\');\n"
"var FilterInput = document.getElementById(\'FilterInput\');\n"
"var FilterInputDiv = document.getElementById(\'FilterInputDiv\');\n"
"var FilterInputDivPos = {\"x\":-1,\"y\":-1,\"w\":-1,\"h\":-1};\n"
"var FilterInputValueLast = \'\';\n"
"\n"
"var CanvasArray0 = [];\n"
"var CanvasArray1 = [];\n"
"var Views = [];\n"
"\n"
"var ViewIndex = 0;\n"
"\n"
"var nWidth = CanvasDetailedView.width;\n"
"var nHeight = CanvasDetailedView.height;\n"
"var nBackColors = [\'#292929\', \'#343434\' ];\n"
"var nBackColorsDark = [\'#292929\', \'#272727\' ];\n"
"var nBackColorOffset = \'#404040\';\n"
"var FontHeight = 10;\n"
"var FontHeightLarge = 12;\n"
"var FontWidth = 1;\n"
"var FontAscent = 3; //Set manually\n"
"var Font = \'Bold \' + FontHeight + \'px Courier New\';\n"
"var FontLarge = \'Bold \' + FontHeightLarge + \'px Courier New\';\n"
"var FontFlash = \'Bold \' + 35 + \'px Courier New\';\n"
"var BoxHeight = FontHeight + 2;\n"
"var MouseX = 0;\n"
"var MouseY = 0;\n"
"var MouseReleased = false;\n"
"var MouseMoveTime = new Date();\n"
"\n"
"var nBarsWidth = 80;\n"
"var nOffsetBarsX = 0;\n"
"var nOffsetBarsY = 0;\n"
"var nOffsetCountersY = 0;\n"
"var nOffsetMenuTimers = 0;\n"
"var nOffsetMenuGroup = 0;\n"
"var nOffsetMenuFunctions = 0;\n"
"var nOffsetMenuModules = 0;\n"
"var nOffsetMenuPatched = 0;\n"
"\n"
"var nHoverCounter = -1;\n"
"\n"
"var MouseDragOff = 0;\n"
"var MouseDragDown = 1;\n"
"var MouseDragUp = 2;\n"
"var MouseDragMove = 3;\n"
"var MouseDragState = MouseDragOff;\n"
"var MouseDragTarget = 0;\n"
"var MouseDragButton = 0;\n"
"var MouseDragKeyShift = 0;\n"
"var MouseDragKeyCtrl = 0;\n"
"var MouseDragX = 0;\n"
"var MouseDragY = 0;\n"
"var MouseDragXLast = 0;\n"
"var MouseDragYLast = 0;\n"
"var MouseDragXStart = 0;\n"
"var MouseDragYStart = 0;\n"
"\n"
"var MouseDragActiveXStart = 0;\n"
"var MouseDragActiveXEnd = -1;\n"
"var MouseInCaptureButton = 0;\n"
"\n"
"var ToolTipCallback = null;\n"
"\n"
"var DPR = 0;\n"
"var C_HUGE = 1e10;\n"
"\n"
"var ActivePreset = \"Default\";\n"
"var ActivePresetRO = 0;\n"
"var PresetPending = 0;\n"
"var Presets = [];\n"
"var PresetsCache = {};\n"
"var ReadOnlyPresets = [];\n"
"var ReadOnlyPresetsCache = {};\n"
"\n"
"Settings.SubGraphSettings = {};\n"
"Settings.ReferenceTime = 50.0;\n"
"var ReferencePresets = [5.0, 10.0, 15.0, 20, 30, 33.33, 50, 66.66,100.0,250.0,500,1000.0];\n"
"var PercentilePresets = [0.0, 50.0, 90.0, 99.0];\n"
"var ReferenceTimeTweak = -1;\n"
"var PercentileTweak = -1;\n"
"\n"
"Settings.TargetTime = 30;\n"
"var TargetTimeTweak = -1;\n"
"\n"
"\n"
"var AggregateFrames = 60;\n"
"Settings.AggregateFrames = 60;\n"
"var AggregatePresets = [0, 10,20,30,60,90,120,500];\n"
"var AggregateHistorySize = 5;\n"
"var AggregateTweak = -1;\n"
"var AggregateCurrent = 0;\n"
"\n"
"var AutoCaptureCooldown = -1;\n"
"var AutoCaptureEnabled = 0;\n"
"var AutoCaptureDefaultThreshold = 66;\n"
"Settings.AutoCaptureTheshold = AutoCaptureDefaultThreshold;\n"
"Settings.AutoCaptureRepeat = 1;\n"
"var AutoCaptureThesholdPresets = [1,3,5,10,15,30,50,66,90,100,250,500,1000];\n"
"var AutoCaptureRepeatPresets = [1,2,3,4,5,6,7,8,9,10, 25, 50, 100];\n"
"var AutoCaptureTweak = -1;\n"
"var AutoCaptureRepeatTweak = -1;\n"
"var AutoCaptureSourceTweak = -1;\n"
"var AutoCaptureSourceIndex = -1;\n"
"\n"
"var CaptureFramesDefault = 30;\n"
"Settings.CaptureFrames = CaptureFramesDefault;\n"
"Settings.CaptureDelay = 0;\n"
"var CaptureFramesPresets = [5,10,15,30,50,66,90,100];\n"
"var CaptureDelayPresets = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10];\n"
"var CaptureTweak = -1;\n"
"var CaptureDelayTweak = -1;\n"
"\n"
"var CaptureTriggerTime = null;\n"
"var CaptureTriggerTimeType = 0;\n"
"var CaptureTriggerDelta = 0;\n"
"\n"
"\n"
"var ProfileData = {};\n"
"var ProfileStackTime = {};\n"
"var ProfileStackName = {};\n"
"var ProfileMode = 0;\n"
"var ProfileRedraw0 = 0;\n"
"var ProfileRedraw1 = 0;\n"
"var ProfileRedraw2 = 0;\n"
"var ProfileFps = 0;\n"
"var ProfileMs = 0;\n"
"var ProfileFpsAggr = 0;\n"
"var ProfileFpsCount = 0;\n"
"var ProfileLastTimeStamp = new Date();\n"
"var PlotfArray = new Array();\n"
"\n"
"var ConnectionStr = [\"\\\\\", \"|\", \"/\", \"-\" ];\n"
"var ConnectionIdx = 0;\n"
"var EnabledArray = [];\n"
"\n"
"\n"
"var FrameData = {};\n"
"var FRAME_COUNT = 256;\n"
"var FramePending = 0;\n"
"\n"
"var WSConnected = 0;\n"
"var WSIsOpen = 0;\n"
"var WSSeconds = 0;\n"
"var WSFail = 0;\n"
"var WS;\n"
"var WSHost = location.hostname ? location.hostname : \"localhost\";\n"
"var WSPort = location.port ? location.port : 1338;\n"
"var WSPath;\n"
"\n"
"var CaptureButtonX = 0;\n"
"var CaptureButtonY = 0;\n"
"var GroupsEnabled = 0;\n"
"var TimersEnabled = 0;\n"
"\n"
"var TimersActiveOnly = 0;\n"
"\n"
"\n"
"var MSG_TIMER_TREE = 1;\n"
"var MSG_ENABLED = 2;\n"
"var MSG_FRAME = 3;\n"
"var MSG_LOADSETTINGS = 4; \n"
"var MSG_PRESETS = 5;\n"
"var MSG_CURRENTSETTINGS = 6; \n"
"var MSG_COUNTERS = 7; \n"
"var MSG_FUNCTION_RESULTS = 8;\n"
"var MSG_INACTIVE_FRAME = 9;\n"
"var MSG_FUNCTION_NAMES = 10;\n"
"var MSG_INSTRUMENT_ERROR = 11;\n"
"// var MSG_MODULE_NAME = 12;\n"
"\n"
"\n"
"var TYPE_NONE = 0;\n"
"var TYPE_TIMER = 1;\n"
"var TYPE_GROUP = 2;\n"
"var TYPE_CATEGORY = 3;\n"
"var TYPE_SETTING = 4;\n"
"var TYPE_COUNTER = 5;\n"
"\n"
"\n"
"var WSSend = 0;\n"
"var WSReceive = 0;\n"
"var WSSendBytes = 0;\n"
"var WSReceiveBytes = 0;\n"
"var WSOpenTime = 0;\n"
"\n"
"\n"
"var TimerArray = [];\n"
"var CounterArray = [];\n"
"var Empty = {\"id\":0, \"w\":0, \"depth\":0, \"sibling\":-1,\"parent\":-1,\"firstchild\":-1};\n"
"var WidthArray = [];\n"
"var FunctionQueryArray = [];\n"
"var FunctionQueryPending = null;\n"
"var FunctionQueryLastRequest = 0;\n"
"var FunctionQueryReceived = 0;\n"
"var WidthTree = 0;\n"
"Settings.ViewActive = 0;\n"
"Settings.ViewCompressed = 0;\n"
"Settings.AllowHighDPI = 1;\n"
"var ViewNames = [\"Graph\", \"Graph\", \"Graph\", \"Bars\", \"Bars\", \"Bars\", \"Counters\"];\n"
"var ViewNames2 = [\"[split]\", \"[percentile]\",\"[group/thread]\",\"[table]\", \"[all]\", \"[single]\", \"\"];\n"
"\n"
"var VIEW_GRAPH_SPLIT = 0;\n"
"// var VIEW_GRAPH = 1;\n"
"var VIEW_GRAPH_PERCENTILE = 1;\n"
"var VIEW_GRAPH_THREAD_GROUP = 2;\n"
"var VIEW_BAR = 3;\n"
"var VIEW_BAR_ALL = 4;\n"
"var VIEW_BAR_SINGLE = 5;\n"
"var VIEW_COUNTERS = 6;\n"
"var VIEW_SIZE = 7;\n"
"\n"
"var GRAPH_ALPHA = 0.5;\n"
"\n"
"\n"
"// Settings.FancyGraph = 1;\n"
"Settings.AutomaticReference = 1;\n"
"Cookie.CodeReportMode = 0; // 0: prompt, 1:always send, 2: never send, never prompt\n"
"\n"
"\n"
"var ReferenceHistory = 0;\n"
"var ReferenceGraph = 0;\n"
"var ReferenceBar = 0;\n"
"var ReferenceHistoryAutomatic = 0;\n"
"var ReferenceGraphAutomatic = 0;\n"
"var ReferenceGraphAutomaticGroup = 0;\n"
"var ReferenceBarAutomatic = 0;\n"
"\n"
"var SingleTimerBars = 0;\n"
"var History;\n"
"var MainView;\n"
"var X7Views;\n"
"var X7LegendView;\n"
"var X7BarColumnRemap = [0,1,2,3,4,5,6];\n"
"var X7BarColumnMask = -1;\n"
"var X7LegendOffset = 25;\n"
"var X7BarLastView = -1;\n"
"var X7BarFirstView = -1;\n"
"\n"
"\n"
"var ViewBarMaxMsTextLength = 0;\n"
"\n"
"Settings.SortColumnOrderFlip = 0;\n"
"Settings.SortColumnName = \"\";\n"
"var SortColumnMouseOverNext = \"\";\n"
"\n"
"\n"
"var KeyShiftDown = 0;\n"
"var KeyCtrlDown = 0;\n"
"\n"
"var IsFrozen = 0;\n"
"\n"
"var PresetToLoad;\n"
"var PresetToLoadRO = 0;\n"
"var HelpFade;\n"
"\n"
"\n"
"TimerArray.push(Empty); // 0 is root of tree\n"
"\n"
"var StrTime = \"Time\";\n"
"var StrExclusive = \"Excl Time\";\n"
"var StrGroup = \"Group\";\n"
"var StrThread = \"Thread\";\n"
"var StrTimer = \"Timer\";\n"
"var StrAverage = \"Average\";\n"
"var StrMax = \"Max\";\n"
"var StrTotal = \"Total\";\n"
"var StrExclTotal = \"Excl Total\";\n"
"var StrMin = \"Min\";\n"
"var StrSpike = \"Spike%\";\n"
"var StrCallAverage = \"Call Average\";\n"
"var StrCount = \"Count\";\n"
"var StrExclAverage = \"Excl Average\";\n"
"var StrExclMax = \"Excl Max\";\n"
"var StrExclMin = \"Excl Max\";\n"
"var StrCallExclAverage = \"Call Excl Avg\";\n"
"\n"
"\n"
"var CounterNameWidth = 100;\n"
"var CounterValueWidth = 100;\n"
"var CounterLimitWidth = 100;\n"
"\n"
"var FormatCounterDefault = 0;\n"
"var FormatCounterBytes = 1;\n"
"var FormatCounterBytesExt = [\"b\",\"kb\",\"mb\",\"gb\",\"tb\",\"pb\",\"eb\",\"zb\",\"yb\"];\n"
"\n"
"var BarColumnNamesTable = [StrTime, StrExclusive, StrAverage, StrMax, StrMin, StrTotal, StrExclAverage, StrExclMax, StrExclTotal, StrSpike, StrCallAverage, StrCallExclAverage, StrCount];\n"
"var BarColumnNamesMulti = [StrTime, StrAverage, StrMax, StrMin, StrExclAverage, StrExclMax, StrExclMin];\n"
"var BarColumnNamesSingle = [StrAverage, StrMax, StrMin, StrExclAverage, StrExclMax, StrExclMin, StrCallAverage];\n"
"\n"
"// var SYMBOLSTATE_DEFAULT = 0;\n"
"// var SYMBOLSTATE_LOADING = 1;\n"
"// var SYMBOLSTATE_DONE = 2;\n"
"\n"
"\n"
"var SymbolState;\n"
"var ModuleState = [];\n"
"\n"
"var FunctionsInstrumented = [];\n"
"var FunctionsInstrumentedUnmangled = [];\n"
"var FunctionsInstrumentedModule = [];\n"
"var PopupsAllowed = 0;\n"
"var PopupsFailed = 0;\n"
"var PopupTestPending = 0;\n"
"\n"
"var ThreadInfo = {};\n"
"\n"
"function ConvertHslToRGB(h, s, l) //from https://gist.github.com/mjackson/5311256\n"
"{\n"
"	var r, g, b;\n"
"	if (s == 0)\n"
"	{\n"
"		r = g = b = l; // achromatic\n"
"	}\n"
"	else\n"
"	{\n"
"		function hue2rgb(p, q, t)\n"
"		{\n"
"			if (t < 0) t += 1;\n"
"			if (t > 1) t -= 1;\n"
"			if (t < 1/6) return p + (q - p) * 6 * t;\n"
"			if (t < 1/2) return q;\n"
"			if (t < 2/3) return p + (q - p) * (2/3 - t) * 6;\n"
"			return p;\n"
"		}\n"
"		var q = l < 0.5 ? l * (1 + s) : l + s - l * s;\n"
"		var p = 2 * l - q;\n"
"		r = hue2rgb(p, q, h + 1/3);\n"
"		g = hue2rgb(p, q, h);\n"
"		b = hue2rgb(p, q, h - 1/3);\n"
"	}\n"
"	var color = ((r*255)<<16) | ((g*255)<<8) | (b*255);\n"
"	return (\"000000\" + color.toString(16)).slice(-6);\n"
"}\n"
"\n"
"\n"
"function GetBarColumnNames()\n"
"{\n"
"	if(Settings.ViewActive == VIEW_BAR_ALL)\n"
"	{\n"
"		return BarColumnNamesMulti;\n"
"	}\n"
"	else if(Settings.ViewActive == VIEW_BAR_SINGLE)\n"
"	{\n"
"		return BarColumnNamesSingle;\n"
"	}\n"
"	else\n"
"	{\n"
"		return BarColumnNamesTable;\n"
"	}\n"
"}\n"
"function GetBarColumnEnabled()\n"
"{\n"
"	if(Settings.ViewActive == VIEW_BAR_ALL)\n"
"	{\n"
"		return Settings.BarColumnEnabledMulti;\n"
"	}\n"
"	else if(Settings.ViewActive == VIEW_BAR_SINGLE)\n"
"	{\n"
"		return Settings.BarColumnEnabledSingle;\n"
"	}\n"
"	else\n"
"	{\n"
"		return Settings.BarColumnEnabledTable;\n"
"	}\n"
"}\n"
"\n"
"Settings.BarColumnEnabledTable = new Array(BarColumnNamesTable.length);\n"
"Settings.BarColumnEnabledSingle = new Array(BarColumnNamesSingle.length);\n"
"Settings.BarColumnEnabledMulti = new Array(BarColumnNamesMulti.length);\n"
"var ColumnsWidth = new Array(BarColumnNamesTable.length);\n"
"function ClearEnabled(E)\n"
"{\n"
"	for(var i = 0; i < E.length; ++i)\n"
"	{\n"
"		E[i] = 1;\n"
"		ColumnsWidth[i] = 10;\n"
"	}\n"
"}\n"
"ClearEnabled(Settings.BarColumnEnabledTable);\n"
"ClearEnabled(Settings.BarColumnEnabledSingle);\n"
"ClearEnabled(Settings.BarColumnEnabledMulti);\n"
"\n"
"function Plotf(str)\n"
"{\n"
"	PlotfArray.push(str);\n"
"}\n"
"function PlotfClear()\n"
"{\n"
"	PlotfArray = new Array();\n"
"}\n"
"\n"
"function ProfileModeClear()\n"
"{\n"
"	if(ProfileMode)\n"
"	{\n"
"\n"
"		for(var idx in ProfileData)\n"
"		{\n"
"			if(idx == \"Plot\")\n"
"				continue;\n"
"			var Timer = ProfileData[idx];\n"
"			Timer.Count = 0;\n"
"			Timer.Time = 0;\n"
"		}\n"
"\n"
"		// ProfileData = new Object();\n"
"		ProfileStackTime = new Array();\n"
"		ProfileStackName = new Array();\n"
"	}\n"
"}\n"
"function ProfileEnter(Name)\n"
"{\n"
"	if(ProfileMode)\n"
"	{\n"
"		ProfileStackTime.push(new Date());\n"
"		ProfileStackName.push(Name);\n"
"	}\n"
"}\n"
"function ProfileLeave()\n"
"{\n"
"	if(ProfileMode)\n"
"	{\n"
"		var Time = new Date();\n"
"		var Delta = Time - ProfileStackTime.pop();\n"
"		var Name = ProfileStackName.pop();\n"
"		var Obj = ProfileData[Name];\n"
"		if(!Obj)\n"
"		{\n"
"			Obj = new Object();\n"
"			Obj.Count = 0;\n"
"			Obj.Name = Name;\n"
"			Obj.Time = 0;\n"
"			Obj.AggrCount = 0;\n"
"			Obj.AggrTime = 0;\n"
"			Obj.AvgTime = 0;\n"
"			ProfileData[Name] = Obj;\n"
"		}\n"
"		Obj.Time += Delta;\n"
"		Obj.Count += 1;\n"
"	}\n"
"}\n"
"\n"
"function ProfilePlot(s)\n"
"{\n"
"	if(ProfileMode)\n"
"	{\n"
"		var A = ProfileData.Plot;\n"
"		if(!A)\n"
"		{\n"
"			ProfileData.Plot = Array();\n"
"			A = ProfileData.Plot;\n"
"		}\n"
"		if(A.length<10)\n"
"		{\n"
"			A.push(s);\n"
"		}\n"
"	}\n"
"}\n"
"function ProfileModeDump()\n"
"{\n"
"	for(var idx in ProfileData)\n"
"	{\n"
"		var Timer = ProfileData[idx];\n"
"		console.log(Timer.Name + \" \" + Timer.Time + \"ms \" + Timer.Count);\n"
"	}\n"
"\n"
"}\n"
"function ProfileModeDraw(Canvas)\n"
"{\n"
"	if(ProfileMode)\n"
"	{\n"
"		ProfileFpsCount ++ ;\n"
"		var AggrFrames = 60;\n"
"		var StringArray = [];\n"
"		function FormatTime(f)\n"
"		{\n"
"			return (\"         \" + f.toFixed(2)).slice(-8);\n"
"		}\n"
"		function FormatStr(t, count, avg)\n"
"		{\n"
"			var str = FormatTime(t) + \"ms #\" + count + \"\" + FormatTime(avg) + \"ms\";\n"
"			return str;\n"
"		}\n"
"		for(var idx in ProfileData)\n"
"		{\n"
"			if(idx == \"Plot\")\n"
"				continue;\n"
"			var Timer = ProfileData[idx];\n"
"			Timer.AggrCount += Timer.Count;\n"
"			Timer.AggrTime += Timer.Time;\n"
"			if(ProfileFpsCount == AggrFrames)\n"
"			{\n"
"				Timer.AvgTime = Timer.AggrTime / AggrFrames;\n"
"				Timer.AggrCount = 0;\n"
"				Timer.AggrTime = 0;\n"
"			}\n"
"			StringArray.push(Timer.Name);\n"
"			StringArray.push(FormatStr(Timer.Time, Timer.Count, Timer.AvgTime));\n"
"			// StringArray.push(\"#\");\n"
"			// StringArray.push(\"\" + Timer.Count);\n"
"		}\n"
"		var Time = new Date();\n"
"		var Delta = Time - ProfileLastTimeStamp;\n"
"		ProfileLastTimeStamp = Time;\n"
"		StringArray.push(\"Frame Delta\");\n"
"		StringArray.push(Delta + \"ms\");\n"
"		{\n"
"			ProfileFpsAggr += Delta;\n"
"\n"
"			if(ProfileFpsCount == AggrFrames)\n"
"			{\n"
"				ProfileMs = ProfileFpsAggr / AggrFrames;\n"
"				ProfileFps = 1000 / (ProfileFpsAggr / AggrFrames);\n"
"				ProfileFpsAggr = 0;\n"
"				ProfileFpsCount = 0;\n"
"			}\n"
"			StringArray.push(\"Avg FPS\");\n"
"			StringArray.push(\"\" + ProfileFps.toFixed(2));\n"
"			StringArray.push(\"Avg MS\");\n"
"			StringArray.push(\"\" + ProfileMs.toFixed(2));\n"
"		}\n"
"		for(var i = 0; i < ProfileData.Plot; ++i)\n"
"		{\n"
"			StringArray.push(\"\");\n"
"			StringArray.push(ProfileData.Plot[i]);\n"
"		}\n"
"		ProfileData.Plot = Array();\n"
"		DrawToolTip(StringArray, Canvas, 0, 200);\n"
"	}\n"
"}\n"
"\n"
"\n"
"\n"
"function MeasureFont()\n"
"{\n"
"	var context = CanvasDetailedView.getContext(\'2d\');\n"
"	context.font = Font;\n"
"	FontWidth = context.measureText(\'W\').width;\n"
"\n"
"}\n"
"function ResizeCanvasDPR(w, h, c)\n"
"{\n"
"	DPR = Settings.AllowHighDPI ? window.devicePixelRatio : 0;\n"
"	if(DPR)\n"
"	{\n"
"		c.style.width = w + \'px\'; \n"
"		c.style.height = h + \'px\';\n"
"		c.width = w * DPR;\n"
"		c.height = h * DPR;\n"
"		c.getContext(\'2d\').scale(DPR,DPR);\n"
"	}\n"
"	else\n"
"	{\n"
"		DPR = 1;\n"
"		c.width = w;\n"
"		c.height = h;\n"
"	}\n"
"\n"
"}\n"
"\n"
"function ResizeCanvasDPR2(w, h, c)\n"
"{\n"
"	DPR = window.devicePixelRatio;\n"
"	if(DPR)\n"
"	{\n"
"		c.style.width = w + \'px\'; \n"
"		c.style.height = h + \'px\';\n"
"		c.width = w * DPR;\n"
"		c.height = h * DPR;\n"
"		c.getContext(\'2d\').scale(DPR,DPR);\n"
"	}\n"
"	else\n"
"	{\n"
"		c.width = w;\n"
"		c.height = h;\n"
"	}\n"
"\n"
"}\n"
"function ResizeView(View, x, y, w, h)\n"
"{\n"
"	View.x = x;\n"
"	View.y = y;\n"
"	View.w = w;\n"
"	View.h = h;\n"
"	var c0 = View.Canvas[0];\n"
"	var c1 = View.Canvas[1];\n"
"	ResizeCanvasDPR(w, h, c0);\n"
"	ResizeCanvasDPR(w, h, c1);\n"
"	c0.getContext(\'2d\').clearRect(0, 0, w, h);\n"
"	c1.getContext(\'2d\').clearRect(0, 0, w, h);\n"
"	View.OffscreenData[0] = c0.getContext(\'2d\').getImageData(0, 0, c0.width, c0.height);\n"
"	View.OffscreenData[1] = c1.getContext(\'2d\').getImageData(0, 0, c1.width, c1.height);\n"
"\n"
"}\n"
"function CreateView(x, y, w, h, name, DisplayFunc, visible, index)\n"
"{\n"
"	var idx = Views.length;\n"
"	var c0 = CanvasArray0[idx];\n"
"	var c1 = CanvasArray1[idx];\n"
"	if(!c0)\n"
"	{\n"
"		c0 = document.createElement(\'canvas\');\n"
"		CanvasArray0[idx] = c0;\n"
"	}\n"
"	if(!c1)\n"
"	{\n"
"		c1 = document.createElement(\'canvas\');\n"
"		CanvasArray1[idx] = c1;\n"
"	}\n"
"	var View = {};\n"
"	View.x = x;\n"
"	View.y = y;\n"
"	View.w = w;\n"
"	View.h = h;\n"
"	View.Canvas = [c0, c1];\n"
"	View.OffscreenData = [null, null];\n"
"	View.visible = visible;\n"
"	View.index = index;\n"
"	ResizeCanvasDPR(w, h, c0);\n"
"	ResizeCanvasDPR(w, h, c1);\n"
"\n"
"	c0.getContext(\'2d\').clearRect(0, 0, w, h);\n"
"	c1.getContext(\'2d\').clearRect(0, 0, w, h);\n"
"	View.OffscreenData[0] = c0.getContext(\'2d\').getImageData(0, 0, c0.width, c0.height);\n"
"	View.OffscreenData[1] = c1.getContext(\'2d\').getImageData(0, 0, c1.width, c1.height);\n"
"	View.BackBuffer = 0;\n"
"	View.DisplayFunc = DisplayFunc;\n"
"	Views.push(View);\n"
"	return View;\n"
"}\n"
"\n"
"function CreateViews(Width, Height, ViewCompressed)\n"
"{\n"
"	Views = [];\n"
"	var HistoryH = ViewCompressed ? 0 : HistoryHeight;\n"
"	History = CreateView(0, 0, Width, HistoryHeight, \"History\", DrawHistory, true, 0);\n"
"	History.visible = !ViewCompressed;\n"
"	MainView = CreateView(0, HistoryH, Width, Height-HistoryH, \"Main\", DrawGraphSplit, true);\n"
"	X7Views = [];\n"
"	var w = Width / 7;\n"
"	var x = 0;\n"
"	X7Views.push(CreateView(w*0, HistoryH, w, Height - HistoryH, \"x5_0\", DrawBars, false, 0) );\n"
"	X7Views.push(CreateView(w*1, HistoryH, w, Height - HistoryH, \"x5_1\", DrawBars, false, 1) );\n"
"	X7Views.push(CreateView(w*2, HistoryH, w, Height - HistoryH, \"x5_2\", DrawBars, false, 2) );\n"
"	X7Views.push(CreateView(w*3, HistoryH, w, Height - HistoryH, \"x5_3\", DrawBars, false, 3) );\n"
"	X7Views.push(CreateView(w*4, HistoryH, w, Height - HistoryH, \"x5_4\", DrawBars, false, 4) );\n"
"	X7Views.push(CreateView(w*5, HistoryH, w, Height - HistoryH, \"x5_3\", DrawBars, false, 5) );\n"
"	X7Views.push(CreateView(w*6, HistoryH, w, Height - HistoryH, \"x5_3\", DrawBars, false, 6) );\n"
"	X7LegendView = CreateView(0, Height-X7LegendOffset, Width, X7LegendOffset, \"x7_legend\", DrawBarsLegend, false, 0);\n"
"\n"
"}\n"
"\n"
"function ResizeCanvas() \n"
"{\n"
"	nWidth = window.innerWidth;\n"
"	nHeight = window.innerHeight;\n"
"	DPR = Settings.AllowHighDPI ? window.devicePixelRatio : 0;\n"
"	ResizeCanvasDPR(nWidth, nHeight, CanvasDetailedView);\n"
"	ResizeCanvasDPR(nWidth, nHeight, CanvasDetailedOffscreen);\n"
"\n"
"	if(DPR)\n"
"	{\n"
"		CanvasDetailedView.style.width = nWidth + \'px\'; \n"
"		CanvasDetailedView.style.height = nHeight + \'px\';\n"
"		CanvasDetailedView.width = nWidth * DPR;\n"
"		CanvasDetailedView.height = nHeight * DPR;\n"
"		CanvasDetailedView.getContext(\'2d\').scale(DPR,DPR);\n"
"\n"
"		CanvasDetailedOffscreen.style.width = nWidth + \'px\';\n"
"		CanvasDetailedOffscreen.style.height = nHeight + \'px\';\n"
"		CanvasDetailedOffscreen.width = nWidth * DPR;\n"
"		CanvasDetailedOffscreen.height = nHeight * DPR;\n"
"		CanvasDetailedOffscreen.getContext(\'2d\').scale(DPR,DPR);\n"
"\n"
"	}\n"
"	else\n"
"	{\n"
"		DPR = 1;\n"
"		CanvasDetailedView.width = nWidth;\n"
"		CanvasDetailedView.height = nHeight;\n"
"		CanvasDetailedOffscreen.width = nWidth;\n"
"		CanvasDetailedOffscreen.height = nHeight;\n"
"	}\n"
"	MeasureFont();\n"
"	CreateViews(nWidth, nHeight, Settings.ViewCompressed);\n"
"	ActivateView(Settings.ViewActive);\n"
"}\n"
"\n"
"\n"
"function FormatTime(Time)\n"
"{\n"
"	return Time.toFixed(2);\n"
"}\n"
"var hh = 0;\n"
"\n"
"\n"
"function DrawBarsLegend(View, LocalMouseX, LocalMouseY, SubIndex)\n"
"{\n"
"	ProfileEnter(\"DrawBar\");\n"
"	var TimerMap = FrameData.TimerMap;\n"
"	if(!TimerMap)\n"
"		return;\n"
"	if(Settings.ViewCompressed)\n"
"		return;\n"
"	var Canvas = View.Canvas[View.BackBuffer];\n"
"	var context = Canvas.getContext(\'2d\');\n"
"	context.clearRect(0, 0, View.w, View.h);\n"
"	var X = 0;\n"
"	var Y = View.h/2;\n"
"	var XSpace = 5;\n"
"	var XSpace2 = XSpace * 2;\n"
"	function DrawEntry(T)\n"
"	{\n"
"		X += XSpace2*2;\n"
"		context.fillStyle = T.color;\n"
"		context.fillRect(X-XSpace,Y-XSpace,XSpace2,XSpace2);\n"
"		X += XSpace + 2;\n"
"		context.fillStyle = \'white\';\n"
"		var w = context.measureText(T.name).width;\n"
"		context.fillText(T.name, X, Y + FontHeight/2);\n"
"		X += w;		\n"
"	}\n"
"\n"
"	if(SingleTimerBars == 0)\n"
"	{\n"
"		for(var key in TimerMap)\n"
"		{\n"
"			var idx = GetTimer(key);\n"
"			var T = TimerArray[idx];\n"
"			if(T.e)\n"
"			{\n"
"				DrawEntry(T);\n"
"			}\n"
"		}\n"
"	}\n"
"	else if(EnabledArray.length > 0)\n"
"	{\n"
"		var idx = EnabledArray[0];\n"
"		var T = TimerArray[idx];\n"
"		DrawEntry(T);\n"
"	}		\n"
"}\n"
"\n"
"function DrawBars(View, LocalMouseX, LocalMouseY, SubIndex)\n"
"{\n"
"	var TimerMap = FrameData.TimerMap;\n"
"	if(!TimerMap)\n"
"		return;\n"
"	if(!SubIndex)\n"
"		SubIndex = 0;\n"
"\n"
"	ProfileEnter(\"DrawBar\");\n"
"	var Canvas = View.Canvas[View.BackBuffer];\n"
"	var context = Canvas.getContext(\'2d\');\n"
"\n"
"	context.clearRect(0, 0, View.w, View.h);\n"
"	var bgcolor = nBackColors[ViewIndex%2];\n"
"	context.fillStyle = bgcolor;\n"
"	context.fillRect(0, 0, View.w, View.h);\n"
"	var Title = \"?\";\n"
"	var TitleName = null;\n"
"	var nNumBars = 0;\n"
"	var BarNames = [];\n"
"	var BarTimes = [];\n"
"	var BarColors = [];\n"
"	var AggregateIndex = Settings.AggregateFrames <= 0 ? AggregateHistorySize-1 : AggregateHistorySize-2; //fix med \n"
"	var GetTime = null;\n"
"	var SubIndex = X7BarColumnRemap[SubIndex];\n"
"\n"
"	if(SingleTimerBars == 0)\n"
"	{\n"
"		if(SubIndex == 0)\n"
"		{\n"
"			Title = \"Time\";\n"
"			GetTime = function(FD){ return FD.FrameTime; };\n"
"		}\n"
"		else if(SubIndex == 1)\n"
"		{\n"
"			Title = \"Average\";\n"
"			GetTime = function(FD){ return FD.TimeAvg[AggregateIndex]; };\n"
"		}\n"
"		else if(SubIndex == 2)\n"
"		{\n"
"			Title = \"Max\";\n"
"			GetTime = function(FD){ return FD.TimeMax[AggregateIndex]; };\n"
"		}\n"
"		else if(SubIndex == 3)\n"
"		{\n"
"			Title = \"Min\";\n"
"			GetTime = function(FD){ return FD.TimeMin[AggregateIndex]; };\n"
"		}\n"
"		else if(SubIndex == 4)\n"
"		{\n"
"			Title = \"Exclusive Avg\";\n"
"			GetTime = function(FD){ return FD.TimeExclAvg[AggregateIndex]; };\n"
"		}\n"
"		else if(SubIndex == 5)\n"
"		{\n"
"			Title = \"Exclusive Max\";\n"
"			GetTime = function(FD){ return FD.TimeExclMax[AggregateIndex]; };\n"
"		}\n"
"		else if(SubIndex == 6)\n"
"		{\n"
"			Title = \"Exclusive Min\";\n"
"			GetTime = function(FD){ return FD.TimeExclMin[AggregateIndex]; };\n"
"		}\n"
"		for(var key in TimerMap)\n"
"		{\n"
"			var idx = GetTimer(key);\n"
"			var T = TimerArray[idx];\n"
"			if(T.e)\n"
"			{\n"
"				nNumBars++;\n"
"				var FD = TimerMap[key];\n"
"				var Time = GetTime(FD);\n"
"				BarNames.push(T.name);\n"
"				BarTimes.push(Time);\n"
"				BarColors.push(T.color);\n"
"			}\n"
"		}\n"
"\n"
"	}\n"
"	else if(EnabledArray.length > 0)\n"
"	{\n"
"		var idx = EnabledArray[0];\n"
"		var T = TimerArray[idx];\n"
"		var FD =  GetFrameData(T.id);\n"
"		var Property = null;\n"
"		if(SubIndex == 0)\n"
"		{\n"
"			Title = \"Average\";\n"
"			Property = \"TimeAvg\";\n"
"		}\n"
"		else if(SubIndex == 1)\n"
"		{\n"
"			Title = \"Max\";\n"
"			Property = \"TimeMax\";\n"
"		}\n"
"		else if(SubIndex == 2)\n"
"		{\n"
"			Title = \"Min\";\n"
"			Property = \"TimeMin\";\n"
"		}\n"
"		else if(SubIndex == 3)\n"
"		{\n"
"			Title = \"Exclusive Average\";\n"
"			Property = \"TimeExclAvg\";\n"
"		}\n"
"		else if(SubIndex == 4)\n"
"		{\n"
"			Title = \"Exclusive Max\";\n"
"			Property = \"TimeExclMax\";\n"
"		}\n"
"		else if(SubIndex == 5)\n"
"		{\n"
"			Title = \"Exclusive Min\";\n"
"			Property = \"TimeExclMin\";\n"
"		}\n"
"		else if(SubIndex == 6)\n"
"		{\n"
"			Title = \"Call Average\";\n"
"			Property = \"TimeCallAvg\";\n"
"		}\n"
"		else if(SubIndex == 7)\n"
"		{\n"
"			Title = \"Call Excl Average\";\n"
"			Property = \"TimeCallExclAvg\";\n"
"		}\n"
"		TitleName = T.name;\n"
"		for(var i = 0; i < AggregateHistorySize; ++i)\n"
"		{\n"
"			nNumBars++;\n"
"			var A = FD[Property];\n"
"			var Time = A[i];\n"
"			BarTimes.push(Time);\n"
"			BarColors.push(T.color);\n"
"		}\n"
"	}\n"
"\n"
"\n"
"	if(!nNumBars)\n"
"	{\n"
"		ProfileLeave();\n"
"		return;\n"
"	}\n"
"\n"
"	var h = View.h;\n"
"	var w = View.w;\n"
"	var MsTextExtraSpace = Math.cos(3.14/4.0) * (ViewBarMaxMsTextLength);\n"
"	var DrawXLeft = Settings.ViewCompressed ? 3 : 15;\n"
"	DrawXLeft = Math.max(DrawXLeft, MsTextExtraSpace);\n"
"	var DrawXRight = Settings.ViewCompressed ? 3: 10;\n"
"	var DrawY = 35 * 2;\n"
"	if(Settings.ViewCompressed)\n"
"	{\n"
"		DrawY = (MsTextExtraSpace) + 35;\n"
"	}\n"
"	var DrawWidth = w - DrawXLeft - DrawXRight;\n"
"	var DrawHeight = h - DrawY;\n"
"	var SpaceWidth = 5;\n"
"	var BarWidth = (DrawWidth-SpaceWidth*(nNumBars-1))/ nNumBars;\n"
"	for(var x = 0; x < 2; ++x)\n"
"	{\n"
"		if(BarWidth < 14)\n"
"		{\n"
"			SpaceWidth -= 1;\n"
"			BarWidth = (DrawWidth-SpaceWidth*(nNumBars-1))/ nNumBars;\n"
"		}\n"
"	}\n"
"	if(BarWidth > 50)\n"
"		BarWidth = 50;\n"
"	var BarHeight = DrawHeight - 5;\n"
"\n"
"	var ReferenceTime = ReferenceBar;\n"
"\n"
"	var fHeightScale = h / ReferenceTime;\n"
"	var MouseDragging = 0;\n"
"	var fWidth = w / FRAME_COUNT;\n"
"	var Keys = [];\n"
"	var X = DrawXLeft;\n"
"	var offset = 0;\n"
"	context.textAlign = \'center\';\n"
"	context.fillStyle = \'#ffffff\';\n"
"	context.fillText(Title, w / 2.0, FontHeight);\n"
"	context.textAlign = \'left\';\n"
"	context.fillStyle = \'wheat\';\n"
"	var BaseY = 20;\n"
"	if(SubIndex == X7BarFirstView)\n"
"	{\n"
"		context.fillText(ReferenceTime.toFixed(2) + \'ms\', 0, BaseY - 5 + DrawHeight - BarHeight);\n"
"	}\n"
"	else if(SubIndex == X7BarLastView)\n"
"	{\n"
"		context.textAlign = \'right\';\n"
"		context.fillText(ReferenceTime.toFixed(2) + \'ms\', w, BaseY - 5 + DrawHeight - BarHeight);\n"
"	}\n"
"	context.textAlign = \'right\';\n"
"	var BarFont = FontLarge;\n"
"	var DrawNames = true;\n"
"	if(BarWidth < 14)\n"
"	{\n"
"		DrawNames = BarWidth > 4;\n"
"		var FontXX = \'Bold \' + Math.floor(BarWidth) + \'px Courier New\';\n"
"		BarFont = FontXX;\n"
"\n"
"	}\n"
"	context.font = BarFont;\n"
"	for(var i = 0; i < BarTimes.length; ++i)\n"
"	{\n"
"		var TimeText = FormatTime(Time);\n"
"		var w = context.measureText(TimeText).width;\n"
"		ViewBarMaxMsTextLength = Math.max(w, ViewBarMaxMsTextLength);\n"
"	\n"
"\n"
"	}\n"
"	for(var i = 0; i < BarTimes.length; ++i)\n"
"	{\n"
"		var Time = BarTimes[i];\n"
"		var TimeText = FormatTime(Time);\n"
"		ReferenceBarAutomatic = Math.max(Time, ReferenceBarAutomatic);\n"
"		var Color = BarColors[i];\n"
"		var fPrc = Time / ReferenceTime;\n"
"		if(fPrc > 1.0)\n"
"			fPrc = 1.0;\n"
"		var BarH = fPrc * BarHeight;\n"
"\n"
"		var X0 = X;\n"
"		var Y0 = BaseY + DrawHeight - BarH;\n"
"		context.fillStyle = Color;\n"
"		context.fillRect(X0, Y0, BarWidth, BarH);\n"
"		context.fillStyle = \'#ffffff\';\n"
"		var MouseOver = LocalMouseX > X0 && LocalMouseX < X0 + BarWidth;\n"
"		if(MouseOver || (Settings.ViewCompressed&&DrawNames))\n"
"		{\n"
"			context.save();\n"
"			context.translate(X0 + BarWidth * 0.5, BaseY + DrawHeight - 2);\n"
"			context.rotate(-3.14/2.0);\n"
"			context.font = BarFont;\n"
"			context.textAlign = \'left\';\n"
"			context.textBaseline = \'middle\';\n"
"			var m = context.measureText(BarNames[i]);\n"
"			context.fillStyle = \'black\';\n"
"			context.fillText(BarNames[i], -1, -1);\n"
"			context.fillStyle = \'white\';\n"
"			context.fillText(BarNames[i], 0, 0);\n"
"			context.textAlign = \'right\';\n"
"			context.restore();\n"
"		}\n"
"		context.save();\n"
"		var XText = X+BarWidth;\n"
"		var YText = BaseY + DrawHeight + FontHeight;		\n"
"		context.translate(XText, YText);\n"
"		context.rotate(-3.14/4.0);\n"
"		context.font = BarFont;\n"
"		context.fillText(TimeText, 0, 0);\n"
"		context.restore();\n"
"\n"
"		X += BarWidth + SpaceWidth;\n"
"	}\n"
"	context.font = Font;\n"
"	ProfileLeave();\n"
"}\n"
"\n"
"function SortColumnFromName(Name)\n"
"{\n"
"	//should match switch in drawtableview\n"
"	if(Name == StrAverage)\n"
"	{\n"
"		return 1;\n"
"	}\n"
"	else if(Name == StrMax)\n"
"	{\n"
"		return 2;\n"
"	}\n"
"	else if(Name == StrTotal)\n"
"	{\n"
"		return 3;\n"
"	}			\n"
"	else if(Name == StrMin)\n"
"	{\n"
"		return 4;\n"
"	}\n"
"	else if(Name == StrSpike)\n"
"	{\n"
"		return 5;\n"
"	}\n"
"	else if(Name == StrCallAverage)\n"
"	{\n"
"		return 6;\n"
"	}\n"
"	else if(Name == StrCount)\n"
"	{\n"
"		return 7;\n"
"	}\n"
"	else if(Name == StrExclAverage)\n"
"	{\n"
"		return 8;\n"
"	}\n"
"	else if(Name == StrExclMax)\n"
"	{\n"
"		return 9;\n"
"	}\n"
"	else if(Name == StrGroup)\n"
"	{\n"
"		return -1;\n"
"	}\n"
"	else if(Name == StrTimer)\n"
"	{\n"
"		return -2;\n"
"	}\n"
"	return 0;\n"
"}\n"
"\n"
"function DrawTableView(View, LocalMouseX, LocalMouseY, SubIndex)\n"
"{\n"
"	ProfileEnter(\"DrawTableView\");\n"
"	var Canvas = View.Canvas[View.BackBuffer];\n"
"	var context = Canvas.getContext(\'2d\');\n"
"	var Height = BoxHeight;\n"
"	var Width = nWidth;\n"
"	var Y = Height;\n"
"	var XBase = 0;\n"
"	var nColorIndex = 0;\n"
"	var bMouseIn = 0;\n"
"	var RcpReferenceTime = 1.0 / Settings.ReferenceTime;\n"
"	var CountWidth = 12 * FontWidth;\n"
"	var InnerBoxHeight = BoxHeight-2;\n"
"	var TimerLen = 8;\n"
"	var TimerWidth = TimerLen * FontWidth;\n"
"	var nWidthBars = nBarsWidth+2;\n"
"	var nWidthMs = TimerWidth+2+10;\n"
"	var NameWidth = 200;\n"
"	var R = 0;\n"
"\n"
"	var OffsetY = BoxHeight;\n"
"\n"
"\n"
"	context.clearRect(0, 0, View.w, View.h);\n"
"	context.fillStyle = \'white\';\n"
"	context.font = Font;\n"
"\n"
"\n"
"	function HeaderMouseHandle(XBegin, X, Y, Header)\n"
"	{\n"
"		if(Header == null)\n"
"			debugger;\n"
"		var bMouseIn = LocalMouseY >= Y && LocalMouseY < BoxHeight+Y && LocalMouseX < X && LocalMouseX > XBegin;\n"
"		if(bMouseIn)\n"
"		{\n"
"			SortColumnMouseOverNext = Header;\n"
"		}\n"
"	}\n"
"	function HeaderString(Header)\n"
"	{\n"
"		if(Header == Settings.SortColumnName)\n"
"		{\n"
"			return Header + (Settings.SortColumnOrderFlip ? \'<\' : \'>\');\n"
"		}\n"
"		else\n"
"		{\n"
"			return Header;\n"
"		}\n"
"\n"
"	}\n"
"	function DrawHeaderSplit(Header, Y)\n"
"	{\n"
"		if(Settings.BarColumnEnabledTable[R])\n"
"		{\n"
"			context.fillStyle = \'white\';\n"
"			context.fillText(HeaderString(Header), X, Y + Height-FontAscent);\n"
"			var XBegin = X;\n"
"			X += nWidthBars;\n"
"			context.fillStyle = nBackColorOffset;\n"
"			X += ColumnsWidth[R];\n"
"\n"
"			if(X >= NameWidth)\n"
"			{\n"
"				context.fillRect(X-3, Y, 1, nHeight);\n"
"			}\n"
"			HeaderMouseHandle(XBegin, X, Y, Header);\n"
"		}\n"
"		R++;\n"
"	}\n"
"	function DrawHeaderSplitSingle(Header, Y)\n"
"	{\n"
"		if(Settings.BarColumnEnabledTable[R])\n"
"		{\n"
"			context.fillStyle = \'white\';\n"
"			context.fillText(HeaderString(Header), X, Y + Height-FontAscent);\n"
"			var XBegin = X;\n"
"			X += ColumnsWidth[R];\n"
"			context.fillStyle = nBackColorOffset;\n"
"			if(X >= NameWidth)\n"
"			{\n"
"				context.fillRect(X-3, Y, 1, nHeight);\n"
"			}\n"
"			HeaderMouseHandle(XBegin, X, Y, Header);\n"
"		}\n"
"		R++;\n"
"	}\n"
"	function DrawHeaderSplitLeftRight(HeaderLeft, HeaderRight, Y, Width)\n"
"	{\n"
"		var HeaderLeftS = HeaderString(HeaderLeft);\n"
"		var HeaderRightS = HeaderString(HeaderRight);\n"
"		context.textAlign = \'left\';\n"
"		context.fillStyle = \'white\';\n"
"		context.fillText(HeaderLeftS, X, Y + Height-FontAscent);\n"
"		var wLeft = context.measureText(HeaderLeftS).width;\n"
"		var XBegin = X;\n"
"		X += Width;\n"
"		context.textAlign = \'right\';\n"
"		context.fillText(HeaderRightS, X-5, Y + Height-FontAscent);\n"
"		context.textAlign = \'left\';\n"
"		context.fillStyle = nBackColorOffset;\n"
"		if(X >= NameWidth)\n"
"		{\n"
"			context.fillRect(X-3, 0, 1, nHeight);\n"
"		}\n"
"		HeaderMouseHandle(XBegin, XBegin + wLeft, Y, HeaderLeft);\n"
"		HeaderMouseHandle(XBegin + wLeft, X, Y, HeaderRight);\n"
"\n"
"	}\n"
"	function DrawTimer(Value, Color)\n"
"	{\n"
"		if(Settings.BarColumnEnabledTable[R])\n"
"		{\n"
"			if(null == Value)\n"
"			{\n"
"				X += nWidthBars + ColumnsWidth[R];\n"
"				console.log(\"Should not happen2\\n\");\n"
"				debugger;\n"
"				return;\n"
"			}\n"
"			var Prc = Value * RcpReferenceTime;\n"
"			var YText = Y+Height-FontAscent;\n"
"			if(Prc > 1)\n"
"			{\n"
"				Prc = 1;\n"
"			}\n"
"			context.textAlign = \'left\';\n"
"			context.fillStyle = Color;\n"
"			context.fillRect(X+1, Y+1, Prc * nBarsWidth, InnerBoxHeight);\n"
"			X += nWidthBars;\n"
"			context.fillStyle = \'white\';\n"
"			var TimerText = Value.toFixed(2);\n"
"			var W = context.measureText(TimerText).width + FontWidth;\n"
"			ColumnsWidth[R] = Math.max(W, ColumnsWidth[R]);\n"
"			X += ColumnsWidth[R];\n"
"			context.textAlign = \'right\';\n"
"			context.fillText(TimerText, X - FontWidth, YText);\n"
"			context.textAlign = \'left\';\n"
"		}\n"
"		R++;\n"
"	}\n"
"	function DrawCount(Str)\n"
"	{\n"
"		if(Settings.BarColumnEnabledTable[R])\n"
"		{\n"
"			X += ColumnsWidth[R];\n"
"			context.fillStyle = \'white\';\n"
"			context.textAlign = \'right\';\n"
"			var YText = Y+Height-FontAscent;\n"
"			context.fillText(Str, X-6, YText);\n"
"			var W = Math.max(80, context.measureText(Str).width + FontWidth * 2);\n"
"			ColumnsWidth[R] = Math.max(W, ColumnsWidth[R]);\n"
"\n"
"		}\n"
"		R++;\n"
"	\n"
"	}\n"
"	function DrawMeta(Value, Width, Dec, YText)\n"
"	{\n"
"		Value = FormatMeta(Value, Dec);\n"
"		X += (FontWidth*Width);\n"
"		context.textAlign = \'right\';\n"
"		context.fillText(Value, X-FontWidth, YText);\n"
"		context.textAlign = \'left\';\n"
"	}\n"
"\n"
"	function DrawTimerRow(idx, showgroup)\n"
"	{\n"
"		R = 0;\n"
"		var T = TimerArray[idx];\n"
"		var key = T.id;\n"
"		var FD = TimerMap[key];\n"
"		var AggregateIndex = Settings.AggregateFrames <= 0 ? AggregateHistorySize-1 : AggregateHistorySize-2;\n"
"	\n"
"		var YText = Y+Height-FontAscent;\n"
"		X = NameWidth + XBase;\n"
"\n"
"		nColorIndex = 1-nColorIndex;\n"
"		bMouseIn = LocalMouseY >= Y && LocalMouseY < Y + BoxHeight;\n"
"		context.fillStyle = bMouseIn ? nBackColorOffset : nBackColors[nColorIndex];\n"
"		context.fillRect(0, Y, Width, FontHeight+2);\n"
"\n"
"		DrawTimer(T.time, T.color);\n"
"		DrawTimer(T.excl, T.color);\n"
"\n"
"		DrawTimer(T.average, T.color);\n"
"		DrawTimer(T.max, T.color);\n"
"		DrawTimer(T.min, T.color);\n"
"		DrawTimer(T.total, T.color);\n"
"\n"
"		DrawTimer(T.exclaverage, T.color);\n"
"		DrawTimer(T.exclmax, T.color);\n"
"		DrawTimer(T.excltotal, T.color);\n"
"\n"
"		DrawCount((T.spike?T.spike.toFixed(2):\"0\") + \'%\');\n"
"		DrawTimer(T.callaverage, T.color);\n"
"		DrawTimer(T.callexclaverage, T.color);\n"
"		DrawCount(\'\' + T.callcount);\n"
"\n"
"		context.fillStyle = bMouseIn ? nBackColorOffset : nBackColors[nColorIndex];\n"
"		context.fillRect(0, Y, NameWidth, Height);\n"
"		if(T.idtype == TYPE_GROUP)\n"
"		{\n"
"			context.textAlign = \'left\';\n"
"			context.fillStyle = T.color;\n"
"			context.fillText(T.name, 1, YText);\n"
"		}\n"
"		else\n"
"		{\n"
"			context.textAlign = \'right\';\n"
"			context.fillStyle = T.color;\n"
"			context.fillText(T.name, NameWidth - 5, YText);\n"
"			context.textAlign = \'left\';\n"
"			let P = TimerArray[T.parent];\n"
"			context.fillStyle = P.color;\n"
"			var ParentName = P.name;\n"
"			context.fillText(ParentName, 1, YText);\n"
"		}\n"
"	}\n"
"	function FilterMatch(FilterArray, value)\n"
"	{\n"
"		if(!FilterArray)\n"
"			return true;\n"
"		for(var i = 0; i < FilterArray.length; ++i)\n"
"		{\n"
"			var res = value.search(FilterArray[i]);\n"
"			if(res<0)\n"
"				return false;\n"
"		}\n"
"		return true;\n"
"	}\n"
"	var TimerMap = FrameData.TimerMap;\n"
"	if(!TimerMap)\n"
"	{\n"
"		return;\n"
"	}\n"
"\n"
"	var wfirst = 100;\n"
"	var OrderArray = new Array();\n"
"	var nTotalRows = 0;\n"
"	for(var key i";

const size_t g_MicroProfileHtmlLive_begin_0_size = sizeof(g_MicroProfileHtmlLive_begin_0);
const char g_MicroProfileHtmlLive_begin_1[] =
"n TimerMap)\n"
"	{\n"
"		var idx = GetTimer(key);\n"
"		var T = TimerArray[idx];\n"
"		if(T.e)\n"
"		{\n"
"			OrderArray.push(idx);\n"
"			wfirst = wfirst < T.wtotal ? T.wtotal : wfirst;\n"
"			nTotalRows++;\n"
"		}\n"
"	}\n"
"	NameWidth = wfirst + 20;\n"
"\n"
"\n"
"	var nTotalRowPixels = nTotalRows * Height;\n"
"	var nFrameRows = nHeight - HistoryHeight - BoxHeight;\n"
"	if(nTotalRowPixels > nFrameRows)\n"
"	{\n"
"		if(nOffsetBarsY + nFrameRows > nTotalRowPixels)\n"
"		{\n"
"			nOffsetBarsY = nTotalRowPixels - nFrameRows;\n"
"		}\n"
"	}\n"
"	else\n"
"	{\n"
"		nOffsetBarsY = 0;\n"
"	}\n"
"	Y = Y - nOffsetBarsY;\n"
"	Y += OffsetY;\n"
"	XBase = XBase - nOffsetBarsX;\n"
"\n"
"	if(1)\n"
"	{\n"
"		let Flip = Settings.SortColumnOrderFlip == 1 ? -1 : 1;\n"
"		let StringCompare = function(Key)\n"
"		{\n"
"			let F = function(A, B)\n"
"			{\n"
"				let s1 = Key(A);\n"
"				let s2 = Key(B);\n"
"				return Flip * s2.localeCompare(s1);\n"
"			};\n"
"			return F;\n"
"		};\n"
"		let NumberCompare = function(Key)\n"
"		{\n"
"			let F = function(A, B)\n"
"			{\n"
"				let v0 = Key(B);\n"
"				let v1 = Key(A);\n"
"				return Flip * (v0 - v1);\n"
"					//Key(B) - Key(A));\n"
"			};\n"
"			return F;\n"
"		};\n"
"		let N = Settings.SortColumnName;\n"
"		if(N == StrTime)\n"
"		{\n"
"			let Do = function()\n"
"			{\n"
"				for(var i = 0; i < OrderArray.length; ++i)\n"
"				{\n"
"					let t = TimerArray[OrderArray[i]];\n"
"					console.log(\"\", i, OrderArray[i], t.name, t.id, t.time);\n"
"				};\n"
"\n"
"			};\n"
"			// Do();\n"
"			OrderArray.sort( NumberCompare( function (a) { \n"
"				return TimerArray[a].time; \n"
"			} ) );\n"
"			// Do();\n"
"		}\n"
"		else if(N == StrExclusive)\n"
"		{\n"
"			OrderArray.sort( NumberCompare( function (a) { return TimerArray[a].excl; } ) );\n"
"		}\n"
"		else if(N == StrAverage)\n"
"		{\n"
"			OrderArray.sort( NumberCompare( function (a) { return TimerArray[a].average; } ) );\n"
"		}\n"
"		else if(N == StrMax)\n"
"		{\n"
"			OrderArray.sort( NumberCompare( function (a) { return TimerArray[a].max; } ) );\n"
"		}\n"
"		else if(N == StrTotal)\n"
"		{\n"
"			OrderArray.sort( NumberCompare( function (a) { return TimerArray[a].total; } ) );\n"
"		}			\n"
"		else if(N == StrMin)\n"
"		{\n"
"			OrderArray.sort( NumberCompare( function (a) { return TimerArray[a].min; } ) );\n"
"		}\n"
"		else if(N == StrSpike)\n"
"		{\n"
"			OrderArray.sort( NumberCompare( function (a) { return TimerArray[a].spike; } ) );\n"
"		}\n"
"		else if(N == StrCallAverage)\n"
"		{\n"
"			OrderArray.sort( NumberCompare( function (a) { return TimerArray[a].callaverage; } ) );\n"
"		}\n"
"		else if(N == StrCount)\n"
"		{\n"
"			OrderArray.sort( NumberCompare( function (a) { return TimerArray[a].count; } ) );\n"
"		}\n"
"		else if(N == StrExclAverage)\n"
"		{\n"
"			OrderArray.sort( NumberCompare( function (a) { return TimerArray[a].exclaverage; } ) );\n"
"		}\n"
"		else if(N == StrExclMax)\n"
"		{\n"
"			OrderArray.sort( NumberCompare( function (a) { return TimerArray[a].exclmax; } ) );\n"
"		}\n"
"		else if(N == StrExclTotal)\n"
"		{\n"
"			OrderArray.sort( NumberCompare( function (a) { return TimerArray[a].excltotal; } ) );\n"
"		}\n"
"		else if(N == StrGroup)\n"
"		{\n"
"			OrderArray.sort( StringCompare( function (a) { return TimerArray[TimerArray[a].parent].name; } ) );\n"
"		}\n"
"		else if(N == StrTimer)\n"
"		{\n"
"			OrderArray.sort( StringCompare( function (a) { return TimerArray[a].name; } ) );\n"
"		}\n"
"		else\n"
"		{\n"
"			if(N != \"\")\n"
"			{\n"
"				console.log(\"unhandle sortkey\", N);\n"
"				debugger;\n"
"			}\n"
"\n"
"			OrderArray.sort( StringCompare( function (a) { return TimerArray[a].sortkey; } ) );\n"
"		}\n"
"	}\n"
"\n"
"	let ColorHigh = \'#85929e\';\n"
"\n"
"\n"
"	for(var i = 0; i < OrderArray.length; ++i)\n"
"	{\n"
"		var idx = OrderArray[i];\n"
"		var T = TimerArray[idx];\n"
"		if(T.idtype == TYPE_GROUP)\n"
"		{\n"
"			DrawTimerRow(idx, 1);\n"
"			Y += Height;\n"
"		}\n"
"	}\n"
"	let SplitY = Y;\n"
"\n"
"	for(var i = 0; i < OrderArray.length; ++i)\n"
"	{\n"
"		var idx = OrderArray[i];\n"
"		var T = TimerArray[idx];\n"
"		if(T.idtype != TYPE_GROUP)\n"
"		{\n"
"			DrawTimerRow(idx, 1);\n"
"			Y += Height;\n"
"		}\n"
"	}\n"
"\n"
"	var X = 0;\n"
"	context.fillStyle = nBackColorOffset;\n"
"	context.fillRect(0, 0, Width, 2*Height);\n"
"	context.fillStyle = \'white\';\n"
"	SortColumnMouseOverNext = null;\n"
"	X = NameWidth + XBase;\n"
"	R = 0;\n"
"\n"
"	let Aggr = Settings.AggregateFrames <= 0 ? AggregateCurrent : Settings.AggregateFrames;\n"
"	let Headers = [\"Per Frame\", \"Aggregate/\" + Aggr + \" Frames\", \"Call/\" + Aggr + \" Frames\"];\n"
"	let SplitX = [0,0,0];\n"
"\n"
"	DrawHeaderSplit(StrTime,OffsetY);\n"
"	DrawHeaderSplit(StrExclusive, OffsetY);\n"
"	SplitX[0] = X;\n"
"\n"
"	DrawHeaderSplit(StrAverage, OffsetY);\n"
"	DrawHeaderSplit(StrMax, OffsetY);\n"
"	DrawHeaderSplit(StrMin, OffsetY);\n"
"	DrawHeaderSplit(StrTotal, OffsetY);\n"
"\n"
"	DrawHeaderSplit(StrExclAverage, OffsetY);\n"
"	DrawHeaderSplit(StrExclMax, OffsetY);\n"
"	DrawHeaderSplit(StrExclTotal, OffsetY);\n"
"	\n"
"	DrawHeaderSplitSingle(StrSpike, OffsetY);\n"
"	SplitX[1] = X;\n"
"\n"
"	DrawHeaderSplit(StrCallAverage, OffsetY);\n"
"	DrawHeaderSplit(StrCallExclAverage, OffsetY);\n"
"	DrawHeaderSplitSingle(StrCount, OffsetY);\n"
"	SplitX[2] = X;\n"
"\n"
"	context.fillStyle = \'white\';\n"
"	for(var i = 0; i < SplitX.length; ++i)\n"
"	{\n"
"		var X0 = i == 0 ? (NameWidth + XBase) : SplitX[i-1];\n"
"		var X1 = SplitX[i];\n"
"		if(X0 != X1)\n"
"		{\n"
"			context.fillText(Headers[i], X0 + 1, Height-FontAscent);\n"
"		}\n"
"	}\n"
"\n"
"\n"
"	X = 0;\n"
"	context.fillStyle = nBackColorOffset;\n"
"	context.fillRect(0, 0, NameWidth, Height * 2);\n"
"	context.fillStyle = \'white\';\n"
"	DrawHeaderSplitLeftRight(StrGroup, StrTimer, 0, NameWidth);\n"
"\n"
"\n"
"	for(var i = 0; i < SplitX.length; ++i)\n"
"	{\n"
"		var X0 = i == 0 ? (NameWidth + XBase) : SplitX[i-1];\n"
"		var X1 = SplitX[i];\n"
"		if(X0 != X1)\n"
"		{\n"
"			context.fillStyle = ColorHigh;\n"
"			if(X1 >= NameWidth)\n"
"				context.fillRect(X1-2.5, 0, 2, nHeight);\n"
"			if(X0 >= NameWidth)\n"
"				context.fillRect(X0-2.5, 0, 2, nHeight);\n"
"		}\n"
"	}\n"
"	context.fillStyle = ColorHigh;\n"
"	context.fillRect(0, 2*Height-1, nWidth, 2);\n"
"\n"
"	context.fillStyle = ColorHigh;\n"
"	context.fillRect(0, SplitY-1, nWidth, 2);\n"
"\n"
"\n"
"	ProfileLeave();\n"
"}\n"
"function DrawGraphThreadGroup(View, LocalMouseX, LocalMouseY, SubIndex)\n"
"{\n"
"	DrawGraphThreadExclusive(View, LocalMouseX, LocalMouseY, SubIndex);\n"
"}\n"
"function DrawGraphSplit(View, LocalMouseX, LocalMouseY, SubIndex)\n"
"{\n"
"	DrawGraph(View, LocalMouseX, LocalMouseY, SubIndex, 1);\n"
"}\n"
"\n"
"function DrawGraphThreadExclusive(View, LocalMouseX, LocalMouseY, SubIndex, Split)\n"
"{\n"
"	var TimerMap = FrameData.TimerMap;\n"
"	if(!TimerMap)\n"
"		return;\n"
"\n"
"	ProfileEnter(\"DrawGraphThreadExclusive\");\n"
"	var Canvas = View.Canvas[View.BackBuffer];\n"
"	var context = Canvas.getContext(\'2d\');\n"
"	context.clearRect(0, 0, View.w, View.h);\n"
"\n"
"	var h = View.h;\n"
"	var w = View.w;\n"
"	var fHeightScale = h / ReferenceGraph;\n"
"	var MouseDragging = 0;\n"
"	var fWidth = w / FRAME_COUNT;\n"
"	var MouseTime = ReferenceGraph * (1-(LocalMouseY / h));\n"
"	var HighlightKey = 0;\n"
"	var HighlightFrame = -1;\n"
"\n"
"\n"
"	var NumGraphs = 0;\n"
"	for(let k in ThreadInfo)\n"
"	{\n"
"		NumGraphs++;\n"
"	}\n"
"	if(NumGraphs)\n"
"	{\n"
"		let hstart = 0;\n"
"		let gh = h / NumGraphs;\n"
"		let cidx = 1;\n"
"		let Count = FRAME_COUNT;\n"
"		let Last = AllocClearedArray(Count);\n"
"		let FT = FrameData.Time;\n"
"		let RcpFT = AllocClearedArray(Count);\n"
"		if(FT.length != RcpFT.length)\n"
"			debugger;\n"
"		for(let k = 0; k < RcpFT.length; ++k)\n"
"		{\n"
"			if(FT[k] != 0)\n"
"			{\n"
"				RcpFT[k] = 1.0 / FT[k];\n"
"			}\n"
"			else\n"
"			{\n"
"				RcpFT[k] = 0;\n"
"			}\n"
"		}\n"
"\n"
"		for(let k in ThreadInfo)\n"
"		{\n"
"			for(let j = 0; j < Last.length; ++j)\n"
"				Last[j] = 0.0;\n"
"			let TI = ThreadInfo[k];\n"
"			let X = 0;\n"
"			let Y = hstart + gh;\n"
"			var YStart = Y;\n"
"			if(LocalMouseX >= 0 && LocalMouseY >= hstart && LocalMouseX < w && LocalMouseY <= Y)\n"
"			{\n"
"				HighlightKey = k;\n"
"				HighlightFrame = Math.floor(FRAME_COUNT * LocalMouseX / w);	\n"
"			}\n"
"\n"
"\n"
"			context.globalAlpha = 1;\n"
"			context.fillStyle = nBackColorsDark[cidx];\n"
"			cidx = 1-cidx;\n"
"			context.fillRect(0, hstart, w, gh);\n"
"			context.strokeStyle = \'white\';\n"
"			context.fillStyle = \'white\';\n"
"			for(let l = 0; l < TI.a.length; ++l)\n"
"			{\n"
"				X = 0;\n"
"				let a = TI.a[l];\n"
"				if(a.length != Count)\n"
"				{\n"
"					console.log(\"should not happen!\\n\");\n"
"					debugger;\n"
"				}\n"
"				let idx = GetTimer(TI.ids[l]);\n"
"				let c = TimerArray[idx].color;\n"
"				context.strokeStyle = c;\n"
"				context.fillStyle = c;\n"
"				context.beginPath();\n"
"\n"
"				for(let m = Last.length-1;m >= 0; m--)\n"
"				{\n"
"					let XX = X + fWidth * m;\n"
"					Y = Math.max(YStart - Last[m] * gh, hstart);\n"
"					if(m == Last.length-1)\n"
"					{\n"
"						context.moveTo(XX, Y);\n"
"					}\n"
"					else\n"
"					{\n"
"						context.lineTo(XX, Y);\n"
"					}\n"
"				}\n"
"\n"
"				for(let m = 0; m < a.length; ++m)\n"
"				{\n"
"\n"
"					let h = a[m] * RcpFT[m];\n"
"					if(h > 1.1)\n"
"					{\n"
"						console.log(\"should not happen \", a[m], RcpFT[m], h);\n"
"						debugger;\n"
"						h = 1;\n"
"						//todo...\n"
"					}\n"
"					let hm = h + Last[m];\n"
"					if(hm > 1.1)\n"
"					{\n"
"						console.log(\"should not happen \", hm, h, Last[m]);\n"
"						debugger;\n"
"						hm = 1;\n"
"						//todo...\n"
"					}\n"
"					Y = Math.max(YStart - hm * gh, hstart);\n"
"					context.lineTo(X, Y);\n"
"					X += fWidth;\n"
"					Last[m] = hm;\n"
"				}\n"
"				context.fill();\n"
"\n"
"			}\n"
"			context.fillStyle = \'wheat\';\n"
"			context.textAlign=\'right\';\n"
"			context.fillText(\'100%\', nWidth, hstart + FontHeight);\n"
"			context.textAlign=\'left\';\n"
"			context.fillText(TI.n, 0, hstart + FontHeight);\n"
"			hstart += gh;\n"
"		}\n"
"	}\n"
"\n"
"	if(HighlightKey != 0 && SubMenuActive == -1)\n"
"	{\n"
"		ToolTipCallback = function(canvas, x, y)\n"
"		{\n"
"			let TI = ThreadInfo[HighlightKey];\n"
"			let ret = [];\n"
"			let colors = [];\n"
"			for(let l = 0; l < TI.a.length; ++l)\n"
"			{\n"
"				let a = TI.a[l];\n"
"				let idx = GetTimer(TI.ids[l]);\n"
"				let c = TimerArray[idx].color;\n"
"				colors.push(c);\n"
"				ret.push(TimerArray[idx].name);\n"
"				let t = FormatTime(a[HighlightFrame]) + \'ms\';\n"
"				colors.push(\'white\');\n"
"				ret.push(t);\n"
"			}\n"
"			return {c:colors, a:ret};\n"
"		}\n"
"	}\n"
"\n"
"	ProfileLeave();\n"
"}\n"
"\n"
"function DrawGraphPercentile(View, LocalMouseX, LocalMouseY, SubIndex)\n"
"{\n"
"	let TimerMap = FrameData.TimerMap;\n"
"	if(!TimerMap)\n"
"		return;\n"
"\n"
"	ProfileEnter(\"DrawGraphPercentile\");\n"
"	let Canvas = View.Canvas[View.BackBuffer];\n"
"	let context = Canvas.getContext(\'2d\');\n"
"	context.clearRect(0, 0, View.w, View.h);\n"
"\n"
"	let h = View.h;\n"
"	let w = View.w;\n"
"	let NumGraphs = 0;\n"
"	let ToolTips = Array();\n"
"	for(let key in TimerMap)\n"
"	{\n"
"		if(!IsGroup(key))\n"
"		{\n"
"			let idx = GetTimer(key);\n"
"			if(TimerArray[idx].e)\n"
"			{\n"
"				NumGraphs++;\n"
"			}\n"
"		}\n"
"	}\n"
"	if(NumGraphs)\n"
"	{\n"
"		let hstart = 0;\n"
"		let gh = h / NumGraphs;\n"
"		let Keys = [];\n"
"		let cidx = 1;\n"
"\n"
"		if(LocalMouseX >= 0 && LocalMouseY >= 0 && LocalMouseX < w && LocalMouseY < h && SubMenuActive == -1)\n"
"		{\n"
"			ToolTipCallback = function(canvas, x, y)\n"
"			{\n"
"				let TimerMap = FrameData.TimerMap;\n"
"				let context = canvas.getContext(\'2d\');\n"
"				context.font = Font;\n"
"				let XPos = x - 20;\n"
"				for(let key in TimerMap)\n"
"				{\n"
"					let idx = GetTimer(key);\n"
"					let TimerState = TimerMap[key];\n"
"					let T = TimerArray[idx];\n"
"					if(!IsGroup(key) && T.e && TimerState.PercentileMax > TimerState.PercentileMin)\n"
"					{\n"
"						let HighlightIndex = -1;\n"
"						let Max = TimerState.PercentileMax;\n"
"						let Min = TimerState.PercentileMin;\n"
"						let h = View.h;\n"
"						let w = View.w;\n"
"						let tooltipstring = TimerState.tooltipstring;\n"
"\n"
"						if(LocalMouseX >= 0 && LocalMouseY >= 0 && LocalMouseX < w && LocalMouseY < h && SubMenuActive == -1 && tooltipstring)\n"
"						{\n"
"							if(TimerState.tooltipysoft)\n"
"							{\n"
"								let RATE = 0.05;\n"
"								if(Math.abs(TimerState.tooltipysoft - TimerState.tooltipy) > 6)\n"
"								{\n"
"									TimerState.tooltipysoft = TimerState.tooltipy * RATE + TimerState.tooltipysoft * (1-RATE);\n"
"								}\n"
"							}\n"
"							else\n"
"							{\n"
"								TimerState.tooltipysoft = TimerState.tooltipy;\n"
"							}\n"
"							let Y = TimerState.tooltipysoft;\n"
"							let wtext = context.measureText(tooltipstring, XPos, Y).width;\n"
"							let X = Math.max(0, XPos - wtext);\n"
"							context.fillStyle = \'black\';\n"
"							context.fillRect(X - 1, Y-1 , wtext+2, BoxHeight+2);\n"
"							context.fillStyle = \'white\';\n"
"							context.textAlign = \'right\';\n"
"							context.fillText(tooltipstring, X + wtext, Y+BoxHeight-2);\n"
"\n"
"						}\n"
"					}\n"
"					context.textAlign = \'left\';\n"
"				}\n"
"			}\n"
"		}\n"
"\n"
"\n"
"		for(let key in TimerMap)\n"
"		{\n"
"			let idx = GetTimer(key);\n"
"			let TimerState = TimerMap[key];\n"
"			TimerState.tooltipstring = null;\n"
"			if(!IsGroup(key) && TimerArray[idx].e && TimerState.PercentileMax > TimerState.PercentileMin)\n"
"			{\n"
"				let Max = TimerState.PercentileMax;\n"
"				let Min = TimerState.PercentileMin;\n"
"				let SubGraphSettings = GetSubGraphSettings(key);\n"
"				let Percentile = SubGraphSettings.Percentile;\n"
"				if(Percentile == null)\n"
"					Percentile = 0.0;\n"
"				Percentile = Math.max(0.0, Math.min(99.0, Percentile));\n"
"				if(!SubGraphSettings.AutomaticReference)\n"
"				{\n"
"					Max = SubGraphSettings.ReferenceTime;\n"
"				}\n"
"				let Reference = Max;\n"
"\n"
"				let PercentileData = TimerState.Percentile;\n"
"				let Total = PercentileData.length-1;\n"
"				let NumElementsOnScreen = Total * (100 - Percentile) / (100);\n"
"				let WidthPerElement = w / NumElementsOnScreen;\n"
"				let TotalWidth = Total * WidthPerElement;\n"
"				let PercentilePrc = Percentile / 100;\n"
"				let PercentileOffset = PercentilePrc * TotalWidth;\n"
"				let fHeightScale2 = gh / Max;\n"
"				let color = TimerArray[idx].color;\n"
"				let X = 0;\n"
"				let Y = hstart + gh;\n"
"				let YStart = Y;\n"
"				let MouseInside = LocalMouseX >= 0 && LocalMouseY >= 0 && LocalMouseX < w && LocalMouseY < h && SubMenuActive == -1;\n"
"\n"
"\n"
"				context.globalAlpha = 1;\n"
"				context.fillStyle = nBackColorsDark[cidx];\n"
"				cidx = 1-cidx;\n"
"				context.fillRect(0, hstart, w, gh);\n"
"				context.strokeStyle = color;\n"
"				context.fillStyle = color;\n"
"				let PercentileStart = Math.max(0, Math.floor(0.01*Percentile / PercentileData.length));\n"
"				{\n"
"					context.beginPath();\n"
"					context.moveTo(X,Y);\n"
"					for(let i = PercentileStart; i < PercentileData.length; ++i)\n"
"					{\n"
"						X = i * WidthPerElement - PercentileOffset;\n"
"						Y = Math.max(YStart - PercentileData[i] * fHeightScale2, hstart);\n"
"						context.lineTo(X, Y);\n"
"					}\n"
"					context.stroke();\n"
"					context.lineTo(X, YStart);\n"
"					context.globalAlpha = GRAPH_ALPHA;\n"
"					context.fill();\n"
"				}\n"
"				context.globalAlpha = 1;\n"
"				context.fillStyle = \'wheat\';\n"
"				context.textAlign=\'right\';\n"
"				context.fillText(FormatTime(Reference) + \'ms\', nWidth, hstart + FontHeight);\n"
"				context.fillText(\'100%\', nWidth, hstart + gh-2);\n"
"				context.textAlign=\'centered\';\n"
"				context.fillText( ((Percentile + 100)/2) + \'%\', nWidth/2, hstart + gh-2);\n"
"				context.textAlign=\'left\';\n"
"				context.fillText(Percentile + \"%  [Samples:\" + PercentileData.length + \"]\", 0, hstart + gh-2);\n"
"				context.fillText(TimerArray[idx].name, 15, hstart + FontHeight);\n"
"				context.fillText(Percentile + \'%\', nWidth, hstart + FontHeight);\n"
"\n"
"				if(MouseInside)\n"
"				{\n"
"					let Element = (PercentileOffset + LocalMouseX) / WidthPerElement;\n"
"					let Rounded = Math.round(Element); \n"
"					let HighlightIndex = Math.max(0, Math.min(Rounded, PercentileData.length-1));\n"
"					X = HighlightIndex * WidthPerElement - PercentileOffset;\n"
"					let Y = YStart - Math.min(PercentileData[HighlightIndex], Reference) * fHeightScale2;\n"
"					context.strokeStyle = color;\n"
"					context.beginPath();\n"
"					let CrossX = X;\n"
"					let CrossY = Y;\n"
"					context.moveTo(CrossX-2, CrossY-2);\n"
"					context.lineTo(CrossX+2, CrossY+2);\n"
"					context.moveTo(CrossX+2, CrossY-2);\n"
"					context.lineTo(CrossX-2, CrossY+2);\n"
"					context.moveTo(CrossX, hstart);\n"
"					context.lineTo(CrossX, hstart + gh);\n"
"					context.stroke();\n"
"					TimerState.tooltipy = Math.min(YStart - BoxHeight, Y) + View.y;\n"
"					let Perc = 100 * HighlightIndex / (PercentileData.length-1)\n"
"					TimerState.tooltipstring = FormatTime(Perc) + \'% \' + FormatTime(PercentileData[HighlightIndex]) + \'ms\';;\n"
"				}\n"
"				hstart += gh;\n"
"			}\n"
"		}\n"
"	}\n"
"	ProfileLeave();\n"
"}\n"
"\n"
"\n"
"\n"
"function DrawGraph(View, LocalMouseX, LocalMouseY, SubIndex, Split)\n"
"{\n"
"	var TimerMap = FrameData.TimerMap;\n"
"	if(!TimerMap)\n"
"		return;\n"
"\n"
"	ProfileEnter(\"DrawGraph\");\n"
"	var Canvas = View.Canvas[View.BackBuffer];\n"
"	var context = Canvas.getContext(\'2d\');\n"
"	context.clearRect(0, 0, View.w, View.h);\n"
"\n"
"	var h = View.h;\n"
"	var w = View.w;\n"
"	var fHeightScale = h / ReferenceGraph;\n"
"	var MouseDragging = 0;\n"
"	var fWidth = w / FRAME_COUNT;\n"
"	var HighlightFrame = -1;\n"
"	var GraphKey = null;\n"
"	var GraphBest = 0;\n"
"	var MouseTime = ReferenceGraph * (1-(LocalMouseY / h));\n"
"\n"
"	if(LocalMouseX >= 0 && LocalMouseY >= 0 && LocalMouseX < w && LocalMouseY < h && SubMenuActive == -1)\n"
"	{\n"
"		var index = Math.floor(FRAME_COUNT * LocalMouseX / w);\n"
"		HighlightFrame = index;\n"
"		for(var key in TimerMap)\n"
"		{\n"
"			var idx = GetTimer(key);\n"
"			var T = TimerArray[idx];\n"
"			var TimerState = TimerMap[key];\n"
"			var Time = TimerState.Time;\n"
"			if(Time[index] >= MouseTime && (GraphBest == 0 || Time[index] <= GraphBest))\n"
"			{\n"
"				GraphKey = key;\n"
"				GraphBest = Time[index];\n"
"			}\n"
"		}\n"
"		ToolTipCallback = function(canvas, x, y)\n"
"		{\n"
"			if(Split)\n"
"			{\n"
"				var TimerMap = FrameData.TimerMap;\n"
"				var context = canvas.getContext(\'2d\');\n"
"				context.font = Font;\n"
"				var XPos = x - 20;\n"
"				for(var key in TimerMap)\n"
"				{\n"
"					var idx = GetTimer(key);\n"
"					var T = TimerArray[idx];\n"
"					var TimerState = TimerMap[key];\n"
"					var Time = TimerState.Time;\n"
"					if(TimerState.tooltipysoft)\n"
"					{\n"
"						var RATE = 0.05;\n"
"						if(Math.abs(TimerState.tooltipysoft - TimerState.tooltipy) > 6)\n"
"						{\n"
"							TimerState.tooltipysoft = TimerState.tooltipy * RATE + TimerState.tooltipysoft * (1-RATE);\n"
"						}\n"
"					}\n"
"					else\n"
"					{\n"
"						TimerState.tooltipysoft = TimerState.tooltipy;\n"
"					}\n"
"					var Y = TimerState.tooltipysoft;\n"
"					var str = \'\' + FormatTime(Time[index]) + \'ms\';\n"
"					var w = context.measureText(str, XPos, Y).width;\n"
"					var X = Math.max(0, XPos - w);\n"
"					context.fillStyle = \'black\';\n"
"					context.fillRect(X - 1, Y-1 , w+2, BoxHeight+2);\n"
"					context.fillStyle = \'white\';\n"
"					context.textAlign = \'right\';\n"
"					context.fillText(str, X + w, Y+BoxHeight-2);\n"
"\n"
"				}\n"
"				context.textAlign = \'left\';\n"
"			}\n"
"			else\n"
"			{\n"
"				var StringArray = [];\n"
"				var ColorArray = [];\n"
"				var TimerMap = FrameData.TimerMap;\n"
"				for(var key in TimerMap)\n"
"				{\n"
"					if(!IsGroup(key))\n"
"					{\n"
"						var idx = GetTimer(key);\n"
"						var T = TimerArray[idx];\n"
"						var TimerState = TimerMap[key];\n"
"						var Time = TimerState.Time;\n"
"						ColorArray.push(TimerArray[idx].color);\n"
"						StringArray.push(\'\' + T.name);\n"
"						ColorArray.push(\'white\');\n"
"						StringArray.push(\'\' + FormatTime(Time[index]) + \'ms\') ;\n"
"					}\n"
"				}\n"
"				return {c:ColorArray,a:StringArray};	\n"
"			}\n"
"		}\n"
"\n"
"	}\n"
"\n"
"	if(Split)\n"
"	{\n"
"		var NumGraphs = 0;\n"
"		for(var key in TimerMap)\n"
"		{\n"
"			if(!IsGroup(key))\n"
"			{\n"
"				NumGraphs++;\n"
"			}\n"
"		}\n"
"		if(NumGraphs)\n"
"		{\n"
"			var hstart = 0;\n"
"			var gh = h / NumGraphs;\n"
"			var Keys = [];\n"
"			var cidx = 1;\n"
"			for(var key in TimerMap)\n"
"			{\n"
"				var idx = GetTimer(key);\n"
"				var TimerState = TimerMap[key];\n"
"				if(!IsGroup(key))\n"
"				{\n"
"					let SubGraphSettings = GetSubGraphSettings(key);\n"
"					var Reference = GetSubGraphReferenceTime(SubGraphSettings, TimerState);\n"
"					var fHeightScale2 = gh / Reference;\n"
"\n"
"					var Time = TimerState.Time;\n"
"					var color = TimerArray[idx].color;\n"
"					var X = w - Time.length*fWidth;\n"
"					var Y = hstart + gh;\n"
"					var YStart = Y;\n"
"					context.globalAlpha = 1;\n"
"					context.fillStyle = nBackColorsDark[cidx];\n"
"					cidx = 1-cidx;\n"
"					context.fillRect(0, hstart, w, gh);\n"
"					context.strokeStyle = color;\n"
"					context.fillStyle = color;\n"
"					context.beginPath();\n"
"					context.moveTo(X,Y);\n"
"					for(var i = 0; i < Time.length; ++i)\n"
"					{\n"
"						Y = Math.max(YStart - Time[i] * fHeightScale2, hstart);\n"
"						context.lineTo(X, Y);\n"
"						X += fWidth;\n"
"\n"
"					}\n"
"					context.stroke();\n"
"					context.lineTo(X, YStart);\n"
"					context.globalAlpha = GRAPH_ALPHA;\n"
"					context.fill();\n"
"\n"
"\n"
"					context.globalAlpha = 1;\n"
"					context.fillStyle = \'wheat\';\n"
"					context.textAlign=\'right\';\n"
"					context.fillText(FormatTime(Reference) + \'ms\', nWidth, hstart + FontHeight);\n"
"					context.textAlign=\'left\';\n"
"					context.fillText(TimerArray[idx].name, 15, hstart + FontHeight);\n"
"\n"
"					if(HighlightFrame >= 0)\n"
"					{\n"
"						var X = w - Time.length * fWidth + fWidth * HighlightFrame;\n"
"						var Y = YStart - Math.min(Time[HighlightFrame], Reference) * fHeightScale2;\n"
"						context.strokeStyle = color;\n"
"						context.beginPath();\n"
"						var CrossX = X;\n"
"						var CrossY = Y;\n"
"						context.moveTo(CrossX-2, CrossY-2);\n"
"						context.lineTo(CrossX+2, CrossY+2);\n"
"						context.moveTo(CrossX+2, CrossY-2);\n"
"						context.lineTo(CrossX-2, CrossY+2);\n"
"						context.moveTo(CrossX, hstart);\n"
"						context.lineTo(CrossX, hstart + gh);\n"
"						context.stroke();\n"
"						TimerState.tooltipy = Math.min(YStart - BoxHeight, Y) + View.y;\n"
"					}\n"
"					hstart += gh;\n"
"				}\n"
"			}\n"
"		}\n"
"	}\n"
"	else\n"
"	{\n"
"		var Keys = [];\n"
"		var Prev = Array();\n"
"		var He = Array();\n"
"		for(var key in TimerMap)\n"
"		{\n"
"			if(!IsGroup(key))\n"
"			{\n"
"				var idx = GetTimer(key);\n"
"				var TimerState = TimerMap[key];\n"
"				var Time = TimerState.Time;\n"
"				var color = TimerArray[idx].color;\n"
"				var X = w - Time.length*fWidth;\n"
"				var Y = h;\n"
"				while(Time.length > He.length)\n"
"				{\n"
"					He.push(0.0);\n"
"				}\n"
"				for(var i = 0; i < Time.length; ++i)\n"
"				{\n"
"					He[i] += Time[i];\n"
"				}\n"
"			}\n"
"		}\n"
"		if(1) // graph with clipping. this code seems way to complicated\n"
"		{\n"
"			var NumGraphs = 0;\n"
"			var Len = 0;\n"
"			for(let key in TimerMap)\n"
"			{\n"
"				if(!IsGroup(key))\n"
"				{\n"
"					var idx = GetTimer(key);\n"
"					var TimerState = TimerMap[key];						\n"
"					var Time = TimerState.Time;\n"
"					Len = Math.max(Len, Time.length);\n"
"					NumGraphs++;\n"
"				}\n"
"			}\n"
"			let g = Array(Len);\n"
"			for(let i = 0; i < g.length; ++i)\n"
"				g[i] = Array(NumGraphs);\n"
"			let i = 0;\n"
"			for(let key in TimerMap)\n"
"			{\n"
"				if(!IsGroup(key))\n"
"				{\n"
"					var TimerState = TimerMap[key];						\n"
"					var Time = TimerState.Time;\n"
"					let x = GetTimer(key);\n"
"					for(let j = 0; j < Time.length; ++j)\n"
"					{\n"
"						g[j][i] = {k:key, v: Time[j], x:x, c:TimerArray[x].color,n:TimerArray[x].name};\n"
"					}\n"
"					i++;\n"
"				}\n"
"			}\n"
"			for(let i = 0; i < g.length; ++i)\n"
"			{\n"
"				let a = g[i];\n"
"				a.sort( function(l, r){\n"
"					return l.v-r.v;\n"
"				});\n"
"			}\n"
"			let cvt = function(t){ return h - t * fHeightScale; };\n"
"			if(1)\n"
"			{\n"
"				let Segments = Array();\n"
"				let MakeSegment = function(b,e)\n"
"				{\n"
"					let s = {b:b, e:e, a:[]};\n"
"					Segments.push(s);\n"
"					return s;\n"
"				};\n"
"				let MakeEntry = function(y0l, y0h, y1l, y1h, c)\n"
"				{\n"
"					let e ={y0l:y0l,y0h:y0h,y1h:y1h,y1l:y1l,c:c,t:0};\n"
"					return e;\n"
"				};\n"
"\n"
"				let X = 0;\n"
"				for(let i = 1; i < g.length; ++i)\n"
"				{\n"
"					let a0 = g[i-1];\n"
"					let a1 = g[i];\n"
"					let s = MakeSegment(X, X + fWidth);\n"
"					if(a0.length != a1.length)\n"
"					{\n"
"						console.log(\"should not happen!!\");\n"
"						debugger;\n"
"					}\n"
"					let FailIndex = -1;\n"
"					for(let j = 0; j < a0.length; ++j)\n"
"					{\n"
"						if(a0[j].k != a1[j].k)\n"
"						{\n"
"							FailIndex = j;\n"
"							break;\n"
"						}\n"
"\n"
"						let t0l = j > 0 ? a0[j-1].v : 0;\n"
"						let t0h = a0[j].v;\n"
"						let t1l = j > 0 ? a1[j-1].v : 0;\n"
"						let t1h = a1[j].v;\n"
"						let c = a1[j].c;\n"
"						let e = MakeEntry(t0l, t0h, t1l, t1h, c);\n"
"						s.a.push(e); \n"
"					}\n"
"					if(FailIndex >= 0)\n"
"					{\n"
"						let l = a0.length;\n"
"						let ax = Array(l);\n"
"						if(FailIndex + 1 >= l)\n"
"							debugger;///no lines, should not happen.\n"
"						for(let j = FailIndex; j < l; ++j)\n"
"						{\n"
"							//find matching\n"
"							for(let k = FailIndex; k < l; ++k)\n"
"							{\n"
"								if(a1[k].k == a0[j].k)\n"
"								{\n"
"									if(ax[j])\n"
"									{\n"
"										console.log(\"should never happen\");\n"
"										debugger;//should not happen\n"
"									}\n"
"									ax[j] = a1[k];\n"
"									break;\n"
"								}\n"
"							}\n"
"						}\n"
"						//find all intersections within [0-1]\n"
"						let I = [];\n"
"						I.push(0);\n"
"						for(let j = FailIndex; j < l; ++j)\n"
"						{\n"
"							let ya = a0[j].v;\n"
"							let yam = ax[j].v;\n"
"							let ka = yam-ya;\n"
"							for(let k = j + 1; k < l; ++k)\n"
"							{\n"
"								let yb = a0[k].v;\n"
"								let ybm = ax[k].v;\n"
"								let kb = ybm-yb;\n"
"								let num = yb-ya;\n"
"								let denom = ka-kb;\n"
"								if(denom>0.00001||denom < -0.00001)\n"
"								{\n"
"									let x = num/denom;\n"
"									if(x>=0 && x <= 1)\n"
"									{\n"
"										I.push(x);\n"
"									}\n"
"								}\n"
"							}\n"
"						}\n"
"						I.push(1);\n"
"						if(I.length)\n"
"						{\n"
"							I.push(I[0]);\n"
"							I.push(I[0]);\n"
"							I.sort();\n"
"\n"
"							let i = 0;\n"
"							let DIST = 0.00001;\n"
"							while(i+1 < I.length)\n"
"							{\n"
"								if(Math.abs(I[i] - I[i+1]) < DIST)\n"
"								{\n"
"									I.splice(i, 1);\n"
"								}\n"
"								else\n"
"								{\n"
"									i++;\n"
"								}\n"
"							}\n"
"						}\n"
"						for(let i = 0; i < I.length-1; ++i)\n"
"						{\n"
"							let x0 = I[i];\n"
"							let x1 = I[i+1];\n"
"							let xm =  0.5 * (x0+x1);\n"
"							let b = X + x0 * fWidth;\n"
"							let e = X + x1 * fWidth;\n"
"							let c = X + xm * fWidth;\n"
"							let s = MakeSegment(b, e);\n"
"							for(let j = FailIndex; j < l; ++j)\n"
"							{\n"
"								let y = a0[j].v;\n"
"								let yx = ax[j].v;\n"
"								let yd = yx - y;\n"
"								let y0 = y + yd * x0;\n"
"								let y1 = y + yd * x1;\n"
"								let ym = y + yd * xm;\n"
"								let e = MakeEntry(ym, y0, ym, y1, a0[j].c);\n"
"								s.a.push(e); \n"
"							}\n"
"							s.a.sort(function(l, r){\n"
"								return l.y0l-r.y0l;\n"
"							});\n"
"							for(let j = 0; j < s.a.length; ++j)\n"
"							{\n"
"								if(j == 0)\n"
"								{\n"
"									s.a[j].y0l = 0;\n"
"									s.a[j].y1l = 0;\n"
"								}\n"
"								else\n"
"								{\n"
"									s.a[j].y0l = s.a[j-1].y0h;\n"
"									s.a[j].y1l = s.a[j-1].y1h;\n"
"								}\n"
"							}\n"
"						}\n"
"					}\n"
"					X += fWidth;\n"
"				}\n"
"				for(let i = 0; i < Segments.length; ++i)\n"
"				{\n"
"					let s = Segments[i];\n"
"					let X0 = s.b;\n"
"					let X1 = s.e;\n"
"					for(let j = 0; j < s.a.length; ++j)\n"
"					{\n"
"						let e = s.a[j];\n"
"						let xs = [];\n"
"						let ytop = [];\n"
"						let ybot = [];\n"
"						if(!e.t)\n"
"						{\n"
"							e.t = 1;\n"
"							let XB = X0;\n"
"							let XE = X1;\n"
"							xs.push(XB);\n"
"							ytop.push(cvt(e.y0h));\n"
"							ybot.push(cvt(e.y0l));\n"
"							let yeh = e.y1h;\n"
"							let yel = e.y1l;\n"
"							let k = i + 1;\n"
"							let Found = true;\n"
"							while(k < Segments.length && Found)\n"
"							{\n"
"								Found = false;\n"
"								let s = Segments[k];\n"
"								for(let l = 0; l < s.a.length && !Found; ++l)\n"
"								{\n"
"									let e1 = s.a[l];\n"
"									if(!e1.t && e1.c == e.c && Math.abs(e1.y0l-e.y1l) < 0.0001 && Math.abs(e1.y0h - e.y1h) < 0.0001)\n"
"									{\n"
"										e1.t = 1;\n"
"										xs.push(XE);\n"
"										ytop.push(cvt(yeh));\n"
"										ybot.push(cvt(yel));\n"
"										XE = s.e;\n"
"										yeh = e1.y1h;\n"
"										yel = e1.y1l;\n"
"										Found = true;\n"
"										e = e1;\n"
"									}\n"
"								}\n"
"								k++;\n"
"							}\n"
"							xs.push(XE);\n"
"							ytop.push(cvt(yeh));\n"
"							ybot.push(cvt(yel));\n"
"						}\n"
"						if(xs.length)\n"
"						{\n"
"							context.strokeStyle = e.c;\n"
"							context.fillStyle = e.c;\n"
"							context.globalAlpha = GRAPH_ALPHA;\n"
"							context.beginPath();\n"
"							context.moveTo(xs[0], ytop[0]);\n"
"							for(let k = 1; k < xs.length; ++k)\n"
"							{\n"
"								context.lineTo(xs[k], ytop[k]);\n"
"							}\n"
"							for(let k = xs.length-1; k >= 0; --k)\n"
"							{\n"
"								context.lineTo(xs[k], ybot[k]);\n"
"							}\n"
"							context.fill();\n"
"							context.beginPath();\n"
"							context.moveTo(xs[0], ytop[0]);\n"
"							for(let k = 1; k < xs.length; ++k)\n"
"							{\n"
"								context.lineTo(xs[k], ytop[k]);\n"
"							}\n"
"							context.globalAlpha = 1.0;\n"
"							context.stroke();\n"
"						}\n"
"					}\n"
"				}\n"
"			}	\n"
"		}\n"
"		if(0) //old graph code, no clipping\n"
"		{\n"
"			for(var key in TimerMap)\n"
"			{\n"
"				if(!IsGroup(key))\n"
"				{\n"
"					var idx = GetTimer(key);\n"
"					var TimerState = TimerMap[key];\n"
"					var Time = TimerState.Time;\n"
"					var color = TimerArray[idx].color;\n"
"					var X = w - Time.length*fWidth;\n"
"					var Y = h;\n"
"					context.strokeStyle = color;\n"
"					context.fillStyle = color;\n"
"\n"
"					context.beginPath();\n"
"					context.moveTo(X,Y);\n"
"					for(var i = 0; i < Time.length; ++i)\n"
"					{\n"
"						Y = h - Time[i] * fHeightScale;\n"
"						context.lineTo(X, Y);\n"
"						X += fWidth;\n"
"					}\n"
"					context.stroke();\n"
"					context.lineTo(X, h);\n"
"					context.globalAlpha = GRAPH_ALPHA;\n"
"					context.fill();\n"
"					context.globalAlpha = 1;\n"
"				}\n"
"			}\n"
"		}\n"
"		if(HighlightFrame >= 0)\n"
"		{\n"
"			for(var key in TimerMap)\n"
"			{\n"
"				if(!IsGroup(key))\n"
"				{\n"
"					var idx = GetTimer(key);\n"
"					var TimerState = TimerMap[key];\n"
"					var Time = TimerState.Time;\n"
"					var color = TimerArray[idx].color;\n"
"					var X = w - Time.length*fWidth + fWidth * HighlightFrame;\n"
"					var Y = h - Time[HighlightFrame] * fHeightScale;\n"
"					context.strokeStyle = color;\n"
"					context.beginPath();\n"
"					var CrossX = X;\n"
"					var CrossY = Y;\n"
"					context.moveTo(CrossX-2, CrossY-2);\n"
"					context.lineTo(CrossX+2, CrossY+2);\n"
"					context.moveTo(CrossX+2, CrossY-2);\n"
"					context.lineTo(CrossX-2, CrossY+2);\n"
"					context.stroke();\n"
"				}\n"
"			}\n"
"		}\n"
"		context.fillStyle = \'wheat\';\n"
"		context.textAlign=\'right\';\n"
"		context.fillText(FormatTime(ReferenceGraph) + \'ms\', nWidth, FontHeight);\n"
"		context.textAlign=\'left\';\n"
"	}\n"
"\n"
"	ProfileLeave();\n"
"}\n"
"\n"
"function StringHash(s) //note: matching code in microprofile.cpp: uint32_t MicroProfileStringHash(const char* pString)\n"
"{ \n"
"	var h = 0xfeedba3e;\n"
"	for(var i = 0; i < s.length; ++i)\n"
"	{\n"
"		h = s.charCodeAt(i) + ((h << 5) - h);\n"
"		h = h & h;\n"
"	}\n"
"	return Math.abs(h);\n"
"}\n"
"\n"
"function StringColorIndex(Name)\n"
"{\n"
"	var h = StringHash(Name);\n"
"	var cidx = Math.floor(360*(h  / (1<<32-1)) );\n"
"	return cidx;\n"
"}\n"
"\n"
"function ColorFromString(Name, S, L)\n"
"{\n"
"	var H = StringColorIndex(Name);\n"
"	return \"hsl(\" + H + \",\" + S + \"%, \" + L+ \"%)\";\n"
"}\n"
"\n"
"function LerpColor(v)\n"
"{\n"
"	var R_0 = 0;\n"
"	var G_0 = 1;\n"
"	var B_0 = 0;\n"
"\n"
"	var R_1 = 1;\n"
"	var G_1 = 0.5;\n"
"	var B_1 = 0;\n"
"\n"
"	var R_2 = 1;\n"
"	var G_2 = 0;\n"
"	var B_3 = 0;\n"
"	var R;\n"
"	var G;\n"
"	if(v < 0.5)\n"
"	{\n"
"		v *= 2;\n"
"		var v0 = (1-v);\n"
"		R = R_0 * v0 + R_1 * v;\n"
"		G = G_0 * v0 + G_1 * v;\n"
"\n"
"	}\n"
"	else\n"
"	{\n"
"		v = (v-0.5) * 2;\n"
"		var v0 = (1-v);\n"
"		R = R_1 * v0 + R_2 * v;\n"
"		G = G_1 * v0 + G_2 * v;\n"
"	}\n"
"	R *= 255;\n"
"	G *= 255;\n"
"	return \"rgb(\" + R.toFixed(0) + \",\" + G.toFixed(0) + \",0)\";\n"
"\n"
"}\n"
"\n"
"function DrawRange(context, X, XEnd, Y, YEnd, ColorBack, ColorFront)\n"
"{\n"
"	if(X < XEnd)\n"
"	{\n"
"		var W = XEnd - X;\n"
"		var H = YEnd - Y;\n"
"		context.globalAlpha = 0.1;\n"
"		context.fillStyle = ColorBack;\n"
"		context.fillRect(X, Y, W, H);\n"
"		context.globalAlpha = 1;\n"
"		context.strokeStyle = ColorFront;\n"
"		context.beginPath();\n"
"		context.moveTo(X, 0);\n"
"		context.lineTo(X, H);\n"
"		context.moveTo(X+W, 0);\n"
"		context.lineTo(X+W, H);\n"
"		// context.closePath();\n"
"		context.stroke();\n"
"	}\n"
"}\n"
"\n"
"\n"
"function DrawHistory(View, LocalMouseX, LocalMouseY)\n"
"{\n"
"	ProfileEnter(\"DrawHistory\");\n"
"	var Canvas = View.Canvas[View.BackBuffer];\n"
"	var context = Canvas.getContext(\'2d\');\n"
"	context.clearRect(0, 0, View.w, View.h);\n"
"	if(!FrameData.Time)\n"
"		return;\n"
"	var fHeight = View.h;\n"
"	var fWidth = nWidth / FRAME_COUNT;\n"
"	var fHeightScale = fHeight / ReferenceHistory;\n"
"	var fX = 0;\n"
"	var FrameIndex = -1;\n"
"	var MouseDragging = 0;\n"
"	var GreenTime = (Settings.TargetTime * 0.9);\n"
"	var RedBegin = (Settings.TargetTime * 1.1);\n"
"	var LerpDist = 1.0 / (RedBegin - GreenTime);\n"
"	var id0 = -1;\n"
"	var id1 = -1;\n"
"	\n"
"	if(MouseDragActiveXEnd > MouseDragActiveXStart)\n"
"	{\n"
"		var idx0 = Math.ceil(FRAME_COUNT * MouseDragActiveXStart / nWidth);\n"
"		var idx1 = Math.floor(FRAME_COUNT * MouseDragActiveXEnd / nWidth);\n"
"		idx0 = Clamp(idx0, 0, FRAME_COUNT-1);\n"
"		idx1 = Clamp(idx1, 0, FRAME_COUNT-1);\n"
"		id0 = FrameData.Ids[idx0];\n"
"		id1 = FrameData.Ids[idx1];\n"
"	}\n"
"\n"
"\n"
"	var ToolTipFrame = -1;\n"
"	for(var i = 0; i < FRAME_COUNT; i++)\n"
"	{\n"
"		var fMs = FrameData.Time[i];\n"
"		var fPrc = (fMs - GreenTime) * LerpDist;\n"
"		fPrc = Clamp(fPrc, 0, 1);\n"
"		var color = LerpColor(fPrc);\n"
"		var fid = FrameData.Ids[i];\n"
"		if(fid >= id0 && fid <= id1)\n"
"		{\n"
"			color = \'cyan\';\n"
"		}else if(FrameData.Frozen[i])\n"
"		{\n"
"			color = \'purple\';\n"
"		}\n"
"\n"
"\n"
"		var fH = fHeightScale * fMs;\n"
"		var bMouse = LocalMouseX > fX && LocalMouseX < fX + fWidth+1 && MouseY <= HistoryHeight;\n"
"		if(bMouse && !MouseDragging)\n"
"		{\n"
"			context.fillStyle = FRAME_HISTORY_COLOR_GPU;\n"
"			ToolTipFrame = i;\n"
"		}\n"
"		else\n"
"		{\n"
"			context.fillStyle = color;\n"
"		}\n"
"		context.fillRect(fX, fHeight - fH, fWidth-1, fH);\n"
"		fX += fWidth;\n"
"	}\n"
"\n"
"\n"
"	DrawRange(context, MouseDragActiveXStart, MouseDragActiveXEnd, 0, HistoryHeight, \'#59d0ff\', \'#00ddff\');\n"
"\n"
"\n"
"	var fH = fHeight - fHeightScale * Settings.TargetTime;\n"
"	context.fillStyle = \'wheat\';\n"
"	context.strokeStyle = \'wheat\';\n"
"	context.beginPath();\n"
"	context.moveTo(0, fH);\n"
"	context.lineTo(nWidth, fH);\n"
"	// context.closePath();\n"
"	context.stroke();\n"
"	var YText;\n"
"	if(fH > HistoryHeight * 0.25)\n"
"	{\n"
"		YText = fH - FontAscent;\n"
"	}\n"
"	else\n"
"	{\n"
"		YText = fH + FontHeight;\n"
"	}\n"
"\n"
"	context.fillText(Settings.TargetTime + \'ms\', 3, YText);\n"
"	context.textAlign=\'right\';\n"
"	context.fillText(FormatTime(ReferenceHistory) + \'ms\', nWidth, FontHeight);\n"
"	context.textAlign=\'left\';\n"
"\n"
"\n"
"\n"
"	if(ToolTipFrame >= 0)\n"
"	{\n"
"		var fMs = FrameData.Time[ToolTipFrame];\n"
"		var Frozen = FrameData.Frozen[ToolTipFrame];\n"
"		ToolTipCallback = function()\n"
"		{\n"
"			var StringArray = [];\n"
"			StringArray.push(\"Frame\");\n"
"			StringArray.push(\"\" + ToolTipFrame);\n"
"			StringArray.push(\"Time\");\n"
"			StringArray.push(\"\" + fMs.toFixed(3));\n"
"			if(Frozen)\n"
"			{\n"
"				StringArray.push(\"Frozen & Unreliable\");\n"
"				StringArray.push(\"\");\n"
"			}\n"
"			return StringArray;\n"
"		}\n"
"	}\n"
"\n"
"\n"
"	ProfileLeave();\n"
"\n"
"}\n"
"function MouseInRect(Rect)\n"
"{\n"
"	return MouseInside(Rect.x, Rect.y, Rect.w, Rect.h);\n"
"}\n"
"function MouseInside(X, Y, W, H)\n"
"{\n"
"	return MouseX >= X && MouseX <= X + W && MouseY >= Y && MouseY <= Y + H;\n"
"}\n"
"\n"
"var MessageText = \"\";\n"
"var MessageTimeout = -1;\n"
"var MessageTimeoutLast = new Date();\n"
"var MessageShowSpinner = 0;\n"
"function SetMessage(text, TimeOut, ShowSpinner)\n"
"{\n"
"	if(TimeOut)\n"
"	{\n"
"		MessageTimeout = TimeOut;\n"
"	}\n"
"	else\n"
"	{\n"
"		MessageTimeout = -1;\n"
"	}\n"
"	MessageText = text;\n"
"	MessageShowSpinner = ShowSpinner;\n"
"}\n"
"function ClearMessage(Message)\n"
"{\n"
"	if(Message == MessageText)\n"
"	{\n"
"		MessageText = \"\";\n"
"		MessageTimeout = -1;\n"
"	}\n"
"}\n"
"\n"
"function DrawMessage()\n"
"{\n"
"	var context = CanvasDetailedView.";

const size_t g_MicroProfileHtmlLive_begin_1_size = sizeof(g_MicroProfileHtmlLive_begin_1);
const char g_MicroProfileHtmlLive_begin_2[] =
"getContext(\'2d\');\n"
"	var Now = new Date();\n"
"	var Delta = Now - MessageTimeoutLast;\n"
"	if(MessageTimeout>0)\n"
"	{\n"
"		MessageTimeout -= Delta;\n"
"		if(MessageTimeout<= 0)\n"
"		{\n"
"			MessageText = \"\";\n"
"			MessageTimeout = -1;\n"
"		}\n"
"\n"
"	}\n"
"	MessageTimeoutLast = Now;\n"
"\n"
"	var Text = MessageText;\n"
"	var X = nWidth / 2;\n"
"\n"
"	var Y = nHeight / 2;\n"
"	context.font = FontFlash;\n"
"	context.textAlign = \'center\';\n"
"	context.fillStyle = \'red\';\n"
"\n"
"	function MSG(a, Spinner)\n"
"	{\n"
"		context.fillText(a, X, Y);\n"
"		if(Spinner)\n"
"		{\n"
"			var w = context.measureText(a).width;\n"
"			SpinnerDraw(1, context, SpinnerText0, X + 3 + w*0.5, Y - 25,  30, 30);\n"
"			SpinnerDraw(1, context, SpinnerText1, X - 3 - w*0.5 - 30, Y - 25,  30, 30);\n"
"		}\n"
"		Y -= 60;\n"
"	}\n"
"	if(!HelpFade)\n"
"		HelpFade = new Date();\n"
"	var HelpFadeTime = new Date() - HelpFade;\n"
"	if(HelpFadeTime < 2000)\n"
"	{\n"
"		var Alpha = 1 - (HelpFadeTime/2000);\n"
"		context.globalAlpha = Alpha;\n"
"		context.fillText(\"Press \'h\' for help\", X, 200);\n"
"		context.globalAlpha = 1;\n"
"	}\n"
"\n"
"	if(Text != \"\")\n"
"	{\n"
"		MSG(Text);\n"
"	}\n"
"	if(IsFrozen)\n"
"	{\n"
"		MSG(\"FROZEN[space]\");\n"
"	}\n"
"\n"
"	PresetPending++; //hack: wait 20 frames before showing enable messages to prevent it from showing when loading settings. [[[test]]]\n"
"	if(WSIsOpen && PresetPending > 20)\n"
"	{\n"
"		if(Settings.ViewActive != VIEW_COUNTERS)\n"
"		{\n"
"			if(GroupsEnabled == 0)\n"
"			{\n"
"				MSG(\"Paused: Enable groups in \'Control\' menu to unpause\");\n"
"			}\n"
"			if(TimersEnabled == 0 && Settings.ViewActive != VIEW_GRAPH_THREAD_GROUP)\n"
"			{\n"
"				MSG(\"Enable Timers or Functions\");\n"
"			}\n"
"		}\n"
"	}\n"
"	context.textAlign = \'left\';\n"
"	context.font = Font;\n"
"}\n"
"\n"
"function DrawGraphSettingsMenu(context, XBase, Y, width, height)\n"
"{\n"
"	if(SubMenuActive != SubMenuGraphSettings)\n"
"	{\n"
"		SubMenuGraphSettingsIndex = -1;\n"
"		SubMenuGraphSettingsKey = \"\";\n"
"	}\n"
"	if(!ShowMenu())\n"
"	{\n"
"		return;\n"
"	}\n"
"	if(!(Settings.ViewActive == VIEW_GRAPH_SPLIT || Settings.ViewActive == VIEW_GRAPH_PERCENTILE))\n"
"	{\n"
"		return;\n"
"	}\n"
"	let NumGraphs = 0;\n"
"	let TimerMap = FrameData.TimerMap;\n"
"\n"
"	for(let key in TimerMap)\n"
"	{\n"
"		if(!IsGroup(key))\n"
"		{\n"
"			let idx = GetTimer(key);\n"
"			if(TimerArray[idx].e)\n"
"			{\n"
"				NumGraphs++;\n"
"			}\n"
"		}\n"
"	}\n"
"	let h = height;\n"
"	let w = width;\n"
"	let hstart = Y;\n"
"	let gh = h / NumGraphs;\n"
"	NumGraphs = 0;\n"
"	for(let key in TimerMap)\n"
"	{\n"
"		if(!IsGroup(key))\n"
"		{\n"
"			let idx = GetTimer(key);\n"
"			if(TimerArray[idx].e)\n"
"			{\n"
"				let X = XBase+1;\n"
"				let Y = hstart+1;\n"
"				let MenuText = \">\";\n"
"				let w2 = 2 + context.measureText(MenuText).width;\n"
"				let bMouseInside = MouseInside(X, Y, w2, 4 + FontHeight);\n"
"				context.fillStyle = bMouseInside || (SubMenuGraphSettings == SubMenuActive && SubMenuGraphSettingsIndex == NumGraphs) ? nBackColors[1] : \'black\';\n"
"				context.fillRect(X, Y, w2, 4 + FontHeight);\n"
"				context.fillStyle = \'#ffffff\';\n"
"				context.fillText(MenuText, X, Y + FontHeight);\n"
"				context.textAlign = \'left\';\n"
"				if(bMouseInside)\n"
"				{\n"
"					SubMenuGraphSettingsIndex = NumGraphs;\n"
"					SubMenuGraphSettingsKey = key;\n"
"					CaptureButtonX = X + w2 + 2;\n"
"					CaptureButtonY = Y;\n"
"					EnableMenu(SubMenuGraphSettings);\n"
"				}\n"
"				NumGraphs++;\n"
"				hstart += gh;\n"
"\n"
"\n"
"			}\n"
"		}\n"
"	}\n"
"}\n"
"\n"
"function DrawCaptureMenu(context)\n"
"{\n"
"	MouseInCaptureButton = 0;\n"
"	if(!ShowMenu())\n"
"	{\n"
"		return;\n"
"	}\n"
"\n"
"	var CaptureRange = MouseDragActiveXStart < MouseDragActiveXEnd ? \"Selection\" : (\"\"+Settings.CaptureFrames);\n"
"	var CaptureText = \"Capture[\" + CaptureRange + \"]\";\n"
"	var w = 10 + context.measureText(CaptureText).width;\n"
"	var X = nWidth / 2 - w / 2;\n"
"	var XCenter = nWidth / 2;\n"
"	var Y = nHeight - 30;\n"
"	MouseInCaptureButton = MouseInside(X, Y, w, 4 + FontHeight);\n"
"	context.textAlign = \'center\';\n"
"	context.fillStyle = MouseInCaptureButton ? nBackColors[1] : \'black\';\n"
"	context.fillRect(X, Y, w, 4 + FontHeight);\n"
"	context.fillStyle = \'#ffffff\';\n"
"	context.fillText(CaptureText, XCenter, Y + FontHeight);\n"
"\n"
"\n"
"\n"
"	X += w + 2;\n"
"	var MenuText = \"^\";\n"
"	var w2 = 10 + context.measureText(MenuText).width;\n"
"	var bMouseInCaptureMenu = MouseInside(X, Y, w2, 4 + FontHeight);\n"
"	context.fillStyle = bMouseInCaptureMenu ? nBackColors[1] : \'black\';\n"
"	context.fillRect(X, Y, w2, 4 + FontHeight);\n"
"\n"
"	context.fillStyle = \'#ffffff\';\n"
"	context.fillText(MenuText, X + w2*0.5, Y + FontHeight);\n"
"\n"
"	let X1 = X + w2 + 10;\n"
"	if(CaptureTriggerDelta)\n"
"	{\n"
"		let text = FormatTime(CaptureTriggerDelta);\n"
"		let w = 10 + context.measureText(\"text\").width;\n"
"		context.fillStyle = \'black\';\n"
"		context.fillRect(X1, Y, w, 4 + FontHeight);\n"
"		context.fillStyle = \'#ffffff\';\n"
"		context.fillText(text, X1 + w*0.5, Y + FontHeight);	\n"
"		X1 += w;\n"
"	}\n"
"\n"
"	let Pending = (CaptureTriggerTime != null && CaptureTriggerTimeType == 2);\n"
"	if(AutoCaptureEnabled || Pending)\n"
"	{\n"
"		let d = Dots();\n"
"		let AutoStatus = Pending ? (\" pending\" + Dots()) : \"\";\n"
"		let Source = GetAutoCaptureString();\n"
"		let Threshold = FormatTime(Settings.AutoCaptureTheshold);\n"
"		let str = \"Autocapture \" + AutoStatus + \" Source:\'\" + Source + \"\' Threshold:\" + Threshold + \"ms Repeat=\" + (Pending?Settings.AutoCaptureRepeat:AutoCaptureEnabled);\n"
"		let w = 10 + context.measureText(str).width;\n"
"		context.fillStyle = \'black\';\n"
"		context.fillRect(X1, Y, w, 4 + FontHeight);\n"
"		context.fillStyle = \'#ffffff\';\n"
"		context.fillText(str, X1 + w*0.5, Y + FontHeight);	\n"
"		X1 += w;\n"
"	}\n"
"\n"
"	context.textAlign = \'left\';\n"
"	if(bMouseInCaptureMenu)\n"
"	{\n"
"		CaptureButtonX = X + w2;\n"
"		CaptureButtonY = Y;\n"
"		EnableMenu(SubMenuCapture);\n"
"	}	\n"
"}\n"
"function UpdateX7Views()\n"
"{\n"
"	if(Settings.ViewActive == VIEW_BAR_SINGLE || Settings.ViewActive == VIEW_BAR_ALL)\n"
"	{\n"
"		var NumSubViews = 0;\n"
"		var BarColumnEnabled = GetBarColumnEnabled();\n"
"		X7BarFirstView = -1;\n"
"		X7BarLastView = -1;\n"
"		var ViewMask = 0;\n"
"		for(var i = 0; i < BarColumnEnabled.length; ++i)\n"
"		{\n"
"			if(BarColumnEnabled[i])\n"
"			{\n"
"				if(X7BarFirstView == -1)\n"
"					X7BarFirstView = i;\n"
"				X7BarColumnRemap[NumSubViews++] = i;\n"
"				ViewMask = ViewMask | (1 << i);\n"
"				X7BarLastView = i;\n"
"			}\n"
"		}\n"
"		if(ViewMask != X7BarColumnMask)\n"
"		{\n"
"			console.log(\"resizing views\");\n"
"			var w = NumSubViews ? nWidth / NumSubViews : 1;\n"
"			for(var i = 0; i < X7Views.length; ++i)\n"
"			{\n"
"				X7Views[i].visible = i < NumSubViews;\n"
"				if(i < NumSubViews)\n"
"				{\n"
"					var HistoryH = Settings.ViewCompressed ? 0 : HistoryHeight;\n"
"					ResizeView(X7Views[i], w*i, HistoryH, w, nHeight - HistoryH);\n"
"				}\n"
"			}\n"
"			X7BarColumnMask = ViewMask;\n"
"		}\n"
"		X7LegendView.visible = true;\n"
"		ReferenceBarAutomatic = 0;\n"
"	}\n"
"}\n"
"function DrawViews()\n"
"{\n"
"	Plotf(\"DrawViews\");\n"
"	UpdateX7Views();\n"
"	ProfileEnter(\"UpdateViews\");\n"
"	ViewIndex = 0;\n"
"	for(var i = 0; i < Views.length; ++i)\n"
"	{\n"
"		var View = Views[i];\n"
"		if(View.visible)\n"
"		{\n"
"			var LocalMouseX = MouseX - View.x;\n"
"			var LocalMouseY = MouseY - View.y;\n"
"			View.DisplayFunc(View, LocalMouseX, LocalMouseY, View.index);\n"
"			var Canvas = View.Canvas[View.BackBuffer];\n"
"			var Context = Canvas.getContext(\'2d\');\n"
"			ViewIndex++;\n"
"		}\n"
"	}\n"
"	ProfileLeave();\n"
"	var context = CanvasDetailedView.getContext(\'2d\');\n"
"	context.clearRect(0, 0, nWidth, nHeight);\n"
"	ProfileEnter(\"BlitViews\");\n"
"	for(var i = 0; i < Views.length; ++i)\n"
"	{\n"
"		var View = Views[i];\n"
"		if(View.visible)\n"
"		{\n"
"			context.drawImage(View.Canvas[View.BackBuffer], Math.floor(View.x), Math.floor(View.y), View.w, View.h);\n"
"		}\n"
"	}\n"
"\n"
"	DrawCaptureMenu(context);\n"
"	DrawGraphSettingsMenu(context, MainView.x, MainView.y, MainView.w, MainView.h);\n"
"\n"
"	ProfileLeave();\n"
"\n"
"}\n"
"var SubMenuGroup = 0;\n"
"var SubMenuTimers = 1;\n"
"var SubMenuModules = 2;\n"
"var SubMenuFunctions = 3;\n"
"var SubMenuPatched = 4;\n"
"var SubMenuSettings = 5;\n"
"var SubMenuViews = 6;\n"
"var SubMenuPresets = 7;\n"
"var SubMenuColumns = 8;\n"
"var SubMenuCapture = 9;\n"
"var SubMenuGraphSettings = 10;\n"
"var SubMenuGraphSettingsIndex = -1;\n"
"var SubMenuGraphSettingsKey = \"\";\n"
"\n"
"var SubMenuActive = -1;\n"
"var SubMenuTimeoutBase = 0.7;\n"
"var SubMenuMouseX = 0;\n"
"var SubMenuMouseY = 0;\n"
"var SubMenuTimeout = new Date();\n"
"var MenuItems = [];\n"
"var FilterInputTimersValue = \'\';\n"
"var FilterInputGroupsValue = \'\';\n"
"var FilterInputModulesValue = \'\';\n"
"var FilterInputFunctionsValue = \'\';\n"
"var FilterInputPatchedValue = \'\';\n"
"\n"
"\n"
"function MakeMenuItem(name, f, visible)\n"
"{\n"
"	var Item = {};\n"
"	Item.name = name;\n"
"	Item.f = f;\n"
"	Item.w = name.length;\n"
"	Item.x = 0;\n"
"	Item.y = 0;\n"
"	Item.visible = visible;\n"
"	return Item;\n"
"}\n"
"function EnableMenu(m)\n"
"{\n"
"	if(m != SubMenuActive)\n"
"	{\n"
"		if(SubMenuActive == SubMenuTimers)\n"
"		{\n"
"			FilterInputTimersValue = FilterInput.value;\n"
"		}\n"
"		else if(SubMenuActive == SubMenuGroup)\n"
"		{\n"
"			FilterInputGroupsValue = FilterInput.value;\n"
"		}\n"
"		else if(SubMenuActive == SubMenuModules)\n"
"		{\n"
"			FilterInputModulesValue = FilterInput.value;\n"
"		}\n"
"		else if(SubMenuActive == SubMenuFunctions)\n"
"		{\n"
"			FilterInputFunctionsValue = FilterInput.value;\n"
"		}\n"
"		else if(SubMenuActive == SubMenuPatched)\n"
"		{\n"
"			FilterInputPatchedValue = FilterInput.value;\n"
"		}\n"
"\n"
"		SubMenuActive = m;\n"
"		SubMenuTimeout = new Date();\n"
"\n"
"		if(SubMenuActive == SubMenuTimers)\n"
"		{\n"
"			FilterInput.value = FilterInputTimersValue;\n"
"		}\n"
"		else if(SubMenuActive == SubMenuGroup)\n"
"		{\n"
"			FilterInput.value = FilterInputGroupsValue;\n"
"		}\n"
"		else if(SubMenuActive == SubMenuModules)\n"
"		{\n"
"			FilterInput.value = FilterInputModulesValue;\n"
"		}\n"
"		else if(SubMenuActive == SubMenuFunctions)\n"
"		{\n"
"			FilterInput.value = FilterInputFunctionsValue;\n"
"		}\n"
"		else if(SubMenuActive == SubMenuPatched)\n"
"		{\n"
"			FilterInput.value = FilterInputPatchedValue;\n"
"		}\n"
"\n"
"		FilterInputValueLast = FilterInput.value;\n"
"	}\n"
"	if(m == -1)\n"
"	{\n"
"		SubMenuTimeout = 0;\n"
"	}\n"
"\n"
"	if(SubMenuActive == SubMenuTimers || SubMenuActive == SubMenuGroup || SubMenuActive == SubMenuModules || SubMenuActive == SubMenuFunctions || SubMenuActive == SubMenuPatched)\n"
"	{\n"
"		FilterInputDiv.style[\'display\'] = \'inline\';\n"
"		FilterInput.focus();\n"
"	}\n"
"	else\n"
"	{\n"
"		FilterInputDiv.style[\'display\'] = \'none\';\n"
"	}\n"
"}\n"
"\n"
"function Clamp(v, low, high)\n"
"{\n"
"	return v < low ? low : (v > high ? high : v);\n"
"}\n"
"function TriggerCapture()\n"
"{\n"
"	if(Settings.CaptureDelay <= 0)\n"
"	{\n"
"		Capture();\n"
"	}\n"
"	else\n"
"	{\n"
"		CaptureTriggerTime = new Date();\n"
"		CaptureTriggerTimeType = 1; \n"
"	}\n"
"}\n"
"function CaptureUpdate()\n"
"{\n"
"	if(CaptureTriggerTime)\n"
"	{\n"
"		let Time = new Date();\n"
"		let Delta = Time - CaptureTriggerTime;\n"
"		CaptureTriggerDelta = Math.max(0.0, (Settings.CaptureDelay * 1000 - Delta) / 1000.0);\n"
"		if(Delta > Settings.CaptureDelay * 1000)\n"
"		{\n"
"			if(CaptureTriggerTimeType == 1)\n"
"			{\n"
"				Capture();\n"
"			}\n"
"			else if(CaptureTriggerTimeType == 2)\n"
"			{\n"
"				AutoCaptureEnabled = Settings.AutoCaptureRepeat > 0 ? Settings.AutoCaptureRepeat : 1;\n"
"			}\n"
"			CaptureTriggerTime = null;\n"
"			CaptureTriggerDelta = 0;\n"
"			CaptureTriggerTimeType = 0;\n"
"		}\n"
"	}\n"
"\n"
"}\n"
"function Capture()\n"
"{\n"
"	AutoCaptureCooldown = Settings.CaptureFrames + 5;\n"
"	var ext = \'\' + Settings.CaptureFrames;\n"
"	if(MouseDragActiveXEnd > MouseDragActiveXStart)\n"
"	{\n"
"		var idx0 = Math.ceil(FRAME_COUNT * MouseDragActiveXStart / nWidth);\n"
"		var idx1 = Math.floor(FRAME_COUNT * MouseDragActiveXEnd / nWidth);\n"
"		idx0 = Clamp(idx0, 0, FRAME_COUNT-1);\n"
"		idx1 = Clamp(idx1, 0, FRAME_COUNT-1);\n"
"		var id0 = FrameData.Ids[idx0];\n"
"		var id1 = FrameData.Ids[idx1];\n"
"		ext = \'r/\'+id0+\'/\'+id1;\n"
"	}\n"
"	var url = \'http://\' + WSHost + \':\' + WSPort + \'/\' + ext;\n"
"	window.open(url);\n"
"}\n"
"function InitMenu()\n"
"{\n"
"	MenuItems = [];\n"
"	MenuItems.push(MakeMenuItem(\"Control\", function(){EnableMenu(SubMenuGroup); } ));\n"
"	MenuItems.push(MakeMenuItem(\"Timers\", function(){EnableMenu(SubMenuTimers); } ));\n"
"	MenuItems.push(MakeMenuItem(\"Modules\", function(){EnableMenu(SubMenuModules); } ));\n"
"	MenuItems.push(MakeMenuItem(\"Functions\", function(){EnableMenu(SubMenuFunctions); } ));\n"
"	MenuItems.push(MakeMenuItem(\"Patched\", function(){EnableMenu(SubMenuPatched); }, function(){ return FunctionsInstrumented.length > 0;} ));\n"
"	MenuItems.push(MakeMenuItem(\"Settings\", function(){ EnableMenu(SubMenuSettings); } ));\n"
"	MenuItems.push(MakeMenuItem(\"Views\", function(){ EnableMenu(SubMenuViews); } ));\n"
"	MenuItems.push(MakeMenuItem(\"Presets\", function(){ EnableMenu(SubMenuPresets); } ));\n"
"	MenuItems.push(MakeMenuItem(\"Columns\", function(){ EnableMenu(SubMenuColumns); } ));\n"
"}\n"
"function DrawTopMenu()\n"
"{\n"
"	var context = CanvasDetailedView.getContext(\'2d\');\n"
"	var X = 2;\n"
"	var Y = 0;\n"
"	var MouseInY = MouseY < BoxHeight;\n"
"	for(var i = 0; i < MenuItems.length; ++i)\n"
"	{\n"
"		if(i == SubMenuColumns)\n"
"		{\n"
"			if(Settings.ViewActive == VIEW_GRAPH_SPLIT || \n"
"				Settings.ViewActive == VIEW_GRAPH_THREAD_GROUP ||\n"
"				Settings.ViewActive == VIEW_GRAPH_PERCENTILE || \n"
"				Settings.ViewActive == VIEW_COUNTERS)\n"
"			{\n"
"				continue;\n"
"			}\n"
"		}\n"
"		var Item = MenuItems[i];\n"
"		if(Item.visible == null || Item.visible())\n"
"		{\n"
"			var w = context.measureText(Item.name).width + 4;\n"
"			var MouseIn = MouseInY && MouseX >= X && MouseX < X + w;\n"
"			var color = MouseIn ? nBackColors[1] : \"black\";\n"
"			Item.x = X;\n"
"			Item.y = Y + BoxHeight;\n"
"			if(MouseIn)\n"
"			{\n"
"				context.fillStyle = \'white\';\n"
"				context.fillRect(X-2, Y, w+4, BoxHeight);\n"
"				// Enable\n"
"				EnableMenu(i);\n"
"			}\n"
"			context.fillStyle = color;\n"
"			context.fillRect(X, Y, w, BoxHeight);\n"
"			context.fillStyle = \"white\";\n"
"			context.fillText(Item.name, X+2, Y+BoxHeight-FontAscent);\n"
"			if(MouseIn && MouseReleased)\n"
"			{\n"
"				Item.f();\n"
"			}\n"
"			X += w + 6;\n"
"		}\n"
"	}\n"
"}\n"
"\n"
"function AggregateMenuSize()\n"
"{\n"
"	var w = 250 + 5 + FontWidth;\n"
"	return WindowRect(nWidth / 2 - w / 2,HistoryHeight + 50, w, nHeight);\n"
"}\n"
"function TimerMenuSize()\n"
"{\n"
"	return MenuSize(WidthArray[TYPE_TIMER] + WidthArray[TYPE_GROUP] + 5 + FontWidth);\n"
"}\n"
"\n"
"function GroupMenuSize()\n"
"{\n"
"	return MenuSize(WidthTree);\n"
"}\n"
"\n"
"function MenuSize(w)\n"
"{\n"
"	return WindowRect(nWidth / 2 - w / 2, HistoryHeight + 50,w, nHeight);\n"
"}\n"
"\n"
"function CreateFilter(Filter)\n"
"{\n"
"	if(!Filter || Filter.length == 0)\n"
"	{\n"
"		return null;\n"
"	}\n"
"	Filter = Filter.split(\' \');\n"
"	\n"
"	var regexp = \"\";\n"
"	for(var i = 0; i < Filter.length; ++i)\n"
"	{\n"
"		regexp = regexp + \".*\" + Filter[i];\n"
"	}\n"
"	Filter = new Array();\n"
"	regexp = regexp + \".*\";\n"
"	Filter.push(new RegExp(regexp, \"i\"));\n"
"	return Filter;\n"
"}\n"
"\n"
"function FilterMatch(FilterArray, value)\n"
"{\n"
"	if(!FilterArray)\n"
"		return true;\n"
"	for(var i = 0; i < FilterArray.length; ++i)\n"
"	{\n"
"		var res = value.search(FilterArray[i]);\n"
"		if(res<0)\n"
"			return false;\n"
"	}\n"
"	return true;\n"
"}\n"
"\n"
"function AddPreset(Name)\n"
"{\n"
"	var O = {};\n"
"	O[Name] = {};\n"
"	var OO = {};\n"
"	OO.p = O;\n"
"	OO.r = {};\n"
"	AddPresets(OO);\n"
"}\n"
"function JSONTryParse(str)\n"
"{\n"
"	if(typeof str == \'string\')\n"
"	{\n"
"		try{\n"
"			return JSON.parse(str);\n"
"		}\n"
"		catch(e){}\n"
"	}\n"
"	return {};\n"
"}\n"
"\n"
"function ProcessPresets(Data, Names, Cache)\n"
"{\n"
"	for(var idx in Data)\n"
"	{\n"
"		if(Names.indexOf(idx) == -1)\n"
"		{\n"
"			Names.push(idx);\n"
"		}\n"
"		Cache[idx] = JSONTryParse(Data[idx]);	\n"
"	}\n"
"}\n"
"function AddPresets(Obj)\n"
"{\n"
"	var Names = Obj.p;\n"
"	var ReadOnlyNames = Obj.r;\n"
"	ProcessPresets(Obj.p, Presets, PresetsCache);\n"
"	ProcessPresets(Obj.r, ReadOnlyPresets, ReadOnlyPresetsCache);\n"
"}\n"
"function GetFullName(T)\n"
"{\n"
"	var parent = T.parent;\n"
"	var ParentName = \"unknown\";\n"
"	var Name = T.name;\n"
"	if(parent && parent < TimerArray.length)\n"
"	{\n"
"		ParentName = TimerArray[parent].name;\n"
"	}\n"
"	return ParentName + \"/\" + Name;\n"
"}\n"
"\n"
"function ColorFromFullName(name, type)\n"
"{\n"
"	for(var i = 0; i < TimerArray.length; ++i)\n"
"	{\n"
"		var t = TimerArray[i];\n"
"		if(t.idtype == type && GetFullName(t) == name)\n"
"		{\n"
"			return t.color;\n"
"		}\n"
"	}\n"
"	return \'white\';\n"
"\n"
"}\n"
"function EnableByName(name, type)\n"
"{\n"
"	for(var i = 0; i < TimerArray.length; ++i)\n"
"	{\n"
"		var t = TimerArray[i];\n"
"		if(t.idtype == type && GetFullName(t) == name)\n"
"		{\n"
"			WSSendMessage(\"c\" + t.id);\n"
"		}\n"
"	}\n"
"}\n"
"\n"
"\n"
"function OnLoadPreset(NewSettings, Apply, RO)\n"
"{\n"
"	if(Apply)\n"
"	{\n"
"		WSSendMessage(\"d\");\n"
"		PresetPending = 0;\n"
"	}\n"
"	ActivePreset = NewSettings.PresetName;\n"
"	ActivePresetRO = RO ? 1 : 0;\n"
"	console.log(\'loading preset \' + ActivePresetRO);\n"
"	var EnableCount = 0;\n"
"	for(var idx in NewSettings)\n"
"	{\n"
"		if(idx == \'Timers\')\n"
"		{\n"
"			if(Apply)\n"
"			{\n"
"				var Timers = NewSettings[idx];\n"
"				for(var i = 0; i < Timers.length; ++i)\n"
"				{\n"
"					var FullName = Timers[i];\n"
"					EnableCount++;\n"
"					EnableByName(FullName, TYPE_TIMER);\n"
"				}\n"
"			}\n"
"		}\n"
"		else if(idx == \'Groups\')\n"
"		{\n"
"			if(Apply)\n"
"			{\n"
"				var Groups = NewSettings[idx];\n"
"				for(var i = 0; i < Groups.length; ++i)\n"
"				{\n"
"					var FullName = Groups[i];\n"
"					EnableByName(FullName, TYPE_GROUP);\n"
"\n"
"				}\n"
"			}\n"
"		}\n"
"		else\n"
"		{\n"
"			Settings[idx] = NewSettings[idx];\n"
"		}\n"
"	}\n"
"\n"
"	if(Settings.FunctionsInstrumented && Apply)\n"
"	{\n"
"		if(Settings.FunctionsInstrumented.length == Settings.FunctionsInstrumentedModule.length && Settings.FunctionsInstrumented.length == Settings.FunctionsInstrumentedUnmangled.length)\n"
"		{\n"
"			var Msg = \"D\" + Settings.FunctionsInstrumented.length + \" \";\n"
"			for(var i = 0; i < Settings.FunctionsInstrumented.length; ++i)\n"
"			{\n"
"				Msg += Settings.FunctionsInstrumentedModule[i] + \"!\" + Settings.FunctionsInstrumentedUnmangled[i] + \"!\";\n"
"			}\n"
"			WSSendMessage(Msg);\n"
"		}\n"
"	}\n"
"	if(Settings.ViewActive >= 0)\n"
"	{\n"
"		ResizeCanvas();\n"
"	}\n"
"}\n"
"function SanitizeString(s)\n"
"{\n"
"	let r = \"\";\n"
"	for(let i = 0; i < s.length; ++i)\n"
"	{\n"
"		let c = s[i];\n"
"		if(!((c>=\'a\' && c<=\'z\') || (c >=\'A\' && c <= \'Z\') || (c >= \'0\' && c <= \'9\')))\n"
"		{\n"
"			r += \'_\';\n"
"		}\n"
"		else\n"
"		{\n"
"			r += c;\n"
"		}\n"
"	}\n"
"	return r;\n"
"}\n"
"function LoadPreset(Name, RO)\n"
"{\n"
"	Name = SanitizeString(Name);\n"
"	WSSendMessage((RO?\"m\":\"l\")+Name);\n"
"}\n"
"\n"
"function SavePreset(Name)\n"
"{\n"
"	Name = SanitizeString(Name);\n"
"	AddPreset(Name);\n"
"	var Timers = [];\n"
"	var Groups = [];\n"
"	for(var i = 0; i < TimerArray.length; ++i)\n"
"	{\n"
"		var t = TimerArray[i];\n"
"		var idtype = TimerArray[i].idtype;\n"
"		if(t.e)\n"
"		{\n"
"			if(idtype == TYPE_TIMER)\n"
"			{\n"
"				Timers.push(GetFullName(t));\n"
"			}\n"
"			else if(idtype == TYPE_GROUP)\n"
"			{\n"
"				Groups.push(GetFullName(t));\n"
"			}\n"
"		}\n"
"	}\n"
"\n"
"	Settings.Timers = Timers;\n"
"	Settings.Groups = Groups;\n"
"	Settings.PresetName = Name;\n"
"	let Clone = function(A)\n"
"	{\n"
"		let N = Array(A.length);\n"
"		for(var i = 0; i < A.length; ++i)\n"
"		{\n"
"			N[i] = A[i];\n"
"		}\n"
"		return N;\n"
"	};\n"
"	Settings.FunctionsInstrumented = Clone(FunctionsInstrumented);\n"
"	Settings.FunctionsInstrumentedModule = Clone(FunctionsInstrumentedModule);\n"
"	Settings.FunctionsInstrumentedUnmangled = Clone(FunctionsInstrumentedUnmangled);\n"
"\n"
"	var JsonSettings = JSON.stringify(Settings);\n"
"	console.log(\'settings stored \' + JsonSettings);\n"
"	WSSendMessage(\"s\"+Name+\",\"+JsonSettings);\n"
"	ActivePreset = Name;\n"
"	ActivePresetRO = 0;\n"
"}\n"
"function DrawMenuPresets()\n"
"{\n"
"	var Selection = null;\n"
"	var SizeInfo = {};\n"
"	SizeInfo.h = BoxHeight * (Presets.length * 2);\n"
"	if(ReadOnlyPresets.length)\n"
"	{\n"
"		SizeInfo.h += BoxHeight * (Presets.length + 1);\n"
"	}\n"
"	var x = MenuItems[SubMenuPresets].x;\n"
"	var y = MenuItems[SubMenuPresets].y;\n"
"\n"
"	var Width = 50;\n"
"	var WLeft = MeasureArray(0, [\"Save \", \"Load \", \"Save As ..\", \"Builtin\" ]);\n"
"	Width = MeasureArray(Width, Presets);\n"
"	var Width = 35 + Width + WLeft;\n"
"	SizeInfo.w = Width;\n"
"	SizeInfo.x = x;\n"
"	SizeInfo.y = y;\n"
"	\n"
"	var M = CreateMenuState(SizeInfo);\n"
"	var context = CanvasDetailedView.getContext(\'2d\');\n"
"\n"
"	var SettingsCached;\n"
"	var SettingsCachedY = 0;\n"
"\n"
"	for(var i = 0; i < Presets.length; ++i)\n"
"	{\n"
"		var Active = (ActivePresetRO == 0 && ActivePreset == Presets[i]) ? 1 : 0;\n"
"		if(DrawMenuElementMouseIn(M))\n"
"		{\n"
"			SettingsCachedY = M.y;\n"
"			SettingsCached = PresetsCache[Presets[i]];\n"
"		}\n"
"\n"
"		if(DrawMenuElement(M, Active, \"Load\", Presets[i], \'white\', 0))\n"
"		{\n"
"			LoadPreset(Presets[i]);\n"
"		}\n"
"	}\n"
"	DrawMenuElement(M, 0, \"---\", \"\", \'white\', 0);\n"
"	if(DrawMenuElement(M, 0, \"Save As..\", \"\", \'white\', 0))\n"
"	{\n"
"		var str = ShowPrompt(\'Enter Preset Name\', \'\');\n"
"		if(str.length>1)\n"
"		{\n"
"			SavePreset(str);\n"
"		}\n"
"\n"
"	}\n"
"\n"
"	for(var i = 0; i < Presets.length; ++i)\n"
"	{\n"
"		var Active = (ActivePresetRO == 0 && ActivePreset == Presets[i]) ? 1 : 0;\n"
"		if(DrawMenuElement(M, Active, \"Save\", Presets[i], \'white\', 0))\n"
"		{\n"
"			SavePreset(Presets[i]);\n"
"		}\n"
"	}\n"
"	if(ReadOnlyPresets && ReadOnlyPresets.length > 0)\n"
"	{\n"
"		DrawMenuElement(M, 0, \"---\", \"\", \'white\', 0);\n"
"		for(var i = 0; i < ReadOnlyPresets.length; ++i)\n"
"		{\n"
"			var Active = (ActivePresetRO && ActivePreset == ReadOnlyPresets[i]) ? 1 : 0;\n"
"			if(DrawMenuElementMouseIn(M))\n"
"			{\n"
"				SettingsCachedY = M.y;\n"
"				SettingsCached = ReadOnlyPresetsCache[ReadOnlyPresets[i]];\n"
"			}\n"
"			if(DrawMenuElement(M, Active, \"Builtin\", ReadOnlyPresets[i], \'white\', 0))\n"
"			{\n"
"				LoadPreset(ReadOnlyPresets[i], 1);\n"
"			}\n"
"		}\n"
"	}\n"
"	SizeInfo.h = M.y - SizeInfo.y;\n"
"\n"
"\n"
"	if(SettingsCached)\n"
"	{\n"
"		var SizeLeft = 10 * FontWidth;\n"
"		var Timers = SettingsCached.Timers;\n"
"		var Groups = SettingsCached.Groups;\n"
"		var Patched = SettingsCached.Patched;\n"
"		var W = 0;\n"
"		var H = 0;\n"
"		if(Timers)\n"
"		{\n"
"			W = MeasureArray(W, Timers);\n"
"			H = 1 + Timers.length;\n"
"		}\n"
"		if(Groups)\n"
"		{\n"
"			W = MeasureArray(W, Groups);\n"
"			H = 1 + Groups.length;\n"
"		}\n"
"		if(Patched)\n"
"		{\n"
"			W = MeasureArray(W, Patched);\n"
"			H = 1 + Patched.length;\n"
"		}\n"
"		W += 40;\n"
"		H = H * (FontHeight+1);\n"
"		var M = CreateMenuState(SizeInfo);\n"
"		M.x += M.w + 5;\n"
"		M.y = SettingsCachedY;\n"
"		M.w = W;\n"
"		M.h = H;\n"
"\n"
"		if(Groups && Groups.length)\n"
"		{\n"
"			DrawMenuElement(M, 0, \"Groups\", \"\", \'white\', 0);\n"
"			for(var i = 0; i < Groups.length; ++i)\n"
"			{\n"
"				DrawMenuElement(M, 0, \"\", Groups[i], \'white\', 0);\n"
"			}\n"
"		}\n"
"		if(Timers && Timers.length)\n"
"		{\n"
"			DrawMenuElement(M, 0, \"Timers\", \"\", \'white\', 0);\n"
"			for(var i = 0; i < Timers.length; ++i)\n"
"			{\n"
"				DrawMenuElement(M, 0, \"\", Timers[i], ColorFromFullName(Timers[i], TYPE_TIMER), 0);\n"
"			}\n"
"		}\n"
"		if(Patched && Patched.length)\n"
"		{\n"
"			DrawMenuElement(M, 0, \"Patched\", \"\", \'white\', 0);\n"
"			for(var i = 0; i < Patched.length; ++i)\n"
"			{\n"
"				DrawMenuElement(M, 0, \"\", Patched[i], \'white\', 0);\n"
"			}\n"
"		}\n"
"\n"
"\n"
"	}\n"
"\n"
"	return SizeInfo;\n"
"}\n"
"\n"
"function DrawMenuColumns()\n"
"{\n"
"	var Selection = null;\n"
"	var SizeInfo = {};\n"
"	var BarColumnNames = GetBarColumnNames();\n"
"	var BarColumnEnabled = GetBarColumnEnabled();\n"
"	SizeInfo.h = BoxHeight * (BarColumnNames.length);\n"
"	var x = MenuItems[SubMenuColumns].x;\n"
"	var y = MenuItems[SubMenuColumns].y;\n"
"\n"
"	var Width = MeasureArray(0, BarColumnNames);\n"
"	SizeInfo.w = Width;\n"
"	SizeInfo.x = x;\n"
"	SizeInfo.y = y;\n"
"	\n"
"	var M = CreateMenuState(SizeInfo);\n"
"	var context = CanvasDetailedView.getContext(\'2d\');\n"
"	context.fillRect(M.x, M.y, Width, SizeInfo.h);\n"
"\n"
"\n"
"	for(var i = 0; i < BarColumnNames.length; ++i)\n"
"	{\n"
"		var Active = ActivePreset == Presets[i] ? 1 : 0;\n"
"		if(DrawMenuElement(M, BarColumnEnabled[i], BarColumnNames[i], \"\", \'white\', 0))\n"
"		{\n"
"			BarColumnEnabled[i] = !BarColumnEnabled[i];\n"
"			for(var j = 0; j < ColumnsWidth.length; ++j)\n"
"			{\n"
"				ColumnsWidth[i] = 20;\n"
"			}\n"
"		}\n"
"	}\n"
"\n"
"	SizeInfo.h = M.y - SizeInfo.y;\n"
"	return SizeInfo;\n"
"\n"
"}\n"
"\n"
"\n"
"function ToggleView()\n"
"{\n"
"	Settings.ViewActive = (Settings.ViewActive+1) % VIEW_SIZE;\n"
"	ActivateView(Settings.ViewActive);\n"
"}\n"
"\n"
"function ActivateView(idx)\n"
"{\n"
"	for(var i = 1; i < Views.length; ++i)\n"
"	{\n"
"		Views[i].visible = false;\n"
"	}\n"
"	if(idx == VIEW_GRAPH_SPLIT)\n"
"	{\n"
"		MainView.DisplayFunc = DrawGraphSplit;\n"
"		MainView.visible = true;\n"
"	}\n"
"	else if(idx == VIEW_GRAPH_PERCENTILE)\n"
"	{\n"
"		MainView.DisplayFunc = DrawGraphPercentile;\n"
"		MainView.visible = true;\n"
"	}\n"
"	else if(idx == VIEW_GRAPH_THREAD_GROUP)\n"
"	{\n"
"		MainView.DisplayFunc = DrawGraphThreadGroup;\n"
"		MainView.visible = true;\n"
"	}\n"
"	else if(idx == VIEW_BAR)\n"
"	{\n"
"		MainView.DisplayFunc = DrawTableView;\n"
"		MainView.visible = true;\n"
"	}\n"
"	else if(idx == VIEW_COUNTERS)\n"
"	{\n"
"		MainView.DisplayFunc = DrawCounterView;\n"
"		MainView.visible = true;\n"
"	}\n"
"	else if(idx == VIEW_BAR_SINGLE || idx == VIEW_BAR_ALL)\n"
"	{\n"
"		for(var i = 0; i < X7Views.length; ++i)\n"
"		{\n"
"			X7Views[i].visible = true;\n"
"		}\n"
"		SingleTimerBars = idx == VIEW_BAR_SINGLE;\n"
"	}\n"
"	Settings.ViewActive = idx;\n"
"	X7BarColumnMask = -1;\n"
"	ViewBarMaxMsTextLength  = 0;\n"
"	var hest = 3;\n"
"}\n"
"function DrawMenuViews()\n"
"{\n"
"	var ViewClick = function(idx, name)\n"
"	{\n"
"		ActivateView(idx);\n"
"	};\n"
"	var x = MenuItems[SubMenuViews].x;\n"
"	var y = MenuItems[SubMenuViews].y;\n"
"	return DrawMenuGeneric(ViewNames, Settings.ViewActive, ViewClick, x, y, ViewNames2);\n"
"}\n"
"\n"
"function TweakValue(Value, Tweak, amount, Min, Max)\n"
"{\n"
"	var V = 0.98;\n"
"	if(Tweak<0)\n"
"	{\n"
"		for(var x = 0; x < Math.abs(Tweak); ++x)\n"
"		{\n"
"			var newValue = Math.floor(Value*V);\n"
"			if(newValue == Value)\n"
"			{\n"
"				Value--;\n"
"			}\n"
"			else\n"
"			{\n"
"				Value = newValue;\n"
"			}\n"
"		}\n"
"	}\n"
"	else\n"
"	{\n"
"		var RcpV = 1.0 / V;\n"
"\n"
"		for(var x = 0; x < Tweak; ++x)\n"
"		{\n"
"			var newValue = Math.ceil(Value*RcpV);\n"
"			if(newValue == Value)\n"
"			{\n"
"				Value++;\n"
"			}\n"
"			else\n"
"			{\n"
"				Value = newValue;\n"
"			}\n"
"		}\n"
"	}\n"
"	if(Min!=null && Value < Min)\n"
"		Value = Min;\n"
"	if(Max!=null && Value > Max)\n"
"		Value = Max;\n"
"	return Value;\n"
"\n"
"}\n"
"\n"
"function NextValue(Presets, Value, Dir)\n"
"{\n"
"	var idx = 0;	\n"
"	if(Dir > 0)\n"
"	{\n"
"		for(idx = 0;idx < Presets.length; ++idx)\n"
"		{\n"
"			if(Presets[idx] > Value)\n"
"			{\n"
"				break;\n"
"			}\n"
"		}\n"
"	}\n"
"	else\n"
"	{\n"
"		for(idx = Presets.length; idx >= 0; idx -= 1)\n"
"		{\n"
"			if(Presets[idx] < Value)\n"
"			{\n"
"				break;\n"
"			}\n"
"		}\n"
"	}\n"
"	idx = (idx + Presets.length) % Presets.length;\n"
"	return Presets[idx];\n"
"}\n"
"function AutoCaptureRoll(Direction, Tweak, SetDirect)\n"
"{\n"
"	if(SetDirect)\n"
"	{\n"
"		Settings.AutoCaptureTheshold = SetDirect;\n"
"	}\n"
"	else if(Tweak)\n"
"	{\n"
"		Settings.AutoCaptureTheshold = TweakValue(Settings.AutoCaptureTheshold, Tweak, 0.98, 1, 500);\n"
"	}\n"
"	else if(Direction)\n"
"	{\n"
"		Settings.AutoCaptureTheshold = NextValue(AutoCaptureThesholdPresets, Settings.AutoCaptureTheshold, Direction);\n"
"	}\n"
"}\n"
"function AutoCaptureRepeatRoll(Direction, Tweak, SetDirect)\n"
"{\n"
"	if(SetDirect)\n"
"	{\n"
"		Settings.AutoCaptureRepeat = SetDirect;\n"
"	}\n"
"	else if(Tweak)\n"
"	{\n"
"		Settings.AutoCaptureRepeat = TweakValue(Settings.AutoCaptureRepeat, Tweak, 0.98, 1, 500);\n"
"	}\n"
"	else if(Direction)\n"
"	{\n"
"		Settings.AutoCaptureRepeat = NextValue(AutoCaptureRepeatPresets, Settings.AutoCaptureRepeat, Direction);\n"
"	}\n"
"}\n"
"function CaptureRoll(Direction, Tweak, SetDirect)\n"
"{\n"
"	if(SetDirect)\n"
"	{\n"
"		Settings.CaptureFrames = SetDirect;\n"
"	}\n"
"	else if(Tweak)\n"
"	{\n"
"		Settings.CaptureFrames = TweakValue(Settings.CaptureFrames, Tweak, 0.98, 5, 300);\n"
"\n"
"	}\n"
"	else if(Direction)\n"
"	{\n"
"		Settings.CaptureFrames = NextValue(CaptureFramesPresets, Settings.CaptureFrames, Direction);\n"
"	}\n"
"}\n"
"function CaptureDelayRoll(Direction, Tweak, SetDirect)\n"
"{\n"
"	if(SetDirect)\n"
"	{\n"
"		Settings.CaptureDelay = SetDirect;\n"
"	}\n"
"	else if(Tweak)\n"
"	{\n"
"		Settings.CaptureDelay = TweakValue(Settings.CaptureDelay, Tweak, 0.98, 5, 300);\n"
"\n"
"	}\n"
"	else if(Direction)\n"
"	{\n"
"		Settings.CaptureDelay = NextValue(CaptureDelayPresets, Settings.CaptureDelay, Direction);\n"
"	}\n"
"}\n"
"\n"
"function GetAutoCaptureString()\n"
"{\n"
"	if(AutoCaptureSourceIndex >= 0)\n"
"	{\n"
"		if(AutoCaptureSourceIndex >= EnabledArray.length)\n"
"		{\n"
"			AutoCaptureSourceIndex = -1;\n"
"			AutoCaptureSourceIndex = -1;\n"
"		}\n"
"		else\n"
"		{\n"
"			var idx = EnabledArray[AutoCaptureSourceIndex];\n"
"			return TimerArray[idx].name;\n"
"		}\n"
"	}\n"
"	return \"Frame Time\";\n"
"}\n"
"\n"
"function AutoCaptureSourceRoll(Direction, Tweak, SetDirect)\n"
"{\n"
"	if(SetDirect)\n"
"	{\n"
"\n"
"	}else if(Tweak||Direction)\n"
"	{\n"
"		if(!Direction)\n"
"			Direction = Tweak;\n"
"		if(Direction<0)\n"
"		{\n"
"			AutoCaptureSourceIndex--;\n"
"			if(AutoCaptureSourceIndex<-1)\n"
"			{\n"
"				AutoCaptureSourceIndex = EnabledArray.length-1;\n"
"			}\n"
"		}\n"
"		else\n"
"		{\n"
"			AutoCaptureSourceIndex++;\n"
"			if(AutoCaptureSourceIndex >= EnabledArray.length)\n"
"			{\n"
"				AutoCaptureSourceIndex = -1;\n"
"			}\n"
"		}\n"
"\n"
"	}\n"
"}\n"
"\n"
"function ShowPrompt(Title, Value, Type)\n"
"{\n"
"	var v;\n"
"	if(Type == \'int\')\n"
"	{\n"
"		var newValue = prompt(\'\' + Title, \'\' + Value);\n"
"		v = parseInt(newValue);\n"
"	}\n"
"	else if(Type == \'float\')\n"
"	{\n"
"		var newValue = prompt(\'\' + Title, \'\' + Value);\n"
"		v = parseFloat(newValue);\n"
"	}\n"
"	else\n"
"	{\n"
"		var v = prompt(\'\' + Title, \'\' + Value);\n"
"		return v;\n"
"	}\n"
"	if(isNaN(v))\n"
"	{\n"
"		return Value;\n"
"	}\n"
"	else\n"
"	{\n"
"		return v;\n"
"	}\n"
"\n"
"}\n"
"function MeasureArray(v, A, f)\n"
"{\n"
"	var context = CanvasDetailedView.getContext(\'2d\');	\n"
"	for(var i = 0; i < A.length; ++i)\n"
"	{\n"
"		var s = A[i];\n"
"		if(f)\n"
"			s=f(s, i);\n"
"		var l = context.measureText(s).width;\n"
"		v = v < l ? l : v;\n"
"	}\n"
"	return v;\n"
"}\n"
"\n"
"function CreateMenuState(SizeInfo)\n"
"{\n"
"	var MenuState = {};\n"
"	for(var i in SizeInfo)\n"
"	{\n"
"		MenuState[i] = SizeInfo[i];\n"
"	}\n"
"	MenuState.cidx = 0;\n"
"	return MenuState;\n"
"}\n"
"function DrawMenuElementMouseIn(M)\n"
"{\n"
"	return MouseY >= M.y && MouseY < M.y + BoxHeight;\n"
"}\n"
"function DrawMenuElement(M, Selected, Name, Value, color)\n"
"{\n"
"	var context = CanvasDetailedView.getContext(\'2d\');\n"
"\n"
"	var bMouseIn = DrawMenuElementMouseIn(M);\n"
"	var YText = M.y + BoxHeight - FontAscent;\n"
"\n"
"	var bgcolor = bMouseIn ? nBackColorOffset : nBackColors[M.cidx];\n"
"	context.fillStyle = Selected?\'white\':bgcolor;\n"
"	context.fillRect(M.x-2, M.y, M.w + 4, BoxHeight);\n"
"	context.fillStyle = bgcolor;\n"
"	context.fillRect(M.x, M.y, M.w, BoxHeight);\n"
"	context.fillStyle = color;\n"
"	context.fillText(Name, M.x, YText);\n"
"	context.textAlign = \'right\';\n"
"	context.fillText(\'\' + Value, M.x + M.w - 2, YText);\n"
"	context.textAlign = \'left\';\n"
"	M.cidx = 1-M.cidx;\n"
"	M.y += BoxHeight;\n"
"	return bMouseIn && MouseReleased;\n"
"}\n"
"function DrawMenuRoll(M, Name, RollValue, RollExt, RollFunction, Tweak, Type)\n"
"{\n"
"	var context = CanvasDetailedView.getContext(\'2d\');\n"
"\n"
"	var YText = M.y + BoxHeight - FontAscent;\n"
"	var SizeMinus = context.measureText(\'-\').width;\n"
"	var SizePlus = context.measureText(\'+\').width;\n"
"\n"
"	var bMouseIn = MouseY >= M.y && MouseY < M.y + BoxHeight;\n"
"	var bgcolor = bMouseIn ? nBackColorOffset : nBackColors[M.cidx];\n"
"	context.fillStyle = bgcolor;\n"
"	context.fillRect(M.x-2, M.y, M.w+4, BoxHeight);\n"
"	context.fillStyle = \'white\';\n"
"	context.fillText(Name, M.x, YText);\n"
"	context.textAlign = \'right\';\n"
"	var XTemp = M.x + M.w - 3;\n"
"\n"
"	if(KeyShiftDown && bMouseIn)\n"
"	{\n"
"		if(Tweak>=0)\n"
"		{\n"
"			RollFunction(0, MouseX-Tweak);\n"
"		}\n"
"		Tweak = MouseX;\n"
"		bMouseIn = false;\n"
"	}\n"
"	else\n"
"	{\n"
"		Tweak = -1;\n"
"	}\n"
"\n"
"	var MouseReleasedUsed = false;\n"
"	if(bMouseIn && MouseX >= XTemp - SizePlus && MouseX <= XTemp)\n"
"	{\n"
"		context.fillStyle = \'red\';\n"
"		if(MouseReleased)\n"
"		{\n"
"			RollFunction(1);\n"
"			MouseReleasedUsed = true;\n"
"		}\n"
"	}\n"
"	else\n"
"	{\n"
"		context.fillStyle = \'white\';\n"
"	}\n"
"	context.fillText(\'+\', XTemp, YText);\n"
"	XTemp -= SizePlus + 3;\n"
"\n"
"\n"
"\n"
"	if(bMouseIn && MouseX >= XTemp - SizeMinus && MouseX <= XTemp)\n"
"	{\n"
"		context.fillStyle = \'red\';\n"
"		if(MouseReleased)\n"
"		{\n"
"			RollFunction(-1);\n"
"			MouseReleasedUsed = true;				\n"
"		}\n"
"	}\n"
"	else\n"
"	{\n"
"		context.fillStyle = \'white\';\n"
"	}\n"
"\n"
"	context.fillText(\'-\', XTemp, YText);\n"
"	XTemp -= SizeMinus + 3;\n"
"	var RollText = \'\'+RollValue + RollExt;\n"
"	var RollWidth = context.measureText(RollText).width;\n"
"	context.fillStyle = \'white\';\n"
"\n"
"	context.fillText(RollText, XTemp, YText);\n"
"	XTemp -= RollWidth;\n"
"	\n"
"	context.textAlign = \'left\';\n"
"\n"
"	M.cidx = 1-M.cidx;\n"
"\n"
"	M.y += BoxHeight;\n"
"	if(Type && MouseReleased && bMouseIn && !MouseReleasedUsed)\n"
"	{\n"
"		var V = ShowPrompt(Name, RollValue, Type);\n"
"		RollFunction(0,0,V);\n"
"	}\n"
"	return Tweak;\n"
"\n"
"}\n"
"function CheckPopupAllowed()\n"
"{\n"
"	if(!PopupsAllowed && !PopupTestPending)\n"
"	{\n"
"		PopupTestPending = 1;\n"
"		PopupsAllowed = 0;\n"
"		PopupsFailed = 0;\n"
"		let DoPopupTest = function()\n"
"		{\n"
"			var W = window.open(\"about:blank\");\n"
"			var Fail = function()\n"
"			{\n"
"				PopupTestPending = 0;\n"
"				PopupsFailed = 1;\n"
"				PopupsAllowed = 0;\n"
"			};\n"
"			var Check = function()\n"
"			{\n"
"				if(!(W.innerHeight>0))\n"
"					Fail();\n"
"				else\n"
"				{\n"
"					PopupTestPending = 0;\n"
"					PopupsFailed = 0;\n"
"					PopupsAllowed = 1;\n"
"					W.close();\n"
"				}\n"
"			};\n"
"			if(W)\n"
"			{\n"
"				if(/chrome/.test(navigator.userAgent.toLowerCase()))\n"
"					setTimeout(Check, 200);\n"
"				else\n"
"					W.onload = Check;\n"
"			}\n"
"			else\n"
"			{\n"
"				Fail();\n"
"			}\n"
"		};\n"
"		setTimeout(DoPopupTest, 5000);\n"
"	}\n"
"}\n"
"\n"
"function GetSubGraphReferenceTime(SubGraphSettings, TimerState)\n"
"{\n"
"	if(SubGraphSettings.AutomaticReference)\n"
"	{\n"
"	 	return TimerState.historymaxsoft ? TimerState.historymax : TimerState.historymax;\n"
"	}\n"
"	else\n"
"	{\n"
"		return SubGraphSettings.ReferenceTime;\n"
"	}\n"
"}\n"
"function GetSubGraphSettingsKey(key)\n"
"{\n"
"	if(Settings.ViewActive == VIEW_GRAPH_PERCENTILE)\n"
"	{\n"
"		return \"perc_\"+key;\n"
"	}\n"
"	else\n"
"	{\n"
"		return key;\n"
"	}\n"
"}\n"
"function GetSubGraphSettings(key)\n"
"{\n"
"	let k = GetSubGraphSettingsKey(key);\n"
"	let SubGraphSettings = Settings.SubGraphSettings[k];\n"
"	if(!SubGraphSettings)\n"
"	{\n"
"		SubGraphSettings = {\"ReferenceTime\":10.0, \"TargetTime\":-1, \"AutomaticReference\":1, \"Percentile\":0.0};\n"
"		Settings.SubGraphSettings[k] = SubGraphSettings;\n"
"	}\n"
"	return SubGraphSettings;\n"
"}\n"
"\n"
"\n"
"function DrawMenuGraphSettings()\n"
"{\n"
"	let Percentile = Settings.ViewActive == VIEW_GRAPH_PERCENTILE;\n"
"	let Selection = null;\n"
"	let SizeInfo = {};\n"
"	SizeInfo.h = (Percentile?4:2) * BoxHeight;\n"
"	let Strings = [\"AutoCapture Enabled\", \"AutoCapture Threshold\", \"AutoCapture Source\", \"Capture Length\"];\n"
"	let wLeft = MeasureArray(0, Strings);\n"
"	let wRight = 50;\n"
"	wRight = MeasureArray(wRight, [\"Frame Time\"]);\n"
"	wRight = MeasureArray(wRight, EnabledArray, function(a){return TimerArray[a].name; } );\n"
"	let Width = wLeft + 35 + wRight;\n"
"	SizeInfo.w = Width;\n"
"	SizeInfo.x = CaptureButtonX;\n"
"	SizeInfo.y = CaptureButtonY;\n"
"	\n"
"	let M = CreateMenuState(SizeInfo);\n"
"	let context = CanvasDetailedView.getContext(\'2d\');\n"
"	context.fillRect(M.x, M.y, Width, SizeInfo.h);\n"
"	let SubGraphSettings = GetSubGraphSettings(SubMenuGraphSettingsKey);\n"
"\n"
"\n"
"	ReferenceTimeTweak = DrawMenuRoll(M, \"Reference Time\", SubGraphSettings.ReferenceTime, \'\', ReferenceRollSubGraph, ReferenceTimeTweak, \'int\');\n"
"	if(DrawMenuElement(M, SubGraphSettings.AutomaticReference, \"Automatic Reference Time\", SubGraphSettings.AutomaticReference, \'white\'))\n"
"	{\n"
"		SubGraphSettings.AutomaticReference = 1-SubGraphSettings.AutomaticReference;\n"
"	}\n"
"	if(Percentile)\n"
"	{\n"
"		PercentileTweak = DrawMenuRoll(M, \"Percentile\", SubGraphSettings.Percentile, \'\', PercentileRollSubGraph, PercentileTweak, \'int\');\n"
"		if(DrawMenuElement(M, 0, \"Clear Aggregate\", \"\", \'white\'))\n"
"		{\n"
"			let TimerMap = FrameData.TimerMap;\n"
"			if(TimerMap)\n"
"			{\n"
"				let TimerState = TimerMap[SubMenuGraphSettingsKey];\n"
"				TimerState.PercentileMax = -1e38;\n"
"				TimerState.PercentileMin = 1e38;\n"
"				TimerState.Percentile = [];\n"
"			}\n"
"		}\n"
"	}\n"
"	SizeInfo.h = M.y - SizeInfo.y;\n"
"	return SizeInfo;\n"
"\n"
"}\n"
"\n"
"function Dots()\n"
"{\n"
"	let t = new Date().getMilliseconds() / 200;\n"
"	let dots = [";

const size_t g_MicroProfileHtmlLive_begin_2_size = sizeof(g_MicroProfileHtmlLive_begin_2);
const char g_MicroProfileHtmlLive_begin_3[] =
"\".  \",\".. \",\"...\",\".. \"];\n"
"	let x = Math.floor(t) %4;\n"
"	return dots[x];\n"
"}\n"
"function DrawMenuCapture()\n"
"{\n"
"	let Selection = null;\n"
"	let SizeInfo = {};\n"
"	SizeInfo.h = 7 * BoxHeight;\n"
"	let Strings = [\"Popups Allowed\", \"AutoCapture Enabled\", \"AutoCapture Threshold\", \"AutoCapture Source\", \"Capture Length\", \"Capture Delay\"];\n"
"	let wLeft = MeasureArray(0, Strings);\n"
"	let wRight = 50;\n"
"	wRight = MeasureArray(wRight, [\"Frame Time\"]);\n"
"	wRight = MeasureArray(wRight, EnabledArray, function(a){return TimerArray[a].name; } );\n"
"	let Width = wLeft + 35 + wRight;\n"
"	SizeInfo.w = Width;\n"
"	SizeInfo.x = CaptureButtonX - SizeInfo.w;\n"
"	SizeInfo.y = CaptureButtonY - SizeInfo.h;\n"
"	\n"
"	let M = CreateMenuState(SizeInfo);\n"
"	let context = CanvasDetailedView.getContext(\'2d\');\n"
"	context.fillRect(M.x, M.y, Width, SizeInfo.h);\n"
"	let d = Dots();\n"
"	let PopupStatus = PopupsAllowed ? \"Yes\" :  (PopupsFailed ? \"No\" : (PopupTestPending ? (\"Testing\"+d) : \"Untested\"));\n"
"	if(DrawMenuElement(M, 0, \"Popups Allowed\", PopupStatus, \'white\', 0))\n"
"	{\n"
"		CheckPopupAllowed();\n"
"	}\n"
"	let AutoStatus = AutoCaptureEnabled > 0 ? \"on\" : \"off\";\n"
"	if(CaptureTriggerTime != null && CaptureTriggerTimeType == 2)\n"
"	{\n"
"		AutoStatus = \"pending\"+d;\n"
"	}\n"
"	if(DrawMenuElement(M, 0, \"AutoCapture Enabled\", AutoStatus, \'white\', 0))\n"
"	{\n"
"		if(!AutoCaptureEnabled && CaptureTriggerTime == null)\n"
"		{\n"
"			if(Settings.CaptureDelay <= 0)\n"
"			{\n"
"				AutoCaptureEnabled = Settings.AutoCaptureRepeat > 0 ? Settings.AutoCaptureRepeat : 1;\n"
"			}\n"
"			else\n"
"			{\n"
"				CaptureTriggerTime = new Date();\n"
"				CaptureTriggerTimeType = 2; \n"
"			}\n"
"		}\n"
"		else\n"
"		{\n"
"			AutoCaptureEnabled = 0;\n"
"			if(CaptureTriggerTimeType == 2)\n"
"			{\n"
"				CaptureTriggerTimeType = 0;\n"
"				CaptureTriggerTime = null;\n"
"			}\n"
"		}\n"
"	}\n"
"	AutoCaptureSourceTweak = DrawMenuRoll(M, \"AutoCapture Source\", GetAutoCaptureString(), \'\', AutoCaptureSourceRoll, AutoCaptureSourceTweak);\n"
"	AutoCaptureTweak = DrawMenuRoll(M, \"AutoCapture Threshold\", Settings.AutoCaptureTheshold, \'ms\', AutoCaptureRoll, AutoCaptureTweak, \'int\');\n"
"	AutoCaptureRepeatTweak = DrawMenuRoll(M, \"AutoCapture Repeat\", Settings.AutoCaptureRepeat, \'\', AutoCaptureRepeatRoll, AutoCaptureRepeatTweak, \'int\');\n"
"	CaptureTweak = DrawMenuRoll(M, \"Capture Length\",  Settings.CaptureFrames, \'\', CaptureRoll, CaptureTweak, \'int\');\n"
"	CaptureDelayTweak = DrawMenuRoll(M, \"Capture Delay\",  Settings.CaptureDelay, \'\', CaptureDelayRoll, CaptureDelayTweak, \'int\');\n"
"\n"
"	SizeInfo.h = M.y - SizeInfo.y;\n"
"	return SizeInfo;\n"
"\n"
"}\n"
"function WindowRect(x,y,w,h)\n"
"{\n"
"	let s = {};\n"
"	s.x = x;\n"
"	s.y = y;\n"
"	s.w = w;\n"
"	s.h = h;\n"
"	return s;\n"
"}\n"
"function GetAggregateString()\n"
"{\n"
"	if(0 == Settings.AggregateFrames)\n"
"		return \'infinite\';\n"
"	else\n"
"		return Settings.AggregateFrames + \'\';\n"
"}\n"
"\n"
"function AggregateRoll(Direction, Tweak, SetDirect)\n"
"{\n"
"	if(SetDirect || SetDirect == 0)\n"
"	{\n"
"		if(SetDirect <= 0 || SetDirect == \'infinite\')\n"
"		{\n"
"			Settings.AggregateFrames = 0;\n"
"		}\n"
"		else\n"
"		{\n"
"			Settings.AggregateFrames = SetDirect;\n"
"		}\n"
"	}\n"
"	else if(Tweak)\n"
"	{\n"
"		Settings.AggregateFrames = TweakValue(Settings.AggregateFrames, Tweak, 0.98, 0, 500);\n"
"\n"
"	}\n"
"	else if(Direction)\n"
"	{\n"
"		Settings.AggregateFrames = NextValue(AggregatePresets, Settings.AggregateFrames, Direction);\n"
"	}\n"
"}\n"
"function ReferenceRoll(Direction, Tweak, SetDirect)\n"
"{\n"
"	if(SetDirect)\n"
"	{\n"
"		Settings.ReferenceTime = SetDirect;\n"
"	}\n"
"	else if(Tweak)\n"
"	{\n"
"		Settings.ReferenceTime = TweakValue(Settings.ReferenceTime, Tweak, 0.98, 5, 1000);\n"
"\n"
"	}\n"
"	else if(Direction)\n"
"	{\n"
"		Settings.ReferenceTime = NextValue(ReferencePresets, Settings.ReferenceTime, Direction);\n"
"	}\n"
"}\n"
"\n"
"function ReferenceRollSubGraph(Direction, Tweak, SetDirect)\n"
"{\n"
"	let SubGraphSettings = GetSubGraphSettings(SubMenuGraphSettingsKey);\n"
"	if(SetDirect)\n"
"	{\n"
"		SubGraphSettings.ReferenceTime = SetDirect;\n"
"	}\n"
"	else if(Tweak)\n"
"	{\n"
"		SubGraphSettings.ReferenceTime = TweakValue(SubGraphSettings.ReferenceTime, Tweak, 0.98, 5, 1000);\n"
"\n"
"	}\n"
"	else if(Direction)\n"
"	{\n"
"		SubGraphSettings.ReferenceTime = NextValue(ReferencePresets, SubGraphSettings.ReferenceTime, Direction);\n"
"	}\n"
"}\n"
"\n"
"function PercentileRollSubGraph(Direction, Tweak, SetDirect)\n"
"{\n"
"	let SubGraphSettings = GetSubGraphSettings(SubMenuGraphSettingsKey);\n"
"	if(SetDirect)\n"
"	{\n"
"		SubGraphSettings.Percentile = SetDirect;\n"
"	}\n"
"	else if(Tweak)\n"
"	{\n"
"		SubGraphSettings.Percentile = TweakValue(SubGraphSettings.Percentile, Tweak, 0.98, 5, 1000);\n"
"	}\n"
"	else if(Direction)\n"
"	{\n"
"		SubGraphSettings.Percentile = NextValue(PercentilePresets, SubGraphSettings.Percentile, Direction);\n"
"	}\n"
"}\n"
"\n"
"\n"
"function TargetRoll(Direction, Tweak, SetDirect)\n"
"{\n"
"	if(SetDirect)\n"
"	{\n"
"		Settings.TargetTime = SetDirect;\n"
"	}\n"
"	else if(Tweak)\n"
"	{\n"
"		Settings.TargetTime = TweakValue(Settings.TargetTime, Tweak, 0.98, 5, 1000);\n"
"\n"
"	}\n"
"	else if(Direction)\n"
"	{\n"
"		Settings.TargetTime = NextValue(ReferencePresets, Settings.TargetTime, Direction);\n"
"	}\n"
"}\n"
"function TargetRollSubGraph(Direction, Tweak, SetDirect)\n"
"{\n"
"	let SubGraphSettings = GetSubGraphSettings(SubMenuGraphSettingsKey);\n"
"	if(SetDirect)\n"
"	{\n"
"		SubGraphSettings.TargetTime = SetDirect;\n"
"	}\n"
"	else if(Tweak)\n"
"	{\n"
"		SubGraphSettings.TargetTime = TweakValue(SubGraphSettings.TargetTime, Tweak, 0.98, 5, 1000);\n"
"\n"
"	}\n"
"	else if(Direction)\n"
"	{\n"
"		SubGraphSettings.TargetTime = NextValue(ReferencePresets, SubGraphSettings.TargetTime, Direction);\n"
"	}\n"
"}\n"
"function DrawMenuSettings()\n"
"{\n"
"	var context = CanvasDetailedView.getContext(\'2d\');\n"
"	var nColorIndex = 0;\n"
"	var SizeInfo = AggregateMenuSize();\n"
"	SizeInfo.x = MenuItems[SubMenuSettings].x;\n"
"	SizeInfo.y = MenuItems[SubMenuSettings].y;\n"
"\n"
"	SizeInfo.w = 200;\n"
"	var M = CreateMenuState(SizeInfo);\n"
"\n"
"	AggregateTweak = DrawMenuRoll(M, \"Aggregate Frames\", GetAggregateString(), \'\', AggregateRoll, AggregateTweak, \'int\');\n"
"	ReferenceTimeTweak = DrawMenuRoll(M, \"Reference Time\", Settings.ReferenceTime, \'\', ReferenceRoll, ReferenceTimeTweak, \'int\');\n"
"	TargetTimeTweak = DrawMenuRoll(M, \"Target Time\", Settings.TargetTime, \'\', TargetRoll, TargetTimeTweak, \'int\');\n"
"	if(DrawMenuElement(M, Settings.AutomaticReference, \"Automatic Reference Time\", Settings.AutomaticReference, \'white\'))\n"
"	{\n"
"		Settings.AutomaticReference = 1-Settings.AutomaticReference;\n"
"	}\n"
"	if(DrawMenuElement(M, Settings.ViewCompressed, \"Compressed View\", Settings.ViewCompressed, \'white\'))\n"
"	{\n"
"		Settings.ViewCompressed = 1-Settings.ViewCompressed;\n"
"		ResizeCanvas();\n"
"	}\n"
"\n"
"	if(Settings.AggregateFrames <= 0)\n"
"	{\n"
"		if(DrawMenuElement(M, 0, \"Clear Aggregate\", \"Current[\" + AggregateCurrent + \"]\", \'white\'))\n"
"		{\n"
"			WSSendMessage(\"r\");\n"
"		}\n"
"	}\n"
"	if(DrawMenuElement(M, 0, \"Clear Percentile Aggregate\", \"\", \'white\'))\n"
"	{\n"
"		let TimerMap = FrameData.TimerMap;\n"
"		if(TimerMap)\n"
"		{\n"
"			for(let key in TimerMap)\n"
"			{\n"
"				let idx = GetTimer(key);\n"
"				let TimerState = TimerMap[key];\n"
"				if(!IsGroup(key) && TimerState.Percentile)\n"
"				{\n"
"					TimerState.PercentileMax = -1e38;\n"
"					TimerState.PercentileMin = 1e38;\n"
"					TimerState.Percentile = [];\n"
"				}\n"
"			}\n"
"		}\n"
"	}\n"
"\n"
"\n"
"	if(DrawMenuElement(M, Settings.AllowHighDPI, \"Allow High DPI\", Settings.AllowHighDPI, \'white\'))\n"
"	{\n"
"		Settings.AllowHighDPI = 1 - Settings.AllowHighDPI;\n"
"		ResizeCanvas();\n"
"	}\n"
"	if(DrawMenuElement(M, Cookie.CodeReportMode == 0, \"Code Report: Prompt\", Cookie.CodeReportMode == 0 ? 1 : 0, \'white\'))\n"
"	{\n"
"		Cookie.CodeReportMode = 0;\n"
"		WriteCookie();\n"
"	}\n"
"\n"
"	if(DrawMenuElement(M, Cookie.CodeReportMode == 1, \"Code Report: Report Silently\", Cookie.CodeReportMode == 1 ? 1 : 0, \'white\'))\n"
"	{\n"
"		Cookie.CodeReportMode = 1;\n"
"		WriteCookie();\n"
"	}\n"
"	if(DrawMenuElement(M, Cookie.CodeReportMode == 2, \"Code Report: Never Report\", Cookie.CodeReportMode == 2 ? 1 : 0, \'white\'))\n"
"	{\n"
"		Cookie.CodeReportMode = 2;\n"
"		WriteCookie();\n"
"	}\n"
"\n"
"	SizeInfo.h = M.y - SizeInfo.y;\n"
"	return SizeInfo;\n"
"}\n"
"\n"
"function MoveFilterInputDiv(x, y, w)\n"
"{\n"
"	if(FilterInputDivPos.x != x || FilterInputDivPos.y != y || FilterInputDivPos.w != w)\n"
"	{\n"
"		FilterInputDivPos.x = x;\n"
"		FilterInputDivPos.y = y;\n"
"		FilterInputDivPos.w = w;\n"
"		FilterInputDiv.style[\'left\'] = x + \'px\';\n"
"		FilterInputDiv.style[\'top\'] = y + \'px\';\n"
"		FilterInput.style[\'width\'] = w + \'px\';\n"
"	}\n"
"}\n"
"\n"
"function DrawMenuTimer()\n"
"{\n"
"	if(FilterInputValueLast != FilterInput.value)\n"
"	{\n"
"		nOffsetMenuTimers = 0;\n"
"	}\n"
"	FilterInputValueLast = FilterInput.value;\n"
"	var FilterArray = CreateFilter(FilterInput.value);\n"
"	var context = CanvasDetailedView.getContext(\'2d\');\n"
"	var nColorIndex = 0;\n"
"	var SizeInfo = TimerMenuSize();\n"
"	SizeInfo.x = MenuItems[SubMenuTimers].x;\n"
"	SizeInfo.y = MenuItems[SubMenuTimers].y;\n"
"	var Y = SizeInfo.y;\n"
"	var Width = SizeInfo.w;\n"
"	var Selection = null;\n"
"	var X = SizeInfo.x;\n"
"	MoveFilterInputDiv(SizeInfo.x, SizeInfo.y, SizeInfo.w);\n"
"	Y += 35;\n"
"\n"
"	var bMouseIn = MouseY >= Y && MouseY < Y + BoxHeight;\n"
"	var bMouseInClear =  MouseY >= Y && MouseY < Y + BoxHeight;\n"
"	var bgcolor = bMouseIn ? nBackColorOffset : nBackColors[nColorIndex];\n"
"	var TextY = Y+BoxHeight-FontAscent;\n"
"	var YClear = Y;\n"
"	var TextYClear = TextY;\n"
"	var YStart = Y;\n"
"\n"
"	var MouseTaken = bMouseIn;\n"
"\n"
"	Y += BoxHeight;\n"
"	nColorIndex = 1-nColorIndex;\n"
"\n"
"	Y -= nOffsetMenuTimers;\n"
"\n"
"	for(var i = 0; i < TimerArray.length; ++i)\n"
"	{\n"
"		var v = TimerArray[i];\n"
"		if(v.idtype == TYPE_TIMER\n"
"		 //|| v.idtype == TYPE_GROUP\n"
"		 )\n"
"		{\n"
"			var Name = v.name;\n"
"			var ParentName = TimerArray[v.parent].name;\n"
"			if(FilterMatch(FilterArray, ParentName + \" \" + Name) && (0 == TimersActiveOnly || v.e))\n"
"			{\n"
"				if(Y > YStart)\n"
"				{\n"
"					var ParentColor = TimerArray[v.parent].e ? \'white\' : \'grey\';\n"
"					bMouseIn = MouseY >= Y && MouseY < Y + BoxHeight && !MouseTaken;\n"
"					bgcolor = bMouseIn ? nBackColorOffset : nBackColors[nColorIndex];\n"
"					TextY = Y+BoxHeight-FontAscent;\n"
"					context.fillStyle = v.e?\'white\':bgcolor;\n"
"					context.fillRect(X-2, Y, Width+4, BoxHeight);\n"
"					context.fillStyle = bgcolor;\n"
"					context.fillRect(X, Y, Width, BoxHeight);\n"
"					context.fillStyle = ParentColor;\n"
"					context.fillText(ParentName, X + 2, TextY);\n"
"					context.fillStyle = v.color;\n"
"					context.textAlign = \'right\';\n"
"					context.fillText(Name, X + Width - 2, TextY);\n"
"					context.textAlign = \'left\';\n"
"					if(bMouseIn)\n"
"					{\n"
"						Selection = v.id;\n"
"					}\n"
"				}\n"
"				Y += BoxHeight;\n"
"				nColorIndex = 1-nColorIndex;\n"
"			}\n"
"		}\n"
"	}\n"
"\n"
"	{\n"
"\n"
"		var c0 = nBackColorOffset;\n"
"		var c1 = nBackColors[1];\n"
"		var W = Width + 4;\n"
"		var WHalf = W / 2;\n"
"		var InsideClear = bMouseInClear && MouseX-X< WHalf-1;\n"
"		var InsideActive =  bMouseInClear && MouseX-X > WHalf+1;\n"
"		context.fillStyle = nBackColors[0];\n"
"		context.fillRect(X-2, YClear, W, BoxHeight);\n"
"\n"
"		context.fillStyle = InsideClear ? c0 :c1;\n"
"		context.fillRect(X-2, YClear, WHalf-1, BoxHeight);\n"
"		context.fillStyle = InsideActive ? c0 :c1;\n"
"		context.fillRect(X-2 + WHalf + 1, YClear, WHalf-1, BoxHeight);\n"
"\n"
"\n"
"		context.fillStyle = \'white\';\n"
"		context.textAlign = \'center\';\n"
"		context.fillText(\"[clear] \", X + 2 + Width * 0.25, TextYClear);\n"
"		context.fillStyle = TimersActiveOnly ? \'white\' : \'grey\';\n"
"		context.fillText(\"[active only]\", X + 2 + Width * 0.75, TextYClear);\n"
"		if(MouseReleased)\n"
"		{\n"
"			if(InsideActive)\n"
"			{\n"
"				TimersActiveOnly = 1-TimersActiveOnly;\n"
"			}\n"
"			if(InsideClear)\n"
"			{\n"
"				WSSendMessage(\"x\");\n"
"			}\n"
"		}\n"
"	}\n"
"	context.textAlign = \'left\';\n"
"	if(Selection && MouseReleased && !MouseTaken)\n"
"	{\n"
"		WSSendMessage(\"c\" + Selection);\n"
"	}\n"
"	SizeInfo.h = Y-SizeInfo.y;\n"
"	return SizeInfo;\n"
"}\n"
"\n"
"var LoadSymbolAnim = -1;\n"
"function LoadSymbolAnimRestart()\n"
"{\n"
"	if(LoadSymbolAnim > 0)\n"
"	{\n"
"		LoadSymbolAnim += 1;\n"
"	}\n"
"	else\n"
"	{\n"
"		LoadSymbolAnim = 1;\n"
"	}\n"
"}\n"
"function LoadSymbolAnimUpdateAndGet()\n"
"{\n"
"	if(LoadSymbolAnim>=0)\n"
"	{\n"
"		LoadSymbolAnim -= 0.03;\n"
"		if(LoadSymbolAnim < 0)\n"
"		{\n"
"			LoadSymbolAnim = -1;\n"
"		}\n"
"		else\n"
"		{\n"
"			return Math.sin(3.14  * LoadSymbolAnim);\n"
"		}\n"
"\n"
"	}\n"
"	return -1;\n"
"}\n"
"\n"
"\n"
"var CircleSteps = 30;\n"
"var CircleX = Array(CircleSteps);\n"
"var CircleY = Array(CircleSteps);\n"
"function InitCircle()\n"
"{\n"
"	var twopi = 2 * Math.PI;\n"
"	for(var i = 0; i < CircleSteps; ++i)\n"
"	{\n"
"		var s = (1.0*i) / CircleSteps;\n"
"\n"
"		var f = (1.0 * s) * twopi;\n"
"		CircleX[i] = Math.sin(f);\n"
"		CircleY[i] = Math.cos(f);\n"
"	}\n"
"}\n"
"function SpinnerResize(Spinner, w, h)\n"
"{\n"
"	if(h != Spinner.CanvasH || w != Spinner.CanvasW || DPR != Spinner.CanvasDPR)\n"
"	{\n"
"		Spinner.Canvas.style.width = w + \'px\';\n"
"		Spinner.Canvas.style.height = h + \'px\';\n"
"		Spinner.Canvas.width = w * DPR;\n"
"		Spinner.Canvas.height = h * DPR;\n"
"		Spinner.Canvas.getContext(\'2d\').scale(DPR, DPR);\n"
"		Spinner.CanvasBack.style.width = w + \'px\';\n"
"		Spinner.CanvasBack.style.height = h + \'px\';\n"
"		Spinner.CanvasBack.width = w * DPR;\n"
"		Spinner.CanvasBack.height = h * DPR;\n"
"\n"
"		Spinner.CanvasBack.getContext(\'2d\').scale(DPR, DPR);\n"
"		Spinner.CanvasH = h;\n"
"		Spinner.CanvasW = w;\n"
"		Spinner.CanvasDPR = DPR;\n"
"	}\n"
"}\n"
"function SpinnerCircle(Phase0, Shift0, Phase1, Shift1, Phase2, Shift2)\n"
"{\n"
"	return {\"Phase0\" : Phase0, \"Shift0\": Shift0, \"Phase1\":Phase1, \"Shift1\":Shift1, \"Phase2\": Phase2, \"Shift2\": Shift2, \"Q\": 0, \"QQ\": 0, \"A0\":0, \"A1\":0, \"A2\":0};\n"
"}\n"
"\n"
"function SpinnerInit(Blur, Color)\n"
"{\n"
"	var Spinner = {};\n"
"	Spinner.x = 0;\n"
"	Spinner.y = 0;\n"
"	Spinner.Canvas = document.createElement(\'canvas\');\n"
"	Spinner.CanvasBack = document.createElement(\'canvas\');\n"
"	Spinner.CanvasOffscreenData;\n"
"	Spinner.CanvasW = -1;\n"
"	Spinner.CanvasH = -1;\n"
"	Spinner.CanvasDPR = -1;\n"
"	Spinner.Circles = [];\n"
"	var x = 1 / 4;\n"
"	var y = 0.07;\n"
"	Spinner.Circles.push(SpinnerCircle(x, 0, y, 0, 0.0, 0.25));\n"
"	Spinner.Circles.push(SpinnerCircle(2/4, 0, 0, 0, 0.14, 0.25));\n"
"	Spinner.Fade = 0;\n"
"	Spinner.Blur = Blur;\n"
"	Spinner.Color = Color;\n"
"	return Spinner;\n"
"}\n"
"\n"
"var SpinnerCorner = SpinnerInit(0.8, \'white\');\n"
"var SpinnerLoadButton = SpinnerInit(0, \'white\');\n"
"var SpinnerText1 = SpinnerInit(0.0, \'red\');\n"
"var SpinnerText0 = SpinnerInit(0.0, \'red\');\n"
"\n"
"\n"
"function SpinnerShow()\n"
"{\n"
"	return SymbolState != null && (SymbolState.q == 1 || SymbolState.r != SymbolState.f || FunctionQueryLastRequest != FunctionQueryReceived);\n"
"}\n"
"\n"
"function SpinnerDraw(Enable, context, Spinner, X, Y, w, h)\n"
"{\n"
"	SpinnerResize(Spinner, w, h);\n"
"	var ContextSpinner = Spinner.Canvas.getContext(\'2d\');\n"
"\n"
"\n"
"	var now = Date.now();\n"
"	if(!ContextSpinner.last)\n"
"	{\n"
"		ContextSpinner.last = now;\n"
"	}\n"
"	var DT = now - ContextSpinner.last;\n"
"	ContextSpinner.last = now;\n"
"	if(Enable)\n"
"	{\n"
"		Spinner.Fade += DT / 200;\n"
"	}\n"
"	else\n"
"	{\n"
"		Spinner.Fade -= DT / 1000;\n"
"	}\n"
"	Spinner.Fade = Math.max(0, Spinner.Fade);\n"
"	Spinner.Fade = Math.min(1, Spinner.Fade);\n"
"	var F = Spinner.Fade * Spinner.Fade;\n"
"\n"
"	if(Spinner.Fade <= 0)\n"
"		return;\n"
"	ContextSpinner.clearRect(0, 0, w, h);\n"
"	if(Spinner.Blur > 0)\n"
"	{\n"
"		ContextSpinner.globalAlpha = Spinner.Blur;\n"
"		ContextSpinner.drawImage(Spinner.CanvasBack, 0, 0, w, h);\n"
"		ContextSpinner.globalAlpha = 1.0;\n"
"	}\n"
"	var twopi = 2 * Math.PI;\n"
"	for(var jjj = 0; jjj < Spinner.Circles.length; ++jjj)\n"
"	{\n"
"		var C = Spinner.Circles[jjj];\n"
"		InitCircle();\n"
"		var xs = CircleX;\n"
"		var ys = CircleY;\n"
"		var scale = (w-2) / 2;\n"
"		var offset = (w) / 2;\n"
"		var SPEED = 100.0;\n"
"\n"
"		var angle = (C.Q / SPEED) * twopi;\n"
"\n"
"		var QQSPEED = 1000;\n"
"\n"
"		C.A0 += (twopi * DT / 1000.0) * C.Phase0;\n"
"		if(C.A0 > twopi)\n"
"			C.A0 -= twopi;\n"
"		C.A1 += (twopi * DT / 1000.0) * C.Phase1;\n"
"		if(C.A1 > twopi)\n"
"			C.A1 -= twopi;\n"
"		C.A2 += (twopi * DT / 1000.0) * C.Phase2;\n"
"		if(C.A2 > twopi)\n"
"			C.A2 -= twopi;\n"
"\n"
"		var A0 = C.A0 + twopi * C.Shift0;\n"
"		var A1 = C.A1 + twopi * C.Shift1;\n"
"		var A2 = C.A2 + twopi * C.Shift2;\n"
"		var m = Math.cos(A0);\n"
"		var m0 = Math.sin(A2);\n"
"		var cs = Math.cos(A1);\n"
"		var ss = Math.sin(A1);\n"
"		for(var i = 0; i < xs.length; ++i)\n"
"		{\n"
"			var x = xs[i] * m;\n"
"			var y = ys[i] * m0;\n"
"			xs[i] = cs * scale * x - ss * scale * y;\n"
"			ys[i] = ss * scale * x + cs * scale * y;\n"
"			xs[i] += offset;\n"
"			ys[i] += offset;\n"
"		}\n"
"		ContextSpinner.strokeStyle = Spinner.Color;\n"
"		ContextSpinner.beginPath();		\n"
"		ContextSpinner.moveTo(xs[0], ys[0]);\n"
"		for(var i = 1; i < CircleSteps; ++i)\n"
"		{\n"
"			ContextSpinner.lineTo(xs[i], ys[i]);\n"
"		}\n"
"		ContextSpinner.lineTo(xs[0], ys[0]);\n"
"		ContextSpinner.stroke();\n"
"\n"
"\n"
"	}\n"
"	context.globalAlpha = F;\n"
"	context.drawImage(Spinner.Canvas, X, Y, w, h);\n"
"	context.globalAlpha = 1;\n"
"	var tmp = Spinner.CanvasBack;\n"
"	Spinner.CanvasBack = Spinner.Canvas;\n"
"	Spinner.Canvas = tmp;\n"
"}\n"
"\n"
"\n"
"function DrawMenuPatched()\n"
"{\n"
"	if(FilterInputValueLast != FilterInput.value)\n"
"	{\n"
"		nOffsetMenuPatched = 0;\n"
"	}\n"
"\n"
"	var FilterArray = CreateFilter(FilterInput.value);\n"
"	var context = CanvasDetailedView.getContext(\'2d\');\n"
"	var nColorIndex = 0;\n"
"	var SizeInfo = TimerMenuSize();\n"
"	SizeInfo.x = MenuItems[SubMenuPatched].x;\n"
"	SizeInfo.y = MenuItems[SubMenuPatched].y;\n"
"	var Y = SizeInfo.y;\n"
"	var Width = SizeInfo.w;\n"
"	Width = Math.max(300, Width);\n"
"	Width = 10+ MeasureArray(Width, FunctionsInstrumented, function(s, i){return s + \" \" + FunctionsInstrumentedModule[i];} );\n"
"\n"
"	if(Width + SizeInfo.x + 50 > nWidth)\n"
"	{\n"
"		Width = nWidth - (SizeInfo.x+50);\n"
"	}\n"
"	SizeInfo.w = Width;\n"
"	var MaxStringLength = Math.floor(Width/(FontWidth));\n"
"\n"
"	var Selection = null;\n"
"	var X = SizeInfo.x;\n"
"	context.fillStyle = nBackColors[0];\n"
"	TextY = Y+BoxHeight-FontAscent;\n"
"	context.fillRect(X, Y, Width, BoxHeight);\n"
"\n"
"	var bMouseIn = MouseY >= Y && MouseY < Y + BoxHeight && MouseX-X < 100;\n"
"	context.fillRect(X, Y, 99, BoxHeight);\n"
"	context.textAlign = \'center\';\n"
"	context.fillStyle = \'white\';\n"
"	context.fillText(\"Patched functions\", X + Width/2, TextY);\n"
"\n"
"	Y += BoxHeight;\n"
"	MoveFilterInputDiv(SizeInfo.x, Y, SizeInfo.w-6);\n"
"	Y += 45;\n"
"\n"
"	bMouseIn = MouseY >= Y && MouseY < Y + BoxHeight;\n"
"	var bgcolor = bMouseIn ? nBackColorOffset : nBackColors[nColorIndex];\n"
"	var TextY = Y+BoxHeight-FontAscent;\n"
"	var YClear = Y;\n"
"	var TextYClear = TextY;\n"
"	var bgcolorClear = bgcolor;\n"
"	var YStart = Y-BoxHeight*2;\n"
"\n"
"	nColorIndex = 1-nColorIndex;\n"
"\n"
"	Y -= nOffsetMenuFunctions + 10;\n"
"	var Selection = -1;\n"
"\n"
"	var StringColor = function(Name)\n"
"	{\n"
"		var h = StringHash(Name);\n"
"		var cidx = h % 360;\n"
"		return cidx;\n"
"	};\n"
"\n"
"	var GetColor = function(Str)\n"
"	{\n"
"		var cidx = StringColor(Str); \n"
"		return \"hsl(\" + cidx + \",50%, 70%)\";\n"
"	};\n"
"	for(var i = 0; i < FunctionsInstrumented.length; ++i)\n"
"	{\n"
"		var Name = FunctionsInstrumented[i];\n"
"		var ModuleName = FunctionsInstrumentedModule[i];\n"
"		if(FilterMatch(FilterArray, ModuleName + \" \" + Name))\n"
"		{\n"
"\n"
"			var Color = GetColor(Name);\n"
"			var ColorModule = GetColor(Name);\n"
"			if(Y >= YStart)\n"
"			{\n"
"				bMouseIn = MouseY >= Y && MouseY < Y + BoxHeight;\n"
"				bgcolor = bMouseIn && MouseX > X ? nBackColorOffset : nBackColors[nColorIndex];\n"
"				TextY = Y+BoxHeight-FontAscent;\n"
"\n"
"				context.fillStyle = bgcolor;\n"
"				context.fillRect(X, Y, Width, BoxHeight);\n"
"				context.fillStyle = Color;\n"
"				context.textAlign = \'right\';\n"
"				context.fillText(Name, X + Width - 2, TextY);\n"
"				context.textAlign = \'left\';\n"
"				context.fillStyle = ColorModule;\n"
"				context.fillText(ModuleName, X, TextY);\n"
"			}\n"
"			Y += BoxHeight;\n"
"			nColorIndex = 1-nColorIndex;\n"
"		}\n"
"	}\n"
"	context.textAlign = \'left\';\n"
"	SizeInfo.h = Y-SizeInfo.y;\n"
"	return SizeInfo;\n"
"}\n"
"\n"
"\n"
"function DrawMenuModules()\n"
"{\n"
"	if(FilterInputValueLast != FilterInput.value)\n"
"	{\n"
"		nOffsetMenuModules = 0;\n"
"	}\n"
"	FilterInputValueLast = FilterInput.value;\n"
"	var M = ModuleState;\n"
"	var FilterArray = CreateFilter(FilterInput.value);\n"
"	var context = CanvasDetailedView.getContext(\'2d\');\n"
"	var nColorIndex = 0;\n"
"	var SizeInfo = TimerMenuSize(); //broken, fix!\n"
"\n"
"	SizeInfo.x = MenuItems[SubMenuModules].x;\n"
"	SizeInfo.y = MenuItems[SubMenuModules].y;\n"
"	var Y = SizeInfo.y;\n"
"	var Width = SizeInfo.w;\n"
"	Width = Math.max(300, Width);\n"
"	Width = 10+ MeasureArray(Width, M, function(s){return s.n + \" \" + s.s;} );\n"
"\n"
"	if(Width + SizeInfo.x + 50 > nWidth)\n"
"	{\n"
"		Width = nWidth - (SizeInfo.x+50);\n"
"	}\n"
"	SizeInfo.w = Width;\n"
"\n"
"\n"
"	var MaxStringLength = Math.floor(Width/(FontWidth));\n"
"\n"
"\n"
"	var X = SizeInfo.x;\n"
"	DrawSymbolHeaderMenu(context, X, Y, Width);\n"
"\n"
"	Y += BoxHeight;\n"
"	MoveFilterInputDiv(SizeInfo.x, Y, SizeInfo.w-6);\n"
"	Y += 45;\n"
"\n"
"	let bMouseIn = MouseY >= Y && MouseY < Y + BoxHeight;\n"
"	var bgcolor = bMouseIn ? nBackColorOffset : nBackColors[nColorIndex];\n"
"	var TextY = Y+BoxHeight-FontAscent;\n"
"	var YClear = Y;\n"
"	var TextYClear = TextY;\n"
"	var bgcolorClear = bgcolor;\n"
"	var YStart = Y-BoxHeight*2;\n"
"\n"
"	nColorIndex = 1-nColorIndex;\n"
"\n"
"	Y -= nOffsetMenuModules + 10;\n"
"	var Selection = -1;\n"
"\n"
"	var StringColor = function(Name)\n"
"	{\n"
"		var h = StringHash(Name);\n"
"		var cidx = h % 360;\n"
"		return cidx;\n"
"	};\n"
"\n"
"	for(var i = 0; i < M.length; ++i)\n"
"	{\n"
"		var Name = M[i].n;\n"
"		var Count = M[i].s;\n"
"		var Prc = M[i].p;\n"
"		if(Prc<0||Prc>1)\n"
"			Prc = 0;\n"
"		let cidx = StringColor(Name);\n"
"		let Color = \"hsl(\" + cidx + \",50%, 70%)\";\n"
"		let C1 = \"hsl(\" + cidx + \",30%, 40%)\";\n"
"		var N = Name;\n"
"		if(N.length > MaxStringLength)\n"
"		{\n"
"			N = N.substring(N.length - MaxStringLength);\n"
"		}\n"
"		if(FilterMatch(FilterArray, Name))\n"
"		{\n"
"\n"
"			if(Y >= YStart)\n"
"			{\n"
"				bMouseIn = MouseY >= Y && MouseY < Y + BoxHeight;\n"
"				bgcolor = bMouseIn && MouseX > X ? nBackColorOffset : nBackColors[nColorIndex];\n"
"				TextY = Y+BoxHeight-FontAscent;\n"
"\n"
"				context.fillStyle = bgcolor;\n"
"				context.fillRect(X, Y, Width, BoxHeight);\n"
"				if(Prc>0 && Prc <= 1)\n"
"				{\n"
"					context.fillStyle = C1;\n"
"					context.fillRect(X, Y, Prc*Width, BoxHeight);\n"
"				}\n"
"				context.fillStyle = \'white\';\n"
"				context.textAlign = \'right\';\n"
"				context.fillText(Count + \'\', X + Width - 2, TextY);\n"
"				context.textAlign = \'left\';\n"
"				context.fillStyle = Color;\n"
"				context.fillText(N, X, TextY);\n"
"				if(bMouseIn)\n"
"				{\n"
"					Selection = i;\n"
"				}\n"
"			}\n"
"			Y += BoxHeight;\n"
"			nColorIndex = 1-nColorIndex;\n"
"		}\n"
"	}\n"
"	context.textAlign = \'left\';\n"
"	if(Selection != -1 && MouseReleased)\n"
"	{\n"
"		WSSendMessage(\"L\" + M[Selection].n);\n"
"	}\n"
"	SizeInfo.h = Y-SizeInfo.y;\n"
"	return SizeInfo;\n"
"}\n"
"function DrawSymbolHeaderMenu(context, X, Y, Width)\n"
"{\n"
"	context.fillStyle = nBackColors[0];\n"
"	let TextY = Y+BoxHeight-FontAscent;\n"
"	context.fillRect(X+100, Y, Width-100, BoxHeight);\n"
"	let bMouseIn = MouseY >= Y && MouseY < Y + BoxHeight && MouseX-X < 100;\n"
"	if(bMouseIn)\n"
"	{\n"
"		context.fillStyle = nBackColorOffset;\n"
"	}\n"
"\n"
"	context.fillRect(X, Y, 99, BoxHeight);\n"
"\n"
"\n"
"	let NumSymbols = 0;\n"
"	let SymbolStateString = \"Load all\";\n"
"	let SymbolButtonActive = 1;\n"
"	let SymbolSpinnerActive = 0;\n"
"	let FinishedSymbols = 0;\n"
"	if(SymbolState)\n"
"	{\n"
"		FinishedSymbols = SymbolState.f;\n"
"		var s = SymbolState.s;\n"
"		NumSymbols = SymbolState.l;\n"
"		SymbolButtonActive = 1;\n"
"		if(SymbolState.q == 1 || FunctionQueryLastRequest != FunctionQueryReceived)\n"
"		{\n"
"			SymbolStateString = \"Querying\";\n"
"			SymbolButtonActive = 0;\n"
"			SymbolSpinnerActive = 1;\n"
"		}\n"
"		else if(SymbolState.f != SymbolState.r)\n"
"		{\n"
"			SymbolButtonActive = 0;\n"
"			SymbolSpinnerActive = 1;\n"
"			SymbolStateString = \"Loading\";\n"
"		}\n"
"		else if(SymbolState.f == ModuleState.length)\n"
"		{\n"
"			SymbolButtonActive = 0;\n"
"			SymbolStateString = \"Loaded\";\n"
"		}\n"
"	}\n"
"	let LoadButtonAnimation  = LoadSymbolAnimUpdateAndGet();\n"
"\n"
"	context.textAlign = \'right\';\n"
"	context.fillStyle = \'white\';\n"
"	context.fillText(NumSymbols + \" Symbols \" + FinishedSymbols + \"/\" + ModuleState.length + \" Modules\", X+Width-2, TextY);\n"
"	context.textAlign = \'center\';\n"
"\n"
"	if(LoadButtonAnimation>0)\n"
"	{ \n"
"		var c = \"hsl(0,0%,\" + (LoadButtonAnimation * 100)+\"%)\";\n"
"		context.fillStyle = c;\n"
"	}\n"
"	if(SymbolButtonActive)\n"
"	{\n"
"		if(bMouseIn && MouseReleased)\n"
"		{\n"
"			WSSendMessage(\"S\"); //load symbols\n"
"		}\n"
"		context.fillText(SymbolStateString, X + 50, TextY);\n"
"	}\n"
"	else\n"
"	{\n"
"		context.fillStyle = \'grey\';\n"
"		context.fillText(SymbolStateString, X + 50, TextY);\n"
"	}\n"
"	SpinnerDraw(SymbolSpinnerActive, context, SpinnerLoadButton, X+2, Y,  FontHeight, FontHeight );\n"
"\n"
"\n"
"}\n"
"\n"
"function DrawMenuFunctions()\n"
"{\n"
"	if(FilterInputValueLast != FilterInput.value)\n"
"	{\n"
"		nOffsetMenuFunctions = 0;\n"
"		var m = FilterInput.value.trim();\n"
"		if(m != \"\")\n"
"		{\n"
"			if(SymbolState && SymbolState.r == SymbolState.f)\n"
"			{\n"
"				var Req = ++FunctionQueryLastRequest;\n"
"				var Q = \"q\" + Req + \"x\" + m;\n"
"				WSSendMessage(Q);\n"
"				FunctionQueryPending = null;\n"
"			}\n"
"			else\n"
"			{\n"
"				FunctionQueryPending = m; \n"
"				if(SymbolState) //wtf?\n"
"				{\n"
"					LoadSymbolAnimRestart();\n"
"				}\n"
"			}\n"
"		}\n"
"	}\n"
"\n"
"	FilterInputValueLast = FilterInput.value;\n"
"	var FF = FunctionQueryArray;\n"
"	var FilterArray = CreateFilter(FilterInput.value);\n"
"	var context = CanvasDetailedView.getContext(\'2d\');\n"
"	var nColorIndex = 0;\n"
"	var SizeInfo = TimerMenuSize(); //broken, fix\n"
"	SizeInfo.x = MenuItems[SubMenuFunctions].x;\n"
"	SizeInfo.y = MenuItems[SubMenuFunctions].y;\n"
"	var Y = SizeInfo.y;\n"
"	var Width = SizeInfo.w;\n"
"	Width = Math.max(300, Width);\n"
"	Width = 10+ MeasureArray(Width, FF, function(s){return s.n + \" \" + s.m;} );\n"
"\n"
"	if(Width + SizeInfo.x + 50 > nWidth)\n"
"	{\n"
"		Width = nWidth - (SizeInfo.x+50);\n"
"	}\n"
"	SizeInfo.w = Width;\n"
"	var MaxStringLength = Math.floor(Width/(FontWidth));\n"
"\n"
"	var Selection = null;\n"
"	var X = SizeInfo.x;\n"
"	\n"
"	{\n"
"		DrawSymbolHeaderMenu(context, X, Y, Width);\n"
"	}\n"
"\n"
"\n"
"	Y += BoxHeight;\n"
"	MoveFilterInputDiv(SizeInfo.x, Y, SizeInfo.w-6);\n"
"	Y += 45;\n"
"\n"
"	let bMouseIn = MouseY >= Y && MouseY < Y + BoxHeight;\n"
"	var bgcolor = bMouseIn ? nBackColorOffset : nBackColors[nColorIndex];\n"
"	var TextY = Y+BoxHeight-FontAscent;\n"
"	var YClear = Y;\n"
"	var TextYClear = TextY;\n"
"	var bgcolorClear = bgcolor;\n"
"	var YStart = Y-BoxHeight*2;\n"
"\n"
"	nColorIndex = 1-nColorIndex;\n"
"\n"
"	Y -= nOffsetMenuFunctions + 10;\n"
"	var Selection = -1;\n"
"\n"
"	var StringColor = function(Name)\n"
"	{\n"
"		var h = StringHash(Name);\n"
"		var cidx = h % 360;\n"
"		return cidx;\n"
"	};\n"
"\n"
"	for(var i = 0; i < FF.length; ++i)\n"
"	{\n"
"		if(true)\n"
"		{\n"
"			var Name = FF[i].n;\n"
"			var ShortName = FF[i].sn;\n"
"			var Color = FF[i].c;\n"
"			var ColorModule = FF[i].cm;\n"
"			var ModuleName = FF[i].m;\n"
"			if(!Color || !ColorModule)\n"
"			{\n"
"				var cidx = StringColor(ShortName); \n"
"				FF[i].c = \"hsl(\" + cidx + \",50%, 70%)\";\n"
"				FF[i].rgb = ConvertHslToRGB(cidx/ 360, 0.5, 0.7);\n"
"				var cidxModule = StringColor(ModuleName); \n"
"				FF[i].cm = \"hsl(\" + cidxModule + \",50%, 70%)\";\n"
"				FF[i].rgbm = ConvertHslToRGB(cidxModule/ 360, 0.5, 0.7);\n"
"				Color = FF[i].c;\n"
"				ColorModule = FF[i].cm;\n"
"			}\n"
"			var UseAlt = 0;\n"
"			var N = UseAlt ? Name : ShortName;\n"
"			if(N.length > MaxStringLength)\n"
"			{\n"
"				N = N.substring(N.length - MaxStringLength);\n"
"			}\n"
"			var E = false;\n"
"			if(true)\n"
"			{\n"
"\n"
"				if(Y >= YStart)\n"
"				{\n"
"					bMouseIn = MouseY >= Y && MouseY < Y + BoxHeight;\n"
"					bgcolor = bMouseIn && MouseX > X ? nBackColorOffset : nBackColors[nColorIndex];\n"
"					TextY = Y+BoxHeight-FontAscent;\n"
"\n"
"					context.fillStyle = bgcolor;\n"
"					context.fillRect(X, Y, Width, BoxHeight);\n"
"					context.fillStyle = Color;\n"
"					context.textAlign = \'right\';\n"
"					context.fillText(N, X + Width - 2, TextY);\n"
"					context.textAlign = \'left\';\n"
"					context.fillStyle = ColorModule;\n"
"					context.fillText(ModuleName, X, TextY);\n"
"					if(bMouseIn)\n"
"					{\n"
"						context.fillStyle = Color;\n"
"						var bgcolorin = bMouseIn && MouseX < X ? nBackColorOffset : nBackColors[nColorIndex];\n"
"\n"
"						Selection = i;\n"
"						var W = context.measureText(\'>>\').width;\n"
"						W = Math.max(W, BoxHeight) + 2;\n"
"						var Corner = X - W - 1;\n"
"						if(Corner < SizeInfo.x)\n"
"						{\n"
"							SizeInfo.w += SizeInfo.x - Corner;\n"
"							SizeInfo.x = Corner;\n"
"						}\n"
"						context.fillStyle = bgcolorin;\n"
"						context.fillRect(Corner, Y, W, BoxHeight);\n"
"						context.fillStyle = Color;\n"
"						context.textAlign = \'center\';\n"
"						context.fillText(\">>\", Corner + Math.floor(W / 2), TextY);\n"
"\n"
"						context.textAlign = \'left\';\n"
"					}\n"
"				}\n"
"				Y += BoxHeight;\n"
"				nColorIndex = 1-nColorIndex;\n"
"			}\n"
"		}\n"
"	}\n"
"\n"
"	context.textAlign = \'left\';\n"
"	if(Selection != -1 && MouseReleased)\n"
"	{\n"
"		if(KeyShiftDown || MouseX < X)\n"
"		{\n"
"			WSSendMessage(\"I\" + FF[Selection].a + \' \' + FF[Selection].rgb + \' \' + FF[Selection].m + \'!\' + FF[Selection].n);		\n"
"		}\n"
"		else\n"
"		{\n"
"			WSSendMessage(\"i\" + FF[Selection].a + \' \' + FF[Selection].rgb + \' \' + FF[Selection].m + \'!\' + FF[Selection].n);		\n"
"		}\n"
"	}\n"
"	SizeInfo.h = Y-SizeInfo.y;\n"
"	return SizeInfo;\n"
"}\n"
"\n"
"function DrawMenuGeneric(Elements, Active, OnClick, x, y, Elements2)\n"
"{\n"
"	var context = CanvasDetailedView.getContext(\'2d\');\n"
"	var nColorIndex = 0;\n"
"	if(Elements2.length != Elements.length)\n"
"	{\n"
"		Elements2 = null;\n"
"	}\n"
"\n"
"	var h = FontHeight * Elements.length;\n"
"	var w = 20;\n"
"	var w2 = 0;\n"
"	for(var i = 0; i < Elements.length; ++i)\n"
"	{\n"
"		var m = context.measureText(Elements[i]).width;\n"
"		w = w > m ? w : m;\n"
"		if(Elements2)\n"
"		{\n"
"			m = context.measureText(Elements2[i]).width;\n"
"			w2 = w2 > m ? w2 : m;\n"
"		}\n"
"	}\n"
"	w += 10 + w2;\n"
"	var SizeInfo = MenuSize(w);\n"
"	SizeInfo.x = x;\n"
"	SizeInfo.y = y;\n"
"	var X = x;\n"
"	var Y = y;\n"
"\n"
"\n"
"	for(var i = 0; i < Elements.length; ++i)\n"
"	{\n"
"		var Selected = Active == i;\n"
"		var Name = Elements[i];\n"
"		var bMouseIn = MouseY >= Y && MouseY < Y + BoxHeight;\n"
"		var bgcolor = bMouseIn ? nBackColorOffset : nBackColors[nColorIndex];\n"
"		var TextY = Y+BoxHeight-FontAscent;\n"
"		context.fillStyle = Selected?\'white\':bgcolor;\n"
"		context.fillRect(X-2, Y, w+4, BoxHeight);\n"
"		context.fillStyle = bgcolor;\n"
"		context.fillRect(X, Y, w, BoxHeight);\n"
"		context.fillStyle = \'white\';\n"
"		context.fillText(Name, X + 2, TextY);\n"
"		if(Elements2)\n"
"		{\n"
"			context.textAlign = \"right\";\n"
"			context.fillText(Elements2[i], X + w , TextY);\n"
"			context.textAlign = \"left\";\n"
"		}\n"
"		context.fillText(Name, X + 2, TextY);\n"
"		if(bMouseIn && MouseReleased)\n"
"		{\n"
"			OnClick(i, Name);\n"
"		}\n"
"		Y += BoxHeight;\n"
"		nColorIndex = 1-nColorIndex;\n"
"	}\n"
"	SizeInfo.h = Y - SizeInfo.y;\n"
"	return SizeInfo;\n"
"}\n"
"\n"
"function DrawMenuGroup()\n"
"{\n"
"	if(FilterInputValueLast != FilterInput.value)\n"
"	{\n"
"		nOffsetMenuGroup = 0;\n"
"	}\n"
"	FilterInputValueLast = FilterInput.value;\n"
"\n"
"	var context = CanvasDetailedView.getContext(\'2d\');\n"
"	var nColorIndex = 0;\n"
"	var Selection = null;\n"
"	var SizeInfo = GroupMenuSize();\n"
"	SizeInfo.x = MenuItems[SubMenuGroup].x;\n"
"	SizeInfo.y = MenuItems[SubMenuGroup].y;\n"
"	var Y = SizeInfo.y;\n"
"	var X = SizeInfo.x;\n"
"	var Width = SizeInfo.w;\n"
"	var FilterArray = CreateFilter(FilterInput.value);\n"
"	MoveFilterInputDiv(SizeInfo.x-2, SizeInfo.y, SizeInfo.w-1);\n"
"	var YStart = Y+20;\n"
"	Y += 35;\n"
"	Y -= nOffsetMenuGroup;\n"
"\n"
"\n"
"	function DrawMenuElement(Selected, Name, color, Indent)\n"
"	{\n"
"		var bMouseIn = MouseY >= Y && MouseY < Y + BoxHeight;\n"
"		var bgcolor = bMouseIn ? nBackColorOffset : nBackColors[nColorIndex];\n"
"		context.fillStyle = Selected?\'white\':bgcolor;\n"
"		context.fillRect(X-2, Y, Width+4, BoxHeight);\n"
"		context.fillStyle = bgcolor;\n"
"		context.fillRect(X, Y, Width, BoxHeight);\n"
"		context.fillStyle = color;\n"
"		if(!Indent) Indent = 0;\n"
"		context.fillText(Name, X + Indent*FontWidth, Y+BoxHeight-FontAscent);\n"
"		nColorIndex = 1-nColorIndex;\n"
"		Y += BoxHeight;\n"
"		return bMouseIn;\n"
"	}\n"
"	function DrawMenuRecursive(Index, Indent, categorymatch)\n"
"	{\n"
"		ProfileEnter(\"DrawMenuRecursive\");		\n"
"		var v = TimerArray[Index];\n"
"		if(v.idtype == TYPE_TIMER || v.idtype == TYPE_COUNTER)\n"
"		{\n"
"			return;\n"
"		}\n"
"		if(v.idtype == TYPE_GROUP && !categorymatch)\n"
"		{\n"
"			if(!FilterMatch(FilterArray, v.name))\n"
"			{\n"
"				return;\n"
"			}\n"
"		}\n"
"		var catmatch = 0;\n"
"		if(v.idtype == TYPE_CATEGORY)\n"
"		{\n"
"			if(FilterMatch(FilterArray, v.name))\n"
"			{\n"
"				catmatch = 1;\n"
"			}\n"
"		}\n"
"		var Closed = 0;\n"
"		if(Index > 0)\n"
"		{\n"
"			if(Y > YStart)\n"
"			{\n"
"				if(DrawMenuElement(v.e, v.name, v.color, Indent))\n"
"				{\n"
"					Selection = v.id;\n"
"				}\n"
"			}\n"
"			else\n"
"			{\n"
"				Y += BoxHeight;\n"
"			}\n"
"		}\n"
"\n"
"		if(!Closed)\n"
"		{\n"
"			var ChildIndex = v.firstchild;\n"
"			while(ChildIndex != -1)\n"
"			{\n"
"				DrawMenuRecursive(ChildIndex, Indent + 1, catmatch);\n"
"				ChildIndex = TimerArray[ChildIndex].sibling;\n"
"			}\n"
"		}\n"
"		ProfileLeave();\n"
"	}\n"
"	DrawMenuRecursive(0, -1);\n"
"	if(Selection && MouseReleased)\n"
"	{\n"
"		WSSendMessage(\"c\" + Selection);\n"
"	}\n"
"	SizeInfo.h = Y - SizeInfo.y;\n"
"	return SizeInfo;\n"
"}\n"
"\n"
"function ShowMenu()\n"
"{\n"
"	if(!Settings.ViewCompressed)\n"
"		return true;\n"
"	else\n"
"	{\n"
"		var Time = new Date();\n"
"		var Delta = Time - MouseMoveTime;\n"
"		console.log(\'delta time is \' + Delta);\n"
"		return Delta < 2000;\n"
"	}\n"
"}\n"
"\n"
"function DrawMenu()\n"
"{\n"
"	if(WSConnected && WS && WS.readyState == 1)\n"
"	{\n"
"		var context = CanvasDetailedView.getContext(\'2d\');\n"
"		var nColorIndex = 0;\n"
"		var Y = 50;\n"
"		var Width = 300;\n"
"		var Selection = null;\n"
"		if(!ShowMenu())\n"
"		{\n"
"			return;\n"
"		}\n"
"		ProfileEnter(\"DrawMenu\");\n"
"		DrawTopMenu();\n"
"		var MenuRect = WindowRect(0,0,nWidth,nHeight);\n"
"		if(SubMenuActive != -1)\n"
"		{\n"
"			MouseMoveTime = new Date();\n"
"		}\n"
"		if(SubMenuActive == SubMenuGroup)\n"
"		{\n"
"			MenuRect = DrawMenuGroup();\n"
"		}\n"
"		else if(SubMenuActive == SubMenuTimers)\n"
"		{\n"
"			MenuRect = DrawMenuTimer();\n"
"		}\n"
"		else if(SubMenuActive == SubMenuModules)\n"
"		{\n"
"			MenuRect = DrawMenuModules();\n"
"		}\n"
"		else if(SubMenuActive == SubMenuFunctions)\n"
"		{\n"
"			MenuRect = DrawMenuFunctions();\n"
"		}\n"
"		else if(SubMenuActive == SubMenuPatched)\n"
"		{\n"
"			MenuRect = DrawMenuPatched();\n"
"		}\n"
"		else if(SubMenuActive == SubMenuSettings)\n"
"		{\n"
"			MenuRect = DrawMenuSettings();\n"
"		}\n"
"		else if(SubMenuActive == SubMenuViews)\n"
"		{\n"
"			MenuRect = DrawMenuViews();\n"
"		}\n"
"		else if(SubMenuActive == SubMenuPresets)\n"
"		{\n"
"			MenuRect = DrawMenuPresets();\n"
"		}\n"
"		else if(SubMenuActive == SubMenuColumns)\n"
"		{\n"
"			MenuRect = DrawMenuColumns();\n"
"		}\n"
"		else if(SubMenuActive == SubMenuCapture)\n"
"		{\n"
"			MenuRect = DrawMenuCapture();\n"
"		}\n"
"		else if(SubMenuActive == SubMenuGraphSettings)\n"
"		{\n"
"			MenuRect = DrawMenuGraphSettings();\n"
"		}\n"
"		var Grow = 10;\n"
"		MenuRect.x -= Grow;\n"
"		MenuRect.y -= Grow;\n"
"		MenuRect.h += 2*Grow;\n"
"		MenuRect.w += 2*Grow;\n"
"		var MouseMoved = MouseX != SubMenuMouseX || MouseY != SubMenuMouseY;\n"
"	\n"
"		if(MouseInRect(MenuRect) || !MouseMoved)\n"
"		{\n"
"			SubMenuTimeout = new Date();\n"
"			SubMenuMouseX = MouseX;\n"
"			SubMenuMouseY = MouseY;\n"
"		}\n"
"		else\n"
"		{\n"
"			var Time = new Date() - SubMenuTimeout;\n"
"			var Dest = SubMenuTimeoutBase * 1000;\n"
"			if(Time > Dest)\n"
"			{\n"
"				EnableMenu(-1);\n"
"			}\n"
"		}\n"
"		if(0)//debugging of menu extents. dont delete\n"
"		{\n"
"			context.strokeStyle = \'red\';\n"
"			context.beginPath();\n"
"			context.moveTo(MenuRect.x,MenuRect.y);\n"
"			context.lineTo(MenuRect.x + MenuRect.w,MenuRect.y);\n"
"			context.lineTo(MenuRect.x ";

const size_t g_MicroProfileHtmlLive_begin_3_size = sizeof(g_MicroProfileHtmlLive_begin_3);
const char g_MicroProfileHtmlLive_begin_4[] =
"+ MenuRect.w,MenuRect.y+MenuRect.h);\n"
"			context.lineTo(MenuRect.x,MenuRect.y+MenuRect.h);\n"
"			context.lineTo(MenuRect.x,MenuRect.y);\n"
"			context.stroke();\n"
"		}\n"
"		SpinnerDraw(SpinnerShow(), context, SpinnerCorner, 0, nHeight-20,  20, 20);\n"
"		ProfileLeave();\n"
"	}\n"
"}\n"
"\n"
"function DrawConnectionStatus()\n"
"{\n"
"	if(WSConnected && WS && WS.readyState == 1)\n"
"	{\n"
"		if(!ProfileMode)\n"
"			return;\n"
"	}\n"
"	var Strings = new Array();\n"
"	Strings.push(\"Status\");\n"
"	if(WSConnected && WS && WS.readyState == 1)\n"
"	{\n"
"		Strings.push(\"[X]\");\n"
"	}\n"
"	else\n"
"	{\n"
"		ConnectionIdx = (ConnectionIdx + 1 ) % ConnectionStr.length;\n"
"		Strings.push(\"[\" + ConnectionStr[ConnectionIdx]+\"]\");\n"
"	}\n"
"	Strings.push(\"Port\");\n"
"	Strings.push(\"\" + WSPort);\n"
"	Strings.push(\"Path\");\n"
"	Strings.push(\"\" + WSPath);\n"
"	Strings.push(\"Sends\");\n"
"	Strings.push(\"\" + WSSend);\n"
"	Strings.push(\"Receives\");\n"
"	Strings.push(\"\" + WSReceive);\n"
"	Strings.push(\"SendBytes\");\n"
"	Strings.push(\"\" + WSSendBytes);\n"
"	Strings.push(\"ReceiveBytes\");\n"
"	Strings.push(\"\" + WSReceiveBytes);\n"
"	Strings.push(\"Seconds\");\n"
"	Strings.push(\"\" + WSSeconds);\n"
"	DrawToolTip(Strings, CanvasDetailedView, 50000, 0);\n"
"}\n"
"function DrawActiveToolTip()\n"
"{\n"
"	if(SubMenuActive == -1)\n"
"	{\n"
"		if(ToolTipCallback && SubMenuActive == -1)\n"
"		{\n"
"			var Strings = ToolTipCallback(CanvasDetailedView, MouseX, MouseY);\n"
"			if(Strings)\n"
"			{\n"
"				DrawToolTip(Strings, CanvasDetailedView, MouseX, MouseY);\n"
"			}\n"
"		}\n"
"	}\n"
"	ToolTipCallback = null;\n"
"}\n"
"function UpdateSettings()\n"
"{\n"
"	if(Settings.AutomaticReference)\n"
"	{\n"
"		if( Math.abs(ReferenceGraph - ReferenceGraphAutomatic) > 0.02 ||\n"
"			Math.abs(ReferenceHistory - ReferenceHistoryAutomatic) > 0.02)\n"
"		{\n"
"			RequestDraw();\n"
"		}\n"
"		ReferenceGraph = 0.9 * ReferenceGraph + 0.1 * ReferenceGraphAutomatic;\n"
"		ReferenceHistory = 0.9 * ReferenceHistory + 0.1 * ReferenceHistoryAutomatic;\n"
"		ReferenceBar = 0.9 * ReferenceBar + 0.1 * ReferenceBarAutomatic;\n"
"		var TimerMap = FrameData.TimerMap;\n"
"		if(!TimerMap)\n"
"			return;\n"
"\n"
"\n"
"		for(var key in TimerMap)\n"
"		{\n"
"			var TimerState = TimerMap[key];\n"
"			if(!TimerState.historymaxsoft)\n"
"			{\n"
"				TimerState.historymaxsoft = TimerState.historymax;\n"
"			}\n"
"			else\n"
"			{\n"
"				TimerState.historymaxsoft = 0.9 * TimerState.historymaxsoft + 0.1 * TimerState.historymax;\n"
"			}\n"
"		}\n"
"\n"
"	}\n"
"	else\n"
"	{\n"
"		ReferenceGraph = Settings.ReferenceTime;\n"
"		ReferenceHistory = Settings.ReferenceTime;\n"
"		ReferenceBar = Settings.ReferenceTime;\n"
"	}\n"
"	if(Settings.AggregateFrames != AggregateFrames)\n"
"	{\n"
"		WSSendMessage(\"a\" + Settings.AggregateFrames);\n"
"		AggregateFrames = Settings.AggregateFrames;\n"
"	}\n"
"}\n"
"\n"
"var PendingDraw = 0;\n"
"\n"
"function Draw()\n"
"{\n"
"	CaptureUpdate();\n"
"	PendingDraw = 0;\n"
"	ProfileModeClear();\n"
"	ProfileEnter(\"Total\");\n"
"\n"
"	UpdateSettings();\n"
"\n"
"	if(WSConnected && WS && WS.readyState == 1)\n"
"	{\n"
"		DrawViews();\n"
"		DrawMessage();	\n"
"		DrawMenu();\n"
"	}\n"
"	else\n"
"	{\n"
"		var context = CanvasDetailedView.getContext(\'2d\');\n"
"		context.clearRect(0, 0, nWidth, nHeight);\n"
"		DrawMessage();\n"
"	}\n"
"\n"
"	DrawConnectionStatus();\n"
"	DrawPlotf(CanvasDetailedView);\n"
"	DrawActiveToolTip();\n"
"\n"
"\n"
"	ProfileLeave();\n"
"	ProfileModeDraw(CanvasDetailedView);\n"
"\n"
"	PlotfClear();\n"
"\n"
"	MouseReleased = false;\n"
"}\n"
"function RequestDraw()\n"
"{\n"
"	if(!PendingDraw)\n"
"	{\n"
"		PendingDraw = 1;\n"
"		requestAnimationFrame(Draw);\n"
"	}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"function WSOpen(event)\n"
"{\n"
"	SetMessage(\"Connected!\", 1000);\n"
"	WSSend = 0;\n"
"	WSReceive = 0;\n"
"	WSSendBytes = 0;\n"
"	WSReceiveBytes = 0;\n"
"	WSIsOpen = 1;\n"
"\n"
"	Empty = {\"id\":0, \"w\":0, \"depth\":0, \"sibling\":-1,\"parent\":-1,\"firstchild\":-1};\n"
"	TimerArray = [];\n"
"	TimerArray.push(Empty);\n"
"	WidthArray = [];\n"
"	CounterArray = [];\n"
"	WidthArray[TYPE_NONE] = 0;\n"
"	WidthArray[TYPE_TIMER] = 0;\n"
"	WidthArray[TYPE_GROUP] = 0;\n"
"	WidthArray[TYPE_CATEGORY] = 0;\n"
"	WidthTree = FontWidth;\n"
"	SymbolState = null;\n"
"	FunctionQueryPending = 0;\n"
"	FunctionQueryReceived = 0;\n"
"	FunctionQueryLastRequest = 0;\n"
"	FunctionsInstrumented = [];\n"
"	FunctionsInstrumentedModule = [];\n"
"	FunctionsInstrumentedUnmangled = [];\n"
"\n"
"	FilterInputTimersValue = \"\";\n"
"	FilterInputGroupsValue = \"\";\n"
"	FilterInputFunctionsValue = \"\";\n"
"	FilterInput.value = \"\";\n"
"	FunctionQueryArray = [];\n"
"	ModuleState = [];\n"
"\n"
"	ResetFrameData();\n"
"	window.document.title = \"MP:\" + WSHost;\n"
"\n"
"	if(PresetToLoad && PresetToLoad != \"\")\n"
"	{\n"
"		LoadPreset(PresetToLoad, PresetToLoadRO);\n"
"	}\n"
"}\n"
"\n"
"function SplitIdTop(v)\n"
"{\n"
"	return v >> 24; // todo: verify\n"
"}\n"
"\n"
"function SplitIdBottom(v)\n"
"{\n"
"	return v & 0xffffff; // todo: verify\n"
"}\n"
"\n"
"function GetTimer(id)\n"
"{\n"
"	for(var i = 0; i < TimerArray.length; ++i)\n"
"	{\n"
"		if(TimerArray[i].id == id)\n"
"		{\n"
"			return i;\n"
"		}\n"
"	}\n"
"	return null;\n"
"}\n"
"function IsGroup(id)\n"
"{\n"
"	var idx = GetTimer(id);\n"
"	return TimerArray[idx].idtype == TYPE_GROUP;\n"
"}\n"
"\n"
"function UpdateActive()\n"
"{\n"
"	GroupsEnabled = 0;\n"
"	TimersEnabled = 0;\n"
"	for(var i = 0; i < TimerArray.length; ++i)\n"
"	{\n"
"		var T = TimerArray[i];\n"
"		if(T.e)\n"
"		{\n"
"			switch(T.idtype)\n"
"			{\n"
"				case TYPE_GROUP:\n"
"					GroupsEnabled++;\n"
"				break;\n"
"				case TYPE_TIMER:\n"
"					TimersEnabled++;\n"
"				break;\n"
"			}\n"
"		}\n"
"	}\n"
"}\n"
"function UpdateEnabledTimer(idx)\n"
"{\n"
"	UpdateActive();\n"
"	var type = TimerArray[idx].idtype;\n"
"	var enabled = TimerArray[idx].e;\n"
"	if(TimerArray[idx].idtype != TYPE_TIMER)\n"
"	{\n"
"		return;\n"
"	}\n"
"	var AutoCaptureSourceValue = null;\n"
"	if(AutoCaptureSourceIndex >= 0 && AutoCaptureSourceIndex < EnabledArray.length)\n"
"	{\n"
"		AutoCaptureSourceValue = EnabledArray[AutoCaptureSourceIndex];\n"
"	}\n"
"\n"
"	var i = EnabledArray.indexOf(idx);\n"
"	if(enabled)\n"
"	{\n"
"		if(i == -1)\n"
"		{\n"
"			EnabledArray.unshift(idx);\n"
"		}\n"
"	}\n"
"	else\n"
"	{\n"
"		if(i != -1)\n"
"		{\n"
"			EnabledArray.splice(i, 1);\n"
"		}\n"
"	}\n"
"	var NewIndex = AutoCaptureSourceValue != null ? EnabledArray.indexOf(AutoCaptureSourceValue) : -1;\n"
"	AutoCaptureSourceIndex = NewIndex;\n"
"}\n"
"\n"
"\n"
"function EnableTimer(T)\n"
"{\n"
"	var idx = GetTimer(T.id);\n"
"	if(idx != null && idx>=0)\n"
"	{\n"
"		TimerArray[idx].e = T.e;\n"
"		UpdateEnabledTimer(idx);\n"
"	}\n"
"	else\n"
"	{\n"
"		console.log(\'unknown enable message\');\n"
"	}\n"
"}\n"
"function MeasureWidth(str)\n"
"{\n"
"	var context = CanvasDetailedView.getContext(\'2d\');\n"
"	return context.measureText(str).width;\n"
"}\n"
"function AddTimer(T)\n"
"{\n"
"	if(!T.color || T.color == \"\")\n"
"	{\n"
"		T.color = ColorFromString(T.name, 40, 50);\n"
"	}\n"
"	console.log(\"Added timer\", T.name);\n"
"	var idx = TimerArray.length;\n"
"	var existing = GetTimer(T.id);\n"
"	if(existing)\n"
"	{\n"
"		idx = existing;\n"
"	}\n"
"	else\n"
"	{\n"
"		TimerArray[idx] = T;\n"
"	}\n"
"	TimerArray[idx].time = 0;\n"
"	TimerArray[idx].excl = 0;\n"
"	TimerArray[idx].average = 0;\n"
"	TimerArray[idx].max = 0;\n"
"	TimerArray[idx].min = 0;\n"
"	TimerArray[idx].total = 0;\n"
"	TimerArray[idx].exclaverage = 0;\n"
"	TimerArray[idx].exclmax = 0;\n"
"	TimerArray[idx].excltotal = 0;\n"
"	TimerArray[idx].spike = 0;\n"
"	TimerArray[idx].callaverage = 0;\n"
"	TimerArray[idx].callexclaverage = 0;\n"
"	TimerArray[idx].callcount = 0;\n"
"	var w = MeasureWidth(T.name);\n"
"	var idtype = SplitIdTop(T.id);\n"
"	var idelement = SplitIdBottom(T.id);\n"
"	TimerArray[idx].idtype = idtype;\n"
"	TimerArray[idx].idelement = idelement;\n"
"	TimerArray[idx].w = w;\n"
"	TimerArray[idx].wtree = w;\n"
"	if(!existing)\n"
"	{\n"
"		TimerArray[idx].sibling = -1;\n"
"		TimerArray[idx].parent = -1;\n"
"		TimerArray[idx].firstchild = -1;\n"
"	}\n"
"	if(w > WidthArray[idtype])\n"
"	{\n"
"		WidthArray[idtype] = w;\n"
"	}\n"
"	UpdateEnabledTimer(idx);\n"
"	var wparent = 0;\n"
"	var pidx = GetTimer(T.pid);\n"
"	if(pidx >= 0 && !existing)\n"
"	{\n"
"		TimerArray[idx].parent = pidx;\n"
"		var Parent = TimerArray[pidx];\n"
"		var Sibling = Parent.firstchild;\n"
"		wparent = MeasureWidth(Parent.name);\n"
"		Parent.firstchild = idx;\n"
"		if(Sibling != -1)\n"
"		{\n"
"			if(TimerArray[Sibling].sibling == idx)\n"
"			{\n"
"				debugger;\n"
"			}\n"
"		}\n"
"		TimerArray[idx].sibling = Sibling;\n"
"		TimerArray[idx].wtree += Parent.depth * FontWidth;\n"
"		TimerArray[idx].depth = Parent.depth + 1;\n"
"		if(TimerArray[idx].wtree > WidthTree)\n"
"		{\n"
"			WidthTree = TimerArray[idx].wtree;\n"
"		}\n"
"		TimerArray[idx].sortkey = Parent.name + \" __ \" + T.name;\n"
"	}\n"
"	else\n"
"	{\n"
"		TimerArray[idx].sortkey = T.name;\n"
"	}\n"
"	TimerArray[idx].wparent = wparent;\n"
"	TimerArray[idx].wtotal = wparent + w;\n"
"\n"
"	if(idtype == TYPE_COUNTER)\n"
"	{\n"
"		if(idelement != CounterArray.length)\n"
"		{\n"
"			debugger;\n"
"		}\n"
"		CounterArray.push(idx);\n"
"		TimerArray[idx].formattedlimit = FormatCounter(TimerArray[idx].format, TimerArray[idx].limit);\n"
"		CounterLimitWidth = Math.max(CounterLimitWidth, TimerArray[idx].formattedlimit.length * (FontWidth+1));\n"
"		CounterNameWidth = Math.max(CounterNameWidth, (TimerArray[idx].name.length + 1 + TimerArray[idx].depth) * (FontWidth+1));\n"
"		TimerArray[idx].counterhistory = {};		\n"
"		TimerArray[idx].counterhistory.history = AllocClearedArray(120);\n"
"		TimerArray[idx].counterhistory.prc = AllocClearedArray(120);		\n"
"	}\n"
"	if(idtype == TYPE_TIMER)\n"
"	{\n"
"		if(T.color == \"#000000\")\n"
"		{\n"
"			T.color = ColorFromString(T.name + \"x\" + Parent.name, 40, 50);\n"
"		}\n"
"\n"
"	}\n"
"	RequestDraw();\n"
"}\n"
"\n"
"function AllocClearedArray(Size)\n"
"{\n"
"	var A = new Array(Size);\n"
"	for(var i = 0; i < Size; ++i)\n"
"	{\n"
"		A[i] = 0;\n"
"	}\n"
"	return A;\n"
"}\n"
"function PushIntoArray(A, v)\n"
"{\n"
"	A.shift();\n"
"	A.push(v);\n"
"}\n"
"function ResetFrameData()\n"
"{\n"
"	FrameData = {};\n"
"	FrameData.TimerMap = {};\n"
"	FrameData.Time = AllocClearedArray(FRAME_COUNT);\n"
"	FrameData.Ids = AllocClearedArray(FRAME_COUNT);\n"
"	FrameData.Frozen = AllocClearedArray(FRAME_COUNT);\n"
"	FrameData.ThreadTime = {};\n"
"}\n"
"function GetFrameData(id)\n"
"{\n"
"	if(FrameData.TimerMap[id])\n"
"	{\n"
"		return FrameData.TimerMap[id];\n"
"	}\n"
"	else\n"
"	{\n"
"		var FD = {};\n"
"		FD.Count = AllocClearedArray(FRAME_COUNT);\n"
"		FD.Time = AllocClearedArray(FRAME_COUNT);\n"
"		FD.TimeExcl = AllocClearedArray(FRAME_COUNT);\n"
"		FD.TimeMax = AllocClearedArray(AggregateHistorySize);\n"
"		FD.TimeMin = AllocClearedArray(AggregateHistorySize);\n"
"		FD.TimeAvg = AllocClearedArray(AggregateHistorySize);\n"
"		FD.TimeExclMax = AllocClearedArray(AggregateHistorySize);\n"
"		FD.TimeExclMin = AllocClearedArray(AggregateHistorySize);\n"
"		FD.TimeExclAvg = AllocClearedArray(AggregateHistorySize);\n"
"		FD.TimeCallAvg = AllocClearedArray(AggregateHistorySize);\n"
"		FD.TimeCallExclAvg = AllocClearedArray(AggregateHistorySize);\n"
"		FD.TimeTotal = AllocClearedArray(AggregateHistorySize);\n"
"		FD.TimeExclTotal = AllocClearedArray(AggregateHistorySize);\n"
"		FD.CallCount = AllocClearedArray(AggregateHistorySize);\n"
"		FD.Percentile = [];\n"
"		FD.PercentileMax = -1e38;\n"
"		FD.PercentileMin = 1e38;\n"
"		FD.EmptyFrames = 0;\n"
"		\n"
"\n"
"		FD.AggregateFrames = 0;\n"
"		FD.FrameTime = 0.0;\n"
"		FD.Aggregate = 0;\n"
"		FD.AggregateTime = 0.0;\n"
"		FD.AggregateSum = 0;\n"
"		FD.AggregateMax = 0;\n"
"		FD.AggregateMin = C_HUGE;\n"
"		FD.AggregateExclSum = 0;\n"
"		FD.AggregateExclMax = 0;\n"
"		FD.AggregateCount = 0;\n"
"		FD.AggregateExclMin = C_HUGE;\n"
"\n"
"\n"
"\n"
"		FrameData.TimerMap[id] = FD;\n"
"		return FD;\n"
"	}\n"
"}\n"
"\n"
"function ProcessCounters(C)\n"
"{\n"
"	for(var i = 0; i < CounterArray.length; ++i)\n"
"	{\n"
"		if(i > C.length)\n"
"		{\n"
"			debugger;\n"
"		}\n"
"		var idx = CounterArray[i];\n"
"		var value = C[i];\n"
"		var T = TimerArray[idx];\n"
"		T.value = value;\n"
"		if(T.minvalue == undefined)\n"
"			T.minvalue = value;\n"
"		else\n"
"			T.minvalue = Math.min(T.minvalue, value);\n"
"		if(T.maxvalue == undefined)\n"
"			T.maxvalue = value;\n"
"		else\n"
"			T.maxvalue = Math.max(T.maxvalue, value);\n"
"		T.formatted = FormatCounter(T.format, value);\n"
"		var boxprc = 1.0;\n"
"		var counterprc = 0;\n"
"		if(T.limit)\n"
"		{\n"
"			counterprc = value / T.limit;\n"
"			if(counterprc > 1.0)\n"
"			{\n"
"				boxprc = 1.0 / counterprc;\n"
"				counterprc = 1.0;\n"
"			}\n"
"			counterprc = Math.max(counterprc, 0.0);\n"
"\n"
"		}\n"
"		T.boxprc = boxprc;\n"
"		T.counterprc = counterprc;\n"
"		PushIntoArray(T.counterhistory.history, value);\n"
"		var prc = T.maxvalue > T.minvalue ? (value - T.minvalue) / (T.maxvalue - T.minvalue) : 0.0;\n"
"		PushIntoArray(T.counterhistory.prc, prc);\n"
"		CounterValueWidth = Math.max(CounterValueWidth, T.formatted.length * (FontWidth+1));\n"
"	}\n"
"\n"
"}\n"
"\n"
"\n"
"function ProcessFrame(F, Inactive)\n"
"{\n"
"	if(F.s)\n"
"	{\n"
"		if(F.s.l == F.s.r)\n"
"		{\n"
"			if(FunctionQueryPending)\n"
"			{\n"
"				var Req = ++FunctionQueryLastRequest;\n"
"				var Q = \"q\" + Req + \"x\" + FunctionQueryPending;\n"
"				WSSendMessage(Q);\n"
"				FunctionQueryPending = null;\n"
"			}\n"
"		}\n"
"		SymbolState = F.s;\n"
"		if(F.M)\n"
"		{\n"
"			ModuleState = F.M;\n"
"		}\n"
"		MenuItems[SubMenuFunctions].visible = function(){return true;};\n"
"		MenuItems[SubMenuModules].visible = function(){return true;};\n"
"	}\n"
"	else\n"
"	{\n"
"		MenuItems[SubMenuFunctions].visible = function(){return false;};\n"
"		MenuItems[SubMenuModules].visible = function(){return false;};\n"
"	}\n"
"	if(F.fr)\n"
"	{\n"
"		IsFrozen = 10;//allow it to stabilize after freezing\n"
"		return;\n"
"	}\n"
"	if(IsFrozen)\n"
"	{\n"
"		IsFrozen--;\n"
"	}\n"
"	if(!Inactive)\n"
"	{\n"
"		var TriggerAutoCapture = 0;\n"
"		PushIntoArray(FrameData.Time, F.t);\n"
"		PushIntoArray(FrameData.Ids, F.f);\n"
"		PushIntoArray(FrameData.Frozen, IsFrozen ? 1 : 0);\n"
"		var CaptureId = null;\n"
"		var AutoCapture = AutoCaptureEnabled && !IsFrozen;\n"
"		AggregateCurrent = F.a;\n"
"		if(F.m != Settings.ViewActive)\n"
"		{\n"
"			WSSendMessage(\"v\" + Settings.ViewActive);\n"
"		}\n"
"		if(AutoCapture > 0 && null == CaptureTriggerTime && AutoCaptureCooldown < 0)\n"
"		{\n"
"			if(AutoCaptureSourceIndex == -1 && F.t > Settings.AutoCaptureTheshold)\n"
"			{\n"
"				AutoCaptureEnabled -= 1;\n"
"				TriggerAutoCapture = 1;\n"
"			}\n"
"			else if(AutoCaptureSourceIndex >= 0 && AutoCaptureSourceIndex < EnabledArray.length)\n"
"			{\n"
"				var id = TimerArray[EnabledArray[AutoCaptureSourceIndex]].id;\n"
"				var Data = F.x[id];\n"
"				if(Data && Data[0])\n"
"				{\n"
"				 	if(Data[0] > Settings.AutoCaptureTheshold)\n"
"				 	{\n"
"				 		TriggerAutoCapture = 1;\n"
"				 		AutoCaptureEnabled -= 1;\n"
"						console.log(\'trigger capture! \', Data[0], \' \', Settings.AutoCaptureTheshold);\n"
"				 	}\n"
"				}\n"
"			}\n"
"		}\n"
"		AutoCaptureCooldown = AutoCaptureCooldown - 1;\n"
"\n"
"		var GraphTimeMax = 0;\n"
"		var GraphTimeGroupMax = 0;\n"
"		var HistoryTimeMax = 0;\n"
"\n"
"		for(var i = 0; i < FrameData.Time.length; ++i)\n"
"		{\n"
"			if(0 == FrameData.Frozen[i])\n"
"			{\n"
"				HistoryTimeMax = HistoryTimeMax > FrameData.Time[i] ? HistoryTimeMax : FrameData.Time[i];\n"
"			}\n"
"		}\n"
"		var FindMaxTime = function(A, bIsGroup)\n"
"		{\n"
"			var MaxTime = 0;\n"
"			for(var i = 0; i < A.length; ++i)\n"
"			{\n"
"				if(0 == FrameData.Frozen[i])\n"
"				{\n"
"					MaxTime = MaxTime > A[i] ? MaxTime : A[i];\n"
"				}\n"
"			}\n"
"			if(bIsGroup)	\n"
"				GraphTimeGroupMax = MaxTime > GraphTimeGroupMax ? MaxTime : GraphTimeGroupMax;\n"
"			else\n"
"				GraphTimeMax = MaxTime > GraphTimeMax ? MaxTime : GraphTimeMax;\n"
"			return MaxTime;\n"
"		};\n"
"		function SetAggregateTimersInArray(FD, id)\n"
"		{\n"
"			var idx = GetTimer(id);\n"
"			var Pos = AggregateHistorySize-1;\n"
"			var T = TimerArray[idx];\n"
"\n"
"			T.max = FD.TimeMax[Pos];\n"
"			T.total = FD.TimeTotal[Pos];\n"
"			T.excltotal = FD.TimeExclTotal[Pos];\n"
"			T.min = FD.TimeMin[Pos];\n"
"			T.spike = (T.average == 0 || T.max == 0) ? 0 : (100*T.max/T.average);\n"
"			T.callaverage = FD.TimeCallAvg[Pos];\n"
"			T.callcount = FD.CallCount[Pos];\n"
"			T.callexclaverage = FD.TimeCallExclAvg[Pos];\n"
"			T.exclaverage = FD.TimeExclAvg[Pos];\n"
"			T.exclmax = FD.TimeExclMax[Pos];\n"
"			T.exclmin = FD.TimeExclMin[Pos];\n"
"			T.average = FD.TimeAvg[Pos];\n"
"		};\n"
"		function SetTimersInArray(FD, id)\n"
"		{\n"
"			var idx = GetTimer(id);\n"
"			var Pos = FD.Time.length-1;\n"
"			var T = TimerArray[idx];\n"
"			T.time = FD.Time[Pos];\n"
"			T.excl = FD.TimeExcl[Pos];\n"
"			T.count = FD.Count[Pos];\n"
"\n"
"		};\n"
"		let UpdateFrameDataInternal = function(id, Time, TimeExcl, Count, bIsGroup)\n"
"		{\n"
"			let FD = GetFrameData(id);\n"
"			if(!IsFrozen)\n"
"			{\n"
"				FD.PercentileMax = Math.max(FD.PercentileMax, Time);\n"
"				FD.PercentileMin = Math.min(FD.PercentileMin, Time);\n"
"				FD.Percentile.push(Time);\n"
"				FD.Percentile.sort(function(a, b){ return a - b; });\n"
"			}\n"
"			PushIntoArray(FD.Time, Time);\n"
"			PushIntoArray(FD.TimeExcl, TimeExcl);\n"
"			PushIntoArray(FD.Count, Count);\n"
"			FD.historymax = FindMaxTime(FD.Time, bIsGroup);\n"
"\n"
"			if((FD.Aggregate > Settings.AggregateFrames && Settings.AggregateFrames > 0) || AggregateCurrent == 0)\n"
"			{\n"
"				SetAggregateTimersInArray(FD, id);\n"
"				FD.Aggregate = 0;\n"
"				FD.AggregateSum = 0;\n"
"				FD.AggregateMax = 0;\n"
"				FD.AggregateMin = C_HUGE;\n"
"				FD.AggregateExclSum = 0;\n"
"				FD.AggregateExclMax = 0;\n"
"				FD.AggregateExclMin = C_HUGE;\n"
"				FD.AggregateCount = 0;\n"
"				\n"
"				FD.TimeMax.shift();\n"
"				FD.TimeMax.push(0);\n"
"				\n"
"				FD.TimeMin.shift();\n"
"				FD.TimeMin.push(0);\n"
"\n"
"				FD.TimeAvg.shift();\n"
"				FD.TimeAvg.push(0);\n"
"				\n"
"				FD.TimeCallAvg.shift();\n"
"				FD.TimeCallAvg.push(0);\n"
"				\n"
"				FD.TimeCallExclAvg.shift();\n"
"				FD.TimeCallExclAvg.push(0);\n"
"\n"
"				FD.CallCount.shift();\n"
"				FD.CallCount.push(0);\n"
"\n"
"				FD.TimeTotal.shift();\n"
"				FD.TimeTotal.push(0);\n"
"\n"
"				FD.TimeExclTotal.shift();\n"
"				FD.TimeExclTotal.push(0);\n"
"\n"
"				FD.TimeExclMax.shift();\n"
"				FD.TimeExclMax.push(0);\n"
"\n"
"				FD.TimeExclMin.shift();\n"
"				FD.TimeExclMin.push(0);\n"
"\n"
"				FD.TimeExclAvg.shift();\n"
"				FD.TimeExclAvg.push(0);\n"
"			}\n"
"\n"
"			FD.Aggregate += 1;\n"
"			FD.AggregateSum += Time;\n"
"			FD.AggregateMax = FD.AggregateMax > Time ? FD.AggregateMax : Time;\n"
"			FD.AggregateMin = FD.AggregateMin < Time ? FD.AggregateMin : Time;\n"
"			FD.AggregateExclSum += TimeExcl;\n"
"			FD.AggregateExclMax = FD.AggregateExclMax > TimeExcl ? FD.AggregateExclMax : TimeExcl;\n"
"			FD.AggregateExclMin = FD.AggregateExclMin < TimeExcl ? FD.AggregateExclMin : TimeExcl;\n"
"			FD.AggregateCount += Count;\n"
"			var UpdatePos = AggregateHistorySize-1;\n"
"			if(UpdatePos != FD.TimeMax.length - 1)\n"
"			{\n"
"				debugger;\n"
"			}\n"
"\n"
"			FD.TimeMax[UpdatePos] = FD.AggregateMax;\n"
"			FD.TimeMin[UpdatePos] = FD.AggregateMin;\n"
"			FD.TimeAvg[UpdatePos] = FD.AggregateSum / FD.Aggregate;\n"
"			FD.TimeCallAvg[UpdatePos] = FD.AggregateCount ? FD.AggregateSum / FD.AggregateCount : 0;\n"
"			FD.TimeCallExclAvg[UpdatePos] = FD.AggregateCount ? FD.AggregateExclSum / FD.AggregateCount : 0;\n"
"			FD.TimeTotal[UpdatePos] = FD.AggregateSum;\n"
"			FD.TimeExclTotal[UpdatePos] = FD.AggregateExclSum;\n"
"			FD.CallCount[UpdatePos] = FD.AggregateCount;\n"
"			FD.TimeExclAvg[UpdatePos] = FD.Aggregate ? FD.AggregateExclSum / FD.Aggregate : 0;\n"
"			FD.TimeExclMax[UpdatePos] = FD.AggregateExclMax;\n"
"			FD.TimeExclMin[UpdatePos] = FD.AggregateExclMin;\n"
"\n"
"			if(Settings.AggregateFrames <= 0)\n"
"			{\n"
"				SetAggregateTimersInArray(FD, id);\n"
"			}\n"
"			SetTimersInArray(FD, id);			\n"
"		};\n"
"\n"
"		for(var id in F.x)\n"
"		{\n"
"			var Data = F.x[id];\n"
"			var Time = Data[0];\n"
"			var TimeExcl = Data[1];\n"
"			var Count = Data[2];\n"
"			UpdateFrameDataInternal(id, Data[0], Data[1], Data[2]);\n"
"		}\n"
"\n"
"		var groups = {};\n"
"		for(var i = 0; i < F.g.length; ++i)\n"
"		{\n"
"			var id = F.gi[i];\n"
"			groups[id] = 1;\n"
"			var t = F.g[i];\n"
"			UpdateFrameDataInternal(id, t[0], t[1], t[2], 1);\n"
"		}\n"
"		\n"
"		let UpdateThreadInfo = function(o)\n"
"		{\n"
"			let sn = SanitizeString(o.n);\n"
"			let TI = ThreadInfo[sn];\n"
"			if(!TI)\n"
"			{\n"
"				TI = { ids:o.gi, a:[], n:o.n, sn:sn };\n"
"				for(let i = 0; i < TI.ids.length; ++i)\n"
"				{\n"
"					TI.a.push(AllocClearedArray(FRAME_COUNT));\n"
"				}\n"
"				ThreadInfo[sn] = TI;\n"
"			}\n"
"			for(let i = 0; i < o.gi.length; ++i)\n"
"			{\n"
"				let id = o.gi[i];\n"
"				let t = o.g[i][1];\n"
"				let te = FrameData.Time[FrameData.Time.length-1];\n"
"				if(t > te)\n"
"				{\n"
"					console.log(\"fail!\");\n"
"					// debugger;\n"
"				}\n"
"				let idx = TI.ids.indexOf(id);\n"
"				if(-1 == idx)\n"
"				{\n"
"					TI.ids.push(id);\n"
"					let a = AllocClearedArray(FRAME_COUNT);\n"
"					a[a.length-1] = o.g[i][1];\n"
"					TI.a.push(a);\n"
"				}\n"
"				else\n"
"				{\n"
"					let l = TI.a[idx].length;\n"
"					TI.a[idx][l-1] = o.g[i][1];\n"
"				}\n"
"			}\n"
"		};\n"
"		if(F.gt && F.gt.length)\n"
"		{\n"
"			for(let key in ThreadInfo)\n"
"			{\n"
"				let TI = ThreadInfo[key];\n"
"				for(let i = 0; i < TI.a.length; ++i)\n"
"				{\n"
"					PushIntoArray(TI.a[i], 0);\n"
"				}\n"
"			}\n"
"\n"
"\n"
"			for(let i = 0; i < F.gt.length; ++i)\n"
"			{\n"
"				let o = F.gt[i];\n"
"				UpdateThreadInfo(o);\n"
"			}\n"
"		}\n"
"\n"
"\n"
"\n"
"		var ToDelete = new Array();\n"
"		for(var id in FrameData.TimerMap)\n"
"		{\n"
"			let FD = FrameData.TimerMap[id];\n"
"			if(!F.x[id] && !groups[id])\n"
"			{\n"
"				PushIntoArray(FD.Time,0.0);\n"
"				PushIntoArray(FD.TimeExcl, 0.0);\n"
"				PushIntoArray(FD.Count, 0);\n"
"				FindMaxTime(FD.Time);\n"
"				FD.EmptyFrames++;\n"
"			}\n"
"			else\n"
"			{\n"
"				FD.EmptyFrames = 0;\n"
"			}\n"
"			FD.FrameTime = FD.Time[FD.Time.length-1]; //Fix her..?\n"
"			FD.AggregateTime = FD.Time[FD.Time.length-1];\n"
"\n"
"			if(FD.EmptyFrames == FD.Time.length)\n"
"			{\n"
"				ToDelete.push(id);\n"
"			}\n"
"		}\n"
"		for(var i = 0; i < ToDelete.length; ++i)\n"
"		{\n"
"			delete FrameData.TimerMap[ToDelete[i]];\n"
"		}\n"
"		FramePending++;\n"
"\n"
"\n"
"		if(TriggerAutoCapture)\n"
"		{\n"
"			Capture();\n"
"		}\n"
"		ReferenceGraphAutomaticGroup = 1.05 * GraphTimeGroupMax;\n"
"		ReferenceGraphAutomatic = 1.05 * GraphTimeMax;\n"
"		ReferenceHistoryAutomatic = 1.05 * HistoryTimeMax;\n"
"	}\n"
"	RequestDraw();\n"
"}\n"
"\n"
"function WSMessage(event)\n"
"{\n"
"	// console.log(event.data);\n"
"	var Obj = JSON.parse(event.data);\n"
"	WSReceive++;\n"
"	WSReceiveBytes += event.data.length;\n"
"	var k = Obj.k;\n"
"	if(k == MSG_TIMER_TREE)\n"
"	{\n"
"		AddTimer(Obj.v);\n"
"	}\n"
"	else if(k == MSG_ENABLED)\n"
"	{\n"
"		EnableTimer(Obj.v);\n"
"	}\n"
"	else if(k == MSG_FRAME)\n"
"	{\n"
"		ProcessFrame(Obj.v);\n"
"	}\n"
"	else if(k == MSG_LOADSETTINGS)\n"
"	{\n"
"		OnLoadPreset(Obj.v, 1, Obj.ro);\n"
"	}\n"
"	else if(k == MSG_CURRENTSETTINGS)\n"
"	{\n"
"		OnLoadPreset(Obj.v, 0, Obj.ro);\n"
"	}\n"
"	else if(k == MSG_PRESETS)\n"
"	{\n"
"		AddPresets(Obj.v);\n"
"	}\n"
"	else if(k == MSG_COUNTERS)\n"
"	{\n"
"		ProcessCounters(Obj.v);\n"
"	}\n"
"	else if(k == MSG_FUNCTION_RESULTS)\n"
"	{\n"
"		FunctionQueryPending = null;\n"
"		if(FunctionQueryReceived< Obj.q)\n"
"		{\n"
"			FunctionQueryArray = Obj.v;\n"
"			FunctionQueryReceived = Obj.q;\n"
"			console.log(\'got result from query \' + Obj.q);\n"
"		}\n"
"		else\n"
"		{\n"
"			console.log(\'ignored result from query \' + Obj.q);\n"
"		}\n"
"\n"
"\n"
"	}\n"
"	else if(k == MSG_INACTIVE_FRAME)\n"
"	{\n"
"		ProcessFrame(Obj.v, 1);\n"
"	}\n"
"	else if(k == MSG_FUNCTION_NAMES)\n"
"	{\n"
"		for(var i = 0; i < Obj.v.length; ++i)\n"
"		{\n"
"			FunctionsInstrumented.push(Obj.v[i][0]);\n"
"			FunctionsInstrumentedModule.push(Obj.v[i][1]);\n"
"			FunctionsInstrumentedUnmangled.push(Obj.v[i][2]);\n"
"\n"
"		}\n"
"	}\n"
"	else if(k == MSG_INSTRUMENT_ERROR)\n"
"	{\n"
"		var D = Obj.v.data;\n"
"		var F = Obj.v.functions;\n"
"		var ASM_SERVER = \"http://microprofileasm.zapto.org\"; \n"
"		var url = ASM_SERVER + \"/add/\" + Obj.v.version + \"/\";\n"
"		console.log(JSON.stringify(D));\n"
"		console.log(JSON.stringify(F));\n"
"		for(var i = 0; i < D.length; ++i)\n"
"		{\n"
"			url = url + D[i].code + \"/\";\n"
"		}\n"
"		var s = \"Failed to instrument the following functions:\\n\";\n"
"\n"
"		for(var i = 0; i < F.length; ++i)\n"
"		{\n"
"			s = s + F[i] + \"\\n\";\n"
"		}\n"
"		s = s + \"\\n\\nPlease click \\\"OK\\\"to report the failed code segments\\n\"\n"
"		s = s + \"this will open the following url in a hidden frame\\n\"\n"
"		s = s + url;\n"
"		s = s + \"\\n-No additional data will be sent\\n-No symbol names will be sent\";\n"
"		s = s + \"\\n[this popup can be auto-denied or auto-accepted from the settings menu]\";\n"
"		if(Cookie.CodeReportMode != 2)\n"
"		{\n"
"			if(Cookie.CodeReportMode == 1 || confirm(s))\n"
"			{\n"
"				var iframe = document.createElement(\"iframe\");\n"
"				iframe.onload = function(){document.body.removeChild(iframe); console.log(\"removed iframe\");};\n"
"				console.log(\"opening url \" + url);\n"
"				iframe.setAttribute(\"src\", url);\n"
"				iframe.style.width = \"100x\";\n"
"				iframe.style.height = \"100px\";\n"
"				document.body.appendChild(iframe);\n"
"			}\n"
"		}\n"
"		console.log(\"got error \"+ JSON.stringify(Obj.v));\n"
"	}\n"
"	// else if(k == MSG_MODULE_NAME)\n"
"	// {\n"
"	// 	console.log(\"MODULENAME..\\n\");\n"
"	// 	console.log(JSON.stringify(Obj.v));\n"
"	// 	ModuleState = Obj.v;\n"
"\n"
"	// }\n"
"	else\n"
"	{\n"
"		console.log(\'hest!\');\n"
"	}\n"
"\n"
"}\n"
"function WSError(event)\n"
"{\n"
"	console.log(\'WSError\');\n"
"}\n"
"function WSClose(event)\n"
"{\n"
"	console.log(\'WSClose\');\n"
"	WSIsOpen = 0;\n"
"	window.document.title = \"MicroProfile Live\";\n"
"	FilterInputDiv.style[\'display\'] = \'none\';\n"
"}\n"
"function WSSendMessage(msgid)\n"
"{\n"
"	if(WSIsOpen)\n"
"	{\n"
"		var str = \'\' + msgid;\n"
"		WSSend++;\n"
"		WSSendBytes += str.length;\n"
"		WS.send(str);\n"
"	}\n"
"	else\n"
"	{\n"
"		if(msgid[0] == \'c\')\n"
"		{\n"
"			console.log(\'failing to send \' + msgid);\n"
"		}\n"
"	}\n"
"}\n"
"\n"
"\n"
"function Connect()\n"
"{\n"
"	if(WS && (WS.readyState == 1 || WS.readyState == 0))\n"
"	{\n"
"		WSConnected = WS.readyState == 1;\n"
"		WSFail = 0;\n"
"		WSSeconds = 0;\n"
"	}\n"
"	else\n"
"	{\n"
"		WSConnected = 0;\n"
"		WSSeconds = (new Date() - WSOpenTime);\n"
"		if(!WS || WSSeconds > 2000)\n"
"		{\n"
"			if(WS)\n"
"			{\n"
"				WS.close();\n"
"				WS = null;\n"
"			}\n"
"			WSOpenTime = new Date();\n"
"			WSPath = \"ws://\" + WSHost + \":\" + WSPort + \"/ws\";\n"
"			SetMessage(\'Connecting to \' + WSPath,5 * 1000, 1);\n"
"			WS = new WebSocket(WSPath);\n"
"			WS.onopen = WSOpen;\n"
"			WS.onmessage = WSMessage;\n"
"			WS.onerror = WSError;\n"
"			WS.onclose = WSClose;\n"
"			WSFail = 0;\n"
"		}\n"
"		else\n"
"		{\n"
"			WSFail++;\n"
"		}\n"
"	}\n"
"	RequestDraw();\n"
"}\n"
"\n"
"\n"
"function MouseDragPan()\n"
"{\n"
"	return MouseDragButton == 1 || MouseDragKeyShift;\n"
"}\n"
"function MouseDragSelectRange()\n"
"{\n"
"	return MouseDragState == MouseDragMove && (MouseDragButton == 3 || (MouseDragKeyShift&&MouseDragKeyCtrl));\n"
"}\n"
"\n"
"function MouseHandleDrag()\n"
"{\n"
"	if(MouseDragTarget == CanvasDetailedView)\n"
"	{\n"
"		if(SubMenuActive == -1)\n"
"		{\n"
"			if(MouseDragSelectRange() && SubMenuActive == -1)\n"
"			{\n"
"				var xStart = MouseDragXStart;\n"
"				var xEnd = MouseDragX;\n"
"				if(xStart > xEnd)\n"
"				{\n"
"					var Temp = xStart;\n"
"					xStart = xEnd;\n"
"					xEnd = Temp;\n"
"				}\n"
"				if(xEnd - xStart > 1)\n"
"				{\n"
"					MouseDragActiveXStart = xStart;\n"
"					MouseDragActiveXEnd = xEnd;\n"
"				}\n"
"			}\n"
"			else if(MouseDragPan())\n"
"			{\n"
"				var X = MouseDragX - MouseDragXLast;\n"
"				var Y = MouseDragY - MouseDragYLast;\n"
"				if(X && MouseDragActiveXStart < MouseDragActiveXEnd)\n"
"				{\n"
"					MouseDragActiveXStart += X;\n"
"					MouseDragActiveXEnd += X;\n"
"				}\n"
"			}\n"
"			if(Settings.ViewActive == VIEW_BAR)\n"
"			{\n"
"				if(MouseDragKeyShift || MouseDragButton == 1)\n"
"				{\n"
"					var X = MouseDragX - MouseDragXLast;\n"
"					var Y = MouseDragY - MouseDragYLast;\n"
"					nOffsetBarsY -= Y;\n"
"					nOffsetBarsX -= X;\n"
"					if(nOffsetBarsY < 0)\n"
"					{\n"
"						nOffsetBarsY = 0;\n"
"					}\n"
"					if(nOffsetBarsX < 0)\n"
"					{\n"
"						nOffsetBarsX = 0;\n"
"					}\n"
"				}\n"
"			}\n"
"			if(Settings.ViewActive == VIEW_COUNTERS)\n"
"			{\n"
"				if(MouseDragKeyShift || MouseDragButton == 1)\n"
"				{\n"
"					var Y = MouseDragY - MouseDragYLast;\n"
"					nOffsetCountersY -= Y;\n"
"					if(nOffsetCountersY < 0)\n"
"					{\n"
"						nOffsetCountersY = 0;\n"
"					}\n"
"				}\n"
"			}\n"
"		}\n"
"		else if(SubMenuActive == SubMenuTimers || SubMenuActive == SubMenuGroup || SubMenuActive == SubMenuFunctions)\n"
"		{\n"
"			if(MouseDragKeyShift || MouseDragButton == 1)\n"
"			{\n"
"				var Y = MouseDragY - MouseDragYLast;\n"
"				if(SubMenuActive == SubMenuTimers)\n"
"				{\n"
"					nOffsetMenuTimers -= Y;\n"
"					if(nOffsetMenuTimers < 0)\n"
"					{\n"
"						nOffsetMenuTimers = 0;\n"
"					}\n"
"				}\n"
"				else if(SubMenuActive == SubMenuFunctions)\n"
"				{\n"
"					nOffsetMenuFunctions -= Y;\n"
"					if(nOffsetMenuFunctions < 0)\n"
"					{\n"
"						nOffsetMenuFunctions = 0;\n"
"					}\n"
"				}\n"
"				else\n"
"				{\n"
"					nOffsetMenuGroup -= Y;\n"
"					if(nOffsetMenuGroup < 0)\n"
"					{\n"
"						nOffsetMenuGroup = 0;\n"
"					}\n"
"				}\n"
"			}\n"
"		}\n"
"	}\n"
"	MouseDragXLast = MouseDragX;\n"
"	MouseDragYLast = MouseDragY;	\n"
"}\n"
"function MouseHandleDragEnd()\n"
"{\n"
"	if(MouseDragTarget == CanvasDetailedView)\n"
"	{\n"
"\n"
"	}\n"
"}\n"
"\n"
"function MouseHandleDragClick()\n"
"{\n"
"	if(SubMenuActive == -1)\n"
"	{	\n"
"		if(nHoverCounter != -1)\n"
"		{\n"
"			if(TimerArray[nHoverCounter].firstchild != -1)\n"
"			{\n"
"				TimerArray[nHoverCounter].closed = !TimerArray[nHoverCounter].closed;\n"
"			}\n"
"			else\n"
"			{\n"
"				TimerArray[nHoverCounter].Expanded = !TimerArray[nHoverCounter].Expanded;\n"
"			}\n"
"			Draw(1);\n"
"		}\n"
"	}\n"
"	if(MouseInCaptureButton)\n"
"	{\n"
"		TriggerCapture();\n"
"	}\n"
"}\n"
"\n"
"function MapMouseButton(event)\n"
"{\n"
"	if(event.button == 1 || event.which == 1)\n"
"	{\n"
"		return 1;\n"
"	}\n"
"	else if(event.button == 3 || event.which == 3)\n"
"	{\n"
"		return 3;\n"
"	}\n"
"	else\n"
"	{\n"
"		return 0;\n"
"	}\n"
"}\n"
"\n"
"function MouseDragReset()\n"
"{\n"
"	MouseDragState = MouseDragOff;\n"
"	MouseDragTarget = 0;\n"
"	MouseDragKeyShift = 0;\n"
"	MouseDragKeyCtrl = 0;\n"
"	MouseDragButton = 0;\n"
"}\n"
"function MouseDragKeyUp()\n"
"{\n"
"	if((MouseDragKeyShift && !KeyShiftDown) || (MouseDragKeyCtrl && !KeyCtrlDown))\n"
"	{\n"
"		MouseHandleDragEnd();\n"
"		MouseDragReset();\n"
"	}\n"
"}\n"
"function MouseDrag(Source, Event)\n"
"{\n"
"	if(Source == MouseDragOff || (MouseDragTarget && MouseDragTarget != Event.target))\n"
"	{\n"
"		MouseDragReset();\n"
"		return;\n"
"	}\n"
"\n"
"	var LocalRect = Event.target.getBoundingClientRect();\n"
"	MouseDragX = Event.clientX - LocalRect.left;\n"
"	MouseDragY = Event.clientY - LocalRect.top;\n"
"	if(MouseDragState == MouseDragMove)\n"
"	{\n"
"		var dx = Math.abs(MouseDragX - MouseDragXStart);\n"
"		var dy = Math.abs(MouseDragY - MouseDragYStart);\n"
"		if((Source == MouseDragUp && MapMouseButton(Event) == MouseDragButton) ||\n"
"			(MouseDragKeyCtrl && !KeyCtrlDown) ||\n"
"			(MouseDragKeyShift && !KeyShiftDown))\n"
"		{\n"
"			MouseHandleDragEnd();\n"
"			MouseDragReset();\n"
"			return;\n"
"		}\n"
"		else\n"
"		{\n"
"			MouseHandleDrag();\n"
"		}\n"
"	}\n"
"	else if(MouseDragState == MouseDragOff)\n"
"	{\n"
"		if(Source == MouseDragDown || KeyShiftDown || KeyCtrlDown)\n"
"		{\n"
"			MouseDragTarget = Event.target;\n"
"			MouseDragButton = MapMouseButton(Event);\n"
"			MouseDragState = MouseDragDown;\n"
"			MouseDragXStart = MouseDragX;\n"
"			MouseDragYStart = MouseDragY;\n"
"			MouseDragKeyCtrl = 0;\n"
"			MouseDragKeyShift = 0;\n"
"\n"
"			if(KeyShiftDown || KeyCtrlDown)\n"
"			{\n"
"				MouseDragKeyShift = KeyShiftDown;\n"
"				MouseDragKeyCtrl = KeyCtrlDown;\n"
"				MouseDragState = MouseDragMove;\n"
"			}\n"
"		}\n"
"	}\n"
"	else if(MouseDragState == MouseDragDown)\n"
"	{\n"
"		if(Source == MouseDragUp)\n"
"		{\n"
"			MouseHandleDragClick();\n"
"			MouseDragReset();\n"
"		}\n"
"		else if(Source == MouseDragMove)\n"
"		{\n"
"			var dx = Math.abs(MouseDragX - MouseDragXStart);\n"
"			var dy = Math.abs(MouseDragY - MouseDragYStart);\n"
"			if(dx+dy>1)\n"
"			{\n"
"				MouseDragState = MouseDragMove;\n"
"			}\n"
"		}\n"
"	}\n"
"	MouseDragXLast = MouseDragX;\n"
"	MouseDragYLast = MouseDragY;\n"
"}\n"
"\n"
"\n"
"function MouseMove(evt)\n"
"{\n"
"    evt.preventDefault();\n"
"	var rect = evt.target.getBoundingClientRect();\n"
"	var x = evt.clientX - rect.left;\n"
"	var y = evt.clientY - rect.top;\n"
"	MouseX = x;\n"
"	MouseY = y;\n"
"	MouseMoveTime = new Date();\n"
"    MouseDrag(MouseDragMove, evt);\n"
"    RequestDraw();\n"
"}\n"
"\n"
"\n"
"function MouseSortClick()\n"
"{\n"
"	if(SubMenuActive == -1)\n"
"	{\n"
"		if(SortColumnMouseOverNext)\n"
"		{\n"
"			if(SortColumnMouseOverNext == Settings.SortColumnName)\n"
"			{\n"
"				Settings.SortColumnOrderFlip =  1 - Settings.SortColumnOrderFlip;\n"
"			}\n"
"			else\n"
"			{\n"
"				Settings.SortColumnOrderFlip = 0;\n"
"			}\n"
"\n"
"			Settings.SortColumnName = SortColumnMouseOverNext;\n"
"			SortColumnMouseOverNext = null;\n"
"		}\n"
"	}\n"
"}\n"
"\n"
"\n"
"function MouseButton(bPressed, evt)\n"
"{\n"
"    evt.preventDefault();\n"
"	MouseReleased = !bPressed;\n"
"	MouseDrag(bPressed ? MouseDragDown : MouseDragUp, evt);\n"
"	if(!bPressed)\n"
"		MouseSortClick();\n"
"    RequestDraw();\n"
"}\n"
"\n"
"function MouseOut(evt)\n"
"{\n"
"	MouseDrag(MouseDragOff, evt);\n"
"	KeyCtrlDown = 0;\n"
"	KeyShiftDown = 0;\n"
"	// MouseDragButton = 0;\n"
"	// nHoverToken = -1;\n"
"	// RangeCpu = RangeInit();\n"
"}\n"
"\n"
"function MouseWheel(e)\n"
"{\n"
"//     var e = window.event || e;\n"
"//     var delta = (e.wheelDelta || e.detail * (-120));\n"
"//     ZoomGraph((-4 * delta / 120.0) | 0);\n"
"//     Draw(1);\n"
"}\n"
"\n"
"function KeyUp(evt)\n"
"{\n"
"	var k = evt.keyCode;\n"
"	var InputActive = SubMenuActive == SubMenuTimers || SubMenuActive == SubMenuGroup || SubMenuActive == SubMenuFunctions || SubMenuActive == SubMenuPatched || SubMenuActive == SubMenuModules;\n"
"	if(!InputActive)\n"
"	{\n"
"		if(k == 220)\n"
"		{\n"
"			ProfileMode = !ProfileMode;\n"
"		}\n"
"		if(k == 191)\n"
"		{\n"
"			WSPort++;\n"
"			if(WSPort > 1338+2)\n"
"			{\n"
"				WSPort = 1338;\n"
"			}\n"
"			if(WS)\n"
"			{\n"
"				WS.close();\n"
"				WS = null;\n"
"			}\n"
"		}\n"
"		if(k == 32)\n"
"		{\n"
"			if(0) //for debugging.\n"
"			{\n"
"				console.log(\"FrameData =\");\n"
"				console.log(JSON.stringify(FrameData));\n"
"				console.log(\"TimerArray =\");\n"
"				console.log(JSON.stringify(TimerArray));\n"
"			}\n"
"			WSSendMessage(\"f\");\n"
"		}\n"
"		if(k == 88)\n"
"		{\n"
"			ToggleView();\n"
"		}\n"
"		if(k == 13)\n"
"		{\n"
"			TriggerCapture();\n"
"		}\n"
"		if(k == 72)\n"
"		{\n"
"			ShowHelp(0, 1);\n"
"		}\n"
"\n"
"\n"
"	}\n"
"	if(k == 27)\n"
"	{\n"
"		if(FilterInput.value.trim() != \"\")\n"
"		{\n"
"			FilterInput.value = \"\";\n"
"		}\n"
"		else\n"
"		{\n"
"			EnableMenu(-1);\n"
"		}\n"
"\n"
"		MouseDragActiveXStart = MouseDragActiveXEnd = -1;\n"
"		Settings.SortColumnName = \"\";\n"
"		ShowHelp(0);\n"
"	}\n"
"	if(k == 192)\n"
"	{\n"
"		Settings.ViewCompressed = Settings.ViewCompressed ? 0 : 1;\n"
"		ResizeCanvas();\n"
"	}\n"
"\n"
"	if(evt.keyCode == 17)\n"
"	{\n"
"		KeyCtrlDown = 0;\n"
"		MouseDragKeyUp();\n"
"	}\n"
"	if(evt.keyCode == 16)\n"
"	{\n"
"		KeyShiftDown = 0;\n"
"		MouseDragKeyUp();\n"
"	}\n"
"}\n"
"\n"
"function KeyDown(evt)\n"
"{\n"
"	// console.log(\"keydow \", k);\n"
"	if(evt.keyCode == 17)\n"
"	{\n"
"		KeyCtrlDown = 1;\n"
"		MouseDragKeyUp();\n"
"	}\n"
"	if(evt.keyCode == 16)\n"
"	{\n"
"		KeyShiftDown = 1;\n"
"		MouseDragKeyUp();\n"
"	}\n"
"}\n"
"\n"
"\n"
"function SetupEvents()\n"
"{\n"
"	var mousewheelevt = (/Firefox/i.test(navigator.userAgent)) ? \"DOMMouseScroll\" : \"mousewheel\"; //FF doesn\'t recognize mousewheel as of \n"
"	CanvasDetailedView.addEventListener(\'mousemove\', MouseMove, false);\n"
"	CanvasDetailedView.addEventListener(\'mousedown\', function(evt) { MouseButton(true, evt); });\n"
"	CanvasDetailedView.addEventListener(\'mouseup\', function(evt) { MouseButton(false, evt); } );\n"
"	CanvasDetailedView.addEventListener(\'mouseout\', MouseOut);\n"
"	CanvasDetailedView.addEventListener(\"contextmenu\", function (e) { e.preventDefault(); }, false);\n"
"	CanvasDetailedView.addEventListener(mousewheelevt, MouseWheel, false);\n"
"	window.addEventListener(\'keydown\', KeyDown);\n"
"	window.addEventListener(\'keyup\', KeyUp);\n"
"	window.addEventListener(\'resize\', ResizeCanvas, false);\n"
"}\n"
"\n"
"function DrawToolTip(StringArray, Canvas, x, y)\n"
"{\n"
"	if(!ShowMenu())\n"
"	{\n"
"		return;\n"
"	}\n"
"	let colors;\n"
"	let a = StringArray;\n"
"	if(StringArray.c)\n"
"	{\n"
"		a = StringArray.a;\n"
"		colors = StringArray.c;\n"
"	}\n"
"	var context = Canvas.getContext(\'2d\');\n"
"	context.font = Font;\n"
"	var WidthArray = Array(a.length);\n"
"	var nMaxWidth = 0;\n"
"	var nHeight = 0;\n"
"	for(var i = 0; i < a.length; i += 2)\n"
"	{\n"
"		var nWidth0 = context.measureText(a[i]).width;\n"
"		var nWidth1 = context.measureText(a[i+1]).width;\n"
"		var nSum = nWidth0 + nWidth1;\n"
"		WidthArray[i] = nWidth0;\n"
"		WidthArray[i+1] = nWidth1;\n"
"		if(nSum > nMaxWidth)\n"
"		{\n"
"			nMaxWidth = nSum;\n"
"		}\n"
"		nHeight += BoxHeight;\n"
"	}\n"
"	nMaxWidth += 15;\n"
"	//bounds check.\n"
"	x = Math.max(0, x - 10 - nMaxWidth);\n"
"	var CanvasRect = Canvas.getBoundingClientRect();\n"
"	if(y + nHeight > CanvasRect.height)\n"
"	{\n"
"		y = CanvasRect.height - nHeight;\n"
"		x += 20;\n"
"	}\n"
"	if(x + nMaxWidth > CanvasRect.width)\n"
"	{\n"
"		x = CanvasRect.width - nMaxWidth;\n"
"	}\n"
"\n"
"	context.fillStyle = \'black\';\n"
"	context.fillRect(x-1, y, nMaxWidth+2, nHeight);\n"
"	context.fillStyle = \'white";

const size_t g_MicroProfileHtmlLive_begin_4_size = sizeof(g_MicroProfileHtmlLive_begin_4);
const char g_MicroProfileHtmlLive_begin_5[] =
"\';\n"
"\n"
"	var XPos = x;\n"
"	var XPosRight = x + nMaxWidth;\n"
"	var YPos = y + BoxHeight-2;\n"
"	context.fillStyle = \'white\';\n"
"	for(i = 0; i < a.length; i += 2)\n"
"	{\n"
"		if(colors)\n"
"			context.fillStyle = colors[i];\n"
"		context.fillText(a[i], XPos, YPos);\n"
"		if(colors)\n"
"			context.fillStyle = colors[i+1];\n"
"		context.fillText(a[i+1], XPosRight - WidthArray[i+1], YPos);\n"
"		YPos += BoxHeight;\n"
"	}\n"
"	context.fillStyle = \'white\';\n"
"}\n"
"\n"
"function DrawPlotf(Canvas)\n"
"{\n"
"	return;\n"
"	var context = Canvas.getContext(\'2d\');\n"
"	context.font = Font;\n"
"	var WidthArray = Array(PlotfArray.length);\n"
"	var nMaxWidth = 0;\n"
"	var nHeight = 0;\n"
"\n"
"	context.font = Font;\n"
"	for(i = 0; i < PlotfArray.length; i++)\n"
"	{\n"
"		var nWidth = context.measureText(PlotfArray[i]).width;\n"
"		WidthArray[i] = nWidth;\n"
"		if(nWidth > nMaxWidth)\n"
"		{\n"
"			nMaxWidth = nWidth;\n"
"		}\n"
"		nHeight += BoxHeight;\n"
"	}\n"
"	nMaxWidth += 15;\n"
"	var x = 0;\n"
"	var y = 0;\n"
"\n"
"	context.fillStyle = \'black\';\n"
"	context.fillRect(x-1, y, nMaxWidth+2, nHeight);\n"
"	context.fillStyle = \'white\';\n"
"\n"
"	var XPos = x;\n"
"	var XPosRight = x + nMaxWidth;\n"
"	var YPos = y + BoxHeight-2;\n"
"	for(i = 0; i < PlotfArray.length; i++)\n"
"	{\n"
"		context.fillText(PlotfArray[i], XPos, YPos);\n"
"		YPos += BoxHeight;\n"
"	}\n"
"}\n"
"\n"
"\n"
"function ShiftRight10(v)\n"
"{\n"
"	if(v > 1024)\n"
"	{\n"
"		return v / 1024.0;\n"
"	}\n"
"	else\n"
"	{\n"
"		return v >> 10;\n"
"	}\n"
"}\n"
"\n"
"function FormatCounter(Format, Counter)\n"
"{\n"
"	if(!Counter)\n"
"	{\n"
"		return \'0\';\n"
"	}\n"
"	var Negative = 0;\n"
"	if(Counter < 0)\n"
"	{\n"
"		Counter = -Counter;\n"
"		Negative = 1;\n"
"		if(Counter < 0) // handle INT_MIN\n"
"		{\n"
"			Counter = -(Counter+1);\n"
"			if(Counter < 0)\n"
"			{\n"
"				return \'?\';\n"
"			}\n"
"		}\n"
"	}\n"
"	var str = Negative ? \'-\' :\'\' ;\n"
"	if(Format == FormatCounterDefault)\n"
"	{\n"
"		var Seperate = 0;\n"
"		var result = \'\';\n"
"		while (Counter)\n"
"		{\n"
"			if (Seperate)\n"
"			{\n"
"				result += \'.\';\n"
"			}\n"
"			Seperate = 1;\n"
"			for (var i = 0; Counter && i < 3; ++i)\n"
"			{\n"
"				var Digit = Math.floor(Counter % 10);\n"
"				Counter = Math.floor(Counter / 10);\n"
"				result += \'\' + Digit;\n"
"			}\n"
"		}\n"
"\n"
"		for(var i = 0; i < result.length; ++i)\n"
"		{\n"
"			str += result[result.length-1-i];\n"
"		}\n"
"		return str;\n"
"	}\n"
"	else if(Format == FormatCounterBytes)\n"
"	{\n"
"		var Shift = 0;\n"
"		var Divisor = 1;\n"
"		var CountShifted = ShiftRight10(Counter);\n"
"		while(CountShifted)\n"
"		{\n"
"			Divisor <<= 10;\n"
"			CountShifted = ShiftRight10(CountShifted);\n"
"			Shift++;\n"
"		}\n"
"		if(Shift)\n"
"		{\n"
"			return str + (Counter / Divisor).toFixed(2) + \'\' + FormatCounterBytesExt[Shift];\n"
"		}\n"
"		else\n"
"		{\n"
"			return str + Counter.toFixed(2) + \'\' + FormatCounterBytesExt[0];\n"
"		}\n"
"	}\n"
"	return \'?\';\n"
"}\n"
"function DrawCounterView(View, LocalMouseX, LocalMouseY, SubIndex)\n"
"{\n"
"	var TimerMap = FrameData.TimerMap;\n"
"	if(!TimerMap)\n"
"		return;\n"
"\n"
"\n"
"	ProfileEnter(\"DrawCounterView\");\n"
"\n"
"	var Canvas = View.Canvas[View.BackBuffer];\n"
"	var context = Canvas.getContext(\'2d\');\n"
"	context.clearRect(0, 0, View.w, View.h);\n"
"\n"
"\n"
"\n"
"	var Height = BoxHeight;\n"
"	var Width = nWidth;\n"
"	var nTotalRows = CounterArray.length;\n"
"	var nTotalRowPixels = nTotalRows * Height;\n"
"	var nFrameRows = nHeight - BoxHeight;\n"
"	if(nOffsetCountersY + nFrameRows > nTotalRowPixels && nTotalRowPixels > nFrameRows)\n"
"	{\n"
"		nOffsetCountersY = nTotalRowPixels - nFrameRows;\n"
"	}\n"
"	var CounterWidth = 150;\n"
"	var Y = -nOffsetCountersY + BoxHeight;\n"
"	var X = 0;\n"
"	var nColorIndex = 0;\n"
"	context.fillStyle = \'white\';\n"
"	context.font = Font;\n"
"	var bMouseIn = 0;\n"
"	function DrawHeaderSplitSingle(Header, Width)\n"
"	{\n"
"		context.fillStyle = \'white\';\n"
"		context.fillText(Header, X, Height-FontAscent);\n"
"		X += Width;\n"
"		context.fillStyle = nBackColorOffset;\n"
"		context.fillRect(X-3, 0, 1, nHeight);\n"
"	}\n"
"	function DrawHeaderSplitSingleRight(Header, Width)\n"
"	{\n"
"		X += Width;\n"
"		context.fillStyle = \'white\';\n"
"		context.textAlign  = \'right\';\n"
"		context.fillText(Header, X - FontWidth, Height-FontAscent);\n"
"		context.fillStyle = nBackColorOffset;\n"
"		context.fillRect(X, 0, 1, nHeight);\n"
"		context.textAlign  = \'left\';\n"
"	}\n"
"	var TimerLen = 6;\n"
"	var TimerWidth = TimerLen * FontWidth;\n"
"	nHoverCounter = -1;\n"
"	function CounterIndent(Level)\n"
"	{\n"
"		return Level * 4 * FontWidth;\n"
"	}\n"
"	function Max(a, b)\n"
"	{\n"
"		return a > b ? a : b;\n"
"	}\n"
"\n"
"	function DrawCounterRecursive(Index)\n"
"	{\n"
"		var Counter = TimerArray[Index];\n"
"		if(Counter.idtype == TYPE_COUNTER)\n"
"		{\n"
"			var Indent = CounterIndent(Counter.depth-1);\n"
"			var X = 0;\n"
"			nColorIndex = 1-nColorIndex;\n"
"			var HeightExpanded = Counter.Expanded ? Height * 5 : Height;\n"
"\n"
"			bMouseIn = LocalMouseY >= Y && LocalMouseY < Y + HeightExpanded;\n"
"			if(bMouseIn)\n"
"			{\n"
"				nHoverCounter = Index;\n"
"			}\n"
"			var bgcolor = bMouseIn ? nBackColorOffset : nBackColors[nColorIndex];\n"
"			context.fillStyle = bgcolor;\n"
"			context.fillRect(0, Y, Width, HeightExpanded);\n"
"			context.fillStyle = \'white\';\n"
"			var c = Counter.closed ? \'*\' : \' \';\n"
"			context.fillText(c + Counter.name, Indent, Y+Height-FontAscent);\n"
"			X += CounterNameWidth;\n"
"			X += CounterValueWidth - FontWidth;\n"
"			context.textAlign = \'right\';\n"
"			context.fillText(Counter.formatted, X, Y+Height-FontAscent);\n"
"			context.textAlign = \'left\';\n"
"			X += FontWidth * 4;\n"
"			var Y0 = Y + 1;\n"
"			if(Counter.limit != 0)\n"
"			{\n"
"				context.fillText(Counter.formattedlimit, X, Y+Height-FontAscent);\n"
"				X += CounterLimitWidth;\n"
"				var X0 = X + 1;\n"
"				context.fillStyle = \'white\';\n"
"				context.fillRect(X0, Y0, Counter.boxprc * (CounterWidth-2), Height-2);\n"
"				context.fillStyle = bgcolor;\n"
"				context.fillRect(X0+1, Y0+1, Counter.boxprc * (CounterWidth-4), Height-4);\n"
"				context.fillStyle = \'cyan\';\n"
"				context.fillRect(X0+1, Y0+1, Counter.counterprc * (CounterWidth-4), Height-4);\n"
"				X += CounterWidth + 10;\n"
"			}\n"
"			else\n"
"			{\n"
"				X += CounterLimitWidth;\n"
"				X += CounterWidth + 10;\n"
"			}\n"
"			\n"
"			if(Counter.minvalue != Counter.maxvalue)\n"
"			{\n"
"				var CounterHistory = Counter.counterhistory;\n"
"				var Prc = CounterHistory.prc;\n"
"				context.fillStyle = \'cyan\';\n"
"				context.strokeStyle = \'cyan\';\n"
"				context.globalAlpha = 0.5;\n"
"				context.beginPath();\n"
"				var x = X;\n"
"				var YBase = Y0 + HeightExpanded-1;\n"
"				var YOffset = -(HeightExpanded-2);\n"
"\n"
"				context.moveTo(X, Y0);\n"
"				for(var i = 0; i < Prc.length; ++i)\n"
"				{\n"
"					context.moveTo(x, YBase);\n"
"					context.lineTo(x, YBase + Prc[i] * YOffset);\n"
"					x += 1;\n"
"				}\n"
"				context.stroke();\n"
"\n"
"				x = X;\n"
"				context.globalAlpha = 1.0;\n"
"				context.beginPath();\n"
"				context.moveTo(X, YBase);\n"
"\n"
"				for(var i = 0; i < Prc.length; ++i)\n"
"				{\n"
"					context.lineTo(x, YBase + Prc[i] * YOffset);\n"
"					x += 1;\n"
"				}\n"
"				context.stroke();\n"
"				if(bMouseIn)\n"
"				{\n"
"					var MouseGraphX = Math.floor(LocalMouseX - X);\n"
"					if(MouseGraphX >= 0 && MouseGraphX < CounterHistory.history.length)\n"
"					{\n"
"						context.fillStyle = \'white\';\n"
"						var Formatted = FormatCounter(Counter.format, CounterHistory.history[MouseGraphX]);\n"
"						context.fillText(Formatted, X, Y+Height-FontAscent);\n"
"					}\n"
"					context.strokeStyle = \'orange\';\n"
"					context.beginPath();\n"
"					var CrossX = X + MouseGraphX;\n"
"					var CrossY = YBase + Prc[MouseGraphX] * YOffset;\n"
"					context.moveTo(CrossX-2, CrossY-2);\n"
"					context.lineTo(CrossX+2, CrossY+2);\n"
"					context.moveTo(CrossX+2, CrossY-2);\n"
"					context.lineTo(CrossX-2, CrossY+2);\n"
"					context.stroke();\n"
"\n"
"				}\n"
"				X += Prc.length + 5;\n"
"				context.fillStyle = \'white\';\n"
"				context.fillText( FormatCounter(Counter.format, Counter.minvalue), X, Y + Height - FontAscent);\n"
"				X += CounterWidth + 5;\n"
"				context.fillText( FormatCounter(Counter.format, Counter.maxvalue), X, Y + Height - FontAscent);\n"
"				X += CounterWidth + 5;\n"
"			}\n"
"			Y += HeightExpanded;\n"
"		}\n"
"\n"
"		if(Index == 0 || (!Counter.closed && Counter.idtype == TYPE_COUNTER))\n"
"		{\n"
"			var ChildIndex = Counter.firstchild;\n"
"			while(ChildIndex != -1)\n"
"			{\n"
"				DrawCounterRecursive(ChildIndex);\n"
"				ChildIndex = TimerArray[ChildIndex].sibling;\n"
"			}\n"
"		}\n"
"	}\n"
"\n"
"	DrawCounterRecursive(0);\n"
"\n"
"	X = 0;\n"
"	context.fillStyle = nBackColorOffset;\n"
"	context.fillRect(0, 0, Width, Height);\n"
"	context.fillStyle = \'white\';\n"
"	DrawHeaderSplitSingle(\'Name\', CounterNameWidth);\n"
"	DrawHeaderSplitSingleRight(\'Value\', CounterValueWidth + (FontWidth+1));\n"
"	DrawHeaderSplitSingle(\'Limit\', CounterLimitWidth + CounterWidth + 3 * (FontWidth+1));\n"
"	ProfileLeave();\n"
"}\n"
"\n"
"function ShowHelp(Show, Toggle)\n"
"{\n"
"	var HelpWindow = document.getElementById(\'helpwindow\');\n"
"	if(Toggle)\n"
"	{\n"
"		if(HelpWindow.style[\'display\'] == \'block\')\n"
"		{\n"
"			HelpWindow.style[\'display\'] = \'none\';\n"
"		}\n"
"		else\n"
"		{\n"
"			HelpWindow.style[\'display\'] = \'block\';			\n"
"		}\n"
"	}\n"
"	else\n"
"	{\n"
"		if(Show)\n"
"		{\n"
"			HelpWindow.style[\'display\'] = \'block\';\n"
"		}\n"
"		else\n"
"		{\n"
"			HelpWindow.style[\'display\'] = \'none\';\n"
"		}\n"
"	}\n"
"}\n"
"\n"
"function ParseUrl()\n"
"{\n"
"	var path = window.location.pathname;\n"
"	var idx = path.indexOf(\'/\');\n"
"	if(idx < 0)\n"
"		return;\n"
"	var StrCommand = path.substring(idx+1);\n"
"	idx = StrCommand.indexOf(\'/\');\n"
"	if(idx < 0)\n"
"		return;\n"
"	var StrSettings = StrCommand.substring(idx+1);\n"
"	PresetToLoad = StrSettings;\n"
"	PresetToLoadRO = StrCommand[0] == \'b\';\n"
"}\n"
"\n"
"\n"
"function GetCookie()\n"
"{\n"
"	var result = document.cookie.match(/fisk=([^;]+)/);\n"
"	if(result && result.length > 0)\n"
"	{\n"
"		var Obj = JSON.parse(result[1]);\n"
"		if(!Obj.offline)\n"
"		{\n"
"			var C = {};\n"
"			C.offline = Obj;\n"
"			Obj = C;\n"
"		}\n"
"		return Obj;\n"
"	}\n"
"	else\n"
"	{\n"
"		return {offline:{},live:{}};\n"
"	}\n"
"}\n"
"\n"
"function ReadCookie()\n"
"{\n"
"	var C = GetCookie().live;\n"
"	for(var i in C)\n"
"	{\n"
"		Cookie[i] = C[i];\n"
"	}\n"
"}\n"
"function WriteCookie()\n"
"{\n"
"	var C = GetCookie();\n"
"	C.live = {};\n"
"	for(var i in Cookie)\n"
"	{\n"
"		C.live[i] = Cookie[i];\n"
"	}\n"
"\n"
"	var date = new Date();\n"
"	date.setFullYear(2099);\n"
"	var cookie = \'fisk=\' + JSON.stringify(C) + \';expires=\' + date;\n"
"	document.cookie = cookie;\n"
"}\n"
"\n"
"ReadCookie();\n"
"ParseUrl();\n"
"ResizeCanvas();\n"
"SetupEvents();\n"
"InitMenu();\n"
"setInterval(Connect, 100);\n"
"RequestDraw();\n"
"\n"
"\n"
"</script>\n"
"</body>\n"
"</html>      \n"
"";

const size_t g_MicroProfileHtmlLive_begin_5_size = sizeof(g_MicroProfileHtmlLive_begin_5);
const char* g_MicroProfileHtmlLive_begin[] = {
&g_MicroProfileHtmlLive_begin_0[0],
&g_MicroProfileHtmlLive_begin_1[0],
&g_MicroProfileHtmlLive_begin_2[0],
&g_MicroProfileHtmlLive_begin_3[0],
&g_MicroProfileHtmlLive_begin_4[0],
&g_MicroProfileHtmlLive_begin_5[0],
};
size_t g_MicroProfileHtmlLive_begin_sizes[] = {
sizeof(g_MicroProfileHtmlLive_begin_0),
sizeof(g_MicroProfileHtmlLive_begin_1),
sizeof(g_MicroProfileHtmlLive_begin_2),
sizeof(g_MicroProfileHtmlLive_begin_3),
sizeof(g_MicroProfileHtmlLive_begin_4),
sizeof(g_MicroProfileHtmlLive_begin_5),
};
size_t g_MicroProfileHtmlLive_begin_count = 6;
const char* g_MicroProfileHtmlLive_end[] = {
""};
size_t g_MicroProfileHtmlLive_end_sizes[] = {
0};
size_t g_MicroProfileHtmlLive_end_count = 0;
#endif //MICROPROFILE_EMBED_HTML

///end file generated from  microprofilelive.html
