/*
    MiddleMan filtering proxy server
    Copyright (C) 2002-2004  Jason McLaughlin

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include "proto.h"

extern TemplateSection *template_section;

DnsblSection::DnsblSection():
        Section("dnsbl", RWLOCK),
     enabled  (field_vec[0].int_value),
     templ    (field_vec[1].string_value),
     domain   (field_vec[2].string_value),
     badips   (field_vec[3].ip_range_list_value)
{
}

void DnsblSection::update()
{
        /* Nothing to do ! */
}

bool DnsblSection::check_and_block(CONNECTION *connection) const
{
	int x;
	char *ptr, buf[1024], ip[16];
	HOSTENT *hostent;

	read_lock();

	if (enabled == TRUE && !(connection->bypass & FEATURE_DNSBL) && domain != "" && badips.size() != 0) {
		ptr = strchr(connection->header->host, '\0');
		for (x = 0; x < 2 && ptr != connection->header->host; ptr--)
		if (*ptr == '.')
			x++;

		if (ptr != connection->header->host)
			ptr += 2;

		snprintf(buf, sizeof(buf), "%s.%s", ptr, domain.c_str());
		hostent = net_dns(buf);
		if (hostent != NULL) {
			inet_ntop(AF_INET, hostent->addr, ip, sizeof(ip));
			if (badips.has(ip)) {
				template_section->send((templ != "") ? templ.c_str() : "blocked", connection, 404);

				unlock();

				hostent_free(hostent);

				putlog(MMLOG_DNSBL, "domain %s is blacklisted", connection->header->host);

				return FALSE;
			}

			hostent_free(hostent);
		}
	}

	unlock();

	return TRUE;
}
