/*
    MiddleMan filtering proxy server
    Copyright (C) 2002-2004  Jason McLaughlin
    Copyright (C) 2003  Riadh Elloumi

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdio.h>
#include <string.h>
#include "proto.h"

GeneralSection::GeneralSection():
	Section("general", RWLOCK),
     hostname    (field_vec[0].string_value),
     ctimeout    (field_vec[1].int_value),
     timeout     (field_vec[2].int_value),
     keeptimeout (field_vec[3].int_value),
     maxbuffer   (field_vec[4].uint_value),
     tempdir     (field_vec[5].string_value),
     linelength  (field_vec[6].int_value),
     cportrange  (field_vec[7].port_range_list_value),
     poolsize    (field_vec[8].int_value),
     pooltimeout (field_vec[9].int_value),
     encodemime  (field_vec[10].string_value),
     compressout   (field_vec[11].int_value),
     compressin    (field_vec[12].int_value),
     xforwardedfor (field_vec[13].int_value),
     via           (field_vec[14].int_value)

{
	emp = NULL;
}

void GeneralSection::update()
{
	if (encodemime != "") {
		if (emp != NULL)
			reg_free(emp);
		emp = reg_compile((char*)encodemime.c_str(), REGFLAGS);
	} else {
		emp = NULL;
	}
}

int GeneralSection::ctimeout_get() const
{
	return atomic_read(&this->ctimeout);
}

int GeneralSection::timeout_get() const
{
	return atomic_read(&this->timeout);
}

int GeneralSection::keeptimeout_get() const
{
	return atomic_read(&this->keeptimeout);
}

int GeneralSection::maxbuffer_get() const
{
	return atomic_read(&this->maxbuffer);
}

int GeneralSection::linelength_get() const
{
	return atomic_read(&this->linelength);
}

int GeneralSection::cportrange_check(int port) const
{
	int ret = TRUE;

	read_lock();
	
	ret = cportrange.has(port);

	unlock();

	return ret;
}

int GeneralSection::poolsize_get() const
{
	return atomic_read(&this->poolsize);
}

int GeneralSection::pooltimeout_get() const
{
	return atomic_read(&this->pooltimeout);
}

int GeneralSection::compressin_get() const
{
	return atomic_read(&this->compressin);
}

int GeneralSection::compressout_get() const
{
	return atomic_read(&this->compressout);
}

int GeneralSection::xforwardedfor_get() const
{
	return atomic_read(&this->xforwardedfor);
}

int GeneralSection::via_get() const
{
	return atomic_read(&this->via);
}

FtpSection::FtpSection():
	Section("ftp", RWLOCK),
     passive   (field_vec[0].int_value),
     timeout   (field_vec[1].int_value),
     anonlogin (field_vec[2].string_value),
     anonpass  (field_vec[3].string_value),
     sortorder (field_vec[4].int_value),
     sortfield (field_vec[5].int_value)
{
}

void FtpSection::update()
{
	/* Nothing to do ! */
}

int FtpSection::passive_get() const
{
	return atomic_read(&this->passive);
}

int FtpSection::timeout_get() const
{
	return atomic_read(&this->timeout);
}

int FtpSection::sortorder_get() const
{
	return atomic_read(&this->sortorder);
}

int FtpSection::sortfield_get() const
{
	return atomic_read(&this->sortfield);
}
