/*
    MiddleMan filtering proxy server
    Copyright (C) 2002-2004  Jason McLaughlin
    Copyright (C) 2003  Riadh Elloumi

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "proto.h"

extern GeneralSection *general_section;
extern TemplateSection *template_section;

/*
This function handles CONNECT requests (HTTPS)
*/
int protocol_connect(CONNECTION * connection)
{
	char *headbuf;

	putlog(MMLOG_REQUEST, "CONNECT %s:%d", connection->header->host, connection->header->port);

	if (connection->proxy_type == PROXY_NORMAL) {
		header_send(connection->header, connection, SERVER, HEADER_FORWARD);

	      auth_finished:
		headbuf = header_get(connection, SERVER, general_section->timeout_get());

		if (headbuf != NULL) {
			connection->rheader = http_header_parse_response(headbuf);
			xfree(headbuf);
		}

		if (connection->rheader == NULL) {
			template_section->send("noconnect", connection, 503);

			goto out;
		}

		if (connection->rheader->code == 407 && !(connection->flags & CONNECTION_AUTHENTICATED)) {
			if (proxy_authenticate(connection)) {
				http_header_free(connection->rheader);

				/* only try once */
				connection->flags |= CONNECTION_AUTHENTICATED;

				/* authentication finished, retrieve the header again */
				goto auth_finished;
			}

			FREE_AND_NULL(connection->rheader->proxy_authenticate);
		} else if (connection->rheader->code != 200) {
			template_section->send("noconnect", connection, 503);

			goto out;
		}

	}

	connection->client->PutSock("HTTP/1.1 200 Connection Established\r\n\r\n");

	net_proxy(connection, -1);

      out:
	if (connection->rheader != NULL)
		http_header_free(connection->rheader);
	return 0;
}


int proxy_connect(CONNECTION * connection)
{
	char *headbuf;
	HEADER *oldheader;

	oldheader = connection->header;

	connection->header = header_new();
	connection->header->type = HTTP_CONNECT;
	connection->header->host = xstrdup(oldheader->host);
	connection->header->port = oldheader->port;

	header_send(connection->header, connection, SERVER, HEADER_FORWARD);

      auth_finished:
	headbuf = header_get(connection, SERVER, general_section->timeout_get());

	connection->rheader = NULL;
	if (headbuf != NULL)
		connection->rheader = http_header_parse_response(headbuf);
	FREE_AND_NULL(headbuf);

	if (connection->rheader == NULL) {
		http_header_free(connection->header);
		connection->header = oldheader;

		return -1;
	}

	if (connection->rheader->code == 407 && !(connection->flags & CONNECTION_AUTHENTICATED)) {
		if (proxy_authenticate(connection)) {
			http_header_free(connection->rheader);

			connection->flags |= CONNECTION_AUTHENTICATED;

			goto auth_finished;
		}
	}

	http_header_free(connection->header);
	http_header_free(connection->rheader);

	connection->header = oldheader;
	connection->rheader = NULL;

	return TRUE;
}

