use strict;
use Lingua::Romkan;

my $CHAR  = '(?:[\x00-\x7f]|(?:\x8f[\xa1-\xfe]|[\x8e\xa1-\xfe])[\xa1-\xfe])';
my $KANJI    = "(?:[\xb0-\xfe][\xa1-\xfe]|\xa1\xb9)";
my $CHOON    = "(?:[\xa1][\xbc]|[\xa1][\xc1])";  # , 
my $HIRAGANA = "(?:(?:[\xa4][\xa1-\xf3])|$CHOON)";

while (<>) {
    if (! /^;/ && /^((?:$KANJI|$HIRAGANA|[a-zA-Z])+) (.*)/) {
	my $head  = kanrom($1);
	my $rest  = $2;
	my @words = grep { /^$CHAR+$/ } split '/', $rest;

	if ($head =~ /^(?:$HIRAGANA+)([a-z]) /) {
	    my $okuri = $1;
	    if (isconsonant($okuri) || $okuri eq "n") {
		for my $cand (consonant2moras($okuri)) {
		    my $deriv =  $head . $cand;
		    my @tmp = map {$_ . romkan($cand)} @words;
		    print "$deriv @tmp\n";
		}
	    } else {
		my $deriv =  $head . $okuri;
		my @tmp = map {$_ . romkan($okuri)} @words;
		print "$deriv\t@tmp\n";
	    }
	} else {
	    print "$head\t@words\n";
	}
    }
}
exit 0;

