/***************************************************************************
    copyright            : (C) 2002-2005 by Stefano Barbato
    email                : stefano@codesink.org

    $Id: header.h,v 1.11 2005/02/23 10:26:14 tat Exp $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef _MIMETIC_HEADER_H_
#define _MIMETIC_HEADER_H_
#include <string>
#include <algorithm>
#include <mimetic/rfc822/header.h>
#include <mimetic/mimeversion.h>
#include <mimetic/contenttype.h>
#include <mimetic/contentid.h>
#include <mimetic/contenttransferencoding.h>
#include <mimetic/contentdisposition.h>
#include <mimetic/contentdescription.h>

namespace mimetic
{

/// MIME message header class
struct Header: public Rfc822Header
{
    const MimeVersion& mimeVersion() const;
    MimeVersion& mimeVersion();
    void mimeVersion(const MimeVersion&);

    const ContentType& contentType() const;
    ContentType& contentType();
    void contentType(const ContentType&);

    const ContentTransferEncoding& contentTransferEncoding() const;
    ContentTransferEncoding& contentTransferEncoding();
    void contentTransferEncoding(const ContentTransferEncoding&);

    const ContentDisposition& contentDisposition() const;
    ContentDisposition& contentDisposition();
    void contentDisposition(const ContentDisposition&);

    const ContentDescription& contentDescription() const;
    ContentDescription& contentDescription();
    void contentDescription(const ContentDescription&);

    const ContentId& contentId() const;
    ContentId& contentId();
    void contentId(const ContentId&);
};

}

#endif
