/*
 * Copyright (C) 2004 Wesley J. Landaker <wjl@icecavern.net> 
 * Copyright (C) 2001 major mms <http://www.geocities.com/majormms/>
 *
 * MiMMS is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * MiMMS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 */

/*
 * mms://netshow.msn.com/msnbc8 
 * mms://216.106.172.144/bbc1099/ads/ibeam/0_ibeamEarth_aaab00020_15_350k.asf
 * mms://195.124.124.82/56/081001_angriffe_1200.wmv
 * mms://193.159.244.12/n24_wmt_mid
 */

#define MIMMS_VERSION "MiMMS v0.0.9 ($Date: 2004/10/22 14:37:47 $)\n"

#include <stdint.h>
#include <stdlib.h>
#include <stdio.h>
#include <netdb.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <fcntl.h>
#include <unistd.h>
#include <uuid/uuid.h>
#include <popt.h>
#include <regex.h>
#include <time.h>

#include <string>
using std::string;

#define _(x) x

#ifdef DEBUG
# define dprintf(x...) printf(x)
#else
# define dprintf(x...) 
#endif

#define BUF_SIZE (1024*128)

typedef struct {

  uint8_t buf[BUF_SIZE];
  int     num_bytes;

} command_t;

int seq_num;
int num_stream_ids;
int stream_ids[20];
int output_fh;

static void put_32 (command_t *cmd, uint32_t value) {
  for (int i=0; i<4; i++) {
    cmd->buf[cmd->num_bytes++] = (value >> (8*i)) & 0xff;
  }
}

static uint32_t get_32 (const void *cmd, int offset) {
  const unsigned char *ccmd = (const unsigned char *)cmd;
  uint32_t value = 0;
  for (int i=0; i<4; i++) {
    value |= ((uint32_t)ccmd[offset+i]&0xff)<<(8*i);
  }
  return value;
}

static void send_command (int s, int command, uint32_t switches, 
			  uint32_t extra, int length,
			  char *data) {
  
  command_t  cmd;
  int        len8;
  int        i;

  len8 = (length + 7) / 8;

  cmd.num_bytes = 0;

  put_32 (&cmd, 0x00000001); /* start sequence */
  put_32 (&cmd, 0xB00BFACE); /* #-)) */
  put_32 (&cmd, len8*8 + 32);
  put_32 (&cmd, 0x20534d4d); /* protocol type "MMS " */
  put_32 (&cmd, len8 + 4);
  put_32 (&cmd, seq_num);
  seq_num++;
  put_32 (&cmd, 0x0);        /* unknown */
  put_32 (&cmd, 0x0);
  put_32 (&cmd, len8+2);
  put_32 (&cmd, 0x00030000 | command); /* dir | command */
  put_32 (&cmd, switches);
  put_32 (&cmd, extra);

  memcpy (&cmd.buf[48], data, length);
  if (length & 7)
    memset(&cmd.buf[48 + length], 0, 8 - (length & 7));

  if (send (s, cmd.buf, len8*8+48, 0) != (len8*8+48)) {
    fprintf (stderr,"write error\n");
  }

  dprintf (_("\n***************************************************\ncommand sent, %d bytes\n"), length+48);

  dprintf (_("start sequence %08x\n"), get_32 (cmd.buf,  0));
  dprintf (_("command id     %08x\n"), get_32 (cmd.buf,  4));
  dprintf (_("length         %8x \n"), get_32 (cmd.buf,  8));
  dprintf (_("len8           %8x \n"), get_32 (cmd.buf, 16));
  dprintf (_("sequence #     %08x\n"), get_32 (cmd.buf, 20));
  dprintf (_("len8  (II)     %8x \n"), get_32 (cmd.buf, 32));
  dprintf (_("dir | comm     %08x\n"), get_32 (cmd.buf, 36));
  dprintf (_("switches       %08x\n"), get_32 (cmd.buf, 40));

  dprintf (_("ascii contents>"));
  for (i=48; i<(length+48); i+=2) {
    unsigned char c = cmd.buf[i];

    if ((c>=32) && (c<=128))
      dprintf ("%c", c);
    else
      dprintf (".");
  }
  dprintf ("\n");

  dprintf (_("complete hexdump of package follows:\n"));
  for (i=0; i<(length+48); i++) {
    dprintf ("%02x", cmd.buf[i]);

    if ((i % 16) == 15)
      dprintf ("\n");

    if ((i % 2) == 1)
      dprintf (" ");

  }
  dprintf ("\n");

}

static void string_utf16(char *dest, const char *src, int len) {
  int i;

  memset (dest, 0, 1000);

  for (i=0; i<len; i++) {
    dest[i*2] = src[i];
    dest[i*2+1] = 0;
  }

  dest[i*2] = 0;
  dest[i*2+1] = 0;
}

static void print_answer (char *data, int len) {

  int i;

  dprintf (_("<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\nanswer received, %d bytes\n"), len);

  dprintf (_("start sequence %08x\n"), get_32 (data, 0));
  dprintf (_("command id     %08x\n"), get_32 (data, 4));
  dprintf (_("length         %8x \n"), get_32 (data, 8));
  dprintf (_("len8           %8x \n"), get_32 (data, 16));
  dprintf (_("sequence #     %08x\n"), get_32 (data, 20));
  dprintf (_("len8  (II)     %8x \n"), get_32 (data, 32));
  dprintf (_("dir | comm     %08x\n"), get_32 (data, 36));
  dprintf (_("switches       %08x\n"), get_32 (data, 40));

  for (i=48; i<len; i+=2) {
    unsigned char c = data[i];
    
    if ((c>=32) && (c<128))
      dprintf ("%c", c);
    else
      dprintf (" %02x ", c);
    
  }
  dprintf ("\n");
}  

static void get_answer (int s) {

  char  data[BUF_SIZE];
  int   command = 0x1b;

  while (command == 0x1b) {
    int len;

    len = recv (s, data, BUF_SIZE, 0) ;
    if (!len) {
      dprintf ("\nalert! eof\n");
      return;
    }

    command = get_32 ((unsigned char *)data, 36) & 0xFFFF;

    if (command == 0x1b) 
      send_command (s, 0x1b, 0, 0, 0, data);
  }
}

static int get_data (int s, char *buf, size_t count) {

  ssize_t  len;
  size_t total = 0;

  while (total < count) {

    len = recv (s, &buf[total], count-total, 0);

    if (len>0) {
       dprintf ("[%d/%d]", total, count);
       fflush (stdout);
    }

    if (len<0) {
      perror ("read error:");
      return 0;
    }

    total += len;

    if (len == 0) return total;

  }

  return total;

}

static int get_header (int s, uint8_t *header) {

  unsigned char  pre_header[8];
  int            i, header_len;

  header_len = 0;

  while (1) {

    if (!get_data (s, (char *)pre_header, 8)) {
      fprintf (stderr,_("pre-header read failed\n"));
      return 0;
    }
    
    for (i=0; i<8; i++)
      dprintf (_("pre_header[%d] = %02x (%d)\n"),
	      i, pre_header[i], pre_header[i]);
    
    if (pre_header[4] == 0x02) {
      
      int packet_len;
      
      packet_len = (pre_header[7] << 8 | pre_header[6]) - 8;

      dprintf (_("asf header packet detected, len=%d\n"),
	      packet_len);

      if (!get_data (s, (char *)&header[header_len], packet_len)) {
	fprintf (stderr,_("header data read failed\n"));
	return 0;
      }

      header_len += packet_len;

      if ( (header[header_len-1] == 1) && (header[header_len-2]==1)) {

	write (output_fh, header, header_len);

	dprintf (_("get header packet finished\n"));

	return (header_len);

      } 

    } else {

      int packet_len, command;
      char data[BUF_SIZE];

      if (!get_data (s, (char *)&packet_len, 4)) {
	fprintf (stderr,_("packet_len read failed\n"));
	return 0;
      }
      
      packet_len = get_32 ((unsigned char *)&packet_len, 0) + 4;
      
      dprintf (_("command packet detected, len=%d\n"),
	      packet_len);
      
      if (!get_data (s, data, packet_len)) {
	fprintf (stderr,_("command data read failed\n"));
	return 0;
      }
      
      command = get_32 ((unsigned char *)data, 24) & 0xFFFF;
      
      dprintf (_("command: %02x\n"), command);
      
      if (command == 0x1b) 
	send_command (s, 0x1b, 0, 0, 0, data);
      
    }

    dprintf (_("get header packet succ\n"));
  }
}

int interp_header (uint8_t *header, int header_len) {

  int i;
  int packet_length = 0;

  /*
   * parse header
   */

  i = 30;
  while (i<header_len) {
    
    uint64_t  guid_1, guid_2, length;

    guid_2 = (uint64_t)header[i] | ((uint64_t)header[i+1]<<8) 
      | ((uint64_t)header[i+2]<<16) | ((uint64_t)header[i+3]<<24)
      | ((uint64_t)header[i+4]<<32) | ((uint64_t)header[i+5]<<40)
      | ((uint64_t)header[i+6]<<48) | ((uint64_t)header[i+7]<<56);
    i += 8;

    guid_1 = (uint64_t)header[i] | ((uint64_t)header[i+1]<<8) 
      | ((uint64_t)header[i+2]<<16) | ((uint64_t)header[i+3]<<24)
      | ((uint64_t)header[i+4]<<32) | ((uint64_t)header[i+5]<<40)
      | ((uint64_t)header[i+6]<<48) | ((uint64_t)header[i+7]<<56);
    i += 8;
    
    dprintf (_("guid found: %016llx%016llx\n"), guid_1, guid_2);

    length = (uint64_t)header[i] | ((uint64_t)header[i+1]<<8) 
      | ((uint64_t)header[i+2]<<16) | ((uint64_t)header[i+3]<<24)
      | ((uint64_t)header[i+4]<<32) | ((uint64_t)header[i+5]<<40)
      | ((uint64_t)header[i+6]<<48) | ((uint64_t)header[i+7]<<56);

    i += 8;

    if ( (guid_1 == 0x6cce6200aa00d9a6ll) && (guid_2 == 0x11cf668e75b22630ll) ) {
      dprintf (_("header object\n"));
    } else if ((guid_1 == 0x6cce6200aa00d9a6ll) && (guid_2 == 0x11cf668e75b22636ll)) {
      dprintf (_("data object\n"));
    } else if ((guid_1 == 0x6553200cc000e48ell) && (guid_2 == 0x11cfa9478cabdca1ll)) {

      packet_length = get_32(header, i+92-24);

      dprintf (_("file object, packet length = %d (%d)\n"),
	      packet_length, get_32(header, i+96-24));


    } else if ((guid_1 == 0x6553200cc000e68ell) && (guid_2 == 0x11cfa9b7b7dc0791ll)) {

      int stream_id = header[i+48] | header[i+49] << 8;

      dprintf (_("stream object, stream id: %d\n"), stream_id);

      stream_ids[num_stream_ids] = stream_id;
      num_stream_ids++;
      

      /*
	} else if ((guid_1 == 0x) && (guid_2 == 0x)) {
	dprintf ("??? object\n");
      */
    } else {
      dprintf (_("unknown object\n"));
    }

    dprintf (_("length    : %lld\n"), length);

    i += length-24;

  }

  return packet_length;

}


static int get_media_packet (int s, int padding) {

  unsigned char  pre_header[8];
  int            i;
  char           data[BUF_SIZE];

  if (!get_data (s, (char *)pre_header, 8)) {
    fprintf (stderr,_("pre-header read failed\n"));
    return 0;
  }

  for (i=0; i<8; i++)
    dprintf (_("pre_header[%d] = %02x (%d)\n"),
	    i, pre_header[i], pre_header[i]);

  if (pre_header[4] == 0x04 || pre_header[4] == 0x44 || pre_header[4] == 0xd1 ) {

    int packet_len;

    packet_len = (pre_header[7] << 8 | pre_header[6]) - 8;

    dprintf (_("asf media packet detected, len=%d\n"),
	    packet_len);

    if (!get_data (s, data, packet_len)) {
      fprintf (stderr,_("media data read failed\n"));
      return 0;
    }

    write (output_fh, data, padding);

  } else {

    int packet_len, command;

    if (!get_data (s, (char *)&packet_len, 4)) {
      dprintf (_("packet_len read failed\n"));
      return 0;
    }

    packet_len = get_32 ((unsigned char *)&packet_len, 0) + 4;

    dprintf (_("command packet detected, len=%d\n"),
	    packet_len);

    if (!get_data (s, data, packet_len)) {
      fprintf (stderr,_("command data read failed\n"));
      return 0;
    }

    if ( (pre_header[7] != 0xb0) || (pre_header[6] != 0x0b)
	 || (pre_header[5] != 0xfa) || (pre_header[4] != 0xce) ) {

      dprintf (_("missing signature\n"));
      exit (1);

    }

    command = get_32 ((unsigned char *)data, 24) & 0xFFFF;

    dprintf (_("command: %02x\n"), command);

    if (command == 0x1b) 
      send_command (s, 0x1b, 0, 0, 0, data);
    else if (command == 0x1e) {

      printf (_("everything done.\n"));

      return 0;
    } else if (command != 0x05) {
      dprintf (_("unknown command %02x\n"), command);
      exit (1);
    }
  }

  dprintf (_("get media packet succ\n"));

  return 1;
}

int main (int argc, const char **argv) {

  int                  s ;
  struct sockaddr_in   sa;
  struct hostent      *hp;
  char                 str[1024];
  char                 data[1024];
  uint8_t              asf_header[8192];
  int                  asf_header_len;
  int                  len, i, packet_length;
  const char          *host;
  int                  port;
  const char          *path;
  const char          *file;
  int                  time = -1;

  char *paramfile = 0;
  int paramtime = 0;
  int paramversion = 0;

  time_t end_time = -1;  

  // parse command line arguments
  // host = hostname
  // path = full path
  // file = output filename

  poptOption paramtable[] = {
    { 
      "output", 'o', POPT_ARG_STRING, &paramfile, 0,
      "Write the output to the given file instead of the name in the URL.", 
      "<file>" 
    },
    { 
      "time", 't', POPT_ARG_INT, &paramtime, 0,
      "Record only for given number of minutes (useful for live streams).", 
      "<minutes>" 
    },
    POPT_AUTOHELP
    { 
      "version", 0, POPT_ARG_NONE, &paramversion, 0,
      "Show program version information.",
      0
    },
    POPT_TABLEEND
  };

  poptContext paramcontext = 
    poptGetContext(0, argc, argv, paramtable, 0);

  poptSetOtherOptionHelp(paramcontext, "[options] mms://<host>[:port]/<path>");
  
  if (argc < 2) {
    poptPrintUsage(paramcontext, stderr, 0);
    exit(1);
  }

  int paramresult = poptGetNextOpt(paramcontext);

  if (paramversion) {
    fprintf(stderr, MIMMS_VERSION);
    exit(1);
  }

  if (paramresult != -1) {
    fprintf(stderr, "(%d) %s: %s\n", paramresult,
	    poptBadOption(paramcontext, POPT_BADOPTION_NOALIAS),
	    poptStrerror(paramresult));
    poptPrintUsage(paramcontext, stderr, 0);
    exit(1);
  }

  const char **mms_url = poptGetArgs(paramcontext);
  if (!mms_url) {
    poptPrintUsage(paramcontext, stderr, 0);
    exit(1);    
  }

  regex_t mms_regex;
  regmatch_t mms_regmatch[5];
  {
    int result = regcomp(&mms_regex, 
	  "^(mms)://([-.[:alnum:]]+)(:[[:digit:]]+)?(/.*)$",
	  REG_EXTENDED);
    if (result) {
      fprintf(stderr,"BUG: error compiling mms_regex\n");
      exit(2);
    }
  }
  
  {
    int result = regexec(&mms_regex, mms_url[0], 5, mms_regmatch, 0);
    if (result) {
      fprintf(stderr, "Unparseable url = '%s'\n", mms_url[0]);
      poptPrintUsage(paramcontext, stderr, 0);
      exit(1);
    }
  }

  string protocol = string(&mms_url[0][mms_regmatch[1].rm_so],
			   &mms_url[0][mms_regmatch[1].rm_eo]);
  if (protocol != "mms") {
    fprintf(stderr, "Unknown protocol = '%s'", protocol.c_str());
    poptPrintUsage(paramcontext, stderr, 0);
    exit (1);
  }

  string host_string = string(&mms_url[0][mms_regmatch[2].rm_so],
			      &mms_url[0][mms_regmatch[2].rm_eo]);
  host = host_string.c_str();

  port = 1755;
  if (mms_regmatch[3].rm_so != -1) {
    string port_string = string(&mms_url[0][mms_regmatch[3].rm_so+1],
				&mms_url[0][mms_regmatch[3].rm_eo]);
    port = atoi(port_string.c_str());
  }

  string path_string = string(&mms_url[0][mms_regmatch[4].rm_so],
			      &mms_url[0][mms_regmatch[4].rm_eo]);
  path = path_string.c_str() + 1;
  file = strrchr(path, '/');
  if (file == 0) {
    file = path;
  } else {
    file += 1;
  }

  if (paramtime) time = paramtime;
  if (paramfile) file = paramfile;

  fprintf (stderr,_("host : >%s<\n"), host);
  fprintf (stderr,_("port : >%d<\n"), port);
  fprintf (stderr,_("path : >%s<\n"), path);
  fprintf (stderr,_("file : >%s<\n"), file);
  fprintf (stderr,_("time : >%d<\n"), time);

  if (time != -1) {
    ::time(&end_time);
    end_time += time*60;
  }

  output_fh = open (file, O_WRONLY | O_CREAT | O_TRUNC, 0644);
  if (output_fh<0) {
    fprintf (stderr,_("cannot create output file '%s'.\n"),
	    file);
    exit(1);
  }

  fprintf (stderr,_("creating output file '%s'\n"), file);

  /* DNS lookup */

  if ((hp = gethostbyname(host)) == NULL) {
    fprintf(stderr,_("Host name lookup failure.\n"));
    return 1 ;
  }

  /* fill socket structure */

  bcopy ((char *) hp->h_addr, (char *) &sa.sin_addr, hp->h_length);
  sa.sin_family = hp->h_addrtype;
  /*sa.sin_port = 0x5000;*/ /* http port (80 => 50 Hex, switch Hi-/Lo-Word ) */

  sa.sin_port = htons(port) ; /* be2me_16(1755);  mms port 1755 */

  fprintf (stderr,_("port: %08x\n"), sa.sin_port);

  /* open socket */

  if ((s = socket(hp->h_addrtype, SOCK_STREAM, 0))<0) {
    perror (_("socket"));
    return  1 ;
  }

  dprintf (_("socket open\n"));

  /* try to connect */

  if (connect (s, (struct sockaddr *)&sa, sizeof sa)<0) {
    perror (_("request"));
    return(1);
  }

  fprintf (stderr,_("connected\n"));

  /* cmd1 */
  uuid_t client_uuid;
  uuid_generate(client_uuid);

  char uuid_string[37];
  uuid_unparse(client_uuid, uuid_string);
  
  sprintf (str,
	   "\034\003NSPlayer/9.0.0.2800; "
	   "{%s}; "
	   "Host: %s", uuid_string, host);
  string_utf16 (data, str, strlen(str)+2);

  send_command (s, 1, 0, 0x0004000b, strlen(str) * 2+8, data);

  len = read (s, data, BUF_SIZE) ;
  if (len)
    print_answer (data, len);
  
  /* cmd2 */

  string_utf16 (&data[8], "\002\000\\\\192.168.0.129\\TCP\\1037\0000", 
		28);
  memset (data, 0, 8);
  send_command (s, 2, 0, 0, 28*2+8, data);

  len = read (s, data, BUF_SIZE) ;
  if (len)
    print_answer (data, len);

  /* 0x5 */

  string_utf16 (&data[8], path, strlen(path));
  memset (data, 0, 8);
  send_command (s, 5, 0, 0, strlen(path)*2+12, data);

  get_answer (s);

  /* 0x15 */

  memset (data, 0, 40);
  data[32] = 2;

  send_command (s, 0x15, 1, 0, 40, data);

  num_stream_ids = 0;
  /* get_headers(s, asf_header);  */

  asf_header_len = get_header (s, asf_header);
  packet_length = interp_header (asf_header, asf_header_len);

  /* 0x33 */

  memset (data, 0, 40);

  for (i=1; i<num_stream_ids; i++) {
    data [ (i-1) * 6 + 2 ] = 0xFF;
    data [ (i-1) * 6 + 3 ] = 0xFF;
    data [ (i-1) * 6 + 4 ] = stream_ids[i];
    data [ (i-1) * 6 + 5 ] = 0x00;
  }

  send_command (s, 0x33, num_stream_ids, 
		0xFFFF | stream_ids[0] << 16, 
		(num_stream_ids-1)*6+2 , data);

  get_answer (s);

  /* 0x07 */

  memset (data, 0, 40);

  for (i=8; i<16; i++)
    data[i] = 0xFF;

  data[20] = 0x04;

  send_command (s, 0x07, 1, 
		0xFFFF | stream_ids[0] << 16, 
		24, data);



  while (get_media_packet(s, packet_length)) {
    printf(".");
    if (time != -1) {
      time_t cur_time;
      ::time(&cur_time);
      if (cur_time > end_time) {
        fprintf(stderr,"Maximum record time exceeded, stopping...\n");
        break;
      }
    }
  }

  close (output_fh);
  close (s);

  return 0;
}
