/*======================================================================*\
|*		Editor mined						*|
|*		part 1							*|
\*======================================================================*/

#include "mined.h"
#include "io.h"

#include <errno.h>


/*======================================================================*\
|*			Definitions specific for mined1.c		*|
\*======================================================================*/

# ifdef unix
# define helpcommand "man mined"
# define helpfilename "%s/mined.help"
# endif

# ifdef vms
# define helpcommand "help mined"
# define helpfilename "%s/mined.help"
# endif

# ifdef msdos
# define helpcommand "more < %smined.hlp"
# define helpfilename "%s/mined.hlp"
# endif

# ifdef unix
#  ifdef sysV
#  define printcommand "lp %s"
#  else
#  define printcommand "lpr %s"
#  endif
# endif

# ifdef vms
# define printcommand "print %s"
# endif

# ifdef msdos
# define printcommand "copy %s prn: > nul:"
# endif

#define mark_file	"@mined.mar"


#ifdef msdos
#ifdef __TURBOC__
#define msdos_screenfunctions
#endif
#endif


/* forward */
static void set_file_type_flags ();


/*======================================================================*\
|*			Screen stuff					*|
\*======================================================================*/

#define clearscreen()	clear_screen (); top_line_scrolled = True;


/*======================================================================*\
|*			Data section					*|
\*======================================================================*/

LINE * header;			/* Head of line list */
LINE * tail;			/* Last line in line list */
LINE * cur_line;		/* Current line in use */
LINE * top_line;		/* First line of screen */
LINE * bot_line;		/* Last line of screen */
char * cur_text;		/* Current char on current line in use */
int last_y;			/* Last y of screen. Usually SCREENMAX */
int x = 0;			/* screen column of current text position */
int y = 0;			/* screen row of current text position */
int line_number;		/* current line # determined by file_status */
int lines_per_page = 0;		/* assumption for file_status */
int open_linum;			/* line # to re-position to */
int open_col;			/* column to re-position to */

int YMAX, XMAX;
short MENU = 1;
mousebutton mouse_button, mouse_lastbutton, mouse_prevbutton;
FLAG report_release = False;
int mouse_shift = 0;
int mouse_xpos, mouse_ypos, mouse_lastxpos, mouse_lastypos;

char linesplitmarker = '\0';	/* Leave 1 char. space BEFORE screen [] ! */
char screen [screen_BUFL + 1];	/* I/O buffer for "writes" and "reads" */

FLAG flags_changed = False;	/* should flags menu area be redrawn? */
FLAG quickmenu = True;		/* Right mouse button pops up menu */
static int wheel_scroll = 3;	/* number of lines scrolled by mouse wheel */
int total_lines = 0;		/* Number of lines in file */
long total_chars = -1L;		/* Number of characters in file */
FLAG modified = False;		/* Set when file is modified */
FLAG viewonly = False;		/* Set when view only mode is selected */
static FLAG init_viewonly = False;	/* Set with option v */
FLAG append_flag = False;	/* Set when buffer should be appended to */
FLAG restricted = False;	/* Set when edited file shall not be switched */
FLAG mined_keypad = True;	/* Apply mined keypad assignments */
FLAG mined_del_is_cut = True;	/* Del key cuts buffer */
FLAG overwriteOK = False;	/* Set if current file is OK for overwrite */
FLAG tab_left = True;		/* Set if moving up/down on TAB should go left */
FLAG writable;			/* Set if file cannot be written */
int JUSlevel = 0;		/* keep justified while typing? */
int JUSmode = 0;		/* 1: paragraphs end at empty line */
FLAG autoindent = True;		/* auto indent on input of Enter? */
FLAG dim_HTML = True;		/* display HTML dimmed ? */
FLAG loading = True;		/* Loading a file? Init True for error handling */
FLAG quit = False;		/* Set when quit character is typed */
FLAG intr_char = False;		/* Set when intr character is typed */
FLAG winchg = False;		/* Set when window size has changed */
FLAG interrupted = False;	/* Set when a signal interrupts */
FLAG isscreenmode = False;	/* Set when screen mode is on */
FLAG stat_visible;		/* Set if status_line is visible */
FLAG top_line_scrolled = False;	/* was menu line scrolled away? */
FLAG fstat_always = False;	/* Permanent file status display wanted ? */
FLAG always_disp_code = False;	/* Permanent char code display on status line? */
FLAG waitingforinput = False;	/* Set while waiting for the next command key */
FLAG rpipe = False;		/* Set if file should be read from stdin */
FLAG wpipe = False;		/* Set if file should be written to stdout */
FLAG multiexit = True;		/* Should exit command go to next file? */
FLAG wordnonblank = False;	/* handle all non-blank sequences as words */
FLAG proportional = False;	/* Enable support for proportional fonts? */
FLAG auto_detect_utf = True;	/* Auto detect character encoding from file ? */
FLAG auto_detect_cjk = True;	/* Auto detect CJK encoding from file ? */
static FLAG cjk_encoding_selected = False;
static char * detect_encodings;	/* list of encodings to detect */
static char language_tag = 0;
FLAG translate_output = False;	/* Transform output diacritics to strings */
int tabsize = 8;		/* width of tab positions, 4 or 8 */
char * transout;		/* Output transformation table */
char * dimansi;			/* special character dimming ANSI sequence */
char * ctrlansi;		/* control character display ANSI sequence */
char * uniansi;			/* Unicode character display ANSI sequence */
char * unimarkansi;		/* Unicode (lineend) marker display ANSI sequence */
char * combiningansi;		/* combining character display ANSI sequence */
char * menuansi;		/* menu line ANSI sequence */
char * HTMLansi;		/* HTML display ANSI sequence */
char * diagansi;		/* dialog (bottom status) line ANSI sequence */
char * scrollfgansi;		/* scrollbar foreground ANSI sequence */
char * scrollbgansi;		/* scrollbar background ANSI sequence */
int translen;			/* length of " */
FLAG controlQS = False;		/* must respect ^Q/^S handshake ? */
FLAG insert_mode = True;	/* insert or overwrite */
character erase_char = '\010';	/* effective (configured) char for erase left */
char emulation = ' ';		/* 'w' for WordStar, 'e' for emacs */
FLAG emacs_buffer = False;	/* enable emacs buffer fct for ^K/^T */
FLAG paste_stay_left = True;	/* cursor stays before pasted region */
character control_prefix = '\026'; /* ^V/^P/^Q character to prefix control chars */
character quit_char = '\034';	/* ^\/^G character to cancel command */
FLAG Turkish = False;		/* enable Turkish case toggle specials ? */
FLAG smart_quotes = True;	/* replace " with typographic quote ? */
static char * preselect_quote_style = NIL_PTR;
FLAG utf8_screen = False;	/* screen driven in UTF-8 mode ? */
FLAG utf8_input = False;	/* keyboard input in UTF-8 mode ? */
FLAG cjk_term = False;		/* terminal in CJK mode ? */
FLAG gb18030_term = True;	/* does CJK terminal support GB18030 ? */
FLAG euc3_term = True;		/* does CJK terminal support EUC 3 byte ? */
FLAG euc4_term = True;		/* does CJK terminal support EUC 4 byte ? */
FLAG cjklow_term = True;	/* does CJK terminal support 81-9F range ? */
FLAG cjk_text = False;		/* text in CJK encoding ? */
FLAG utf8_text = False;		/* text in UTF-8 representation ? */
FLAG mapped_text = False;	/* text in 8 bit, non-Latin-1 representation ? */
FLAG utf8_lineends = False;	/* detect UTF-8 LS and PS line ends ? */
FLAG poormansbidi = False;	/* poor man's bidirectional support ? */
FLAG disp_scrollbar = True;	/* shall scrollbar be displayed ? */
FLAG fine_scrollbar = True;	/* fine-grained UTF-8 scrollbar ? */
int scrollbar_width = 1;
FLAG update_scrollbar_lazy = True;	/* partial scrollbar refresh as needed ? */
FLAG combining_mode = False;	/* UTF-8 combining character display support ? */
FLAG combining_mode_disabled = False;	/* combining mode explicitly disabled ? */
FLAG combining_screen = False;	/* UTF-8 combining character terminal ? */
FLAG bidi_screen = False;	/* UTF-8 bidi terminal ? */
int width_data_version = 2;
int nonbmp_width_data = 0x4;
FLAG utf_cjk_wide_padding = False; /* always display CJK on UTF double-width ? */
int combining_data_version = 3;
static FLAG U_mode_set = False;
FLAG display_block_graphics = False;	/* display control chars as graphics */
FLAG no_window_title = False;	/* suppress filename display in window title? */

char selection_space = SPACE_NEXT;	/* space behaviour in keyboard mapping menu */

FLAG page_scroll = False;	/* use scroll for page up/down */
FLAG page_stay = False;		/* stay at edge of screen after page up/down */
#ifdef pc_delay
int display_delay = 9;		/* delay between display lines */
#else
int display_delay = -1;		/* Unix terminals are slow enough anyway */
#endif

#ifdef msdos_with_auto_crlf
char RET_opt = 'r';		/* handle RET chars: ignore / newline */
#else
char RET_opt = ' ';		/* handle RET chars: ignore / newline */
#endif
lineend_type default_lineend = lineend_LF;	/* used for some inserts */

long chars_saved;		/* # of chars in paste buffer */
long bytes_saved;		/* # of bytes in paste buffer */
int lines_saved;		/* # of lines in paste buffer */
int input_fd = STD_IN;		/* File descriptors for terminal dialog */
#ifdef __EMX__
int output_fd = STD_OUT;
#else
int output_fd = STD_ERR;
#endif
unsigned int out_count = 0;	/* Index in output buffer */
char file_name [maxLINE_LEN];	/* Name of file in use */
char text_buffer [MAX_CHARS];	/* for get_line, modifications, build_string */
int hop_flag = 0;		/* Counter flag for the HOP function */
char TABchar = ' ';		/* Char to be shown in place of tab chars */
char TABchar0 = '\0';		/* Char to be shown at start of tab chars */
char TABchar2 = '\0';		/* Char to be shown at end of tab chars */
char TABcharmid = '\0';		/* Char to be shown in middle of tab chars */
char SHIFT_BEG = '\0';		/* Char indicating that line continues left */
char RET_MARK = '\0';		/* Char indicating end of line */
char DOSRET_MARK = '\0';	/* Char indicating DOS end of line */
char PARA_MARK = '\0';		/* Char indicating end of paragraph */
char RET_BLANK = '\0';		/* Char to fill the end of line with */
char RET_BLANK2 = '\0';		/* Char to fill last position of line with */
char * UTF_TAB = NIL_PTR;	/* Char to be shown in place of tab chars */
char * UTF_TAB0 = NIL_PTR;	/* Char to be shown at start of tab chars */
char * UTF_TAB2 = NIL_PTR;	/* Char to be shown at end of tab chars */
char * UTF_TABmid = NIL_PTR;	/* Char to be shown in middle of tab chars */
char * UTF_RET = NIL_PTR;	/* Char indicating end of line */
char * UTF_DOSRET = NIL_PTR;	/* Char indicating DOS end of line */
char * UTF_PARA = NIL_PTR;	/* Char indicating end of paragraph */
char * UTF_RETblank = NIL_PTR;	/* Char to fill the end of line with */
char * UTF_RETblank2 = NIL_PTR;	/* Char to fill last position of line with */
FLAG paradisp = False;		/* Shall paragraph end be distinguished? */
#ifdef vms
unsigned int fprot = 0;		/* To be used for file creatings */
unsigned int bufprot = 0;	/* To be used for paste buffer file */
unsigned int exeprot = 0;	/* To be used for creation of executables */
#else
PROT fprot = 0644;	/* To be used for file creatings */
PROT bufprot = 0600;	/* To be used for paste buffer file */
PROT exeprot = 0111;	/* To be used for creation of executables */
#endif
PROT xprot = 0;
int fnami;			/* Parameter index of current file name */
int fnami_min, fnami_max, fnami_cnt;
/* char * (* fnamv) []; */
char * * fnamv;			/* Copy of argv. Points to program params */

char * inisearch = NIL_PTR;	/* Optional startup search string */

extern int first_left_margin;
extern int next_left_margin;
extern int right_margin;

#ifdef unix
/* window headline and icon text setting */
char * window_string_code = "";
char * mined_modf = " (*)";
#endif

/*
 * Yank variables.
 */
char * temp_dir;
char yank_file [maxLINE_LEN];
char yankie_file [maxLINE_LEN];
char html_file [maxLINE_LEN];	/* Temp. file for HTML embedding buffer */
char panic_file [maxLINE_LEN];


/*======================================================================*\
|*			Text string routines				*|
\*======================================================================*/

int
UTF_len (c)
  char c;
{
	if ((c & 0x80) == 0x00) {
		return 1;
	} else if ((c & 0xE0) == 0xC0) {
		return 2;
	} else if ((c & 0xF0) == 0xE0) {
		return 3;
	} else if ((c & 0xF8) == 0xF0) {
		return 4;
	} else if ((c & 0xFC) == 0xF8) {
		return 5;
	} else if ((c & 0xFE) == 0xFC) {
		return 6;
	} else { /* illegal UTF-8 code */
		return 1;
	}
}

int
UTFseq_len (text)
  char * text;
{
	int follow = UTF_len (* text) - 1;
	int len = 1;
	text ++;
	while (follow > 0 && (* text & 0xC0) == 0x80) {
		len ++;
		text ++;
		follow --;
	}
	return len;
}

int
CJK_len (text)
  character * text;
{
  if (multichar (* text)) {
	if (cjk_encoding == 'C' && * text == 0x8E) {
		return 4;
	} else if (cjk_encoding == 'J' && * text == 0x8F) {
		return 3;
	} else if (cjk_encoding == 'G'
		&& * (text + 1) <= '9'
		&& * (text + 1) >= '0') {
			return 4;
	} else {
		return 2;
	}
  } else {
	return 1;
  }
}


/*
 * char_count () returns the number of characters in the string
 * excluding the '\0'.
 */
int
char_count (string)
  char * string;
{
  int count = 0;

  if (string != NIL_PTR) {
	while (* string != '\0') {
		advance_char (& string);
		count ++;
	}
  }
  return count;
}


/**
   Quotation marks detection
 */

/**
   determine if current position (if quote mark) is opening
 */
static
int
isopeningquote (s, beg)
  char * s;
  char * beg;
{
	unsigned int prevchar = precedingchar (s, beg);
	/* for now, follow simplified approach; don't consider 
	   quotes after quotes, or CJK embedded quotes */
	switch (prevchar) {
	case '(':
	case '\n':
	case '\t':
	case ' ':
	case '[':
	case '{':
		return True;
	}
	return False;
}

/**
   language-specific quotation mark counters
 */
static unsigned long count_plain = 0;
static unsigned long count_English = 0;
static unsigned long count_German = 0;
static unsigned long count_French = 0;
static unsigned long count_inwards = 0;
static unsigned long count_Dutch = 0;
static unsigned long count_Swedish_q = 0;
static unsigned long count_Swedish_g = 0;
static unsigned long count_Greek = 0;
static unsigned long count_Chinese = 0;
static unsigned long count_Japanese = 0;

static
void
reset_quote_statistics ()
{
	count_plain = 0;
	count_English = 0;
	count_German = 0;
	count_French = 0;
	count_inwards = 0;
	count_Dutch = 0;
	count_Swedish_q = 0;
	count_Swedish_g = 0;
	count_Greek = 0;
	count_Chinese = 0;
	count_Japanese = 0;
}

static unsigned long count_quotes;

static
void
check_quote_style (c, s)
  unsigned long c;
  char * s;
{
/*printf ("%4d %s\n", c, s);*/
  if (c > count_quotes) {
	count_quotes = c;
	set_quote_style (s);
  }
}

static
void
determine_quote_style ()
{
	count_quotes = 0;
	check_quote_style (count_plain, "\"\"");
	check_quote_style (count_English, "“”");
	check_quote_style (count_inwards, "»«");
	check_quote_style (count_German, "„“");
	check_quote_style (count_French, "«» ‹›");
	check_quote_style (count_Dutch, "„”");
	check_quote_style (count_Swedish_q, "””");
	check_quote_style (count_Swedish_g, "»»");
	check_quote_style (count_Greek, "«» ‟”");
	check_quote_style (count_Chinese, "《》");
	check_quote_style (count_Japanese, "『』");
}

/*
 * utf_count () returns the number of UTF-8 characters in the string
   (like char_count) and also detects quotation marks and updates 
   their statistics.
 */
int
utf8_count (string)
  char * string;
{
  char * start = string;
  int count = 0;
  unsigned long unichar;
  int utflen;

  if (string != NIL_PTR) {
    while (* string != '\0') {
	/* Detect quotation marks.
	   The UTF-8 codes of all quotation marks are either 
	   C2AB or C2BB or start with either E280 or E380. 
	   This may help for efficient detection during file loading.
	 */
	if ((((character) * string) <= 0x27
	     && (* string == '\'' || * string == '"')
	    )
	    ||
	    ((* string & 0xDE) == 0xC2
	     && (((character) * string) == 0xC2 || ((character) * (string + 1)) == 0x80)
	    )
	   )
	{
	    utf8_info (string, & utflen, & unichar);
	    switch ((unsigned int) unichar) {
	    case (character) '"':
	    case (character) '\'':
			count_plain ++;
			break;
	    case 0x201C: /* “ LEFT DOUBLE QUOTATION MARK; DOUBLE TURNED COMMA QUOTATION MARK */
	    case 0x2018: /* ‘ LEFT SINGLE QUOTATION MARK; SINGLE TURNED COMMA QUOTATION MARK */
			/* left English, Spanish, Turkish */
			/* right German, Danish, Polish, Russian, Romanian, Slovak, Slovenian, Czech, Hungarian */
		if (isopeningquote (string, start)) {
			count_English ++;
		} else {
			count_German ++;
		}
		break;
	    case 0x201D: /* ” RIGHT DOUBLE QUOTATION MARK; DOUBLE COMMA QUOTATION MARK */
		count_Greek ++;
	    case 0x2019: /* ’ RIGHT SINGLE QUOTATION MARK; SINGLE COMMA QUOTATION MARK */
			/* right English, Spanish, Turkish */
			/* right Dutch, Hungarian */
			/* left/right Swedish, Finnish */
			/* ” right nested traditional Greek */
		count_Swedish_q ++;
		if (! isopeningquote (string, start)) {
			count_English ++;
			count_Dutch ++;
		}
		break;
	    case 0x201E: /* „ DOUBLE LOW-9 QUOTATION MARK; LOW DOUBLE COMMA QUOTATION MARK */
	    case 0x201A: /* ‚ SINGLE LOW-9 QUOTATION MARK; LOW SINGLE COMMA QUOTATION MARK */
			/* left German, Danish, Polish, Russian, Romanian, Slovak, Sloven, Czech, Hungarian */
			/* left Dutch, Hungarian */
		if (isopeningquote (string, start)) {
			count_German ++;
			count_Dutch ++;
		}
		break;
	    case 0x201F: /* ‟ DOUBLE HIGH-REVERSED-9 QUOTATION MARK; DOUBLE REVERSED COMMA QUOTATION MARK */
		count_Greek ++;
	    case 0x201B: /* ‛ SINGLE HIGH-REVERSED-9 QUOTATION MARK; SINGLE REVERSED COMMA QUOTATION MARK */
			/* ‟ left nested traditional Greek */
		break;
	    case 0x00AB: /* « LEFT-POINTING DOUBLE ANGLE QUOTATION MARK; LEFT POINTING GUILLEMET */
	    case 0x2039: /* ‹ SINGLE LEFT-POINTING ANGLE QUOTATION MARK; LEFT POINTING SINGLE GUILLEMET */
			/* left French, Italian, Norwegian, Portuguese, Russian, Slovenian, Turkish */
			/* right German, Polish, Slovak, Czech, Serbian, Croatian */
			/* left Greek */
		if (isopeningquote (string, start)) {
			count_French ++;
			count_Greek ++;
		} else {
			count_German ++;
			count_inwards ++;
		}
		break;
	    case 0x00BB: /* » RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK; RIGHT POINTING GUILLEMET */
	    case 0x203A: /* › SINGLE RIGHT-POINTING ANGLE QUOTATION MARK; RIGHT POINTING SINGLE GUILLEMET */
			/* right French, Italian, Norwegian, Portuguese, Russian, Slovenian, Turkish */
			/* left German, Polish, Slovak, Czech, Serbian, Croatian */
			/* left/right Swedish, Finnish */
			/* right Greek */
		count_Swedish_g ++;
		if (isopeningquote (string, start)) {
			count_German ++;
			count_inwards ++;
		} else {
			count_French ++;
			count_Greek ++;
		}
		break;
	    case 0x300A: /* 《 LEFT DOUBLE ANGLE BRACKET; OPENING DOUBLE ANGLE BRACKET */
	    case 0x3008: /* 〈 LEFT ANGLE BRACKET; OPENING ANGLE BRACKET */
			/* left Chinese? */
			/* 〈 left Chinese?? */
		if (isopeningquote (string, start)) {
			count_Chinese ++;
		}
		break;
	    case 0x300B: /* 》 RIGHT DOUBLE ANGLE BRACKET; CLOSING DOUBLE ANGLE BRACKET */
	    case 0x3009: /* 〉 RIGHT ANGLE BRACKET; CLOSING ANGLE BRACKET */
			/* right Chinese? */
			/* 〉 right Chinese?? */
		if (! isopeningquote (string, start)) {
			count_Chinese ++;
		}
		break;
	    case 0x300C: /* 「 LEFT CORNER BRACKET; OPENING CORNER BRACKET */
	    case 0x300E: /* 『 LEFT WHITE CORNER BRACKET; OPENING WHITE CORNER BRACKET */
			/* left Japanese */
			/* 『 left Japanese? */
		if (isopeningquote (string, start)) {
			count_Japanese ++;
		}
		break;
	    case 0x300D: /* 」 RIGHT CORNER BRACKET; CLOSING CORNER BRACKET */
	    case 0x300F: /* 』 RIGHT WHITE CORNER BRACKET; CLOSING WHITE CORNER BRACKET */
			/* right Japanese */
			/* 』 right Japanese? */
		if (! isopeningquote (string, start)) {
			count_Japanese ++;
		}
		break;
	    }
	}

	/* Advance and count */
	advance_utf8 (& string);
	count ++;
    }
  }
  return count;
}

/*
 * col_count () returns the number of screen columns in the string
 */
int
col_count (string)
  char * string;
{
  int count = 0;
  char * start = string;

  if (string != NIL_PTR) {
	while (* string != '\0') {
		advance_char_scr (& string, & count, start);
	}
  }
  return count;
}

/*
 * utf8_col_count () returns the number of screen columns in the 
 * UTF-8 string
 */
int
utf8_col_count (string)
  char * string;
{
  int count = 0;
  char * start = string;

  if (string != NIL_PTR) {
	while (* string != '\0') {
		advance_utf8_scr (& string, & count, start);
	}
  }
  return count;
}


/**
   convert Unicode character to UTF-8
 */
int
uniUTF (unichar, buf)
  unsigned long unichar;
  character * buf;
{
  int len;

  if (unichar < 0x80) {
	len = 1;
	* buf ++ = unichar;
  } else if (unichar < 0x800) {
	len = 2;
	* buf ++ = 0xC0 | (unichar >> 6);
	* buf ++ = 0x80 | (unichar & 0x3F);
  } else if (unichar < 0x10000) {
	len = 3;
	* buf ++ = 0xE0 | (unichar >> 12);
	* buf ++ = 0x80 | ((unichar >> 6) & 0x3F);
	* buf ++ = 0x80 | (unichar & 0x3F);
  } else if (unichar < 0x200000) {
	len = 4;
	* buf ++ = 0xF0 | (unichar >> 18);
	* buf ++ = 0x80 | ((unichar >> 12) & 0x3F);
	* buf ++ = 0x80 | ((unichar >> 6) & 0x3F);
	* buf ++ = 0x80 | (unichar & 0x3F);
  } else if (unichar < 0x4000000) {
	len = 5;
	* buf ++ = 0xF8 | (unichar >> 24);
	* buf ++ = 0x80 | ((unichar >> 18) & 0x3F);
	* buf ++ = 0x80 | ((unichar >> 12) & 0x3F);
	* buf ++ = 0x80 | ((unichar >> 6) & 0x3F);
	* buf ++ = 0x80 | (unichar & 0x3F);
  } else if (unichar < 0x80000000) {
	len = 6;
	* buf ++ = 0xFC | (unichar >> 30);
	* buf ++ = 0x80 | ((unichar >> 24) & 0x3F);
	* buf ++ = 0x80 | ((unichar >> 18) & 0x3F);
	* buf ++ = 0x80 | ((unichar >> 12) & 0x3F);
	* buf ++ = 0x80 | ((unichar >> 6) & 0x3F);
	* buf ++ = 0x80 | (unichar & 0x3F);
  } else {
	len = 0;
  }
  * buf = '\0';
  return len;
}

/**
   convert CJK character to byte sequence
 */
int
cjkencode (cjkchar, buf)
  unsigned long cjkchar;
  character * buf;
{
  int len = 0;
  int i;

  if (cjkchar >= 0x1000000) {
	i = (cjkchar >> 16) & 0xFF;
	if (cjk_encoding == 'G' && cjkchar >= 0x80000000
	 && i >= '0' && i <= '9') {
		len = 4;
	} else if (cjk_encoding == 'C' && (cjkchar >> 24) == 0x8E) {
		len = 4;
	}
  } else if (cjkchar >= 0x10000) {
	if (cjk_encoding == 'J' && (cjkchar >> 16) == 0x8F) {
		len = 3;
	}
  } else if (cjkchar >= 0x8000 && (cjkchar & 0xFF) > 0 &&
		multichar ((character) (cjkchar >> 8))) {
	len = 2;
  } else if (cjkchar < 0x100 && ! multichar (cjkchar)) {
	len = 1;
  }

  for (i = len - 1; i >= 0; i --) {
	buf [i] = cjkchar & 0xFF;
	cjkchar = cjkchar >> 8;
	if (buf [i] == '\0') {
		len = 0;
	}
  }
  buf [len] = '\0';

  return len;
}


/**
   determine Unicode information from UTF-8 character
   return parameters:
     length: the number of UTF-8 bytes in the character
     unicode: its Unicode value
 */
void
utf8_info (u, length, unicode)
  char * u;
  int * length;
  unsigned long * unicode;
{
#define REPLACEMENT_CHARACTER 0xFFFD
#define illegal 0x80000000

  char * textpoi = u;
  character c = * textpoi;
  int utfcount;
  unsigned long unichar;

	if ((c & 0x80) == 0x00) {
		utfcount = 1;
		unichar = c;
	} else if ((c & 0xE0) == 0xC0) {
		utfcount = 2;
		unichar = c & 0x1F;
	} else if ((c & 0xF0) == 0xE0) {
		utfcount = 3;
		unichar = c & 0x0F;
	} else if ((c & 0xF8) == 0xF0) {
		utfcount = 4;
		unichar = c & 0x07;
	} else if ((c & 0xFC) == 0xF8) {
		utfcount = 5;
		unichar = c & 0x03;
	} else if ((c & 0xFE) == 0xFC) {
		utfcount = 6;
		unichar = c & 0x01;
	} else if (c == 0xFE) {
		/* illegal UTF-8 code */
		utfcount = 1;
		unichar = '4';
	} else if (c == 0xFF) {
		/* illegal UTF-8 code */
		utfcount = 1;
		unichar = '5';
	} else {
		/* illegal UTF-8 sequence character */
		utfcount = 1;
		unichar = '8';
	}

	* length = utfcount;

	utfcount --;
	textpoi ++;
	while (utfcount > 0 && (* textpoi & 0xC0) == 0x80) {
		unichar = (unichar << 6) | (* textpoi & 0x3F);
		utfcount --;
		textpoi ++;
	}
	if (utfcount > 0) {
		/* too short UTF-8 sequence */
		unichar = (character) '';
		* length -= utfcount;
	}

	* unicode = unichar;
}

/**
   Determine the effective screen width of a Unicode character.
 */
int
uniscrwidth (unichar, charpos, linebegin)
  unsigned long unichar;
  char * charpos;
  char * linebegin;
{
  if (combining_mode == True && iscombined (unichar, charpos, linebegin)) {
	return 0;
  } else if (iswide (unichar)) {
	return 2;
  } else {
	return 1;
  }
}

#ifdef non_joining
/**
   Determine the Unicode width of a character.
 */
int
uniwidth (unichar)
  unsigned long unichar;
{
  if (combining_mode == True && iscombining (unichar)) {
	return 0;
  } else if (iswide (unichar)) {
	return 2;
  } else {
	return 1;
  }
}
#endif

/**
   Determine if a character is joined to a ligature 
   with the previous character in the string or line.
 */
int
isjoined (unichar, charpos, linebegin)
  unsigned long unichar;
  char * charpos;
  char * linebegin;
{
  unsigned long prev_unichar;
  int utflen;

  if (bidi_screen == True && utf8_text == True) {
	if (unichar == 0x0622 || unichar == 0x0623 || unichar == 0x0625 || unichar == 0x0627) {
		/* ALEF may be joined to a ligature with preceding LAM */
		precede_char (& charpos, linebegin);
		utf8_info (charpos, & utflen, & prev_unichar);
		if (prev_unichar == 0x0644) {
			/* LAM joins to a ligature with any of the above */
			return 1;
		}
	}
  }
  return 0;
}

/**
   Determine if a character is effectively of zero width, i.e. 
   if it combines with the previous character in the string or line.
 */
int
iscombined (unichar, charpos, linebegin)
  unsigned long unichar;
  char * charpos;
  char * linebegin;
{
  return isjoined (unichar, charpos, linebegin) || iscombining (unichar);
}

/*
   charbegin () determines the first byte of the character pointed to 
   in the given line
 */
char *
charbegin (line, s)
  char * line;
  char * s;
{
  char * char_search;
  char * char_prev;

  if (utf8_text == True || cjk_text == True) {
	char_search = line;
	char_prev = char_search;
	while (char_search < s) {
		char_prev = char_search;
		advance_char (& char_search);
	}
	if (char_search > s) {
		return char_prev;
	} else {
		return s;
	}
  }
  return s;
}

/*
 * precede_char () moves the character pointer within line "begin_line" 
 * left by 1 character
 */
void
precede_char (poipoi, begin_line)
  char * * poipoi;
  char * begin_line;
{
  char * char_search;
  char * char_prev;

  if (utf8_text == True || cjk_text == True) {
	char_search = begin_line;
	char_prev = char_search;
	while (char_search < * poipoi) {
		char_prev = char_search;
		advance_char (& char_search);
	}
	(* poipoi) = char_prev;
  } else if ((* poipoi) != begin_line) {
	(* poipoi) --;
  }
}

/*
 * charvalue () determines the value of the character
 */
unsigned long
charvalue (poi)
  character * poi;
{
  unsigned long unichar;
  int len;

  if (utf8_text == True) {
	utf8_info (poi, & len, & unichar);
	return unichar;
  } else if (cjk_text == True && multichar (* poi)) {
	len = CJK_len (poi);
	unichar = * poi ++;
	len --;
	while (len > 0 && * poi != '\0' && * poi != '\n') {
		unichar = (unichar << 8) | * poi ++;
		len --;
	}
	return unichar;
  } else {
	return * poi;
  }
}

/*
 * precedingchar () determines the preceding character value
 */
unsigned long
precedingchar (curpoi, begin_line)
  char * curpoi;
  char * begin_line;
{
  char * poi;

  if (curpoi == begin_line) {
	return '\n';
  } else {
	poi = curpoi;
	precede_char (& poi, begin_line);
	return charvalue (poi);
  }
}

/*
 * Advance character pointer and screen column counter to next character.
 * UTF-8 mode.
 */
void
advance_utf8_scr (poipoi, colpoi, linebegin)
  char * * poipoi;
  int * colpoi;
  char * linebegin;
{
  unsigned long unichar;
  int follow;

	utf8_info (* poipoi, & follow, & unichar);
	(* colpoi) += uniscrwidth (unichar, * poipoi, linebegin);
	follow --;
	(* poipoi) ++;
	while (follow > 0 && (* * poipoi & 0xC0) == 0x80) {
		(* poipoi) ++;
		follow --;
	}
}

/*
 * Advance only character pointer to next character.
 * UTF-8 mode.
 */
void
advance_utf8 (poipoi)
  char * * poipoi;
{
  register int follow = UTF_len (* * poipoi) - 1;

	(* poipoi) ++;
	while (follow > 0 && (* * poipoi & 0xC0) == 0x80) {
		(* poipoi) ++;
		follow --;
	}
}

/*
 * Advance character pointer and screen column counter to next character.
 * Handle tab characters and different character encodings correctly.
 */
void
advance_char_scr (poipoi, colpoi, linebegin)
  char * * poipoi;
  int * colpoi;
  char * linebegin;
{
  int len;
  unsigned long unichar;

  if (is_tab (* * poipoi)) {
	* colpoi = tab (* colpoi);
	(* poipoi) ++;
  } else if (utf8_text == True) {
	advance_utf8_scr (poipoi, colpoi, linebegin);
  } else if (cjk_text == True && multichar (* * poipoi)) {
	len = CJK_len (* poipoi);

	if (cjk_term == False) {
		unichar = lookup_cjk (charvalue (* poipoi));
		if (iscombining (unichar)) {
			/* * colpoi remains */
		} else if (utf_cjk_wide_padding == True || iswide (unichar)) {
			(* colpoi) += 2;
		} else {
			(* colpoi) ++;
		}
		(* poipoi) ++;
	} else {
		(* colpoi) ++;
		(* poipoi) ++;
		if (((character) * * poipoi) >= ' ') {
			(* colpoi) ++;
		}
	}

	len --;
	while (len > 0 && * * poipoi != '\0' && * * poipoi != '\n') {
		(* poipoi) ++;
		len --;
	}
  } else {
	(* colpoi) ++;
	(* poipoi) ++;
  }
}

/*
 * Advance only character pointer to next character.
 * Handle tab characters and different character encodings correctly.
 */
void
advance_char (poipoi)
  char * * poipoi;
{
  register int len;

  if (utf8_text == True) {
	advance_utf8 (poipoi);
  } else if (cjk_text == True) {
	len = CJK_len (* poipoi);
	(* poipoi) ++;
	len --;
	while (len > 0 && * * poipoi != '\0' && * * poipoi != '\n') {
		(* poipoi) ++;
		len --;
	}
  } else {
	(* poipoi) ++;
  }
}


/*======================================================================*\
|*			Text buffer routines				*|
|*			File operations					*|
\*======================================================================*/

#include "textbuf.c"


/*======================================================================*\
|*			Web marker insertion				*|
\*======================================================================*/

/*
   Strip string from first blank.
 */
static
void
strip (s)
  char * s;
{
  while (* s != '\0' && * s != ' ') {
	s ++;
  }
  * s = '\0';
}

static
void
embed_HTML ()
{
  char marker [maxLINE_LEN];
  char tag [maxLINE_LEN];

  if (viewonly == True) {
	viewonlyerr ();
	return;
  }
  if (get_string_nokeymap ("Embed text in HTML marker:", marker, True, "") != FINE) {
	return;
  }

  yank_HTML (DELETE);
  S ('<');
  S ('/');
  S ('>');
  MLF ();
  strcpy (tag, marker);
  strip (tag);
  if (insert (cur_line, cur_text, tag) == ERRORS) {
	return;
  }
  MLF ();
  MLF ();
  paste_HTML ();
  S ('<');
  S ('>');
  MLF ();
  if ((marker [0] == 'A' || marker [0] == 'a') && marker [1] == '\0') {
	S (marker [0]);
	S (' ');
	S ('h');
	S ('r');
	S ('e');
	S ('f');
	S ('=');
  } else {
	(void) insert (cur_line, cur_text, marker);
  }
  RD ();
}

static char HTMLmarker [maxLINE_LEN];
static FLAG HTMLmarking = False;

void
HTML ()
{
  char * htmlpoi;

  if (viewonly == True) {
	viewonlyerr ();
	return;
  }

  if (hop_flag > 0) {
	hop_flag = 0;
	embed_HTML ();
  } else {
	if (HTMLmarking == False) {
		if (get_string_nokeymap ("Begin HTML marker:", HTMLmarker, True, "") != FINE)
			return;
		clear_status ();
		S ('<');
		S ('>');
		MLF ();
		if (insert (cur_line, cur_text, HTMLmarker) == ERRORS) {
			return;
		}
		HTMLmarking = True;
	} else {
		S ('<');
		S ('/');
		S ('>');
		MLF ();
		strip (HTMLmarker);
		if (insert (cur_line, cur_text, HTMLmarker) == ERRORS) {
			return;
		}
		HTMLmarking = False;
	}
/*
	set_cursor (0, y);
	line_print (y, cur_line);
*/
	RD ();
	if (* cur_text != '>') {
		htmlpoi = cur_text;
		do {
			advance_char (& htmlpoi);
		} while (* htmlpoi != '>' && * htmlpoi != '\0');
		if (* htmlpoi == '>') {
			htmlpoi ++;
		}
		move_address (htmlpoi, y);
	}
  }
}


/*======================================================================*\
|*			Miscellaneous					*|
\*======================================================================*/

static
int
get_tagline (idf, filename, search)
  char * idf;
  char * filename;
  char * search;
{
  int tags_fd = open ("tags", O_RDONLY | O_BINARY, 0);
  FLAG modif = modified;
  unsigned int len = strlen (idf);
  int dumlen;
  char * poi;
  char * outpoi;
  char lastpat = '\0';
  FLAG found;

  flush ();	/* clear the shared screen/get_line buffer! */

  if (tags_fd >= 0) {
	found = False;
	while (found == False && (get_line (tags_fd, text_buffer, & dumlen)) != ERRORS) {
	    if (strncmp (idf, text_buffer, len) == 0 && text_buffer [len] == '\t') {
		found = True;
		poi = text_buffer + len + 1;

		outpoi = filename;
		while (* poi != '\0' && * poi != '\t') {
			* outpoi ++ = * poi ++;
		}
		* outpoi = '\0';

		outpoi = search;
		poi ++;
		if (* poi == '/') {
			poi ++;
		}
		while (* poi != '\0' && (* poi != '/' || lastpat == '\\')) {
			if (* poi == '[' || * poi == ']' || * poi == '*') {
				* outpoi ++ = '\\';
			}
			lastpat = * poi ++;
			* outpoi ++ = lastpat;
		}
		* outpoi = '\0';
	    }
	}
	(void) close (tags_fd);
	clear_buffer ();
	clear_get_line ();
	modified = modif; /* don't let the tags file affect the modified flag */
	if (found == False) {
		error ("Identifier not found in tags file", NIL_PTR);
		return ERRORS;
	} else {
		return FINE;
	}
  } else {
	error ("No tags file present; apply the ctags command to your source files", NIL_PTR);
	return ERRORS;
  }
}

/*
 * Stag () opens file and moves to idf, using tags file
 */
void
Stag ()
{
  char idf_buf [MAX_CHARS];	/* identifier to search for */
  char new_file [maxLINE_LEN];	/* Buffer to hold new file name */
  char search [MAX_CHARS];	/* search expression */
  int lineno;

  if (hop_flag > 0) {
	if (get_string ("Enter identifier (to locate definition):", idf_buf, True, "") != FINE) {
		return;
	}
  } else {
	if (get_idf (idf_buf, cur_text, cur_line->text) == ERRORS) {
		return;
	}
  }

  if (get_tagline (idf_buf, new_file, search) == ERRORS) {
	return;
  }

  Pushmark ();

  if (strcmp (new_file, file_name) != 0) {
	if (save_text_load_file (new_file) == ERRORS) {
		return;
	}
  }

  if (* search >= '0' && * search <= '9') {
	(void) scan_int (search, & lineno);
	goline (lineno);
  } else {
	search_for (search, FORWARD);
  }
}


/*
   Set flags depending on file type.
 */
static
void
set_file_type_flags ()
{
  char * suffix = strrchr (file_name, '.');
  if (suffix != NIL_PTR) {
	suffix ++;
  } else {
	suffix = "";
  }
  if (streq (suffix, "html")
	|| streq (suffix, "htm")
	|| streq (suffix, "sgml")
	|| streq (suffix, "xml")
	|| streq (suffix, "jsp")
#ifdef msdos
	|| streq (suffix, "HTML")
	|| streq (suffix, "HTM")
	|| streq (suffix, "SGML")
	|| streq (suffix, "XML")
	|| streq (suffix, "JSP")
#endif
     )
  {
	dim_HTML = True;
  } else {
	dim_HTML = False;
  }
}


/*
 * return the mined command associated with the key value
 */
voidfunc
command (c)
  unsigned long c;
{
  if (c == (character) FUNcmd) {
	return keyproc;
  } else if (c < arrlen (key_map)) {
	return key_map [c];
  } else {
	return Scharacter;
  }
}


#ifdef unix

/*
 * Set window headline and icon text
 */
static
void
build_header (ws, fn, modf)
	char * ws;
	char * fn;
	char * modf;
{
  build_string (ws, window_string_code, fn, modf, fn, modf);
}

void
RD_window_title ()
{
  char window_string [MAX_CHARS];
  char filename_ok [maxLINE_LEN];
  char * filename_dispoi;
  char * filename_poi;

  filename_poi = file_name;
  filename_dispoi = filename_ok;
  while (* filename_poi != '\0') {
	if (utf8_screen == True && (* filename_poi & 0xC0) == 0x80) {
	} else if ((* filename_poi & 0x60) == 0
	   || (utf8_screen == True && (* filename_poi & 0x80) == 0x80)) {
		* filename_dispoi = '?';
	} else {
		* filename_dispoi = * filename_poi;
	}
	filename_poi ++;
	filename_dispoi ++;
  }
  * filename_dispoi = '\0';

  if (loading == False) {
	build_header (window_string, file_name [0] == '\0' ? "[buffer]" : filename_ok,
					modified == True ? mined_modf : "");
/*	putstring (window_string);	*/
/*	Mind! As long as screen buffer shared with file buffer:	*/
	write (output_fd, window_string, (unsigned int) length_of (window_string));
  }
}

void
clear_window_title ()
{
  char window_string [MAX_CHARS];

	build_header (window_string, " ", " ");
/*	putstring (window_string);	*/
/*	Mind! As long as screen buffer shared with file buffer:	*/
	write (output_fd, window_string, (unsigned int) length_of (window_string));
}

#endif


/*
 * Set the modified flag
 */
void
set_modified ()
{
  if (modified == False) {
	modified = True;
#ifdef unix
	RD_window_title ();
#endif
  }
}

/*
 * Redraw the screen
 */
void
RD_nobot ()
{
  reverse_off ();
  clearscreen ();

/* display page */
  display (0, top_line, last_y, y);

/* redraw scroll bar */
  if (disp_scrollbar == True) {
	(void) display_scrollbar (False);
  }

/* clear/redraw last line */
  set_cursor (0, YMAX);
  clear_lastline ();
  move_y (y);

#ifdef unix
  RD_window_title ();
#endif
}

void
RD ()
{
  RD_nobot ();
  if (stat_visible == True) {
	rd_bottom_line ();
  }
}

void
RD_y (y_pos)
  int y_pos;
{
  reverse_off ();
  clearscreen ();

/* display page */
  display (0, top_line, last_y, y_pos);

/* clear/redraw last line */
  set_cursor (0, YMAX);
  clear_lastline ();
  if (stat_visible == True) {
	rd_bottom_line ();
  }
}

/*
 * Adjust current window size after WINCH signal
 */
void
RDwin ()
{
  register LINE * current_line;

  winchg = False;
  getwinsize ();

  if (loading == False) {
	current_line = cur_line;
	reset (top_line, y);
/*	move_y (find_y_w_o_RD (current_line)); */
	move_address (cur_text, find_y_w_o_RD (current_line));
	RD_nobot ();
	if (MENU) {
		displaymenuline ();
		set_cursor_xy ();
		redrawmenu ();
	}
  }
  if (stat_visible == True) {
	rd_bottom_line ();
  }
  flush ();
}

void
change_screen_size (sb, keep_columns)
  FLAG sb;
  FLAG keep_columns;
{
  int index;
  int mode1;
#ifdef msdos_screenfunctions
  int mode2;
#endif

/* Experimental area: */
/*	set_screen_mode (mode1);	any available mode number */
/*	set_video_lines (mode1);	0/1/2: 200/350/400 lines */
	/* does not seem to have any effect */
/*	set_textmode_height (mode1);	0/1/2: font height 8/14/16 */
/*	set_grafmode_height (mode1, mode2);
		0/1/2: font height 8/14/16 1/2/3/n: 14/25/43/n lines */
/*	set_fontbank (f);		0..7 */
/**/
  if (hop_flag > 0) {
#ifdef msdos_screenfunctions
    if (keep_columns == True) {
      if (sb == BIGGER) {
	index = get_number ("Switch to font bank (0..7) ", '\0', & mode1);
	if (index == ERRORS) {
		return;
	}
	set_fontbank (mode1);
      } else {
	index = get_number ("Set character height (<= 32 pixels) ", '\0', & mode1);
	if (index == ERRORS) {
		return;
	}
	set_font_height (mode1);
      }
    } else {
      if (sb == BIGGER) {
#endif
	index = get_number ("Select video mode ", '\0', & mode1);
	if (index == ERRORS) {
		return;
	}
	set_screen_mode (mode1);
#ifdef msdos_screenfunctions
      } else {
	index = get_number ("Select graf font (0/1/2: font height 8/14/16) ", '\0', & mode1);
	if (index == ERRORS) {
		return;
	}
	index = get_number ("Select line number (1/2/3/n: 14/25/43/n) ", '\0', & mode2);
	if (index == ERRORS) {
		return;
	}
	set_grafmode_height (mode1, mode2);	/* 0/1/2: font height 8/14/16 */
					/* 1/2/3/n: 14/25/43/n lines */
      }
    }
#endif
  }
  else {
	resize_the_screen (sb, keep_columns);
  }
  RDwin ();
}
void
screenmorelines ()
{
  change_screen_size (BIGGER, True);
}
void
screenlesslines ()
{
  change_screen_size (SMALLER, True);
}
void
screenbigger ()
{
  change_screen_size (BIGGER, False);
}
void
screensmaller ()
{
  change_screen_size (SMALLER, False);
}

void
LNCI ()
{
  switch_textmode_height (True);
  RDwin ();
}

void
LNSW ()
{
  switch_textmode_height (False);
  RDwin ();
}

/*
 * Ignore this keystroke.
 */
void
I ()
{
}

/*
 * Fortifying 'HOP' key.
 */
void
HOP ()
{
  hop_flag = 2;
  if (MENU) {
	displayflags ();
	set_cursor_xy ();
	flush ();
  }
  if (! char_ready_within (500)) {
	status_msg ("Continue HOP command (next command fortified) ...");
  }
}

/*
 * Cancel prefix function.
 */
void
CANCEL ()
{
  hop_flag = 0;
  clear_status ();
}

/*
 * Call proc associated with function key.
 */
void
FUNKEY ()
{
  (* keyproc) ('\0');
  keyproc = I;
}

/*
 * Toggle insert/overwrite mode.
 */
void
TOGINS ()
{
  if (insert_mode == True) {
	insert_mode = False;
  } else {
	insert_mode = True;
  }
}


#define cmd_char(c)	(c < '\040' ? c + '\100' : (c >= '\140' ? c - '\040' : c))

/*
 * Interpret control-Q commands. Most can be implemented with the Hop function.
 */
void
ctrlQ ()
{
  character c;
  void (* func) ();

  if (! char_ready_within (500)) {
	status_msg ("^Q: blockBegin Find replAce goto<n>mark HOP...");
  }
  if (quit == True) {
	return;
  }

  c = readcharacter ();
  if (quit == True) {
	return;
  }

  clear_status ();
  if ('0' <= c && c <= '9') {
	GOMAn ((int) c - (int) '0');
	return;
  }
  if (c == '\033' || c == quit_char) {
	CANCEL ();
	return;
  }
  switch (cmd_char (c)) {
	case 'B' : {GOMA () ; return;}
	case 'K' : { ; return;}		/* not exactly WS function */
	case 'P' : { ; return;}		/* not exactly WS function */
	case 'V' : { ; return;}		/* not exactly WS function */
	case 'W' :			/* not exactly WS function */
	case 'Z' :			/* not exactly WS function */
	case 'Y' :
	case '\177' : {
			func = command (c);
			hop_flag = 1;
			(* func) (c);
			return;
		      }
	case 'F' : {if (hop_flag > 0) {
			SRV ();
		    } else {
			SFW ();
		    }
		    return;
		   }
	case 'A' : {if (hop_flag > 0) {
			REPL ();
		    } else {
			GR ();
		    }
		    return;
		   }
	case 'Q' : {REPT (' '); return;}	/* not exactly WS function */
	case 'L' :			/* not exactly WS function */
/*
^Q: B/K top/bottom block
    P last position
    W/Z continuous scroll
    V last find or block
    Y/DEL delete line right/left
    0-9 marker
    F find
    A replace
    Q repeat next key/command
    L find misspelling
*/
	default : {
		func = command (c);
		if ((c < ' ') || ((voidfunc) func == (voidfunc) FUNKEY)) {
			/* (voidfunc) is an identity cast here.
			   It seems to be required for the sake of the 
			   apparently totally rotten microvax C compiler */
			hop_flag = 1;
			(* func) (c);
		} else {
			BAD (c);
		}
		return;
	}
  }
}

/*
 * Interpret control-K commands.
 */
void
ctrlK ()
{
  character c;

  if (! char_ready_within (500)) {
	status_msg ("^K: Save Done eXit Quit Read Log <n>mark / block: B/K mark Cop Ydel moV Wr...");
  }
  if (quit == True) {
	return;
  }

  c = readcharacter ();
  if (quit == True) {
	return;
  }

  clear_status ();
  if ('0' <= c && c <= '9') {
	MARKn ((int) c - (int) '0');
	return;
  }
  if (c == '\033' || c == quit_char) {
	CANCEL ();
	return;
  }
  switch (cmd_char (c)) {
	case 'S' : {WTU (); return;}
	case 'D' : {EXFILE (); return;}
	case 'X' : {EXMINED (); return;}
	case 'Q' : {QUED (); return;}
	case 'B' : {MARK () ; return;}
	case 'K' : {COPY () ; return;}	/* not exactly WS function */
	case 'H' : { ; return;}		/* not exactly WS function */
	case 'C' : {PASTE () ; return;}	/* not exactly WS function */
	case 'Y' : {CUT () ; return;}	/* not exactly WS function */
	case 'V' : {PASTE (); return;}	/* not exactly WS function */
	case 'W' : {WB (); return;}	/* not exactly WS function */
	case 'N' : { ; return;}		/* not exactly WS function */
	case 'R' : {INSFILE (); return;}
	case 'L' : {CHDI (); return;}
/*
^K  0-9 set/hide marker
    B/K block begin/end
    H block hide
    C/Y/V/W block copy/delete/move/write
    N column block
*/
	default : {
		BAD (c);
		return;
	}
  }
}

/*
 * Interpret control-O commands.
 */
void
ctrlO ()
{
  character c;

  if (! char_ready_within (500)) {
	status_msg ("^O: L/R left/right margins...");
  }
  if (quit == True) {
	return;
  }

  c = readcharacter ();
  if (quit == True) {
	return;
  }

  clear_status ();
  if ('0' <= c && c <= '9') {
	return;
  }
  if (c == '\033' || c == quit_char) {
	CANCEL ();
	return;
  }
  switch (cmd_char (c)) {
	case 'L' : {ADJLM (); return;}
	case 'R' : {ADJRM (); return;}
	case 'G' : {ADJFLM () /* actually paragraph tab */; return;}
/*
^O  L/R/M set left/right margin /release
    I/N set/clear tab
    F ruler from line
    C center line
    S set line spacing
    W toggle word wrap
    T toggle ruler line
    J toggle justify
    V     vari-tabs
    H     hyph-help
    E     soft hyph
    D     print display
    P     page break
*/
	default : {
		BAD (c);
		return;
	}
  }
}

/*
 * Set marker / go to marker.
 */
void
MARKER ()
{
  character c;

/*  if (! char_ready_within (500))*/
  	status_msg ("0..9: set marker / , or blank: default marker");
/*  if (quit == True) return;*/

  c = readcharacter ();
  if (quit == True) {
	return;
  }

  clear_status ();
  if (c == '\033' || c == quit_char) {
	CANCEL ();
	return;
  }
  if ('0' <= c && c <= '9') {
	MARKn ((int) c - (int) '0');
	return;
  }
  if (c == ',' || c == '\'' || c == ' ' || c == ']' || c == '\035') {
	MARK ();
	return;
  }
  BAD (c);
  return;
}

void
GOMARKER ()
{
  character c;

/*  if (! char_ready_within (500))*/
  	status_msg ("0..9: go marker / blank: default marker");
/*  if (quit == True) return;*/

  c = readcharacter ();
  if (quit == True) {
	return;
  }

  clear_status ();
  if (c == '\033' || c == quit_char) {
	CANCEL ();
	return;
  }
  if ('0' <= c && c <= '9') {
	GOMAn ((int) c - (int) '0');
	return;
  }
  if (c == ',' || c == '.' || c == 'g' || c == 'G' || c == '\'' || 
      c == ' ' || c == ']' || c == '\035') {
	GOMA ();
	return;
  }
  BAD (c);
  return;
}

/*
 * ...MENU () opens the respective menu
 */
void
FILEMENU ()
{
  if (keyshift & shift_mask) {
	keyshift = '0';
	QUICKMENU ();
  } else {
	openmenu (0);
  }
}

void
EDITMENU ()
{
  openmenu (1);
}

void
SEARCHMENU ()
{
  openmenu (2);
}

void
EXTRAMENU ()
{
  openmenu (3);
}

void
PARAMENU ()
{
  openmenu (4);
}

void
QUICKMENU ()
{
  QUICKMEN (x, y);
}

/*
   Toggle TAB width.
 */
void
toggletab ()
{
  if (tabsize == 4) {
	tabsize = 8;
  } else {
	tabsize = 4;
  }
  RDwin ();
}

void
UNDO ()
{
  error ("Undo not implemented", NIL_PTR);
}

/*
 * Interpret Escape commands.
 */
void
ESCAPE ()
{
  unsigned long c;
  voidfunc func;

  if (! char_ready_within (500)) {
	status_msg ("ESC(exit) TAB,blank(menu) q(uit /,\\(search) (match r(eplace g(oto h(elp ...");
  }
  if (quit == True) {
	return;
  }

  c = readcharacter ();
  if (quit == True) {
	return;
  }

  clear_status ();

  if ('0' <= c && c <= '9') {
	REPT (c);
	return;
  }

  switch (c) {
	case '\033' : {EXED (); return;}
	case '\r' :
	case '\n' : {Popmark (); return;}
	case 'q' : {QUED (); return;}
	case '/' : {SFW (); return;}
	case '\\' : {SRV (); return;}
	case 'R' : {LR (); return;}
	case 'r' : {REPL (); return;}
	case 'w' : {WT (); return;}
	case 'W' : {WTU (); return;}
	case 'v' : {VIEW (); return;}
	case 'E' : {EDITmode (); return;}
	case 'V' : {VIEWmode (); return;}
	case 'g' : {GOTO (); return;}
	case 'h' : {HELP (); return;}
	case '?' : {FS (); return;}
	case '.' : {RDwin (); return;}
	case 'm' : {MARKER (); return;}
	case '\'' : {GOMARKER (); return;}
	case 'i' : {INSFILE (); return;}
	case 'b' : {WB (); return;}
	case '=' : {REPT (' '); return;}
	case 'z' : {SUSP (); return;}
	case 'd' : {CHDI (); return;}
	case '!' : {SH (); return;}
	case '^' : {MARK (); return;}
	case ']' : {GOMA (); return;}
	case 'n' : {NN (); return;}
	case 'c' : {CMD (); return;}
	case 'u' : {display_code (); return;}
	case 'U' : {changeuni (); return;}
	case 'X' : {changehex (); return;}
	case 'A' : {changeoct (); return;}
	case 'D' : {changedec (); return;}
	case '+' : {NXTFILE (); return;}
	case '-' : {PRVFILE (); return;}
	case '#' : {NTHFILE (); return;}
	case '%' : {screensmaller (); return;}
	case '&' : {screenbigger (); return;}
	case 'l' : {screenlesslines (); return;}
	case 'L' : {screenmorelines (); return;}
	case 'J' : {JUS (); return;}
	case 'j' : {JUSclever (); return;}
	case '<' : {ADJLM (); return;}
	case ';' : {ADJFLM (); return;}
	case ':' : {ADJNLM (); return;}
	case '>' : {ADJRM (); return;}
	case 'P' : {ADJPAGELEN (); return;}
	case 'T' : {toggletab (); return;}
	case 'H' : {HTML (); return;}
	case '_' : {UML (language_tag); return;}
	case (character) '' :
	case (character) '' :
	case (character) '' :
	case (character) '' : {UML ('g'); return;}
	case (character) '' :
	case (character) '' :
	case (character) '' :
	case (character) '' :
	case (character) '' : {UML ('f'); return;}
	case (character) '' :
	case (character) '' :
	case (character) '' : {UML ('d'); return;}
	case 'C' : {LOWCAP (); return;}
	case '(' : {SCORR (); return;}
	case ')' : {SCORR (); return;}
	case '{' : {SCORR (); return;}
	case '}' : {SCORR (); return;}
	case 't' : {Stag (); return;}
	case 'a' : {toggleappend (); return;}
	case 'k' : {toggleKEYMAP (); return;}
	case 'K' : {setupKEYMAP (); return;}
	case 'Q' : if (utf8_text == True) {
			if (hop_flag > 0) {
				quote_type_up ();
			} else {
				handleQuotemenu (0);
			}
			displayflags ();
		   } else {
			error ("Smart quotes not active", NIL_PTR);
		   }
		   return;
/*	case 'o' : {TOGINS (); return;}	*/
/*	case '\t' : {FILEMENU (); return;}	*/
	case ' ' : {QUICKMENU (); return;}
	case 'f' : {FILEMENU (); return;}
	case 'e' : {EDITMENU (); return;}
	case 's' : {SEARCHMENU (); return;}
	case 'x' : {EXTRAMENU (); return;}
	case 'p' : {PARAMENU (); return;}
	case ',' : {GR (); return;}
/*
	case 'e' : {EDIT (); return;}
	case 's' : {GR (); return;}
	case 'p' : {PBUF (); return;}
*/
	default : {
		if (c == quit_char) {
			CANCEL ();
			return;
		}
		func = command (c);
		if ((c < ' ') || ((voidfunc) func == (voidfunc) FUNKEY)) {
			/* (voidfunc) is an identity cast here.
			   It seems to be required for the sake of the 
			   apparently totally rotten microvax C compiler */
			hop_flag = 1;
			(* func) (c);
		} else {
			BAD (c);
		}
		return;
	}
  }
}

/*
 * Interpret emacs meta commands.
 */
void
META ()
{
  unsigned long c;
  voidfunc func;

  if (! char_ready_within (500)) {
	status_msg ("Meta ESC(exit) TAB,blank(menu) /,\\(search) (match ...");
  }
  if (quit == True) {
	return;
  }

  c = readcharacter ();
  if (quit == True) {
	return;
  }

  clear_status ();

  if ('0' <= c && c <= '9') {
	REPT (c);
	return;
  }

  switch (c) {
	/* emacs meta commands */
	case 'v' : {PU (); return;}
	case 'f' : {MNW (); return;}
	case 'b' : {MPW (); return;}
	case 'a' : {BSEN (); return;}
	case 'e' : {ESEN (); return;}
	case '<' : {BFILE (); return;}
	case '>' : {EFILE (); return;}
	case 'd' : {DNW (); return;}
	case 'k' : {MARK (); ESEN (); CUT (); return;}
	case 'w' : {COPY (); return;}
	case 'y' : {YANKRING (); return;}
	case 'z' : {SUSP (); return;}
	case '%' : {REPL (); return;}
	case 'x' : {ESCAPE (); return;}
	case 'u' : {hop_flag = 1; UPPER (); return;}
	case 'l' : {hop_flag = 1; LOWER (); return;}
	case 'c' : {CAPWORD (); return;}
	case '.' : {Stag (); return;}

#ifdef no_emacs
	/* hidden mined commands */
	case '.' : {RDwin (); return;}
	case 'd' : {CHDI (); return;}
	case 'u' : {display_code (); return;}
	case 'c' : {CMD (); return;}
	case 'f' : {FILEMENU (); return;}
	case 'e' : {EDITMENU (); return;}
	case 'x' : {EXTRAMENU (); return;}
	case '?' : {FS (); return;}

	case '<' : {ADJLM (); return;}
	case '>' : {ADJRM (); return;}
	case 'w' : {WT (); return;}
	case 'v' : {VIEW (); return;}
	case 'b' : {WB (); return;}
	case 'a' : {toggleappend (); return;}
	case 'k' : {toggleKEYMAP (); return;}
	case '%' : {screensmaller (); return;}
	case 'l' : {screenlesslines (); return;}

	/* remaining mined commands */
	case '\033' : {EXED (); return;}
	case '\r' :
	case '\n' : {Popmark (); return;}
	case '/' : {SFW (); return;}
	case '\\' : {SRV (); return;}
	case '\'' : {GOMARKER (); return;}
	case '=' : {REPT (' '); return;}
	case '!' : {SH (); return;}
	case '^' : {MARK (); return;}
	case ']' : {GOMA (); return;}
	case '+' : {NXTFILE (); return;}
	case '-' : {PRVFILE (); return;}
	case '#' : {NTHFILE (); return;}
	case '&' : {screenbigger (); return;}
	case ';' : {ADJFLM (); return;}
	case ':' : {ADJNLM (); return;}
	case '_' : {UML (language_tag); return;}
	case '(' : {SCORR (); return;}
	case ')' : {SCORR (); return;}
	case '{' : {SCORR (); return;}
	case '}' : {SCORR (); return;}
	case ' ' : {QUICKMENU (); return;}
	case ',' : {GR (); return;}

	case 'q' : {QUED (); return;}
	case 'R' : {LR (); return;}
	case 'r' : {REPL (); return;}
	case 'W' : {WTU (); return;}
	case 'E' : {EDITmode (); return;}
	case 'V' : {VIEWmode (); return;}
	case 'g' : {GOTO (); return;}
	case 'h' : {HELP (); return;}
	case 'm' : {MARKER (); return;}
	case 'i' : {INSFILE (); return;}
	case 'n' : {NN (); return;}
	case 'U' : {changeuni (); return;}
	case 'X' : {changehex (); return;}
	case 'A' : {changeoct (); return;}
	case 'D' : {changedec (); return;}
	case 'L' : {screenmorelines (); return;}
	case 'J' : {JUS (); return;}
	case 'j' : {JUSclever (); return;}
	case 'P' : {ADJPAGELEN (); return;}
	case 'T' : {toggletab (); return;}
	case 'H' : {HTML (); return;}
	case 'C' : {LOWCAP (); return;}
	case 't' : {Stag (); return;}
	case 'K' : {setupKEYMAP (); return;}
	case 'Q' : if (utf8_text == True) {
			if (hop_flag > 0) {
				quote_type_up ();
			} else {
				handleQuotemenu (0);
			}
			displayflags ();
		   } else {
			error ("Smart quotes not active", NIL_PTR);
		   }
		   return;
	case 's' : {SEARCHMENU (); return;}
	case 'p' : {PARAMENU (); return;}
/*	case 'o' : {TOGINS (); return;}	*/
/*	case '\t' : {FILEMENU (); return;}	*/
#endif

	default : {
		if (c == quit_char) {
			CANCEL ();
			return;
		}
		func = command (c);
		if ((c < ' ') || ((voidfunc) func == (voidfunc) FUNKEY)) {
			/* (voidfunc) is an identity cast here.
			   It seems to be required for the sake of the 
			   apparently totally rotten microvax C compiler */
			hop_flag = 1;
			(* func) (c);
		} else {
			BAD (c);
		}
		return;
	}
  }
}

/*
 * Interpret emacs ^X commands.
 */
void
EMAX ()
{
  unsigned long c;

  if (! char_ready_within (500)) {
	status_msg ("^X ...");
  }
  if (quit == True) {
	return;
  }

  c = readcharacter ();
  if (quit == True) {
	return;
  }

  clear_status ();

  if (command (c) == MARK) {
	Popmark ();
	return;
  }
  switch (c) {
	case 'u' : {UNDO (); return;}
	case '' : {EXED (); return;}
	case '' : {WT (); return;}
	case '' : {SAVEAS (); return;}
	case '' : {PRVFILE (); return;}
	case '' : {EDIT (); return;}
	case '\032' : {SUSP (); return;}
	case '' : {REPT (' '); return;}
	case 'i' : {INSFILE (); return;}
	case 's' : {WT (); return;}
	case 'k' : {QUED (); return;}
	case '=' : {FS (); return;}
	case '[' : {PU (); return;}
	case ']' : {PD (); return;}
	default : {
		if (c == quit_char) {
			CANCEL ();
			return;
		}
		BAD (c);
	}
  }
}

/*
 * MOUSEescape () is invoked after a mouse escape sequence with 
 * coordinates and button info already stored in 
 * mouse_xpos, mouse_ypos, and mouse_button.
 * Then it performs a menu or other mouse controlled function.
 */
void
MOUSEescape ()
{
  int proz;

  if (mouse_button == wheelup) {
	if (mouse_shift & shift_button) {
		PU ();
	} else if (mouse_shift & control_button) {
		SU ();
	} else {
		for (proz = 0; quit == False && proz < wheel_scroll && proz < YMAX; proz ++) {
			if (proz > 0 && disp_scrollbar == True) {
				(void) display_scrollbar (True);
			}
			SU ();
		}
	}
  } else if (mouse_button == wheeldown) {
	if (mouse_shift & shift_button) {
		PD ();
	} else if (mouse_shift & control_button) {
		SD ();
	} else {
		for (proz = 0; quit == False && proz < wheel_scroll && proz < YMAX; proz ++) {
			if (proz > 0 && disp_scrollbar == True) {
				(void) display_scrollbar (True);
			}
			SD ();
		}
	}
  } else if (disp_scrollbar == True && mouse_xpos == XMAX) {
	if (mouse_button == leftbutton) {
		PD ();
	} else if (mouse_button == rightbutton) {
		PU ();
	} else if (mouse_button == middlebutton
		   || (mouse_button == releasebutton
		       && mouse_lastbutton == middlebutton)
		   || mouse_button == movebutton
		  ) {
		proz = (mouse_ypos + 1) * 100 / YMAX;
		if (proz > 100) {
			goproz (100);
		} else {
			goproz ((mouse_ypos + 1) * 100 / YMAX);
		}
	}
  } else if (mouse_button == movebutton) {
	/* ignore */
  } else if (mouse_ypos == -1) {	/* menu stuff */
	openmenuat (mouse_xpos);
  } else if (mouse_ypos == YMAX) {
	if (mouse_button == leftbutton) {
		PD ();
	} else if (mouse_button == middlebutton) {
		FS ();
	} else if (mouse_button == rightbutton) {
		PU ();
	}
  } else if (quickmenu == True) {
	if (mouse_ypos > last_y) {
		mouse_ypos = last_y;
	}
	if (mouse_button == leftbutton) {
		move_to (mouse_xpos, mouse_ypos);
		report_release = True;
	} else if (mouse_button == middlebutton) {
		FS ();
	} else if (mouse_button == rightbutton) {
		move_to (mouse_xpos, mouse_ypos);
		QUICKMEN (x, y);
	} else if (mouse_button == releasebutton 
		&& mouse_lastbutton == leftbutton 
		&& (mouse_xpos != mouse_lastxpos 
		    || mouse_ypos != mouse_lastypos)) {
		MARK ();
		move_to (mouse_xpos, mouse_ypos);
		COPY ();
	}
  } else {
	if (mouse_ypos > last_y) {
		mouse_ypos = last_y;
	}
	move_to (mouse_xpos, mouse_ypos);
	if (mouse_button == leftbutton) {
		MARK ();
	} else if (mouse_button == middlebutton) {
		PASTE ();
	} else if (mouse_button == rightbutton) {
		COPY ();
	}
  }
}

/*
 * REPT () prompts for a count and wants a command after that. It repeats the
 * command count times. If a ^\ is given during repeating, stop looping and
 * return to main loop.
 */
void
REPT (firstdigit)
  char firstdigit;
{
  register int count;
  register void (* func) ();
  long cmd;
  int number;

  hop_flag = 0;
  if (firstdigit >= '0' && firstdigit <= '9') {
     cmd = get_number ("Please continue repeat count...", firstdigit, & number);
     if (firstdigit != '0' && number < 10) {
	error ("Invalid repeat count after ESC <digit>", NIL_PTR);
	return;
     }
  } else {
     cmd = get_number ("Please enter repeat count...", '\0', & number);
  }
  if (cmd == ERRORS) {
	return;
  }

  func = command (cmd);
  if ((voidfunc) func == (voidfunc) I) {	/* Function assigned? */
	/* (voidfunc) is an identity cast here. It seems to be required for
	   the sake of the apparently totally rotten microvax C compiler */
	clear_status ();
	return;
  }
  if ((voidfunc) func == (voidfunc) FUNKEY) {
	/* (voidfunc) is an identity cast here. It seems to be required for
	   the sake of the apparently totally rotten microvax C compiler */
/*	func = * keyproc;	*/
	func = keyproc;
	keyproc = I;
	cmd = '\0';
  }

  if ((voidfunc) func == (voidfunc) S) {
	func = Scharacter;
  }
  count = number;
  while (count -- > 0 && quit == False) {
	if (stat_visible == True) {
		clear_status ();
	}
	(* func) (cmd);
	flush ();
  }

  if (quit == True) {		/* Abort has been given */
	error ("Repeat aborted", NIL_PTR);
  } else {
	clear_status ();
  }
}

/*
 * Complains to illegal commands and eats up illegal escape sequences.
 */
void
BAD (c)
  character c;
{
  static char message2 [] = "'**' - type a blank";

  if (c < ' ') {
	message2 [1] = '^'; message2 [2] = c + '@';
  } else {
	message2 [1] = ' '; message2 [2] = c;
  }
/*  error ("Unknown command ", message2);
*/
  error ("Unknown command - type a blank", NIL_PTR);
  while (readcharacter () != ' ' && quit == False) {
	ring_bell ();
	flush ();
  }
  clear_status ();
}

/*
 * Change working directory.
 */
void
CHDI ()
{
  char new_dir [maxLINE_LEN];	/* Buffer to hold new dir. name */

  if (restricted == True) {
	restrictederr ();
	return;
  }

#ifdef pc
  build_string (text_buffer, "Drive/Directory: %s, change to:", unnull (getcwd (new_dir, maxLINE_LEN)));
#else
  build_string (text_buffer, "Directory: %s, change to:", unnull (getcwd (new_dir, maxLINE_LEN)));
#endif

  if (get_file (text_buffer, new_dir) != FINE) {
	return;
  }
#ifdef msdos
  if (new_dir [0] != '\0' && new_dir [1] == ':')
	if (new_dir [2] == '\0') {
		new_dir [2] = '.';	/* change to current dir. of drive */
		new_dir [3] = '\0';
	}
#endif
  if (chdir (new_dir) == 0) {
#ifdef msdos
	if (new_dir [0] != '\0' && new_dir [1] == ':')
		setdisk (((int) new_dir [0] & (int) '\137') - (int) 'A');
	RD ();	/* disk error dialog may be on screen after chdir */
#endif
	clear_status ();
	overwriteOK = False;	/* Same file base name ... */
	writable = True;
/*	if (viewmode == False)	*/
	    set_modified ();	/* would mean different file now */
  } else {
#ifdef msdos
	RD ();	/* disk error dialog may be on screen */
#endif
	error ("Could not change work dir: ", serror ());
  }
}

/*
 * Print file status.
 */
void
FSTAT ()
{
  fstatus (file_name [0] ? "" : "[buffer]", -1L, -1L);
}
void
FS ()
{
  if (hop_flag > 0) {
	if (fstat_always == False) {
		fstat_always = True;
	} else {
		fstat_always = False;
	}
  } else {
	FSTAT ();
  }
}


/*
 * Checkout (from version managing system).
 */
void
checkout ()
{
  int save_cur_column;
  int save_cur_line;
  char syscommand [maxLINE_LEN];	/* Buffer for full system command */
  int sysres;

	if (modified == True) {
		if (write_text (False) != FINE) {
			return;
		}
	}

	/* save current position */
	save_cur_line = line_number;
	save_cur_column = get_cur_col ();

	/* try to check out */
	raw_mode (OFF);
	build_string (syscommand, "co %s", file_name);
	sysres = system (syscommand);
	sleep (1);
	raw_mode (ON);
	if (sysres != 0) {
		error ("Checkout failed", NIL_PTR);
	}

	/* reload file */
	initialize ();
	clearscreen ();
	load_file_position (file_name, True, save_cur_line, save_cur_column);
}

/*
 * Checkin (to version managing system).
 */
void
checkin ()
{
  char syscommand [maxLINE_LEN];	/* Buffer for full system command */
  int sysres;

	if (modified == True) {
		if (write_text (False) != FINE) {
			return;
		}
	}

	/* try to check in */
	raw_mode (OFF);
	build_string (syscommand, "ci %s", file_name);
	sysres = system (syscommand);
	sleep (1);
	raw_mode (ON);
	RDwin ();
	if (sysres != 0) {
		error ("Checkin failed", NIL_PTR);
	}
}


static FLAG save_viewonly;
static FLAG save_restricted;
static char save_file_name [maxLINE_LEN];
static FLAG viewing_help = False;
static int save_cur_column;
static int save_cur_line;

static
void
view_help (helpfile, item)
  char * helpfile;
  char * item;
{
  char searchstring [maxLINE_LEN];

  /* unless already viewing help, save edited text */
  if (viewing_help == False) {
	if (modified == True) {
		if (write_text (False) != FINE) {
			return;
		}
	}

	/* save current position */
	save_cur_line = line_number;
	save_cur_column = get_cur_col ();

	/* save editing mode and file name */
	save_viewonly = viewonly;
	save_restricted = restricted;
	copy_string (save_file_name, file_name);

	/* set mode appropriate for viewing online help */
	viewonly = True;
	restricted = True;
	viewing_help = True;

	/* load online help file */
	initialize ();
	clearscreen ();
	load_file_position (helpfile, True, -1, 0);
  }

  /* position to selected help topic */
  BFILE ();
  build_string (searchstring, "mined help topic '%s'", item);
  search_for (searchstring, FORWARD);
}

static
void
end_view_help ()
{
  viewonly = save_viewonly;
  restricted = save_restricted;
  viewing_help = False;

  initialize ();
  clearscreen ();
  load_file_position (save_file_name, True, save_cur_line, save_cur_column);
}

void
show_help (item)
  char * item;
{
#ifndef pc
  char syscommand [maxLINE_LEN];	/* Buffer for full system command */
  int sysres;
#endif
  char * helpfile;
  int hf = -1;

  helpfile = (char *) getenv ("MINEDHELPFILE");
  if (helpfile != NIL_PTR && * helpfile != '\0') {
	hf = open (helpfile, O_RDONLY);
  }
  if (hf == -1) {
#include "minedhlp.h"
	hf = open (helpfile, O_RDONLY);
  }
  if (hf == -1) {
	helpfile = "/usr/local/share/help/mined.hlp";
	hf = open (helpfile, O_RDONLY);
  }
  if (hf == -1) {
	helpfile = "/usr/local/info/mined.hlp";
	hf = open (helpfile, O_RDONLY);
  }
  if (hf == -1) {
	helpfile = "/usr/share/doc/packages/mined/mined.hlp";
	hf = open (helpfile, O_RDONLY);
  }
  if (hf == -1) {
	helpfile = "/usr/share/info/mined.hlp";
	hf = open (helpfile, O_RDONLY);
  }
  if (hf == -1) {
	helpfile = "/opt/gnu/share/help/mined.hlp";
	hf = open (helpfile, O_RDONLY);
  }
  if (hf == -1) {
	helpfile = "/opt/gnu/info/mined.hlp";
	hf = open (helpfile, O_RDONLY);
  }

  if (hf == -1) {
	status_msg ("Help file not found; configure MINEDHELPFILE in environment!");
	return;
#ifndef pc
  } else if (! (hop_flag > 0 || viewing_help == True)) {
	(void) close (hf);
/*
	build_string (syscommand, "unzip -p %s %s | LESS=\"QMPMMined help topic '%s'?e (end):?pb (%%pb\\%%).. - type q to return to mined $ +Gg\" ${PAGER-less}", 
			helpfile, item, item);
*/
	build_string (syscommand, 
		"less '-QMPMMined help?e (end):?pb (%%pb\\%%).. - type \"'\\''h\" for help topic \"%s\", q to return to mined '"
		" +\"/mined help topic '%s'\nkmhG'h\" %s",
			item, item, helpfile);

	clear_status ();
	set_cursor (0, YMAX);
#ifdef unix
	clear_window_title ();
#endif
	raw_mode (OFF);

	sysres = system (syscommand);

	raw_mode (ON);
	RDwin ();
	if (sysres != 0) {
		error ("Help item not found in help file", NIL_PTR);
	}
#endif
  } else {
	(void) close (hf);
	view_help (helpfile, item);
  }
}

/*
 * Interactive Help
 */
void
HELP ()
{
  character c;

  status_msg ("Help on: i(ntroduction k(eyboard f(unction-keys c(ommands m(enu");
  if (quit == True) return;

  c = readcharacter ();
  if (quit == True) return;

  clear_status ();
  switch (c) {
	case '\033': return;
	case 'i': show_help ("introduction"); return;
	case 'k': show_help ("keyboard"); return;
	case 'f': show_help ("function-keys"); return;
	case 'c': show_help ("commands"); return;
	case 'm': show_help ("menu"); return;
	default: {
		if (c == quit_char) {
			return;
		}
		status_msg ("No such help available");
		return;
	}
  }
}

/*
 * Print buffer
 */
void
PBUF ()
{
  int fd;
  char cmd [maxLINE_LEN];	/* Buffer for print command */

  if ((fd = yankfile (READ, False)) == ERRORS) {
	error ("Buffer is empty", NIL_PTR);
	return;
  }
  (void) close (fd);
  build_string (cmd, getenv ("MINEDPRINT") ?
		(char *) getenv ("MINEDPRINT") : printcommand, yank_file);
/* Turbo-C wants the cast here since getenv must be declared as far * */
  clear_status ();
  set_cursor (0, YMAX);
  flush ();
  system (cmd);
  sleep (1);
  RDwin ();
}

/*
 * Pipe buffer
 */
void
CMD ()
{
  int fd;
  char cmd [maxLINE_LEN];	/* Buffer for command */
  char command [maxLINE_LEN];	/* Buffer for full command */

  if (restricted == True) {
	restrictederr ();
	return;
  }

  if ((fd = yankfile (READ, False)) == ERRORS) {
	error ("Buffer is empty", NIL_PTR);
	return;
  }
  (void) close (fd);
  if (get_string ("Command with buffer as input:", cmd, True, "") != FINE) {
	return;
  }
  build_string (command, "%s < %s", cmd, yank_file);
  clear_status ();
  set_cursor (0, YMAX);
#ifdef unix
  clear_window_title ();
#endif
  raw_mode (OFF);

  system (command);

  sleep (1);
  raw_mode (ON);
  RDwin ();
}

/*
 * Called if an operation is not implemented on this system
 */
static
void
notavailable ()
{
  error ("Command not available", NIL_PTR);
}

/*
 * Suspend editor after writing back the file.
 */
void
SUSP ()
{
  if (restricted == True) {
	restrictederr ();
	return;
  }

  if (cansuspendmyself == True) {
	if (hop_flag == 0 && modified == True) {
		if (write_text (False) == ERRORS) {
			return;
		}
	}
	set_cursor (0, YMAX);
#ifdef unix
	clear_window_title ();
#endif
	raw_mode (OFF);

	suspendmyself ();
	raw_mode (ON);
	clear_status ();
	RDwin ();
  } else {
	notavailable ();
  }
}

/*
 * Call an interactive shell.
 */
void
SH ()
{

#ifdef unix
#define SHimplemented
  register int w;
  int pid;
  int status;
  int waiterr;

  if (restricted == True) {
	restrictederr ();
	return;
  }

#ifdef FORK
  switch (pid = fork ()) {
#else
  switch (pid = vfork ()) {
#endif
	case -1:			/* Error */
		error ("Cannot fork: ", serror ());
		return;
	case 0:				/* This is the child */
		set_cursor (0, YMAX);
		putchar ('\n');
		clear_window_title ();
		raw_mode (OFF);

		if (rpipe == True) {	/* Fix stdin */
			if (close (STD_IN) < 0) {
				_exit (126);
			}
			if (open ("/dev/tty", O_RDONLY, 0) < 0) {
				_exit (126);
			}
		}
		execl (getenv ("SHELL"), getenv ("SHELL"), 0);
		_exit (127);	/* Exit with 127 */
		/* NOTREACHED */
	default:			/* This is the parent */
		do {
			w = wait (& status);
		} while (w != -1 && w != pid);
		waiterr = geterrno ();
  }

  raw_mode (ON);
  RDwin ();

  if (w == -1) {
	error ("Wait error: ", serrorof (waiterr));
	if (((status >> 8) == 127) || ((status >> 8) == 126)) sleep (2);
  }
  if ((status >> 8) == 127) {		/* Child died with 127 */
	error (getenv ("SHELL"), ": error invoking ${SHELL} (not found / not enough memory ?)");
  } else if ((status >> 8) == 126) {
	error ("Cannot open /dev/tty as fd #0", NIL_PTR);
  }
#endif /* unix */


#ifdef msdos
#define SHimplemented
  char old_dir [maxLINE_LEN];	/* Buffer to hold dir. name */

  if (restricted == True) {
	restrictederr ();
	return;
  }

  (void) getcwd (old_dir, maxLINE_LEN);

  set_cursor (0, YMAX);
  raw_mode (OFF);

  system (getenv ("COMSPEC"));

  raw_mode (ON);
  clear_status ();
  RDwin ();

  if (chdir (old_dir) == 0) {
	if (old_dir [0] != '\0' && old_dir [1] == ':')
		setdisk (((int) old_dir [0] & (int) '\137') - (int) 'A');
	RD ();	/* disk error dialog may be on screen after chdir */
  } else {
	overwriteOK = False;	/* Same file base name ... */
	writable = True;
/*	if (viewmode == False)	*/
	    set_modified ();	/* would mean different file now */
	RD ();	/* disk error dialog may be on screen */
	error ("Could not reset previous work dir: ", serror ());
  }
#endif /* msdos */


#ifdef vms
#define SHimplemented
  if (restricted == True) {
	restrictederr ();
	return;
  }

/* Who can tell me why this hangs the process after return from the CLI ?
  set_cursor (0, YMAX);
  raw_mode (OFF);

  system ("SPAWN");

  raw_mode (ON);
  clear_status ();
  RDwin ();
*/
  notavailable ();
#endif


#ifndef SHimplemented
  notavailable ();
#endif
}


/*======================================================================*\
|*			Main						*|
\*======================================================================*/

char * minedopt;

static
void
WordStar_keys ()
{
  int i;

  for (i = 0; i < 32; i ++) {
	key_map [i] = ws_key_map [i];
  }
  control_prefix = '\020';	/* ^P */
  emulation = 'w';
}

static
void
set_emacs_mode ()
{
  int i;

  for (i = 0; i < 32; i ++) {
	key_map [i] = emacs_key_map [i];
  }
  key_map ['\177'] = DPC;
  control_prefix = '\021';	/* ^Q */
  quit_char = '\007';		/* ^G */
  emulation = 'e';
  emacs_buffer = True;
  paste_stay_left = False;
  JUSmode = 1;
}

static
void
config_markers ()
{
  char * Mark;

  Mark = (char *) getenv ("MINEDSHIFT");
/* Turbo-C wants the cast here since getenv must be declared as far * */
  if (Mark != NIL_PTR) {
	SHIFT_MARK = Mark [0];
	if (Mark [0] != '\0') SHIFT_BEG = Mark [1];
  }

  Mark = (char *) getenv ("MINEDTAB");
  if (Mark != NIL_PTR) {
/*	TABchar = (Mark [0] == '\0' ? TABdefault : Mark [0]);	*/
	if (Mark [0] == '\0') {
		TABchar = TABdefault;
	} else {
		TABchar = Mark [0];
		TABchar0 = Mark [1];
		if (TABchar0 != '\0') {
			TABchar2 = Mark [2];
		}
		if (TABchar2 != '\0') {
			TABcharmid = Mark [3];
			TABchar0 = '\0';
		}
	}
  } else {
	TABchar = TABdefault;
  }
  UTF_TAB = (char *) getenv ("MINEDUTFTAB");
  if (UTF_TAB != NIL_PTR) {
	UTF_TAB0 = UTF_TAB;
	if (* UTF_TAB0 != '\0') {
		advance_utf8 (& UTF_TAB0);
	}
	UTF_TAB2 = UTF_TAB0;
	if (* UTF_TAB2 != '\0') {
		advance_utf8 (& UTF_TAB2);
	}
	UTF_TABmid = UTF_TAB2;
	if (* UTF_TABmid != '\0') {
		advance_utf8 (& UTF_TABmid);
		if (* UTF_TABmid != '\0') UTF_TAB0 = "";
	}
  }

  Mark = (char *) getenv ("MINEDRET");
  if (Mark != NIL_PTR) {
	RET_MARK = Mark [0];
	if (RET_MARK != '\0') {
		RET_BLANK = Mark [1];
	}
	if (RET_BLANK != '\0') {
		RET_BLANK2 = Mark [2];
	}
  } else {
	RET_MARK = RETdefault;
  }
  Mark = (char *) getenv ("MINEDDOSRET");
  if (Mark != NIL_PTR) {
	DOSRET_MARK = Mark [0];
  } else {
	DOSRET_MARK = DOSRETdefault;
  }
  Mark = (char *) getenv ("MINEDPARA");
  if (Mark != NIL_PTR) {
	PARA_MARK = Mark [0];
  } else {
	PARA_MARK = PARAdefault;
  }
  UTF_RET = (char *) getenv ("MINEDUTFRET");
  if (UTF_RET != NIL_PTR) {
	UTF_RETblank = UTF_RET;
	if (* UTF_RETblank != '\0') {
		advance_utf8 (& UTF_RETblank);
	}
	UTF_RETblank2 = UTF_RETblank;
	if (* UTF_RETblank2 != '\0') {
		advance_utf8 (& UTF_RETblank2);
	}
  }
  UTF_DOSRET = (char *) getenv ("MINEDUTFDOSRET");
  UTF_PARA = (char *) getenv ("MINEDUTFPARA");
}

void
set_mapped_text (encoding)
  char encoding;
{
  set_cjk_table (encoding);
  utf8_text = False;
  cjk_text = False;
  mapped_text = True;
}

static
void
eval_options (minedopt)
  char * minedopt;
{
  FLAG plus_opt = False;	/* set if options start with '+' */

  while (* minedopt != '\0') {
    switch (* minedopt) {
	case '+':
		plus_opt = True;
		break;
	case '-':
		plus_opt = False;
		minedopt ++;
		if (* minedopt == '-') {
			restricted = True;
		} else {
			minedopt --;
		}
		break;
	case ' ':
		break;
	case 'M':
		MENU = 1 - MENU;
		break;
	case '*':
		use_mouse = False;
		break;
	case 'L':
		minedopt ++;
		minedopt = scan_int (minedopt, & wheel_scroll);
		minedopt --;
		break;
	case 'v':
		init_viewonly = True;
		viewonly = True;
		break;
	case 'm':
		if (plus_opt == True) {
			multiexit = False;
		} else {
			multiexit = True;
		}
		break;
	case 'P':
		proportional = True;
		break;
	case 'p':
		paradisp = True;
		break;
	case 'r':
		if (RET_opt == 'r') {
			RET_opt = ' ';
		} else {
			RET_opt = 'r';
		}
		break;
	case 'R':
		if (plus_opt == True) {
			RET_opt = 'M';
		} else {
			RET_opt = 'R';
		}
		break;
	case 'G':
		if (plus_opt == True) {
			use_vt100_block_graphics = True;
		} else {
			if (display_block_graphics == True) {
				display_block_graphics = False;
			} else {
				display_block_graphics = True;
			}
		}
		break;
	case 'Q':
		minedopt ++;
		explicit_border_style = True;
		if (* minedopt == 'a') {
			use_ascii_graphics = True;
		} else if (* minedopt == 'v') {
			use_vt100_block_graphics = True;
		} else {
			menu_border_style = * minedopt;
		}
		break;
	case 'o':
		minedopt ++;
		switch (* minedopt) {
		case '0':
			disp_scrollbar = False;
			scrollbar_width = 0;
			break;
		case '1':
			disp_scrollbar = True;
			fine_scrollbar = False;
			scrollbar_width = 1;
			break;
		case '2':
			disp_scrollbar = True;
			fine_scrollbar = True;
			scrollbar_width = 1;
			break;
		case '8':
			update_scrollbar_lazy = False;
			break;
		case '9':
			update_scrollbar_lazy = True;
			break;
		default:
			minedopt --;
			/* compatibility */
			if (disp_scrollbar == True) {
				disp_scrollbar = False;
				scrollbar_width = 0;
				/* compatibility with 2000.6 beta */
				if (utf8_screen == True) {
					bidi_screen = True;
					poormansbidi = False;
				}
			} else if (bidi_screen == False) {
				disp_scrollbar = True;
				scrollbar_width = 1;
			}
		}
		break;
	case 'c':
		if (plus_opt == False) {
			if (combining_mode == True) {
				combining_mode = False;
				combining_mode_disabled = True;
			} else {
				combining_screen = False;
			}
		} else if (utf8_screen == True) {
			combining_mode = True;
			combining_screen = True;
		}
		break;
	case 'C':
		cjk_text = True;
		auto_detect_utf = False;
		utf8_text = False;
		utf8_lineends = False;
		if (utf8_screen == False) {
			cjk_term = True;
			/* make sure lineend marker will always fit: */
			scrollbar_width = 1;
		}
		break;
	case 'U':
		if (plus_opt == True) {
			if (U_mode_set) {
				bidi_screen = True;
				poormansbidi = False;
				/* disable scrollbar to prevent interference */
				disp_scrollbar = False;
				scrollbar_width = 0;
			} else {
				utf8_screen = True;
				utf8_input = True;
				combining_screen = True;
				combining_mode = True;
				U_mode_set = True;
				cjk_term = False;
			}
		} else if (utf8_input == True) {
			utf8_screen = False;
			utf8_input = False;
			combining_screen = False;
			combining_mode = False;
		} else {
			utf8_screen = True;
			utf8_input = True;
			combining_screen = True;
			combining_mode = True;
			cjk_term = False;
		}
		break;
	case 'u':
		auto_detect_utf = False;
		auto_detect_cjk = False;
		if (plus_opt == True) {
			utf8_text = False;
		} else {
			if (utf8_text == True) {
				/* double 'u' option */
				utf8_lineends = True;
			} else {
				utf8_text = True;
				cjk_text = False;
			}
		}
		break;
	case 'l':
		auto_detect_utf = False;
		auto_detect_cjk = False;
		utf8_text = False;
		cjk_text = False;
		break;
	case 'E':
		minedopt ++;
		if (* minedopt == 'U' || * minedopt == 'L') {
			auto_detect_utf = False;
			auto_detect_cjk = False;
			cjk_text = False;
			if (* minedopt == 'U') {
				utf8_text = True;
			} else {
				utf8_text = False;
			}
		} else {
			auto_detect_cjk = False;
			switch (* minedopt) {
			case 'g':	gb18030_term = False;
					set_cjk_table ('G');
					cjk_encoding_selected = True;
					break;
			case 'j':	euc3_term = False;
					set_cjk_table ('J');
					cjk_encoding_selected = True;
					break;
			case 'c':	euc4_term = False;
					set_cjk_table ('C');
					cjk_encoding_selected = True;
					break;
			case 'V':	set_mapped_text (* minedopt);
					auto_detect_utf = False;
					auto_detect_cjk = False;
					break;
			default:	set_cjk_table (* minedopt);
					cjk_encoding_selected = True;
					break;
			}
		}
		break;
	case 'b':
		if (poormansbidi == True) {
			poormansbidi = False;
		} else {
			poormansbidi = True;
			bidi_screen = False;
		}
		break;
	case 'K':
		minedopt ++;
		selection_space = * minedopt;
		break;
	case 'w':
		if (wordnonblank == True) {
			wordnonblank = False;
		} else {
			wordnonblank = True;
		}
		break;
	case 'a':
		append_flag = True;
		break;
	case 'j':
		if (plus_opt == True) {
			if (JUSlevel < 2) {
				JUSlevel ++;
			}
		} else if (JUSlevel == 1) {
			JUSlevel = 2;
		} else {
			JUSlevel = 1;
		}
		break;
	case 'J':
		JUSlevel = 2;
		break;
	case 'k':
		mined_keypad = False;
		mined_del_is_cut = False;
		break;
	case 'B':
		/*
		key_map ['\010'] = DPC;
		key_map ['\177'] = DCC;
		*/
		key_map ['\010'] = MLF;
		key_map ['\177'] = DPC;
		break;
	case 'T':
		tab_left = False;
		break;
	case 'W':
		WordStar_keys ();
		break;
	case 'e':
		set_emacs_mode ();
		break;
	case 'V':
		emacs_buffer = plus_opt;
		paste_stay_left = ! plus_opt;
		break;
	case 's':
		page_stay = True;
		break;
	case 'S':
		page_scroll = True;
		break;
	case 'x':
		xprot = exeprot;
		break;
	case 'X':
		no_window_title = True;
		break;
	case 't':
		minedopt ++;
		if (* minedopt == '\0') {
			TABchar = TABdefault;
		} else {
			TABchar = * minedopt;
		}
		break;
	case 'd':
		minedopt ++;
		if (* minedopt == '-') {
			display_delay = -1;
		} else if (* minedopt >= '0' && * minedopt <= '9') {
			display_delay = (int) * minedopt - (int) '0';
		} else {
			minedopt --;
		}
		break;
	case '/':
		minedopt ++;
		inisearch = minedopt;
		break;
	case '4':
		tabsize = 4;
		break;
	case '8':
		tabsize = 8;
		break;
	default:
		fprintf (stderr, "Unknown option %c\n", * minedopt);
		break;
    }
    if (* minedopt != '\0') {
	minedopt ++;
    }
  }
}

void
invoke_key_function (key)
  unsigned long key;
{
  if (key >= arrlen (key_map) || command (key) == (voidfunc) S) {
	Scharacter (key);
  } else {
	(* key_map [key]) (key);
  }
}


#define dont_debug_test_screen_width

static
int
test_screen_width (s)
  char * s;
{
#ifndef msdos
  character c;
  int row, col;

  /* for the initial position request, balance the delay time 
     (to accept a response) so that reponses via slow remote 
     terminal lines can be acquired but the user delay on a 
     terminal that doesn't respond at all remains acceptable
   */
  static int response_delay = 500;

  putstring ("\r");
  putstring (s);
  putstring ("\033[6n");
  flush ();
  if (char_ready_within (response_delay)) {
	/* for subsequent position requests, increase delay time 
	   for the sake of mlterm which needs a longer time to react, 
	   probably for font loading
	 */
	response_delay = 1500;

	c = read1byte ();
	if (c == '\033' && char_ready_within (300)) {
		c = read1byte ();
		if (c == '[' && char_ready_within (300)) {
			c = get_digits (& row);
			if (c == ';') {
				c = get_digits (& col);
#ifdef debug_test_screen_width
	printf ("%s -> %d\n", s, col - 1);
#endif
				return col - 1;
			}
		}
	}
  }
#endif

  return -1;
}

#define dont_debug_encoding
#ifdef debug_encoding
#define trace_encoding()	printf ("utf8 %d (%d), cjk %d (%d), encoding %c\n", utf8_text, auto_detect_utf, cjk_text, auto_detect_cjk, cjk_encoding)
#else
#define trace_encoding()	
#endif

int
main (argc, argv)
  int argc;
  char * argv [];
{
  unsigned long inputchar;
  int initlinenum;
  int initlini = 0;
  LINE * initline;
  FLAG goon;
  FLAG cursor_somewhere = False;
  int swidth;
  int cwidth;
  char * encoding;
  char * language;

/* fprot = umask (0); */

/* determine character encoding modes */
  if (getenv ("utf8_screen")) {
	utf8_screen = True;
  }
  if (getenv ("utf8_input")) {
	utf8_input = True;
  }
  if (getenv ("utf8_term")) {
	utf8_screen = True;
	utf8_input = True;
  }
  if (is_locale_utf8 ()) {
	utf8_screen = True;
	utf8_input = True;
  }
  if (! getenv ("utf8_no_combining_screen")) {
	if (utf8_screen == True) {
		combining_screen = True;
		combining_mode = True;
	}
  }

  if (getenv ("MINEDCJKTERM") || getenv ("MINEDCHIN")) {
	cjk_text = True;
	auto_detect_utf = False;
	utf8_text = False;
	utf8_lineends = False;
	if (utf8_screen == False) {
		cjk_term = True;
		/* make sure lineend marker will always fit: */
		scrollbar_width = 1;
	}
  }

/* determine various modes and display options from environment settings */
  if (getenv ("NoCtrlSQ") || getenv ("NoControlSQ")) {
	/* ^S and ^Q may come arbitrarily from terminal, so don't use them */
	controlQS = True;
	key_map ['\021'] = I;
	key_map ['\023'] = I;
  }
  if (getenv ("MINEDPROP")) proportional = True;
  if (getenv ("MINEDTURKISH")) Turkish = True;

  if (getenv ("MINEDMAC")) RET_opt = 'R';
  if (getenv ("MINEDWS")) WordStar_keys ();
  transout = (char *) getenv ("MINEDOUT");
  if (transout != NIL_PTR && * transout != '\0') {
	translate_output = True;
	translen = strlen (transout);
  }
#ifdef unix
  if (getenv ("MINEDMODF")) mined_modf = getenv ("MINEDMODF");
#endif
#ifdef pc_winlowdelay
  if (getenv ("windir")) display_delay = 0;
#endif

  dimansi = (char *) getenv ("MINEDDIM");
  if (dimansi == NIL_PTR) {
#ifdef pc
	dimansi = "1;31";
#else
	dimansi = "31";
#endif
  }

  uniansi = (char *) getenv ("MINEDUNI");
  if (uniansi == NIL_PTR) {
	/*uniansi = "46";*/
	uniansi = "36;7;40";
  } else if ((character) * uniansi > '9') {
	UNI_MARK = * uniansi;
	do {
		uniansi ++;
	} while (* uniansi == ' ');
  }
  unimarkansi = (char *) getenv ("MINEDUNIMARK");
  if (unimarkansi == NIL_PTR) unimarkansi = "36";
  combiningansi = (char *) getenv ("MINEDCOMBINING");
  if (combiningansi == NIL_PTR) combiningansi = "46";	/* 45? */

  ctrlansi = (char *) getenv ("MINEDCTRL");
  if (ctrlansi == NIL_PTR) ctrlansi = "";
  menuansi = (char *) getenv ("MINEDMENU");
  if (menuansi == NIL_PTR) menuansi = "";
  HTMLansi = (char *) getenv ("MINEDHTML");
  if (HTMLansi == NIL_PTR) HTMLansi = "34";
  diagansi = (char *) getenv ("MINEDDIAG");
  if (diagansi == NIL_PTR) diagansi = "";
  scrollfgansi = (char *) getenv ("MINEDSCROLLFG");
  if (scrollfgansi == NIL_PTR) scrollfgansi = "44;36;38;5;45";
  scrollbgansi = (char *) getenv ("MINEDSCROLLBG");
  if (scrollbgansi == NIL_PTR) scrollbgansi = "46;34;48;5;45";

  if ((minedopt = (char *) getenv ("MINED")) != NIL_PTR) {
	eval_options (minedopt);
  }

/* evaluate command line options (not file names) */
  fnami = 1;
  goon = True;
  do {
	if (fnami < argc) {
		if (* argv [fnami] == '+' && argv [fnami] [1] >= '0' && argv [fnami] [1] <= '9') {
			initlini = fnami;
			fnami += 1;
		} else if (* argv [fnami] == '-'
			      || * argv [fnami] == '+'
#ifdef msdos
			      || * argv [fnami] == '/'
#endif
			      )
		{
			minedopt = argv [fnami];
			eval_options (minedopt);
			fnami += 1;
		} else {
			goon = False;
		}
	} else {
		goon = False;
	}
  } while (goon == True);

/* configure special markers unless running on CJK terminal */
  if (cjk_term == False || utf8_screen == True) {
	config_markers ();
  } else {
	SHIFT_MARK = ' ';
  }

  fnami_min = fnami;
  fnami_max = argc - 1;
  fnami_cnt = argc - fnami_min;
  fnamv = argv;	/* Why did this produce a warning? C is such a stupid language! */
  if (! (fnami < argc)) {
     fnami = 0;
  }

/* handling of input/output redirection */
  if (! isatty (STD_IN)) {	/* Reading from pipe */
	if (fnami != 0) {
		panic ("Cannot read both pipe and file", NIL_PTR);
	}
	rpipe = True;
	set_modified ();	/* Set modified flag not to loose buffer */
#ifdef msdos
	panic ("Cannot edit after input from pipe", "MSDOS C incompatibility");
#else
	if ((input_fd = open ("/dev/tty", O_RDONLY, 0)) < 0)
	   panic ("Cannot open /dev/tty for read", serror ());
#endif
  }
  if (! isatty (STD_OUT)) {
	wpipe = True;
	set_modified (); /* Set modified flag not to ignore buffer on exit */
    /*	if ((output_fd = open ("/dev/tty", O_WRONLY, 0)) < 0)
	   panic ("Cannot open /dev/tty for write", serror ()); */
  }

/* terminal mode initialisation */
  get_term ();
  raw_mode (ON);	/* Set tty to appropriate mode */
  if (erase_char != '\0') {
	key_map [erase_char] = DPC;
  }
  trace_encoding ();

/* detect screen encoding if not yet specified */
  swidth = test_screen_width ("åلاษษ刈刈");
  if (swidth > 0) {
	/**
	 check cursor column after test string, determine screen mode
	  6	-> UTF-8, no double-width, with LAM/ALEF ligature joining
	  7	-> UTF-8, no double-width, no LAM/ALEF ligature joining
	  8	-> UTF-8, double-width, with LAM/ALEF ligature joining
	  9	-> UTF-8, double-width, no LAM/ALEF ligature joining
	 13	-> 8 bit terminal (or CJK terminal)
	 14..17	-> CJK terminal
	 18	-> CJK terminal (or 8 bit terminal)
	*/
	if (swidth > 0 && swidth <= 9) {
		utf8_screen = True;
		utf8_input = True;
		cjk_term = False;
		if (test_screen_width ("a̡") == 1) {
			combining_screen = True;
			if (combining_mode_disabled == False) {
				combining_mode = True;
			}
		} else {
			combining_screen = False;
			combining_mode = False;
		}
		if ((swidth & 1) == 0) {
			/* ligature joining detected, must also be bidi */
			bidi_screen = True;
			poormansbidi = False;
			/* disable scrollbar to prevent interference */
			disp_scrollbar = False;
			scrollbar_width = 0;
		}
		if (swidth < 8) {
			/* no wide character support */
			width_data_version = 0;
		} else if (test_screen_width ("《》〚〛｠") < 8) {
			/* older width data (before xterm 167) */
			width_data_version = 1;
			if (test_screen_width ("a܏") == 1) {
				combining_data_version = 2;
			} else {
				combining_data_version = 1;
			}
		}
		if (width_data_version == 2) {
			if (test_screen_width ("‘’“”…―") > 8) {
				/* xterm -cjk_width (since xterm 168) */
				width_data_version = 3;
			}
#ifdef single_width_check
			swidth = test_screen_width ("…―…");
			if ((swidth & 1) == 0) {
				/* ― is wide */
			}
			if (swidth >= 5) {
				/* … is wide */
			}
#endif
		}

		/* workaround for buggy mlterm font selection */
		if (bidi_screen == True) {
			/* probably mlterm, bold does not work */
			use_bold = False;
		}
		/* workaround for buggy mlterm width data chaos */
		if (explicit_border_style == False && width_data_version != 3) {
			boldon ();
			if (test_screen_width ("╭") > 1) {
				use_vt100_block_graphics = True;
			}
			boldoff ();
		}

		/* check non-BMP width properties */
		nonbmp_width_data = test_screen_width ("𠀀𠀀𠀀𠀀a𝆪a𝆪a󠀠") - 7;
	} else {
		if (swidth > 13) {
			cwidth = test_screen_width ("00");
			if (cwidth > 2) {
				/* quite safe detection */
				gb18030_term = False;
			} else if (cwidth >= 0) {
				cjk_term = True;
			}
			cwidth = test_screen_width ("");
			if (cwidth > 2) {
				/* quite safe detection */
				euc4_term = False;
			} else if (cwidth >= 0) {
				cjk_term = True;
			}
			if (euc3_term == True && test_screen_width ("x") > 3) {
				/* unsafe detection */
				euc3_term = False;
			}
			if (test_screen_width ("") < 2) {
				cjklow_term = False;
			}
		}
		if ((swidth > 13 && swidth < 18) || cjk_term == True) {
			/* if the test string width did not comply 
			   with 8 bit behaviour, or a 
			   GB18030 or EUC 4 byte (EUC-TW) terminal 
			   was asserted, assume CJK terminal;
			   a EUC 3 byte (EUC-JP) terminal cannot 
			   be asserted but can just be assumed as 
			   an 8 bit terminal might respond with 
			   the same width behaviour
			 */
			cjk_term = True;
			/* make sure lineend marker will always fit: */
			scrollbar_width = 1;
			utf8_screen = False;
			utf8_input = False;
			auto_detect_utf = False;
			cjk_text = True;
			utf8_text = False;
			utf8_lineends = False;
		}
	}
  }
  trace_encoding ();

  clearscreen ();

/* set screen mode and default text encoding according to locale encoding */
  if (cjk_encoding_selected == False) {
	if (utf8_screen == True) {
		encoding = locale_text_encoding ();
	} else {
		encoding = locale_terminal_encoding ();
	}

	/* detect CJK encodings by locale suffixes */
	if (strisprefix ("GB", encoding)
	 || strisprefix ("gb", encoding)
	 || strisprefix ("EUC-CN", encoding)
	 || strisprefix ("euccn", encoding)
	 || strisprefix ("_CN", encoding)
	   )
	{
		cjk_encoding_selected = True;
		set_cjk_table ('G');
	}
	else if (strisprefix ("BIG5", encoding)
		 || strisprefix ("Big5", encoding)
		 || strisprefix ("_HK", encoding)
		 || strisprefix ("_TW", encoding)
		)
	{
		cjk_encoding_selected = True;
		set_cjk_table ('B');
	}
	else if (strisprefix ("EUC-TW", encoding)
		 || strisprefix ("euctw", encoding)
		)
	{
		cjk_encoding_selected = True;
		set_cjk_table ('C');
	}
	else if (strisprefix ("UHC", encoding)
		 || strisprefix ("EUC-KR", encoding)
		 || strisprefix ("euckr", encoding)
		)
	{
		cjk_encoding_selected = True;
		set_cjk_table ('K');
	}
	else if (strisprefix ("EUC-JP", encoding)
		 || strisprefix ("eucjp", encoding)
		 || strisprefix ("euc", encoding)
		)
	{
		cjk_encoding_selected = True;
		set_cjk_table ('J');
	}
	else if (strisprefix ("Shift_JIS", encoding)
		)
	{
		cjk_encoding_selected = True;
		set_cjk_table ('S');
	}
	else if (strisprefix ("JOHAB", encoding)
		)
	{
		cjk_encoding_selected = True;
		set_cjk_table ('H');
	}

	if (cjk_encoding_selected == True) {
		if (utf8_screen == True) {
			auto_detect_cjk = False;
			cjk_text = True;

			auto_detect_utf = False;	/* ? */
			utf8_text = False;
			utf8_lineends = False;
		} else {
			cjk_term = True;
			scrollbar_width = 1;

			auto_detect_cjk = False;
			cjk_text = True;

			auto_detect_utf = False;
			utf8_text = False;
			utf8_lineends = False;
		}
	}
  }
  trace_encoding ();

/* read filter that defines which CJK encodings may be auto-detected */
  detect_encodings = (char *) getenv ("MINEDDETECT");

/* detect language component of locale */
  language = (char *) getenv ("LANG");
  if (! language || ! * language) {
    language = (char *) getenv ("LC_ALL");
    if (! language || ! * language) {
      language = (char *) getenv ("LC_CTYPE");
    }
  }
  if (language && * language) {
	if (strisprefix ("de", language)) {
		language_tag = 'g';
	} else if (strisprefix ("da", language)) {
		language_tag = 'd';
	} else if (strisprefix ("fr", language)) {
		language_tag = 'f';
	}
  }

/* special cases of terminal capabilities handling (esp. block graphics) */
  if (explicit_border_style == False && 
      getenv ("TERM") && strcmp ("linux", (char *) getenv ("TERM")) == 0) {
	if (utf8_screen == True) {
		/*use_ascii_graphics = True;*/
		menu_border_style = 's';
	} else if (use_vt100_block_graphics == False) {
		use_vga_block_graphics = True;
	}
  }
  if (can_alt_cset == False && utf8_screen == False) {
	use_ascii_graphics = True;
  }
  if (cjk_term == True) {
	/*use_bgcolor = False;*/
  }

/* select map of escape sequences for terminal function keys */
#ifndef msdos
  if (getenv ("TERM") && strisprefix ("vt100", (char *) getenv ("TERM"))) {
	set_fkeymap ("vt100");
  }
  set_fkeymap (getenv ("MINEDTERM"));
  setKEYMAP (getenv ("MINEDKEYMAP"));
#endif

/*
 * Generate names of paste files and of panic-file
 */
#ifdef unix
  temp_dir = getenv ("MINEDTMP");
  if (temp_dir == NIL_PTR || temp_dir [0] == '\0' || access (temp_dir, R_OK | X_OK) < 0) {
	temp_dir = getenv ("TMPDIR");
  }
  if (temp_dir == NIL_PTR || temp_dir [0] == '\0' || access (temp_dir, R_OK | X_OK) < 0) {
	temp_dir = getenv ("TMP");
  }
  if (temp_dir == NIL_PTR || temp_dir [0] == '\0' || access (temp_dir, R_OK | X_OK) < 0) {
	temp_dir = getenv ("TEMP");
  }
  if (temp_dir == NIL_PTR || temp_dir [0] == '\0' || access (temp_dir, R_OK | X_OK) < 0) {
	temp_dir = "/usr/tmp";
  }
  if (access (temp_dir, R_OK | X_OK) < 0) {
	temp_dir = "/tmp";
  }
  if (getenv ("MINEDUSER")) {
	build_string (yankie_file, "%s/minedbuf.%s", temp_dir, getenv ("MINEDUSER"));
	build_string (panic_file, "%s/minedpanic.%s.%d", temp_dir, getenv ("MINEDUSER"), getpid ());
  } else if (getenv ("USER")) {
	build_string (yankie_file, "%s/minedbuf.%s", temp_dir, getenv ("USER"));
	build_string (panic_file, "%s/minedpanic.%s.%d", temp_dir, getenv ("USER"), getpid ());
  } else {
	build_string (yankie_file, "%s/minedbuf.%d", temp_dir, geteuid ());
	build_string (panic_file, "%s/minedpanic.%d.%d", temp_dir, geteuid (), getpid ());
  }
#endif
#ifdef vms
  if (getenv ("SYS$MINEDTMP")) {
	temp_dir = "SYS$MINEDTMP";
  } else if (getenv ("SYS$SCRATCH")) {
	temp_dir = "SYS$SCRATCH";
  } else {
  	temp_dir = "SYS$LOGIN";
  }
  if (getenv ("MINEDUSER")) {
	build_string (yankie_file, "%s:$MINEDBUF$%s", temp_dir, getenv ("MINEDUSER"));
	build_string (panic_file, "%s:$MINEDPANIC$%s.%d", temp_dir, getenv ("MINEDUSER"), getpid ());
  } else if (getenv ("USER")) {
	build_string (yankie_file, "%s:$MINEDBUF$%s", temp_dir, getenv ("USER"));
	build_string (panic_file, "%s:$MINEDPANIC$%s.%d", temp_dir, getenv ("USER"), getpid ());
  } else {
	build_string (yankie_file, "%s:$MINEDBUF$%d", temp_dir, geteuid ());
	build_string (panic_file, "%s:$MINEDPANIC$%d.%d", temp_dir, geteuid (), getpid ());
  }
#endif
#ifdef msdos
  temp_dir = (char *) getenv ("MINEDTMP");
  if (temp_dir == NIL_PTR || temp_dir [0] == '\0') temp_dir = (char *) getenv ("TEMP");
  if (temp_dir == NIL_PTR || temp_dir [0] == '\0') temp_dir = (char *) getenv ("TMP");
  if (temp_dir == NIL_PTR || temp_dir [0] == '\0') temp_dir = "\\";
  build_string (yankie_file, "%s\\minedbuf", temp_dir);
  build_string (panic_file, "%s\\mined-pa.nic", temp_dir);
#endif

  preselect_quote_style = getenv ("MINEDQUOTES");

  header = tail = alloc_header (); /* Make header of list */
  if (header == NIL_LINE) panic ("Cannot allocate memory", NIL_PTR);
  header->text = NIL_PTR;
  header->next = tail->prev = header;
  header->syntax_marker = syntax_none;

/* Load the file (if any) */
  if (fnami == 0) {
	load_file (NIL_PTR, False);
  } else {
	/* This should be applied to all file names, or better, not at all:
	if (length_of (argv [fnami]) > maxLINE_LEN) {
		argv [fnami] [maxLINE_LEN] = '\0';
	}
	*/
	load_wild_file (argv [fnami], False);
  }
  loading = True;	/* keep loading flag True until entering main loop */

  if (initlini != 0) {
     (void) scan_int (argv [initlini] + 1, & initlinenum);
     if (initlinenum > 0) {
	if (initlinenum <= 0 || (initline = proceed (header->next, initlinenum - 1)) == tail) {
	   error ("Invalid line number: ", num_out ((long) initlinenum));
	} else {
	   move_to (x, find_y_w_o_RD (initline));
	   fstatus ("Read", -1L, -1L);
	}
     }
  }

  if (inisearch != NIL_PTR) {
	search_for (inisearch, FORWARD);
	fstatus ("Read", -1L, -1L);
  }

  if (wpipe == True) {
	file_name [0] = '\0'; /* don't let user believe he's editing a file */
	fstatus ("Editing for standard output", -1L, -1L);
  }
  RD ();
  flush ();
  catch_signals (catch_interrupt);
  loading = False;
  trace_encoding ();

/* Main loop of the editor */
  for (;;) {
	if (fstat_always == True && stat_visible == False) {
		FSTAT ();
	} else if (always_disp_code == True && stat_visible == False) {
		display_the_code ();
	}

	if (MENU && top_line_scrolled == True) {
		displaymenuline ();
		flags_changed = False;
		cursor_somewhere = True;
	}
	if (MENU && flags_changed == True) {
		displayflags ();
		cursor_somewhere = True;
	}
	if (disp_scrollbar == True) {
		if (display_scrollbar (update_scrollbar_lazy)) {
			cursor_somewhere = True;
		}
	}
	if (cursor_somewhere == True) {
		set_cursor_xy ();
	}
	flush ();	/* Flush output (if any) */

	inputchar = readcharacter_mapping (True);
	if (cjk_text == True && inputchar == quit_char) {
		inputchar = 0xFF;
	}

	if (stat_visible == True) {
		clear_status ();
	}
	if (quit == False) {	/* Call the function for the typed key */
		invoke_key_function (inputchar);
		if (hop_flag > 0) {
			hop_flag --;
			flags_changed = True;
		}
		if (buffer_open_flag > 0) {
			buffer_open_flag --;
#ifdef debug_ring_buffer
			if (buffer_open_flag == 0) {
				flags_changed = True;
			}
#endif
		}
	}
	if (quit == True) {
		if (hop_flag > 0) {
			flags_changed = True;
		}
		CANCEL ();
		quit = False;
	}
  }
  /* NOTREACHED */
}


/*======================================================================*\
|*				End					*|
\*======================================================================*/
