#! /bin/sh

SRCDIR = .
BUILDDIR = ../build/binutils
BINUTILSDIR = $(SRCDIR)/binutils
BFDDIR = $(SRCDIR)/bfd
INCDIR = $(SRCDIR)/include

GNAT_OBJ = $(BUILDDIR)/gnaddr2line.o

LIBOBJS = $(GNAT_OBJ) $(BUILDDIR)/bucomm.o $(BUILDDIR)/budemang.o $(BUILDDIR)/filemode.o
LIB = $(BUILDDIR)/libaddr2line.a

CFLAGS = -O2 -Wall -W

INCLUDES = -D_GNU_SOURCE \
	 -I$(BUILDDIR) -I$(BINUTILSDIR) -I$(BUILDDIR)../bfd -I$(BFDDIR) -I$(INCDIR) \
	 -D__USE_MINGW_FSEEK -DBUILD_LIB

ALL_CFLAGS = $(CFLAGS) $(INCLUDES)

all: $(LIB)

clean:
	rm -f $(LIB)
	rm -f $(GNAT_OBJ)

$(LIB): $(GNAT_OBJ)
	rm -f $(LIB)
	ar cr $(LIB) $(LIBOBJS)
	ranlib $(LIB)

$(BUILDDIR)/gnaddr2line.o: $(BINUTILSDIR)/gnaddr2line.c
	gcc -c $(ALL_CFLAGS) -o $@ $<
