from typing import Mapping, Sequence

def mergedefaults(a, b):
    for k, v in b.items():
        if k in a:
            if isinstance(v, Mapping):
                new = v.copy()
                new.update(a[k])
                a[k] = new
            elif isinstance(v, Sequence):
                a[k] = v + a[k]
        else:
            a[k] = v
    return a

def add_dicts(a, b):
    # currently unused
    new = {}
    for k, v in b.items():
        if k in a:
            # the docco isn’t clear on this but it’s better to overwrite strings
            if isinstance(v, str):
                new[k] = b[k]
            elif isinstance(v, Mapping):
                new[k] = add_dicts(a[k], b[k])
            elif isinstance(v, Sequence):
                new[k] = a[k] + b[k]
        else:
            new[k] = v
    return new

def print_vars(target, kv, names):
    for name in names:
        if name in kv:
            print(f"{target}_{name.upper():<8} = {' '.join(kv[name])}")


