; $Id: list.scm,v 1.13 2007/07/25 10:33:42 schwicht Exp $
(if (not (assoc "nat" ALGEBRAS))
    (myerror "First execute (libload \"nat.scm\")"))

(display "loading list.scm ...") (newline)

(add-param-alg "list" 'prefix-typeop
	       '("Nil" "list")
	       '("Cons" "alpha1=>list=>list"))

; Notice that listrev.scm and list.scm cannot be loaded together.
; Reason: In :0::1::2::3 the ":" is a prefix-op (for listrev.scm), but
; in 3::2::1::0: the ":" is a postfix-op (for list.scm).

; Infix notation allowed (and type parameters omitted) for binary 
; constructors, as follows.  This would also work for prefix notation.
; Example: :: for Cons.  x::y::z: 
; Here : is postfix for z

(add-token
 "::" 'pair-op ;hence right associative
 (lambda (x xs)
   (let ((type (term-to-type x))
	 (listtype (term-to-type xs)))
     (if (and (alg-form? listtype)
	      (string=? "list" (alg-form-to-name listtype))
	      (equal? type (car (alg-form-to-types listtype))))
	 (mk-term-in-app-form
	  (make-term-in-const-form
	   (let* ((constr (constr-name-to-constr "Cons"))
		  (tvars (const-to-tvars constr))
		  (subst (make-substitution tvars (list type))))
	     (const-substitute constr subst #f)))
	  x xs)
	 (myerror "parse error" "types do not fit for" type "::" listtype)))))

(add-display
 (py "list alpha")
 (lambda (x)
   (if (term-in-app-form? x)
       (let ((op (term-in-app-form-to-final-op x))
	     (args (term-in-app-form-to-args x)))
	 (if (and (term-in-const-form? op)
		  (string=? "Cons"
			    (const-to-name (term-in-const-form-to-const op)))
		  (= 2 (length args)))
	     (list 'pair-op "::"
		   (term-to-token-tree (car args))
		   (term-to-token-tree (cadr args)))
	     #f))
       #f)))

(add-token
 ":" 'postfix-op
 (lambda (x)
   (mk-term-in-app-form
    (make-term-in-const-form
     (let* ((constr (constr-name-to-constr "Cons"))
	    (tvars (const-to-tvars constr))
	    (subst (make-substitution tvars (list (term-to-type x)))))
       (const-substitute constr subst #f)))
    x
    (make-term-in-const-form
     (let* ((constr (constr-name-to-constr "Nil"))
	    (tvars (const-to-tvars constr))
	    (subst (make-substitution tvars (list (term-to-type x)))))
       (const-substitute constr subst #f))))))

(add-display
 (py "list alpha")
 (lambda (x)
   (if (term-in-app-form? x)
       (let ((op (term-in-app-form-to-final-op x))
	     (args (term-in-app-form-to-args x)))
	 (if (and (term-in-const-form? op)
		  (string=? "Cons" (const-to-name
				    (term-in-const-form-to-const op)))
		  (= 2 (length args))
		  (term-in-const-form? (cadr args))
		  (string=? "Nil" (const-to-name
				   (term-in-const-form-to-const (cadr args)))))
	     (list 'postfix-op ":" (term-to-token-tree (car args)))
	     #f))
       #f)))

(add-program-constant
 "ListAppend" (py "list alpha=>list alpha=>list alpha") t-deg-one 'const 1)

(add-token
 ":+:" 'mul-op
 (lambda (x y)
   (mk-term-in-app-form
    (make-term-in-const-form
     (let* ((const (pconst-name-to-pconst "ListAppend"))
	    (tvars (const-to-tvars const))
	    (listtype (term-to-type x))
	    (type (car (alg-form-to-types listtype)))
	    (subst (make-substitution tvars (list type))))
       (const-substitute const subst #f)))
    x y)))

(add-display
 (py "list alpha")
 (lambda (x)
   (if (term-in-app-form? x)
       (let ((op (term-in-app-form-to-final-op x))
	     (args (term-in-app-form-to-args x)))
	 (if (and (term-in-const-form? op)
		  (string=? "ListAppend"
			    (const-to-name (term-in-const-form-to-const op)))
		  (= 2 (length args)))
	     (list 'mul-op ":+:"
		   (term-to-token-tree (car args))
		   (term-to-token-tree (cadr args)))
	     #f))
       #f)))

(add-computation-rule
 (pt "(ListAppend alpha)(Nil alpha)")
 (pt "[(list alpha)_2](list alpha)_2"))

(add-computation-rule
 (pt "(ListAppend alpha)(alpha::(list alpha)_1)")
 (pt "[(list alpha)_2](alpha::(list alpha)_1 :+:(list alpha)_2)"))

; "ListAppendNil"
(set-goal (pf "all list alpha
                Equal(list alpha :+:(Nil alpha))list alpha"))
(ind)
(use "Eq-Refl")
(assume "alpha" "list alpha" "IH")
(ng)
(simp "IH")
(use "Eq-Refl")
(save "ListAppendNil")

; "ListAppendNilPartial"
(set-goal (pf "all list alpha^.STotal list alpha^ ->
                Equal(list alpha^ :+:(Nil alpha))list alpha^"))
(ind)
(use "Eq-Refl")
(assume "alpha^" "list alpha^" "[STotal]" "IH")
(ng)
(simp "IH")
(use "Eq-Refl")
(save "ListAppendNilPartial")

; This is not added as a rewrite rule, because ListAppend is defined
; by recursion over the first argument and expects rules of arity 1.


(add-program-constant "ListLength" (py "list alpha=>nat") t-deg-one)

(add-token
 "Lh" 'prefix-op 
 (lambda (x) (make-term-in-app-form
	      (make-term-in-const-form
	       (let* ((const (pconst-name-to-pconst "ListLength"))
		      (tvars (const-to-tvars const))
		      (listtype (term-to-type x))
		      (type (car (alg-form-to-types listtype)))
		      (subst (make-substitution tvars (list type))))
		 (const-substitute const subst #f)))
	      x)))

(add-display
 (py "nat")
 (lambda (x)
   (if (term-in-app-form? x)
       (let ((op (term-in-app-form-to-op x)))
	 (if (and (term-in-const-form? op)
		  (string=? "ListLength"
			    (const-to-name (term-in-const-form-to-const op))))
	     (list 'prefix-op "Lh"
		   (term-to-token-tree (term-in-app-form-to-arg x)))
	     #f))
       #f)))

(add-computation-rule (pt "Lh(Nil alpha)") (pt "Zero"))
(add-computation-rule (pt "Lh(alpha::list alpha)") (pt "Succ Lh list alpha"))

; "LhAppend"
(set-goal (pf "all (list alpha)_1,(list alpha)_2
                Lh((list alpha)_1:+:(list alpha)_2)=
                Lh (list alpha)_1+Lh (list alpha)_2"))
(ind)
(assume "(list alpha)_2")
(use "Truth-Axiom")
(assume "alpha" "(list alpha)_1" "IH")
(use "IH")
(save "LhAppend")

(add-rewrite-rule
 (pt "Lh((list alpha)_1:+:(list alpha)_2)")
 (pt "Lh(list alpha)_1+Lh(list alpha)_2"))


; Now for projection, ListProj, which is partial.  We use Inhab for
; the rule (Nil alpha)__n -> (Inhab alpha)

(add-program-constant
 "ListProj" (py "nat=>list alpha=>alpha") t-deg-zero 'const 2)

(add-token
 "__" 'mul-op ;hence left associative
 (lambda (x y)
   (mk-term-in-app-form
    (make-term-in-const-form
     (let* ((const (pconst-name-to-pconst "ListProj"))
	    (tvars (const-to-tvars const))
	    (listtype (term-to-type x))
	    (type (car (alg-form-to-types listtype)))
	    (subst (make-substitution tvars (list type))))
       (const-substitute const subst #f)))
    y x)))

(add-token
 "thof" 'pair-op ;hence right associative
 (lambda (x y)
   (mk-term-in-app-form
    (make-term-in-const-form
     (let* ((const (pconst-name-to-pconst "ListProj"))
	    (tvars (const-to-tvars const))
	    (listtype (term-to-type y))
	    (type (car (alg-form-to-types listtype)))
	    (subst (make-substitution tvars (list type))))
       (const-substitute const subst #f)))
    x y)))

; Not used (reason: occurrences of "thof" examples/tait)
; (add-display
;  (py "alpha")
;  (lambda (x)
;    (if (term-in-app-form? x)
;        (let ((op (term-in-app-form-to-final-op x))
; 	     (args (term-in-app-form-to-args x)))
; 	 (if (and (term-in-const-form? op)
; 		  (string=? "ListProj"
; 			    (const-to-name (term-in-const-form-to-const op)))
; 		  (= 2 (length args)))
; 	     (list 'mul-op "__"
; 		   (term-to-token-tree (car args))
; 		   (term-to-token-tree (cadr args)))
; 	     #f))
;        #f)))

(add-display
 (py "alpha")
 (lambda (x)
   (if (term-in-app-form? x)
       (let ((op (term-in-app-form-to-final-op x))
	     (args (term-in-app-form-to-args x)))
	 (if (and (term-in-const-form? op)
		  (string=? "ListProj"
			    (const-to-name (term-in-const-form-to-const op)))
		  (= 2 (length args)))
	     (list 'pair-op "thof"
		   (term-to-token-tree (car args))
		   (term-to-token-tree (cadr args)))
	     #f))
       #f)))

(add-computation-rule (pt "nat thof(Nil alpha)") (pt "(Inhab alpha)"))

(add-computation-rule (pt "0 thof(alpha::(list alpha)_1)")
		      (pt "alpha"))
(add-computation-rule (pt "(Succ nat1)thof(alpha::(list alpha)_1)")
		      (pt "nat1 thof(list alpha)_1"))

; (pp (nt (pt "1 thof(0::1::2::3:)")))
; (pp (nt (pt "5 thof(0::1::2::3:)")))
; (pp (nt (pt "(0::1::2::3:)__1")))
; (pp (nt (pt "(0::1::2::3:)__5")))


(add-program-constant
 "ListMap" (py "(alpha1=>alpha2)=>list alpha1=>list alpha2") t-deg-one)

(add-token
 "map" 'pair-op ;hence right associative
 (lambda (x y)
   (mk-term-in-app-form
    (make-term-in-const-form
     (let* ((const (pconst-name-to-pconst "ListMap"))
	    (tvars (const-to-tvars const))
	    (listtype (term-to-type y))
	    (type1 (car (alg-form-to-types listtype)))
	    (type2 (arrow-form-to-val-type (term-to-type x)))
	    (subst (make-substitution tvars (list type1 type2))))
       (const-substitute const subst #f)))
    x y)))

(add-display
 (py "list alpha")
 (lambda (x)
   (if (term-in-app-form? x)
       (let ((op (term-in-app-form-to-final-op x))
	     (args (term-in-app-form-to-args x)))
	 (if (and (term-in-const-form? op)
		  (string=? "ListMap"
			    (const-to-name (term-in-const-form-to-const op)))
		  (= 2 (length args)))
	     (list 'pair-op "map"
		   (term-to-token-tree (car args))
		   (term-to-token-tree (cadr args)))
	     #f))
       #f)))

(add-computation-rule
 (pt "alpha1=>alpha2 map(Nil alpha1)")
 (pt "(Nil alpha2)"))

(add-computation-rule
 (pt "alpha1=>alpha2 map alpha1::(list alpha1)_1")
 (pt "alpha1=>alpha2 alpha1::alpha1=>alpha2 map(list alpha1)_1"))

; (pp (nt (pt "Pred map 2::3::4:")))

; "LhMap"
(set-goal (pf "all alpha1=>alpha2,(list alpha1) 
                Lh(alpha1=>alpha2 map (list alpha1))=Lh(list alpha1)"))
(assume "alpha1=>alpha2")
(ind)
(use "Truth-Axiom")
(assume "alpha1" "list alpha1" "IH")
(use "IH")
(save "LhMap")

; "LhMapPartial"
(set-goal (pf "all alpha1=>alpha2^,list alpha1^.STotal list alpha1^ ->
                Lh(alpha1=>alpha2^ map list alpha1^)=Lh list alpha1^"))
(assume "alpha1=>alpha2^")
(ind)
(use "Truth-Axiom")
(assume "alpha1^" "list alpha1^" "[Stotal]""IH")
(use "IH")
(save "LhMapPartial")

; "MapAppend"
(set-goal (pf "all alpha1=>alpha2,(list alpha1)_2,(list alpha1)_1
               Equal(alpha1=>alpha2 map ((list alpha1)_1:+:(list alpha1)_2))
               ((alpha1=>alpha2 map (list alpha1)_1):+:
                (alpha1=>alpha2 map (list alpha1)_2))"))
(assume "alpha1=>alpha2" "(list alpha1)_2")
(ind)
(ng)
(use "Eq-Refl")
(assume "alpha1" "list alpha1" "IH")
(ng)
(simp "IH")
(use "Eq-Refl")
(save "MapAppend")

; "MapAppendPartial"
(set-goal (pf "all alpha1=>alpha2^,(list alpha1)^2,(list alpha1)^1.
               STotal (list alpha1)^1 ->
               Equal(alpha1=>alpha2^ map ((list alpha1)^1:+:(list alpha1)^2))
               ((alpha1=>alpha2^ map (list alpha1)^1):+:
                (alpha1=>alpha2^ map (list alpha1)^2))"))
(assume "alpha1=>alpha2^" "(list alpha1)^2")
(ind)
(ng)
(use "Eq-Refl")
(assume "alpha1^" "(list alpha1)^" "[STotal]" "IH")
(ng)
(simp "IH")
(use "Eq-Refl")
(save "MapAppendPartial")

; "ListProjMap"
(set-goal (pf "all alpha1=>alpha2,(list alpha1),nat.nat<Lh(list alpha1) ->
               Equal(nat thof(alpha1=>alpha2 map(list alpha1)))
                    (alpha1=>alpha2(nat thof(list alpha1)))"))
(assume "alpha1=>alpha2")
(ind)
(assume "nat" "Absurd")
(use "Efq")
(use "Absurd")
(assume "alpha1" "list alpha1" "IH")
(cases)
(assume "Trivial")
(ng)
(use "Eq-Refl")
(assume "nat" "nat<Lh List alpha1")
(ng)
(use "IH")
(use "nat<Lh List alpha1")
(save "ListProjMap")

(add-program-constant
 "Consn" (py "nat=>alpha=>list alpha=>list alpha") t-deg-one)

(add-computation-rule (pt "(Consn alpha)0 alpha list alpha")
		      (pt "alpha::list alpha"))
(add-computation-rule (pt "(Consn alpha)(Succ nat)alpha(Nil alpha)")
		      (pt "alpha::(Consn alpha)nat alpha(Nil alpha)"))
(add-computation-rule (pt "(Consn alpha)(Succ nat)alpha(alpha_1::list alpha)")
		      (pt "alpha_1::(Consn alpha)nat alpha(list alpha)"))

; (pp (nt (pt "(Consn nat)7 nat(0::1::2:)")))
; => 0::1::2::nat::nat::nat::nat::nat:
		      
; "LhE"
(set-goal (pf "all list alpha^.STotal list alpha^ -> E(Lh list alpha^)"))
(ind)
(use "Truth-Axiom")
(assume "alpha^" "list alpha^" "[STotal]" "IH")
(use "IH")
(save "LhE")

; "All-AllPartial-nat"
(set-goal (pf "all nat (Pvar nat)nat -> 
               all nat^.E nat^ -> (Pvar nat)nat^"))
(assume "H1" "nat^" "H2")
(use-with "All-AllPartial"
	  (py "nat")
	  (make-cterm (pv "nat") (pf "(Pvar nat)nat"))
	  "H1" (pt "nat^") "?")
(use (make-proof-in-aconst-form
      (finalg-to-e-to-total-aconst (py "nat"))))
(use "H2")
(save "All-AllPartial-nat")

; "LhConsn"
(set-goal
 (pf "all alpha^1,list alpha^.STotal list alpha^ -> 
      all nat.
       Lh list alpha^ <=nat -> 
       Lh(list alpha^ :+:(Consn alpha)(nat--Lh list alpha^)alpha^1(Nil alpha))=
       Succ nat"))
(assume "alpha^1")
(ind)
(ind)
(assume "Trivial")
(ng)
(use "Truth-Axiom")
(assume "nat" "IHnat" "Trivial")
(use "IHnat")
(use "Truth-Axiom")
(assume "alpha^2" "(list alpha)^" "[STotal]" "IHl")
(cases)
(assume "Absurd")
(use "Efq")
(use "Absurd")
(assume "nat")
(assume "Lh(list alpha)^ <=nat")
(ng)
(assert (pf "all nat1,nat^2.E nat^2 -> Pred(Succ nat1--nat^2)=nat1--nat^2"))
 (assume "nat1")
 (use-with "All-AllPartial-nat"
 	  (make-cterm (pv "nat^2") (pf "Pred(Succ nat1--nat^2)=nat1--nat^2"))
 	  "?")
 (assume "nat2")
 (use "Truth-Axiom")
(assume "H")
(simp "H")
(use "IHl")
(use "Lh(list alpha)^ <=nat")
(use "LhE")
(use "[STotal]")
(save "LhConsn")


; We add a bounded universal quantifier

(add-program-constant
 "AllBList" (py "nat=>(list boole=>boole)=>boole") t-deg-one)

(add-computation-rule (pt "AllBList 0 list boole=>boole")
		      (pt "(list boole=>boole)(Nil boole)"))
(add-computation-rule
 (pt "AllBList(Succ nat)list boole=>boole")
 (pt "(AllBList nat([list boole]list boole=>boole(True::list boole)))andb
      (AllBList nat([list boole]list boole=>boole(False::list boole)))"))

; "ListLhZero"
(set-goal
 (pf "all list alpha^.STotal list alpha^ -> Lh list alpha^ =0 ->
                      Equal list alpha^(Nil alpha)"))
(cases)
(assume "Trivial")
(use "Eq-Refl")
(assume "alpha^" "list alpha^" "[STotal]" "IH")
(use "Efq")
(use "IH")
(save "ListLhZero")

; "AllBListIntro"
(set-goal
 (pf "all nat,list boole=>boole^.
       (all list boole^.Lh list boole^ =nat -> 
                        list boole=>boole^ list boole^) -> 
       AllBList nat list boole=>boole^"))
(ind)
(assume "list boole=>boole^")
(ng)
(strip)
(use 1)
(use "Truth-Axiom")
(assume "nat" "IH" "list boole=>boole^" "H")
(ng)
(split)
(use "IH")
(ng)
(assume "list boole^" "Lh list boole^ =nat")
(use "H")
(use "Lh list boole^ =nat")
(use "IH")
(ng)
(assume "list boole^" "Lh list boole^ =nat")
(use "H")
(use "Lh list boole^ =nat")
(save "AllBListIntro")

; "AllBListElim"
(set-goal
 (pf "all nat,list boole=>boole^.
       AllBList nat list boole=>boole^ -> 
       all list boole.Lh list boole =nat -> list boole=>boole^list boole"))
(ind)
(assume "list boole=>boole^" "H1")
(cases)
(assume "Trivial")
(use "H1")
(assume "boole" "list boole" "Absurd")
(use "Efq")
(use "Absurd")
(assume "nat" "IH" "list boole=>boole^" "H1")
(cases)
(assume "Absurd")
(use "Efq")
(use "Absurd")
(cases)
(assume "list boole")
(use-with "IH" (pt "[list boole1]list boole=>boole^(True::list boole1)")
	  "?" (pt "list boole"))
(ng)
(use "H1")
(assume "list boole")
(use-with "IH" (pt "[list boole1]list boole=>boole^(False::list boole1)")
	  "?" (pt "list boole"))
(ng)
(use "H1")
(save "AllBListElim")

