#!/usr/bin/python
# -*- coding: utf-8 -*-
#
#    MirrorKit - A python frontend to debmirror
#    Copyright (C) 2008-2009  Stephane Graber <stgraber@ubuntu.com>
#              (C) 2009       Michael Jeanson <mjeanson@rlnx.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

from distutils.core import setup
from glob import glob

setup(
    name="mirrorkit",
    version="0.1.1",
    description="A python frontend to debmirror",
    author="Stéphane Graber",
    author_email="stgraber@ubuntu.com",
    url='https://launchpad.net/mirrorkit',
    scripts = glob('src/bin/*'),
#    packages = ['mirrorkit'],
#    package_dir = {'mirrorkit':'src/lib/mirrorkit'},
    data_files = [
        ('share/man/man1', ['doc/mirrorkit.1']),
        ('share/mirrorkit/html', glob('src/share/html/*')),
        ('share/doc/mirrorkit/examples', glob('examples/*')),
    ]
)
