let header_rexp = Str.regexp "^\\([a-zA-Z_-]*\\)=\\(.*\\)$"

let read_variables channel =
  let rec f acc =
    try
      let pos = pos_in channel in
      let line = input_line channel in
        if Str.string_match header_rexp line 0 then
        begin
          let variable = Str.matched_group 1 line in
          let value = Str.matched_group 2 line in
            Misc.verbose ("...read binding " ^ variable ^ "=" ^ value);
            f ((variable, value) :: acc)
        end
        else
          (seek_in channel pos; acc)
    with End_of_file -> acc
  in
    f []

