# Copyright 2006 Soeren Boll Overgaard <boll@fork.dk>
#
# This file is part of mlmmjadmd.
#
# mlmmjadmd is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# mlmmjadmd is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with mlmmjadmd; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import shutil;
from SocketServer import *;
from socket import *;
from mlmmjadm.auth import *;
import conf;
import mlmmjadm.conf;
import logging;
import os;
import os.path;
import re;
from sys import *;
from util import *;

class MlmmjadmCommandHandler:
    
    connected = True;
    authenticator = None;
    authenticated = False;
    noSuchListMessage = "ER No such list available";
    noauthMessage = "ER Not authenticated, please use authenticate first"
    nolistMessage = "ER No list specified";
    nodataMessage = "ER No argument data specified";
    noSuchTunableMessage = "ER No such tunable";
    configuration = None;
    
    def __init__(self):
        self.authenticator = Authenticator();
        self.configuration = mlmmjadm.conf.Configuration();
    
    def checkTunable(self, list, tunable):
        if not self.isAuthenticated():
            return self.noauthMessage;
        if not list:
            return self.nolistMessage;
        if not listExists(list):
            return self.noSuchListMessage;
        if not tunable:
            return self.noSuchTunableMessage;
        controlDir = buildListControlDir(list);
        tunableFile = controlDir+"/"+tunable;
        result = "LI 1\nDA ";
        if fileExists(tunableFile):
            result += "True";
        else:
            result += "False";
        result += "\nOK Checked "+tunable;
        return result;
    
    def setTunable(self, list, tunable):
        if not self.isAuthenticated():
            return self.noauthMessage;
        if not list:
            return self.nolistMessage;
        if not listExists(list):
            return self.noSuchListMessage;
        if not tunable:
            return self.noSuchTunableMessage;
        controlDir = buildListControlDir(list);
        tunableFile = controlDir+"/"+tunable;
        if createFile(tunableFile):
            return "OK successfully set "+tunable;
        else:
            return "ER Unable to set "+tunable;
        
    def unsetTunable(self, list, tunable):
        if not self.isAuthenticated():
            return self.noauthMessage;
        if not list:
            return self.nolistMessage;
        if not listExists(list):
            return self.noSuchListMessage;
        if not tunable:
            return self.noSuchTunableMessage;
        controlDir = buildListControlDir(list);
        tunableFile = controlDir+"/"+tunable;
        if removeFile(tunableFile):
            return "OK Successfully unset "+tunable;
        else:
            return "ER Unable to unset "+tunable;

    
    def authenticate(self, user, password, sock):
        if not user:
            return "ER No username specified";
        if not password:
            return "ER No password specified";
        
        # self.authenticator.addUser("boll", "test");
        # self.authenticator.save();
        self.authenticated = self.authenticator.authenticate(user, password.strip());
        if self.authenticated:
            return "OK Authentication successful";
        else:
            return "ER Auhtentication failed";
    
    def listlists(self, data, null, sock):
        listCount = 0;
        result = "";
        if not self.isAuthenticated():
            return self.noauthMessage;
        lists = os.listdir(self.configuration.getListBase());
        for list in lists:
            if listExists(list):
                listCount += 1;
                result += "DA "+list+"\n";
        result = "LI "+str(listCount)+"\n" + result + "OK List list complete";
        return result;
    
    def addlist(self, name, data, sock):
        
        domain = "";
        owner = "";
        
        if not data:
            return self.nodataMessage;
        
        dataParts = data.split(" ");
        logging.debug("Data: "+data);
        if (len(dataParts)==2):
            domain = dataParts[0];
            owner = dataParts[1];
        else:
            logging.debug("Size of dataParts: "+str(len(dataParts)));
            return "ER No domain or no list owner provided";
                
        # Directories that must be created
        listBaseDir = self.configuration.getListBase() + "/" + name;
        listControlDir = listBaseDir + "/control";
        listModerationDir = listBaseDir + "/moderation";
        listArchiveDir = listBaseDir + "/archive";
        listBounceDir = listBaseDir + "/bounce";
        listDigestersDir = listBaseDir + "/digesters.d";
        listSubscribersDir = listBaseDir + "/subscribers.d";
        listIncomingDir = listBaseDir + "/incoming";
        listNomailSubsDir = listBaseDir + "/nomailsubs.d";
        listQueueDir = listBaseDir + "/queue";
        listRequeueDir = listBaseDir + "/requeue";
        listSubConfDir = listBaseDir + "/subconf";
        listTextDir = listBaseDir + "/text";
        listUnsubConfDir = listBaseDir + "/unsubconf";
        # Files that must be created
        listAddressFile = listControlDir + "/listaddress";
        listOwnerFiler = listControlDir + "/owner";
        
        try:
            os.makedirs(listBaseDir, 0755);
            os.makedirs(listControlDir,  0755);
            os.makedirs(listModerationDir,  0755);
            os.makedirs(listArchiveDir,  0755);
            os.makedirs(listBounceDir,  0755);
            os.makedirs(listDigestersDir,  0755);
            os.makedirs(listSubscribersDir,  0755);
            os.makedirs(listIncomingDir,  0755);
            os.makedirs(listNomailSubsDir,  0755);
            os.makedirs(listQueueDir,  0755);
            os.makedirs(listRequeueDir,  0755);
            os.makedirs(listSubConfDir,  0755);
            os.makedirs(listTextDir,  0755);
            os.makedirs(listUnsubConfDir,  0755);
        except OSError, e:
            logging.error("Unable to create directory: "+str(e));
            return "ER Unable to create list (unable to create dirs)";
        except IOError, e:
            logging.error("Unable to create directory: "+str(e));
            return "ER Unable to create list (an I/O error occurred)";
            
        # Copy list texts into place
        listTexts = os.listdir(self.configuration.getMlmmjListTextsDir());
        for text in listTexts:
            sourcePath = self.configuration.getMlmmjListTextsDir() + "/" + text;
            if fileExists(sourcePath):
                shutil.copy(sourcePath, listTextDir);

        try:
            addLine(listAddressFile, name+"@"+domain);
            addLine(listOwnerFiler,owner);
            
        except IOError, e:
            logging.error("Unable to create files: "+str(e));
            return "ER Unable to create list (unable to create files)";
        
        return "OK List created";
    
    def removelist(self, list, data, sock):
        if not self.isAuthenticated():
            return self.noauthMessage;
        if not listExists(list):
            return self.noSuchListMessage;
        # This is an ugly hack, but using os.rmdir 
        # is simply cludgy
        if os.system("rm -r "+buildListDir(list))==os.EX_OK:
            return "OK List deleted";
        else:
            return "ER Unable to completely remove list";
        
    def listmoderators(self, list, data, sock):
        result = "";
        if not self.isAuthenticated():
            return self.noauthMessage;
        if not listExists(list):
            return self.noSuchListMessage;
        moderators = getFileLines(buildListControlDir(list)+"/moderators");
        result = "LI "+str(len(moderators))+"\n";
        for moderator in moderators:
            result += "DA "+moderator+"\n";
        return result + "OK Moderators listed";
        
    
    def addmoderator(self, list, data, sock):
        if not self.isAuthenticated():
            return self.noauthMessage;
        if not list:
            return self.nolistMessage;
        if not data:
            return self.nodataMessage;
        if not listExists(list):
            return self.noSuchListMessage;
        controlDir = buildListControlDir(list);
        moderatorsFile = controlDir + "/moderators";
        addLine(moderatorsFile, data);
        return "OK Moderator added";
    
    def removemoderator(self, list, data, sock):
        if not self.isAuthenticated():
            return self.noauthMessage;
        if not list:
            return self.nolistMessage;
        if not data:
            return self.nodataMessage;
        if not listExists(list):
            return self.noSuchListMessage;
        controlDir = buildListControlDir(list);
        moderatorsFile = controlDir + "/moderators";
        removeLine(moderatorsFile, data);
        return "OK Moderator removed";
    
    def listdigestsubscribers(self, list, data, sock):
        result = "";
        lineCount = 0;
        if not self.isAuthenticated():
            return self.noauthMessage;
        if not list:
            return self.nolistMessage;
        if not listExists(list):
            return self.noSuchListMessage;
        source = os.popen4(self.configuration.getMlmmjList() +
                           " -L " + self.configuration.getListBase() + "/" + list +
                           " -d ", 
                           "r")[1];
        line = source.readline();
        while (line):
            lineCount += 1;
            result += "DA "+line;
            line = source.readline();
        
        result += "OK Digest subscribers listed";
        result = "LI "+str(lineCount)+"\n" + result;
        return result;
    
    def adddigestsubscriber(self, list, data, sock):
        result = os.EX_OK;
        if not self.isAuthenticated():
            return self.noauthMessage;
        if not list:
            return self.nolistMessage;
        if not data:
            return self.nodataMessage;
        if not listExists(list):
            return self.noSuchListMessage;
        result = os.system(self.configuration.getMlmmjSub() +
                        " -s " +
                        " -d " +
                        " -L " + self.configuration.getListBase() + "/" + list +
                        " -a " + data);
        if (result==os.EX_OK):
            return "OK User subscribed to digest";
        else:
            return "ER Unable to subscribe user to digest, please check the mlmmj logs for details";
        pass;
    
    def removedigestsubscriber(self, list, data, sock):
        result = os.EX_OK;
        if (not self.isAuthenticated()):
            return self.noauthMessage;
        if not list:
            return self.nolistMessage;
        if not data:
            return self.nodataMessage;
        if not listExists(list):
            return self.noSuchListMessage;
        result = os.system(self.configuration.getMlmmjUnsub() +
                        " -s " +
                        " -d " +
                        " -L " + self.configuration.getListBase() + "/" + list +
                        " -a " + data);
        if (result==os.EX_OK):
            return "OK User unsubscribed from digest";
        else:
            return "ER Unable to unsubscribe user from digest, please check mlmmj logs for details";
        
    
    def setmoderated(self, list, data, sock):
        return self.setTunable(list, "moderated");
        
    def unsetmoderated(self, list, data, sock):
        return self.unsetTunable(list, "moderated");
    
    def getmoderated(self, list, data, sock):
        return self.checkTunable(list, "moderated");
        
    def setclosedlist(self, list, data, sock):
        return self.setTunable(list, "closedlist");
    
    def unsetclosedlist(self, list, data, sock):
        return self.unsetTunable(list, "closedlist");
    
    def getclosedlist(self, list, data, sock):
        return self.checkTunable(list, "closedlist");
    
    def setclosedlistsub(self, list, data, sock):
        return self.setTunable(list, "closedlistsub");
    
    def unsetclosedlistsub(self, list, data, sock):
        return self.unsetTunable(list, "closedlistsub");
    
    def getclosedlistsub(self, list, data, sock):
        return self.checkTunable(list, "closedlistsub");
    
    def settocc(self, list, data, sock):
        return self.setTunable(list,"tocc");
    
    def unsettocc(self, list, data, sock):
        return self.unsetTunable(list, "tocc");
    
    def gettocc(self, list, data, sock):
        return self.checkTunable(list, "tocc");
    
    def setsubonlypost(self, list, data, sock):
        return self.setTunable(list, "subonlypost");
    
    def unsetsubonlypost(self, list, data, sock):
        return self.setTunable(list, "subonlypost");
    
    def getsubonlypost(self, list, data, sock):
        return self.checkTunable(list, "subonlypost");
    
    def setprefix(self, list, prefix, sock):
        if not self.isAuthenticated():
            return self.noauthMessage;
        if not list:
            return self.nolistMessage;
        if not listExists(list):
            return self.noSuchListMessage;
        controlDir = buildListControlDir(list);
        prefixFile = controlDir + "/prefix";
        if fileExists(prefixFile):
            removeFile(prefixFile);
        if addLine(prefixFile, prefix):
            return "OK Prefix added";
        else:
            return "ER Unable to add prefix";
    
    def unsetprefix(self, list, data, sock):
        return self.unsetTunable(list, "prefix");
    
    def getprefix(self, list, data, sock):
        if not self.isAuthenticated():
            return self.noauthMessage;
        if not list:
            return self.nolistMessage;
        if not listExists(list):
            return self.noSuchListMessage;
        controlDir = buildListControlDir(list);
        prefixFile = controlDir + "/prefix";
        prefix = readSingleLineFile(prefixFile);
        if prefix:
            return "LI 1\nDA "+prefix.strip()+"\nOK Prefix found";
        else:
            return "LI 0\nOK No prefix is currently defined for this list";
        
    def addowner(self, list, owner, sock):
        if not self.isAuthenticated():
            return self.noauthMessage;
        if not list:
            return self.nolistMessage;
        if not listExists(list):
            return self.noSuchListMessage;
        controlDir = buildListControlDir(list);
        ownerFile = controlDir+"/owner";
        if addLine(ownerFile, owner.strip()):
            return "OK Owner added";
        else:
            return "ER Unable to add owner";
    
    def removeowner(self, list, owner, sock):
        if not self.isAuthenticated():
            return self.noauthMessage;
        if not list:
            return self.nolistMessage;
        if not listExists(list):
            return self.noSuchListMessage;
        controlDir = buildListControlDir(list);
        ownerFile = controlDir+"/owner";
        if removeLine(ownerFile, owner.strip()):
            return "OK Owner removed";
        else:
            return "ER Unable to remove owner";
    
    def listowners(self, list, data, sock):
        if not self.isAuthenticated():
            return self.noauthMessage;
        if not list:
            return self.nolistMessage;
        if not listExists(list):
            return self.noSuchListMessage;
        controlDir = buildListControlDir(list);
        ownerFile = controlDir+"/owner";
        owners = getFileLines(ownerFile);
        result = "LI "+str(len(owners))+"\n";
        for owner in owners:
            result = result + "DA "+owner.strip()+"\n";
        result = result+"OK Owners listed";
        return result;
    
    def addcustomheader(self, list, header, sock):
        if not self.isAuthenticated():
            return self.noauthMessage;
        if not list:
            return self.nolistMessage;
        if not listExists(list):
            return self.noSuchListMessage;
        controlDir = buildListControlDir(list);
        headersFile = controlDir+"/customheaders";
        if addLine(headersFile, header.strip()):
            return "OK Custom header added";
        else:
            return "ER Unable to add custom header";
    
    def removecustomheader(self, list, header, sock):
        if not self.isAuthenticated():
            return self.noauthMessage;
        if not list:
            return self.nolistMessage;
        if not listExists(list):
            return self.noSuchListMessage;
        controlDir = buildListControlDir(list);
        headersFile = controlDir+"/customheaders";
        if removeLine(headersFile, header.strip()):
            return "OK Custom header removed";
        else:
            return "ER Unable to remove custom header";
        
    def listcustomheaders(self, list, data, sock):
        result = "";
        if not self.isAuthenticated():
            return self.noauthMessage;
        if not list:
            return self.nolistMessage;
        if not listExists(list):
            return self.noSuchListMessage;
        controlDir = buildListControlDir(list);
        headersFile= controlDir+"/customheaders";
        headers = getFileLines(headersFile);
        if headers:
            result = "LI "+str(len(headers))+"\n";
            for header in headers:
                result += "DA "+header.strip()+"\n";
            result += "OK Custom headers listed";
        else:
            result = "ER Unable to list headers";
        return result; 
        
    def adddelheader(self, list, header, sock):
        if not self.isAuthenticated():
            return self.noauthMessage;
        if not list:
            return self.nolistMessage;
        if not listExists(list):
            return self.noSuchListMessage;
        controlDir = buildListControlDir(list);
        headersFile = controlDir+"/delheaders";
        if addLine(headersFile, header.strip()):
            return "OK Deletable header added";
        else:
            return "ER Unable to add deletable header";
    
    def removedelheader(self, list, header, sock):
        if not self.isAuthenticated():
            return self.noauthMessage;
        if not list:
            return self.nolistMessage;
        if not listExists(list):
            return self.noSuchListMessage;
        controlDir = buildListControlDir(list);
        headersFile = controlDir+"/delheaders";
        if removeLine(headersFile, header.strip()):
            return "OK Deletable header removed";
        else:
            return "ER Unable to remove deletable header";
    
    def listdelheaders(self, list, data, sock):
        result = "";
        if not self.isAuthenticated():
            return self.noauthMessage;
        if not list:
            return self.nolistMessage;
        if not listExists(list):
            return self.noSuchListMessage;
        controlDir = buildListControlDir(list);
        headersFile= controlDir+"/delheaders";
        headers = getFileLines(headersFile);
        if headers:
            result = "LI "+str(len(headers))+"\n";
            for header in headers:
                result += "DA "+header.strip()+"\n";
            result += "OK Deleteable headers listed";
        else:
            result = "ER Unable to list headers";
        return result; 
    
    # FIXME
    # Careful with these two. Arbitrary regexp's are not 
    # allowed through the input buffer sanitizer
    def addaccessrule(self, list, rule, sock):
        return "ER Not yet implemented";
    
    def removeaccessrule(self, list, data, sock):
        return "ER Not yet implemented";
    
    def setmemorymailsize(self, list, size, sock):
        if not self.isAuthenticated():
            return self.noauthMessage;
        if not list:
            return self.nolistMessage;
        if not listExists(list):
            return self.noSuchListMessage;
        controlDir = buildListControlDir(list);
        memorySizeFile = controlDir + "/memorymailsize";
        if writeSingleLineFile(memorySizeFile, size):
            return "OK Memory mail size set";
        else:
            return "ER Unable to set memory mail size";
    
    def unsetmemorymailsize(self, list, data, sock):
        if not self.isAuthenticated():
            return self.noauthMessage;
        if not list:
            return self.nolistMessage;
        if not listExists(list):
            return self.noSuchListMessage;
        controlDir = buildListControlDir(list);
        memorySizeFile = controlDir + "/memorymailsize";
        if removeFile(memorySizeFile):
            return "OK Unset memory mail size";
        else:
            return "ER Unable to unset memory mail size";

    def getmemorymailsize(self, list, data, sock):
        if not self.isAuthenticated():
            return self.noauthMessage;
        if not list:
            return self.nolistMessage;
        if not listExists(list):
            return self.noSuchListMessage;
        controlDir = buildListControlDir(list);
        memorySizeFile = controlDir + "/memorymailsize";
        memorySize = readSingleLineFile(memorySizeFile);
        if memorySize:
            return "LI 1\nDA "+memorySize.strip()+"\nOK Memory size found";
        else:
            return "LI 0\nOK No memory size is currently defined for this list";

    def setaddtohdr(self, list, data, sock):
        return self.setTunable(list, "addtohdr");
    
    def unsetaddtohdr(self, list, data, sock):
        return self.unsetTunable(list, "addtohdr");
    
    def getaddtohdr(self, list, data, sock):
        return self.checkTunable(list, "addtohdr");
    
    def setrelayhost(self, list, data, sock):
        if not self.isAuthenticated():
            return self.noauthMessage;
        if not list:
            return self.nolistMessage;
        if not listExists(list):
            return self.noSuchListMessage;
        controlDir = buildListControlDir(list);
        relayHostFile = controlDir + "/relayhost";
        if writeSingleLineFile(relayHostFile, size):
            return "OK Successfully set relay host";
        else:
            return "ER Unable to set the relay host";
    
    def unsetrelayhost(self, list, data, sock):
        if not self.isAuthenticated():
            return self.noauthMessage;
        if not list:
            return self.nolistMessage;
        if not listExists(list):
            return self.noSuchListMessage;
        controlDir = buildListControlDir(list);
        relayHostFile = controlDir + "/relayhost";
        if removeFile(memorySizeFile):
            return "OK Successfully unset the relay host";
        else:
            return "ER Unable to unset the relay host";
    
    def getrelayhost(self, list, data, sock):
        if not self.isAuthenticated():
            return self.noauthMessage;
        if not list:
            return self.nolistMessage;
        if not listExists(list):
            return self.noSuchListMessage;
        controlDir = buildListControlDir(list);
        relayHostFile = controlDir + "/relayhost";
        relayHost = readSingleLineFile(relayHostFile);
        if relayHost:
            return "LI 1\nDA "+relayHost.strip()+"\nOK Relay host found";
        else:
            return "LI 0\nOK No relay host is currently defined for this list";
    
    def setnotifysub(self, list, data, sock):
        return self.setTunable(list, "notifysub");
    
    def unsetnotifysub(self, list, data, sock):
        return self.unsetTunable(list, "notifysub");
    
    def getnotifysub(self, list, data, sock):
        return self.checkTunable(list, "notifysub");
    
    def setdigestinterval(self, list, interval, sock):
        if not self.isAuthenticated():
            return self.noauthMessage;
        if not list:
            return self.nolistMessage;
        if not listExists(list):
            return self.noSuchListMessage;
        controlDir = buildListControlDir(list);
        digestIntervalFile = controlDir + "/digestinterval";
        if writeSingleLineFile(digestIntervalFile, interval):
            return "OK Successfully set digest interval";
        else:
            return "ER Unable to set the digest interval";
    
    def unsetdigestinterval(self, list, data, sock):
        if not self.isAuthenticated():
            return self.noauthMessage;
        if not list:
            return self.nolistMessage;
        if not listExists(list):
            return self.noSuchListMessage;
        controlDir = buildListControlDir(list);
        digestIntervalFile = controlDir + "/digestinterval";
        if removeFile(digestIntervalFile):
            return "OK Unset digest interval.";
        else:
            return "ER Unable to unset digest interval";
    
    def getdigestinterval(self, list, data, sock):
        if not self.isAuthenticated():
            return self.noauthMessage;
        if not list:
            return self.nolistMessage;
        if not listExists(list):
            return self.noSuchListMessage;
        controlDir = buildListControlDir(list);
        digestIntervalFile = controlDir + "/digestinterval";
        digestInterval = readSingleLineFile(digestIntervalFile);
        if digestInterval:
            return "LI 1\nDA "+digestInterval.strip()+"\nOK Digest interval found";
        else:
            return "LI 0\nOK No digest interval is currently defined for this list";
    
    def setdigestmaxmails(self, list, maxmails, sock):
        if not self.isAuthenticated():
            return self.noauthMessage;
        if not list:
            return self.nolistMessage;
        if not listExists(list):
            return self.noSuchListMessage;
        controlDir = buildListControlDir(list);
        digestMaxMailsFile = controlDir + "/digestmaxmails";
        if writeSingleLineFile(digestMaxMailsFile, maxmails):
            return "OK Successfully set maximum digest mails";
        else:
            return "ER Unable to set the maximum digest mails";
    
    def unsetdigestmaxmails(self, list, data, sock):
        if not self.isAuthenticated():
            return self.noauthMessage;
        if not list:
            return self.nolistMessage;
        if not listExists(list):
            return self.noSuchListMessage;
        controlDir = buildListControlDir(list);
        digestMaxMailsFile = controlDir + "/digestmaxmails";
        if removeFile(digestMaxMailsFile):
            return "OK Unset maximum digest mails";
        else:
            return "ER Unable to unset maximum digest mails";
    
    def getdigestmaxmails(self, list, data, sock):
        if not self.isAuthenticated():
            return self.noauthMessage;
        if not list:
            return self.nolistMessage;
        if not listExists(list):
            return self.noSuchListMessage;
        controlDir = buildListControlDir(list);
        digestMaxMailsFile = controlDir + "/digestmaxmails";
        digestMaxMails = readSingleLineFile(digestMaxMailsFile);
        if digestMaxMails:
            return "LI 1\nDA "+digestMaxMails.strip()+"\nOK Max mails found";
        else:
            return "LI 0\nOK No max digest mail count is currently defined for this list";
    
    def setbouncelife(self, list, duration, sock):
        if not self.isAuthenticated():
            return self.noauthMessage;
        if not list:
            return self.nolistMessage;
        if not listExists(list):
            return self.noSuchListMessage;
        controlDir = buildListControlDir(list);
        bounceLifeFile = controlDir + "/bouncelife";
        if writeSingleLineFile(bounceLifeFile, duration):
            return "OK Successfully set bounce life";
        else:
            return "ER Unable to set the bounce life";
    
    def unsetbouncelife(self, list, data, sock):
        if not self.isAuthenticated():
            return self.noauthMessage;
        if not list:
            return self.nolistMessage;
        if not listExists(list):
            return self.noSuchListMessage;
        controlDir = buildListControlDir(list);
        bounceLifeFile = controlDir + "/bouncelife";
        if removeFile(bounceLifeFile):
            return "OK Unset bounce life";
        else:
            return "ER Unable to unset bounce life";
    
    def getbouncelife(self, list, data, sock):
        if not self.isAuthenticated():
            return self.noauthMessage;
        if not list:
            return self.nolistMessage;
        if not listExists(list):
            return self.noSuchListMessage;
        controlDir = buildListControlDir(list);
        bounceLifeFile = controlDir + "/bouncelife";
        bounceLife = readSingleLineFile(bounceLifeFile);
        if bounceLife:
            return "LI 1\nDA "+bounceLife.strip()+"\nOK Bounce life found";
        else:
            return "LI 0\nOK No bounce life is currently defined for this list";
    
    def setnoarchive(self, list, data, sock):
        return self.setTunable(list, "noarchive");
    
    def unsetnoarchive(self, list, data, sock):
        return self.unsetTunable(list, "noarchive");
    
    def getnoarchive(self, list, data, sock):
        return self.checkTunable(list, "noarchive");
    
    def setnosubconfirm(self, list, data, sock):
        return self.setTunable(list, "nosubconfirm");
    
    def unsetnosubconfirm(self, list, data, sock):
        return self.unsetTunable(list, "nosubconfirm");
    
    def setnoget(self, list, data, sock):
        return self.setTunabel(list, "noget");
    
    def unsetnoget(self, list, data, sock):
        return self.setTunable(list, "noget");
    
    def getnoget(self, list, data, sock):
        return self.checkTunable(list, "noget");
    
    def setsubonlyget(self, list, data, sock):
        return self.setTunable(list, "subonlyget");
    
    def unsetsubonlyget(self, list, data, sock):
        return self.unsetTunable(list, "subonlyget");
    
    def getsubonlyget(self, list, data, sock):
        return self.checkTunable(list, "subonlyget");
    
    def setsmtpport(self, list, port, sock):
        if not self.isAuthenticated():
            return self.noauthMessage;
        if not list:
            return self.nolistMessage;
        if not listExists(list):
            return self.noSuchListMessage;
        controlDir = buildListControlDir(list);
        smtpPortFile = controlDir + "/smtpport";
        if writeSingleLineFile(smtpPortFile, port):
            return "OK Successfully set smtp port";
        else:
            return "ER Unable to set the smtp port";
    
    def unsetsmtpport(self, list, data, sock):
        if not self.isAuthenticated():
            return self.noauthMessage;
        if not list:
            return self.nolistMessage;
        if not listExists(list):
            return self.noSuchListMessage;
        controlDir = buildListControlDir(list);
        smtpPortFile = controlDir + "/smtpport";
        if removeFile(smtpPortFile):
            return "OK Unset digest interval.";
        else:
            return "ER Unable to unset digest interval";
    
    def getsmtpport(self, list, data, sock):
        if not self.isAuthenticated():
            return self.noauthMessage;
        if not list:
            return self.nolistMessage;
        if not listExists(list):
            return self.noSuchListMessage;
        controlDir = buildListControlDir(list);
        smtpPortFile = controlDir + "/smtpport";
        smtpPort = readSingleLineFile(smtpPortFile);
        if smtpPort:
            return "LI 1\nDA "+smtpPort.strip()+"\nOK SMTP port found";
        else:
            return "LI 0\nOK No SMTP port is currently defined for this list";
    
    # FIXME
    # Careful, do we actually accept the delimiter characters
    def setdelimiter(self, list, delimiter, sock):
        if not self.isAuthenticated():
            return self.noauthMessage;
        if not list:
            return self.nolistMessage;
        if not listExists(list):
            return self.noSuchListMessage;
        controlDir = buildListControlDir(list);
        delimiterFile = controlDir + "/delimiter";
        if writeSingleLineFile(delimiterFile, interval):
            return "OK Successfully set delimiter";
        else:
            return "ER Unable to set the delimiter";
    
    def unsetdelimiter(self, list, data, sock):
        if not self.isAuthenticated():
            return self.noauthMessage;
        if not list:
            return self.nolistMessage;
        if not listExists(list):
            return self.noSuchListMessage;
        controlDir = buildListControlDir(list);
        delimiterFile = controlDir + "/delimiter";
        if removeFile(delimiterFile):
            return "OK Unset delimiter";
        else:
            return "ER Unable to unset delimiter";
    
    def getdelimiter(self, list, data, sock):
        if not self.isAuthenticated():
            return self.noauthMessage;
        if not list:
            return self.nolistMessage;
        if not listExists(list):
            return self.noSuchListMessage;
        controlDir = buildListControlDir(list);
        delimiterFile = controlDir + "/delimiter";
        delimiter = readSingleLineFile(delimiterFile);
        if delimiter:
            return "LI 1\nDA "+delimiter.strip()+"\nOK Delimiter found";
        else:
            return "LI 0\nOK No delimiter is currently defined for this list";
    
    def isAuthenticated(self):
        return self.authenticated;
    
    def echo(self, list, data, sock):
        return "OK Echo";
    
    def addsubscriber(self, list, data, sock):
        result = os.EX_OK;
        if not self.isAuthenticated():
            return self.noauthMessage;
        if not list:
            return self.nolistMessage;
        if not data:
            return self.nodataMessage;
        if not listExists(list):
            return self.noSuchListMessage;
        result = os.system(self.configuration.getMlmmjSub() +
                        " -s " +
                        " -L " + self.configuration.getListBase() + "/" + list +
                        " -a " + data);
        if (result==os.EX_OK):
            return "OK User subscribed";
        else:
            return "ER Unable to subscribe user, please check the mlmmj logs for details";
    
    def removesubscriber(self, list, data, sock):
        result = os.EX_OK;
        if not self.isAuthenticated():
            return self.noauthMessage;
        if not list:
            return self.nolistMessage;
        if not data:
            return self.nodataMessage;
        if not listExists(list):
            return self.noSuchListMessage;
        result = os.system(self.configuration.getMlmmjUnsub() +
                        " -s " +
                        " -L " + self.configuration.getListBase() + "/" + list +
                        " -a " + data);
        if (result==os.EX_OK):
            return "OK User unsubscribed";
        else:
            return "ER Unable to unsubscribe user, please check mlmmj logs for details";
        
    
    def listsubscribers(self, list, data, sock):
        result = "";
        lineCount = 0;
        if not self.isAuthenticated():
            return self.noauthMessage;
        if not list:
            return self.nolistMessage;
        if not listExists(list):
            return self.noSuchListMessage;
        source = os.popen4(self.configuration.getMlmmjList() +
                           " -L " + self.configuration.getListBase() + "/" + list +
                           " -s", 
                           "r")[1];
        line = source.readline();
        while (line):
            lineCount += 1;
            result += "DA "+line;
            line = source.readline();
        
        result += "OK Subscribers listed";
        result = "LI "+str(lineCount)+"\n" + result;
        return result;
    
    def noSuchMethod(self, list, data, sock):
        return "ER Unknown method called";
    
    def quit(self, list, data, sock):
        sock.shutdown(SHUT_RDWR);
        sock.close();
        self.connected = False;
        # This will never get sent
        return "OK Closing connection";


class Server(ThreadingMixIn, TCPServer):
    pass;


class ServerRequestHandler(BaseRequestHandler):
    def handle(self):
        # Probably use socket.makefile()

        buffer = True;
        command = None;
        list = None;
        data = None;
        method = None;
        ch = MlmmjadmCommandHandler();
        commandParts = None;
        logging.debug("Connection received from "+self.client_address[0]+":"+str(self.client_address[1]));
        
        
        input = self.request.makefile()
        
        buffer = input.readline()
        while buffer:
            
            list = None;
            data = None;
            command = None;
            method = None;
            
            buffer = buffer.strip();
            
            logging.debug("Input buffer: "+buffer);
            
            # Make sure that input data is clean
            allowedExp1 = re.compile("^[a-z0-9\-@\. ]*$", re.I);
            allowedExp2 = re.compile(".*\.\..*",re.I);
            if not allowedExp1.match(buffer) or allowedExp2.match(buffer):
                response = "ER Illegal input detected";
            else:
                commandParts = buffer.split(" ");
            
                if len(commandParts) < 3:
                    data = None;
                else:
                    data = " ".join(commandParts[2:]);
                
                if len(commandParts) < 2:
                    response = "ER No list specified";
                else:
                    list = commandParts[1];
                
                if len(commandParts) < 1:
                    command = None;
                    continue;
                else:
                    command = commandParts[0].lower();
                    method = command.lower();
                
            
                method = getattr(ch, method, ch.noSuchMethod);
                response = method(list, data, self.request);
                
            if ch.connected:
                self.request.sendall(response+"\n");
            
            buffer = input.readline();
            
        logging.debug("Connection terminated.");