/*******************************************************************************
*                                                                              *
*   (C) 1997-2021 by Ernst W. Mayer.                                           *
*                                                                              *
*  This program is free software; you can redistribute it and/or modify it     *
*  under the terms of the GNU General Public License as published by the       *
*  Free Software Foundation; either version 2 of the License, or (at your      *
*  option) any later version.                                                  *
*                                                                              *
*  This program is distributed in the hope that it will be useful, but WITHOUT *
*  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or       *
*  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for   *
*  more details.                                                               *
*                                                                              *
*  You should have received a copy of the GNU General Public License along     *
*  with this program; see the file GPL.txt.  If not, you may view one at       *
*  http://www.fsf.org/licenses/licenses.html, or obtain one by writing to the  *
*  Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA     *
*  02111-1307, USA.                                                            *
*                                                                              *
*******************************************************************************/

/****************************************************************************
 * We now include this header file if it was not included before.
 ****************************************************************************/
#ifndef fac_test_dat96_included
#define fac_test_dat96_included

	#include "types.h"

	// Testcases for factors up to 96 bits store all bits of the factor in a uint96.
	struct testFac96{
		uint64 p;	// Feb 2020: Make 64-bit to properly test 96-bit modpow code; added several p > 2^32 testcases at bottom
		uint32 d1;
		uint64 d0;
	};

	/* Factors <= 96 bits: */
	static const struct testFac96 fac96[] =
	{
		{18276023,         1u, 9352652860056109297ull},{18169451,         1u, 9391223343761911353ull},{18101203,         1u, 9245198838244718175ull},{18200431,         1u, 9638047650792060207ull},{18153137,         1u, 9331979875586794647ull},
		{18286589,         1u, 9164964664217404903ull},{18087869,         1u,18404873023603575487ull},{18211181,         1u,10434605500782496975ull},{18211313,         1u,15746090072000275711ull},{18085237,         1u,10657076381559003585ull},
		{18210259,         1u,16355331429482797863ull},{18084967,         1u,12535841202704578975ull},{18084109,         1u,16470485288787225105ull},{18214087,         1u,10207338191440827513ull},{18214733,         1u,17740871572718924041ull},
		{18219479,         1u,18017792182604237361ull},{18066011,         1u,11376490360570509583ull},{18066007,         1u,11743936157345608143ull},{18242551,         1u,16695389546547233823ull},{18243733,         1u,13242634967295051207ull},
		{18051727,         1u,12764547214878403897ull},{18198319,         1u,14789209292635722871ull},{18252719,         1u,11949949204123386865ull},{18112553,         1u,14699169213035249007ull},{18188237,         1u,12547222997198167135ull},
		{18253273,         1u,15022424507268036615ull},{18177769,         1u,11181456191737830247ull},{18261431,         1u,12524685482980431153ull},{18263183,         1u,13717086022817448657ull},{18266477,         1u,13203156723265013793ull},
		{18165269,         1u,15387405357686244967ull},{18268543,         1u,10094150846373329745ull},{18134009,         1u,16150555121170358703ull},{18134147,         1u,12395351030116788801ull},{18134503,         1u,15773366615529206215ull},
		{18039589,         1u,12778558630672248943ull},{18276109,         1u,16390963948859540473ull},{18030241,         1u,15223465608795025207ull},{18285769,         1u,16970223144559381623ull},{18128549,         1u,15621768181131297471ull},
		{18285779,         1u,16993305172548993081ull},{18018739,         1u,14782732913885672961ull},{18295141,         1u,15005657306462735095ull},{18067589,         1u,13635840857860527775ull},{18295429,         2u,11468839311814080137ull},
		{18141763,         2u, 3092281768231311825ull},{18013091,         2u, 6772961738882249817ull},{18141511,         2u, 9576098065896122991ull},{18141127,         2u, 2247772876461344439ull},{18138203,         2u, 4695706118051975177ull},
		{18161641,         2u, 3950924079024657471ull},{18292093,         2u,12421322989569225951ull},{18123713,         2u,12125574039462479825ull},{18123709,         2u,10308047940655965639ull},{18173257,         2u,  207535002320717055ull},
		{18173983,         2u,14403605950085358951ull},{18120779,         2u, 9422223333804691761ull},{18019927,         2u,  408406707228848249ull},{18288797,         2u,17360156522995678599ull},{18177359,         2u,14832757638836506257ull},
		{18021973,         2u,13957432374640225095ull},{18025373,         2u,10098147461342295887ull},{18030193,         2u,15607091523248359911ull},{18118223,         2u, 2086356729639751937ull},{18185821,         2u, 1689334627499619465ull},
		{18117667,         2u,18215785349680460505ull},{18191837,         2u, 4493229489136679145ull},{18039271,         2u,16908805479784654401ull},{18281567,         2u,  933612760336845065ull},{18277937,         2u,10828438976824746849ull},
		{18039583,         2u,16417153962708385977ull},{18106591,         2u, 6626926712493143231ull},{18104287,         2u, 5723270436532623081ull},{18100177,         2u, 5071318343531010431ull},{18201467,         2u, 8160208643402298681ull},
		{18096061,         2u, 5937864839522586857ull},{18273883,         2u, 9773485756057249919ull},{18205183,         2u,15965092645879202447ull},{18272207,         2u,18262224097511217255ull},{18034481,         2u,13499269779109594391ull},
		{18206509,         2u, 8346049916247856479ull},{18093931,         2u, 9016815379266258047ull},{18270737,         2u,14523795906613507401ull},{18093689,         2u, 7580734199533821447ull},{18268721,         2u,11636683762416614271ull},
		{18092993,         2u, 3762951486187803561ull},{18089803,         2u,15886632766576700241ull},{18034843,         2u, 9087385776245663847ull},{18268303,         2u, 7107598341676734585ull},{18041711,         2u,10757635336355125415ull},
		{18080327,         2u, 4758087939326186009ull},{18264241,         2u,11059071541209885857ull},{18044431,         2u,12003164749400602311ull},{18259963,         2u,15572392068966635289ull},{18258577,         2u,10083568368046177095ull},
		{18076199,         2u, 1454254024310888471ull},{18067363,         2u, 6406596177417022745ull},{18050309,         2u,18266669341317591087ull},{18225367,         2u,  761543200176047729ull},{18066091,         2u, 4899820894457011847ull},
		{18233899,         2u,15827163809275823697ull},{18233951,         2u,12763352503716067857ull},{18050917,         2u,12630824986549901607ull},{18237679,         2u,  577537617363161615ull},{18051611,         2u,  926957969535303017ull},
		{18051823,         2u, 7818658096538148999ull},{18248603,         2u,16682557782845116569ull},{18064201,         2u, 4069052049914747889ull},{18060871,         2u,11707201997664612815ull},{18243989,         2u, 6890936471658773391ull},
		{18248441,         2u,17190543255548706647ull},{18246433,         2u,12208236782114945297ull},{18056369,         3u,17384615928981125225ull},{18239717,         3u,13146163309434854663ull},{18239423,         3u, 9830331743268882449ull},
		{18064247,         3u,12694290879965764249ull},{18051413,         3u,14413895596060013105ull},{18250439,         3u,10025619183380103271ull},{18237281,         3u, 9125012626367750681ull},{18224879,         3u,11767560264583516825ull},
		{18255343,         3u, 5870725649191146911ull},{18256097,         3u, 3190651672811461271ull},{18221701,         3u, 3582478237908082991ull},{18219983,         3u, 8327348782275241889ull},{18050233,         3u, 6535190184551801743ull},
		{18261623,         3u,17086528894147714391ull},{18048889,         3u,14630863141546358215ull},{18078727,         3u,15550160336321956111ull},{18217873,         3u, 3021804603112513103ull},{18082877,         3u,10987147732897659511ull},
		{18086017,         3u,12672060712653398353ull},{18088957,         3u, 2906408230830983393ull},{18208621,         3u, 9127697742932317439ull},{18207347,         3u, 6623005940415687023ull},{18206281,         3u,11960252621902730281ull},
		{18271933,         3u,12291953682343228271ull},{18205601,         3u,16600095605189677529ull},{18203707,         3u,18008003865578937049ull},{18039629,         3u, 9427695590083594375ull},{18198977,         3u, 3076193691622372985ull},
		{18110383,         3u,  185345134978204289ull},{18196499,         3u,11880812732795403521ull},{18111229,         3u,11071059034249992329ull},{18035989,         3u, 5539705418955744265ull},{18183743,         3u,11415352866482141719ull},
		{18028897,         3u, 3716387045703399295ull},{18285781,         3u, 9357102466781895559ull},{18180077,         3u,15536479403169204695ull},{18022649,         3u, 5654606217092758855ull},{18118489,         3u, 6394983796367039201ull},
		{18287957,         3u, 8752778334904342079ull},{18176321,         3u,17471759203966653145ull},{18175529,         3u, 2271464572669811305ull},{18163883,         3u, 3719255206030166033ull},{18019699,         3u, 4310391407591765215ull},
		{18151579,         3u, 1595301140365420159ull},{18142301,         3u,12867206532962105191ull},{18143519,         3u, 2481422238311117321ull},
		{ 7244507,  25571934u,17645344339951798897ull},{ 7414637,       164u, 4116711638593590185ull},{ 7723447,      5420u,12562746707691010049ull},
		{ 7818977,      1353u,  659102583034765273ull},{ 8029633,       831u, 7916220548900207543ull},{ 8053889,   2103436u, 1167145018735557081ull},{ 8086453,      1227u,17541595206117360217ull},{ 8095291,      1704u,13708852579508485207ull},
		{ 8168357,     87810u, 6610049516710328711ull},{ 8184557,        33u, 2763581858425117679ull},{ 8243537,       531u, 5525174834371803241ull},{ 8259871,        14u,  796855330669004183ull},{ 8272661,       380u,14241720166580408009ull},
		{ 8273437,  25987538u,14814742953278716353ull},{ 8283053,       161u,13929456041379261263ull},{ 8297321,   3034093u, 8730546825436233825ull},{ 8314843,   2684125u, 6454422580796036649ull},{ 8333579,       854u,13655594228639799257ull},
		{ 8361211,        12u, 8939076096818105929ull},{ 8390441,       595u, 4193551430717959153ull},{ 8422597,      1366u, 7870914753859973521ull},{ 8427803,      1474u,11450161366987292943ull},{ 8444941,      2885u,11827496755524969729ull},
		{ 8461697,        90u, 5398489150994146721ull},{ 8484347,         6u,12630454963470541663ull},{ 8489857,         8u,17355799175298876081ull},{ 8493427,       805u, 9747852211561597759ull},{ 8529877,       136u,16465808959478947065ull},
		{ 8592989,      1038u, 8509600750746547649ull},{ 8620109,         4u, 9079157166504874159ull},{ 8622461,         5u, 2437973634125785521ull},{ 8654389,         8u, 9482848212441108929ull},{ 8654579,        21u,11899068713858479361ull},
		{ 8656603,        93u,15062407632802667551ull},{ 8658217,        80u, 6325248917681739887ull},{ 8668423,        28u,18320769443016069721ull},{ 8674759,         7u,18284948339037548257ull},{ 8676287,        14u, 3843963214618658969ull},
		{ 8678947,      5396u, 2636802174995602407ull},{ 8681021,       401u, 4998736748668298991ull},{ 8681579,        30u,16135213582861992497ull},{ 8683729,         8u,11293259574337184559ull},{ 8688011,       145u, 9578503463191650391ull},
		{ 8692877,     36661u,18428023068529200991ull},{ 8697607,        17u,  870550676082897689ull},{ 8704219,     27999u,16201955968424701817ull},{ 8711159,        17u,11366350694546647641ull},{ 8719301,        88u,13672547084272167169ull},
		{ 8722339,      7423u,18156437144620420569ull},{ 8723123,    217954u, 6973216771046930049ull},{ 8725657,        63u, 2916601161951227239ull},{ 8725841,        25u,13195469447575389151ull},{ 8738729,         6u, 8170383313133995223ull},
		{ 8740939,       240u, 4617356654063117857ull},{ 8747819,    108516u, 9367350152656600871ull},{ 8749571,         9u,15657372839554601087ull},{ 8751563,         5u,13841889794965422657ull},{ 8755027,       593u,16519620384372861863ull},
		{ 8756101,      8284u, 6072693151654549537ull},{ 8763817,       119u, 6048599338562527617ull},{ 8767069,    257333u,15121360214969010561ull},{ 8776997,        64u,14339583161777897937ull},{ 8789447,       215u, 3202800343531181993ull},
		{ 8799389,       709u, 1702544524884741217ull},{ 8799529,     22022u, 3369348266587752401ull},{ 8800037,        17u, 1648884270309857487ull},{ 8801491,      3693u,16652078850798618551ull},{ 8802329,       419u,15755726911414877649ull},
		{ 8808773,       440u, 2473070962046579177ull},{ 8815151,        52u,  819707353106726625ull},{ 8816747,     92343u,16904660106867077831ull},{ 8823883,    520923u, 3776175324622247383ull},{ 8824301,       439u, 8808290111578886823ull},
		{ 8827319,   9331025u,10299995606463506351ull},{ 8839343,        93u,10232357004734229929ull},{ 8845349,     17999u,17028006110880085593ull},{ 8845399,       480u, 5232264661915708753ull},{ 8851631,       881u,11375193854275230591ull},
		{ 8852323,      3529u,13976988789038676439ull},{ 8879971,     55760u, 4065954677724111201ull},{ 8885839,    189157u,13972705208713530009ull},{ 8887667,     15650u, 3479161486544600081ull},{ 8891479,       281u, 3908734036550545881ull},
		{ 8892001,    399980u,  348160936584190151ull},{ 8895067,       659u,12293902350439178087ull},{ 8896403,    281473u, 4911135064261999521ull},{ 8907659,     28045u,14784606591196077103ull},{ 8910043,       821u, 5656531726894273265ull},
		{ 8914519,       949u, 4686244932662218297ull},{ 8925463,  34406392u, 6947221817440081257ull},{ 8928847,    280991u,18128549402387363145ull},{ 8941447,       170u, 7578823934664030161ull},{ 8942761,    285889u,12419432609440032345ull},
		{ 8943461,    268039u,15846513700731858799ull},{ 8947891,      1735u, 9265596559543333297ull},{ 8955143, 101273010u,12253893124535158577ull},{ 8980789,     22537u,13426157623604500687ull},{ 8982371,       101u,14022829103709041663ull},
		{ 9009229,     89356u,15359747832206463841ull},{ 9023117,      1296u, 9569964735123059105ull},{ 9331061,       203u, 1005489040573919343ull},{ 9360067,      7440u, 1016920852914327511ull},{11836397,        76u, 4753937900335225801ull},
		{12342461,      3185u, 1753345721477568209ull},{12682547,   4085607u,16926237622668427889ull},{12702857,     55435u,15473514712868330607ull},{12999053,   1235292u, 3762487385164613785ull},{14498369,    128237u,14526323552203604241ull},
		{15165389,       485u,  330179403340003319ull},{15190393,     13872u,11887173197900552719ull},{15267589,        74u,14963262145345516425ull},{15331573,     49730u, 4408178729149087001ull},{15421487,       921u, 8877756807240402497ull},
		{15626909,  11906539u, 4417661925555319825ull},{15729583,       186u,10717054419563574223ull},{15729827,1057892912u,14816318765732916257ull},{15829861,     19825u,15865309391356950409ull},{15904423,       110u, 4238645735120536409ull},
		{15983707,        48u, 4357300712211145471ull},{15991193,      3046u, 3680186924956910097ull},{15997109,       308u,15794942471928637713ull},{16051547,     11155u,15864453969212219103ull},{16129213,       392u, 3754198172882755785ull},
		{16131979,      6827u,10576842754565059055ull},{16172621,    191569u,  891829992192399319ull},{16204523,  18537874u,13853273991470839569ull},{16210483,        64u,11178113142365390047ull},{16218907,      3470u, 9365149503113345247ull},
		{16226809,      1100u, 7659583808777621319ull},{16296349,     74952u, 6789913543149950497ull},{16322297,       748u, 8822692284702673065ull},{16364057,       268u,10431176301742662465ull},{16377743,      3176u, 5972801908074189743ull},
		{16406363,     30172u,  253845389692387185ull},{16416161,     84184u, 8026903278674309185ull},{16444163,    123743u,13602749018509000529ull},{16445119, 199993173u, 2826719993506082993ull},{16462993,      1933u, 2246545941595562751ull},
		{16465439,    767792u, 7421856042576531887ull},{16468129,    672932u, 9193735353107684049ull},{16503173,      2024u, 9443492740464039183ull},{16521053,      4172u, 4215545972090492199ull},{16544719,   3532287u,15490834954328089129ull},
		{16608113,       993u,11973891496836029831ull},{16658221,    994392u, 9265003897988786177ull},{16662589,      5583u,10877104196614353761ull},{16669259,     37695u,14727883460246356457ull},{16685437,   9776194u, 6889969512162125377ull},
		{16723717,    212092u,14906504205635945761ull},{16727479,     14410u,18068882455710331257ull},{16785413,    129671u, 9903178178510980001ull},{16792663,      9703u,11105483931030878809ull},{16800587,     11130u,13650391737015148049ull},
		{16804847,   6500829u, 3533341371541809833ull},{16808453,      4936u, 7844623794952651617ull},{16809391,     29703u, 9869185788127161889ull},{16817747,   4387352u, 2015829708477243887ull},{16819343,    227351u,14577617651386377761ull},
		{16820549,  29259736u, 2579164402117877625ull},{16825007, 390682869u, 9671153211854428993ull},{16825889,      1645u, 5034090624360750817ull},{16826959,    394522u, 4262342457128545047ull},{16832939,   2283480u, 3499229584108421473ull},
		{16843219,1740637150u,16678575536200532911ull},{16843987,    892167u,11320504716025434577ull},{16861753,     27509u, 4966077503304358433ull},{16864429,   3472340u, 7383710753692858103ull},{16865557, 141107518u,12657461798830290009ull},
		{16872847,      7042u, 5664463976168682217ull},{16876267,    768500u, 2386605663683715839ull},{16877227,     26909u,16828458807433451793ull},{16878749,    347420u, 5530942263660718719ull},{16892789,     37499u,15689282913842113409ull},
		{16895803,   1532721u,18305119409047103975ull},{16897009,    317299u,   35208741571512609ull},{16900309,      2472u,13474962507039928007ull},{16910191,    170146u, 5170061300924029473ull},{16928419,      1489u, 5006545141137940057ull},
		{16930393,   9582022u,11727071280078615841ull},{16937773,      3510u, 9267789279716192833ull},{16938461,     77244u, 4261887363890383759ull},{16942561,    333713u,16416959992066943223ull},{16950361,      2580u,11177105512311418417ull},
		{16969409,     39842u,14393933843859339287ull},{16979441,    505755u,16434730466875831753ull},{16981427,     28066u, 9296044504676969833ull},{16983727,  94240809u,17752094683956384025ull},{16983983,     28059u,16091607843728445223ull},
		{16995779,      6661u, 7830143707771831545ull},{17025413,     10724u, 8148147940903146705ull},{17026687,     31859u, 6811989873351804369ull},{17034133,     20487u,17357576493083550241ull},{17039059,    122645u,11496188035198294967ull},
		{17048029,    285247u,13305518687973938281ull},{17056447,   2606122u,12574870762596486535ull},{17083237,   8461215u, 9905576412463209257ull},{17083777,     18430u,11428865434586521009ull},{17087557,     37215u,14875832505057766609ull},
		{17095889,   1323377u, 3717220050156882191ull},{17097389,1760731413u, 9843676629243088873ull},{17105299,     81371u, 1929162103058421135ull},{17109713,     51459u,17280464114564148169ull},{17110757,   2046067u, 8067475805035482625ull},
		{17112113,     52542u, 1517105784283888919ull},{17112191,     24884u,15515225620652684223ull},{17113253,      7250u,15583958528602828257ull},{17114791,     13155u,15934260513033726703ull},{17140177, 819404853u, 7737165812083468943ull},
		{17154157,   2917808u,14475130768968748289ull},{17168243,      1189u,14031023330502092233ull},{17174827,     20877u, 3116423579334084745ull},{17191459,    164012u,11124925933076103519ull},{17196229,    452235u,11155442872175691889ull},
		{17199473,     51825u, 6083166130595396831ull},{17213509,   1022179u,12911928712002520737ull},{17220101,   3214549u, 7363134224170851673ull},{17227849,    172183u,10847800035774997255ull},{17238307,  12542043u,15663835937396410441ull},
		{17251489,2144117919u,15480179807909042479ull},{17253517,  12309654u, 6025235993786279423ull},{17257879,    161418u, 1382566104163313935ull},{17260589, 115175336u,10283224490478819833ull},{17264011,   1744457u,  994697667365615745ull},
		{17268703,   2063251u, 9350765217636640455ull},{17269621,  13735949u,  673788709708729265ull},{17270191,    259556u,13644816076166641193ull},{17277367,    378545u,10258283237536366089ull},{17295857,    164529u,12996504031838402257ull},
		{17297321,    136045u, 3477326686230228009ull},{17300057,    485742u,10134593588474735065ull},{17309261,    131275u, 6030008496201936663ull},{17326747,   1611645u, 1921630189938798817ull},{17358763,   3232800u, 4928905537991785441ull},
		{17359063,  35383704u, 2015083763123199095ull},{17362099,     53690u, 9683541530822602193ull},{17385503,4046742644u,16856501793554568897ull},{17387893,  41374286u, 2560656520549446921ull},{17395817, 159852898u,16792033592198659863ull},
		{17427923,    188981u,  532633914835864385ull},{17433629,    695925u, 3505119555206483393ull},{17444443,    513163u, 5445979551755147943ull},{17450053,    157812u,18415231095804314545ull},{17456651,    551552u, 3880353390263834249ull},
		{17467139,    211059u,10062518427716833465ull},{17477639,    264827u, 6507519522524416335ull},{17503567,    319478u,15607288692565636353ull},{17506249,   7246235u,10929482532834898487ull},{17518877,   8867104u,11570050222122965689ull},
		{17527283, 136813947u, 3326024563062685825ull},{17536823,    440352u, 9878707771636535647ull},{17539007,   4354617u, 4406481822187523599ull},{17540879,    726756u, 1118113451897253593ull},{17555399,  35153812u, 4507443726068176209ull},
		{17566609,  21653383u, 7399444876854645393ull},{17569711, 479166769u,11868486932669699833ull},{17571031,    484527u, 7060215751726447079ull},{17616943,    114090u,14738812321054635817ull},{17622817,  13690398u, 4811636227715074249ull},
		{17647373,    103263u, 3189089353926248513ull},{17652469,   1244343u,  141431592584913433ull},{17675893,   4077389u,13651439017267265249ull},{17679919,   7872193u, 3894559783103852031ull},{17698939,     47810u, 7782021279990355767ull},
		{17711143,    640279u, 5303785660976639535ull},{17732801,   4103871u, 4583035766799531017ull},{17739133, 130747716u, 1947030475661309305ull},{17739583,     69157u,  539914343514113919ull},{17746877,   6306926u,13250449299753722625ull},
		{17783203,    128254u, 9322981120069197199ull},{17797207,    117994u, 6024425248459124193ull},{17807701,  16601701u, 2797681640543443633ull},{17814431,     59907u, 3165706124645613559ull},{17833331,    108749u,10677366860900144129ull},
		{17835473,    865553u, 8821789166368052975ull},{17841821,  16595068u, 2785009705636697065ull},{17858671,     83788u,11636762661956212849ull},{17860541,    127880u,11679412360494356457ull},{17871673, 899827073u, 4365981991822767335ull},
		{17883197, 171007919u,14112849719432819969ull},{17891383,  15314611u, 5494386947721296607ull},{17901223,  26483927u, 8759360566729963809ull},{17907917,   2699547u,15287649357901403887ull},{17920373,    117967u,14284930551950649009ull},
		{17941151,    135102u,13697963633382258847ull},{17953391,   4407462u, 3856268332031058257ull},{18015407,    823035u, 3863124271074440977ull},{18017383,   1360055u, 7566698478337249511ull},{18120731,    223471u, 3508167879733895305ull},
		{33227807,  14922325u, 2838567728392815481ull},{33233503,  12807462u, 3334091319432416681ull},{33241399,    166492u,12812515124938083865ull},{33250067,2182275258u, 8923029501170211169ull},{33251227,   6911594u,13590065507670693809ull},
		{33256609,   1818244u,  220871972264494263ull},{33259153,  38814254u,16386977130529408193ull},{33268253,  27991294u, 3898646068209270567ull},{33277301,    683360u, 4806541503703691279ull},{33280787,    282030u, 9924364295782824137ull},
		{33282257,     79056u, 8075902570930756103ull},{33284753,    111827u,15449457299209774881ull},{33286807,  81756638u, 2255231334031845305ull},{33290197,    189083u,14424443831930143785ull},{33291679,    367547u,18387530411978866559ull},
		{33299443,    776963u, 2636922682980779825ull},{33311869,    186338u, 1874415908399668103ull},{33337613,    323616u, 3695590210606875881ull},{33340963,     96949u,11960300797586306719ull},{33344947,    205119u,12785072524810844153ull},
		{33357251, 120482483u, 5734238336333966079ull},{33360631,    124712u, 6837598985057705985ull},{33364561,    247352u,17266053889495344551ull},{33369911,   6119593u, 2157811649735073519ull},{33379673,    500668u, 1793898280018450369ull},
		{33394931,    504443u,12345311626227159743ull},{33396289,    389902u,15587540931804441849ull},{33396457, 328283329u, 3027562459369760823ull},{33399761,    279642u, 9658553917939196047ull},{33406151,  57459294u,12082998895638046327ull},
		{33406621, 125212997u, 5566884921004692039ull},{33408533,    120922u,12235980571743216255ull},{33408943,   2787233u, 9527286207438248745ull},{33411487,   1062745u,12865415306884302993ull},{33422659,    403467u, 6257350676364808409ull},
		{33423319,     57634u,17459695061727397089ull},{2147483647,      13u, 2749942686469094193ull},{2147483647,    9650u,10298917214042272751ull},{19016461,3264525660u, 8603927029340062289ull},{5506720553412961ull,27539499u,13972472981534021599ull},
		{6821097032944489ull,609u,5722907802746151079ull},{1818493763727601ull,0u,901972906808890097ull},{0ull,0u,0ull},{0ull,0u,0ull},{0ull,0u,0ull}
	};

#endif	/* #ifndef fac_test_dat96_included */
