/* -*- Mode: C; indent-tabs-mode:nil; c-basic-offset: 8-*- */

/*
 *This file is part of MlView.
 *
 *MlView is free software; you can redistribute 
 *it and/or modify it under the terms of 
 *the GNU General Public License as published by the 
 *Free Software Foundation; either version 2, 
 *or (at your option) any later version.
 *
 *GNU MlView is distributed in the hope that it will 
 *be useful, but WITHOUT ANY WARRANTY; 
 *without even the implied warranty of 
 *MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *See the GNU General Public License for more details.
 *
 *You should have received a copy of the 
 *GNU General Public License along with MlView; 
 *see the file COPYING. 
 *If not, write to the Free Software Foundation, 
 *Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *See COPYRIGHT file for copyright information.
 */

#include "config.h"
#include <libgnome/libgnome.h>
#include <libxml/parser.h>
#include "mlview-app-context.h"

#ifndef __MLVIEW_UTILS_H__
#define __MLVIEW_UTILS_H__

G_BEGIN_DECLS

/**
 *@file
 *Misc usefull functions.
 *There are also some functions that could be small patches
 *gtk and libxml2.
 */
        enum MlViewStatus {
        MLVIEW_OK,
        MLVIEW_BAD_PARAM_ERROR,
        MLVIEW_NULL_FILE_NAME_ERROR,
        MLVIEW_BAD_FILE_ERROR,
        MLVIEW_EMPTY_FILE_ERROR,
        MLVIEW_NO_SPACE_LEFT_ERROR,
        MLVIEW_UNKNOWN_ENCODING_ERROR,
        MLVIEW_ENCODING_ERROR,
        MLVIEW_NO_ENCODINGS_ERROR,
        MLVIEW_ENCODING_NOT_SUPPORTED_ERROR,
        MLVIEW_CHAR_TOO_LONG_ERROR,
        MLVIEW_OUT_OF_MEMORY_ERROR,
        MLVIEW_NODE_NOT_FOUND_ERROR,
        MLVIEW_OUT_OF_BOUNDS_ERROR,
        MLVIEW_NO_LEFT_ANGLE_BRACKET_ERROR,
        MLVIEW_NO_RIGHT_ANGLE_BRACKET_ERROR,
        MLVIEW_NO_ROW_SELECTED_ERROR,
        MLVIEW_PARSING_ERROR,
        MLVIEW_BAD_URI_ERROR,
        MLVIEW_INTERNAL_SUBSET_ALREADY_EXISTS_ERROR,
        MLVIEW_ENTITY_NAME_EXISTS_ERROR,
        MLVIEW_BAD_NODE_PARENT,
        MLVIEW_EOF_ERROR,
        MLVIEW_IFACE_NOT_DEFINED_ERROR,
        MLVIEW_OBJECT_NOT_FOUND_ERROR,
        MLVIEW_OBJECT_CONTAINER_NOT_EMPTY,
        MLVIEW_PATH_TOO_DEEP_ERRROR,
        MLVIEW_NO_DOC_IN_VIEW_ERROR,
        MLVIEW_INT_SUBSET_ALREADY_PRESENT_ERROR,
        /*must be the last one */
        MLVIEW_ERROR
};

enum MlViewEncoding {
        UTF8,
        ISO8859_1,
        ASCII
};

struct NameValuePair {
        GString *name ;
        GString *value ;
} ;

/*
 *Some miscellaneous macros definitions.
 */

#  define MVLIEW_LOG_DOMAIN "MLVIEW"

#  ifdef __GNUC__

#    define mlview_utils_trace(a_log_level, a_msg) \
g_log (MVLIEW_LOG_DOMAIN, \
       G_LOG_LEVEL_CRITICAL, \
       "file %s: line %d (%s): %s\n", \
       __FILE__, \
       __LINE__, \
       __PRETTY_FUNCTION__, \
	a_msg)
#  else
      /*__GNUC__*/

#    define mlview_utils_trace(a_log_level, a_msg) \
g_log (MVLIEW_LOG_DOMAIN, \
       G_LOG_LEVEL_CRITICAL, \
       "file %s: line %d: %s\n", \
       __FILE__, \
       __LINE__, \
       a_msg)
#  endif

/**
 *Traces an info message.
 *The file, line and enclosing function
 *of the message will be automatically 
 *added to the message.
 *@param a_msg the msg to trace.
 */
#  define mlview_utils_trace_info(a_msg) \
mlview_utils_trace (G_LOG_LEVEL_INFO, a_msg)

/**
 *Trace a debug message.
 * The file, line and enclosing function
 *of the message will be automatically
 *added to the message.
 *@param a_msg the msg to trace.
 */
#  define mlview_utils_trace_debug(a_msg) \
mlview_utils_trace (G_LOG_LEVEL_DEBUG, a_msg) ;

int mlview_utils_load_xml_document (gchar * a_xmlfile,
                                    xmlParserCtxtPtr
                                    a_parser_context);

void mlview_utils_display_message_dialog (MlViewAppContext * a_ctxt,
                                          const guchar * a_msg_format,
                                          ...) ;

void mlview_utils_display_warning_dialog (MlViewAppContext * a_ctxt,
                                     const guchar * a_msg_format,
                                     ...) ;

void mlview_utils_display_error_dialog (MlViewAppContext * a_ctxt,
                                        const guchar * a_msg_format,
                                        ...);

gboolean mlview_utils_is_base_char (gint a_c)  ;

gboolean mlview_utils_is_combining (gint a_c) ;

gboolean mlview_utils_is_extender (gint a_c) ;

gboolean mlview_utils_is_ideographic (gint a_c) ;
gboolean mlview_utils_is_letter (gint a_c) ;
gboolean mlview_utils_is_name_char (gint a_c) ;
gboolean mlview_utils_is_digit (gint a_c) ;
gboolean mlview_utils_is_space (gint a_c) ;
gboolean mlview_utils_is_pubidchar (gint a_c) ;
enum MlViewStatus mlview_utils_skip_spaces (guchar *a_raw_str,
                                            guchar **a_skiped_to) ;
enum MlViewStatus mlview_utils_parse_element_name (guchar *row_str,
                                                   guchar **a_name_end) ;
enum MlViewStatus mlview_utils_parse_reference (guchar *a_raw_str,
                                                guchar **a_ref_end) ;
enum MlViewStatus mlview_utils_parse_attribute (guchar *a_raw_str,
                                                guchar **a_name_end,
                                                guchar **a_val_start,
                                                guchar **a_val_end)  ;
enum MlViewStatus mlview_utils_parse_comment (guchar *a_raw_str,
                                              GString **a_comment) ;
enum MlViewStatus mlview_utils_parse_pi (guchar *a_raw_pi,
                                         GString **a_pi_target,
                                         GString **a_pi_param) ;
enum MlViewStatus mlview_utils_parse_start_tag (guchar *a_raw_str,
                                                GString **a_name,
                                                GList **a_name_value_pair_list) ;

enum MlViewStatus mlview_utils_parse_cdata_section (const gchar *a_raw_str,
                                                    gchar **a_out_start,
                                                    gchar **a_out_end) ;
enum MlViewStatus
mlview_utils_parse_doctype_decl (guchar *a_instr,
                                 guchar **a_name_start,
                                 guchar **a_name_end,
                                 guchar **a_public_id_start,
                                 guchar **a_public_id_end,
                                 guchar **a_external_id_start,
                                 guchar **a_external_id_end) ;

enum MlViewStatus
mlview_utils_parse_external_id (guchar *a_instr,
                                guchar **a_public_id_start,
                                guchar **a_public_id_end,
                                guchar **a_system_id_start,
                                guchar **a_system_id_end,
                                guchar **a_end_ptr) ;

enum MlViewStatus mlview_utils_parse_entity_ref (guchar *a_instr,
                                                 guchar **a_name_start,
                                                 guchar **a_name_end) ;

enum MlViewStatus mlview_utils_parse_char_ref (guchar *a_instr,
                                               guchar **a_char_code_start,
                                               guchar **a_char_code_end,
                                               gboolean *a_is_hexa) ;

enum MlViewStatus mlview_utils_parse_pe_ref (guchar *a_instr,
                                             guchar **a_name_start,
                                             guchar **a_name_end) ;

enum MlViewStatus mlview_utils_parse_entity_value (guchar *a_instr,
                                                   guchar **a_value_start,
                                                   guchar **a_value_end) ;

enum MlViewStatus mlview_utils_parse_internal_general_entity (guchar *a_instr,
                                                              guchar **a_name_start,
                                                              guchar **a_name_end,
                                                              guchar **a_value_start,
                                                              guchar **a_value_end) ;

enum MlViewStatus mlview_utils_parse_external_general_parsed_entity (guchar *a_instr,
                                                                     guchar **a_name_start,
                                                                     guchar **a_name_end,
                                                                     guchar **a_public_id_start,
                                                                     guchar **a_public_id_end,
                                                                     guchar **a_system_id_start,
                                                                     guchar **a_system_id_end) ;

enum MlViewStatus mlview_utils_parse_external_general_unparsed_entity (guchar *a_instr,
                                                                       guchar **a_name_start,
                                                                       guchar **a_name_end,
                                                                       guchar **a_public_id_start,
                                                                       guchar **a_public_id_end,
                                                                       guchar **a_system_id_start,
                                                                       guchar **a_system_id_end,
                                                                       guchar **a_ndata_start,
                                                                       guchar **a_ndata_end) ;

enum MlViewStatus mlview_utils_parse_internal_parameter_entity (guchar *a_instr,
                                                                guchar **a_name_start,
                                                                guchar **a_name_end,
                                                                guchar **a_value_start,
                                                                guchar **a_value_end) ;

enum MlViewStatus mlview_utils_parse_external_parameter_entity (guchar *iptr,
                                                                guchar **a_name_start,
                                                                guchar **a_name_end,
                                                                guchar **a_public_id_start,
                                                                guchar **a_public_id_end,
                                                                guchar **a_system_id_start,
                                                                guchar **a_system_id_end) ;

enum MlViewStatus mlview_utils_mark_menu_object (GtkWidget *a_menu_object,
                                                 guchar *a_mark_string) ;


enum MlViewStatus mlview_utils_get_menu_object (GtkWidget *a_menu_root,
                                                guchar *a_path,
                                                GtkWidget **a_menu_object) ;

struct NameValuePair * mlview_utils_name_value_pair_new (GString *a_name,
                                                         GString *a_value) ;

void mlview_utils_name_value_pair_free (struct NameValuePair *a_this,
                                        gboolean a_free_strings) ;

void  mlview_utils_name_value_pair_list_free (GList *a_nv_pair_list,
                                              gboolean a_free_strings) ;

struct NameValuePair * mlview_utils_name_value_pair_list_lookup (GList *a_nv_pair_list ,
                                                                 const guchar *a_name) ;

gboolean mlview_utils_is_white_string (const guchar * a_str);

enum MlViewStatus mlview_utils_escape_predef_entities_in_str (guchar *a_instr,
                                                              guchar **a_outstr,
                                                              guint *a_outstrlen) ;

enum MlViewStatus mlview_utils_isolat1_str_len_as_utf8 (const guchar * a_str,
                                                        gint * a_result_len);

enum MlViewStatus mlview_utils_utf8_str_len_as_isolat1 (const guchar * a_utf8_str,
                                                        gint * a_len);

enum MlViewStatus mlview_utils_isolat1_str_to_utf8 (const guchar * a_input_str,
                                                    guchar ** a_output_str);

enum MlViewStatus mlview_utils_utf8_str_to_isolat1 (const guchar * a_in_str,
                                                    guchar ** a_out_str);
void mlview_utils_parse_full_name (xmlNode * a_node,
                                   const guchar * a_full_name,
                                   xmlNs ** a_ns,
                                   guchar ** a_local_name);

void mlview_utils_init_available_encodings_list (void);

void mlview_utils_ref_available_encodings (void);

void mlview_utils_unref_available_encodings (void);

GList *mlview_utils_get_available_encodings (void);

enum MlViewStatus mlview_utils_add_supported_encoding (const guchar * a_name);

enum MlViewStatus mlview_utils_del_supported_encoding (const guchar * a_name);

gboolean mlview_utils_is_encoding_supported (const guchar * a_encoding);

gboolean mlview_utils_str_equals_ignore_case (const guchar *a_str1,
                                              const guchar *a_str2) ;
gboolean mlview_utils_str_equals (const guchar *a_str1,
                                  const guchar *a_str2,
                                  gboolean a_ignore_case) ;
gboolean mlview_utils_strstr_ignore_case (const guchar *a_haystack,
                                          const guchar *a_needle) ;
gboolean mlview_utils_strstr (const guchar *a_haystack,
                              const guchar *a_needle,
                              gboolean a_ignore_case) ;

enum MlViewStatus mlview_utils_uri_is_relative (const gchar *a_uri,
                                                gboolean *a_is_relative) ;

gchar * mlview_utils_get_dir_name_from_uri (const gchar *a_uri) ;

enum MlViewStatus mlview_utils_relative_uri_to_absolute_uri (const gchar *a_relative_uri,
                                                             const gchar* a_base_uri,
                                                             gchar **a_absolute_uri) ;

xmlNs *xmlUnlinkNs (xmlNode * node, xmlNs * ns);

xmlNs *xmlUnlinkNsDef (xmlNode * node, xmlNs * ns);

int xmlValidGetValidElementsChildren (xmlNode * a_node,
                                      const xmlChar ** a_list,
                                      int a_max);

int xmlSetEntityNodeName (xmlDtd *aDtd, xmlEntity *anEntityNode,
                          xmlChar *aName) ;

gint gtk_clist_row_absolute_top_ypixel (GtkCList * a_clist,
                                        gint a_row);

gint gtk_ctree_node_absolute_top_ypixel (GtkCTree * a_tree,
                                         GtkCTreeNode * a_node);

gboolean mlview_utils_gtk_row_ref_2_iter (GtkTreeModel * a_model,
                                          GtkTreeRowReference * a_ref,
                                          GtkTreeIter * a_iter) ;

enum MlViewStatus mlview_utils_tree_path_string_to_iter (GtkTreeModel *a_model,
                                                         guchar *a_tree_path_str,
                                                         GtkTreeIter *a_iter);

enum MlViewStatus mlview_utils_gtk_tree_view_expand_row_to_depth (GtkTreeView *a_view,
                                                                  GtkTreePath *a_path,
                                                                  gint a_depth) ;

enum MlViewStatus mlview_utils_gtk_tree_view_expand_row_to_depth2 (GtkTreeView *a_view,
                                                                   GtkTreeIter *a_iter,
                                                                   gint a_depth) ;
gint gtk_clist_absolute_row_top_ypixel (GtkCList * a_clist, gint a_row);


void mlview_utils_init (void);

void mlview_utils_cleanup (void);


G_END_DECLS

#endif
