
# MMApatBass.py 

"""
	This module is an integeral part of the program 
	MMA - Musical Midi Accompaniment.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	Bob van der Poel <bvdp@uniserve.com>
	
"""
	


import MMAglobals;  gbl = MMAglobals
from MMAcommon import *
from MMAharmony import harmonize
from MMApat import PC


class Bass(PC):
	""" Pattern class for a bass track. """

	vtype = 'BASS'	
			
	def getPgroup(self, ev):
		""" Get group for bass pattern.
				
			Tuples:  [start, length, note, volume]
		
		"""
		
		a = struct()
		if len(ev) != 4:	
			error("There must be n groups of 4 in a pattern definition, "
				"not <%s>." % ' '.join(ev) )
		
		n=ev[2][:1]
		if n   == '1':  a.noteoffset=0
		elif n == '3':  a.noteoffset=1
		elif n == '5':  a.noteoffset=2	
		else:
			error("Note offset in Bass must be '1', '3' or '5', "
				"not '%s'" % n )
		
		a.addoctave = 0
		for n in ev[2][1:]:
			if n == '+':
				a.addoctave += 12
			elif n == '-':
				a.addoctave -= 12
			else:
				error("Only '-' or '+' is permitted after a noteoffset. "
					"not '%s'" % n)
		
		a.vol = stoi(ev[3], "Note volume in Bass definition not int.")
		
		a.duration = getNoteLen( ev[1] )

		a.offset = self.setBarOffset(ev[0])
					
		if a.noteoffset<0 or a.noteoffset>2:
			error("Chord offsets must be 0..2.")
		
		return a


	def trackBar(self, pattern, ctable):
		""" Do the bass bar.
		
		Called from self.bar()
		
		"""
		
		sc = self.seq
		unify = self.unify[sc]

		for p in pattern:
			ct = self.getChordInPos(p.offset, ctable)

			if ct.bassZ:
				continue
						
			if self.chordLimit:
				ct.chord.limit(self.limit)
				
			if self.compress[sc]:
				ct.chord.compress()
				if p.noteoffset >= ct.chord.len():
					continue
									
			if self.invert[sc]:
				ct.chord.invert(self.invert[sc])

			note = ct.chord.offsetNote(p.noteoffset) + p.addoctave

			v=self.adjustVolume(p.vol, p.offset)
			
			if not v:
				continue
			
		
			if not self.harmonyOnly[sc]:
				gbl.mtrks[self.channel].addPairToTrack(
					p.offset,
					self.rTime[sc],
					self.getDur(p.duration),
					self.adjustNote(note),
					v, unify )
			
			if self.duplicate[sc]:
				n = self.adjustNote(note) + self.duplicate[sc]
				if n>=0 and n<128:
					gbl.mtrks[self.channel].addPairToTrack(
						p.offset,
						self.rTime[sc],
						self.getDur(p.duration),
						n, 	v, unify )
						
			if self.harmony[sc]:
				h = harmonize(self.harmony[sc], note, ct.chord.notes())
				for n in h:
					gbl.mtrks[self.channel].addPairToTrack(
						p.offset,
						self.rTime[sc],
						self.getDur(p.duration),
						self.adjustNote(n), 
						self.adjustVolume(p.vol, -1),
						unify )
						
			ct.chord.reset()	# important!
	

