# MMAfile.py

import sys
import os
import MMAglobals;  gbl = MMAglobals
from MMAcommon import *

###########################
# File read class
###########################



class ReadFile:

	class FileData:
		""" After reading the file in bulk it is parsed and stored in this
			data structure. Blanks lines and comments are removed.
		
		"""
	
		def __init__(self, lnum, data, label):
			self.lnum=lnum
			self.data=data
			self.label=label
	

	def __init__(self, fname):
	
		self.fdata=fdata=[]
		self.lastline = None
		self.lineptr = None
		self.fname = None
		self.lineno=0				
		
		self.que = []	# que for pushed lines (mainly for REPEAT)
		self.qnums = []
		
		self.beginData = []		# Current data set by a BEGIN statement
		self.beginPoints = []	# since BEGINs can be nested, we need ptrs
								# for backing out of BEGINs


		if not os.path.exists(fname):
			if not fname.endswith(gbl.ext):
				fname += gbl.ext
		else:
			if not fname.endswith(gbl.ext) and os.path.exists(fname + gbl.ext) \
				and os.path.exists(fname):
					warning("Both files '%s' and '%s' are present. Processing '%s'." % \
						(fname, fname + gbl.ext, fname) )
					
		
		self.fname = fname
		
		try:
			inpath = open(fname, 'r')
		except:
			error("Unable to open '%s' for input" % fname)
			
		if gbl.debug or gbl.showFilenames:
			print "File '%s' opened." % fname
			
		# Read entire file. Do it line by line so we can strip off
		# line terminations and trailing blanks. This is needed for
		# out continuation line sensor to work (and it's platform independent)!
		
		lcount=0
		label=''
		labs=[]		# track label defs, error if duplicate in same file
		more=0
		l=''

		for a in inpath:
			lcount += 1

			# If the previous line was a cont-line, append.
			# otherwise, create a new line.
			
			if more:
				l+= a.strip()
			else:
				l=a.strip()
			
			# If line ends with a \ , set cont-line flag,
			# strip off the \ and loop for the next line.

			if l and l[-1] == '\\':
				more = 1
				l='\\'.join(l.split('\\')[:-1])
				continue

			else:
				more = 0

			# Strip comments
			
			l = l.strip().split('//')[0].split()			
			
			# Store line in data array
			
			if l:
				fdata.append( self.FileData(lcount, l, label))
				
				# Check for a label. Note, we don't check in empty lines :)
				
				if l[0].upper()=='LABEL':
					if len(l) !=2:
						error("Usage: LABEL <string>")
					label=l[1].upper()
					if label[0]=='$':
						error("Variables are not permitted as labels")
					if label in labs:
						error("Duplicate label specified in line %s." % lcount)
					labs.append(label)
				else:
					label=''
		
		inpath.close()

		self.lineptr = 0	
		self.lastline = len(fdata)	


	def toEof(self):
		""" Move pointer to End of File. """
		
		self.lineptr=self.lastline+1
		self.que = []
		self.qnums = []
		

	def goto(self, l):
		""" Do a goto jump.
		
			This isn't perfect, but is probably the way most GOTOs work. If
			inside a repeat/if then nothing more is processed. The jump is
			immediate. Of course, you'll run into problems with missing
			repeat/repeatend if you try it. Since all repeats are stacked
			back into the que, we just delete the que. Then we look for a
			matching label in the file line array.
			
			Label search is linear. Not too efficient, but the lists
			will probably never be that long either.
			
		"""
		
		if not l:
			error("No label specified")

		if self.que:
			self.que=[]
			
		fdata=self.fdata
		for p in range(self.lastline):
			if fdata[p].label==l:
				self.lineptr=p
				return
		
		error("Label '%s' has not be set." % l)
		
		
	def push(self, q, nums):
		""" Push a list of lines back into the input stream.
		
			Note: This is a list of semi-processed lines, no comments, etc.
		
			It's quicker to extend a list than to insert, so add to the end.
			Note: we reverse the original, extend() then reverse again, just
			in case the caller cares.
			
			nums is a list of linenumbers. Needed to report error lines.
		"""

		if not self.que:
			self.que = ['']
			self.qnums=[self.lineno]

		q.reverse()
		self.que.extend(q)
		q.reverse()

		nums.reverse()
		self.qnums.extend(nums)
		nums.reverse()
		
		
	def read(self):
		""" Return a line.
		
			This will return either a queued line or a line from the 
			file (which was stored/processed earlier).
		"""
		
		while 1:
				
			# Return a queued line if possible.
			
			if self.que:
				ln = self.que.pop(-1)

				self.lineno = self.qnums.pop()

				if not ln:
					continue

				return ln
		
			
			# Return the next line in the file.


			if self.lineptr>=self.lastline:
				if self.beginData:
					error("BEGIN active at EOF: %s" % ' '.join(self.beginData) )
					
				return None		####  EOF


			ln=self.fdata[self.lineptr].data
			self.lineno = self.fdata[self.lineptr].lnum
			self.lineptr +=1
			
			# Handle the BEGIN/END block stuff here
				
			if ln[0].upper() == 'BEGIN':
				ln = ln[1:]
				if not ln:
					error("Use: BEGIN STUFF.")

				self.beginPoints.append(len(self.beginData))
				self.beginData.extend(ln)
				continue

			if ln[0].upper()=='END':
				if len(ln) > 1:
					error("No arguments permitted for End")
					
				if not self.beginData:
					error("No 'Begin' for 'End'")
		
				self.beginData=self.beginData[:self.beginPoints.pop(-1)]
				continue

			if self.beginData:
				ln = self.beginData + ln


			
			return ln


