//  $Id: mmdb_mask.h,v 1.3 2004/01/28 17:22:33 keb Exp $
//  =================================================================
//
//   CCP4 Coordinate Library: support of coordinate-related
//   functionality in protein crystallography applications.
//
//   Copyright (C) Eugene Krissinel 2004.
//
//   This library is free software and is distributed under the terms
//   and conditions of the CCP4 licence agreement as `Part 0' (Annex 2)
//   software, which is version 2.1 of the GNU Lesser General Public
//   Licence (LGPL) with the following additional clause:
//
//      `You may also combine or link a "work that uses the Library"
//      to produce a work containing portions of the Library, and
//      distribute that work under terms of your choice, provided that
//      you give prominent notice with each copy of the work that the
//      specified version of the Library is used in it, and that you
//      include or provide public access to the complete corresponding
//      machine-readable source code for the Library including whatever
//      changes were used in the work. (i.e. If you make changes to the
//      Library you must distribute those, but you do not need to
//      distribute source or object code to those portions of the work
//      not covered by this licence.)'
//
//   Note that this clause grants an additional right and does not
//   impose any additional restriction, and so does not affect
//   compatibility with the GNU General Public Licence (GPL). If you
//   wish to negotiate other terms, please contact the maintainer.
//
//   You can redistribute it and/or modify the library under the terms
//   of the GNU Lesser General Public License as published by the Free
//   Software Foundation; either version 2.1 of the License, or (at
//   your option) any later version.
//
//   This library is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Lesser General Public License for more details.
//
//   You should have received a copy of the CCP4 licence and/or GNU
//   Lesser General Public License along with this library; if not,
//   write to the CCP4 Secretary, Daresbury Laboratory, Warrington
//   WA4 4AD, UK. The GNU Lesser General Public can also be obtained
//   by writing to the Free Software Foundation, Inc., 59 Temple Place,
//   Suite 330, Boston, MA 02111-1307 USA
//
//  =================================================================
//
//    17.11.00   <--  Date of Last Modification.
//                   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//  -----------------------------------------------------------------
//
//  **** Module  :   MMDBF_Mask <interface>
//       ~~~~~~~~~
//  **** Project :   MacroMolecular Data Base (MMDB)
//       ~~~~~~~~~
//
//  **** Classes :   CMask  ( atom selection mask )
//       ~~~~~~~~~
//
//  E. Krissinel 2000
//
//  =================================================================
//

#ifndef __MMDB_Mask__
#define __MMDB_Mask__


#ifndef __Stream__
#include "stream_.h"
#endif



//  ====================  CMask  ========================

DefineClass(CMask)
DefineStreamFunctions(CMask)

class CMask : public CStream  {

  public :

    CMask ();
    CMask ( RPCStream Object );
    ~CMask();

    void SetMaskBit ( int   BitNo );
    void NewMask    ( PPCMask Mask, int nMasks );

    void CopyMask   ( PCMask Mask );   //  this = Mask
    void SetMask    ( PCMask Mask );   //  this = this | Mask
    void RemoveMask ( PCMask Mask );   //  this = this & (~Mask)
    void SelMask    ( PCMask Mask );   //  this = this & Mask
    void XadMask    ( PCMask Mask );   //  this = this ^ Mask
    void ClearMask  ();                //  this = NULL
    void NegMask    ();                //  this = ~this

    Boolean CheckMask ( PCMask Mask ); //  True if the bit is on
    Boolean isMask    ();              // true if any mask bit is on

    pstr Print ( pstr S ); // returns binary string

    void write ( RCFile f );
    void read  ( RCFile f );

  protected :
    int     mlen;
    wvector m;

    void InitMask();
    void Expand  ( int n );

};


#endif

