//  $Id: mmdb_tables.h,v 1.9 2005/11/17 18:07:17 keb Exp $
//  =================================================================
//
//   CCP4 Coordinate Library: support of coordinate-related
//   functionality in protein crystallography applications.
//
//   Copyright (C) Eugene Krissinel 2004.
//
//   This library is free software and is distributed under the terms
//   and conditions of the CCP4 licence agreement as `Part 0' (Annex 2)
//   software, which is version 2.1 of the GNU Lesser General Public
//   Licence (LGPL) with the following additional clause:
//
//      `You may also combine or link a "work that uses the Library"
//      to produce a work containing portions of the Library, and
//      distribute that work under terms of your choice, provided that
//      you give prominent notice with each copy of the work that the
//      specified version of the Library is used in it, and that you
//      include or provide public access to the complete corresponding
//      machine-readable source code for the Library including whatever
//      changes were used in the work. (i.e. If you make changes to the
//      Library you must distribute those, but you do not need to
//      distribute source or object code to those portions of the work
//      not covered by this licence.)'
//
//   Note that this clause grants an additional right and does not
//   impose any additional restriction, and so does not affect
//   compatibility with the GNU General Public Licence (GPL). If you
//   wish to negotiate other terms, please contact the maintainer.
//
//   You can redistribute it and/or modify the library under the terms
//   of the GNU Lesser General Public License as published by the Free
//   Software Foundation; either version 2.1 of the License, or (at
//   your option) any later version.
//
//   This library is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Lesser General Public License for more details.
//
//   You should have received a copy of the CCP4 licence and/or GNU
//   Lesser General Public License along with this library; if not,
//   write to the CCP4 Secretary, Daresbury Laboratory, Warrington
//   WA4 4AD, UK. The GNU Lesser General Public can also be obtained
//   by writing to the Free Software Foundation, Inc., 59 Temple Place,
//   Suite 330, Boston, MA 02111-1307 USA
//
//  =================================================================
//
//    30.05.03   <--  Date of Last Modification.
//                   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//  -----------------------------------------------------------------
//
//  **** Module  :   MMDBF_Tables <interface>
//       ~~~~~~~~~
//  **** Project :   MacroMolecular Data Base (MMDB)
//       ~~~~~~~~~
//
//  **** Functions : 
//       ~~~~~~~~~~~ 
//
//  **** Constants : AName  ( array of 2-character atom names       )
//       ~~~~~~~~~~~ HAName ( array of 2=character heteroatom names )
//                   RName  ( 3-characters amino acid names         )
//                   RName1 ( 1-characters amino acid names         )
//
//
//  E. Krissinel  2001-2002
//
//  =================================================================
//


#ifndef __MMDB_Tables__
#define __MMDB_Tables__


#ifndef __MatType__
#include "mattype_.h"
#endif



//  =================================================================


#define nElementNames  117
#define nElementMetals 91
#define nHydAtomNames  14

extern pstr     const ElementName   [nElementNames];
extern pstr     const ElementMetal  [nElementMetals];
extern pstr     const HydAtomName   [nHydAtomNames];
extern realtype const MolecWeight   [nElementNames];
extern realtype const CovalentRadius[nElementNames];
extern realtype const VdWaalsRadius [nElementNames];
extern realtype const IonicRadius   [nElementNames];

extern Boolean isMetal ( const pstr element );

#define  ELEMENT_UNKNOWN    -1

extern int      getElementNo      ( const pstr element );
extern realtype getMolecWeight    ( const pstr element );
extern realtype getCovalentRadius ( const pstr element );
extern realtype getVdWaalsRadius  ( const pstr element );

#define nResNames  26

extern pstr const ResidueName [nResNames];
extern char const ResidueName1[nResNames];

extern int getResidueNo ( pstr resName );

#define nSolventNames     12
#define nAminoacidNames   23
#define nNucleotideNames  16


DefineStructure(SAAProperty)

struct SAAProperty  {
  char     name[4];
  realtype hydropathy;
  realtype charge;
  realtype relSolvEnergy;
};

extern SAAProperty const AAProperty[nAminoacidNames];

extern realtype GetAAHydropathy ( const pstr resName );  // -4.5...+4.5
extern realtype GetAACharge     ( const pstr resName );
extern realtype GetAASolvationEnergy ( const pstr resName );
extern int      GetAASimilarity ( const pstr resName1,
                                  const pstr resName2 );  // 0..5

extern pstr const StdSolventName[nSolventNames];
//extern pstr const AminoacidName [nAminoacidNames];
extern pstr const NucleotideName[nNucleotideNames];

extern Boolean isSolvent    ( const pstr resName );
extern Boolean isAminoacid  ( const pstr resName );
extern Boolean isNucleotide ( const pstr resName );
extern Boolean isSugar      ( const pstr resName );

extern void  Get1LetterCode ( const pstr res3name, pstr res1code );


#endif

