//  $Id: mmdb_uddata.cpp,v 1.6 2004/05/17 16:38:13 keb Exp $
//  =================================================================
//
//   CCP4 Coordinate Library: support of coordinate-related
//   functionality in protein crystallography applications.
//
//   Copyright (C) Eugene Krissinel 2004.
//
//   This library is free software and is distributed under the terms
//   and conditions of the CCP4 licence agreement as `Part 0' (Annex 2)
//   software, which is version 2.1 of the GNU Lesser General Public
//   Licence (LGPL) with the following additional clause:
//
//      `You may also combine or link a "work that uses the Library"
//      to produce a work containing portions of the Library, and
//      distribute that work under terms of your choice, provided that
//      you give prominent notice with each copy of the work that the
//      specified version of the Library is used in it, and that you
//      include or provide public access to the complete corresponding
//      machine-readable source code for the Library including whatever
//      changes were used in the work. (i.e. If you make changes to the
//      Library you must distribute those, but you do not need to
//      distribute source or object code to those portions of the work
//      not covered by this licence.)'
//
//   Note that this clause grants an additional right and does not
//   impose any additional restriction, and so does not affect
//   compatibility with the GNU General Public Licence (GPL). If you
//   wish to negotiate other terms, please contact the maintainer.
//
//   You can redistribute it and/or modify the library under the terms
//   of the GNU Lesser General Public License as published by the Free
//   Software Foundation; either version 2.1 of the License, or (at
//   your option) any later version.
//
//   This library is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Lesser General Public License for more details.
//
//   You should have received a copy of the CCP4 licence and/or GNU
//   Lesser General Public License along with this library; if not,
//   write to the CCP4 Secretary, Daresbury Laboratory, Warrington
//   WA4 4AD, UK. The GNU Lesser General Public can also be obtained
//   by writing to the Free Software Foundation, Inc., 59 Temple Place,
//   Suite 330, Boston, MA 02111-1307 USA
//
//  =================================================================
//
//    24.04.03   <--  Date of Last Modification.
//                   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//  -----------------------------------------------------------------
//
//  **** Module  :   MMDBF_UDData <implementation>
//       ~~~~~~~~~
//  **** Project :   MacroMolecular Data Base (MMDB)
//       ~~~~~~~~~
//
//  **** Classes :   CUDData ( user-defined data )
//       ~~~~~~~~~
//
//  E. Krissinel 2000-2003
//
//  =================================================================
//

#ifndef __STRING_H
#include <string.h>
#endif


#ifndef __MMDB_UDData__
#include "mmdb_uddata.h"
#endif


//  ========================  CUDRegister  ==========================

#define  nUDRTypes  5

CUDRegister::CUDRegister() : CStream()  {
  InitUDRegister();
}

CUDRegister::CUDRegister ( RPCStream Object ) : CStream(Object)  {
  InitUDRegister();
}

CUDRegister::~CUDRegister()  {
  FreeUDRegister();
}

void  CUDRegister::InitUDRegister()  {
int i;
  for (i=0;i<nUDRTypes;i++)  {
    nIUDR[i]       = 0;
    nRUDR[i]       = 0;
    nSUDR[i]       = 0;
    IUDRegister[i] = NULL;
    RUDRegister[i] = NULL;
    SUDRegister[i] = NULL;
  }
}

void  CUDRegister::FreeUDRegister()  {
int i,j;

  for (j=0;j<nUDRTypes;j++)  {

    if (IUDRegister[j])  {
      for (i=0;i<nIUDR[j];i++)
        if (IUDRegister[j][i])  delete[] IUDRegister[j][i];
      delete[] IUDRegister[j];
      IUDRegister[j] = NULL;
    }
    nIUDR[j] = 0;

    if (RUDRegister[j])  {
      for (i=0;i<nRUDR[j];i++)
        if (RUDRegister[j][i])  delete[] RUDRegister[j][i];
      delete[] RUDRegister[j];
      RUDRegister[j] = NULL;
    }
    nRUDR[j] = 0;
    if (SUDRegister[j])  {
      for (i=0;i<nRUDR[j];i++)
        if (SUDRegister[j][i])  delete[] SUDRegister[j][i];
      delete[] SUDRegister[j];
      SUDRegister[j] = NULL;
    }
    nSUDR[j] = 0;

  }

}

int CUDRegister::RegisterUDData ( psvector & UDRegister,
                                  int      & nUDR,
                                  const pstr UDDataID )  {
psvector UDReg;
int      i,UDDhandle,n;

  n         = -1;
  UDDhandle = 0;
  for (i=0;(i<nUDR) && (!UDDhandle);i++)
    if (UDRegister[i])  {
      if (!strcmp(UDDataID,UDRegister[i]))
        UDDhandle = i+1;
    } else
      n = i;

  if (!UDDhandle)  {
    if (n<0)  {
      UDReg = new pstr[nUDR+1];
      for (i=0;i<nUDR;i++)
        UDReg[i] = UDRegister[i];
      UDReg[nUDR] = NULL;
      if (UDRegister)  delete[] UDRegister;
      UDRegister = UDReg;
      n = nUDR;
      nUDR++;
    }
    CreateCopy ( UDRegister[n],UDDataID );
    UDDhandle = n+1;
  }

  return UDDhandle;

}

static int UDRegisterFlag[nUDRTypes] = {
  UDRF_ATOM,
  UDRF_RESIDUE,
  UDRF_CHAIN,
  UDRF_MODEL,
  UDRF_HIERARCHY
};


int  CUDRegister::RegisterUDInteger ( int udr_type,
                                      const pstr UDDataID )  {
  if ((udr_type>=0) && (udr_type<nUDRTypes))
    return RegisterUDData ( IUDRegister[udr_type],
                            nIUDR[udr_type],UDDataID ) |
           UDRegisterFlag[udr_type];
  else
    return UDDATA_WrongUDRType;
}

int  CUDRegister::RegisterUDReal ( int udr_type,
                                   const pstr UDDataID )  {
  if ((udr_type>=0) && (udr_type<nUDRTypes))
    return RegisterUDData ( RUDRegister[udr_type],
                            nRUDR[udr_type],UDDataID ) |
           UDRegisterFlag[udr_type];
  else
    return UDDATA_WrongUDRType;
}

int  CUDRegister::RegisterUDString ( int udr_type,
                                     const pstr UDDataID )  {
  if ((udr_type>=0) && (udr_type<nUDRTypes))
    return RegisterUDData ( SUDRegister[udr_type],
                            nSUDR[udr_type],UDDataID ) |
           UDRegisterFlag[udr_type];
  else
    return UDDATA_WrongUDRType;
}

int  CUDRegister::GetUDDHandle ( int udr_type,
                                 const pstr UDDataID )  {
int  i,UDDhandle;

  if ((udr_type>=0) && (udr_type<nUDRTypes))  {

    UDDhandle = 0;

    for (i=0;(i<nIUDR[udr_type]) && (!UDDhandle);i++)
      if (IUDRegister[udr_type][i])  {
        if (!strcmp(UDDataID,IUDRegister[udr_type][i]))
          UDDhandle = i+1;
      }
    for (i=0;(i<nRUDR[udr_type]) && (!UDDhandle);i++)
      if (RUDRegister[udr_type][i])  {
        if (!strcmp(UDDataID,RUDRegister[udr_type][i]))
          UDDhandle = i+1;
      }
    for (i=0;(i<nSUDR[udr_type]) && (!UDDhandle);i++)
      if (SUDRegister[udr_type][i])  {
        if (!strcmp(UDDataID,SUDRegister[udr_type][i]))
          UDDhandle = i+1;
      }

    if (UDDhandle)  return UDDhandle | UDRegisterFlag[udr_type];
              else  return UDDhandle;

  } else
    return UDDATA_WrongUDRType;

}


void  CUDRegister::write ( RCFile f )  {
int  i,j;
byte Version=1;
  f.WriteByte ( &Version );
  for (j=0;j<nUDRTypes;j++)  {
    f.WriteInt ( &nIUDR[j] );
    for (i=0;i<nIUDR[j];i++)
      f.CreateWrite ( IUDRegister[j][i] );
    f.WriteInt ( &nRUDR[j] );
    for (i=0;i<nRUDR[j];i++)
      f.CreateWrite ( RUDRegister[j][i] );
    f.WriteInt ( &nSUDR[j] );
    for (i=0;i<nSUDR[j];i++)
      f.CreateWrite ( SUDRegister[j][i] );
  }
}

void  CUDRegister::read ( RCFile f )  {
int  i,j;
byte Version;
  f.ReadByte ( &Version );
  FreeUDRegister();
  for (j=0;j<nUDRTypes;j++)  {
    f.ReadInt ( &nIUDR[j] );
    if (nIUDR[j]>0)  {
      IUDRegister[j] = new pstr[nIUDR[j]];
      for (i=0;i<nIUDR[j];i++)  {
        IUDRegister[j][i] = NULL;
        f.CreateRead ( IUDRegister[j][i] );
      }
    }
    f.ReadInt ( &nRUDR[j] );
    if (nRUDR[j]>0)  {
      RUDRegister[j] = new pstr[nRUDR[j]];
      for (i=0;i<nRUDR[j];i++)  {
        RUDRegister[j][i] = NULL;
        f.CreateRead ( RUDRegister[j][i] );
      }
    }
    f.ReadInt ( &nSUDR[j] );
    if (nSUDR[j]>0)  {
      SUDRegister[j] = new pstr[nSUDR[j]];
      for (i=0;i<nSUDR[j];i++)  {
        SUDRegister[j][i] = NULL;
        f.CreateRead ( SUDRegister[j][i] );
      }
    }
  }
}


MakeStreamFunctions(CUDRegister)



//  ==========================  CUDData  ============================

CUDData::CUDData() : CMask()  {
  InitUDData();
}

CUDData::CUDData ( RPCStream Object ) : CMask(Object)  {
  InitUDData();
}

CUDData::~CUDData()  {
  FreeUDDMemory();
}

void CUDData::InitUDData()  {
  IUData = NULL;
  RUData = NULL;
  SUData = NULL;
}

void CUDData::FreeUDDMemory()  {
int i,l;
  FreeVectorMemory ( IUData,0 );
  FreeVectorMemory ( RUData,0 );
  if (SUData)  {
    l = getNofSUData();
    for (i=0;i<=l;i++)
      if (SUData[i])  delete[] SUData[i];
    delete[] SUData;
  }
  IUData = NULL;
  RUData = NULL;
  SUData = NULL;
}

int  CUDData::getNofIUData()  {
  if (!IUData)  return 0;
  return IUData[0];
}

int  CUDData::getNofRUData()  {
  if (!RUData)  return 0;
  return mround(RUData[0]);
}

int  CUDData::getNofSUData()  {
  if (!SUData)    return 0;
  if (!SUData[0]) return 0;
  return (int(SUData[0][0]) << 24) +
         (int(SUData[0][1]) << 16) +
         (int(SUData[0][2]) << 8)  +
          int(SUData[0][3]);
}

void CUDData::setNofSUData ( int newN )  {
  if (!SUData)    return;
  if (!SUData[0]) return;
  SUData[0][3] = byte( newN & 0x000000FF);
  SUData[0][2] = byte((newN & 0x0000FF00) >> 8);
  SUData[0][1] = byte((newN & 0x00FF0000) >> 16);
  SUData[0][0] = byte((newN & 0xFF000000) >> 24);
}


int  CUDData::putUDData ( int UDDhandle, int iudd )  {
ivector IUD;
int     i,l,udh;
  udh = UDDhandle & UDRF_MASK;
  if (udh<1)  return UDDATA_WrongHandle;
  l = getNofIUData();
  if (udh>l)  {
    GetVectorMemory ( IUD,udh+1,0 );
    IUD[0] = udh;
    for (i=1;i<=l;i++)
      IUD[i] = IUData[i];
    for (i=l+1;i<udh;i++)
      IUD[i] = MinInt4;
    FreeVectorMemory ( IUData,0 );
    IUData = IUD;
  }
  IUData[udh] = iudd;
  return UDDATA_Ok;
}

int  CUDData::putUDData ( int UDDhandle, realtype rudd )  {
rvector RUD;
int     i,l,udh;
  udh = UDDhandle & UDRF_MASK;
  if (udh<1)  return UDDATA_WrongHandle;
  l = getNofRUData();
  if (udh>l)  {
    GetVectorMemory ( RUD,udh+1,0 );
    RUD[0] = udh;
    for (i=1;i<=l;i++)
      RUD[i] = RUData[i];
    for (i=l+1;i<udh;i++)
      RUD[i] = -MaxReal;
    FreeVectorMemory ( RUData,0 );
    RUData = RUD;
  }
  RUData[udh] = rudd;
  return UDDATA_Ok;
}

int  CUDData::putUDData ( int UDDhandle, const pstr sudd )  {
psvector SUD;
int      i,l,udh;
  udh = UDDhandle & UDRF_MASK;
  if (udh<1)  return UDDATA_WrongHandle;
  l = getNofSUData();
  if (udh>l)  {
    if (l>0)  {
      GetVectorMemory ( SUD,udh+1,0 );
      for (i=0;i<=l;i++)
        SUD[i] = SUData[i];
      for (i=l+1;i<=udh;i++)
        SUD[i] = NULL;
      FreeVectorMemory ( SUData,0 );
      SUData = SUD;
    } else  {
      GetVectorMemory ( SUData,udh+1,0 );
      SUData[0] = new char[4];
      for (i=1;i<=udh;i++)
        SUData[i] = NULL;
    }
    setNofSUData ( udh );
  }
  CreateCopy ( SUData[udh],sudd );
  return UDDATA_Ok;
}

int  CUDData::getUDData ( int UDDhandle, int & iudd )  {
int l,udh;
  iudd = 0;
  udh  = UDDhandle & UDRF_MASK;
  if (udh<1)  return UDDATA_WrongHandle;
  l = getNofIUData();
  if (udh>l)  return UDDATA_NoData;
  iudd = IUData[udh];
  if (iudd==MinInt4)  return UDDATA_NoData;
  return UDDATA_Ok;
}

int  CUDData::getUDData ( int UDDhandle, realtype & rudd )  {
int l,udh;
  rudd = 0.0;
  udh = UDDhandle & UDRF_MASK;
  if (udh<1)  return UDDATA_WrongHandle;
  l = getNofRUData();
  if (udh>l)  return UDDATA_NoData;
  rudd = RUData[udh];
  if (rudd==-MaxReal)  return UDDATA_NoData;
  return UDDATA_Ok;
}

int  CUDData::getUDData ( int UDDhandle, pstr sudd, int maxLen )  {
int l,udh;
  sudd[0] = char(0);
  udh = UDDhandle & UDRF_MASK;
  if (udh<1)  return UDDATA_WrongHandle;
  l = getNofSUData();
  if (udh>l)  return UDDATA_NoData;
  if (!SUData[udh])  return UDDATA_NoData;
  strcpy_n0 ( sudd,SUData[udh],maxLen-1 );
  return UDDATA_Ok;
}

pstr  CUDData::getUDData ( int UDDhandle, int * retcode )  {
int l,udh;
  udh = UDDhandle & UDRF_MASK;
  if (udh<1)  {
    if (retcode)  *retcode = UDDATA_WrongHandle;
    return NULL;
  }
  l = getNofSUData();
  if (udh>l)  {
    if (retcode)  *retcode = UDDATA_NoData;
    return NULL;
  }
  if (!SUData[udh])  {
    if (retcode)  *retcode = UDDATA_NoData;
    return NULL;
  }
  if (retcode)  *retcode = UDDATA_Ok;
  return SUData[udh];
}

int  CUDData::getUDData ( int UDDhandle, pstr & sudd )  {
int l,udh;
  udh = UDDhandle & UDRF_MASK;
  if (udh<1)  {
    if (sudd)  {
      delete[] sudd;   
      sudd = NULL;
    }
    return UDDATA_WrongHandle;
  }
  l = getNofSUData();
  if (udh>l)  {
    if (sudd)  {
      delete[] sudd;   
      sudd = NULL;
    }
    return UDDATA_NoData;
  }
  if (!SUData[udh])  {
    if (sudd)  {
      delete[] sudd;   
      sudd = NULL;
    }
    return UDDATA_NoData;
  }
  CreateCopy ( sudd,SUData[udh] );
  return UDDATA_Ok;
}
    

void  CUDData::write ( RCFile f )  {
int  i,l;
byte Version=1;

  f.WriteByte ( &Version );

  CMask::write ( f );

  if (IUData)  l = IUData[0];
         else  l = -1;
  f.WriteVector ( IUData,l+1,0 );
  if (RUData)  l = mround(RUData[0]);
         else  l = -1;
  f.WriteVector ( RUData,l+1,0 );
  l = getNofSUData();
  f.WriteInt ( &l );
  for (i=1;i<=l;i++)
    f.CreateWrite ( SUData[i] );
}

void  CUDData::read  ( RCFile f )  {
int  i,l;
byte Version;

  f.ReadByte ( &Version );

  FreeUDDMemory();

  CMask::read ( f );

  f.CreateReadVector ( IUData,0 );
  f.CreateReadVector ( RUData,0 );
  f.ReadInt ( &l );
  if (l>0)  {
    SUData = new pstr[l+1];
    SUData[0] = new char[4];
    setNofSUData ( l );
    for (i=1;i<=l;i++)  {
      SUData[i] = NULL;
      f.CreateRead ( SUData[i] );
    }
  }
}


MakeStreamFunctions(CUDData)


